/* exporter.c generated by valac 0.56.1, the Vala compiler
 * generated from exporter.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Stef Walter <stefw@collabora.co.uk>
 */

#include "seahorse-common.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseExporterExportToFileData SeahorseExporterExportToFileData;

struct _SeahorseExporterExportToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseExporter* self;
	GFile* file;
	gboolean overwrite;
	GCancellable* cancellable;
	gboolean result;
	guint8* bytes;
	gint bytes_length1;
	gint _bytes_size_;
	GFile* outfile;
	GFile* _tmp0_;
	guint8* _tmp1_;
	size_t _tmp2_;
	guint8* _tmp3_;
	gint _tmp1__length1;
	gint __tmp1__size_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint unique;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	GError* err;
	GError* _tmp8_;
	GFile* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_;
};

static GFile* seahorse_exporter_file_increment_unique (GFile* file,
                                                guint* state);
static void seahorse_exporter_export_to_file_data_free (gpointer _data);
static gboolean seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_);
static void seahorse_exporter_export_to_file_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static GType seahorse_exporter_get_type_once (void);

 G_GNUC_NO_INLINE static GType
seahorse_exporter_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_EXPORTER_TYPE_ANY, "SEAHORSE_EXPORTER_TYPE_ANY", "any"}, {SEAHORSE_EXPORTER_TYPE_TEXTUAL, "SEAHORSE_EXPORTER_TYPE_TEXTUAL", "textual"}, {0, NULL, NULL}};
	GType seahorse_exporter_type_type_id;
	seahorse_exporter_type_type_id = g_enum_register_static ("SeahorseExporterType", values);
	return seahorse_exporter_type_type_id;
}

GType
seahorse_exporter_type_get_type (void)
{
	static volatile gsize seahorse_exporter_type_type_id__once = 0;
	if (g_once_init_enter (&seahorse_exporter_type_type_id__once)) {
		GType seahorse_exporter_type_type_id;
		seahorse_exporter_type_type_id = seahorse_exporter_type_get_type_once ();
		g_once_init_leave (&seahorse_exporter_type_type_id__once, seahorse_exporter_type_type_id);
	}
	return seahorse_exporter_type_type_id__once;
}

GList*
seahorse_exporter_get_objects (SeahorseExporter* self)
{
	SeahorseExporterIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->get_objects) {
		return _iface_->get_objects (self);
	}
	return NULL;
}

gboolean
seahorse_exporter_add_object (SeahorseExporter* self,
                              GObject* obj)
{
	SeahorseExporterIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->add_object) {
		return _iface_->add_object (self, obj);
	}
	return FALSE;
}

void
seahorse_exporter_export (SeahorseExporter* self,
                          GCancellable* cancellable,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	SeahorseExporterIface* _iface_;
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->export) {
		_iface_->export (self, cancellable, _callback_, _user_data_);
	}
}

guint8*
seahorse_exporter_export_finish (SeahorseExporter* self,
                                 GAsyncResult* _res_,
                                 size_t* result_length1,
                                 GError** error)
{
	SeahorseExporterIface* _iface_;
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->export_finish) {
		return _iface_->export_finish (self, _res_, result_length1, error);
	}
	return NULL;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GFile*
seahorse_exporter_file_increment_unique (GFile* file,
                                         guint* state)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	gint last = 0;
	const gchar* _tmp1_;
	gchar* prefix = NULL;
	gchar* suffix = NULL;
	gint index = 0;
	const gchar* _tmp2_;
	guint _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	last = string_last_index_of_char (_tmp1_, (gunichar) '/', 0);
	if (last == -1) {
		last = 0;
	}
	_tmp2_ = uri;
	index = string_last_index_of_char (_tmp2_, (gunichar) '.', last);
	if (index == -1) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = uri;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (prefix);
		prefix = _tmp4_;
		_tmp5_ = g_strdup ("");
		_g_free0 (suffix);
		suffix = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = uri;
		_tmp7_ = string_substring (_tmp6_, (glong) 0, (glong) index);
		_g_free0 (prefix);
		prefix = _tmp7_;
		_tmp8_ = uri;
		_tmp9_ = string_substring (_tmp8_, (glong) index, (glong) -1);
		_g_free0 (suffix);
		suffix = _tmp9_;
	}
	_tmp10_ = *state;
	*state = _tmp10_ + 1;
	_tmp11_ = prefix;
	_tmp12_ = suffix;
	_tmp13_ = g_strdup_printf ("%s-%u%s", _tmp11_, *state, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_new_for_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	result = _tmp16_;
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (uri);
	return result;
}

static void
seahorse_exporter_export_to_file_data_free (gpointer _data)
{
	SeahorseExporterExportToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseExporterExportToFileData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_exporter_export_to_file (SeahorseExporter* self,
                                  GFile* file,
                                  gboolean overwrite,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SeahorseExporterExportToFileData* _data_;
	SeahorseExporter* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (SeahorseExporterExportToFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_exporter_export_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_data_->overwrite = overwrite;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_exporter_export_to_file_co (_data_);
}

gboolean
seahorse_exporter_export_to_file_finish (SeahorseExporter* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gboolean result;
	SeahorseExporterExportToFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_exporter_export_to_file_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SeahorseExporterExportToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_exporter_export_to_file_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
seahorse_exporter_export_to_file_co (SeahorseExporterExportToFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->bytes_length1 = 0;
	_data_->_bytes_size_ = 0;
	_data_->_tmp0_ = _g_object_ref0 (_data_->file);
	_data_->outfile = _data_->_tmp0_;
	_data_->_tmp2_ = 0;
	_data_->_state_ = 1;
	seahorse_exporter_export (_data_->self, _data_->cancellable, seahorse_exporter_export_to_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = seahorse_exporter_export_finish (_data_->self, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp3_;
	_data_->_tmp1__length1 = _data_->_tmp2_;
	_data_->__tmp1__size_ = _data_->_tmp1__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->outfile);
		_data_->bytes = (g_free (_data_->bytes), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp4__length1 = _data_->_tmp1__length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1__length1 = 0;
	_data_->bytes = (g_free (_data_->bytes), NULL);
	_data_->bytes = _data_->_tmp4_;
	_data_->bytes_length1 = _data_->_tmp4__length1;
	_data_->_bytes_size_ = _data_->bytes_length1;
	while (TRUE) {
		_data_->unique = (guint) 0;
		{
			if (_data_->overwrite) {
				_data_->_tmp5_ = NULL;
			} else {
				_data_->_tmp5_ = "invalid etag";
			}
			_data_->_tmp6_ = _data_->outfile;
			_data_->_tmp7_ = _data_->bytes;
			_data_->_tmp7__length1 = _data_->bytes_length1;
			_data_->_state_ = 2;
			g_file_replace_contents_async (_data_->_tmp6_, _data_->_tmp7_, (gsize) _data_->_tmp7__length1, _data_->_tmp5_, FALSE, G_FILE_CREATE_PRIVATE, _data_->cancellable, seahorse_exporter_export_to_file_ready, _data_);
			return FALSE;
			_state_2:
			g_file_replace_contents_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				goto __finally0;
			}
			_data_->result = TRUE;
			_data_->_tmp1_ = (g_free (_data_->_tmp1_), NULL);
			_g_object_unref0 (_data_->outfile);
			_data_->bytes = (g_free (_data_->bytes), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp8_ = _data_->err;
			if (g_error_matches (_data_->_tmp8_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
				_data_->_tmp9_ = seahorse_exporter_file_increment_unique (_data_->file, &_data_->unique);
				_g_object_unref0 (_data_->outfile);
				_data_->outfile = _data_->_tmp9_;
				_g_error_free0 (_data_->err);
				continue;
			}
			_data_->_tmp10_ = _data_->err;
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
			_data_->_inner_error0_ = _data_->_tmp11_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		__finally0:
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->_tmp1_ = (g_free (_data_->_tmp1_), NULL);
		_g_object_unref0 (_data_->outfile);
		_data_->bytes = (g_free (_data_->bytes), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

gchar*
seahorse_exporter_get_filename (SeahorseExporter* self)
{
	SeahorseExporterIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->get_filename) {
		return _iface_->get_filename (self);
	}
	return NULL;
}

const gchar*
seahorse_exporter_get_content_type (SeahorseExporter* self)
{
	SeahorseExporterIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->get_content_type) {
		return _iface_->get_content_type (self);
	}
	return NULL;
}

GtkFileFilter*
seahorse_exporter_get_file_filter (SeahorseExporter* self)
{
	SeahorseExporterIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_EXPORTER_GET_INTERFACE (self);
	if (_iface_->get_file_filter) {
		return _iface_->get_file_filter (self);
	}
	return NULL;
}

static void
seahorse_exporter_default_init (SeahorseExporterIface * iface,
                                gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("content-type", "content-type", "content-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_object ("file-filter", "file-filter", "file-filter", gtk_file_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

 G_GNUC_NO_INLINE static GType
seahorse_exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseExporterIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_exporter_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType seahorse_exporter_type_id;
	seahorse_exporter_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorseExporter", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (seahorse_exporter_type_id, G_TYPE_OBJECT);
	return seahorse_exporter_type_id;
}

GType
seahorse_exporter_get_type (void)
{
	static volatile gsize seahorse_exporter_type_id__once = 0;
	if (g_once_init_enter (&seahorse_exporter_type_id__once)) {
		GType seahorse_exporter_type_id;
		seahorse_exporter_type_id = seahorse_exporter_get_type_once ();
		g_once_init_leave (&seahorse_exporter_type_id__once, seahorse_exporter_type_id);
	}
	return seahorse_exporter_type_id__once;
}

