/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.component;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.tools.api.ToolController;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.component.ActionsToolbar;
import org.gephi.visualization.component.CollapsePanel;
import org.gephi.visualization.component.SelectionToolbar;
import org.gephi.visualization.component.VizBarController;
import org.gephi.visualization.opengl.AbstractEngine;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="GraphTopComponent", persistenceType=0)
public class GraphTopComponent
extends TopComponent
implements AWTEventListener {
    private transient AbstractEngine engine;
    private transient VizBarController vizBarController;
    private transient GraphDrawable drawable;
    private SelectionToolbar selectionToolbar;
    private ActionsToolbar actionsToolbar;
    private JComponent toolbar;
    private JComponent propertiesBar;
    private CollapsePanel collapsePanel;
    private JLabel waitingLabel;

    public GraphTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(GraphTopComponent.class, (String)"CTL_GraphTopComponent"));
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                GraphTopComponent.this.open();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GraphTopComponent.this.initCollapsePanel();
                        GraphTopComponent.this.initToolPanels();
                        GraphTopComponent.this.drawable = VizController.getInstance().getDrawable();
                        GraphTopComponent.this.engine = VizController.getInstance().getEngine();
                        GraphTopComponent.this.requestActive();
                        GraphTopComponent.this.add(GraphTopComponent.this.drawable.getGraphComponent(), "Center");
                        GraphTopComponent.this.remove(GraphTopComponent.this.waitingLabel);
                    }
                });
            }
        });
        this.initKeyEventContextMenuActionMappings();
    }

    private void initCollapsePanel() {
        this.vizBarController = new VizBarController();
        if (VizController.getInstance().getVizConfig().isShowVizVar()) {
            this.collapsePanel.init(this.vizBarController.getToolbar(), this.vizBarController.getExtendedBar(), false);
        } else {
            this.collapsePanel.setVisible(false);
        }
    }

    private void initToolPanels() {
        boolean hasWorkspace;
        final ToolController tc = (ToolController)Lookup.getDefault().lookup(ToolController.class);
        if (tc != null) {
            if (VizController.getInstance().getVizConfig().isToolbar()) {
                JPanel westPanel = new JPanel(new BorderLayout(0, 0));
                this.toolbar = tc.getToolbar();
                if (this.toolbar != null) {
                    westPanel.add((Component)this.toolbar, "Center");
                }
                this.selectionToolbar = new SelectionToolbar();
                this.actionsToolbar = new ActionsToolbar();
                westPanel.add((Component)this.selectionToolbar, "North");
                westPanel.add((Component)this.actionsToolbar, "South");
                this.add(westPanel, "West");
            }
            if (VizController.getInstance().getVizConfig().isPropertiesbar()) {
                this.propertiesBar = tc.getPropertiesBar();
                if (this.propertiesBar != null) {
                    this.add(this.propertiesBar, "North");
                }
            }
        }
        ProjectController projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        projectController.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                if (GraphTopComponent.this.toolbar != null) {
                    GraphTopComponent.this.toolbar.setEnabled(true);
                }
                if (GraphTopComponent.this.propertiesBar != null) {
                    GraphTopComponent.this.propertiesBar.setEnabled(true);
                }
                if (GraphTopComponent.this.actionsToolbar != null) {
                    GraphTopComponent.this.actionsToolbar.setEnabled(true);
                }
                if (GraphTopComponent.this.selectionToolbar != null) {
                    GraphTopComponent.this.selectionToolbar.setEnabled(true);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                if (GraphTopComponent.this.toolbar != null) {
                    GraphTopComponent.this.toolbar.setEnabled(false);
                }
                if (tc != null) {
                    tc.select(null);
                }
                if (GraphTopComponent.this.propertiesBar != null) {
                    GraphTopComponent.this.propertiesBar.setEnabled(false);
                }
                if (GraphTopComponent.this.actionsToolbar != null) {
                    GraphTopComponent.this.actionsToolbar.setEnabled(false);
                }
                if (GraphTopComponent.this.selectionToolbar != null) {
                    GraphTopComponent.this.selectionToolbar.setEnabled(false);
                }
            }
        });
        boolean bl = hasWorkspace = projectController.getCurrentWorkspace() != null;
        if (this.toolbar != null) {
            this.toolbar.setEnabled(hasWorkspace);
        }
        if (this.propertiesBar != null) {
            this.propertiesBar.setEnabled(hasWorkspace);
        }
        if (this.actionsToolbar != null) {
            this.actionsToolbar.setEnabled(hasWorkspace);
        }
        if (this.selectionToolbar != null) {
            this.selectionToolbar.setEnabled(hasWorkspace);
        }
    }

    private void initKeyEventContextMenuActionMappings() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        KeyEvent evt = (KeyEvent)event;
        if (evt.getID() != 402 || (evt.getModifiersEx() & 0x80) == 128) {
            // empty if block
        }
    }

    private void initComponents() {
        this.waitingLabel = new JLabel();
        this.collapsePanel = new CollapsePanel();
        this.setLayout(new BorderLayout());
        this.waitingLabel.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.waitingLabel, (String)NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.waitingLabel.text"));
        this.waitingLabel.setVerticalAlignment(1);
        this.add(this.waitingLabel, "Center");
        this.add(this.collapsePanel, "Last");
    }

    protected void componentActivated() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    protected void componentDeactivated() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

