/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.progress;

import org.gephi.utils.progress.ProgressTicket;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;

public final class ProgressTicketImpl
implements ProgressTicket {
    private final ProgressHandle handle;
    private String displayName;
    private int progress100 = 0;
    private int progressTotal;
    private int currentUnit = 0;
    private boolean started = false;
    private boolean finished = false;

    public ProgressTicketImpl(String displayName, Cancellable cancellable) {
        this.handle = ProgressHandleFactory.createHandle((String)displayName, (Cancellable)cancellable);
        this.displayName = displayName;
    }

    public void finish() {
        if (this.handle != null && this.started && !this.finished) {
            try {
                this.handle.finish();
                this.finished = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void finish(String finishMessage) {
        if (this.handle != null && this.started && !this.finished) {
            try {
                this.handle.finish();
                this.finished = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            StatusDisplayer.getDefault().setStatusText(finishMessage);
        }
    }

    public void progress() {
        this.progress(this.currentUnit + 1);
    }

    public void progress(int workunit) {
        int ratioProgress;
        this.currentUnit = workunit;
        if (this.handle != null && (ratioProgress = (int)(100.0 * (double)workunit / (double)this.progressTotal)) != this.progress100) {
            this.progress100 = ratioProgress;
            this.handle.progress(this.progress100 <= 100 ? this.progress100 : 100);
        }
    }

    public void progress(String message) {
        if (this.handle != null) {
            this.handle.progress(message);
        }
    }

    public void progress(String message, int workunit) {
        int ratioProgress;
        this.currentUnit = workunit;
        if (this.handle != null && (ratioProgress = (int)(100.0 * (double)workunit / (double)this.progressTotal)) != this.progress100) {
            this.progress100 = ratioProgress;
            this.handle.progress(message, this.progress100 <= 100 ? this.progress100 : 100);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        if (this.handle != null) {
            this.handle.setDisplayName(newDisplayName);
            this.displayName = newDisplayName;
        }
    }

    public void start() {
        if (this.handle != null) {
            this.started = true;
            this.handle.start();
        }
    }

    public void start(int workunits) {
        if (this.handle != null) {
            this.started = true;
            this.progressTotal = workunits;
            this.handle.start(100);
        }
    }

    public void switchToDeterminate(int workunits) {
        if (this.handle != null) {
            if (this.started) {
                this.progressTotal = workunits;
                this.handle.switchToDeterminate(100);
            } else {
                this.start(workunits);
            }
        }
    }

    public void switchToIndeterminate() {
        if (this.handle != null) {
            this.handle.switchToIndeterminate();
        }
    }
}

