/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class ExporterGML
implements GraphExporter,
CharacterExporter,
LongTask {
    double minX;
    double maxX;
    double minY;
    double maxY;
    double minZ;
    double maxZ;
    double minSize;
    double maxSize;
    private boolean exportVisible = false;
    private Workspace workspace;
    private GraphModel graphModel;
    private Writer writer;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private int spaces = 2;
    private int currentSpaces = 0;
    private boolean exportLabel = true;
    private boolean exportCoordinates = true;
    private boolean exportNodeSize = true;
    private boolean exportEdgeSize = true;
    private final boolean exportDynamicWeight = true;
    private boolean exportColor = true;
    private boolean exportNotRecognizedElements = true;
    private boolean normalize = false;

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.graphModel = graphController.getGraphModel(this.workspace);
        Graph graph = this.exportVisible ? this.graphModel.getGraphVisible() : this.graphModel.getGraph();
        Progress.start((ProgressTicket)this.progressTicket, (int)(graph.getNodeCount() + graph.getEdgeCount()));
        graph.readLock();
        try {
            if (this.normalize) {
                this.computeNormalizeValues(graph);
            }
            this.exportData(graph);
        }
        catch (IOException e) {
            Logger.getLogger(ExporterGML.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void printOpen(String s) throws IOException {
        int i;
        for (i = 0; i < this.currentSpaces; ++i) {
            this.writer.write(32);
        }
        this.writer.write(s + "\n");
        for (i = 0; i < this.currentSpaces; ++i) {
            this.writer.write(32);
        }
        this.writer.write("[\n");
        this.currentSpaces += this.spaces;
    }

    private void printClose() throws IOException {
        this.currentSpaces -= this.spaces;
        for (int i = 0; i < this.currentSpaces; ++i) {
            this.writer.write(32);
        }
        this.writer.write("]\n");
    }

    private void printTag(String s) throws IOException {
        for (int i = 0; i < this.currentSpaces; ++i) {
            this.writer.write(32);
        }
        this.writer.write(s + "\n");
    }

    private void exportData(Graph graph) throws IOException {
        this.printOpen("graph");
        this.printTag("Creator \"Gephi\"");
        if (graph.isDirected() || graph.isMixed()) {
            this.printTag("directed 1");
        } else if (graph.isUndirected()) {
            this.printTag("directed 0");
        }
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            if (this.cancel) {
                nodeIterable.doBreak();
                return;
            }
            this.printNode(node, graph);
        }
        EdgeIterable edgeIterable = graph.getEdges();
        for (Edge edge : edgeIterable) {
            if (this.cancel) {
                edgeIterable.doBreak();
                return;
            }
            this.printEdge(edge, graph);
        }
        this.printClose();
    }

    private void printEdge(Edge edge, Graph graph) throws IOException {
        this.printOpen("edge");
        this.printTag("id " + edge.getId());
        this.printTag("source " + edge.getSource().getId());
        this.printTag("target " + edge.getTarget().getId());
        if (this.exportLabel && edge.getLabel() != null) {
            this.printTag("label \"" + edge.getLabel() + "\"");
        }
        if (this.exportEdgeSize) {
            this.printTag("value " + edge.getWeight(graph.getView()));
        }
        if (graph.isMixed()) {
            if (edge.isDirected()) {
                this.printTag("directed 1");
            } else {
                this.printTag("directed 0");
            }
        }
        if (this.exportColor && edge.alpha() != 0.0f) {
            Color color = edge.getColor();
            this.printTag("fill \"" + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + "\"");
        }
        if (this.exportNotRecognizedElements) {
            for (Column col : this.graphModel.getEdgeTable()) {
                Object value;
                if (col.isProperty() || (value = edge.getAttribute(col, graph.getView())) == null) continue;
                this.printTag(this.formatTitle(col.getTitle()) + " \"" + this.formatValue(value) + "\"");
            }
        }
        this.printClose();
        Progress.progress((ProgressTicket)this.progressTicket);
    }

    private void printNode(Node node, Graph graph) throws IOException {
        this.printOpen("node");
        this.printTag("id " + node.getId());
        if (this.exportLabel && node.getLabel() != null) {
            this.printTag("label \"" + node.getLabel() + "\"");
        }
        if (this.exportCoordinates || this.exportNodeSize || this.exportColor) {
            this.printOpen("graphics");
            if (this.exportCoordinates) {
                if (!this.normalize) {
                    this.printTag("x " + node.x());
                    this.printTag("y " + node.y());
                    this.printTag("z " + node.z());
                } else {
                    this.printTag("x " + ((double)node.x() - this.minX) / (this.maxX - this.minX));
                    this.printTag("y " + ((double)node.y() - this.minY) / (this.maxY - this.minY));
                    this.printTag("z " + ((double)node.z() - this.minZ) / (this.maxZ - this.minZ));
                }
            }
            if (this.exportNodeSize) {
                if (!this.normalize) {
                    this.printTag("w " + node.size());
                    this.printTag("h " + node.size());
                    this.printTag("d " + node.size());
                } else {
                    this.printTag("w " + ((double)node.size() - this.minSize) / (this.maxSize - this.minSize));
                    this.printTag("h " + ((double)node.size() - this.minSize) / (this.maxSize - this.minSize));
                    this.printTag("d " + ((double)node.size() - this.minSize) / (this.maxSize - this.minSize));
                }
            }
            if (this.exportColor) {
                Color color = node.getColor();
                this.printTag("fill \"" + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()) + "\"");
            }
            this.printClose();
        }
        if (this.exportNotRecognizedElements) {
            for (Column col : this.graphModel.getNodeTable()) {
                Object value;
                if (col.isProperty() || (value = node.getAttribute(col, graph.getView())) == null) continue;
                this.printTag(this.formatTitle(col.getTitle()) + " \"" + this.formatValue(value) + "\"");
            }
        }
        this.printClose();
        Progress.progress((ProgressTicket)this.progressTicket);
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isExportColor() {
        return this.exportColor;
    }

    public void setExportColor(boolean exportColor) {
        this.exportColor = exportColor;
    }

    public boolean isExportCoordinates() {
        return this.exportCoordinates;
    }

    public void setExportCoordinates(boolean exportCoordinates) {
        this.exportCoordinates = exportCoordinates;
    }

    public boolean isExportEdgeSize() {
        return this.exportEdgeSize;
    }

    public void setExportEdgeSize(boolean exportEdgeSize) {
        this.exportEdgeSize = exportEdgeSize;
    }

    public boolean isExportLabel() {
        return this.exportLabel;
    }

    public void setExportLabel(boolean exportLabel) {
        this.exportLabel = exportLabel;
    }

    public boolean isExportNodeSize() {
        return this.exportNodeSize;
    }

    public void setExportNodeSize(boolean exportNodeSize) {
        this.exportNodeSize = exportNodeSize;
    }

    public boolean isExportNotRecognizedElements() {
        return this.exportNotRecognizedElements;
    }

    public void setExportNotRecognizedElements(boolean exportNotRecognizedElements) {
        this.exportNotRecognizedElements = exportNotRecognizedElements;
    }

    public int getSpaces() {
        return this.spaces;
    }

    public void setSpaces(int spaces) {
        this.spaces = spaces;
    }

    private void computeNormalizeValues(Graph graph) {
        this.minX = Double.MAX_VALUE;
        this.minY = Double.MAX_VALUE;
        this.minZ = Double.MAX_VALUE;
        this.maxX = Double.MIN_VALUE;
        this.maxY = Double.MIN_VALUE;
        this.maxZ = Double.MIN_VALUE;
        this.minSize = Double.MAX_VALUE;
        this.maxSize = Double.MIN_VALUE;
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            if (this.cancel) {
                nodeIterable.doBreak();
                break;
            }
            this.minX = Math.min(this.minX, (double)node.x());
            this.minY = Math.min(this.minY, (double)node.y());
            this.minZ = Math.min(this.minZ, (double)node.z());
            this.maxX = Math.max(this.maxX, (double)node.x());
            this.maxY = Math.max(this.maxY, (double)node.y());
            this.maxZ = Math.max(this.maxZ, (double)node.z());
            this.minSize = Math.min(this.minSize, (double)node.size());
            this.maxSize = Math.max(this.maxSize, (double)node.size());
        }
    }

    private String formatTitle(String s) {
        String res = s.replace("\"", "").replace("'", "").replace("[", "").replace("]", "").replace(" ", "").replace("#", "");
        if (s.charAt(0) >= '0' && s.charAt(0) <= '9') {
            return "column" + res;
        }
        return res;
    }

    private String formatValue(Object obj) {
        String res = obj.toString();
        return res.replace("\r\n", " ").replace("\n", " ").replace('\"', ' ');
    }
}

