/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.GeneralCreateColumnFromRegex;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;

public class GeneralCreateColumnFromRegexUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    private static final Color invalidRegexColor = new Color(254, 150, 150);
    private DialogControls dialogControls;
    private Table table;
    private Mode mode = Mode.BOOLEAN;
    private GeneralCreateColumnFromRegex manipulator;
    private Pattern pattern;
    private JLabel descriptionLabel;
    private JLabel regexLabel;
    private JTextField regexTextField;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public GeneralCreateColumnFromRegexUI() {
        this.initComponents();
        this.regexTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshPattern();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshPattern();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshPattern();
            }
        });
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GeneralCreateColumnFromRegexUI.this.refreshOkButton();
            }
        });
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.manipulator = (GeneralCreateColumnFromRegex)m;
        this.table = table;
        this.dialogControls = dialogControls;
        switch (this.mode) {
            case BOOLEAN: {
                this.descriptionLabel.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.descriptionLabel.text.boolean", (Object)column.getTitle()));
                break;
            }
            case MATCHING_GROUPS: {
                this.descriptionLabel.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.descriptionLabel.text.matching_groups", (Object)column.getTitle()));
            }
        }
        this.refreshPattern();
    }

    public void unSetup() {
        this.manipulator.setTitle(this.titleTextField.getText());
        this.manipulator.setPattern(this.pattern);
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        return validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void refreshOkButton() {
        String text = this.titleTextField.getText();
        this.dialogControls.setOkButtonEnabled(this.pattern != null && text != null && !text.isEmpty() && !this.table.hasColumn(text));
    }

    private void refreshPattern() {
        try {
            this.pattern = Pattern.compile(this.regexTextField.getText());
            this.regexTextField.setBackground(Color.WHITE);
        }
        catch (PatternSyntaxException ex) {
            this.regexTextField.setBackground(invalidRegexColor);
            this.pattern = null;
        }
        this.refreshOkButton();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.regexLabel = new JLabel();
        this.regexTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.titleLabel.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.titleTextField.text"));
        this.regexLabel.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.regexLabel.text"));
        this.regexTextField.setText(NbBundle.getMessage(GeneralCreateColumnFromRegexUI.class, (String)"GeneralCreateColumnFromRegexUI.regexTextField.text"));
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, GroupLayout.Alignment.TRAILING, -1, 280, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.regexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regexTextField, -1, 180, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 184, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.titleTextField, -2, -1, -2).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.regexLabel).addComponent(this.regexTextField, -2, -1, -2)).addContainerGap()));
    }

    public static enum Mode {
        BOOLEAN,
        MATCHING_GROUPS;

    }
}

