/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import javax.swing.JPanel;
import org.gephi.io.exporter.preview.SVGExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.preview.AbstractExporterSettings;
import org.gephi.ui.exporter.preview.UIExporterPDF;
import org.gephi.ui.exporter.preview.UIExporterSVGPanel;
import org.openide.util.NbBundle;

public class UIExporterSVG
implements ExporterUI {
    private final ExporterSVGSettings settings = new ExporterSVGSettings();
    private UIExporterSVGPanel panel;
    private SVGExporter exporterSVG;

    public void setup(Exporter exporter) {
        this.exporterSVG = (SVGExporter)exporter;
        this.settings.load(this.exporterSVG);
        this.panel.setup(this.exporterSVG);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterSVG);
            this.settings.save(this.exporterSVG);
        }
        this.panel = null;
        this.exporterSVG = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterSVGPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof SVGExporter;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPDF.class, (String)"UIExporterSVG.name");
    }

    private static class ExporterSVGSettings
    extends AbstractExporterSettings {
        private static final String SCALE_STROKES = "SVG_strokeScale";
        private static final String MARGIN = "SVG_margin";
        private static final SVGExporter DEFAULT = new SVGExporter();

        private ExporterSVGSettings() {
        }

        void load(SVGExporter exporter) {
            exporter.setScaleStrokes(this.get(SCALE_STROKES, DEFAULT.isScaleStrokes()));
            exporter.setMargin(this.get(MARGIN, DEFAULT.getMargin()));
        }

        void save(SVGExporter exporter) {
            this.put(SCALE_STROKES, exporter.isScaleStrokes());
            this.put(MARGIN, exporter.getMargin());
        }
    }
}

