/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.awt.Color;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.PartitionTransformer;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIController;
import org.gephi.desktop.appearance.AutoAppyTransformer;
import org.gephi.desktop.appearance.FunctionObserverExecutor;
import org.gephi.desktop.appearance.TableObserverExecutor;
import org.gephi.project.api.Workspace;
import org.gephi.ui.appearance.plugin.category.DefaultCategory;

public class AppearanceUIModel {
    protected final AppearanceModel appearanceModel;
    protected final Map<String, Map<TransformerCategory, TransformerUI>> selectedTransformerUI;
    protected final Map<String, Map<TransformerUI, Function>> selectedFunction;
    protected final Map<String, TransformerCategory> selectedCategory;
    protected final Map<String, Map<TransformerCategory, AutoAppyTransformer>> selectedAutoTransformer;
    protected final Map<Function, Map<String, Object>> savedProperties;
    protected final TableObserverExecutor tableObserverExecutor;
    protected final FunctionObserverExecutor functionObserverExecutor;
    protected String selectedElementClass = "nodes";

    public AppearanceUIModel(AppearanceModel model) {
        this.appearanceModel = model;
        this.selectedCategory = new HashMap<String, TransformerCategory>();
        this.selectedTransformerUI = new HashMap<String, Map<TransformerCategory, TransformerUI>>();
        this.selectedFunction = new HashMap<String, Map<TransformerUI, Function>>();
        this.selectedAutoTransformer = new HashMap<String, Map<TransformerCategory, AutoAppyTransformer>>();
        this.savedProperties = new HashMap<Function, Map<String, Object>>();
        for (String ec : AppearanceUIController.ELEMENT_CLASSES) {
            this.initSelectedTransformerUIs(ec);
        }
        this.tableObserverExecutor = new TableObserverExecutor(this);
        this.functionObserverExecutor = new FunctionObserverExecutor(this);
    }

    private void initSelectedTransformerUIs(String elementClass) {
        this.selectedFunction.put(elementClass, new HashMap());
        this.selectedAutoTransformer.put(elementClass, new HashMap());
        this.selectedTransformerUI.put(elementClass, new HashMap());
        for (Function func : elementClass.equals("nodes") ? this.appearanceModel.getNodeFunctions() : this.appearanceModel.getEdgeFunctions()) {
            TransformerUI ui = func.getUI();
            if (ui == null) continue;
            TransformerCategory cat = ui.getCategory();
            this.selectedCategory.put(elementClass, cat);
            if (!func.isSimple()) continue;
            this.selectedTransformerUI.get(elementClass).put(cat, ui);
            this.selectedFunction.get(elementClass).put(ui, func);
        }
        if (this.selectedTransformerUI.get(elementClass).containsKey(DefaultCategory.COLOR)) {
            this.selectedCategory.put(elementClass, DefaultCategory.COLOR);
        }
    }

    public void select() {
        this.tableObserverExecutor.start();
        this.functionObserverExecutor.start();
    }

    public void unselect() {
        this.tableObserverExecutor.stop();
        this.functionObserverExecutor.stop();
    }

    public boolean isRankingLocalScale() {
        return this.appearanceModel.isRankingLocalScale();
    }

    public boolean isPartitionLocalScale() {
        return this.appearanceModel.isPartitionLocalScale();
    }

    public boolean isTransformNullValues() {
        return this.appearanceModel.isTransformNullValues();
    }

    public void saveTransformerProperties() {
        Function func = this.getSelectedFunction();
        if (func != null) {
            Transformer transformer = func.getTransformer();
            Map props = this.savedProperties.computeIfAbsent(func, k -> new HashMap());
            for (Map.Entry<String, Method[]> entry : this.getProperties(transformer).entrySet()) {
                String name = entry.getKey();
                Method getMethod = entry.getValue()[0];
                try {
                    Object o = getMethod.invoke((Object)transformer, new Object[0]);
                    props.put(name, o);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadTransformerProperties() {
        Function func = this.getSelectedFunction();
        if (func != null) {
            Transformer transformer = func.getTransformer();
            Map<String, Object> props = this.savedProperties.get(func);
            if (props != null) {
                for (Map.Entry<String, Method[]> entry : this.getProperties(transformer).entrySet()) {
                    String name = entry.getKey();
                    Object o = props.get(name);
                    if (o == null) continue;
                    Method setMethod = entry.getValue()[1];
                    try {
                        setMethod.invoke((Object)transformer, o);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public String getSelectedElementClass() {
        return this.selectedElementClass;
    }

    protected void setSelectedElementClass(String selectedElementClass) {
        this.saveTransformerProperties();
        this.selectedElementClass = selectedElementClass;
        this.loadTransformerProperties();
    }

    public TransformerCategory getSelectedCategory() {
        return this.selectedCategory.get(this.selectedElementClass);
    }

    protected void setSelectedCategory(TransformerCategory category) {
        this.saveTransformerProperties();
        this.selectedCategory.put(this.selectedElementClass, category);
        this.loadTransformerProperties();
    }

    public TransformerUI getSelectedTransformerUI() {
        return this.selectedTransformerUI.get(this.selectedElementClass).get(this.getSelectedCategory());
    }

    protected void setSelectedTransformerUI(TransformerUI transformerUI) {
        this.saveTransformerProperties();
        this.selectedTransformerUI.get(this.selectedElementClass).put(this.getSelectedCategory(), transformerUI);
        this.loadTransformerProperties();
    }

    public Function getSelectedFunction() {
        return this.selectedFunction.get(this.selectedElementClass).get(this.getSelectedTransformerUI());
    }

    protected void setSelectedFunction(Function function) {
        this.saveTransformerProperties();
        this.selectedFunction.get(this.selectedElementClass).put(this.getSelectedTransformerUI(), function);
        this.loadTransformerProperties();
    }

    public AutoAppyTransformer getAutoApplyTransformer() {
        String elm = this.getSelectedElementClass();
        TransformerCategory ct = this.getSelectedCategory();
        if (ct != null) {
            return this.selectedAutoTransformer.get(elm).get(ct);
        }
        return null;
    }

    public Workspace getWorkspace() {
        return this.appearanceModel.getWorkspace();
    }

    public AppearanceModel getAppearanceModel() {
        return this.appearanceModel;
    }

    public Collection<Function> getFunctions() {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function func : this.selectedElementClass.equalsIgnoreCase("nodes") ? this.appearanceModel.getNodeFunctions() : this.appearanceModel.getEdgeFunctions()) {
            TransformerUI ui = func.getUI();
            if (ui == null || !ui.getDisplayName().equals(this.getSelectedTransformerUI().getDisplayName()) || !ui.getCategory().equals(this.selectedCategory.get(this.selectedElementClass))) continue;
            functions.add(func);
        }
        return functions;
    }

    protected void setAutoApply(boolean autoApply) {
        AutoAppyTransformer aat;
        if (!autoApply && (aat = this.getAutoApplyTransformer()) != null) {
            aat.stop();
        }
        String elmt = this.getSelectedElementClass();
        TransformerCategory cat = this.getSelectedCategory();
        if (autoApply) {
            this.selectedAutoTransformer.get(elmt).put(cat, new AutoAppyTransformer(this.getSelectedFunction()));
        } else {
            this.selectedAutoTransformer.get(elmt).put(cat, null);
        }
    }

    protected boolean isAttributeTransformerUI(TransformerUI ui) {
        Class transformerClass = ui.getTransformerClass();
        return RankingTransformer.class.isAssignableFrom(transformerClass) || PartitionTransformer.class.isAssignableFrom(transformerClass);
    }

    private Map<String, Method[]> getProperties(Transformer transformer) {
        HashMap<String, Method[]> propertyMethods = new HashMap<String, Method[]>();
        for (Method m : transformer.getClass().getMethods()) {
            String name = m.getName();
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String propertyName = null;
            if (name.startsWith("get")) {
                propertyName = name.substring(3);
            } else if (name.startsWith("set")) {
                propertyName = name.substring(3);
            } else if (name.startsWith("is")) {
                propertyName = name.substring(2);
            }
            Method[] ms = (Method[])propertyMethods.get(propertyName);
            if (ms == null) {
                ms = new Method[2];
                propertyMethods.put(propertyName, ms);
            }
            if (name.startsWith("set")) {
                ms[1] = m;
                continue;
            }
            ms[0] = m;
        }
        Iterator itr = propertyMethods.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Method get = ((Method[])entry.getValue())[0];
            Method set = ((Method[])entry.getValue())[1];
            if (get != null && set != null && set.getParameterTypes().length == 1 && get.getParameterTypes().length == 0 && set.getParameterTypes()[0].equals(get.getReturnType()) && this.isSupportedPropertyType(get.getReturnType())) continue;
            itr.remove();
        }
        return propertyMethods;
    }

    private boolean isSupportedPropertyType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            Class<?> cmp = type.getComponentType();
            return cmp.isPrimitive();
        }
        return type.equals(Color.class);
    }
}

