/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.NbBundle;

public class SwapListPanel
extends JPanel {
    private JList itemList1;
    private JList itemList2;
    private JButton leftButton;
    private JButton rightButton;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;

    public SwapListPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.itemList1 = new JList();
        this.scrollPane2 = new JScrollPane();
        this.itemList2 = new JList();
        this.leftButton = new JButton();
        this.rightButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.itemList1.setModel(new AbstractListModel(){
            final String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollPane1.setViewportView(this.itemList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollPane1, gridBagConstraints);
        this.itemList2.setModel(new AbstractListModel(){
            final String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollPane2.setViewportView(this.itemList2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollPane2, gridBagConstraints);
        this.leftButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/leftArrow.png")));
        this.leftButton.setText(NbBundle.getMessage(SwapListPanel.class, (String)"SwapListPanel.leftButton.text"));
        this.leftButton.setMinimumSize(new Dimension(33, 23));
        this.leftButton.setPreferredSize(new Dimension(33, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.leftButton, gridBagConstraints);
        this.rightButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/ui/components/resources/rightArrow.png")));
        this.rightButton.setText(NbBundle.getMessage(SwapListPanel.class, (String)"SwapListPanel.rightButton.text"));
        this.rightButton.setMinimumSize(new Dimension(33, 23));
        this.rightButton.setPreferredSize(new Dimension(33, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.rightButton, gridBagConstraints);
    }

    private class SwapListModel {
        JList leftList;
        JList rightList;
        DefaultListModel leftModel = new DefaultListModel();
        DefaultListModel rightModel = new DefaultListModel();
        JButton leftButton;
        JButton rightButton;

        public SwapListModel(JList leftList, JList rightList, JButton leftButton, JButton rightButton) {
            this.leftList = leftList;
            this.rightList = rightList;
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            leftList.setModel(this.leftModel);
            rightList.setModel(this.rightModel);
            leftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwapListModel.this.fromRightToLeftAction();
                }
            });
            rightButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwapListModel.this.fromLeftToRightAction();
                }
            });
        }

        public void fromLeftToRightAction() {
            Object value = this.leftList.getSelectedValue();
            this.rightModel.addElement(value);
            this.leftModel.removeElement(value);
            this.rightButton.setEnabled(!this.rightModel.isEmpty());
            this.leftButton.setEnabled(!this.leftModel.isEmpty());
        }

        public void fromRightToLeftAction() {
            Object value = this.rightList.getSelectedValue();
            this.leftModel.addElement(value);
            this.rightModel.removeElement(value);
            this.rightButton.setEnabled(!this.rightModel.isEmpty());
            this.leftButton.setEnabled(!this.leftModel.isEmpty());
            if (this.leftList.getSelectedIndex() == -1 && !this.leftModel.isEmpty()) {
                this.leftList.setSelectedIndex(0);
            }
            if (this.rightList.getSelectedIndex() == -1 && !this.rightModel.isEmpty()) {
                this.rightList.setSelectedIndex(0);
            }
        }

        public Object[] getLeftValues() {
            return this.leftModel.toArray();
        }

        public void setLeftValues(Object[] values) {
            this.leftModel.clear();
            for (Object o : values) {
                this.leftModel.addElement(o);
            }
            if (!this.leftModel.isEmpty()) {
                this.leftList.setSelectedIndex(0);
            }
            if (!this.rightModel.isEmpty()) {
                this.rightList.setSelectedIndex(0);
            }
            this.rightButton.setEnabled(!this.rightModel.isEmpty());
            this.leftButton.setEnabled(!this.leftModel.isEmpty());
        }

        public Object[] getRightValues() {
            return this.rightModel.toArray();
        }
    }
}

