/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "delegatedConstructorCallIsSuper", "", "getDelegatedConstructorCallIsSuper", "()Z", "delegatedConstructorCallIsThis", "getDelegatedConstructorCallIsThis", "isPrimary", "resolvedDelegatedConstructor", "getResolvedDelegatedConstructor", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "resolvedDelegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getResolvedDelegatedConstructorCall", "()Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "tree"})
public final class FirConstructorSymbol
extends FirFunctionSymbol<FirConstructor> {
    public FirConstructorSymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        super(callableId, null);
    }

    public FirConstructorSymbol(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        this(FqNamesUtilKt.callableIdForConstructor(classId));
    }

    public final boolean isPrimary() {
        return ((FirConstructor)this.getFir()).isPrimary();
    }

    @Nullable
    public final FirConstructorSymbol getResolvedDelegatedConstructor() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = this.getResolvedDelegatedConstructorCall();
        if (firDelegatedConstructorCall == null) {
            return null;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = firDelegatedConstructorCall;
        FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(delegatedConstructorCall.getCalleeReference());
        return firBasedSymbol instanceof FirConstructorSymbol ? (FirConstructorSymbol)firBasedSymbol : null;
    }

    @Nullable
    public final FirDelegatedConstructorCall getResolvedDelegatedConstructorCall() {
        if (((FirConstructor)this.getFir()).getDelegatedConstructor() == null) {
            return null;
        }
        FirPhaseManagerKt.ensureResolved(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirConstructor)this.getFir()).getDelegatedConstructor();
    }

    public final boolean getDelegatedConstructorCallIsThis() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false;
    }

    public final boolean getDelegatedConstructorCallIsSuper() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isSuper() : false;
    }
}

