# Installation
> `npm install --save @types/fuzzy-search`

# Summary
This package contains type definitions for fuzzy-search (https://github.com/wouter2203/fuzzy-search#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/fuzzy-search.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/fuzzy-search/index.d.ts)
````ts
// Type definitions for fuzzy-search 2.1
// Project: https://github.com/wouter2203/fuzzy-search#readme
// Definitions by: BendingBender <https://github.com/BendingBender>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.8

declare class FuzzySearch<T extends object | string> {
    haystack: T[];
    keys: string[];
    options: Required<FuzzySearch.Options>;

    static isMatch(item: string, query: string, caseSensitive: boolean): number;

    constructor(haystack: T[], keys?: string[], options?: FuzzySearch.Options);
    search(needle?: string): T[];
}

declare namespace FuzzySearch {
    interface Options {
        caseSensitive?: boolean | undefined;
        sort?: boolean | undefined;
    }
}

export = FuzzySearch;

````

### Additional Details
 * Last updated: Thu, 23 Dec 2021 23:34:39 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [BendingBender](https://github.com/BendingBender).
