/* utils.c generated by valac 0.56.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2018-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <libwnck/libwnck.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "abomination.h"

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gchar* budgie_abomination_get_group_name (WnckWindow* window);

/**
 * Try to get application group from its WM_CLASS property or fallback to using
 * the app name when WM_CLASS isn't set (e.g. LibreOffice, Google Chrome, Android Studio emulator, maybe others)
 */
gchar*
budgie_abomination_get_group_name (WnckWindow* window)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = wnck_window_get_class_group_name (window);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = name;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = wnck_window_get_class_instance_name (window);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (name);
		name = _tmp6_;
	}
	_tmp8_ = name;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = name;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	}
	if (_tmp7_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = wnck_window_get_name (window);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (name);
		name = _tmp11_;
	}
	_tmp12_ = name;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = name;
		_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
		_g_free0 (name);
		name = _tmp14_;
	}
	_tmp15_ = name;
	if (g_strcmp0 (_tmp15_, "google chrome") == 0) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("google-chrome");
		_g_free0 (name);
		name = _tmp16_;
	}
	result = name;
	return result;
}

