/* tabswitcher.c generated by valac 0.56.0, the Vala compiler
 * generated from tabswitcher.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2017-2022 taaem <taaem@mailbox.org>
 * Copyright (C) 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libwnck/libwnck.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include "appsys.h"
#include <gdk/gdkx.h>
#include <cairo-gobject.h>
#include <stdio.h>

#define BUDGIE_SWITCHER_SIZE -1
#define BUDGIE_SWITCHER_MOD_EXPIRE_TIME 50
#define BUDGIE_SWITCHER_DBUS_NAME "org.budgie_desktop.TabSwitcher"
#define BUDGIE_SWITCHER_DBUS_OBJECT_PATH "/org/budgie_desktop/TabSwitcher"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_TAB_SWITCHER_WIDGET (budgie_tab_switcher_widget_get_type ())
#define BUDGIE_TAB_SWITCHER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidget))
#define BUDGIE_TAB_SWITCHER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidgetClass))
#define BUDGIE_IS_TAB_SWITCHER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET))
#define BUDGIE_IS_TAB_SWITCHER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER_WIDGET))
#define BUDGIE_TAB_SWITCHER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidgetClass))

typedef struct _BudgieTabSwitcherWidget BudgieTabSwitcherWidget;
typedef struct _BudgieTabSwitcherWidgetClass BudgieTabSwitcherWidgetClass;
typedef struct _BudgieTabSwitcherWidgetPrivate BudgieTabSwitcherWidgetPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_WIDGET_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_widget_properties[BUDGIE_TAB_SWITCHER_WIDGET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_TAB_SWITCHER_WINDOW (budgie_tab_switcher_window_get_type ())
#define BUDGIE_TAB_SWITCHER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindow))
#define BUDGIE_TAB_SWITCHER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindowClass))
#define BUDGIE_IS_TAB_SWITCHER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW))
#define BUDGIE_IS_TAB_SWITCHER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER_WINDOW))
#define BUDGIE_TAB_SWITCHER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindowClass))

typedef struct _BudgieTabSwitcherWindow BudgieTabSwitcherWindow;
typedef struct _BudgieTabSwitcherWindowClass BudgieTabSwitcherWindowClass;
typedef struct _BudgieTabSwitcherWindowPrivate BudgieTabSwitcherWindowPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_WINDOW_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_window_properties[BUDGIE_TAB_SWITCHER_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_TAB_SWITCHER (budgie_tab_switcher_get_type ())
#define BUDGIE_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcher))
#define BUDGIE_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))
#define BUDGIE_IS_TAB_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_IS_TAB_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TAB_SWITCHER))
#define BUDGIE_TAB_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcherClass))

typedef struct _BudgieTabSwitcher BudgieTabSwitcher;
typedef struct _BudgieTabSwitcherClass BudgieTabSwitcherClass;
typedef struct _BudgieTabSwitcherPrivate BudgieTabSwitcherPrivate;
enum  {
	BUDGIE_TAB_SWITCHER_0_PROPERTY,
	BUDGIE_TAB_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* budgie_tab_switcher_properties[BUDGIE_TAB_SWITCHER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BudgieTabSwitcherWidget {
	GtkImage parent_instance;
	BudgieTabSwitcherWidgetPrivate * priv;
	gchar* title;
	guint32 xid;
	guint32 usertime;
	WnckWindow* wnck_window;
};

struct _BudgieTabSwitcherWidgetClass {
	GtkImageClass parent_class;
};

struct _BudgieTabSwitcherWindow {
	GtkWindow parent_instance;
	BudgieTabSwitcherWindowPrivate * priv;
};

struct _BudgieTabSwitcherWindowClass {
	GtkWindowClass parent_class;
};

struct _BudgieTabSwitcherWindowPrivate {
	GtkFlowBox* window_box;
	GtkLabel* window_title;
	GdkMonitor* primary_monitor;
	GHashTable* xids;
	BudgieAppSystem* app_system;
};

struct _BudgieTabSwitcher {
	GObject parent_instance;
	BudgieTabSwitcherPrivate * priv;
};

struct _BudgieTabSwitcherClass {
	GObjectClass parent_class;
};

struct _BudgieTabSwitcherPrivate {
	BudgieTabSwitcherWindow* switcher_window;
	guint32 mod_timeout;
};

static gpointer budgie_tab_switcher_widget_parent_class = NULL;
static gint BudgieTabSwitcherWindow_private_offset;
static gpointer budgie_tab_switcher_window_parent_class = NULL;
static gint BudgieTabSwitcher_private_offset;
static gpointer budgie_tab_switcher_parent_class = NULL;
VALA_EXTERN gboolean budgie_setup;

VALA_EXTERN GType budgie_tab_switcher_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcherWidget, g_object_unref)
VALA_EXTERN BudgieTabSwitcherWidget* budgie_tab_switcher_widget_new (WnckWindow* window,
                                                         GDesktopAppInfo* info,
                                                         guint32 usertime);
VALA_EXTERN BudgieTabSwitcherWidget* budgie_tab_switcher_widget_construct (GType object_type,
                                                               WnckWindow* window,
                                                               GDesktopAppInfo* info,
                                                               guint32 usertime);
static void budgie_tab_switcher_widget_finalize (GObject * obj);
static GType budgie_tab_switcher_widget_get_type_once (void);
VALA_EXTERN GType budgie_tab_switcher_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcherWindow, g_object_unref)
static void budgie_tab_switcher_window_on_hide (BudgieTabSwitcherWindow* self);
VALA_EXTERN void budgie_tab_switcher_window_stop_switching (BudgieTabSwitcherWindow* self);
VALA_EXTERN BudgieTabSwitcherWindow* budgie_tab_switcher_window_new (void);
VALA_EXTERN BudgieTabSwitcherWindow* budgie_tab_switcher_window_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _budgie_tab_switcher_window_on_hide_gtk_widget_hide (GtkWidget* _sender,
                                                          gpointer self);
static void budgie_tab_switcher_window_on_monitors_changed (BudgieTabSwitcherWindow* self);
static void _budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                                  gpointer self);
VALA_EXTERN void budgie_tab_switcher_window_move_switcher (BudgieTabSwitcherWindow* self);
VALA_EXTERN void budgie_tab_switcher_window_add_window (BudgieTabSwitcherWindow* self,
                                            guint32 xid,
                                            guint32 usertime);
VALA_EXTERN void budgie_tab_switcher_window_focus_item (BudgieTabSwitcherWindow* self,
                                            guint32 xid);
static void budgie_tab_switcher_window_finalize (GObject * obj);
static GType budgie_tab_switcher_window_get_type_once (void);
VALA_EXTERN GType budgie_tab_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieTabSwitcher, g_object_unref)
VALA_EXTERN guint budgie_tab_switcher_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_new (void);
VALA_EXTERN BudgieTabSwitcher* budgie_tab_switcher_construct (GType object_type);
VALA_EXTERN void budgie_tab_switcher_setup_dbus (BudgieTabSwitcher* self,
                                     gboolean replace);
static void budgie_tab_switcher_on_bus_acquired (BudgieTabSwitcher* self,
                                          GDBusConnection* conn);
static void _budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self);
static void __lambda20_ (BudgieTabSwitcher* self);
static void ___lambda20__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
VALA_EXTERN void budgie_tab_switcher_PassItem (BudgieTabSwitcher* self,
                                   guint32 id,
                                   guint32 usertime,
                                   GError** error);
VALA_EXTERN void budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                       guint32 curr_xid,
                                       GError** error);
static void budgie_tab_switcher_add_mod_key_watcher (BudgieTabSwitcher* self);
VALA_EXTERN void budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                       GError** error);
static gboolean budgie_tab_switcher_check_mod_key (BudgieTabSwitcher* self);
static void budgie_tab_switcher_finalize (GObject * obj);
static GType budgie_tab_switcher_get_type_once (void);
static void _dbus_budgie_tab_switcher_PassItem (BudgieTabSwitcher* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void budgie_tab_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_tab_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_tab_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_tab_switcher_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_tab_switcher_dbus_arg_info_PassItem_id = {-1, "id", "u", NULL};
static const GDBusArgInfo _budgie_tab_switcher_dbus_arg_info_PassItem_usertime = {-1, "usertime", "u", NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_PassItem_in[] = {&_budgie_tab_switcher_dbus_arg_info_PassItem_id, &_budgie_tab_switcher_dbus_arg_info_PassItem_usertime, NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_PassItem_out[] = {NULL};
static const GDBusMethodInfo _budgie_tab_switcher_dbus_method_info_PassItem = {-1, "PassItem", (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_PassItem_in), (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_PassItem_out), NULL};
static const GDBusArgInfo _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_curr_xid = {-1, "curr_xid", "u", NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_in[] = {&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_curr_xid, NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_ShowSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_tab_switcher_dbus_method_info_ShowSwitcher = {-1, "ShowSwitcher", (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_in), (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_ShowSwitcher_out), NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_StopSwitcher_in[] = {NULL};
static const GDBusArgInfo * const _budgie_tab_switcher_dbus_arg_info_StopSwitcher_out[] = {NULL};
static const GDBusMethodInfo _budgie_tab_switcher_dbus_method_info_StopSwitcher = {-1, "StopSwitcher", (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_StopSwitcher_in), (GDBusArgInfo **) (&_budgie_tab_switcher_dbus_arg_info_StopSwitcher_out), NULL};
static const GDBusMethodInfo * const _budgie_tab_switcher_dbus_method_info[] = {&_budgie_tab_switcher_dbus_method_info_PassItem, &_budgie_tab_switcher_dbus_method_info_ShowSwitcher, &_budgie_tab_switcher_dbus_method_info_StopSwitcher, NULL};
static const GDBusSignalInfo * const _budgie_tab_switcher_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_tab_switcher_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_tab_switcher_dbus_interface_info = {-1, "org.budgie_desktop.TabSwitcher", (GDBusMethodInfo **) (&_budgie_tab_switcher_dbus_method_info), (GDBusSignalInfo **) (&_budgie_tab_switcher_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_tab_switcher_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_tab_switcher_dbus_interface_vtable = {budgie_tab_switcher_dbus_interface_method_call, budgie_tab_switcher_dbus_interface_get_property, budgie_tab_switcher_dbus_interface_set_property};

/**
* Construct a new TabSwitcherWidget with the given xid + title
*/
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

BudgieTabSwitcherWidget*
budgie_tab_switcher_widget_construct (GType object_type,
                                      WnckWindow* window,
                                      GDesktopAppInfo* info,
                                      guint32 usertime)
{
	BudgieTabSwitcherWidget * self = NULL;
	gchar* title = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GValue _tmp7_ = {0};
	self = (BudgieTabSwitcherWidget*) g_object_new (object_type, NULL);
	_tmp0_ = wnck_window_get_name (window);
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	if (wnck_window_has_name (window)) {
		const gchar* _tmp3_;
		_tmp3_ = title;
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = "";
	}
	_tmp4_ = g_strdup (_tmp2_);
	_g_free0 (self->title);
	self->title = _tmp4_;
	_tmp5_ = self->title;
	_tmp6_ = string_strip (_tmp5_);
	_g_free0 (self->title);
	self->title = _tmp6_;
	self->wnck_window = window;
	self->xid = (guint32) wnck_window_get_xid (window);
	self->usertime = usertime;
	g_value_init (&_tmp7_, G_TYPE_INT);
	g_value_set_int (&_tmp7_, 10);
	g_object_set_property ((GObject*) self, "margin", &_tmp7_);
	G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
	if (info != NULL) {
		GIcon* _tmp8_;
		_tmp8_ = g_app_info_get_icon ((GAppInfo*) info);
		gtk_image_set_from_gicon ((GtkImage*) self, _tmp8_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	} else {
		WnckWindow* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp9_ = self->wnck_window;
		_tmp10_ = wnck_window_get_icon (_tmp9_);
		gtk_image_set_from_pixbuf ((GtkImage*) self, _tmp10_);
	}
	gtk_image_set_pixel_size ((GtkImage*) self, 48);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	_g_free0 (title);
	return self;
}

BudgieTabSwitcherWidget*
budgie_tab_switcher_widget_new (WnckWindow* window,
                                GDesktopAppInfo* info,
                                guint32 usertime)
{
	return budgie_tab_switcher_widget_construct (BUDGIE_TYPE_TAB_SWITCHER_WIDGET, window, info, usertime);
}

static void
budgie_tab_switcher_widget_class_init (BudgieTabSwitcherWidgetClass * klass,
                                       gpointer klass_data)
{
	budgie_tab_switcher_widget_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_widget_finalize;
}

static void
budgie_tab_switcher_widget_instance_init (BudgieTabSwitcherWidget * self,
                                          gpointer klass)
{
	self->wnck_window = NULL;
}

static void
budgie_tab_switcher_widget_finalize (GObject * obj)
{
	BudgieTabSwitcherWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER_WIDGET, BudgieTabSwitcherWidget);
	_g_free0 (self->title);
	G_OBJECT_CLASS (budgie_tab_switcher_widget_parent_class)->finalize (obj);
}

/**
* A TabSwitcherWidget is used for each icon in the display
*/
static GType
budgie_tab_switcher_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcherWidget), 0, (GInstanceInitFunc) budgie_tab_switcher_widget_instance_init, NULL };
	GType budgie_tab_switcher_widget_type_id;
	budgie_tab_switcher_widget_type_id = g_type_register_static (gtk_image_get_type (), "BudgieTabSwitcherWidget", &g_define_type_info, 0);
	return budgie_tab_switcher_widget_type_id;
}

GType
budgie_tab_switcher_widget_get_type (void)
{
	static volatile gsize budgie_tab_switcher_widget_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_widget_type_id__once)) {
		GType budgie_tab_switcher_widget_type_id;
		budgie_tab_switcher_widget_type_id = budgie_tab_switcher_widget_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_widget_type_id__once, budgie_tab_switcher_widget_type_id);
	}
	return budgie_tab_switcher_widget_type_id__once;
}

static inline gpointer
budgie_tab_switcher_window_get_instance_private (BudgieTabSwitcherWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieTabSwitcherWindow_private_offset);
}

/**
* Make the current selection the active window
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_tab_switcher_window_on_hide (BudgieTabSwitcherWindow* self)
{
	GList* selection = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GtkFlowBoxChild* current = NULL;
	gboolean _tmp2_ = FALSE;
	GList* _tmp3_;
	GtkFlowBoxChild* _tmp9_;
	BudgieTabSwitcherWidget* tab = NULL;
	GtkFlowBoxChild* _tmp10_;
	GtkWidget* _tmp11_;
	BudgieTabSwitcherWidget* _tmp12_;
	guint32 time = 0U;
	GdkWindow* _tmp13_;
	BudgieTabSwitcherWidget* _tmp14_;
	WnckWindow* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_box;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	selection = _tmp1_;
	current = NULL;
	_tmp3_ = selection;
	if (_tmp3_ != NULL) {
		GList* _tmp4_;
		_tmp4_ = selection;
		_tmp2_ = g_list_length (_tmp4_) > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GList* _tmp5_;
		gconstpointer _tmp6_;
		GtkFlowBoxChild* _tmp7_;
		GtkFlowBoxChild* _tmp8_;
		_tmp5_ = selection;
		_tmp6_ = g_list_nth_data (_tmp5_, (guint) 0);
		_tmp7_ = (GtkFlowBoxChild*) _tmp6_;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) _tmp7_) : NULL);
		_g_object_unref0 (current);
		current = _tmp8_;
	}
	_tmp9_ = current;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (current);
		(selection == NULL) ? NULL : (selection = (g_list_free (selection), NULL));
		return;
	}
	_tmp10_ = current;
	_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
	_tmp12_ = _g_object_ref0 (BUDGIE_IS_TAB_SWITCHER_WIDGET (_tmp11_) ? ((BudgieTabSwitcherWidget*) _tmp11_) : NULL);
	tab = _tmp12_;
	_tmp13_ = gdk_get_default_root_window ();
	time = (guint32) gdk_x11_get_server_time (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gdk_x11_window_get_type ()) ? ((GdkX11Window*) _tmp13_) : NULL);
	_tmp14_ = tab;
	_tmp15_ = _tmp14_->wnck_window;
	wnck_window_activate (_tmp15_, time);
	budgie_tab_switcher_window_stop_switching (self);
	_g_object_unref0 (tab);
	_g_object_unref0 (current);
	(selection == NULL) ? NULL : (selection = (g_list_free (selection), NULL));
}

void
budgie_tab_switcher_window_stop_switching (BudgieTabSwitcherWindow* self)
{
	GList* children = NULL;
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GHashTable* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	children = _tmp1_;
	_tmp2_ = children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				gtk_widget_destroy (_tmp3_);
			}
		}
	}
	_tmp4_ = self->priv->xids;
	g_hash_table_remove_all (_tmp4_);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

/**
* Construct a new TabSwitcherWindow
*/
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_budgie_tab_switcher_window_on_hide_gtk_widget_hide (GtkWidget* _sender,
                                                     gpointer self)
{
	budgie_tab_switcher_window_on_hide ((BudgieTabSwitcherWindow*) self);
}

static void
_budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                             gpointer self)
{
	budgie_tab_switcher_window_on_monitors_changed ((BudgieTabSwitcherWindow*) self);
}

BudgieTabSwitcherWindow*
budgie_tab_switcher_window_construct (GType object_type)
{
	BudgieTabSwitcherWindow * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	BudgieAppSystem* _tmp3_;
	GdkVisual* vis = NULL;
	GdkScreen* _tmp4_;
	GdkScreen* _tmp5_;
	GdkVisual* _tmp6_;
	GdkVisual* _tmp7_;
	GdkVisual* _tmp8_;
	GdkScreen* _tmp10_;
	GdkScreen* _tmp11_;
	GtkWidget* _tmp12_;
	self = (BudgieTabSwitcherWindow*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, NULL);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ALWAYS);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->xids);
	self->priv->xids = _tmp2_;
	_tmp3_ = budgie_app_system_new ();
	_g_object_unref0 (self->priv->app_system);
	self->priv->app_system = _tmp3_;
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _budgie_tab_switcher_window_on_hide_gtk_widget_hide, self, 0);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_stick ((GtkWindow*) self);
	_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gdk_screen_get_rgba_visual (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	vis = _tmp7_;
	_tmp8_ = vis;
	if (_tmp8_ != NULL) {
		GdkVisual* _tmp9_;
		_tmp9_ = vis;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp9_);
	}
	_tmp10_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "monitors-changed", (GCallback) _budgie_tab_switcher_window_on_monitors_changed_gdk_screen_monitors_changed, self, 0);
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_SWITCHER_SIZE, -1);
	gtk_widget_realize ((GtkWidget*) self);
	_tmp12_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp12_);
	budgie_tab_switcher_window_on_monitors_changed (self);
	_g_object_unref0 (vis);
	return self;
}

BudgieTabSwitcherWindow*
budgie_tab_switcher_window_new (void)
{
	return budgie_tab_switcher_window_construct (BUDGIE_TYPE_TAB_SWITCHER_WINDOW);
}

/**
* Monitors changed, find out the primary monitor, and schedule move of OSD
*/
static void
budgie_tab_switcher_window_on_monitors_changed (BudgieTabSwitcherWindow* self)
{
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkMonitor* _tmp3_;
	GdkMonitor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_display (_tmp1_);
	_tmp3_ = gdk_display_get_primary_monitor (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->primary_monitor);
	self->priv->primary_monitor = _tmp4_;
	budgie_tab_switcher_window_move_switcher (self);
}

/**
* Move the SWITCHER into the correct position
*/
void
budgie_tab_switcher_window_move_switcher (BudgieTabSwitcherWindow* self)
{
	GdkRectangle bounds = {0};
	GdkMonitor* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GtkAllocation alloc = {0};
	GtkWidget* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	gint x = 0;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GtkAllocation _tmp6_;
	gint y = 0;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GtkAllocation _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_monitor;
	gdk_monitor_get_geometry (_tmp0_, &_tmp1_);
	bounds = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_get_allocation (_tmp2_, &_tmp3_);
	alloc = _tmp3_;
	_tmp4_ = bounds;
	_tmp5_ = bounds;
	_tmp6_ = alloc;
	x = _tmp4_.x + ((_tmp5_.width / 2) - (_tmp6_.width / 2));
	_tmp7_ = bounds;
	_tmp8_ = bounds;
	_tmp9_ = alloc;
	y = _tmp7_.y + ((_tmp8_.height / 2) - (_tmp9_.height / 2));
	gtk_window_move ((GtkWindow*) self, x, y);
}

void
budgie_tab_switcher_window_add_window (BudgieTabSwitcherWindow* self,
                                       guint32 xid,
                                       guint32 usertime)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	WnckWindow* window = NULL;
	WnckWindow* _tmp2_;
	WnckWindow* _tmp3_;
	GDesktopAppInfo* desktop = NULL;
	BudgieAppSystem* _tmp4_;
	WnckWindow* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	BudgieTabSwitcherWidget* child = NULL;
	WnckWindow* _tmp7_;
	GDesktopAppInfo* _tmp8_;
	BudgieTabSwitcherWidget* _tmp9_;
	GHashTable* _tmp10_;
	BudgieTabSwitcherWidget* _tmp11_;
	BudgieTabSwitcherWidget* _tmp12_;
	guint n_kids = 0U;
	GHashTable* _tmp13_;
	GtkFlowBox* _tmp16_;
	BudgieTabSwitcherWidget* _tmp17_;
	GtkFlowBox* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == TRUE) {
		return;
	}
	window = NULL;
	_tmp2_ = wnck_window_get ((gulong) xid);
	window = _tmp2_;
	_tmp3_ = window;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->app_system;
	_tmp5_ = window;
	_tmp6_ = budgie_app_system_query_window (_tmp4_, _tmp5_);
	desktop = _tmp6_;
	_tmp7_ = window;
	_tmp8_ = desktop;
	_tmp9_ = budgie_tab_switcher_widget_new (_tmp7_, _tmp8_, usertime);
	g_object_ref_sink (_tmp9_);
	child = _tmp9_;
	_tmp10_ = self->priv->xids;
	_tmp11_ = child;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	g_hash_table_insert (_tmp10_, (gpointer) ((guintptr) xid), _tmp12_);
	_tmp13_ = self->priv->xids;
	n_kids = g_hash_table_size (_tmp13_);
	if (n_kids < ((guint) 8)) {
		GtkFlowBox* _tmp14_;
		_tmp14_ = self->priv->window_box;
		gtk_flow_box_set_max_children_per_line (_tmp14_, n_kids);
	} else {
		GtkFlowBox* _tmp15_;
		_tmp15_ = self->priv->window_box;
		gtk_flow_box_set_max_children_per_line (_tmp15_, (guint) 8);
	}
	_tmp16_ = self->priv->window_box;
	_tmp17_ = child;
	gtk_flow_box_insert (_tmp16_, (GtkWidget*) _tmp17_, -1);
	gtk_widget_queue_resize ((GtkWidget*) self);
	_tmp18_ = self->priv->window_box;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_g_object_unref0 (child);
	_g_object_unref0 (desktop);
}

void
budgie_tab_switcher_window_focus_item (BudgieTabSwitcherWindow* self,
                                       guint32 xid)
{
	BudgieTabSwitcherWidget* widget = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieTabSwitcherWidget* _tmp2_;
	BudgieTabSwitcherWidget* _tmp3_;
	GtkLabel* _tmp4_;
	BudgieTabSwitcherWidget* _tmp5_;
	const gchar* _tmp6_;
	GtkFlowBox* _tmp7_;
	BudgieTabSwitcherWidget* _tmp8_;
	GtkContainer* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->xids;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) xid));
	_tmp2_ = _g_object_ref0 ((BudgieTabSwitcherWidget*) _tmp1_);
	widget = _tmp2_;
	_tmp3_ = widget;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (widget);
		return;
	}
	_tmp4_ = self->priv->window_title;
	_tmp5_ = widget;
	_tmp6_ = _tmp5_->title;
	gtk_label_set_text (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->window_box;
	_tmp8_ = widget;
	_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
	gtk_flow_box_select_child (_tmp7_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_flow_box_child_get_type ()) ? ((GtkFlowBoxChild*) _tmp9_) : NULL);
	_g_object_unref0 (widget);
}

static void
budgie_tab_switcher_window_class_init (BudgieTabSwitcherWindowClass * klass,
                                       gpointer klass_data)
{
	budgie_tab_switcher_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieTabSwitcherWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/daemon/tabswitcher.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "window_box", FALSE, BudgieTabSwitcherWindow_private_offset + G_STRUCT_OFFSET (BudgieTabSwitcherWindowPrivate, window_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "window_title", FALSE, BudgieTabSwitcherWindow_private_offset + G_STRUCT_OFFSET (BudgieTabSwitcherWindowPrivate, window_title));
}

static void
budgie_tab_switcher_window_instance_init (BudgieTabSwitcherWindow * self,
                                          gpointer klass)
{
	self->priv = budgie_tab_switcher_window_get_instance_private (self);
	self->priv->xids = NULL;
	self->priv->app_system = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_tab_switcher_window_finalize (GObject * obj)
{
	BudgieTabSwitcherWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER_WINDOW, BudgieTabSwitcherWindow);
	_g_object_unref0 (self->priv->primary_monitor);
	_g_hash_table_unref0 (self->priv->xids);
	_g_object_unref0 (self->priv->app_system);
	G_OBJECT_CLASS (budgie_tab_switcher_window_parent_class)->finalize (obj);
}

/**
*
*/
static GType
budgie_tab_switcher_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcherWindow), 0, (GInstanceInitFunc) budgie_tab_switcher_window_instance_init, NULL };
	GType budgie_tab_switcher_window_type_id;
	budgie_tab_switcher_window_type_id = g_type_register_static (gtk_window_get_type (), "BudgieTabSwitcherWindow", &g_define_type_info, 0);
	BudgieTabSwitcherWindow_private_offset = g_type_add_instance_private (budgie_tab_switcher_window_type_id, sizeof (BudgieTabSwitcherWindowPrivate));
	return budgie_tab_switcher_window_type_id;
}

GType
budgie_tab_switcher_window_get_type (void)
{
	static volatile gsize budgie_tab_switcher_window_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_window_type_id__once)) {
		GType budgie_tab_switcher_window_type_id;
		budgie_tab_switcher_window_type_id = budgie_tab_switcher_window_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_window_type_id__once, budgie_tab_switcher_window_type_id);
	}
	return budgie_tab_switcher_window_type_id__once;
}

static inline gpointer
budgie_tab_switcher_get_instance_private (BudgieTabSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieTabSwitcher_private_offset);
}

BudgieTabSwitcher*
budgie_tab_switcher_construct (GType object_type)
{
	BudgieTabSwitcher * self = NULL;
	BudgieTabSwitcherWindow* _tmp0_;
	self = (BudgieTabSwitcher*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_tab_switcher_window_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->switcher_window);
	self->priv->switcher_window = _tmp0_;
	return self;
}

BudgieTabSwitcher*
budgie_tab_switcher_new (void)
{
	return budgie_tab_switcher_construct (BUDGIE_TYPE_TAB_SWITCHER);
}

/**
* Own the SWITCHER_DBUS_NAME
*/
static void
_budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             gpointer self)
{
	budgie_tab_switcher_on_bus_acquired ((BudgieTabSwitcher*) self, connection);
}

static void
__lambda20_ (BudgieTabSwitcher* self)
{
}

static void
___lambda20__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda20_ ((BudgieTabSwitcher*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

void
budgie_tab_switcher_setup_dbus (BudgieTabSwitcher* self,
                                gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_SWITCHER_DBUS_NAME, flags, (GClosure*) ((_budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_tab_switcher_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda20__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda20__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
}

/**
* Acquired SWITCHER_DBUS_NAME, register ourselves on the bus
*/
static void
budgie_tab_switcher_on_bus_acquired (BudgieTabSwitcher* self,
                                     GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_tab_switcher_register_object (self, conn, BUDGIE_SWITCHER_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering TabSwitcher: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	budgie_setup = TRUE;
}

/**
* Add items to the SWITCHER with parameters:
* id: uint32 xid of the item
* title: string title of the window
*/
void
budgie_tab_switcher_PassItem (BudgieTabSwitcher* self,
                              guint32 id,
                              guint32 usertime,
                              GError** error)
{
	BudgieTabSwitcherWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_window;
	budgie_tab_switcher_window_add_window (_tmp0_, id, usertime);
}

/**
* Show the SWITCHER on screen with the given parameters:
* curr_xid: uint32 xid of the item to select
*/
void
budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                  guint32 curr_xid,
                                  GError** error)
{
	BudgieTabSwitcherWindow* _tmp0_;
	BudgieTabSwitcherWindow* _tmp1_;
	BudgieTabSwitcherWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	budgie_tab_switcher_add_mod_key_watcher (self);
	_tmp0_ = self->priv->switcher_window;
	budgie_tab_switcher_window_move_switcher (_tmp0_);
	_tmp1_ = self->priv->switcher_window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->switcher_window;
	budgie_tab_switcher_window_focus_item (_tmp2_, curr_xid);
}

void
budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                  GError** error)
{
	BudgieTabSwitcherWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->switcher_window;
	budgie_tab_switcher_window_stop_switching (_tmp0_);
}

static void
budgie_tab_switcher_add_mod_key_watcher (BudgieTabSwitcher* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->mod_timeout != ((guint32) 0)) {
		g_source_remove ((guint) self->priv->mod_timeout);
		self->priv->mod_timeout = (guint32) 0;
	}
	self->priv->mod_timeout = (guint32) g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUDGIE_SWITCHER_MOD_EXPIRE_TIME, (GSourceFunc) budgie_tab_switcher_check_mod_key, g_object_ref (self), g_object_unref);
}

static gboolean
budgie_tab_switcher_check_mod_key (BudgieTabSwitcher* self)
{
	GdkModifierType modifier = 0U;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkDevice* _tmp2_;
	GdkWindow* _tmp3_;
	GdkModifierType _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->mod_timeout = (guint32) 0;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = gdk_seat_get_pointer (_tmp1_);
	_tmp3_ = gdk_get_default_root_window ();
	gdk_device_get_state (_tmp2_, _tmp3_, NULL, &_tmp4_);
	modifier = _tmp4_;
	if ((modifier & GDK_MOD1_MASK) == 0) {
		_tmp7_ = (modifier & GDK_MOD3_MASK) == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = (modifier & GDK_MOD4_MASK) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = (modifier & GDK_CONTROL_MASK) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		BudgieTabSwitcherWindow* _tmp8_;
		_tmp8_ = self->priv->switcher_window;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
budgie_tab_switcher_class_init (BudgieTabSwitcherClass * klass,
                                gpointer klass_data)
{
	budgie_tab_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieTabSwitcher_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_tab_switcher_finalize;
}

static void
budgie_tab_switcher_instance_init (BudgieTabSwitcher * self,
                                   gpointer klass)
{
	self->priv = budgie_tab_switcher_get_instance_private (self);
	self->priv->switcher_window = NULL;
	self->priv->mod_timeout = (guint32) 0;
}

static void
budgie_tab_switcher_finalize (GObject * obj)
{
	BudgieTabSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TAB_SWITCHER, BudgieTabSwitcher);
	_g_object_unref0 (self->priv->switcher_window);
	G_OBJECT_CLASS (budgie_tab_switcher_parent_class)->finalize (obj);
}

/**
* TabSwitcher is responsible for managing the BudgieSwitcher over d-bus, receiving
* requests, for example, from budgie-wm
*/
static GType
budgie_tab_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieTabSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_tab_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieTabSwitcher), 0, (GInstanceInitFunc) budgie_tab_switcher_instance_init, NULL };
	GType budgie_tab_switcher_type_id;
	budgie_tab_switcher_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieTabSwitcher", &g_define_type_info, 0);
	g_type_set_qdata (budgie_tab_switcher_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_tab_switcher_register_object);
	BudgieTabSwitcher_private_offset = g_type_add_instance_private (budgie_tab_switcher_type_id, sizeof (BudgieTabSwitcherPrivate));
	return budgie_tab_switcher_type_id;
}

GType
budgie_tab_switcher_get_type (void)
{
	static volatile gsize budgie_tab_switcher_type_id__once = 0;
	if (g_once_init_enter (&budgie_tab_switcher_type_id__once)) {
		GType budgie_tab_switcher_type_id;
		budgie_tab_switcher_type_id = budgie_tab_switcher_get_type_once ();
		g_once_init_leave (&budgie_tab_switcher_type_id__once, budgie_tab_switcher_type_id);
	}
	return budgie_tab_switcher_type_id__once;
}

static void
_dbus_budgie_tab_switcher_PassItem (BudgieTabSwitcher* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 id = 0U;
	GVariant* _tmp46_;
	guint32 usertime = 0U;
	GVariant* _tmp47_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_get_uint32 (_tmp46_);
	g_variant_unref (_tmp46_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	usertime = g_variant_get_uint32 (_tmp47_);
	g_variant_unref (_tmp47_);
	budgie_tab_switcher_PassItem (self, id, usertime, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_tab_switcher_ShowSwitcher (BudgieTabSwitcher* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 curr_xid = 0U;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	curr_xid = g_variant_get_uint32 (_tmp48_);
	g_variant_unref (_tmp48_);
	budgie_tab_switcher_ShowSwitcher (self, curr_xid, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_tab_switcher_StopSwitcher (BudgieTabSwitcher* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_tab_switcher_StopSwitcher (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_tab_switcher_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PassItem") == 0) {
		_dbus_budgie_tab_switcher_PassItem (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowSwitcher") == 0) {
		_dbus_budgie_tab_switcher_ShowSwitcher (object, parameters, invocation);
	} else if (strcmp (method_name, "StopSwitcher") == 0) {
		_dbus_budgie_tab_switcher_StopSwitcher (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_tab_switcher_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_tab_switcher_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_tab_switcher_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_tab_switcher_dbus_interface_info), &_budgie_tab_switcher_dbus_interface_vtable, data, _budgie_tab_switcher_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_tab_switcher_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

