/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.ScrollThread;
import net.sf.freecol.common.model.Direction;

public class AbstractCanvasListener
extends FreeColClientHolder {
    protected static final int AUTO_SCROLL_SPACE = 4;
    private static final int DRAG_SCROLL_SPACE = 100;
    private static volatile ScrollThread scrollThread = null;
    private static volatile Object scrollThreadLock = new Object();

    protected AbstractCanvasListener(FreeColClient freeColClient) {
        super(freeColClient);
    }

    protected void performAutoScrollIfActive(MouseEvent e, boolean ignoreTop) {
        if (e.getComponent().isEnabled() && this.getClientOptions().getBoolean("model.option.autoScroll")) {
            this.scroll(e.getX(), e.getY(), 4, ignoreTop);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    protected void performDragScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            this.scroll(e.getX(), e.getY(), 100, false);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopScrollIfScrollIsActive() {
        if (scrollThread != null) {
            Object object = scrollThreadLock;
            synchronized (object) {
                scrollThread.abort();
                scrollThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(int x, int y, int scrollSpace, boolean ignoreTop) {
        Direction direction = this.getGUI().getScrollDirection(x, y, scrollSpace, ignoreTop);
        if (direction == null) {
            this.stopScrollIfScrollIsActive();
        }
        Object object = scrollThreadLock;
        synchronized (object) {
            if (scrollThread != null && !scrollThread.isAborted()) {
                scrollThread.setDirection(direction);
                return;
            }
            this.stopScrollIfScrollIsActive();
            scrollThread = new ScrollThread(this.getFreeColClient());
            scrollThread.setDirection(direction);
            scrollThread.start();
        }
    }
}

