/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.StringTemplate;

public final class ErrorPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ErrorPanel.class.getName());
    private static final String SHOW = "show";
    private static final int columnWidth = 40;

    public ErrorPanel(FreeColClient freeColClient, String message) {
        super(freeColClient, null, new MigLayout());
        JButton showButton = Utility.localizedButton(StringTemplate.template("errorPanel.showLogFile").addName("%path%", FreeColDirectories.getLogFilePath()));
        showButton.setActionCommand(SHOW);
        showButton.addActionListener(this);
        this.add((Component)Utility.getDefaultTextArea(message, 40), "wrap 20");
        this.add((Component)this.okButton, "split 2, tag ok");
        this.add(showButton);
    }

    public ErrorPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout());
        String message = FreeColDirectories.getLogFileContents();
        if (message == null) {
            message = Messages.message("errorPanel.loadError");
        }
        JTextArea textArea = Utility.getDefaultTextArea(message, 40);
        textArea.setFocusable(true);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        this.add((Component)scrollPane, "height 200:200:, wrap 20");
        this.add((Component)this.okButton, "tag ok");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (SHOW.equals(command)) {
            this.getGUI().showLogFilePanel();
        } else {
            super.actionPerformed(ae);
        }
    }
}

