/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class OptimadeReader
extends AtomSetCollectionReader {
    private int modelNo;
    private boolean iHaveDesiredModel;
    private float[] dimensionType;
    private float ndims;
    private boolean isPolymer;
    private boolean isSlab;
    private float[] xyz = new float[3];

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        SB sb = new SB();
        try {
            while (this.rd() != null) {
                sb.append(this.line);
            }
            Map<String, Object> json = this.vwr.parseJSONMap(sb.toString());
            List aData = (List)json.get("data");
            if (aData != null) {
                for (int i = 0; !this.iHaveDesiredModel && i < aData.size(); ++i) {
                    Map data = (Map)aData.get(i);
                    if (!"structures".equals(data.get("type"))) continue;
                    this.readModel((Map)data.get("attributes"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void readModel(Map<String, Object> map) throws Exception {
        this.modelNumber = ++this.modelNo;
        if (!this.doGetModel(this.modelNo, null)) {
            return;
        }
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setFractionalCoordinates(false);
        this.dimensionType = new float[3];
        OptimadeReader.toFloatArray((List)map.get("dimension_types"), this.dimensionType);
        if (!this.checkDimensionType()) {
            throw new IllegalArgumentException("OptimadeReader does not support dimentionType " + this.dimensionType[0] + " " + this.dimensionType[1] + " " + this.dimensionType[2]);
        }
        if (!this.isMolecular) {
            this.setSpaceGroupName("P1");
            this.asc.setInfo("symmetryType", this.isSlab ? "2D - SLAB" : (this.isPolymer ? "1D - POLYMER" : "3D"));
        }
        this.asc.setAtomSetName((String)map.get("chemical_formula_descriptive"));
        this.doConvertToFractional = !this.isMolecular && this.readLattice((List)map.get("lattice_vectors"));
        this.readAtoms((List)map.get("species"), (List)map.get("species_at_sites"), (List)map.get("cartesian_site_positions"));
    }

    private boolean checkDimensionType() {
        float[] dt = this.dimensionType;
        this.isMolecular = false;
        this.isSlab = false;
        this.isPolymer = false;
        this.ndims = dt[0] + dt[1] + dt[2];
        return this.ndims == 3.0f || (this.isMolecular = this.ndims == 0.0f) || (this.isSlab = dt[0] + dt[1] == 2.0f) || (this.isPolymer = dt[0] == 1.0f);
    }

    private boolean readLattice(List<Object> lattice) {
        if (lattice == null) {
            return false;
        }
        float[] abc = new float[3];
        P3[] vabc = new P3[3];
        for (int i = 0; i < 3; ++i) {
            if (!OptimadeReader.toFloatArray((List)lattice.get(i), this.xyz)) {
                return false;
            }
            this.unitCellParams[0] = Float.NaN;
            if (this.isSlab || this.isPolymer) {
                vabc[i] = P3.new3(this.xyz[0], this.xyz[1], this.xyz[2]);
                abc[i] = vabc[i].length();
            }
            if (i == 2 && (this.isSlab || this.isPolymer)) {
                this.unitCellParams[0] = abc[0];
                if (this.isSlab) {
                    this.unitCellParams[1] = abc[1];
                }
            }
            this.addExplicitLatticeVector(i, this.xyz, 0);
        }
        this.doApplySymmetry = true;
        return true;
    }

    private void readAtoms(List<Object> species, List<Object> sites, List<Object> coords) {
        int natoms = sites.size();
        HashMap<String, Map> speciesByName = new HashMap<String, Map>();
        int i = species.size();
        while (--i >= 0) {
            Map s = (Map)species.get(i);
            speciesByName.put((String)s.get("name"), s);
        }
        for (i = 0; i < natoms; ++i) {
            String sname = (String)sites.get(i);
            OptimadeReader.toFloatArray((List)coords.get(i), this.xyz);
            Map sp = (Map)speciesByName.get(sname);
            List syms = (List)sp.get("chemical_symbols");
            int nOcc = syms.size();
            if (nOcc > 1) {
                float[] conc = new float[nOcc];
                OptimadeReader.toFloatArray((List)sp.get("concentration"), conc);
                for (int j = 0; j < conc.length; ++j) {
                    Atom a = this.addAtom(this.xyz, (String)syms.get(j), sname);
                    a.foccupancy = conc[j];
                }
                continue;
            }
            this.addAtom(this.xyz, (String)syms.get(0), sname);
        }
    }

    private Atom addAtom(float[] xyz, String sym, String name) {
        Atom atom = this.asc.addNewAtom();
        if (sym != null) {
            atom.elementSymbol = sym;
        }
        if (name != null) {
            atom.atomName = name;
        }
        this.setAtomCoordXYZ(atom, xyz[0], xyz[1], xyz[2]);
        return atom;
    }

    private static boolean toFloatArray(List<Number> list, float[] a) {
        int i = a.length;
        while (--i >= 0) {
            Number d = list.get(i);
            if (d == null) {
                return false;
            }
            a[i] = list.get(i).floatValue();
        }
        return true;
    }

    @Override
    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
        super.finalizeSubclassSymmetry(haveSymmetry);
    }
}

