/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.MeshCapper;
import org.jmol.util.MeshSurface;

public class MeshSlicer {
    protected MeshSurface m;
    private boolean doCap;
    private boolean doClear;
    private boolean doGhost;
    private int iD;
    private int iE;
    private int[] sources;
    private P3[] pts;
    V3 norm;
    private float dPlane;
    float[] values;
    float[] fracs;
    private MeshCapper capper;
    private float wPlane;

    MeshSlicer set(MeshSurface meshSurface) {
        this.m = meshSurface;
        this.values = new float[2];
        this.fracs = new float[2];
        this.sources = new int[3];
        return this;
    }

    public boolean slabPolygons(Object[] slabObject, boolean allowCap) {
        SB sb;
        MeshSurface m;
        block34: {
            boolean isGhost;
            boolean andCap;
            if (this.m.polygonCount0 < 0) {
                return false;
            }
            m = this.m;
            int slabType = (Integer)slabObject[0];
            if (slabType == 1073742333 || slabType == 0x40000030) {
                if (m.bsSlabDisplay != null && (m.polygonCount0 != 0 || m.vertexCount0 != 0)) {
                    m.pc = m.polygonCount0;
                    m.vc = m.vertexCount0;
                    m.vertexCount0 = 0;
                    m.polygonCount0 = 0;
                    m.normixCount = m.isDrawPolygon ? m.pc : m.vc;
                    m.bsSlabDisplay.setBits(0, m.pc == 0 ? m.vc : m.pc);
                    m.slabOptions = new SB().append(m.meshType + " slab none");
                    m.bsSlabGhost = null;
                    m.slabMeshType = 1073742333;
                }
                if (slabType == 1073742333) {
                    return false;
                }
            }
            Object slabbingObject = slabObject[1];
            boolean bl = andCap = (Boolean)slabObject[2] != false && slabType != 0x40000030;
            if (andCap && !allowCap) {
                return false;
            }
            Object[] colorData = (Object[])slabObject[3];
            boolean bl2 = isGhost = colorData != null;
            if (m.bsSlabDisplay == null || m.polygonCount0 == 0 && m.vertexCount0 == 0) {
                m.polygonCount0 = m.pc;
                m.vertexCount0 = m.vc;
                m.bsSlabDisplay = BSUtil.setAll(m.pc == 0 ? m.vc : m.pc);
                m.bsSlabGhost = null;
                if (m.pc == 0 && m.vc == 0) {
                    return false;
                }
            } else if (m.isMerged) {
                if (m.pc == 0) {
                    m.bsSlabDisplay.setBits(m.mergeVertexCount0, m.vc);
                } else {
                    m.bsSlabDisplay.setBits(m.mergePolygonCount0, m.pc);
                }
            }
            if (isGhost) {
                if (m.bsSlabGhost == null) {
                    m.bsSlabGhost = new BS();
                }
                m.slabMeshType = (Integer)colorData[0];
                m.slabColix = (Short)colorData[1];
                andCap = false;
                m.colix = C.getColixTranslucent3(m.colix, false, 0.0f);
            }
            sb = new SB();
            sb.append(andCap ? " cap " : " slab ");
            if (isGhost) {
                sb.append(C.getColixTranslucencyLabel(m.slabColix)).append(" ");
                String s = C.getHexCode(m.slabColix);
                if (s != null) {
                    sb.append(s).append(" ");
                }
                if (m.slabMeshType == 1073742018) {
                    sb.append("mesh ");
                }
            }
            block0 : switch (slabType) {
                case 0x40000030: {
                    sb.append("brillouin");
                    this.slabBrillouin((P3[])slabbingObject);
                    break;
                }
                case 3: {
                    this.getIntersection(0.0f, null, null, null, null, (BS)slabbingObject, null, andCap, false, 3, isGhost);
                    break;
                }
                case 134217750: {
                    P4 plane = (P4)slabbingObject;
                    sb.append(Escape.eP4(plane));
                    this.getIntersection(0.0f, plane, null, null, null, null, null, andCap, false, 134217750, isGhost);
                    break;
                }
                case 1678381065: 
                case 1814695966: {
                    T3[] box = (P3[])slabbingObject;
                    sb.append("within ").append(Escape.eAP(box));
                    P4[] faces = this.getBoxFacesFromOABC((P3[])box);
                    for (int i = 0; i < faces.length; ++i) {
                        this.getIntersection(0.0f, faces[i], null, null, null, null, null, andCap, false, 134217750, isGhost);
                    }
                    break;
                }
                case 134221834: {
                    this.getIntersection(0.0f, null, null, null, (float[])slabbingObject, null, null, false, false, 32, isGhost);
                    break;
                }
                case 134217759: 
                case 1073742018: 
                case 1073742114: {
                    Object[] o = (Object[])slabbingObject;
                    float distance = ((Float)o[0]).floatValue();
                    switch (slabType) {
                        case 134217759: {
                            P3[] points = (P3[])o[1];
                            BS bs = (BS)o[2];
                            sb.append("within ").appendF(distance).append(bs == null ? Escape.e(points) : Escape.e(bs));
                            this.getIntersection(distance, null, points, null, null, null, null, andCap, false, 1275069443, isGhost);
                            break block0;
                        }
                        case 1073742114: {
                            if (m.vvs == null) {
                                return false;
                            }
                            float distanceMax = ((Float)o[1]).floatValue();
                            sb.append("within range ").appendF(distance).append(" ").appendF(distanceMax);
                            BS bs = distanceMax < distance ? BSUtil.copy(m.bsSlabDisplay) : null;
                            this.getIntersection(distance, null, null, null, null, null, null, andCap, false, 32, isGhost);
                            BS bsA = bs == null ? null : BSUtil.copy(m.bsSlabDisplay);
                            BSUtil.copy2(bs, m.bsSlabDisplay);
                            this.getIntersection(distanceMax, null, null, null, null, null, null, andCap, false, 64, isGhost);
                            if (bsA != null) {
                                m.bsSlabDisplay.or(bsA);
                                break block0;
                            }
                            break block34;
                        }
                        case 1073742018: {
                            MeshSurface mesh = (MeshSurface)o[1];
                            this.getIntersection(0.0f, null, null, null, null, null, mesh, andCap, false, distance < 0.0f ? 32 : 64, isGhost);
                        }
                    }
                }
            }
        }
        String newOptions = sb.toString();
        if (m.slabOptions == null) {
            m.slabOptions = new SB();
        }
        if (m.slabOptions.indexOf(newOptions) < 0) {
            m.slabOptions.append(m.slabOptions.length() > 0 ? "; " : "").append(m.meshType).append(newOptions);
        }
        return true;
    }

    private P4[] getBoxFacesFromOABC(P3[] oabc) {
        P4[] faces = new P4[6];
        V3 vNorm = new V3();
        V3 vAB = new V3();
        P3 pta = new P3();
        P3 ptb = new P3();
        P3 ptc = new P3();
        P3[] vertices = BoxInfo.getVerticesFromOABC(oabc);
        for (int i = 0; i < 6; ++i) {
            pta.setT(vertices[BoxInfo.facePoints[i][0]]);
            ptb.setT(vertices[BoxInfo.facePoints[i][1]]);
            ptc.setT(vertices[BoxInfo.facePoints[i][2]]);
            faces[i] = Measure.getPlaneThroughPoints(pta, ptb, ptc, vNorm, vAB, new P4());
        }
        return faces;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getIntersection(float distance, P4 plane, P3[] ptCenters, Lst<P3[]> vData, float[] fData, BS bsSource, MeshSurface meshSurface, boolean andCap, boolean doClean, int tokType, boolean isGhost) {
        int i;
        MeshSurface m = this.m;
        boolean isSlab = vData == null;
        P3[] p = null;
        this.pts = ptCenters;
        if (plane != null) {
            this.norm = V3.newV(plane);
            this.dPlane = (float)Math.sqrt(this.norm.dot(this.norm));
            this.wPlane = plane.w;
            if (this.dPlane == 0.0f) {
                this.dPlane = 1.0f;
                this.norm.z = 1.0f;
                this.wPlane = 0.0f;
            }
        }
        if (fData == null) {
            if (tokType == 3 && bsSource != null) {
                if (m.vertexSource == null) {
                    return;
                }
                fData = new float[m.vc];
                for (i = 0; i < m.vc; ++i) {
                    fData[i] = m.vertexSource[i];
                    if (fData[i] != -1.0f) continue;
                    System.out.println("meshsurface hmm");
                }
            } else {
                fData = m.vvs;
            }
        }
        if (m.pc == 0) {
            i = m.mergeVertexCount0;
            while (true) {
                if (i >= m.vc) {
                    return;
                }
                if (Float.isNaN(fData[i]) || this.checkSlab(tokType, m.vs[i], fData[i], distance, bsSource) > 0.0f) {
                    m.bsSlabDisplay.clear(i);
                }
                ++i;
            }
        }
        if (ptCenters != null || isGhost) {
            andCap = false;
        }
        if (andCap && this.capper == null) {
            this.capper = ((MeshCapper)Interface.getInterface("org.jmol.util.MeshCapper", m.vwr, "script")).set(this);
        }
        if (this.capper != null) {
            this.capper.clear();
        }
        double absD = Math.abs(distance);
        Hashtable<String, Integer> mapEdge = new Hashtable<String, Integer>();
        BS bsD = BS.newN(m.vc);
        float[] d = new float[m.vc];
        float d1 = 0.0f;
        float d2 = 0.0f;
        float d3 = 0.0f;
        int iLast = m.pc;
        block14: for (int i2 = m.mergePolygonCount0; i2 < iLast; ++i2) {
            int[] face = m.setABC(i2);
            if (face == null) continue;
            BS bsSlab = m.bsSlabGhost != null && m.bsSlabGhost.get(i2) ? m.bsSlabGhost : m.bsSlabDisplay;
            int check1 = face[3];
            int iContour = m.dataOnly ? 0 : face[4];
            int ia = m.iA;
            int ib = m.iB;
            int ic = m.iC;
            T3 vA = m.vs[ia];
            T3 vB = m.vs[ib];
            T3 vC = m.vs[ic];
            float valA = fData[ia];
            float valB = fData[ib];
            float valC = fData[ic];
            if (m.vertexSource != null) {
                this.sources[0] = m.vertexSource[ia];
                this.sources[1] = m.vertexSource[ib];
                this.sources[2] = m.vertexSource[ic];
            }
            if (!bsD.get(ia)) {
                bsD.set(ia);
                d[ia] = this.checkSlab(tokType, vA, valA, bsSource == null ? distance : (float)this.sources[0], bsSource);
            }
            if (!bsD.get(ib)) {
                bsD.set(ib);
                d[ib] = this.checkSlab(tokType, vB, valB, bsSource == null ? distance : (float)this.sources[1], bsSource);
            }
            if (!bsD.get(ic)) {
                bsD.set(ic);
                d[ic] = this.checkSlab(tokType, vC, valC, bsSource == null ? distance : (float)this.sources[2], bsSource);
            }
            d1 = d[ia];
            d2 = d[ib];
            d3 = d[ic];
            int test1 = (d1 != 0.0f && d1 < 0.0f ? 1 : 0) + (d2 != 0.0f && d2 < 0.0f ? 2 : 0) + (d3 != 0.0f && d3 < 0.0f ? 4 : 0);
            int thisSet = m.vertexSets == null ? 0 : m.vertexSets[ia];
            switch (test1) {
                default: {
                    break;
                }
                case 1: 
                case 6: {
                    if (ptCenters == null) {
                        p = new P3[]{this.interpolatePoint(vA, vB, -d1, d2, valA, valB, 0), this.interpolatePoint(vA, vC, -d1, d3, valA, valC, 1)};
                        break;
                    }
                    p = new P3[]{this.interpolateSphere(vA, vB, -d1, -d2, absD, valA, valB, 0), this.interpolateSphere(vA, vC, -d1, -d3, absD, valA, valC, 1)};
                    break;
                }
                case 2: 
                case 5: {
                    if (ptCenters == null) {
                        p = new P3[]{this.interpolatePoint(vB, vA, -d2, d1, valB, valA, 1), this.interpolatePoint(vB, vC, -d2, d3, valB, valC, 0)};
                        break;
                    }
                    p = new P3[]{this.interpolateSphere(vB, vA, -d2, -d1, absD, valB, valA, 1), this.interpolateSphere(vB, vC, -d2, -d3, absD, valB, valC, 0)};
                    break;
                }
                case 3: 
                case 4: {
                    p = ptCenters == null ? new P3[]{this.interpolatePoint(vC, vA, -d3, d1, valC, valA, 0), this.interpolatePoint(vC, vB, -d3, d2, valC, valB, 1)} : new P3[]{this.interpolateSphere(vC, vA, -d3, -d1, absD, valC, valA, 0), this.interpolateSphere(vC, vB, -d3, -d2, absD, valC, valB, 1)};
                }
            }
            this.doClear = true;
            this.doGhost = isGhost;
            this.doCap = andCap;
            if (isSlab) {
                switch (test1) {
                    case 0: {
                        this.doCap = false;
                        break;
                    }
                    case 7: {
                        continue block14;
                    }
                    case 1: 
                    case 6: {
                        BS bs;
                        boolean tossBC;
                        boolean bl = tossBC = test1 == 1;
                        if (tossBC || isGhost) {
                            if (!this.getDE(this.fracs, 0, ia, ib, ic, tossBC)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p[0], this.values[0], this.sources[0], thisSet, mapEdge, ia, ib);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p[1], this.values[1], this.sources[0], thisSet, mapEdge, ia, ic);
                            }
                            bs = tossBC ? bsSlab : m.bsSlabGhost;
                            m.addPolygonV3(ia, this.iD, this.iE, check1 & 5 | 2, iContour, 0, bs);
                            if (!isGhost) break;
                        }
                        if (!this.getDE(this.fracs, 1, ia, ic, ib, tossBC)) break;
                        BS bS = bs = tossBC ? m.bsSlabGhost : bsSlab;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(p[0], this.values[0], this.sources[1], thisSet, mapEdge, ia, ib);
                            m.addPolygonV3(this.iE, ib, ic, check1 & 3, iContour, 0, bs);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(p[1], this.values[1], this.sources[2], thisSet, mapEdge, ia, ic);
                        m.addPolygonV3(this.iD, this.iE, ic, check1 & 4 | 1, iContour, 0, bs);
                        break;
                    }
                    case 2: 
                    case 5: {
                        boolean tossAC;
                        BS bs;
                        boolean bl = tossAC = test1 == 2;
                        if (tossAC || isGhost) {
                            if (!this.getDE(this.fracs, 0, ib, ic, ia, tossAC)) break;
                            BS bS = bs = tossAC ? bsSlab : m.bsSlabGhost;
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p[0], this.values[0], this.sources[1], thisSet, mapEdge, ib, ia);
                            }
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p[1], this.values[1], this.sources[1], thisSet, mapEdge, ib, ic);
                            }
                            m.addPolygonV3(this.iE, ib, this.iD, check1 & 3 | 4, iContour, 0, bs);
                            if (!isGhost) break;
                        }
                        if (!this.getDE(this.fracs, 1, ib, ia, ic, tossAC)) break;
                        BS bS = bs = tossAC ? m.bsSlabGhost : bsSlab;
                        if (this.iD < 0) {
                            this.iD = this.addIntersectionVertex(p[0], this.values[0], this.sources[0], thisSet, mapEdge, ib, ia);
                            m.addPolygonV3(ia, this.iD, ic, check1 & 5, iContour, 0, bs);
                        }
                        if (this.iE >= 0) break;
                        this.iE = this.addIntersectionVertex(p[1], this.values[1], this.sources[2], thisSet, mapEdge, ib, ic);
                        m.addPolygonV3(this.iD, this.iE, ic, check1 & 2 | 1, iContour, 0, bs);
                        break;
                    }
                    case 3: 
                    case 4: {
                        boolean tossAB;
                        BS bs;
                        boolean bl = tossAB = test1 == 4;
                        if (tossAB || isGhost) {
                            if (!this.getDE(this.fracs, 0, ic, ia, ib, tossAB)) break;
                            if (this.iD < 0) {
                                this.iD = this.addIntersectionVertex(p[0], this.values[0], this.sources[2], thisSet, mapEdge, ia, ic);
                            }
                            if (this.iE < 0) {
                                this.iE = this.addIntersectionVertex(p[1], this.values[1], this.sources[2], thisSet, mapEdge, ib, ic);
                            }
                            bs = tossAB ? bsSlab : m.bsSlabGhost;
                            m.addPolygonV3(this.iD, this.iE, ic, check1 & 6 | 1, iContour, 0, bs);
                            if (!isGhost) break;
                        }
                        if (!this.getDE(this.fracs, 1, ic, ib, ia, tossAB)) break;
                        BS bS = bs = tossAB ? m.bsSlabGhost : bsSlab;
                        if (this.iE < 0) {
                            this.iE = this.addIntersectionVertex(p[0], this.values[0], this.sources[0], thisSet, mapEdge, ia, ic);
                            m.addPolygonV3(ia, ib, this.iE, check1 & 5, iContour, 0, bs);
                        }
                        if (this.iD >= 0) break;
                        this.iD = this.addIntersectionVertex(p[1], this.values[1], this.sources[1], thisSet, mapEdge, ib, ic);
                        m.addPolygonV3(this.iE, ib, this.iD, check1 & 2 | 4, iContour, 0, bs);
                    }
                }
                if (this.doClear) {
                    bsSlab.clear(i2);
                    if (this.doGhost) {
                        m.bsSlabGhost.set(i2);
                    }
                }
                if (!this.doCap) continue;
                this.capper.addEdge(this.iE, this.iD, thisSet);
                continue;
            }
            if (p == null) continue;
            vData.addLast(p);
        }
        if (andCap) {
            this.capper.createCap(this.norm);
        }
        if (!doClean) {
            return;
        }
        BS bsv = new BS();
        BS bsp = new BS();
        for (int i3 = 0; i3 < m.pc; ++i3) {
            if (m.pis[i3] == null) continue;
            bsp.set(i3);
            for (int j = 0; j < 3; ++j) {
                bsv.set(m.pis[i3][j]);
            }
        }
        int n = 0;
        int nPoly = bsp.cardinality();
        if (nPoly == m.pc) return;
        int[] map = new int[m.vc];
        for (int i4 = 0; i4 < m.vc; ++i4) {
            if (!bsv.get(i4)) continue;
            map[i4] = n++;
        }
        P3[] vTemp = new P3[n];
        n = 0;
        for (int i5 = 0; i5 < m.vc; ++i5) {
            if (!bsv.get(i5)) continue;
            vTemp[n++] = m.vs[i5];
        }
        int[][] pTemp = AU.newInt2(nPoly);
        nPoly = 0;
        int i6 = 0;
        while (true) {
            if (i6 >= m.pc) {
                m.vs = vTemp;
                m.vc = n;
                m.pis = pTemp;
                m.pc = nPoly;
                return;
            }
            if (m.pis[i6] != null) {
                for (int j = 0; j < 3; ++j) {
                    m.pis[i6][j] = map[m.pis[i6][j]];
                }
                pTemp[nPoly++] = m.pis[i6];
            }
            ++i6;
        }
    }

    private boolean getDE(float[] fracs, int fD, int i1, int i2, int i3, boolean toss23) {
        this.iD = MeshSlicer.setPoint(fracs, fD, i1, i2);
        this.iE = MeshSlicer.setPoint(fracs, 1 - fD, i1, i3);
        if (this.iD == i1 && this.iE == i1) {
            this.doClear = toss23;
            this.doCap = false;
            return false;
        }
        if (this.iD == i2 && this.iE == i3) {
            this.doClear = !toss23;
            return !this.doClear;
        }
        if (this.iD == i1 || this.iE == i1) {
            this.doClear = toss23;
            if (this.iD < 0) {
                this.iD = toss23 ? i2 : i3;
            } else if (this.iE < 0) {
                this.iE = toss23 ? i3 : i2;
            }
            return this.doCap;
        }
        this.doGhost = false;
        return true;
    }

    private static int setPoint(float[] fracs, int i, int i0, int i1) {
        return fracs[i] == 0.0f ? i0 : (fracs[i] == 1.0f ? i1 : -1);
    }

    private float checkSlab(int tokType, T3 v, float val, float distance, BS bs) {
        float d;
        switch (tokType) {
            case 3: {
                return val >= 0.0f && bs.get((int)val) ? 1 : -1;
            }
            case 32: {
                d = distance - val;
                break;
            }
            case 64: {
                d = val - distance;
                break;
            }
            case 134217750: {
                d = (v.dot(this.norm) + this.wPlane) / this.dPlane;
                break;
            }
            default: {
                float dmin = 2.1474836E9f;
                int i = this.pts.length;
                while (--i >= 0) {
                    d = this.pts[i].distance(v);
                    if (!(d < dmin)) continue;
                    dmin = d;
                }
                d = distance > 0.0f ? dmin - distance : -distance - dmin;
            }
        }
        return Math.abs(d) < 1.0E-4f ? 0.0f : d;
    }

    private P3 interpolateSphere(T3 v1, T3 v2, float d1, float d2, double absD, float val1, float val2, int i) {
        return this.interpolateFraction(v1, v2, MeshSurface.getSphericalInterpolationFraction(absD, d1, d2, v1.distance(v2)), val1, val2, i);
    }

    private P3 interpolatePoint(T3 v1, T3 v2, float d1, float d2, float val1, float val2, int i) {
        return this.interpolateFraction(v1, v2, d1 / (d1 + d2), val1, val2, i);
    }

    private P3 interpolateFraction(T3 v1, T3 v2, float f, float val1, float val2, int i) {
        if ((double)f < 1.0E-4) {
            f = 0.0f;
        } else if ((double)f > 0.9999) {
            f = 1.0f;
        }
        this.fracs[i] = f;
        this.values[i] = (val2 - val1) * f + val1;
        return P3.new3(v1.x + (v2.x - v1.x) * f, v1.y + (v2.y - v1.y) * f, v1.z + (v2.z - v1.z) * f);
    }

    protected void slabBrillouin(P3[] unitCellPoints) {
        T3[] vectors;
        MeshSurface m = this.m;
        T3[] t3Array = vectors = unitCellPoints == null ? m.oabc : unitCellPoints;
        if (vectors == null) {
            return;
        }
        P3[] pts = new P3[27];
        pts[0] = P3.newP(vectors[0]);
        int pt = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    pts[++pt] = P3.newP(pts[0]);
                    pts[pt].scaleAdd2(i, vectors[1], pts[pt]);
                    pts[pt].scaleAdd2(j, vectors[2], pts[pt]);
                    pts[pt].scaleAdd2(k, vectors[3], pts[pt]);
                }
            }
        }
        P3 ptTemp = new P3();
        P4 planeGammaK = new P4();
        V3 vGammaToKPoint = new V3();
        V3 vTemp = new V3();
        BS bsMoved = new BS();
        Hashtable<String, Integer> mapEdge = new Hashtable<String, Integer>();
        m.bsSlabGhost = new BS();
        for (int i = 1; i < 27; ++i) {
            vGammaToKPoint.setT(pts[i]);
            Measure.getBisectingPlane(pts[0], vGammaToKPoint, ptTemp, vTemp, planeGammaK);
            this.getIntersection(1.0f, planeGammaK, null, null, null, null, null, false, false, 134217750, true);
            bsMoved.clearAll();
            mapEdge.clear();
            int j = m.bsSlabGhost.nextSetBit(0);
            while (j >= 0) {
                if (m.setABC(j) != null) {
                    int k;
                    int[] p = AU.arrayCopyRangeI(m.pis[j], 0, -1);
                    for (k = 0; k < 3; ++k) {
                        int pk = p[k];
                        p[k] = this.addIntersectionVertex(m.vs[pk], m.vvs[pk], m.vertexSource == null ? 0 : m.vertexSource[pk], m.vertexSets == null ? 0 : m.vertexSets[pk], mapEdge, 0, pk);
                        if (pk == p[k] || !bsMoved.get(pk)) continue;
                        bsMoved.set(p[k]);
                    }
                    m.addPolygon(p, m.bsSlabDisplay);
                    for (k = 0; k < 3; ++k) {
                        if (bsMoved.get(p[k])) continue;
                        bsMoved.set(p[k]);
                        m.vs[p[k]].sub(vGammaToKPoint);
                    }
                }
                j = m.bsSlabGhost.nextSetBit(j + 1);
            }
            if (m.bsSlabGhost.nextSetBit(0) < 0) continue;
            m.bsSlabGhost.clearAll();
            i = 0;
        }
        m.bsSlabGhost = null;
        BoxInfo bi = new BoxInfo();
        if (m.pc == 0) {
            int i = m.vc;
            while (--i >= 0) {
                bi.addBoundBoxPoint(m.vs[i]);
            }
        } else {
            BS bsDone = new BS();
            int i = m.pc;
            while (--i >= 0) {
                int[] f = m.setABC(i);
                if (f == null) continue;
                int j = 3;
                while (--j >= 0) {
                    if (bsDone.get(f[j])) continue;
                    bi.addBoundBoxPoint(m.vs[f[j]]);
                    bsDone.set(f[j]);
                }
            }
        }
        m.setBoundingBox(bi.getBoundBoxPoints(false));
    }

    int addIntersectionVertex(T3 vertex, float value, int source, int set, Map<String, Integer> mapEdge, int i1, int i2) {
        Integer v;
        String key = this.getKey(i1, i2);
        if (key.length() > 0 && (v = mapEdge.get(key)) != null) {
            return v;
        }
        if (this.m.vertexSource != null) {
            if (this.m.vc >= this.m.vertexSource.length) {
                this.m.vertexSource = AU.doubleLengthI(this.m.vertexSource);
            }
            this.m.vertexSource[this.m.vc] = source;
        }
        if (this.m.vertexSets != null) {
            if (this.m.vc >= this.m.vertexSets.length) {
                this.m.vertexSets = AU.doubleLengthI(this.m.vertexSets);
            }
            this.m.vertexSets[this.m.vc] = set;
        }
        int i = this.m.addVCVal(vertex, value, true);
        if (key.length() > 0) {
            mapEdge.put(key, i);
        }
        return i;
    }

    String getKey(int i1, int i2) {
        return i1 < 0 ? "" : (i1 > i2 ? i2 + "_" + i1 : i1 + "_" + i2);
    }

    void addTriangle(int ipt1, int ipt2, int ipt3) {
        this.m.addPolygonV3(ipt1, ipt2, ipt3, 0, 0, 0, this.m.bsSlabDisplay);
    }
}

