/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.util.function.IntSupplier;
import org.openstreetmap.josm.data.preferences.AbstractProperty;

public interface DownloadSourceSizingPolicy {
    public int getComponentHeight();

    public boolean isHeightAdjustable();

    default public void storeHeight(int height) {
        throw new UnsupportedOperationException("Setting the height is not supported for " + this.getClass().getCanonicalName());
    }

    public static class AdjustableDownloadSizePolicy
    implements DownloadSourceSizingPolicy {
        private final AbstractProperty<Integer> preference;
        private final IntSupplier minHeight;

        public AdjustableDownloadSizePolicy(AbstractProperty<Integer> preference) {
            this(preference, () -> 1);
        }

        public AdjustableDownloadSizePolicy(AbstractProperty<Integer> preference, IntSupplier minHeight) {
            this.preference = preference;
            this.minHeight = minHeight;
        }

        @Override
        public int getComponentHeight() {
            int computedMinHeight = this.minHeight.getAsInt();
            if (computedMinHeight < 0) {
                throw new IllegalStateException("Illegal minimum component height:" + computedMinHeight);
            }
            return Math.max(computedMinHeight, this.preference.get());
        }

        @Override
        public boolean isHeightAdjustable() {
            return true;
        }

        @Override
        public void storeHeight(int height) {
            this.preference.put(height);
        }
    }

    public static class FixedDownloadSourceSizePolicy
    implements DownloadSourceSizingPolicy {
        private final Component base;

        public FixedDownloadSourceSizePolicy(Component base) {
            this.base = base;
        }

        @Override
        public int getComponentHeight() {
            return (int)this.base.getPreferredSize().getHeight();
        }

        @Override
        public boolean isHeightAdjustable() {
            return false;
        }
    }
}

