import { Application, NextFunction, Response, Router } from "express";
import { ProvisioningStore } from "./store";
import ProvisioningRequest from "./request";
export interface ProvisioningApiOpts {
    /**
     * Secret token for provisioning requests
     */
    provisioningToken: string;
    /**
     * For widget tokens, use this prefix.
     */
    widgetTokenPrefix?: string;
    /**
     * How long should a widget token last for?
     */
    widgetTokenLifetimeMs?: number;
    /**
     * Where are the files stored for the widget frontend. If undefined, do not host a frontend.
     */
    widgetFrontendLocation?: string;
    /**
     * Provide an existing express app to bind to.
     *
     * Note: start() and close() will no-op when this is used.
     */
    expressApp?: Application;
    /**
     * Prefix to use for the API. E.g. `/api` in `/api/v1/session`
     *
     * Default is `/api`.
     */
    apiPrefix?: string;
}
/**
 * The provisioning API serves two classes of clients:
 *  - Integration managers which provide a unique secret token, and a userId
 *  - Widget users which provide a openId token.
 */
export declare abstract class ProvisioningApi {
    protected store: ProvisioningStore;
    private opts;
    private app;
    private server?;
    protected baseRoute: Router;
    private readonly widgetTokenPrefix;
    private readonly widgetTokenLifetimeMs;
    constructor(store: ProvisioningStore, opts: ProvisioningApiOpts);
    start(port: number, hostname?: string, backlog?: number): void;
    close(): void;
    addRoute(method: "get" | "post" | "delete" | "put", path: string, handler: (req: ProvisioningRequest, res: Response, next: NextFunction) => void | Promise<void>, fnName?: string): void;
    private authenticateRequest;
    private getHealth;
    private getSession;
    private deleteSession;
    private deleteAllSessions;
    private postExchangeOpenId;
}
