/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class YMirror {
    private final double max;

    public YMirror(double max) {
        this.max = max;
    }

    public double getMirrored(double v) {
        if (v < 0.0 || v > this.max) {
            System.err.println("BAD VALUE IN YMirror");
        }
        return this.max - v;
    }

    public Point2D getMirrored(Point2D pt) {
        return new Point2D.Double(pt.getX(), this.max - pt.getY());
    }

    public DotPath getMirrored(DotPath path) {
        DotPath result = new DotPath();
        for (CubicCurve2D.Double bez : path.getBeziers()) {
            result = result.addCurve(this.getMirrored(bez.getP1()), this.getMirrored(bez.getCtrlP1()), this.getMirrored(bez.getCtrlP2()), this.getMirrored(bez.getP2()));
        }
        return result;
    }

    public UTranslate getMirrored(UTranslate tr) {
        return new UTranslate(tr.getDx(), this.max - tr.getDy());
    }
}

