import collections
from _typeshed import Self
from collections.abc import Iterable, Iterator, Mapping
from typing import Any, Generic, TypeVar, overload

_KT = TypeVar("_KT")
_VT = TypeVar("_VT")

class frozendict(Mapping[_KT, _VT], Generic[_KT, _VT]):

    dict_cls: type[dict[Any, Any]] = ...
    @overload
    def __init__(self, **kwargs: _VT) -> None: ...
    @overload
    def __init__(self, mapping: Mapping[_KT, _VT]) -> None: ...
    @overload
    def __init__(self, iterable: Iterable[tuple[_KT, _VT]]) -> None: ...
    def __getitem__(self, key: _KT) -> _VT: ...
    def __contains__(self, __key: object) -> bool: ...
    def copy(self: Self, **add_or_replace: _VT) -> Self: ...
    def __iter__(self) -> Iterator[_KT]: ...
    def __len__(self) -> int: ...
    def __hash__(self) -> int: ...

class FrozenOrderedDict(frozendict[_KT, _VT]):

    dict_cls: type[collections.OrderedDict[Any, Any]] = ...
