# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2018 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The `wx.ribbon` module contains a set of classes for writing a ribbon-based user interface.

At the most generic level, this is a combination of a tab control with a
toolbar. At a more functional level, it is similar to the user interface
present in recent versions of Microsoft Office and in Windows 10.
"""
#-- begin-_ribbon --#

import wx
#-- end-_ribbon --#
#-- begin-ribbon_control --#

class RibbonControl(wx.Control):
    """
    RibbonControl()
    RibbonControl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ControlNameStr)
    
    wxRibbonControl serves as a base class for all controls which share
    the ribbon characteristics of having a ribbon art provider, and
    (optionally) non-continuous resizing.
    """

    def __init__(self, *args, **kw):
        """
        RibbonControl()
        RibbonControl(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name=wx.ControlNameStr)
        
        wxRibbonControl serves as a base class for all controls which share
        the ribbon characteristics of having a ribbon art provider, and
        (optionally) non-continuous resizing.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        
        Set the art provider to be used.
        """

    def GetArtProvider(self):
        """
        GetArtProvider() -> RibbonArtProvider
        
        Get the art provider to be used.
        """

    def IsSizingContinuous(self):
        """
        IsSizingContinuous() -> bool
        """

    def GetNextSmallerSize(self, *args, **kw):
        """
        GetNextSmallerSize(direction) -> wx.Size
        GetNextSmallerSize(direction, relative_to) -> wx.Size
        
        If sizing is not continuous, then return a suitable size for the
        control which is smaller than the current size.
        """

    def GetNextLargerSize(self, *args, **kw):
        """
        GetNextLargerSize(direction) -> wx.Size
        GetNextLargerSize(direction, relative_to) -> wx.Size
        
        If sizing is not continuous, then return a suitable size for the
        control which is larger than the current size.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Perform initial size and layout calculations after children have been
        added, and/or realize children.
        """

    def Realise(self):
        """
        Realise() -> bool
        
        Alias for Realize().
        """

    def GetAncestorRibbonBar(self):
        """
        GetAncestorRibbonBar() -> RibbonBar
        
        Get the first ancestor which is a wxRibbonBar (or derived) or NULL if
        not having such parent.
        """

    def GetBestSizeForParentSize(self, parentSize):
        """
        GetBestSizeForParentSize(parentSize) -> wx.Size
        
        Finds the best width and height given the parent's width and height.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    AncestorRibbonBar = property(None, None)
    ArtProvider = property(None, None)

    def DoGetNextSmallerSize(self, direction, relative_to):
        """
        DoGetNextSmallerSize(direction, relative_to) -> wx.Size
        
        Implementation of GetNextSmallerSize().
        """

    def DoGetNextLargerSize(self, direction, relative_to):
        """
        DoGetNextLargerSize(direction, relative_to) -> wx.Size
        
        Implementation of GetNextLargerSize().
        """
# end of class RibbonControl

#-- end-ribbon_control --#
#-- begin-ribbon_page --#

class RibbonPage(RibbonControl):
    """
    RibbonPage()
    RibbonPage(parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, style=0)
    
    Container for related ribbon panels, and a tab within a ribbon bar.
    """

    def __init__(self, *args, **kw):
        """
        RibbonPage()
        RibbonPage(parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, style=0)
        
        Container for related ribbon panels, and a tab within a ribbon bar.
        """

    def Create(self, parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, style=0):
        """
        Create(parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, style=0) -> bool
        
        Create a ribbon page in two-step ribbon page construction.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        
        Set the art provider to be used.
        """

    def GetIcon(self):
        """
        GetIcon() -> wx.Bitmap
        
        Get the icon used for the page in the ribbon bar tab area (only
        displayed if the ribbon bar is actually showing icons).
        """

    def SetSizeWithScrollButtonAdjustment(self, x, y, width, height):
        """
        SetSizeWithScrollButtonAdjustment(x, y, width, height)
        
        Set the size of the page and the external scroll buttons (if any).
        """

    def AdjustRectToIncludeScrollButtons(self, rect):
        """
        AdjustRectToIncludeScrollButtons(rect)
        
        Expand a rectangle of the page to include external scroll buttons (if
        any).
        """

    def DismissExpandedPanel(self):
        """
        DismissExpandedPanel() -> bool
        
        Dismiss the current externally expanded panel, if there is one.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Perform a full re-layout of all panels on the page.
        """

    def ScrollLines(self, lines):
        """
        ScrollLines(lines) -> bool
        
        Scroll the page by some amount up / down / left / right.
        """

    def ScrollPixels(self, pixels):
        """
        ScrollPixels(pixels) -> bool
        
        Scroll the page by a set number of pixels up / down / left / right.
        """

    def ScrollSections(self, sections):
        """
        ScrollSections(sections) -> bool
        
        Scroll the page by an entire child section.
        """

    def GetMajorAxis(self):
        """
        GetMajorAxis() -> Orientation
        
        Get the direction in which ribbon panels are stacked within the page.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    Icon = property(None, None)
    MajorAxis = property(None, None)
# end of class RibbonPage

#-- end-ribbon_page --#
#-- begin-ribbon_panel --#
RIBBON_PANEL_NO_AUTO_MINIMISE = 0
RIBBON_PANEL_EXT_BUTTON = 0
RIBBON_PANEL_MINIMISE_BUTTON = 0
RIBBON_PANEL_STRETCH = 0
RIBBON_PANEL_FLEXIBLE = 0
RIBBON_PANEL_DEFAULT_STYLE = 0
wxEVT_RIBBONPANEL_EXTBUTTON_ACTIVATED = 0

class RibbonPanel(RibbonControl):
    """
    RibbonPanel()
    RibbonPanel(parent, id=wx.ID_ANY, label=wx.EmptyString, minimised_icon=wx.NullBitmap, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_PANEL_DEFAULT_STYLE)
    
    Serves as a container for a group of (ribbon) controls.
    """

    def __init__(self, *args, **kw):
        """
        RibbonPanel()
        RibbonPanel(parent, id=wx.ID_ANY, label=wx.EmptyString, minimised_icon=wx.NullBitmap, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_PANEL_DEFAULT_STYLE)
        
        Serves as a container for a group of (ribbon) controls.
        """

    def Create(self, parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_PANEL_DEFAULT_STYLE):
        """
        Create(parent, id=wx.ID_ANY, label=wx.EmptyString, icon=wx.NullBitmap, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_PANEL_DEFAULT_STYLE) -> bool
        
        Create a ribbon panel in two-step ribbon panel construction.
        """

    def GetMinimisedIcon(self):
        """
        GetMinimisedIcon() -> wx.Bitmap
        
        Get the bitmap to be used in place of the panel children when it is
        minimised.
        """

    def HasExtButton(self):
        """
        HasExtButton() -> bool
        
        Test if the panel has an extension button.
        """

    def IsMinimised(self, *args, **kw):
        """
        IsMinimised() -> bool
        IsMinimised(at_size) -> bool
        
        Query if the panel is currently minimised.
        """

    def IsHovered(self):
        """
        IsHovered() -> bool
        
        Query is the mouse is currently hovered over the panel.
        """

    def IsExtButtonHovered(self):
        """
        IsExtButtonHovered() -> bool
        
        Query if the mouse is currently hovered over the extension button.
        """

    def CanAutoMinimise(self):
        """
        CanAutoMinimise() -> bool
        
        Query if the panel can automatically minimise itself at small sizes.
        """

    def ShowExpanded(self):
        """
        ShowExpanded() -> bool
        
        Show the panel externally expanded.
        """

    def HideExpanded(self):
        """
        HideExpanded() -> bool
        
        Hide the panel's external expansion.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        
        Set the art provider to be used.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Realize all children of the panel.
        """

    def GetExpandedDummy(self):
        """
        GetExpandedDummy() -> RibbonPanel
        
        Get the dummy panel of an expanded panel.
        """

    def GetExpandedPanel(self):
        """
        GetExpandedPanel() -> RibbonPanel
        
        Get the expanded panel of a dummy panel.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ExpandedDummy = property(None, None)
    ExpandedPanel = property(None, None)
    MinimisedIcon = property(None, None)
# end of class RibbonPanel


class RibbonPanelEvent(wx.CommandEvent):
    """
    RibbonPanelEvent(command_type=wx.wxEVT_NULL, win_id=0, panel=None)
    
    Event used to indicate various actions relating to a wxRibbonPanel.
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0, panel=None):
        """
        RibbonPanelEvent(command_type=wx.wxEVT_NULL, win_id=0, panel=None)
        
        Event used to indicate various actions relating to a wxRibbonPanel.
        """

    def GetPanel(self):
        """
        GetPanel() -> RibbonPanel
        
        Returns the panel relating to this event.
        """

    def SetPanel(self, page):
        """
        SetPanel(page)
        
        Sets the page relating to this event.
        """
    Panel = property(None, None)
# end of class RibbonPanelEvent


EVT_RIBBONPANEL_EXTBUTTON_ACTIVATED = wx.PyEventBinder(wxEVT_RIBBONPANEL_EXTBUTTON_ACTIVATED, 1)
#-- end-ribbon_panel --#
#-- begin-ribbon_bar --#
RIBBON_BAR_SHOW_PAGE_LABELS = 0
RIBBON_BAR_SHOW_PAGE_ICONS = 0
RIBBON_BAR_FLOW_HORIZONTAL = 0
RIBBON_BAR_FLOW_VERTICAL = 0
RIBBON_BAR_SHOW_PANEL_EXT_BUTTONS = 0
RIBBON_BAR_SHOW_PANEL_MINIMISE_BUTTONS = 0
RIBBON_BAR_ALWAYS_SHOW_TABS = 0
RIBBON_BAR_SHOW_TOGGLE_BUTTON = 0
RIBBON_BAR_SHOW_HELP_BUTTON = 0
RIBBON_BAR_DEFAULT_STYLE = 0
RIBBON_BAR_FOLDBAR_STYLE = 0
RIBBON_BAR_PINNED = 0
RIBBON_BAR_MINIMIZED = 0
RIBBON_BAR_EXPANDED = 0
wxEVT_RIBBONBAR_PAGE_CHANGED = 0
wxEVT_RIBBONBAR_PAGE_CHANGING = 0
wxEVT_RIBBONBAR_TAB_MIDDLE_DOWN = 0
wxEVT_RIBBONBAR_TAB_MIDDLE_UP = 0
wxEVT_RIBBONBAR_TAB_RIGHT_DOWN = 0
wxEVT_RIBBONBAR_TAB_RIGHT_UP = 0
wxEVT_RIBBONBAR_TAB_LEFT_DCLICK = 0
wxEVT_RIBBONBAR_TOGGLED = 0
wxEVT_RIBBONBAR_HELP_CLICK = 0

class RibbonBarEvent(wx.NotifyEvent):
    """
    RibbonBarEvent(command_type=wx.wxEVT_NULL, win_id=0, page=None)
    
    Event used to indicate various actions relating to a wxRibbonBar.
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0, page=None):
        """
        RibbonBarEvent(command_type=wx.wxEVT_NULL, win_id=0, page=None)
        
        Event used to indicate various actions relating to a wxRibbonBar.
        """

    def GetPage(self):
        """
        GetPage() -> RibbonPage
        
        Returns the page being changed to, or being clicked on.
        """

    def SetPage(self, page):
        """
        SetPage(page)
        
        Sets the page relating to this event.
        """
    Page = property(None, None)
# end of class RibbonBarEvent


class RibbonPageTabInfo(object):
    """
    
    """
    rect = property(None, None)
    page = property(None, None)
    ideal_width = property(None, None)
    small_begin_need_separator_width = property(None, None)
    small_must_have_separator_width = property(None, None)
    minimum_width = property(None, None)
    active = property(None, None)
    hovered = property(None, None)
    highlight = property(None, None)
    shown = property(None, None)
# end of class RibbonPageTabInfo


class RibbonBar(RibbonControl):
    """
    RibbonBar()
    RibbonBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_BAR_DEFAULT_STYLE)
    
    Top-level control in a ribbon user interface.
    """

    def __init__(self, *args, **kw):
        """
        RibbonBar()
        RibbonBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_BAR_DEFAULT_STYLE)
        
        Top-level control in a ribbon user interface.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_BAR_DEFAULT_STYLE):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=RIBBON_BAR_DEFAULT_STYLE) -> bool
        
        Create a ribbon bar in two-step ribbon bar construction.
        """

    def SetTabCtrlMargins(self, left, right):
        """
        SetTabCtrlMargins(left, right)
        
        Set the margin widths (in pixels) on the left and right sides of the
        tab bar region of the ribbon bar.
        """

    def SetArtProvider(self, art):
        """
        SetArtProvider(art)
        
        Set the art provider to be used be the ribbon bar.
        """

    def SetActivePage(self, *args, **kw):
        """
        SetActivePage(page) -> bool
        SetActivePage(page) -> bool
        
        Set the active page by index, without triggering any events.
        """

    def GetActivePage(self):
        """
        GetActivePage() -> int
        
        Get the index of the active page.
        """

    def GetPage(self, n):
        """
        GetPage(n) -> RibbonPage
        
        Get a page by index.
        """

    def GetPageCount(self):
        """
        GetPageCount() -> size_t
        
        Get the number of pages in this bar.
        """

    def DismissExpandedPanel(self):
        """
        DismissExpandedPanel() -> bool
        
        Dismiss the expanded panel of the currently active page.
        """

    def GetPageNumber(self, page):
        """
        GetPageNumber(page) -> int
        
        Returns the number for a given ribbon bar page.
        """

    def DeletePage(self, n):
        """
        DeletePage(n)
        
        Delete a single page from this ribbon bar.
        """

    def ClearPages(self):
        """
        ClearPages()
        
        Delete all pages from the ribbon bar.
        """

    def IsPageShown(self, page):
        """
        IsPageShown(page) -> bool
        
        Indicates whether the tab for the given page is shown to the user or
        not.
        """

    def ShowPage(self, page, show_tab=True):
        """
        ShowPage(page, show_tab=True)
        
        Show or hide the tab for a given page.
        """

    def HidePage(self, page):
        """
        HidePage(page)
        
        Hides the tab for a given page.
        """

    def IsPageHighlighted(self, page):
        """
        IsPageHighlighted(page) -> bool
        
        Indicates whether a tab is currently highlighted.
        """

    def AddPageHighlight(self, page, highlight=True):
        """
        AddPageHighlight(page, highlight=True)
        
        Highlight the specified tab.
        """

    def RemovePageHighlight(self, page):
        """
        RemovePageHighlight(page)
        
        Changes a tab to not be highlighted.
        """

    def ShowPanels(self, show=True):
        """
        ShowPanels(show=True)
        
        Shows or hides the panel area of the ribbon bar.
        """

    def HidePanels(self):
        """
        HidePanels()
        
        Hides the panel area of the ribbon bar.
        """

    def ArePanelsShown(self):
        """
        ArePanelsShown() -> bool
        
        Indicates whether the panel area of the ribbon bar is shown.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Perform initial layout and size calculations of the bar and its
        children.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ActivePage = property(None, None)
    PageCount = property(None, None)
# end of class RibbonBar


EVT_RIBBONBAR_PAGE_CHANGED    = wx.PyEventBinder(wxEVT_RIBBONBAR_PAGE_CHANGED, 1)
EVT_RIBBONBAR_PAGE_CHANGING   = wx.PyEventBinder(wxEVT_RIBBONBAR_PAGE_CHANGING,1)
EVT_RIBBONBAR_TAB_MIDDLE_DOWN = wx.PyEventBinder(wxEVT_RIBBONBAR_TAB_MIDDLE_DOWN, 1)
EVT_RIBBONBAR_TAB_MIDDLE_UP   = wx.PyEventBinder(wxEVT_RIBBONBAR_TAB_MIDDLE_UP, 1)
EVT_RIBBONBAR_TAB_RIGHT_DOWN  = wx.PyEventBinder(wxEVT_RIBBONBAR_TAB_RIGHT_DOWN, 1)
EVT_RIBBONBAR_TAB_RIGHT_UP    = wx.PyEventBinder(wxEVT_RIBBONBAR_TAB_RIGHT_UP, 1)
EVT_RIBBONBAR_TAB_LEFT_DCLICK = wx.PyEventBinder(wxEVT_RIBBONBAR_TAB_LEFT_DCLICK, 1)
EVT_RIBBONBAR_TOGGLED         = wx.PyEventBinder(wxEVT_RIBBONBAR_TOGGLED, 1)
EVT_RIBBONBAR_HELP_CLICK      = wx.PyEventBinder(wxEVT_RIBBONBAR_HELP_CLICK, 1)
#-- end-ribbon_bar --#
#-- begin-ribbon_art --#
RIBBON_ART_TAB_SEPARATION_SIZE = 0
RIBBON_ART_PAGE_BORDER_LEFT_SIZE = 0
RIBBON_ART_PAGE_BORDER_TOP_SIZE = 0
RIBBON_ART_PAGE_BORDER_RIGHT_SIZE = 0
RIBBON_ART_PAGE_BORDER_BOTTOM_SIZE = 0
RIBBON_ART_PANEL_X_SEPARATION_SIZE = 0
RIBBON_ART_PANEL_Y_SEPARATION_SIZE = 0
RIBBON_ART_TOOL_GROUP_SEPARATION_SIZE = 0
RIBBON_ART_GALLERY_BITMAP_PADDING_LEFT_SIZE = 0
RIBBON_ART_GALLERY_BITMAP_PADDING_RIGHT_SIZE = 0
RIBBON_ART_GALLERY_BITMAP_PADDING_TOP_SIZE = 0
RIBBON_ART_GALLERY_BITMAP_PADDING_BOTTOM_SIZE = 0
RIBBON_ART_PANEL_LABEL_FONT = 0
RIBBON_ART_BUTTON_BAR_LABEL_FONT = 0
RIBBON_ART_TAB_LABEL_FONT = 0
RIBBON_ART_BUTTON_BAR_LABEL_COLOUR = 0
RIBBON_ART_BUTTON_BAR_LABEL_DISABLED_COLOUR = 0
RIBBON_ART_BUTTON_BAR_HOVER_BORDER_COLOUR = 0
RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_BUTTON_BAR_HOVER_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_BUTTON_BAR_ACTIVE_BORDER_COLOUR = 0
RIBBON_ART_BUTTON_BAR_ACTIVE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_BUTTON_BAR_ACTIVE_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_BUTTON_BAR_ACTIVE_BACKGROUND_COLOUR = 0
RIBBON_ART_BUTTON_BAR_ACTIVE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_GALLERY_BORDER_COLOUR = 0
RIBBON_ART_GALLERY_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_BACKGROUND_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_FACE_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_HOVER_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_HOVER_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_HOVER_FACE_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_ACTIVE_BACKGROUND_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_ACTIVE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_ACTIVE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_ACTIVE_FACE_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_DISABLED_BACKGROUND_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_DISABLED_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_DISABLED_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_GALLERY_BUTTON_DISABLED_FACE_COLOUR = 0
RIBBON_ART_GALLERY_ITEM_BORDER_COLOUR = 0
RIBBON_ART_TAB_LABEL_COLOUR = 0
RIBBON_ART_TAB_SEPARATOR_COLOUR = 0
RIBBON_ART_TAB_SEPARATOR_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_CTRL_BACKGROUND_COLOUR = 0
RIBBON_ART_TAB_CTRL_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_HOVER_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_TAB_HOVER_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_TAB_HOVER_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_ACTIVE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_TAB_ACTIVE_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_ACTIVE_BACKGROUND_COLOUR = 0
RIBBON_ART_TAB_ACTIVE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TAB_BORDER_COLOUR = 0
RIBBON_ART_PANEL_BORDER_COLOUR = 0
RIBBON_ART_PANEL_BORDER_GRADIENT_COLOUR = 0
RIBBON_ART_PANEL_MINIMISED_BORDER_COLOUR = 0
RIBBON_ART_PANEL_MINIMISED_BORDER_GRADIENT_COLOUR = 0
RIBBON_ART_PANEL_LABEL_BACKGROUND_COLOUR = 0
RIBBON_ART_PANEL_LABEL_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_PANEL_LABEL_COLOUR = 0
RIBBON_ART_PANEL_HOVER_LABEL_BACKGROUND_COLOUR = 0
RIBBON_ART_PANEL_HOVER_LABEL_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_PANEL_HOVER_LABEL_COLOUR = 0
RIBBON_ART_PANEL_MINIMISED_LABEL_COLOUR = 0
RIBBON_ART_PANEL_ACTIVE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_PANEL_ACTIVE_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_PANEL_ACTIVE_BACKGROUND_COLOUR = 0
RIBBON_ART_PANEL_ACTIVE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_PAGE_BORDER_COLOUR = 0
RIBBON_ART_PAGE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_PAGE_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_PAGE_BACKGROUND_COLOUR = 0
RIBBON_ART_PAGE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_PAGE_HOVER_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_PAGE_HOVER_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_PAGE_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_PAGE_HOVER_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TOOLBAR_BORDER_COLOUR = 0
RIBBON_ART_TOOLBAR_HOVER_BORDER_COLOUR = 0
RIBBON_ART_TOOLBAR_FACE_COLOUR = 0
RIBBON_ART_TOOL_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_TOOL_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_TOOL_BACKGROUND_COLOUR = 0
RIBBON_ART_TOOL_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TOOL_HOVER_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_TOOL_HOVER_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_TOOL_HOVER_BACKGROUND_COLOUR = 0
RIBBON_ART_TOOL_HOVER_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_ART_TOOL_ACTIVE_BACKGROUND_TOP_COLOUR = 0
RIBBON_ART_TOOL_ACTIVE_BACKGROUND_TOP_GRADIENT_COLOUR = 0
RIBBON_ART_TOOL_ACTIVE_BACKGROUND_COLOUR = 0
RIBBON_ART_TOOL_ACTIVE_BACKGROUND_GRADIENT_COLOUR = 0
RIBBON_SCROLL_BTN_LEFT = 0
RIBBON_SCROLL_BTN_RIGHT = 0
RIBBON_SCROLL_BTN_UP = 0
RIBBON_SCROLL_BTN_DOWN = 0
RIBBON_SCROLL_BTN_DIRECTION_MASK = 0
RIBBON_SCROLL_BTN_NORMAL = 0
RIBBON_SCROLL_BTN_HOVERED = 0
RIBBON_SCROLL_BTN_ACTIVE = 0
RIBBON_SCROLL_BTN_STATE_MASK = 0
RIBBON_SCROLL_BTN_FOR_OTHER = 0
RIBBON_SCROLL_BTN_FOR_TABS = 0
RIBBON_SCROLL_BTN_FOR_PAGE = 0
RIBBON_SCROLL_BTN_FOR_MASK = 0
RIBBON_BUTTON_NORMAL = 0
RIBBON_BUTTON_DROPDOWN = 0
RIBBON_BUTTON_HYBRID = 0
RIBBON_BUTTON_TOGGLE = 0

class RibbonArtProvider(object):
    """
    RibbonArtProvider()
    
    wxRibbonArtProvider is responsible for drawing all the components of
    the ribbon interface.
    """

    def __init__(self):
        """
        RibbonArtProvider()
        
        wxRibbonArtProvider is responsible for drawing all the components of
        the ribbon interface.
        """

    def Clone(self):
        """
        Clone() -> RibbonArtProvider
        
        Create a new art provider which is a clone of this one.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Set the style flags.
        """

    def GetFlags(self):
        """
        GetFlags() -> long
        
        Get the previously set style flags.
        """

    def GetMetric(self, id):
        """
        GetMetric(id) -> int
        
        Get the value of a certain integer setting.
        """

    def SetMetric(self, id, new_val):
        """
        SetMetric(id, new_val)
        
        Set the value of a certain integer setting to the value new_val.
        """

    def SetFont(self, id, font):
        """
        SetFont(id, font)
        
        Set the value of a certain font setting to the value font.
        """

    def GetFont(self, id):
        """
        GetFont(id) -> wx.Font
        
        Get the value of a certain font setting.
        """

    def GetColour(self, id):
        """
        GetColour(id) -> wx.Colour
        
        Get the value of a certain colour setting.
        """

    def SetColour(self, id, colour):
        """
        SetColour(id, colour)
        
        Set the value of a certain colour setting to the value colour.
        """

    def GetColor(self, id):
        """
        GetColor(id) -> wx.Colour
        """

    def SetColor(self, id, color):
        """
        SetColor(id, color)
        """

    def GetColourScheme(self):
        """
        GetColourScheme() -> (primary, secondary, tertiary)
        
        Get the current colour scheme.
        """

    def SetColourScheme(self, primary, secondary, tertiary):
        """
        SetColourScheme(primary, secondary, tertiary)
        
        Set all applicable colour settings from a few base colours.
        """

    def DrawTabCtrlBackground(self, dc, wnd, rect):
        """
        DrawTabCtrlBackground(dc, wnd, rect)
        
        Draw the background of the tab region of a ribbon bar.
        """

    def DrawTab(self, dc, wnd, tab):
        """
        DrawTab(dc, wnd, tab)
        
        Draw a single tab in the tab region of a ribbon bar.
        """

    def DrawTabSeparator(self, dc, wnd, rect, visibility):
        """
        DrawTabSeparator(dc, wnd, rect, visibility)
        
        Draw a separator between two tabs in a ribbon bar.
        """

    def DrawPageBackground(self, dc, wnd, rect):
        """
        DrawPageBackground(dc, wnd, rect)
        
        Draw the background of a ribbon page.
        """

    def DrawScrollButton(self, dc, wnd, rect, style):
        """
        DrawScrollButton(dc, wnd, rect, style)
        
        Draw a ribbon-style scroll button.
        """

    def DrawPanelBackground(self, dc, wnd, rect):
        """
        DrawPanelBackground(dc, wnd, rect)
        
        Draw the background and chrome for a ribbon panel.
        """

    def DrawGalleryBackground(self, dc, wnd, rect):
        """
        DrawGalleryBackground(dc, wnd, rect)
        
        Draw the background and chrome for a wxRibbonGallery control.
        """

    def DrawGalleryItemBackground(self, dc, wnd, rect, item):
        """
        DrawGalleryItemBackground(dc, wnd, rect, item)
        
        Draw the background of a single item in a wxRibbonGallery control.
        """

    def DrawMinimisedPanel(self, dc, wnd, rect, bitmap):
        """
        DrawMinimisedPanel(dc, wnd, rect, bitmap)
        
        Draw a minimised ribbon panel.
        """

    def DrawButtonBarBackground(self, dc, wnd, rect):
        """
        DrawButtonBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonButtonBar control.
        """

    def DrawButtonBarButton(self, dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small):
        """
        DrawButtonBarButton(dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small)
        
        Draw a single button for a wxRibbonButtonBar control.
        """

    def DrawToolBarBackground(self, dc, wnd, rect):
        """
        DrawToolBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonToolBar control.
        """

    def DrawToolGroupBackground(self, dc, wnd, rect):
        """
        DrawToolGroupBackground(dc, wnd, rect)
        
        Draw the background for a group of tools on a wxRibbonToolBar control.
        """

    def DrawTool(self, dc, wnd, rect, bitmap, kind, state):
        """
        DrawTool(dc, wnd, rect, bitmap, kind, state)
        
        Draw a single tool (for a wxRibbonToolBar control).
        """

    def DrawToggleButton(self, dc, wnd, rect, mode):
        """
        DrawToggleButton(dc, wnd, rect, mode)
        
        Draw toggle button on wxRibbonBar.
        """

    def DrawHelpButton(self, dc, wnd, rect):
        """
        DrawHelpButton(dc, wnd, rect)
        
        Draw help button on wxRibbonBar.
        """

    def GetBarTabWidth(self, dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum):
        """
        GetBarTabWidth(dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum)
        
        Calculate the ideal and minimum width (in pixels) of a tab in a ribbon
        bar.
        """

    def GetTabCtrlHeight(self, dc, wnd, pages):
        """
        GetTabCtrlHeight(dc, wnd, pages) -> int
        
        Calculate the height (in pixels) of the tab region of a ribbon bar.
        """

    def GetScrollButtonMinimumSize(self, dc, wnd, style):
        """
        GetScrollButtonMinimumSize(dc, wnd, style) -> wx.Size
        
        Calculate the minimum size (in pixels) of a scroll button.
        """

    def GetPanelSize(self, dc, wnd, client_size, client_offset):
        """
        GetPanelSize(dc, wnd, client_size, client_offset) -> wx.Size
        
        Calculate the size of a panel for a given client size.
        """

    def GetPanelClientSize(self, dc, wnd, size, client_offset):
        """
        GetPanelClientSize(dc, wnd, size, client_offset) -> wx.Size
        
        Calculate the client size of a panel for a given overall size.
        """

    def GetPanelExtButtonArea(self, dc, wnd, rect):
        """
        GetPanelExtButtonArea(dc, wnd, rect) -> wx.Rect
        
        Calculate the position and size of the panel extension button.
        """

    def GetGallerySize(self, dc, wnd, client_size):
        """
        GetGallerySize(dc, wnd, client_size) -> wx.Size
        
        Calculate the size of a wxRibbonGallery control for a given client
        size.
        """

    def GetGalleryClientSize(self, dc, wnd, size, client_offset, scroll_up_button, scroll_down_button, extension_button):
        """
        GetGalleryClientSize(dc, wnd, size, client_offset, scroll_up_button, scroll_down_button, extension_button) -> wx.Size
        
        Calculate the client size of a wxRibbonGallery control for a given
        size.
        """

    def GetPageBackgroundRedrawArea(self, dc, wnd, page_old_size, page_new_size):
        """
        GetPageBackgroundRedrawArea(dc, wnd, page_old_size, page_new_size) -> wx.Rect
        
        Calculate the portion of a page background which needs to be redrawn
        when a page is resized.
        """

    def GetButtonBarButtonSize(self, dc, wnd, kind, size, label, bitmap_size_large, bitmap_size_small, button_size, normal_region, dropdown_region):
        """
        GetButtonBarButtonSize(dc, wnd, kind, size, label, bitmap_size_large, bitmap_size_small, button_size, normal_region, dropdown_region) -> bool
        
        Calculate the size of a button within a wxRibbonButtonBar.
        """

    def GetMinimisedPanelMinimumSize(self, dc, wnd, desired_bitmap_size, expanded_panel_direction):
        """
        GetMinimisedPanelMinimumSize(dc, wnd, desired_bitmap_size, expanded_panel_direction) -> wx.Size
        
        Calculate the size of a minimised ribbon panel.
        """

    def GetToolSize(self, dc, wnd, bitmap_size, kind, is_first, is_last, dropdown_region):
        """
        GetToolSize(dc, wnd, bitmap_size, kind, is_first, is_last, dropdown_region) -> wx.Size
        
        Calculate the size of a tool within a wxRibbonToolBar.
        """

    def GetBarToggleButtonArea(self, rect):
        """
        GetBarToggleButtonArea(rect) -> wx.Rect
        
        Calculate the position and size of the ribbon's toggle button.
        """

    def GetRibbonHelpButtonArea(self, rect):
        """
        GetRibbonHelpButtonArea(rect) -> wx.Rect
        
        Calculate the position and size of the ribbon's help button.
        """
    Flags = property(None, None)
# end of class RibbonArtProvider


class RibbonMSWArtProvider(RibbonArtProvider):
    """
    RibbonMSWArtProvider(set_colour_scheme=True)
    """

    def __init__(self, set_colour_scheme=True):
        """
        RibbonMSWArtProvider(set_colour_scheme=True)
        """

    def Clone(self):
        """
        Clone() -> RibbonArtProvider
        
        Create a new art provider which is a clone of this one.
        """

    def SetFlags(self, flags):
        """
        SetFlags(flags)
        
        Set the style flags.
        """

    def GetFlags(self):
        """
        GetFlags() -> long
        
        Get the previously set style flags.
        """

    def GetMetric(self, id):
        """
        GetMetric(id) -> int
        
        Get the value of a certain integer setting.
        """

    def SetMetric(self, id, new_val):
        """
        SetMetric(id, new_val)
        
        Set the value of a certain integer setting to the value new_val.
        """

    def SetFont(self, id, font):
        """
        SetFont(id, font)
        
        Set the value of a certain font setting to the value font.
        """

    def GetFont(self, id):
        """
        GetFont(id) -> wx.Font
        
        Get the value of a certain font setting.
        """

    def GetColour(self, id):
        """
        GetColour(id) -> wx.Colour
        
        Get the value of a certain colour setting.
        """

    def SetColour(self, id, colour):
        """
        SetColour(id, colour)
        
        Set the value of a certain colour setting to the value colour.
        """

    def GetColourScheme(self):
        """
        GetColourScheme() -> (primary, secondary, tertiary)
        
        Get the current colour scheme.
        """

    def SetColourScheme(self, primary, secondary, tertiary):
        """
        SetColourScheme(primary, secondary, tertiary)
        
        Set all applicable colour settings from a few base colours.
        """

    def GetTabCtrlHeight(self, dc, wnd, pages):
        """
        GetTabCtrlHeight(dc, wnd, pages) -> int
        
        Calculate the height (in pixels) of the tab region of a ribbon bar.
        """

    def DrawTabCtrlBackground(self, dc, wnd, rect):
        """
        DrawTabCtrlBackground(dc, wnd, rect)
        
        Draw the background of the tab region of a ribbon bar.
        """

    def DrawTab(self, dc, wnd, tab):
        """
        DrawTab(dc, wnd, tab)
        
        Draw a single tab in the tab region of a ribbon bar.
        """

    def DrawTabSeparator(self, dc, wnd, rect, visibility):
        """
        DrawTabSeparator(dc, wnd, rect, visibility)
        
        Draw a separator between two tabs in a ribbon bar.
        """

    def DrawPageBackground(self, dc, wnd, rect):
        """
        DrawPageBackground(dc, wnd, rect)
        
        Draw the background of a ribbon page.
        """

    def DrawScrollButton(self, dc, wnd, rect, style):
        """
        DrawScrollButton(dc, wnd, rect, style)
        
        Draw a ribbon-style scroll button.
        """

    def DrawPanelBackground(self, dc, wnd, rect):
        """
        DrawPanelBackground(dc, wnd, rect)
        
        Draw the background and chrome for a ribbon panel.
        """

    def DrawGalleryBackground(self, dc, wnd, rect):
        """
        DrawGalleryBackground(dc, wnd, rect)
        
        Draw the background and chrome for a wxRibbonGallery control.
        """

    def DrawGalleryItemBackground(self, dc, wnd, rect, item):
        """
        DrawGalleryItemBackground(dc, wnd, rect, item)
        
        Draw the background of a single item in a wxRibbonGallery control.
        """

    def DrawMinimisedPanel(self, dc, wnd, rect, bitmap):
        """
        DrawMinimisedPanel(dc, wnd, rect, bitmap)
        
        Draw a minimised ribbon panel.
        """

    def DrawButtonBarBackground(self, dc, wnd, rect):
        """
        DrawButtonBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonButtonBar control.
        """

    def DrawButtonBarButton(self, dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small):
        """
        DrawButtonBarButton(dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small)
        
        Draw a single button for a wxRibbonButtonBar control.
        """

    def DrawToolBarBackground(self, dc, wnd, rect):
        """
        DrawToolBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonToolBar control.
        """

    def DrawToolGroupBackground(self, dc, wnd, rect):
        """
        DrawToolGroupBackground(dc, wnd, rect)
        
        Draw the background for a group of tools on a wxRibbonToolBar control.
        """

    def DrawTool(self, dc, wnd, rect, bitmap, kind, state):
        """
        DrawTool(dc, wnd, rect, bitmap, kind, state)
        
        Draw a single tool (for a wxRibbonToolBar control).
        """

    def DrawToggleButton(self, dc, wnd, rect, mode):
        """
        DrawToggleButton(dc, wnd, rect, mode)
        
        Draw toggle button on wxRibbonBar.
        """

    def DrawHelpButton(self, dc, wnd, rect):
        """
        DrawHelpButton(dc, wnd, rect)
        
        Draw help button on wxRibbonBar.
        """

    def GetBarTabWidth(self, dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum):
        """
        GetBarTabWidth(dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum)
        
        Calculate the ideal and minimum width (in pixels) of a tab in a ribbon
        bar.
        """

    def GetScrollButtonMinimumSize(self, dc, wnd, style):
        """
        GetScrollButtonMinimumSize(dc, wnd, style) -> wx.Size
        
        Calculate the minimum size (in pixels) of a scroll button.
        """

    def GetPanelSize(self, dc, wnd, client_size, client_offset):
        """
        GetPanelSize(dc, wnd, client_size, client_offset) -> wx.Size
        
        Calculate the size of a panel for a given client size.
        """

    def GetPanelClientSize(self, dc, wnd, size, client_offset):
        """
        GetPanelClientSize(dc, wnd, size, client_offset) -> wx.Size
        
        Calculate the client size of a panel for a given overall size.
        """

    def GetPanelExtButtonArea(self, dc, wnd, rect):
        """
        GetPanelExtButtonArea(dc, wnd, rect) -> wx.Rect
        
        Calculate the position and size of the panel extension button.
        """

    def GetGallerySize(self, dc, wnd, client_size):
        """
        GetGallerySize(dc, wnd, client_size) -> wx.Size
        
        Calculate the size of a wxRibbonGallery control for a given client
        size.
        """

    def GetGalleryClientSize(self, dc, wnd, size, client_offset, scroll_up_button, scroll_down_button, extension_button):
        """
        GetGalleryClientSize(dc, wnd, size, client_offset, scroll_up_button, scroll_down_button, extension_button) -> wx.Size
        
        Calculate the client size of a wxRibbonGallery control for a given
        size.
        """

    def GetPageBackgroundRedrawArea(self, dc, wnd, page_old_size, page_new_size):
        """
        GetPageBackgroundRedrawArea(dc, wnd, page_old_size, page_new_size) -> wx.Rect
        
        Calculate the portion of a page background which needs to be redrawn
        when a page is resized.
        """

    def GetButtonBarButtonSize(self, dc, wnd, kind, size, label, bitmap_size_large, bitmap_size_small, button_size, normal_region, dropdown_region):
        """
        GetButtonBarButtonSize(dc, wnd, kind, size, label, bitmap_size_large, bitmap_size_small, button_size, normal_region, dropdown_region) -> bool
        
        Calculate the size of a button within a wxRibbonButtonBar.
        """

    def GetMinimisedPanelMinimumSize(self, dc, wnd, desired_bitmap_size, expanded_panel_direction):
        """
        GetMinimisedPanelMinimumSize(dc, wnd, desired_bitmap_size, expanded_panel_direction) -> wx.Size
        
        Calculate the size of a minimised ribbon panel.
        """

    def GetToolSize(self, dc, wnd, bitmap_size, kind, is_first, is_last, dropdown_region):
        """
        GetToolSize(dc, wnd, bitmap_size, kind, is_first, is_last, dropdown_region) -> wx.Size
        
        Calculate the size of a tool within a wxRibbonToolBar.
        """

    def GetBarToggleButtonArea(self, rect):
        """
        GetBarToggleButtonArea(rect) -> wx.Rect
        
        Calculate the position and size of the ribbon's toggle button.
        """

    def GetRibbonHelpButtonArea(self, rect):
        """
        GetRibbonHelpButtonArea(rect) -> wx.Rect
        
        Calculate the position and size of the ribbon's help button.
        """
    Flags = property(None, None)
# end of class RibbonMSWArtProvider


class RibbonAUIArtProvider(RibbonMSWArtProvider):
    """
    RibbonAUIArtProvider()
    """

    def __init__(self):
        """
        RibbonAUIArtProvider()
        """

    def Clone(self):
        """
        Clone() -> RibbonArtProvider
        
        Create a new art provider which is a clone of this one.
        """

    def GetColour(self, id):
        """
        GetColour(id) -> wx.Colour
        
        Get the value of a certain colour setting.
        """

    def SetColour(self, id, colour):
        """
        SetColour(id, colour)
        
        Set the value of a certain colour setting to the value colour.
        """

    def SetColourScheme(self, primary, secondary, tertiary):
        """
        SetColourScheme(primary, secondary, tertiary)
        
        Set all applicable colour settings from a few base colours.
        """

    def SetFont(self, id, font):
        """
        SetFont(id, font)
        
        Set the value of a certain font setting to the value font.
        """

    def GetScrollButtonMinimumSize(self, dc, wnd, style):
        """
        GetScrollButtonMinimumSize(dc, wnd, style) -> wx.Size
        
        Calculate the minimum size (in pixels) of a scroll button.
        """

    def DrawScrollButton(self, dc, wnd, rect, style):
        """
        DrawScrollButton(dc, wnd, rect, style)
        
        Draw a ribbon-style scroll button.
        """

    def GetPanelSize(self, dc, wnd, client_size, client_offset):
        """
        GetPanelSize(dc, wnd, client_size, client_offset) -> wx.Size
        
        Calculate the size of a panel for a given client size.
        """

    def GetPanelClientSize(self, dc, wnd, size, client_offset):
        """
        GetPanelClientSize(dc, wnd, size, client_offset) -> wx.Size
        
        Calculate the client size of a panel for a given overall size.
        """

    def GetPanelExtButtonArea(self, dc, wnd, rect):
        """
        GetPanelExtButtonArea(dc, wnd, rect) -> wx.Rect
        
        Calculate the position and size of the panel extension button.
        """

    def DrawTabCtrlBackground(self, dc, wnd, rect):
        """
        DrawTabCtrlBackground(dc, wnd, rect)
        
        Draw the background of the tab region of a ribbon bar.
        """

    def GetTabCtrlHeight(self, dc, wnd, pages):
        """
        GetTabCtrlHeight(dc, wnd, pages) -> int
        
        Calculate the height (in pixels) of the tab region of a ribbon bar.
        """

    def GetBarTabWidth(self, dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum):
        """
        GetBarTabWidth(dc, wnd, label, bitmap, ideal, small_begin_need_separator, small_must_have_separator, minimum)
        
        Calculate the ideal and minimum width (in pixels) of a tab in a ribbon
        bar.
        """

    def DrawTab(self, dc, wnd, tab):
        """
        DrawTab(dc, wnd, tab)
        
        Draw a single tab in the tab region of a ribbon bar.
        """

    def DrawTabSeparator(self, dc, wnd, rect, visibility):
        """
        DrawTabSeparator(dc, wnd, rect, visibility)
        
        Draw a separator between two tabs in a ribbon bar.
        """

    def DrawPageBackground(self, dc, wnd, rect):
        """
        DrawPageBackground(dc, wnd, rect)
        
        Draw the background of a ribbon page.
        """

    def DrawPanelBackground(self, dc, wnd, rect):
        """
        DrawPanelBackground(dc, wnd, rect)
        
        Draw the background and chrome for a ribbon panel.
        """

    def DrawMinimisedPanel(self, dc, wnd, rect, bitmap):
        """
        DrawMinimisedPanel(dc, wnd, rect, bitmap)
        
        Draw a minimised ribbon panel.
        """

    def DrawGalleryBackground(self, dc, wnd, rect):
        """
        DrawGalleryBackground(dc, wnd, rect)
        
        Draw the background and chrome for a wxRibbonGallery control.
        """

    def DrawGalleryItemBackground(self, dc, wnd, rect, item):
        """
        DrawGalleryItemBackground(dc, wnd, rect, item)
        
        Draw the background of a single item in a wxRibbonGallery control.
        """

    def DrawButtonBarBackground(self, dc, wnd, rect):
        """
        DrawButtonBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonButtonBar control.
        """

    def DrawButtonBarButton(self, dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small):
        """
        DrawButtonBarButton(dc, wnd, rect, kind, state, label, bitmap_large, bitmap_small)
        
        Draw a single button for a wxRibbonButtonBar control.
        """

    def DrawToolBarBackground(self, dc, wnd, rect):
        """
        DrawToolBarBackground(dc, wnd, rect)
        
        Draw the background for a wxRibbonToolBar control.
        """

    def DrawToolGroupBackground(self, dc, wnd, rect):
        """
        DrawToolGroupBackground(dc, wnd, rect)
        
        Draw the background for a group of tools on a wxRibbonToolBar control.
        """

    def DrawTool(self, dc, wnd, rect, bitmap, kind, state):
        """
        DrawTool(dc, wnd, rect, bitmap, kind, state)
        
        Draw a single tool (for a wxRibbonToolBar control).
        """
# end of class RibbonAUIArtProvider


if 'wxMSW' in wx.PlatformInfo:
    RibbonDefaultArtProvider = RibbonMSWArtProvider
else:
    RibbonDefaultArtProvider = RibbonAUIArtProvider
#-- end-ribbon_art --#
#-- begin-ribbon_buttonbar --#
RIBBON_BUTTONBAR_BUTTON_SMALL = 0
RIBBON_BUTTONBAR_BUTTON_MEDIUM = 0
RIBBON_BUTTONBAR_BUTTON_LARGE = 0
RIBBON_BUTTONBAR_BUTTON_SIZE_MASK = 0
RIBBON_BUTTONBAR_BUTTON_NORMAL_HOVERED = 0
RIBBON_BUTTONBAR_BUTTON_DROPDOWN_HOVERED = 0
RIBBON_BUTTONBAR_BUTTON_HOVER_MASK = 0
RIBBON_BUTTONBAR_BUTTON_NORMAL_ACTIVE = 0
RIBBON_BUTTONBAR_BUTTON_DROPDOWN_ACTIVE = 0
RIBBON_BUTTONBAR_BUTTON_ACTIVE_MASK = 0
RIBBON_BUTTONBAR_BUTTON_DISABLED = 0
RIBBON_BUTTONBAR_BUTTON_TOGGLED = 0
RIBBON_BUTTONBAR_BUTTON_STATE_MASK = 0
wxEVT_RIBBONBUTTONBAR_CLICKED = 0
wxEVT_RIBBONBUTTONBAR_DROPDOWN_CLICKED = 0

class RibbonButtonBar(RibbonControl):
    """
    RibbonButtonBar()
    RibbonButtonBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    
    A ribbon button bar is similar to a traditional toolbar.
    """

    def __init__(self, *args, **kw):
        """
        RibbonButtonBar()
        RibbonButtonBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        
        A ribbon button bar is similar to a traditional toolbar.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Create a button bar in two-step button bar construction.
        """

    def AddButton(self, *args, **kw):
        """
        AddButton(button_id, label, bitmap, help_string, kind=RIBBON_BUTTON_NORMAL) -> RibbonButtonBarButtonBase
        AddButton(button_id, label, bitmap, bitmap_small=wx.NullBitmap, bitmap_disabled=wx.NullBitmap, bitmap_small_disabled=wx.NullBitmap, kind=RIBBON_BUTTON_NORMAL, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Add a button to the button bar (simple version).
        """

    def AddDropdownButton(self, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        AddDropdownButton(button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Add a dropdown button to the button bar (simple version).
        """

    def AddHybridButton(self, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        AddHybridButton(button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Add a hybrid button to the button bar (simple version).
        """

    def AddToggleButton(self, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        AddToggleButton(button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Add a toggle button to the button bar (simple version).
        """

    def InsertButton(self, *args, **kw):
        """
        InsertButton(pos, button_id, label, bitmap, help_string, kind=RIBBON_BUTTON_NORMAL) -> RibbonButtonBarButtonBase
        InsertButton(pos, button_id, label, bitmap, bitmap_small=wx.NullBitmap, bitmap_disabled=wx.NullBitmap, bitmap_small_disabled=wx.NullBitmap, kind=RIBBON_BUTTON_NORMAL, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Inserts a button to the button bar (simple version) at the given
        position.
        """

    def InsertDropdownButton(self, pos, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        InsertDropdownButton(pos, button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Inserts a dropdown button to the button bar (simple version) at the
        given position.
        """

    def InsertHybridButton(self, pos, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        InsertHybridButton(pos, button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Inserts a hybrid button to the button bar (simple version) at the
        given position.
        """

    def InsertToggleButton(self, pos, button_id, label, bitmap, help_string=wx.EmptyString):
        """
        InsertToggleButton(pos, button_id, label, bitmap, help_string=wx.EmptyString) -> RibbonButtonBarButtonBase
        
        Inserts a toggle button to the button bar (simple version) at the
        given position.
        """

    def GetButtonCount(self):
        """
        GetButtonCount() -> size_t
        
        Returns the number of buttons in this button bar.
        """

    def SetItemClientData(self, item, data):
        """
        SetItemClientData(item, data)
        
        Set the client object associated with a button.
        """

    def GetItemClientData(self, item):
        """
        GetItemClientData(item) -> ClientData
        
        Get the client object associated with a button.
        """

    def GetItem(self, n):
        """
        GetItem(n) -> RibbonButtonBarButtonBase
        
        Returns the N-th button of the bar.
        """

    def GetItemById(self, id):
        """
        GetItemById(id) -> RibbonButtonBarButtonBase
        
        Returns the first button having a given id or NULL if none matches.
        """

    def GetItemId(self, item):
        """
        GetItemId(item) -> int
        
        Returns the id of a button.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Calculate button layouts and positions.
        """

    def ClearButtons(self):
        """
        ClearButtons()
        
        Delete all buttons from the button bar.
        """

    def DeleteButton(self, button_id):
        """
        DeleteButton(button_id) -> bool
        
        Delete a single button from the button bar.
        """

    def EnableButton(self, button_id, enable=True):
        """
        EnableButton(button_id, enable=True)
        
        Enable or disable a single button on the bar.
        """

    def ToggleButton(self, button_id, checked):
        """
        ToggleButton(button_id, checked)
        
        Set a toggle button to the checked or unchecked state.
        """

    def GetActiveItem(self):
        """
        GetActiveItem() -> RibbonButtonBarButtonBase
        
        Returns the active item of the button bar or NULL if there is none.
        """

    def GetHoveredItem(self):
        """
        GetHoveredItem() -> RibbonButtonBarButtonBase
        
        Returns the hovered item of the button bar or NULL if there is none.
        """

    def SetShowToolTipsForDisabled(self, show):
        """
        SetShowToolTipsForDisabled(show)
        
        Indicates whether tooltips are shown for disabled buttons.
        """

    def GetShowToolTipsForDisabled(self):
        """
        GetShowToolTipsForDisabled() -> bool
        
        Sets whether tooltips should be shown for disabled buttons or not.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ActiveItem = property(None, None)
    ButtonCount = property(None, None)
    HoveredItem = property(None, None)
    ShowToolTipsForDisabled = property(None, None)
# end of class RibbonButtonBar


class RibbonButtonBarEvent(wx.CommandEvent):
    """
    RibbonButtonBarEvent(command_type=wx.wxEVT_NULL, win_id=0, bar=None, button=None)
    
    Event used to indicate various actions relating to a button on a
    wxRibbonButtonBar.
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0, bar=None, button=None):
        """
        RibbonButtonBarEvent(command_type=wx.wxEVT_NULL, win_id=0, bar=None, button=None)
        
        Event used to indicate various actions relating to a button on a
        wxRibbonButtonBar.
        """

    def GetBar(self):
        """
        GetBar() -> RibbonButtonBar
        
        Returns the bar which contains the button which the event relates to.
        """

    def SetBar(self, bar):
        """
        SetBar(bar)
        
        Sets the button bar relating to this event.
        """

    def GetButton(self):
        """
        GetButton() -> RibbonButtonBarButtonBase
        
        Returns the button which the event relates to.
        """

    def SetButton(self, bar):
        """
        SetButton(bar)
        
        Sets the button relating to this event.
        """

    def PopupMenu(self, menu):
        """
        PopupMenu(menu) -> bool
        
        Display a popup menu as a result of this (dropdown clicked) event.
        """
    Bar = property(None, None)
    Button = property(None, None)
# end of class RibbonButtonBarEvent


EVT_RIBBONBUTTONBAR_CLICKED = wx.PyEventBinder( wxEVT_RIBBONBUTTONBAR_CLICKED, 1 )
EVT_RIBBONBUTTONBAR_DROPDOWN_CLICKED = wx.PyEventBinder( wxEVT_RIBBONBUTTONBAR_DROPDOWN_CLICKED, 1 )
#-- end-ribbon_buttonbar --#
#-- begin-ribbon_gallery --#
RIBBON_GALLERY_BUTTON_NORMAL = 0
RIBBON_GALLERY_BUTTON_HOVERED = 0
RIBBON_GALLERY_BUTTON_ACTIVE = 0
RIBBON_GALLERY_BUTTON_DISABLED = 0
wxEVT_RIBBONGALLERY_HOVER_CHANGED = 0
wxEVT_RIBBONGALLERY_SELECTED = 0
wxEVT_RIBBONGALLERY_CLICKED = 0

class RibbonGallery(RibbonControl):
    """
    RibbonGallery()
    RibbonGallery(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    
    A ribbon gallery is like a wxListBox, but for bitmaps rather than
    strings.
    """

    def __init__(self, *args, **kw):
        """
        RibbonGallery()
        RibbonGallery(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        
        A ribbon gallery is like a wxListBox, but for bitmaps rather than
        strings.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Create a gallery in two-step gallery construction.
        """

    def Clear(self):
        """
        Clear()
        
        Remove all items from the gallery.
        """

    def IsEmpty(self):
        """
        IsEmpty() -> bool
        
        Query if the gallery has no items in it.
        """

    def GetCount(self):
        """
        GetCount() -> unsignedint
        
        Get the number of items in the gallery.
        """

    def GetItem(self, n):
        """
        GetItem(n) -> RibbonGalleryItem
        
        Get an item by index.
        """

    def Append(self, *args, **kw):
        """
        Append(bitmap, id) -> RibbonGalleryItem
        Append(bitmap, id, clientData) -> RibbonGalleryItem
        
        Add an item to the gallery (with no client data).
        """

    def SetItemClientData(self, item, data):
        """
        SetItemClientData(item, data)
        
        Set the client object associated with a gallery item.
        """

    def GetItemClientData(self, item):
        """
        GetItemClientData(item) -> ClientData
        
        Get the client object associated with a gallery item.
        """

    def SetSelection(self, item):
        """
        SetSelection(item)
        
        Set the selection to the given item, or removes the selection if item
        == NULL.
        """

    def GetSelection(self):
        """
        GetSelection() -> RibbonGalleryItem
        
        Get the currently selected item, or NULL if there is none.
        """

    def GetHoveredItem(self):
        """
        GetHoveredItem() -> RibbonGalleryItem
        
        Get the currently hovered item, or NULL if there is none.
        """

    def GetActiveItem(self):
        """
        GetActiveItem() -> RibbonGalleryItem
        
        Get the currently active item, or NULL if there is none.
        """

    def GetUpButtonState(self):
        """
        GetUpButtonState() -> RibbonGalleryButtonState
        
        Get the state of the scroll up button.
        """

    def GetDownButtonState(self):
        """
        GetDownButtonState() -> RibbonGalleryButtonState
        
        Get the state of the scroll down button.
        """

    def GetExtensionButtonState(self):
        """
        GetExtensionButtonState() -> RibbonGalleryButtonState
        
        Get the state of the "extension" button.
        """

    def IsHovered(self):
        """
        IsHovered() -> bool
        
        Query is the mouse is currently hovered over the gallery.
        """

    def ScrollLines(self, lines):
        """
        ScrollLines(lines) -> bool
        
        Scroll the gallery contents by some amount.
        """

    def ScrollPixels(self, pixels):
        """
        ScrollPixels(pixels) -> bool
        
        Scroll the gallery contents by some fine-grained amount.
        """

    def EnsureVisible(self, item):
        """
        EnsureVisible(item)
        
        Scroll the gallery to ensure that the given item is visible.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
    ActiveItem = property(None, None)
    Count = property(None, None)
    DownButtonState = property(None, None)
    ExtensionButtonState = property(None, None)
    HoveredItem = property(None, None)
    Selection = property(None, None)
    UpButtonState = property(None, None)
# end of class RibbonGallery


class RibbonGalleryEvent(wx.CommandEvent):
    """
    RibbonGalleryEvent(command_type=wx.wxEVT_NULL, win_id=0, gallery=None, item=None)
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0, gallery=None, item=None):
        """
        RibbonGalleryEvent(command_type=wx.wxEVT_NULL, win_id=0, gallery=None, item=None)
        """

    def GetGallery(self):
        """
        GetGallery() -> RibbonGallery
        
        Returns the gallery which the event relates to.
        """

    def GetGalleryItem(self):
        """
        GetGalleryItem() -> RibbonGalleryItem
        
        Returns the gallery item which the event relates to, or NULL if it
        does not relate to an item.
        """

    def SetGallery(self, gallery):
        """
        SetGallery(gallery)
        
        Sets the gallery relating to this event.
        """

    def SetGalleryItem(self, item):
        """
        SetGalleryItem(item)
        
        Sets the gallery item relating to this event.
        """
    Gallery = property(None, None)
    GalleryItem = property(None, None)
# end of class RibbonGalleryEvent


EVT_RIBBONGALLERY_HOVER_CHANGED = wx.PyEventBinder( wxEVT_RIBBONGALLERY_HOVER_CHANGED, 1 )
EVT_RIBBONGALLERY_SELECTED = wx.PyEventBinder( wxEVT_RIBBONGALLERY_SELECTED, 1 )
EVT_RIBBONGALLERY_CLICKED = wx.PyEventBinder( wxEVT_RIBBONGALLERY_CLICKED, 1 )
#-- end-ribbon_gallery --#
#-- begin-ribbon_toolbar --#
wxEVT_RIBBONTOOLBAR_CLICKED = 0
wxEVT_RIBBONTOOLBAR_DROPDOWN_CLICKED = 0

class RibbonToolBar(RibbonControl):
    """
    RibbonToolBar()
    RibbonToolBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
    
    A ribbon tool bar is similar to a traditional toolbar which has no
    labels.
    """

    def __init__(self, *args, **kw):
        """
        RibbonToolBar()
        RibbonToolBar(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0)
        
        A ribbon tool bar is similar to a traditional toolbar which has no
        labels.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0) -> bool
        
        Create a tool bar in two-step tool bar construction.
        """

    def AddTool(self, *args, **kw):
        """
        AddTool(tool_id, bitmap, help_string, kind=RIBBON_BUTTON_NORMAL) -> RibbonToolBarToolBase
        AddTool(tool_id, bitmap, bitmap_disabled=wx.NullBitmap, help_string=wx.EmptyString, kind=RIBBON_BUTTON_NORMAL, clientData=None) -> RibbonToolBarToolBase
        
        Add a tool to the tool bar (simple version).
        """

    def AddDropdownTool(self, tool_id, bitmap, help_string=wx.EmptyString):
        """
        AddDropdownTool(tool_id, bitmap, help_string=wx.EmptyString) -> RibbonToolBarToolBase
        
        Add a dropdown tool to the tool bar (simple version).
        """

    def AddHybridTool(self, tool_id, bitmap, help_string=wx.EmptyString):
        """
        AddHybridTool(tool_id, bitmap, help_string=wx.EmptyString) -> RibbonToolBarToolBase
        
        Add a hybrid tool to the tool bar (simple version).
        """

    def AddToggleTool(self, tool_id, bitmap, help_string):
        """
        AddToggleTool(tool_id, bitmap, help_string) -> RibbonToolBarToolBase
        
        Add a toggle tool to the tool bar (simple version).
        """

    def AddSeparator(self):
        """
        AddSeparator() -> RibbonToolBarToolBase
        
        Add a separator to the tool bar.
        """

    def InsertTool(self, *args, **kw):
        """
        InsertTool(pos, tool_id, bitmap, help_string, kind=RIBBON_BUTTON_NORMAL) -> RibbonToolBarToolBase
        InsertTool(pos, tool_id, bitmap, bitmap_disabled=wx.NullBitmap, help_string=wx.EmptyString, kind=RIBBON_BUTTON_NORMAL, clientData=None) -> RibbonToolBarToolBase
        
        Insert a tool to the tool bar (simple version) as the specified
        position.
        """

    def InsertDropdownTool(self, pos, tool_id, bitmap, help_string=wx.EmptyString):
        """
        InsertDropdownTool(pos, tool_id, bitmap, help_string=wx.EmptyString) -> RibbonToolBarToolBase
        
        Insert a dropdown tool to the tool bar (simple version) as the
        specified position.
        """

    def InsertHybridTool(self, pos, tool_id, bitmap, help_string=wx.EmptyString):
        """
        InsertHybridTool(pos, tool_id, bitmap, help_string=wx.EmptyString) -> RibbonToolBarToolBase
        
        Insert a hybrid tool to the tool bar (simple version) as the specified
        position.
        """

    def InsertToggleTool(self, pos, tool_id, bitmap, help_string=wx.EmptyString):
        """
        InsertToggleTool(pos, tool_id, bitmap, help_string=wx.EmptyString) -> RibbonToolBarToolBase
        
        Insert a toggle tool to the tool bar (simple version) as the specified
        position.
        """

    def InsertSeparator(self, pos):
        """
        InsertSeparator(pos) -> RibbonToolBarToolBase
        
        Insert a separator to the tool bar at the specified position.
        """

    def ClearTools(self):
        """
        ClearTools()
        
        Deletes all the tools in the toolbar.
        """

    def DeleteTool(self, tool_id):
        """
        DeleteTool(tool_id) -> bool
        
        Removes the specified tool from the toolbar and deletes it.
        """

    def DeleteToolByPos(self, pos):
        """
        DeleteToolByPos(pos) -> bool
        
        This function behaves like DeleteTool() but it deletes the tool at the
        specified position and not the one with the given id.
        """

    def FindById(self, tool_id):
        """
        FindById(tool_id) -> RibbonToolBarToolBase
        
        Returns a pointer to the tool opaque structure by id or NULL if no
        corresponding tool is found.
        """

    def GetToolByPos(self, pos):
        """
        GetToolByPos(pos) -> RibbonToolBarToolBase
        
        Return the opaque pointer corresponding to the given tool.
        """

    def GetToolId(self, tool):
        """
        GetToolId(tool) -> int
        
        Return the id assciated to the tool opaque structure.
        """

    def GetToolClientData(self, tool_id):
        """
        GetToolClientData(tool_id) -> PyUserData
        
        Get any client data associated with the tool.
        """

    def GetToolEnabled(self, tool_id):
        """
        GetToolEnabled(tool_id) -> bool
        
        Called to determine whether a tool is enabled (responds to user
        input).
        """

    def GetToolHelpString(self, tool_id):
        """
        GetToolHelpString(tool_id) -> String
        
        Returns the help string for the given tool.
        """

    def GetToolKind(self, tool_id):
        """
        GetToolKind(tool_id) -> RibbonButtonKind
        
        Return the kind of the given tool.
        """

    def GetToolPos(self, tool_id):
        """
        GetToolPos(tool_id) -> int
        
        Returns the tool position in the toolbar, or wxNOT_FOUND if the tool
        is not found.
        """

    def GetToolState(self, tool_id):
        """
        GetToolState(tool_id) -> bool
        
        Gets the on/off state of a toggle tool.
        """

    def Realize(self):
        """
        Realize() -> bool
        
        Calculate tool layouts and positions.
        """

    def SetRows(self, nMin, nMax=-1):
        """
        SetRows(nMin, nMax=-1)
        
        Set the number of rows to distribute tool groups over.
        """

    def SetToolClientData(self, tool_id, clientData):
        """
        SetToolClientData(tool_id, clientData)
        
        Sets the client data associated with the tool.
        """

    def SetToolDisabledBitmap(self, tool_id, bitmap):
        """
        SetToolDisabledBitmap(tool_id, bitmap)
        
        Sets the bitmap to be used by the tool with the given ID when the tool
        is in a disabled state.
        """

    def SetToolHelpString(self, tool_id, helpString):
        """
        SetToolHelpString(tool_id, helpString)
        
        Sets the help string shown in tooltip for the given tool.
        """

    def SetToolNormalBitmap(self, tool_id, bitmap):
        """
        SetToolNormalBitmap(tool_id, bitmap)
        
        Sets the bitmap to be used by the tool with the given ID.
        """

    def EnableTool(self, tool_id, enable=True):
        """
        EnableTool(tool_id, enable=True)
        
        Enable or disable a single tool on the bar.
        """

    def ToggleTool(self, tool_id, checked):
        """
        ToggleTool(tool_id, checked)
        
        Set a toggle tool to the checked or unchecked state.
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """
# end of class RibbonToolBar


class RibbonToolBarEvent(wx.CommandEvent):
    """
    RibbonToolBarEvent(command_type=wx.wxEVT_NULL, win_id=0, bar=None)
    """

    def __init__(self, command_type=wx.wxEVT_NULL, win_id=0, bar=None):
        """
        RibbonToolBarEvent(command_type=wx.wxEVT_NULL, win_id=0, bar=None)
        """

    def GetBar(self):
        """
        GetBar() -> RibbonToolBar
        """

    def SetBar(self, bar):
        """
        SetBar(bar)
        """

    def PopupMenu(self, menu):
        """
        PopupMenu(menu) -> bool
        """
    Bar = property(None, None)
# end of class RibbonToolBarEvent


EVT_RIBBONTOOLBAR_CLICKED = wx.PyEventBinder( wxEVT_RIBBONTOOLBAR_CLICKED, 1 )
EVT_RIBBONTOOLBAR_DROPDOWN_CLICKED = wx.PyEventBinder( wxEVT_RIBBONTOOLBAR_DROPDOWN_CLICKED, 1 )
#-- end-ribbon_toolbar --#
