
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "loadrequest_wrapper.h"

// inner classes

// Extra includes
#include <loadrequest.h>
#include <qbytearray.h>
#include <qurl.h>
#include <qwebenginehttprequest.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LoadRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LoadRequest >()))
        return -1;

    ::LoadRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_LoadRequest_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:LoadRequest", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: LoadRequest::LoadRequest()
    // 1: LoadRequest::LoadRequest(LoadRequest)
    // 2: LoadRequest::LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // LoadRequest()
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2])))) {
                overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // LoadRequest(LoadRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_LoadRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // LoadRequest()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_LoadRequest_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // LoadRequest()
                cptr = new ::LoadRequest();
            }
            break;
        }
        case 1: // LoadRequest(const LoadRequest & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_LoadRequest_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::LoadRequest cppArg0_local;
            ::LoadRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // LoadRequest(LoadRequest)
                cptr = new ::LoadRequest(*cppArg0);
            }
            break;
        }
        case 2: // LoadRequest(const QUrl & url, LoadRequest::Operation op, const QByteArray & data)
        {
            if (kwds) {
                PyObject *value{};
                PyObject *kwds_dup = PyDict_Copy(kwds);
                static PyObject *const key_op = Shiboken::String::createStaticString("op");
                if (PyDict_Contains(kwds, key_op)) {
                    value = PyDict_GetItem(kwds, key_op);
                    if (value && pyArgs[1]) {
                        errInfo = key_op;
                        Py_INCREF(errInfo);
                        goto Sbk_LoadRequest_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_LoadRequest_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_op);
                }
                static PyObject *const key_data = Shiboken::String::createStaticString("data");
                if (PyDict_Contains(kwds, key_data)) {
                    value = PyDict_GetItem(kwds, key_data);
                    if (value && pyArgs[2]) {
                        errInfo = key_data;
                        Py_INCREF(errInfo);
                        goto Sbk_LoadRequest_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2]))))
                            goto Sbk_LoadRequest_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_data);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup;
                    goto Sbk_LoadRequest_Init_TypeError;
                } else {
                    Py_DECREF(kwds_dup);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::LoadRequest::Operation cppArg1 = LoadRequest::Operation::GetOperation;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QByteArray cppArg2_local = QByteArray();
            ::QByteArray *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
                cptr = new ::LoadRequest(*cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::LoadRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_LoadRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_LoadRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_LoadRequestFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QByteArray cppResult = const_cast<const ::LoadRequest *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequestFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::LoadRequest *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequestFunc_operation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.operation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operation()const
            LoadRequest::Operation cppResult = LoadRequest::Operation(const_cast<const ::LoadRequest *>(cppSelf)->operation());
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequestFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_LoadRequestFunc_setData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setData(QByteArray)
            cppSelf->setData(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_LoadRequestFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_LoadRequestFunc_setOperation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.setOperation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setOperation(LoadRequest::Operation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOperation(LoadRequest::Operation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_LoadRequestFunc_setOperation_TypeError;

    // Call function/method
    {
        ::LoadRequest::Operation cppArg0{LoadRequest::GetOperation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOperation(LoadRequest::Operation)
            cppSelf->setOperation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_LoadRequestFunc_setOperation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_LoadRequestFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_LoadRequestFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_LoadRequestFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_LoadRequestFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::LoadRequest *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequestFunc_urlString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.urlString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // urlString()const
            QString cppResult = const_cast<const ::LoadRequest *>(cppSelf)->urlString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequestFunc_webRequest(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.LoadRequest.webRequest";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // webRequest()const
            QWebEngineHttpRequest* cppResult = new QWebEngineHttpRequest(const_cast<const ::LoadRequest *>(cppSelf)->webRequest());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_LoadRequest___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_LoadRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_LoadRequest_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_data), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_isValid), METH_NOARGS},
    {"operation", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_operation), METH_NOARGS},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setData), METH_O},
    {"setOperation", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setOperation), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setUrl), METH_O},
    {"url", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_url), METH_NOARGS},
    {"urlString", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_urlString), METH_NOARGS},
    {"webRequest", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_webRequest), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_LoadRequest___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_LoadRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_LoadRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_LoadRequest_Type = nullptr;
static SbkObjectType *Sbk_LoadRequest_TypeF(void)
{
    return _Sbk_LoadRequest_Type;
}

static PyType_Slot Sbk_LoadRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LoadRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LoadRequest_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LoadRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LoadRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_LoadRequest_spec = {
    "1:PyFalkon.LoadRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_LoadRequest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void LoadRequest_Operation_PythonToCpp_LoadRequest_Operation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::LoadRequest::Operation *>(cppOut) =
        static_cast<::LoadRequest::Operation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_LoadRequest_Operation_PythonToCpp_LoadRequest_Operation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX]))
        return LoadRequest_Operation_PythonToCpp_LoadRequest_Operation;
    return {};
}
static PyObject *LoadRequest_Operation_CppToPython_LoadRequest_Operation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::LoadRequest::Operation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LoadRequest_PythonToCpp_LoadRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_LoadRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LoadRequest_PythonToCpp_LoadRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_LoadRequest_TypeF())))
        return LoadRequest_PythonToCpp_LoadRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LoadRequest_PTR_CppToPython_LoadRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::LoadRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_LoadRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *LoadRequest_COPY_CppToPython_LoadRequest(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_LoadRequest_TypeF(), new ::LoadRequest(*reinterpret_cast<const ::LoadRequest *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void LoadRequest_PythonToCpp_LoadRequest_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::LoadRequest *>(cppOut) = *reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_LOADREQUEST_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_LoadRequest_PythonToCpp_LoadRequest_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_LoadRequest_TypeF())))
        return LoadRequest_PythonToCpp_LoadRequest_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQUrlREF_PythonToCpp_LoadRequest(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::LoadRequest *>(cppOut) = ::LoadRequest( *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQUrlREF_PythonToCpp_LoadRequest_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], pyIn))
        return PySide2_QtCore_constQUrlREF_PythonToCpp_LoadRequest;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *LoadRequest_SignatureStrings[] = {
    "2:PyFalkon.LoadRequest(self)",
    "1:PyFalkon.LoadRequest(self,other:PyFalkon.LoadRequest)",
    "0:PyFalkon.LoadRequest(self,url:PySide2.QtCore.QUrl,op:PyFalkon.LoadRequest.Operation=GetOperation,data:PySide2.QtCore.QByteArray=QByteArray())",
    "PyFalkon.LoadRequest.data(self)->PySide2.QtCore.QByteArray",
    "PyFalkon.LoadRequest.isValid(self)->bool",
    "PyFalkon.LoadRequest.operation(self)->PyFalkon.LoadRequest.Operation",
    "PyFalkon.LoadRequest.setData(self,data:PySide2.QtCore.QByteArray)",
    "PyFalkon.LoadRequest.setOperation(self,op:PyFalkon.LoadRequest.Operation)",
    "PyFalkon.LoadRequest.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PyFalkon.LoadRequest.url(self)->PySide2.QtCore.QUrl",
    "PyFalkon.LoadRequest.urlString(self)->QString",
    "PyFalkon.LoadRequest.webRequest(self)->PySide2.QtWebEngineCore.QWebEngineHttpRequest",
    "PyFalkon.LoadRequest.__copy__()",
    nullptr}; // Sentinel

void init_LoadRequest(PyObject *module)
{
    _Sbk_LoadRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "LoadRequest",
        "LoadRequest",
        &Sbk_LoadRequest_spec,
        &Shiboken::callCppDestructor< ::LoadRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_LoadRequest_Type);
    InitSignatureStrings(pyType, LoadRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_LoadRequest_Type), Sbk_LoadRequest_PropertyStrings);
    SbkPyFalkonTypes[SBK_LOADREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_LoadRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_LoadRequest_TypeF(),
        LoadRequest_PythonToCpp_LoadRequest_PTR,
        is_LoadRequest_PythonToCpp_LoadRequest_PTR_Convertible,
        LoadRequest_PTR_CppToPython_LoadRequest,
        LoadRequest_COPY_CppToPython_LoadRequest);

    Shiboken::Conversions::registerConverterName(converter, "LoadRequest");
    Shiboken::Conversions::registerConverterName(converter, "LoadRequest*");
    Shiboken::Conversions::registerConverterName(converter, "LoadRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LoadRequest).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        LoadRequest_PythonToCpp_LoadRequest_COPY,
        is_LoadRequest_PythonToCpp_LoadRequest_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQUrlREF_PythonToCpp_LoadRequest,
        is_PySide2_QtCore_constQUrlREF_PythonToCpp_LoadRequest_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Operation'.
    SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_LoadRequest_TypeF(),
        "Operation",
        "1:PyFalkon.LoadRequest.Operation",
        "LoadRequest::Operation");
    if (!SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX],
        Sbk_LoadRequest_TypeF(), "GetOperation", (long) LoadRequest::Operation::GetOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX],
        Sbk_LoadRequest_TypeF(), "PostOperation", (long) LoadRequest::Operation::PostOperation))
        return;
    // Register converter for enum 'LoadRequest::Operation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX],
            LoadRequest_Operation_CppToPython_LoadRequest_Operation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            LoadRequest_Operation_PythonToCpp_LoadRequest_Operation,
            is_LoadRequest_Operation_PythonToCpp_LoadRequest_Operation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_LOADREQUEST_OPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "LoadRequest::Operation");
        Shiboken::Conversions::registerConverterName(converter, "Operation");
    }
    // End of 'Operation' enum.


    qRegisterMetaType< ::LoadRequest >("LoadRequest");
    qRegisterMetaType< ::LoadRequest::Operation >("LoadRequest::Operation");
}
