/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;

public class StackTraceElementCompositeData
extends LazyCompositeData {
    private final StackTraceElement ste;
    private static final CompositeType stackTraceElementCompositeType;
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String FILE_NAME = "fileName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String NATIVE_METHOD = "nativeMethod";
    private static final String[] stackTraceElementItemNames;
    private static final long serialVersionUID = -2704607706598396827L;

    private StackTraceElementCompositeData(StackTraceElement ste) {
        this.ste = ste;
    }

    public StackTraceElement getStackTraceElement() {
        return this.ste;
    }

    public static StackTraceElement from(CompositeData cd) {
        StackTraceElementCompositeData.validateCompositeData(cd);
        return new StackTraceElement(StackTraceElementCompositeData.getString(cd, CLASS_NAME), StackTraceElementCompositeData.getString(cd, METHOD_NAME), StackTraceElementCompositeData.getString(cd, FILE_NAME), StackTraceElementCompositeData.getInt(cd, LINE_NUMBER));
    }

    public static CompositeData toCompositeData(StackTraceElement ste) {
        StackTraceElementCompositeData cd = new StackTraceElementCompositeData(ste);
        return cd.getCompositeData();
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] stackTraceElementItemValues = new Object[]{this.ste.getClassName(), this.ste.getMethodName(), this.ste.getFileName(), new Integer(this.ste.getLineNumber()), new Boolean(this.ste.isNativeMethod())};
        try {
            return new CompositeDataSupport(stackTraceElementCompositeType, stackTraceElementItemNames, stackTraceElementItemValues);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void validateCompositeData(CompositeData cd) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!StackTraceElementCompositeData.isTypeMatched(stackTraceElementCompositeType, cd.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for StackTraceElement");
        }
    }

    static {
        try {
            stackTraceElementCompositeType = (CompositeType)MappedMXBeanType.toOpenType(StackTraceElement.class);
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
        stackTraceElementItemNames = new String[]{CLASS_NAME, METHOD_NAME, FILE_NAME, LINE_NUMBER, NATIVE_METHOD};
    }
}

