/* sortedset.c generated by valac 0.56.0, the Vala compiler
 * generated from sortedset.vala, do not modify */

/* sortedset.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static GType gee_sorted_set_get_type_once (void);

/**
 * Returns the first element of the sorted set. Set must not be empty.
 *
 * @return the first element in the sorted set
 */
gpointer
gee_sorted_set_first (GeeSortedSet* self)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->first) {
		return _iface_->first (self);
	}
	return NULL;
}

/**
 * Returns the last element of the sorted set. Set must not be empty.
 *
 * @return the last element in the sorted set
 */
gpointer
gee_sorted_set_last (GeeSortedSet* self)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->last) {
		return _iface_->last (self);
	}
	return NULL;
}

/**
 * Returns a {@link BidirIterator} initially pointed at the specified
 * element.
 *
 * @param element the element to point the iterator at
 *
 * @return        a {@link BidirIterator} over this sorted set, or null if
 *                the specified element is not in this set
 */
GeeIterator*
gee_sorted_set_iterator_at (GeeSortedSet* self,
                            gconstpointer element)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->iterator_at) {
		return _iface_->iterator_at (self, element);
	}
	return NULL;
}

/**
 * Returns the element which is strictly lower than the specified element.
 *
 * @param element the element which you want the lower element for
 *
 * @return        the corresponding element
 */
gpointer
gee_sorted_set_lower (GeeSortedSet* self,
                      gconstpointer element)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->lower) {
		return _iface_->lower (self, element);
	}
	return NULL;
}

/**
 * Returns the element which is strictly higher than the specified element.
 *
 * @param element the element which you want the strictly higher element
 *                for
 *
 * @return        the corresponding element
 */
gpointer
gee_sorted_set_higher (GeeSortedSet* self,
                       gconstpointer element)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->higher) {
		return _iface_->higher (self, element);
	}
	return NULL;
}

/**
 * Returns the element which is lower or equal then the specified element.
 *
 * @param element the element which you want the lower or equal element for
 *
 * @return        the corresponding element
 */
gpointer
gee_sorted_set_floor (GeeSortedSet* self,
                      gconstpointer element)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->floor) {
		return _iface_->floor (self, element);
	}
	return NULL;
}

/**
 * Returns the element which is higher or equal then the specified element.
 *
 * @param element the element which you want the higher or equal element
 *                for
 *
 * @return        the corresponding element
 */
gpointer
gee_sorted_set_ceil (GeeSortedSet* self,
                     gconstpointer element)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->ceil) {
		return _iface_->ceil (self, element);
	}
	return NULL;
}

/**
 * Returns the sub-set of this sorted set containing elements strictly
 * lower than the specified element.
 *
 * @param before the lower inclusive bound for the sub-set
 *
 * @return     the corresponding sub-set of this sorted set
 */
GeeSortedSet*
gee_sorted_set_head_set (GeeSortedSet* self,
                         gconstpointer before)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->head_set) {
		return _iface_->head_set (self, before);
	}
	return NULL;
}

/**
 * Returns the sub-set of this sorted set containing elements equal or
 * higher than the specified element.
 *
 * @param after the higher exclusive bound for the sub-set
 *
 * @return   the corresponding sub-set of this sorted set
 */
GeeSortedSet*
gee_sorted_set_tail_set (GeeSortedSet* self,
                         gconstpointer after)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->tail_set) {
		return _iface_->tail_set (self, after);
	}
	return NULL;
}

/**
 * Returns the right-open sub-set of this sorted set, thus containing
 * elements equal or higher than the specified ``from`` element, and stricly
 * lower than the specified ``to`` element.
 *
 * @param from the lower inclusive bound for the sub-set
 * @param to   the higher exclusive bound for the sub-set
 *
 * @return     the corresponding sub-set of this sorted set
 */
GeeSortedSet*
gee_sorted_set_sub_set (GeeSortedSet* self,
                        gconstpointer from,
                        gconstpointer to)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->sub_set) {
		return _iface_->sub_set (self, from, to);
	}
	return NULL;
}

/**
 * Returns an immutable empty sorted set.
 *
 * @return an immutable empty sorted set
 */
GeeSortedSet*
gee_sorted_set_empty (GType g_type,
                      GBoxedCopyFunc g_dup_func,
                      GDestroyNotify g_destroy_func)
{
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp1_;
	GeeBidirSortedSet* _tmp2_;
	GeeBidirSortedSet* _tmp3_;
	GeeSortedSet* _tmp4_;
	GeeSortedSet* result;
	_tmp0_ = gee_tree_set_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_bidir_sorted_set_get_read_only_view ((GeeAbstractBidirSortedSet*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GeeSortedSet*) _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

GeeSortedSet*
gee_sorted_set_get_read_only_view (GeeSortedSet* self)
{
	GeeSortedSetIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_SET_GET_INTERFACE (self);
	if (_iface_->get_read_only_view) {
		return _iface_->get_read_only_view (self);
	}
	return NULL;
}

static void
gee_sorted_set_default_init (GeeSortedSetIface * iface,
                             gpointer iface_data)
{
	/**
	 * The read-only view of this set.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_SORTED_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

/**
 * A sorted set, which you can navigate over and get sub-sets of.
 */
static GType
gee_sorted_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeSortedSetIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_sorted_set_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_sorted_set_type_id;
	gee_sorted_set_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeSortedSet", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_sorted_set_type_id, GEE_TYPE_SET);
	return gee_sorted_set_type_id;
}

GType
gee_sorted_set_get_type (void)
{
	static volatile gsize gee_sorted_set_type_id__once = 0;
	if (g_once_init_enter (&gee_sorted_set_type_id__once)) {
		GType gee_sorted_set_type_id;
		gee_sorted_set_type_id = gee_sorted_set_get_type_once ();
		g_once_init_leave (&gee_sorted_set_type_id__once, gee_sorted_set_type_id);
	}
	return gee_sorted_set_type_id__once;
}

