/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-recur.h"
#include "libical-glib-private.h"
#include "i-cal-recurrence.h"

/**
 * i_cal_recur_expand_recurrence:
 * @rule: The rule of the recurrence
 * @start: The start seconds past the POSIX epoch
 * @count: The number of elements to be filled up in the @array
 *
 * Fills an array with the 'count' number of occurrences generated by the rrule. Note that the times are
 * returned in UTC, but the times are calculated in local time. YOu will have to convert the results back
 * into local time before using them.
 *
 * Returns: (array) (element-type long) (transfer full): If successful, return the array. NULL if failed.
 *
 * Since: 1.0
 *
 **/
GArray *
i_cal_recur_expand_recurrence (const gchar *rule, 
                               time_t start, 
                               gint count)
{
        time_t *array;
        GArray *garray;
        gint result;
        g_return_val_if_fail (rule != NULL, 0);
        array = g_new (time_t, count);
        result = icalrecur_expand_recurrence (rule, start, count, array);
        if (result == 0) {
                g_free (array);
                return NULL;
        } else {
                garray = g_array_new (FALSE, FALSE, sizeof (time_t));
                g_array_append_vals (garray, array, count);
                g_free (array);
                return garray;
        }
}

/**
 * i_cal_recurrence_weekday_from_string:
 * @str: The string representation of the weekday
 *
 * Converts a string representation to an enum representation for the weekday.
 *
 * Returns: The enum representation of the weekday.
 *
 * Since: 1.0
 *
 **/
ICalRecurrenceWeekday
i_cal_recurrence_weekday_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_NO_WEEKDAY);

	return (ICalRecurrenceWeekday) (icalrecur_string_to_weekday (str));
}

/**
 * i_cal_recurrence_weekday_to_string:
 * @kind: The frequency enum
 *
 * Converts a enum representation to a string representation for the weekday.
 *
 * Returns: The string representation of weekday
 *
 * Since: 2.0
 *
 **/
const gchar *
i_cal_recurrence_weekday_to_string (ICalRecurrenceWeekday kind)
{
	return icalrecur_weekday_to_string ((icalrecurrencetype_weekday) (kind));
}

/**
 * i_cal_recurrence_frequency_from_string:
 * @str: The string representation of the frequency
 *
 * Converts a string representation to an enum representation for the frequency.
 *
 * Returns: The enum representation of the frequency.
 *
 * Since: 2.0
 *
 **/
ICalRecurrenceFrequency
i_cal_recurrence_frequency_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_NO_RECURRENCE);

	return (ICalRecurrenceFrequency) (icalrecur_string_to_freq (str));
}

/**
 * i_cal_recurrence_frequency_to_string:
 * @kind: The frequency enum
 *
 * Converts a enum representation to a string representation for the frequency.
 *
 * Returns: The string representation of frequency
 *
 * Since: 2.0
 *
 **/
const gchar *
i_cal_recurrence_frequency_to_string (ICalRecurrenceFrequency kind)
{
	return icalrecur_freq_to_string ((icalrecurrencetype_frequency) (kind));
}

/**
 * i_cal_recurrence_skip_from_string:
 * @str: The string representation of the skip
 *
 * Converts a string representation to an enum representation for the skip.
 *
 * Returns: The enum representation of the skip.
 *
 * Since: 2.0
 *
 **/
ICalRecurrenceSkip
i_cal_recurrence_skip_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, I_CAL_SKIP_UNDEFINED);

	return (ICalRecurrenceSkip) (icalrecur_string_to_skip (str));
}

/**
 * i_cal_recurrence_skip_to_string:
 * @kind: The frequency enum
 *
 * Converts a enum representation to a string representation for the skip.
 *
 * Returns: The string representation of skip
 *
 * Since: 2.0
 *
 **/
const gchar *
i_cal_recurrence_skip_to_string (ICalRecurrenceSkip kind)
{
	return icalrecur_skip_to_string ((icalrecurrencetype_skip) (kind));
}
