/* key-data.c generated by valac 0.56.1, the Vala compiler
 * generated from key-data.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <glib-object.h>

enum  {
	SEAHORSE_SSH_KEY_DATA_0_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY,
	SEAHORSE_SSH_KEY_DATA_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	SEAHORSE_SSH_SEC_DATA_0_PROPERTY,
	SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY,
	SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY,
	SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY,
	SEAHORSE_SSH_SEC_DATA_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_NUM_PROPERTIES];

struct _SeahorseSshKeyDataPrivate {
	gchar* _privfile;
	gchar* _pubfile;
	gboolean _partial;
	gboolean _authorized;
	gchar* _rawdata;
	gchar* _comment;
	gchar* _fingerprint;
	guint _length;
	SeahorseSshAlgorithm _algo;
};

struct _SeahorseSshSecDataPrivate {
	gchar* _rawdata;
	gchar* _comment;
	SeahorseSshAlgorithm _algo;
};

static gint SeahorseSshKeyData_private_offset;
static gpointer seahorse_ssh_key_data_parent_class = NULL;
static gint SeahorseSshSecData_private_offset;
static gpointer seahorse_ssh_sec_data_parent_class = NULL;

VALA_EXTERN void seahorse_ssh_key_data_set_rawdata (SeahorseSshKeyData* self,
                                        const gchar* value);
VALA_EXTERN void seahorse_ssh_key_data_set_algo (SeahorseSshKeyData* self,
                                     SeahorseSshAlgorithm value);
VALA_EXTERN gchar* seahorse_ssh_key_data_parse_key_blob (guchar* bytes,
                                             gint bytes_length1,
                                             GError** error);
VALA_EXTERN void seahorse_ssh_key_data_set_fingerprint (SeahorseSshKeyData* self,
                                            const gchar* value);
VALA_EXTERN guint seahorse_ssh_key_data_calc_bits (SeahorseSshAlgorithm algo,
                                       guint len);
VALA_EXTERN void seahorse_ssh_key_data_set_length (SeahorseSshKeyData* self,
                                       guint value);
VALA_EXTERN void seahorse_ssh_key_data_set_comment (SeahorseSshKeyData* self,
                                        const gchar* value);
static void seahorse_ssh_key_data_finalize (GObject * obj);
static GType seahorse_ssh_key_data_get_type_once (void);
static void _vala_seahorse_ssh_key_data_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_ssh_key_data_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
VALA_EXTERN void seahorse_ssh_sec_data_set_comment (SeahorseSshSecData* self,
                                        const gchar* value);
static gchar* seahorse_ssh_sec_data_parse_lines_block (GString* data,
                                                const gchar* start,
                                                const gchar* end);
VALA_EXTERN void seahorse_ssh_sec_data_set_rawdata (SeahorseSshSecData* self,
                                        const gchar* value);
VALA_EXTERN void seahorse_ssh_sec_data_set_algo (SeahorseSshSecData* self,
                                     SeahorseSshAlgorithm value);
static void seahorse_ssh_sec_data_finalize (GObject * obj);
static GType seahorse_ssh_sec_data_get_type_once (void);
static void _vala_seahorse_ssh_sec_data_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_ssh_sec_data_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_key_data_get_instance_private (SeahorseSshKeyData* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshKeyData_private_offset);
}

gboolean
seahorse_ssh_key_data_is_valid (SeahorseSshKeyData* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_fingerprint;
	result = _tmp0_ != NULL;
	return result;
}

/**
     * Checks whether this key and another (in the form of a string) match.
     */
gboolean
seahorse_ssh_key_data_match (SeahorseSshKeyData* self,
                             const gchar* line)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (!seahorse_ssh_key_data_is_valid (self)) {
		result = FALSE;
		return result;
	}
	{
		SeahorseSshKeyData* other = NULL;
		SeahorseSshKeyData* _tmp0_;
		gboolean _tmp1_ = FALSE;
		SeahorseSshKeyData* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = seahorse_ssh_key_data_parse_line (line, &_inner_error0_);
		other = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = other;
		_tmp3_ = _tmp2_->priv->_fingerprint;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			SeahorseSshKeyData* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = self->priv->_fingerprint;
			_tmp5_ = other;
			_tmp6_ = _tmp5_->priv->_fingerprint;
			_tmp1_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		_g_object_unref0 (other);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("key-data.vala:51: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

SeahorseSshKeyData*
seahorse_ssh_key_data_parse_line (const gchar* line,
                                  GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* no_leading = NULL;
	gchar* _tmp4_;
	SeahorseSshKeyData* _result_ = NULL;
	SeahorseSshKeyData* _tmp5_;
	SeahorseSshKeyData* _tmp6_;
	const gchar* _tmp7_;
	gchar** type_rest = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint type_rest_length1;
	gint _type_rest_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* type = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	SeahorseSshKeyData* _tmp18_;
	const gchar* _tmp19_;
	SeahorseSshKeyData* _tmp20_;
	SeahorseSshAlgorithm _tmp21_;
	gchar* rest = NULL;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar** data_comment = NULL;
	const gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint data_comment_length1;
	gint _data_comment_size_;
	guchar* bytes = NULL;
	gchar** _tmp35_;
	gint _tmp35__length1;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gsize _tmp39_ = 0;
	guchar* _tmp40_;
	guchar* _tmp41_;
	gint _tmp41__length1;
	gint bytes_length1;
	gint _bytes_size_;
	gchar* _tmp42_ = NULL;
	guchar* _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	SeahorseSshKeyData* _tmp45_;
	SeahorseSshKeyData* _tmp46_;
	SeahorseSshKeyData* _tmp47_;
	SeahorseSshAlgorithm _tmp48_;
	guchar* _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp50_;
	gint _tmp50__length1;
	GError* _inner_error0_ = NULL;
	SeahorseSshKeyData* result;
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = string_strip (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
		_g_free0 (_tmp2_);
	}
	if (_tmp0_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't parse key from empty line.");
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = string_chug (line);
	no_leading = _tmp4_;
	_tmp5_ = seahorse_ssh_key_data_new ();
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	_tmp7_ = no_leading;
	seahorse_ssh_key_data_set_rawdata (_tmp6_, _tmp7_);
	_tmp8_ = no_leading;
	_tmp10_ = _tmp9_ = g_strsplit_set (_tmp8_, " \t", 2);
	type_rest = _tmp10_;
	type_rest_length1 = _vala_array_length (_tmp9_);
	_type_rest_size_ = type_rest_length1;
	_tmp11_ = type_rest;
	_tmp11__length1 = type_rest_length1;
	if (_tmp11__length1 != 2) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't distinguish type from data (space missing).");
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
		_g_free0 (no_leading);
		return NULL;
	}
	_tmp13_ = type_rest;
	_tmp13__length1 = type_rest_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = g_strdup (_tmp14_);
	type = _tmp15_;
	_tmp16_ = type;
	if (g_strcmp0 (_tmp16_, "") == 0) {
		GError* _tmp17_;
		_tmp17_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Key doesn't have a type.");
		_inner_error0_ = _tmp17_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (type);
		type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
		_g_free0 (no_leading);
		return NULL;
	}
	_tmp18_ = _result_;
	_tmp19_ = type;
	seahorse_ssh_key_data_set_algo (_tmp18_, seahorse_ssh_algorithm_guess_from_string (_tmp19_));
	_tmp20_ = _result_;
	_tmp21_ = _tmp20_->priv->_algo;
	if (_tmp21_ == SEAHORSE_SSH_ALGORITHM_UNKNOWN) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GError* _tmp25_;
		GError* _tmp26_;
		_tmp22_ = type;
		_tmp23_ = g_strdup_printf ("Key doesn't have a valid type (%s).", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_inner_error0_ = _tmp26_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (type);
		type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
		_g_free0 (no_leading);
		return NULL;
	}
	_tmp27_ = type_rest;
	_tmp27__length1 = type_rest_length1;
	_tmp28_ = _tmp27_[1];
	_tmp29_ = g_strdup (_tmp28_);
	rest = _tmp29_;
	_tmp30_ = rest;
	if (g_strcmp0 (_tmp30_, "") == 0) {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Key doesn't have any data.");
		_inner_error0_ = _tmp31_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (rest);
		_g_free0 (type);
		type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
		_g_free0 (no_leading);
		return NULL;
	}
	_tmp32_ = rest;
	_tmp34_ = _tmp33_ = g_strsplit_set (_tmp32_, " \t", 2);
	data_comment = _tmp34_;
	data_comment_length1 = _vala_array_length (_tmp33_);
	_data_comment_size_ = data_comment_length1;
	_tmp35_ = data_comment;
	_tmp35__length1 = data_comment_length1;
	_tmp36_ = _tmp35_[0];
	_tmp37_ = string_strip (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp40_ = g_base64_decode (_tmp38_, &_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp41__length1 = _tmp39_;
	_g_free0 (_tmp38_);
	bytes = _tmp41_;
	bytes_length1 = _tmp41__length1;
	_bytes_size_ = bytes_length1;
	_tmp43_ = bytes;
	_tmp43__length1 = bytes_length1;
	_tmp44_ = seahorse_ssh_key_data_parse_key_blob (_tmp43_, (gint) _tmp43__length1, &_inner_error0_);
	_tmp42_ = _tmp44_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		bytes = (g_free (bytes), NULL);
		data_comment = (_vala_array_free (data_comment, data_comment_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (rest);
		_g_free0 (type);
		type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_result_);
		_g_free0 (no_leading);
		return NULL;
	}
	_tmp45_ = _result_;
	seahorse_ssh_key_data_set_fingerprint (_tmp45_, _tmp42_);
	_tmp46_ = _result_;
	_tmp47_ = _result_;
	_tmp48_ = _tmp47_->priv->_algo;
	_tmp49_ = bytes;
	_tmp49__length1 = bytes_length1;
	seahorse_ssh_key_data_set_length (_tmp46_, seahorse_ssh_key_data_calc_bits (_tmp48_, (guint) _tmp49__length1));
	_tmp50_ = data_comment;
	_tmp50__length1 = data_comment_length1;
	if (_tmp50__length1 == 2) {
		gchar* comment = NULL;
		gchar** _tmp51_;
		gint _tmp51__length1;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp51_ = data_comment;
		_tmp51__length1 = data_comment_length1;
		_tmp52_ = _tmp51_[1];
		_tmp53_ = g_strdup (_tmp52_);
		comment = _tmp53_;
		_tmp54_ = comment;
		if (!g_utf8_validate (_tmp54_, (gssize) -1, NULL)) {
			gchar* _tmp55_ = NULL;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			gchar* _tmp60_;
			SeahorseSshKeyData* _tmp61_;
			_tmp56_ = comment;
			_tmp57_ = comment;
			_tmp58_ = strlen (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_convert (_tmp56_, (gssize) _tmp59_, "UTF-8", "ISO-8859-1", NULL, NULL, &_inner_error0_);
			_tmp55_ = _tmp60_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (comment);
				_g_free0 (_tmp42_);
				bytes = (g_free (bytes), NULL);
				data_comment = (_vala_array_free (data_comment, data_comment_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (rest);
				_g_free0 (type);
				type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_result_);
				_g_free0 (no_leading);
				return NULL;
			}
			_tmp61_ = _result_;
			seahorse_ssh_key_data_set_comment (_tmp61_, _tmp55_);
			_g_free0 (_tmp55_);
		} else {
			SeahorseSshKeyData* _tmp62_;
			const gchar* _tmp63_;
			_tmp62_ = _result_;
			_tmp63_ = comment;
			seahorse_ssh_key_data_set_comment (_tmp62_, _tmp63_);
		}
		_g_free0 (comment);
	}
	result = _result_;
	_g_free0 (_tmp42_);
	bytes = (g_free (bytes), NULL);
	data_comment = (_vala_array_free (data_comment, data_comment_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (rest);
	_g_free0 (type);
	type_rest = (_vala_array_free (type_rest, type_rest_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (no_leading);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
seahorse_ssh_key_data_parse_key_blob (guchar* bytes,
                                      gint bytes_length1,
                                      GError** error)
{
	gchar* digest = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GString* fingerprint = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GString* _tmp6_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_compute_checksum_for_data (G_CHECKSUM_MD5, bytes, (gint) bytes_length1);
	digest = _tmp0_;
	_tmp1_ = digest;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't calculate fingerprint from key.");
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (digest);
		return NULL;
	}
	_tmp3_ = digest;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_string_sized_new ((gsize) ((_tmp5_ * 3) / 2));
	fingerprint = _tmp6_;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				const gchar* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GString* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				if (!_tmp7_) {
					i += (gsize) 2;
				}
				_tmp7_ = FALSE;
				_tmp8_ = digest;
				_tmp9_ = strlen (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(i < ((gsize) _tmp10_))) {
					break;
				}
				if (i > ((gsize) 0)) {
					GString* _tmp11_;
					_tmp11_ = fingerprint;
					g_string_append_c (_tmp11_, ':');
				}
				_tmp12_ = fingerprint;
				_tmp13_ = digest;
				_tmp14_ = string_substring (_tmp13_, (glong) i, (glong) 2);
				_tmp15_ = _tmp14_;
				g_string_append (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
			}
		}
	}
	_tmp16_ = fingerprint;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_string_free0 (fingerprint);
	_g_free0 (digest);
	return result;
}

guint
seahorse_ssh_key_data_calc_bits (SeahorseSshAlgorithm algo,
                                 guint len)
{
	guint result;
	switch (algo) {
		case SEAHORSE_SSH_ALGORITHM_RSA:
		{
			result = (len - 23) * 8;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_DSA:
		{
			guint n = 0U;
			gint _tmp0_ = 0;
			n = ((len - 50) * 8) / 3;
			if ((n % 64) > ((guint) 32)) {
				_tmp0_ = 1;
			} else {
				_tmp0_ = 0;
			}
			result = ((n / 64) + _tmp0_) * 64;
			return result;
		}
		case SEAHORSE_SSH_ALGORITHM_ED25519:
		{
			result = (guint) 256;
			return result;
		}
		default:
		{
			result = (guint) 0;
			return result;
		}
	}
}

void
seahorse_ssh_key_data_filter_file (const gchar* filename,
                                   SeahorseSshKeyData* add,
                                   SeahorseSshKeyData* remove,
                                   GError** error)
{
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	GString* results = NULL;
	GString* _tmp1_;
	gboolean first = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar** lines = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GString* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	if (remove == NULL) {
		remove = add;
	}
	g_file_get_contents (filename, &_tmp0_, NULL, &_inner_error0_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (contents);
		return;
	}
	_tmp1_ = g_string_new ("");
	results = _tmp1_;
	first = TRUE;
	_tmp3_ = contents;
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		_tmp2_ = "";
	}
	_tmp5_ = _tmp4_ = g_strsplit (_tmp2_, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = lines_length1;
	_tmp6_ = lines;
	_tmp6__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp6_;
		line_collection_length1 = _tmp6__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp7_;
			gchar* line = NULL;
			_tmp7_ = g_strdup (line_collection[line_it]);
			line = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				GString* _tmp11_;
				const gchar* _tmp12_;
				if (remove != NULL) {
					const gchar* _tmp9_;
					_tmp9_ = line;
					_tmp8_ = seahorse_ssh_key_data_match (remove, _tmp9_);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_g_free0 (line);
					continue;
				}
				if (!first) {
					GString* _tmp10_;
					_tmp10_ = results;
					g_string_append_c (_tmp10_, '\n');
				}
				first = FALSE;
				_tmp11_ = results;
				_tmp12_ = line;
				g_string_append (_tmp11_, _tmp12_);
				_g_free0 (line);
			}
		}
	}
	if (add != NULL) {
		GString* _tmp14_;
		const gchar* _tmp15_;
		if (!first) {
			GString* _tmp13_;
			_tmp13_ = results;
			g_string_append_c (_tmp13_, '\n');
		}
		_tmp14_ = results;
		_tmp15_ = add->priv->_rawdata;
		g_string_append (_tmp14_, _tmp15_);
	}
	_tmp16_ = results;
	_tmp17_ = _tmp16_->str;
	g_file_set_contents (filename, _tmp17_, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (results);
		_g_free0 (contents);
		return;
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (results);
	_g_free0 (contents);
}

gchar*
seahorse_ssh_key_data_get_location (SeahorseSshKeyData* self)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_privfile;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_privfile;
		_tmp0_ = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_pubfile;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	result = _tmp4_;
	return result;
}

SeahorseSshKeyData*
seahorse_ssh_key_data_construct (GType object_type)
{
	SeahorseSshKeyData * self = NULL;
	self = (SeahorseSshKeyData*) g_object_new (object_type, NULL);
	return self;
}

SeahorseSshKeyData*
seahorse_ssh_key_data_new (void)
{
	return seahorse_ssh_key_data_construct (SEAHORSE_SSH_TYPE_KEY_DATA);
}

const gchar*
seahorse_ssh_key_data_get_privfile (SeahorseSshKeyData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_privfile;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_data_set_privfile (SeahorseSshKeyData* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_privfile (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_privfile);
		self->priv->_privfile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY]);
	}
}

const gchar*
seahorse_ssh_key_data_get_pubfile (SeahorseSshKeyData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pubfile;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_data_set_pubfile (SeahorseSshKeyData* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_pubfile (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_pubfile);
		self->priv->_pubfile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY]);
	}
}

gboolean
seahorse_ssh_key_data_get_partial (SeahorseSshKeyData* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_partial;
	return result;
}

void
seahorse_ssh_key_data_set_partial (SeahorseSshKeyData* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_partial (self);
	if (old_value != value) {
		self->priv->_partial = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY]);
	}
}

gboolean
seahorse_ssh_key_data_get_authorized (SeahorseSshKeyData* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_authorized;
	return result;
}

void
seahorse_ssh_key_data_set_authorized (SeahorseSshKeyData* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_authorized (self);
	if (old_value != value) {
		self->priv->_authorized = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY]);
	}
}

const gchar*
seahorse_ssh_key_data_get_rawdata (SeahorseSshKeyData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rawdata;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_data_set_rawdata (SeahorseSshKeyData* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_rawdata (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_rawdata);
		self->priv->_rawdata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY]);
	}
}

const gchar*
seahorse_ssh_key_data_get_comment (SeahorseSshKeyData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_data_set_comment (SeahorseSshKeyData* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_comment (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_comment);
		self->priv->_comment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY]);
	}
}

const gchar*
seahorse_ssh_key_data_get_fingerprint (SeahorseSshKeyData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fingerprint;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_data_set_fingerprint (SeahorseSshKeyData* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_fingerprint (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_fingerprint);
		self->priv->_fingerprint = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY]);
	}
}

guint
seahorse_ssh_key_data_get_length (SeahorseSshKeyData* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_length;
	return result;
}

void
seahorse_ssh_key_data_set_length (SeahorseSshKeyData* self,
                                  guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_length (self);
	if (old_value != value) {
		self->priv->_length = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY]);
	}
}

SeahorseSshAlgorithm
seahorse_ssh_key_data_get_algo (SeahorseSshKeyData* self)
{
	SeahorseSshAlgorithm result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_algo;
	return result;
}

void
seahorse_ssh_key_data_set_algo (SeahorseSshKeyData* self,
                                SeahorseSshAlgorithm value)
{
	SeahorseSshAlgorithm old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_key_data_get_algo (self);
	if (old_value != value) {
		self->priv->_algo = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY]);
	}
}

static void
seahorse_ssh_key_data_class_init (SeahorseSshKeyDataClass * klass,
                                  gpointer klass_data)
{
	seahorse_ssh_key_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshKeyData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_key_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_key_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_key_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY] = g_param_spec_string ("privfile", "privfile", "privfile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY] = g_param_spec_string ("pubfile", "pubfile", "pubfile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY] = g_param_spec_boolean ("partial", "partial", "partial", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY] = g_param_spec_boolean ("authorized", "authorized", "authorized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY] = g_param_spec_string ("rawdata", "rawdata", "rawdata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY] = g_param_spec_string ("fingerprint", "fingerprint", "fingerprint", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY, seahorse_ssh_key_data_properties[SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY] = g_param_spec_enum ("algo", "algo", "algo", SEAHORSE_SSH_TYPE_ALGORITHM, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_ssh_key_data_instance_init (SeahorseSshKeyData * self,
                                     gpointer klass)
{
	self->priv = seahorse_ssh_key_data_get_instance_private (self);
	self->priv->_authorized = FALSE;
}

static void
seahorse_ssh_key_data_finalize (GObject * obj)
{
	SeahorseSshKeyData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyData);
	_g_free0 (self->priv->_privfile);
	_g_free0 (self->priv->_pubfile);
	_g_free0 (self->priv->_rawdata);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_fingerprint);
	G_OBJECT_CLASS (seahorse_ssh_key_data_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_key_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshKeyDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_key_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshKeyData), 0, (GInstanceInitFunc) seahorse_ssh_key_data_instance_init, NULL };
	GType seahorse_ssh_key_data_type_id;
	seahorse_ssh_key_data_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshKeyData", &g_define_type_info, 0);
	SeahorseSshKeyData_private_offset = g_type_add_instance_private (seahorse_ssh_key_data_type_id, sizeof (SeahorseSshKeyDataPrivate));
	return seahorse_ssh_key_data_type_id;
}

GType
seahorse_ssh_key_data_get_type (void)
{
	static volatile gsize seahorse_ssh_key_data_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_key_data_type_id__once)) {
		GType seahorse_ssh_key_data_type_id;
		seahorse_ssh_key_data_type_id = seahorse_ssh_key_data_get_type_once ();
		g_once_init_leave (&seahorse_ssh_key_data_type_id__once, seahorse_ssh_key_data_type_id);
	}
	return seahorse_ssh_key_data_type_id__once;
}

static void
_vala_seahorse_ssh_key_data_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshKeyData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyData);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_data_get_privfile (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_data_get_pubfile (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY:
		g_value_set_boolean (value, seahorse_ssh_key_data_get_partial (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY:
		g_value_set_boolean (value, seahorse_ssh_key_data_get_authorized (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_data_get_rawdata (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_data_get_comment (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_data_get_fingerprint (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY:
		g_value_set_uint (value, seahorse_ssh_key_data_get_length (self));
		break;
		case SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY:
		g_value_set_enum (value, seahorse_ssh_key_data_get_algo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_key_data_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshKeyData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY_DATA, SeahorseSshKeyData);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_DATA_PRIVFILE_PROPERTY:
		seahorse_ssh_key_data_set_privfile (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_PUBFILE_PROPERTY:
		seahorse_ssh_key_data_set_pubfile (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_PARTIAL_PROPERTY:
		seahorse_ssh_key_data_set_partial (self, g_value_get_boolean (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_AUTHORIZED_PROPERTY:
		seahorse_ssh_key_data_set_authorized (self, g_value_get_boolean (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_RAWDATA_PROPERTY:
		seahorse_ssh_key_data_set_rawdata (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_COMMENT_PROPERTY:
		seahorse_ssh_key_data_set_comment (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_FINGERPRINT_PROPERTY:
		seahorse_ssh_key_data_set_fingerprint (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_LENGTH_PROPERTY:
		seahorse_ssh_key_data_set_length (self, g_value_get_uint (value));
		break;
		case SEAHORSE_SSH_KEY_DATA_ALGO_PROPERTY:
		seahorse_ssh_key_data_set_algo (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
seahorse_ssh_sec_data_get_instance_private (SeahorseSshSecData* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshSecData_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
seahorse_ssh_sec_data_contains_private_key (const gchar* data)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (data != NULL, FALSE);
	if (string_contains (data, SEAHORSE_SSH_SEC_DATA_SSH_KEY_SECRET_SIG)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_contains (data, SEAHORSE_SSH_SEC_DATA_SSH_PRIVATE_BEGIN);
	}
	result = _tmp0_;
	return result;
}

/**
     * Finds the first occurence of a private key in the given string and parses it if found.
     * NOTE: after parsing, it will *remove* the data with the private key from the string.
     *
     * @param data The data that contains a private key.
     */
SeahorseSshSecData*
seahorse_ssh_sec_data_parse_data (GString* data,
                                  GError** error)
{
	SeahorseSshSecData* secdata = NULL;
	SeahorseSshSecData* _tmp0_;
	const gchar* _tmp1_;
	gchar* rawdata = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	SeahorseSshSecData* _tmp22_;
	const gchar* _tmp23_;
	SeahorseSshSecData* _tmp24_;
	const gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	SeahorseSshSecData* result;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = seahorse_ssh_sec_data_new ();
	secdata = _tmp0_;
	_tmp1_ = data->str;
	if (g_str_has_prefix (_tmp1_, SEAHORSE_SSH_SEC_DATA_SSH_KEY_SECRET_SIG)) {
		gchar* comment = NULL;
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		SeahorseSshSecData* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp2_ = data->str;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 2);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_tmp6_ = _tmp5_[0];
		_tmp7_ = g_strdup (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
		comment = _tmp8_;
		_tmp9_ = secdata;
		_tmp10_ = comment;
		_tmp11_ = strlen (SEAHORSE_SSH_SEC_DATA_SSH_KEY_SECRET_SIG);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_strip (_tmp14_);
		_tmp16_ = _tmp15_;
		seahorse_ssh_sec_data_set_comment (_tmp9_, _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (comment);
	}
	_tmp17_ = seahorse_ssh_sec_data_parse_lines_block (data, SEAHORSE_SSH_SEC_DATA_SSH_PRIVATE_BEGIN, SEAHORSE_SSH_SEC_DATA_SSH_PRIVATE_END);
	rawdata = _tmp17_;
	_tmp19_ = rawdata;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = rawdata;
		_tmp18_ = g_strcmp0 (_tmp20_, "") == 0;
	}
	if (_tmp18_) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Private key contains no data.");
		_inner_error0_ = _tmp21_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (rawdata);
		_g_object_unref0 (secdata);
		return NULL;
	}
	_tmp22_ = secdata;
	_tmp23_ = rawdata;
	seahorse_ssh_sec_data_set_rawdata (_tmp22_, _tmp23_);
	_tmp24_ = secdata;
	_tmp25_ = rawdata;
	seahorse_ssh_sec_data_set_algo (_tmp24_, seahorse_ssh_algorithm_guess_from_string (_tmp25_));
	result = secdata;
	_g_free0 (rawdata);
	return result;
}

/**
     * Takes everything between the start and end pattern and returns it.
     * NOTE: The string (if found will) be removed from the argument.
     */
static gchar*
seahorse_ssh_sec_data_parse_lines_block (GString* data,
                                         const gchar* start,
                                         const gchar* end)
{
	GString* _result_ = NULL;
	GString* _tmp0_;
	gboolean start_found = FALSE;
	gchar** lines = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (end != NULL, NULL);
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	start_found = FALSE;
	_tmp1_ = data->str;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	lines = _tmp3_;
	lines_length1 = _vala_array_length (_tmp2_);
	_lines_size_ = lines_length1;
	_tmp4_ = lines;
	_tmp4__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp4_;
		line_collection_length1 = _tmp4__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp5_;
			gchar* line = NULL;
			_tmp5_ = g_strdup (line_collection[line_it]);
			line = _tmp5_;
			{
				if (!start_found) {
					const gchar* _tmp6_;
					_tmp6_ = line;
					if (string_contains (_tmp6_, start)) {
						GString* _tmp7_;
						const gchar* _tmp8_;
						GString* _tmp9_;
						const gchar* _tmp10_;
						gint _tmp11_;
						gint _tmp12_;
						_tmp7_ = _result_;
						_tmp8_ = line;
						g_string_append_printf (_tmp7_, "%s\n", _tmp8_);
						_tmp9_ = _result_;
						_tmp10_ = line;
						_tmp11_ = strlen (_tmp10_);
						_tmp12_ = _tmp11_;
						g_string_erase (_tmp9_, (gssize) 0, (gssize) (_tmp12_ + 1));
						start_found = TRUE;
						_g_free0 (line);
						continue;
					}
				} else {
					GString* _tmp13_;
					const gchar* _tmp14_;
					GString* _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					const gchar* _tmp19_;
					_tmp13_ = _result_;
					_tmp14_ = line;
					g_string_append_printf (_tmp13_, "%s\n", _tmp14_);
					_tmp15_ = _result_;
					_tmp16_ = line;
					_tmp17_ = strlen (_tmp16_);
					_tmp18_ = _tmp17_;
					g_string_erase (_tmp15_, (gssize) 0, (gssize) (_tmp18_ + 1));
					_tmp19_ = line;
					if (string_contains (_tmp19_, end)) {
						_g_free0 (line);
						break;
					}
				}
				_g_free0 (line);
			}
		}
	}
	_tmp20_ = _result_;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (_result_);
	return result;
}

SeahorseSshSecData*
seahorse_ssh_sec_data_construct (GType object_type)
{
	SeahorseSshSecData * self = NULL;
	self = (SeahorseSshSecData*) g_object_new (object_type, NULL);
	return self;
}

SeahorseSshSecData*
seahorse_ssh_sec_data_new (void)
{
	return seahorse_ssh_sec_data_construct (SEAHORSE_SSH_TYPE_SEC_DATA);
}

const gchar*
seahorse_ssh_sec_data_get_rawdata (SeahorseSshSecData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rawdata;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_sec_data_set_rawdata (SeahorseSshSecData* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_sec_data_get_rawdata (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_rawdata);
		self->priv->_rawdata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY]);
	}
}

const gchar*
seahorse_ssh_sec_data_get_comment (SeahorseSshSecData* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_sec_data_set_comment (SeahorseSshSecData* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_sec_data_get_comment (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_comment);
		self->priv->_comment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY]);
	}
}

SeahorseSshAlgorithm
seahorse_ssh_sec_data_get_algo (SeahorseSshSecData* self)
{
	SeahorseSshAlgorithm result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_algo;
	return result;
}

void
seahorse_ssh_sec_data_set_algo (SeahorseSshSecData* self,
                                SeahorseSshAlgorithm value)
{
	SeahorseSshAlgorithm old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_ssh_sec_data_get_algo (self);
	if (old_value != value) {
		self->priv->_algo = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY]);
	}
}

static void
seahorse_ssh_sec_data_class_init (SeahorseSshSecDataClass * klass,
                                  gpointer klass_data)
{
	seahorse_ssh_sec_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshSecData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_sec_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_sec_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_sec_data_finalize;
	/**
	     * Everything excluding the comment
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY] = g_param_spec_string ("rawdata", "rawdata", "rawdata", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY, seahorse_ssh_sec_data_properties[SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY] = g_param_spec_enum ("algo", "algo", "algo", SEAHORSE_SSH_TYPE_ALGORITHM, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_ssh_sec_data_instance_init (SeahorseSshSecData * self,
                                     gpointer klass)
{
	self->priv = seahorse_ssh_sec_data_get_instance_private (self);
}

static void
seahorse_ssh_sec_data_finalize (GObject * obj)
{
	SeahorseSshSecData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecData);
	_g_free0 (self->priv->_rawdata);
	_g_free0 (self->priv->_comment);
	G_OBJECT_CLASS (seahorse_ssh_sec_data_parent_class)->finalize (obj);
}

/**
 * Represents the data in a private key.
 */
 G_GNUC_NO_INLINE static GType
seahorse_ssh_sec_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshSecDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_sec_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshSecData), 0, (GInstanceInitFunc) seahorse_ssh_sec_data_instance_init, NULL };
	GType seahorse_ssh_sec_data_type_id;
	seahorse_ssh_sec_data_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshSecData", &g_define_type_info, 0);
	SeahorseSshSecData_private_offset = g_type_add_instance_private (seahorse_ssh_sec_data_type_id, sizeof (SeahorseSshSecDataPrivate));
	return seahorse_ssh_sec_data_type_id;
}

GType
seahorse_ssh_sec_data_get_type (void)
{
	static volatile gsize seahorse_ssh_sec_data_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_sec_data_type_id__once)) {
		GType seahorse_ssh_sec_data_type_id;
		seahorse_ssh_sec_data_type_id = seahorse_ssh_sec_data_get_type_once ();
		g_once_init_leave (&seahorse_ssh_sec_data_type_id__once, seahorse_ssh_sec_data_type_id);
	}
	return seahorse_ssh_sec_data_type_id__once;
}

static void
_vala_seahorse_ssh_sec_data_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshSecData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecData);
	switch (property_id) {
		case SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY:
		g_value_set_string (value, seahorse_ssh_sec_data_get_rawdata (self));
		break;
		case SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY:
		g_value_set_string (value, seahorse_ssh_sec_data_get_comment (self));
		break;
		case SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY:
		g_value_set_enum (value, seahorse_ssh_sec_data_get_algo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_sec_data_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorseSshSecData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_SEC_DATA, SeahorseSshSecData);
	switch (property_id) {
		case SEAHORSE_SSH_SEC_DATA_RAWDATA_PROPERTY:
		seahorse_ssh_sec_data_set_rawdata (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_SEC_DATA_COMMENT_PROPERTY:
		seahorse_ssh_sec_data_set_comment (self, g_value_get_string (value));
		break;
		case SEAHORSE_SSH_SEC_DATA_ALGO_PROPERTY:
		seahorse_ssh_sec_data_set_algo (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

