/* game-view.c generated by valac 0.56.0, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <clutter-gtk/clutter-gtk.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "config.h"
#include <cogl/cogl.h>
#include <pango/pango.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME_GROUP (game_group_get_type ())
#define GAME_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_GROUP, GameGroup))
#define GAME_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_GROUP, GameGroupClass))
#define IS_GAME_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_GROUP))
#define IS_GAME_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_GROUP))
#define GAME_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_GROUP, GameGroupClass))

typedef struct _GameGroup GameGroup;
typedef struct _GameGroupClass GameGroupClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GameGroupPrivate GameGroupPrivate;

#define TYPE_TILE_ACTOR (tile_actor_get_type ())
#define TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_ACTOR, TileActor))
#define TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_ACTOR, TileActorClass))
#define IS_TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_ACTOR))
#define IS_TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_ACTOR))
#define TILE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_ACTOR, TileActorClass))

typedef struct _TileActor TileActor;
typedef struct _TileActorClass TileActorClass;

#define TYPE_CURSOR_ACTOR (cursor_actor_get_type ())
#define CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURSOR_ACTOR, CursorActor))
#define CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURSOR_ACTOR, CursorActorClass))
#define IS_CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURSOR_ACTOR))
#define IS_CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURSOR_ACTOR))
#define CURSOR_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURSOR_ACTOR, CursorActorClass))

typedef struct _CursorActor CursorActor;
typedef struct _CursorActorClass CursorActorClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
enum  {
	GAME_GROUP_0_PROPERTY,
	GAME_GROUP_GAME_PROPERTY,
	GAME_GROUP_THEME_NAME_PROPERTY,
	GAME_GROUP_IS_ZEALOUS_PROPERTY,
	GAME_GROUP_NUM_PROPERTIES
};
static GParamSpec* game_group_properties[GAME_GROUP_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _ThemePrivate ThemePrivate;
typedef enum  {
	OPACITY_NULL,
	OPACITY_HALF,
	OPACITY_FULL
} Opacity;

#define TYPE_OPACITY (opacity_get_type ())
typedef struct _TileActorPrivate TileActorPrivate;

#define TYPE_SCORE_ACTOR (score_actor_get_type ())
#define SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_ACTOR, ScoreActor))
#define SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_ACTOR, ScoreActorClass))
#define IS_SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_ACTOR))
#define IS_SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_ACTOR))
#define SCORE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_ACTOR, ScoreActorClass))

typedef struct _ScoreActor ScoreActor;
typedef struct _ScoreActorClass ScoreActorClass;
enum  {
	THEME_0_PROPERTY,
	THEME_NUM_PROPERTIES
};
static GParamSpec* theme_properties[THEME_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	TILE_ACTOR_0_PROPERTY,
	TILE_ACTOR_NUM_PROPERTIES
};
static GParamSpec* tile_actor_properties[TILE_ACTOR_NUM_PROPERTIES];
typedef struct _CursorActorPrivate CursorActorPrivate;
enum  {
	CURSOR_ACTOR_0_PROPERTY,
	CURSOR_ACTOR_NUM_PROPERTIES
};
static GParamSpec* cursor_actor_properties[CURSOR_ACTOR_NUM_PROPERTIES];
typedef struct _ScoreActorPrivate ScoreActorPrivate;
enum  {
	SCORE_ACTOR_0_PROPERTY,
	SCORE_ACTOR_NUM_PROPERTIES
};
static GParamSpec* score_actor_properties[SCORE_ACTOR_NUM_PROPERTIES];

struct _GameView {
	GtkClutterEmbed parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _GameViewPrivate {
	ClutterStage* stage;
	GameGroup* group;
};

struct _GameGroup {
	ClutterGroup parent_instance;
	GameGroupPrivate * priv;
};

struct _GameGroupClass {
	ClutterGroupClass parent_class;
};

struct _GameGroupPrivate {
	TileActor* highlighted;
	CursorActor* cursor;
	gboolean cursor_active;
	gint _cursor_x;
	gint _cursor_y;
	TileActor** tiles;
	gint tiles_length1;
	gint tiles_length2;
	ClutterActor* game_actors;
	gboolean game_is_set;
	Game* _game;
	GHashTable* themes;
	gchar* _theme_name;
	gint tile_size;
	gboolean _is_zealous;
};

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
	ClutterImage** textures;
	gint textures_length1;
	gint _textures_size_;
	ClutterImage* cursor;
};

struct _ThemeClass {
	GObjectClass parent_class;
};

struct _TileActor {
	ClutterActor parent_instance;
	TileActorPrivate * priv;
	Tile* tile;
};

struct _TileActorClass {
	ClutterActorClass parent_class;
};

struct _CursorActor {
	ClutterActor parent_instance;
	CursorActorPrivate * priv;
};

struct _CursorActorClass {
	ClutterActorClass parent_class;
};

struct _ScoreActor {
	ClutterGroup parent_instance;
	ScoreActorPrivate * priv;
};

struct _ScoreActorClass {
	ClutterGroupClass parent_class;
};

struct _ScoreActorPrivate {
	ClutterText* label;
	gfloat scene_width;
	gfloat scene_height;
	gint game_size;
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;
static gint GameGroup_private_offset;
static gpointer game_group_parent_class = NULL;
static gpointer theme_parent_class = NULL;
static gpointer tile_actor_parent_class = NULL;
static gpointer cursor_actor_parent_class = NULL;
static gint ScoreActor_private_offset;
static gpointer score_actor_parent_class = NULL;

VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType game_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameGroup, g_object_unref)
static void game_view_init_size (GameView* self);
static gboolean game_view_configure_event_cb (GameView* self,
                                       GtkWidget* widget,
                                       GdkEvent* event);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* game);
VALA_EXTERN void game_group_set_game (GameGroup* self,
                          Game* value);
VALA_EXTERN void game_view_set_theme_name (GameView* self,
                               const gchar* theme_name);
VALA_EXTERN void game_group_set_theme_name (GameGroup* self,
                                const gchar* value);
VALA_EXTERN void game_view_set_is_zealous (GameView* self,
                               gboolean is_zealous);
VALA_EXTERN void game_group_set_is_zealous (GameGroup* self,
                                gboolean value);
VALA_EXTERN void game_view_board_left_cb (GameView* self);
VALA_EXTERN void game_group_board_left_cb (GameGroup* self);
VALA_EXTERN void game_view_cursor_move (GameView* self,
                            gint x,
                            gint y);
VALA_EXTERN void game_group_cursor_move (GameGroup* self,
                             gint x,
                             gint y);
VALA_EXTERN void game_view_cursor_click (GameView* self);
VALA_EXTERN void game_group_cursor_click (GameGroup* self);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static GObject * game_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
VALA_EXTERN GameGroup* game_group_new (void);
VALA_EXTERN GameGroup* game_group_construct (GType object_type);
static gboolean _game_view_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                                   GdkEventConfigure* event,
                                                                   gpointer self);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);
VALA_EXTERN GType tile_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TileActor, g_object_unref)
VALA_EXTERN GType cursor_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CursorActor, g_object_unref)
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
static void game_group_remove_tiles (GameGroup* self);
static Game* game_group_get_game (GameGroup* self);
VALA_EXTERN guint8 game_get_columns (Game* self);
VALA_EXTERN guint8 game_get_rows (Game* self);
static void game_group_place_tiles (GameGroup* self);
static const gchar* game_group_get_theme_name (GameGroup* self);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN Tile* game_get_tile (Game* self,
                     guint8 x,
                     guint8 y);
VALA_EXTERN gboolean tile_get_closed (Tile* self);
VALA_EXTERN guint8 tile_get_color (Tile* self);
VALA_EXTERN TileActor* tile_actor_new (Tile* tile,
                           ClutterImage* texture,
                           gint size);
VALA_EXTERN TileActor* tile_actor_construct (GType object_type,
                                 Tile* tile,
                                 ClutterImage* texture,
                                 gint size);
static inline void game_group_move_cb (GameGroup* self,
                         guint8 old_x,
                         guint8 old_y,
                         guint8 new_x,
                         guint8 new_y);
static void _game_group_move_cb_tile_move (Tile* _sender,
                                    guint8 old_x,
                                    guint8 old_y,
                                    guint8 new_x,
                                    guint8 new_y,
                                    gpointer self);
static inline void game_group_close_cb (GameGroup* self,
                          guint8 grid_x,
                          guint8 grid_y);
static void _game_group_close_cb_tile_close (Tile* _sender,
                                      guint8 grid_x,
                                      guint8 grid_y,
                                      gpointer self);
static void game_group_remove_region_cb (GameGroup* self,
                                  ClutterTapAction* tap,
                                  ClutterActor* actor);
static void _game_group_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                          ClutterActor* actor,
                                                          gpointer self);
static gboolean game_group_tile_entered_cb (GameGroup* self,
                                     ClutterActor* actor,
                                     ClutterCrossingEvent* event);
static gboolean _game_group_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender,
                                                                ClutterCrossingEvent* event,
                                                                gpointer self);
static gboolean game_group_tile_left_cb (GameGroup* self,
                                  ClutterActor* actor,
                                  ClutterCrossingEvent* event);
static gboolean _game_group_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender,
                                                             ClutterCrossingEvent* event,
                                                             gpointer self);
VALA_EXTERN CursorActor* cursor_actor_new (ClutterContent* texture,
                               gint size);
VALA_EXTERN CursorActor* cursor_actor_construct (GType object_type,
                                     ClutterContent* texture,
                                     gint size);
VALA_EXTERN void tile_actor_animate_out (TileActor* self);
VALA_EXTERN void tile_actor_animate_to (TileActor* self,
                            gdouble new_x,
                            gdouble new_y,
                            gboolean is_zealous);
static gboolean game_group_get_is_zealous (GameGroup* self);
VALA_EXTERN GType opacity_get_type (void) G_GNUC_CONST ;
static void game_group_opacity_for_connected_tiles (GameGroup* self,
                                             TileActor* actor,
                                             Opacity opacity);
VALA_EXTERN GList* game_connected_tiles (Game* self,
                             Tile* given_tile);
VALA_EXTERN guint8 tile_get_grid_x (Tile* self);
VALA_EXTERN guint8 tile_get_grid_y (Tile* self);
VALA_EXTERN void tile_actor_update_opacity (TileActor* self,
                                Opacity opacity);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void game_group_set_cursor_x (GameGroup* self,
                              gint value);
static void game_group_set_cursor_y (GameGroup* self,
                              gint value);
VALA_EXTERN void game_remove_connected_tiles (Game* self,
                                  Tile* given_tile);
static TileActor* game_group_find_tile_at_position (GameGroup* self,
                                             gint position_x,
                                             gint position_y);
static gint game_group_get_cursor_x (GameGroup* self);
static gint game_group_get_cursor_y (GameGroup* self);
static void game_group_update_score_cb (GameGroup* self,
                                 guint points_awarded);
VALA_EXTERN GType score_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreActor, g_object_unref)
VALA_EXTERN ScoreActor* score_actor_new (gint game_size,
                             gdouble width,
                             gdouble height);
VALA_EXTERN ScoreActor* score_actor_construct (GType object_type,
                                   gint game_size,
                                   gdouble width,
                                   gdouble height);
VALA_EXTERN void score_actor_animate_score (ScoreActor* self,
                                guint points);
static void game_group_game_complete_cb (GameGroup* self);
VALA_EXTERN void score_actor_animate_final_score (ScoreActor* self,
                                      guint points);
VALA_EXTERN guint game_get_score (Game* self);
static inline void game_group_move_undone_cb (GameGroup* self);
static void _game_group_move_undone_cb_game_undone (Game* _sender,
                                             gpointer self);
static void _game_group_game_complete_cb_game_complete (Game* _sender,
                                                 gpointer self);
static void _game_group_update_score_cb_game_update_score (Game* _sender,
                                                    guint points_awarded,
                                                    gpointer self);
static GObject * game_group_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
VALA_EXTERN Theme* theme_new (const gchar* name);
VALA_EXTERN Theme* theme_construct (GType object_type,
                        const gchar* name);
static void game_group_finalize (GObject * obj);
static GType game_group_get_type_once (void);
static void _vala_game_group_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_game_group_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void theme_finalize (GObject * obj);
static GType theme_get_type_once (void);
static void tile_actor_hide_tile_cb (TileActor* self);
static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                   gpointer self);
static void tile_actor_finalize (GObject * obj);
static GType tile_actor_get_type_once (void);
static GType cursor_actor_get_type_once (void);
static void __lambda6_ (ScoreActor* self);
static void ___lambda6__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                      gpointer self);
static void score_actor_finalize (GObject * obj);
static GType score_actor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

static void
game_view_init_size (GameView* self)
{
	GameGroup* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	GameGroup* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat w_scale = 0.0F;
	ClutterStage* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	GameGroup* _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat h_scale = 0.0F;
	ClutterStage* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	GameGroup* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_ = 0.0F;
	gfloat scale = 0.0F;
	GameGroup* _tmp19_;
	GameGroup* _tmp20_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	GameGroup* _tmp24_;
	gfloat _tmp25_;
	gfloat _tmp26_;
	ClutterStage* _tmp27_;
	gfloat _tmp28_;
	gfloat _tmp29_;
	GameGroup* _tmp30_;
	gfloat _tmp31_;
	gfloat _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->group;
	_tmp4_ = clutter_actor_get_height ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_size_request ((GtkWidget*) self, (gint) _tmp2_, (gint) _tmp5_);
	_tmp6_ = self->priv->stage;
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->group;
	_tmp10_ = clutter_actor_get_width ((ClutterActor*) _tmp9_);
	_tmp11_ = _tmp10_;
	w_scale = _tmp8_ / _tmp11_;
	_tmp12_ = self->priv->stage;
	_tmp13_ = clutter_actor_get_height ((ClutterActor*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->group;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	h_scale = _tmp14_ / _tmp17_;
	if (w_scale < h_scale) {
		_tmp18_ = w_scale;
	} else {
		_tmp18_ = h_scale;
	}
	scale = _tmp18_;
	_tmp19_ = self->priv->group;
	clutter_actor_set_scale ((ClutterActor*) _tmp19_, (gdouble) scale, (gdouble) scale);
	_tmp20_ = self->priv->group;
	_tmp21_ = self->priv->stage;
	_tmp22_ = clutter_actor_get_width ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->group;
	_tmp25_ = clutter_actor_get_width ((ClutterActor*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->stage;
	_tmp28_ = clutter_actor_get_height ((ClutterActor*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->group;
	_tmp31_ = clutter_actor_get_height ((ClutterActor*) _tmp30_);
	_tmp32_ = _tmp31_;
	clutter_actor_set_position ((ClutterActor*) _tmp20_, (_tmp23_ - (scale * _tmp26_)) / 2, (_tmp29_ - (scale * _tmp32_)) / 2);
}

static gboolean
game_view_configure_event_cb (GameView* self,
                              GtkWidget* widget,
                              GdkEvent* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_init_size (self);
	result = FALSE;
	return result;
}

void
game_view_set_game (GameView* self,
                    Game* game)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->group;
	game_group_set_game (_tmp0_, game);
	game_view_init_size (self);
}

void
game_view_set_theme_name (GameView* self,
                          const gchar* theme_name)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	_tmp0_ = self->priv->group;
	game_group_set_theme_name (_tmp0_, theme_name);
}

void
game_view_set_is_zealous (GameView* self,
                          gboolean is_zealous)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	game_group_set_is_zealous (_tmp0_, is_zealous);
}

void
game_view_board_left_cb (GameView* self)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	game_group_board_left_cb (_tmp0_);
}

void
game_view_cursor_move (GameView* self,
                       gint x,
                       gint y)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	game_group_cursor_move (_tmp0_, x, y);
}

void
game_view_cursor_click (GameView* self)
{
	GameGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->group;
	game_group_cursor_click (_tmp0_);
}

GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	return self;
}

GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_game_view_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                          GdkEventConfigure* event,
                                                          gpointer self)
{
	gboolean result;
	result = game_view_configure_event_cb ((GameView*) self, _sender, event);
	return result;
}

static GObject *
game_view_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameView * self;
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterStage* _tmp2_;
	ClutterColor _tmp3_ = {0};
	GameGroup* _tmp4_;
	ClutterStage* _tmp5_;
	GameGroup* _tmp6_;
	parent_class = G_OBJECT_CLASS (game_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_tmp0_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, clutter_stage_get_type (), ClutterStage));
	_g_object_unref0 (self->priv->stage);
	self->priv->stage = _tmp1_;
	_tmp2_ = self->priv->stage;
	clutter_color_from_string (&_tmp3_, "#000000");
	clutter_actor_set_background_color ((ClutterActor*) _tmp2_, &_tmp3_);
	_tmp4_ = game_group_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->group);
	self->priv->group = _tmp4_;
	_tmp5_ = self->priv->stage;
	_tmp6_ = self->priv->group;
	clutter_actor_add_child ((ClutterActor*) _tmp5_, (ClutterActor*) _tmp6_);
	game_view_init_size (self);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) _game_view_configure_event_cb_gtk_widget_configure_event, self, 0);
	return obj;
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = game_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	self->priv = game_view_get_instance_private (self);
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->group);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

/**
 *  This class defines the view of a game. All clutter related stuff goes here. It follows the
 *  principle of MVC framework. This class deals with the presentation (view) layer. It communicates
 *  with the model class by composite relation and with the control layer by means of signals and
 *  events.
 */
static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "GameView", &g_define_type_info, 0);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

static inline gpointer
game_group_get_instance_private (GameGroup* self)
{
	return G_STRUCT_MEMBER_P (self, GameGroup_private_offset);
}

static void
game_group_remove_tiles (GameGroup* self)
{
	CursorActor* _tmp19_;
	g_return_if_fail (self != NULL);
	if (!self->priv->game_is_set) {
		return;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Game* _tmp2_;
				Game* _tmp3_;
				guint8 _tmp4_;
				guint8 _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = game_group_get_game (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = game_get_columns (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(x < ((gint) _tmp5_))) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							Game* _tmp8_;
							Game* _tmp9_;
							guint8 _tmp10_;
							guint8 _tmp11_;
							TileActor* tile = NULL;
							TileActor** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							TileActor* _tmp13_;
							TileActor* _tmp14_;
							TileActor* _tmp15_;
							TileActor** _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							TileActor* _tmp17_;
							TileActor* _tmp18_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = y;
								y = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = game_group_get_game (self);
							_tmp9_ = _tmp8_;
							_tmp10_ = game_get_rows (_tmp9_);
							_tmp11_ = _tmp10_;
							if (!(y < ((gint) _tmp11_))) {
								break;
							}
							_tmp12_ = self->priv->tiles;
							_tmp12__length1 = self->priv->tiles_length1;
							_tmp12__length2 = self->priv->tiles_length2;
							_tmp13_ = _tmp12_[(x * _tmp12__length2) + y];
							_tmp14_ = _g_object_ref0 (_tmp13_);
							tile = _tmp14_;
							_tmp15_ = tile;
							if (_tmp15_ == NULL) {
								_g_object_unref0 (tile);
								continue;
							}
							_tmp16_ = self->priv->tiles;
							_tmp16__length1 = self->priv->tiles_length1;
							_tmp16__length2 = self->priv->tiles_length2;
							_g_object_unref0 (_tmp16_[(x * _tmp16__length2) + y]);
							_tmp16_[(x * _tmp16__length2) + y] = NULL;
							_tmp17_ = tile;
							g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
							_tmp18_ = tile;
							clutter_actor_destroy ((ClutterActor*) _tmp18_);
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp19_ = self->priv->cursor;
	clutter_actor_destroy ((ClutterActor*) _tmp19_);
}

static void
_game_group_move_cb_tile_move (Tile* _sender,
                               guint8 old_x,
                               guint8 old_y,
                               guint8 new_x,
                               guint8 new_y,
                               gpointer self)
{
	game_group_move_cb ((GameGroup*) self, old_x, old_y, new_x, new_y);
}

static void
_game_group_close_cb_tile_close (Tile* _sender,
                                 guint8 grid_x,
                                 guint8 grid_y,
                                 gpointer self)
{
	game_group_close_cb ((GameGroup*) self, grid_x, grid_y);
}

static void
_game_group_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender,
                                                     ClutterActor* actor,
                                                     gpointer self)
{
	game_group_remove_region_cb ((GameGroup*) self, _sender, actor);
}

static gboolean
_game_group_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender,
                                                       ClutterCrossingEvent* event,
                                                       gpointer self)
{
	gboolean result;
	result = game_group_tile_entered_cb ((GameGroup*) self, _sender, event);
	return result;
}

static gboolean
_game_group_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender,
                                                    ClutterCrossingEvent* event,
                                                    gpointer self)
{
	gboolean result;
	result = game_group_tile_left_cb ((GameGroup*) self, _sender, event);
	return result;
}

static void
game_group_place_tiles (GameGroup* self)
{
	Theme* theme = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	Theme* _tmp4_;
	Theme* _tmp5_;
	Theme* _tmp56_;
	ClutterImage* _tmp57_;
	CursorActor* _tmp58_;
	ClutterActor* _tmp59_;
	CursorActor* _tmp60_;
	CursorActor* _tmp61_;
	g_return_if_fail (self != NULL);
	if (!self->priv->game_is_set) {
		return;
	}
	_tmp0_ = self->priv->themes;
	_tmp1_ = game_group_get_theme_name (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((Theme*) _tmp3_);
	theme = _tmp4_;
	_tmp5_ = theme;
	if (_tmp5_ == NULL) {
		GHashTable* _tmp6_;
		gconstpointer _tmp7_;
		Theme* _tmp8_;
		_tmp6_ = self->priv->themes;
		_tmp7_ = g_hash_table_lookup (_tmp6_, "shapesandcolors");
		_tmp8_ = _g_object_ref0 ((Theme*) _tmp7_);
		_g_object_unref0 (theme);
		theme = _tmp8_;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				Game* _tmp11_;
				Game* _tmp12_;
				guint8 _tmp13_;
				guint8 _tmp14_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = x;
					x = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = game_group_get_game (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = game_get_columns (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(x < ((gint) _tmp14_))) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							Game* _tmp17_;
							Game* _tmp18_;
							guint8 _tmp19_;
							guint8 _tmp20_;
							Tile* l = NULL;
							Game* _tmp21_;
							Game* _tmp22_;
							Tile* _tmp23_;
							gboolean _tmp24_ = FALSE;
							Tile* _tmp25_;
							TileActor* tile = NULL;
							Tile* _tmp29_;
							Theme* _tmp30_;
							ClutterImage** _tmp31_;
							gint _tmp31__length1;
							Tile* _tmp32_;
							guint8 _tmp33_;
							guint8 _tmp34_;
							ClutterImage* _tmp35_;
							TileActor* _tmp36_;
							Tile* _tmp37_;
							Tile* _tmp38_;
							gfloat xx = 0.0F;
							gfloat yy = 0.0F;
							Game* _tmp39_;
							Game* _tmp40_;
							guint8 _tmp41_;
							guint8 _tmp42_;
							TileActor* _tmp43_;
							TileActor* _tmp44_;
							ClutterTapAction* tap = NULL;
							ClutterTapAction* _tmp45_;
							TileActor* _tmp46_;
							ClutterTapAction* _tmp47_;
							ClutterTapAction* _tmp48_;
							TileActor* _tmp49_;
							TileActor* _tmp50_;
							TileActor** _tmp51_;
							gint _tmp51__length1;
							gint _tmp51__length2;
							TileActor* _tmp52_;
							TileActor* _tmp53_;
							ClutterActor* _tmp54_;
							TileActor* _tmp55_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = y;
								y = _tmp16_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp17_ = game_group_get_game (self);
							_tmp18_ = _tmp17_;
							_tmp19_ = game_get_rows (_tmp18_);
							_tmp20_ = _tmp19_;
							if (!(y < ((gint) _tmp20_))) {
								break;
							}
							_tmp21_ = game_group_get_game (self);
							_tmp22_ = _tmp21_;
							_tmp23_ = game_get_tile (_tmp22_, (guint8) x, (guint8) y);
							l = _tmp23_;
							_tmp25_ = l;
							if (_tmp25_ == NULL) {
								_tmp24_ = TRUE;
							} else {
								Tile* _tmp26_;
								gboolean _tmp27_;
								gboolean _tmp28_;
								_tmp26_ = l;
								_tmp27_ = tile_get_closed (_tmp26_);
								_tmp28_ = _tmp27_;
								_tmp24_ = _tmp28_;
							}
							if (_tmp24_) {
								_g_object_unref0 (l);
								continue;
							}
							_tmp29_ = l;
							_tmp30_ = theme;
							_tmp31_ = _tmp30_->textures;
							_tmp31__length1 = _tmp30_->textures_length1;
							_tmp32_ = l;
							_tmp33_ = tile_get_color (_tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = _tmp31_[_tmp34_ - 1];
							_tmp36_ = tile_actor_new (_tmp29_, _tmp35_, self->priv->tile_size);
							g_object_ref_sink (_tmp36_);
							tile = _tmp36_;
							_tmp37_ = l;
							g_signal_connect_object (_tmp37_, "move", (GCallback) _game_group_move_cb_tile_move, self, 0);
							_tmp38_ = l;
							g_signal_connect_object (_tmp38_, "close", (GCallback) _game_group_close_cb_tile_close, self, 0);
							xx = (gfloat) (x * self->priv->tile_size);
							_tmp39_ = game_group_get_game (self);
							_tmp40_ = _tmp39_;
							_tmp41_ = game_get_rows (_tmp40_);
							_tmp42_ = _tmp41_;
							yy = (gfloat) (((_tmp42_ - y) - 1) * self->priv->tile_size);
							_tmp43_ = tile;
							clutter_actor_set_position ((ClutterActor*) _tmp43_, xx, yy);
							_tmp44_ = tile;
							clutter_actor_set_reactive ((ClutterActor*) _tmp44_, TRUE);
							_tmp45_ = (ClutterTapAction*) clutter_tap_action_new ();
							g_object_ref_sink (_tmp45_);
							tap = _tmp45_;
							_tmp46_ = tile;
							_tmp47_ = tap;
							clutter_actor_add_action ((ClutterActor*) _tmp46_, (ClutterAction*) _tmp47_);
							_tmp48_ = tap;
							g_signal_connect_object (_tmp48_, "tap", (GCallback) _game_group_remove_region_cb_clutter_tap_action_tap, self, 0);
							_tmp49_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp49_, "enter-event", (GCallback) _game_group_tile_entered_cb_clutter_actor_enter_event, self, 0);
							_tmp50_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp50_, "leave-event", (GCallback) _game_group_tile_left_cb_clutter_actor_leave_event, self, 0);
							_tmp51_ = self->priv->tiles;
							_tmp51__length1 = self->priv->tiles_length1;
							_tmp51__length2 = self->priv->tiles_length2;
							_tmp52_ = tile;
							_tmp53_ = _g_object_ref0 (_tmp52_);
							_g_object_unref0 (_tmp51_[(x * _tmp51__length2) + y]);
							_tmp51_[(x * _tmp51__length2) + y] = _tmp53_;
							_tmp54_ = self->priv->game_actors;
							_tmp55_ = tile;
							clutter_actor_add_child (_tmp54_, (ClutterActor*) _tmp55_);
							_g_object_unref0 (tap);
							_g_object_unref0 (tile);
							_g_object_unref0 (l);
						}
					}
				}
			}
		}
	}
	_tmp56_ = theme;
	_tmp57_ = _tmp56_->cursor;
	_tmp58_ = cursor_actor_new ((ClutterContent*) _tmp57_, self->priv->tile_size);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = _tmp58_;
	_tmp59_ = self->priv->game_actors;
	_tmp60_ = self->priv->cursor;
	clutter_actor_add_child (_tmp59_, (ClutterActor*) _tmp60_);
	_tmp61_ = self->priv->cursor;
	clutter_actor_hide ((ClutterActor*) _tmp61_);
	_g_object_unref0 (theme);
}

static inline void
game_group_close_cb (GameGroup* self,
                     guint8 grid_x,
                     guint8 grid_y)
{
	TileActor* tile_actor = NULL;
	TileActor** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	TileActor* _tmp1_;
	TileActor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(grid_x * _tmp0__length2) + grid_y];
	tile_actor = _tmp1_;
	_tmp2_ = tile_actor;
	if (_tmp2_ != NULL) {
		TileActor* _tmp3_;
		_tmp3_ = tile_actor;
		tile_actor_animate_out (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_TILE_ACTOR, TileActor));
	}
}

static inline void
game_group_move_cb (GameGroup* self,
                    guint8 old_x,
                    guint8 old_y,
                    guint8 new_x,
                    guint8 new_y)
{
	TileActor* tile = NULL;
	TileActor** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	TileActor* _tmp1_;
	TileActor* _tmp2_;
	TileActor** _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	TileActor* _tmp4_;
	gint new_xx = 0;
	gint new_yy = 0;
	Game* _tmp5_;
	Game* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(old_x * _tmp0__length2) + old_y];
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tile = _tmp2_;
	_tmp3_ = self->priv->tiles;
	_tmp3__length1 = self->priv->tiles_length1;
	_tmp3__length2 = self->priv->tiles_length2;
	_tmp4_ = _g_object_ref0 (tile);
	_g_object_unref0 (_tmp3_[(new_x * _tmp3__length2) + new_y]);
	_tmp3_[(new_x * _tmp3__length2) + new_y] = _tmp4_;
	new_xx = new_x * self->priv->tile_size;
	_tmp5_ = game_group_get_game (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = game_get_rows (_tmp6_);
	_tmp8_ = _tmp7_;
	new_yy = ((_tmp8_ - new_y) - 1) * self->priv->tile_size;
	_tmp9_ = self->priv->_is_zealous;
	tile_actor_animate_to (tile, (gdouble) new_xx, (gdouble) new_yy, _tmp9_);
	_g_object_unref0 (tile);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
game_group_opacity_for_connected_tiles (GameGroup* self,
                                        TileActor* actor,
                                        Opacity opacity)
{
	GList* connected_tiles = NULL;
	Game* _tmp0_;
	Game* _tmp1_;
	Tile* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	if (actor == NULL) {
		return;
	}
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = actor->tile;
	_tmp3_ = game_connected_tiles (_tmp1_, _tmp2_);
	connected_tiles = _tmp3_;
	_tmp4_ = connected_tiles;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp4_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Tile* _tmp5_;
			Tile* l = NULL;
			_tmp5_ = _g_object_ref0 ((Tile*) l_it->data);
			l = _tmp5_;
			{
				TileActor* tile_actor = NULL;
				TileActor** _tmp6_;
				gint _tmp6__length1;
				gint _tmp6__length2;
				Tile* _tmp7_;
				guint8 _tmp8_;
				guint8 _tmp9_;
				Tile* _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				TileActor* _tmp13_;
				TileActor* _tmp14_;
				TileActor* _tmp15_;
				_tmp6_ = self->priv->tiles;
				_tmp6__length1 = self->priv->tiles_length1;
				_tmp6__length2 = self->priv->tiles_length2;
				_tmp7_ = l;
				_tmp8_ = tile_get_grid_x (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = l;
				_tmp11_ = tile_get_grid_y (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp6_[(_tmp9_ * _tmp6__length2) + _tmp12_];
				_tmp14_ = _g_object_ref0 (_tmp13_);
				tile_actor = _tmp14_;
				_tmp15_ = tile_actor;
				if (_tmp15_ != NULL) {
					TileActor* _tmp16_;
					_tmp16_ = tile_actor;
					tile_actor_update_opacity (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_TILE_ACTOR, TileActor), opacity);
				}
				_g_object_unref0 (tile_actor);
				_g_object_unref0 (l);
			}
		}
	}
	(connected_tiles == NULL) ? NULL : (connected_tiles = (_g_list_free__g_object_unref0_ (connected_tiles), NULL));
}

static gboolean
game_group_tile_entered_cb (GameGroup* self,
                            ClutterActor* actor,
                            ClutterCrossingEvent* event)
{
	TileActor* tile = NULL;
	TileActor* _tmp0_;
	TileActor* _tmp1_;
	TileActor* _tmp2_;
	TileActor* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->cursor_active) {
		result = FALSE;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (actor, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp0_;
	_tmp1_ = tile;
	game_group_opacity_for_connected_tiles (self, _tmp1_, OPACITY_FULL);
	_tmp2_ = tile;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp3_;
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}

static gboolean
game_group_tile_left_cb (GameGroup* self,
                         ClutterActor* actor,
                         ClutterCrossingEvent* event)
{
	TileActor* tile = NULL;
	TileActor* _tmp0_;
	TileActor* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->cursor_active) {
		result = FALSE;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (actor, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp0_;
	_tmp1_ = tile;
	game_group_opacity_for_connected_tiles (self, _tmp1_, OPACITY_HALF);
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}

static void
game_group_remove_region_cb (GameGroup* self,
                             ClutterTapAction* tap,
                             ClutterActor* actor)
{
	TileActor* tile = NULL;
	TileActor* _tmp0_;
	TileActor* _tmp1_;
	TileActor* _tmp3_;
	Tile* _tmp4_;
	guint8 _tmp5_;
	guint8 _tmp6_;
	TileActor* _tmp7_;
	Tile* _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	TileActor* _tmp13_;
	Tile* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (actor, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp0_;
	_tmp1_ = self->priv->highlighted;
	game_group_opacity_for_connected_tiles (self, _tmp1_, OPACITY_HALF);
	if (self->priv->cursor_active) {
		CursorActor* _tmp2_;
		self->priv->cursor_active = FALSE;
		_tmp2_ = self->priv->cursor;
		clutter_actor_hide ((ClutterActor*) _tmp2_);
	}
	_tmp3_ = tile;
	_tmp4_ = _tmp3_->tile;
	_tmp5_ = tile_get_grid_x (_tmp4_);
	_tmp6_ = _tmp5_;
	game_group_set_cursor_x (self, (gint) _tmp6_);
	_tmp7_ = tile;
	_tmp8_ = _tmp7_->tile;
	_tmp9_ = tile_get_grid_y (_tmp8_);
	_tmp10_ = _tmp9_;
	game_group_set_cursor_y (self, (gint) _tmp10_);
	_tmp11_ = game_group_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = tile;
	_tmp14_ = _tmp13_->tile;
	game_remove_connected_tiles (_tmp12_, _tmp14_);
	_g_object_unref0 (tile);
}

void
game_group_board_left_cb (GameGroup* self)
{
	TileActor** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		TileActor** tile_actor_collection = NULL;
		gint tile_actor_collection_length1 = 0;
		gint tile_actor_collection_length2 = 0;
		gint tile_actor_it = 0;
		tile_actor_collection = _tmp0_;
		tile_actor_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (tile_actor_it = 0; tile_actor_it < tile_actor_collection_length1; tile_actor_it = tile_actor_it + 1) {
			TileActor* _tmp1_;
			TileActor* tile_actor = NULL;
			_tmp1_ = _g_object_ref0 (tile_actor_collection[tile_actor_it]);
			tile_actor = _tmp1_;
			{
				TileActor* _tmp2_;
				_tmp2_ = tile_actor;
				if (_tmp2_ != NULL) {
					TileActor* _tmp3_;
					_tmp3_ = tile_actor;
					tile_actor_update_opacity (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_TILE_ACTOR, TileActor), OPACITY_HALF);
				}
				_g_object_unref0 (tile_actor);
			}
		}
	}
}

static TileActor*
game_group_find_tile_at_position (GameGroup* self,
                                  gint position_x,
                                  gint position_y)
{
	TileActor** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	TileActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	{
		TileActor** tile_actor_collection = NULL;
		gint tile_actor_collection_length1 = 0;
		gint tile_actor_collection_length2 = 0;
		gint tile_actor_it = 0;
		tile_actor_collection = _tmp0_;
		tile_actor_collection_length1 = _tmp0__length1 * _tmp0__length2;
		for (tile_actor_it = 0; tile_actor_it < tile_actor_collection_length1; tile_actor_it = tile_actor_it + 1) {
			TileActor* _tmp1_;
			TileActor* tile_actor = NULL;
			_tmp1_ = _g_object_ref0 (tile_actor_collection[tile_actor_it]);
			tile_actor = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				TileActor* _tmp4_;
				_tmp4_ = tile_actor;
				if (_tmp4_ != NULL) {
					TileActor* _tmp5_;
					Tile* _tmp6_;
					guint8 _tmp7_;
					guint8 _tmp8_;
					_tmp5_ = tile_actor;
					_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TILE_ACTOR, TileActor)->tile;
					_tmp7_ = tile_get_grid_x (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp3_ = ((gint) _tmp8_) == position_x;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					TileActor* _tmp9_;
					Tile* _tmp10_;
					guint8 _tmp11_;
					guint8 _tmp12_;
					_tmp9_ = tile_actor;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TILE_ACTOR, TileActor)->tile;
					_tmp11_ = tile_get_grid_y (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp2_ = ((gint) _tmp12_) == position_y;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = tile_actor;
					return result;
				}
				_g_object_unref0 (tile_actor);
			}
		}
	}
	result = NULL;
	return result;
}

void
game_group_cursor_move (GameGroup* self,
                        gint x,
                        gint y)
{
	TileActor* cursor_tile = NULL;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	TileActor* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	TileActor* _tmp21_;
	TileActor* _tmp40_;
	TileActor* _tmp41_;
	gfloat xx = 0.0F;
	gfloat yy = 0.0F;
	gint _tmp42_;
	gint _tmp43_;
	Game* _tmp44_;
	Game* _tmp45_;
	guint8 _tmp46_;
	guint8 _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	CursorActor* _tmp50_;
	CursorActor* _tmp51_;
	g_return_if_fail (self != NULL);
	if (self->priv->cursor_active) {
		gint old_cursor_x = 0;
		gint _tmp0_;
		gint _tmp1_;
		gint old_cursor_y = 0;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		gint _tmp9_;
		gint _tmp10_;
		_tmp0_ = game_group_get_cursor_x (self);
		_tmp1_ = _tmp0_;
		old_cursor_x = _tmp1_;
		_tmp2_ = game_group_get_cursor_y (self);
		_tmp3_ = _tmp2_;
		old_cursor_y = _tmp3_;
		_tmp4_ = game_group_get_cursor_x (self);
		_tmp5_ = _tmp4_;
		game_group_set_cursor_x (self, _tmp5_ + x);
		_tmp6_ = game_group_get_cursor_y (self);
		_tmp7_ = _tmp6_;
		game_group_set_cursor_y (self, _tmp7_ + y);
		_tmp9_ = game_group_get_cursor_x (self);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == old_cursor_x) {
			gint _tmp11_;
			gint _tmp12_;
			_tmp11_ = game_group_get_cursor_y (self);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ == old_cursor_y;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			return;
		}
	} else {
		self->priv->cursor_active = TRUE;
	}
	_tmp13_ = game_group_get_cursor_x (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = game_group_get_cursor_y (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = game_group_find_tile_at_position (self, _tmp14_, _tmp16_);
	cursor_tile = _tmp17_;
	_tmp21_ = self->priv->highlighted;
	if (_tmp21_ != NULL) {
		TileActor* _tmp22_;
		_tmp22_ = cursor_tile;
		_tmp20_ = _tmp22_ == NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gboolean _tmp23_ = FALSE;
		TileActor* _tmp24_;
		_tmp24_ = self->priv->highlighted;
		if (_tmp24_ == NULL) {
			TileActor* _tmp25_;
			_tmp25_ = cursor_tile;
			_tmp23_ = _tmp25_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp19_ = _tmp23_;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		TileActor* _tmp28_;
		_tmp28_ = self->priv->highlighted;
		if (_tmp28_ != NULL) {
			TileActor* _tmp29_;
			_tmp29_ = cursor_tile;
			_tmp27_ = _tmp29_ != NULL;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			TileActor* _tmp30_;
			Tile* _tmp31_;
			guint8 _tmp32_;
			guint8 _tmp33_;
			TileActor* _tmp34_;
			Tile* _tmp35_;
			guint8 _tmp36_;
			guint8 _tmp37_;
			_tmp30_ = self->priv->highlighted;
			_tmp31_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_TILE_ACTOR, TileActor)->tile;
			_tmp32_ = tile_get_color (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = cursor_tile;
			_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_TILE_ACTOR, TileActor)->tile;
			_tmp36_ = tile_get_color (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp26_ = _tmp33_ != _tmp37_;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp18_ = _tmp26_;
	}
	if (_tmp18_) {
		TileActor* _tmp38_;
		TileActor* _tmp39_;
		_tmp38_ = self->priv->highlighted;
		game_group_opacity_for_connected_tiles (self, _tmp38_, OPACITY_HALF);
		_tmp39_ = cursor_tile;
		game_group_opacity_for_connected_tiles (self, _tmp39_, OPACITY_FULL);
	}
	_tmp40_ = cursor_tile;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp41_;
	_tmp42_ = game_group_get_cursor_x (self);
	_tmp43_ = _tmp42_;
	xx = (gfloat) (_tmp43_ * self->priv->tile_size);
	_tmp44_ = game_group_get_game (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = game_get_rows (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = game_group_get_cursor_y (self);
	_tmp49_ = _tmp48_;
	yy = (gfloat) (((_tmp47_ - 1) - _tmp49_) * self->priv->tile_size);
	_tmp50_ = self->priv->cursor;
	clutter_actor_set_position ((ClutterActor*) _tmp50_, xx, yy);
	_tmp51_ = self->priv->cursor;
	clutter_actor_show ((ClutterActor*) _tmp51_);
	_g_object_unref0 (cursor_tile);
}

void
game_group_cursor_click (GameGroup* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	TileActor** _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	TileActor* _tmp7_;
	Tile* _tmp8_;
	TileActor** _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	TileActor* _tmp14_;
	TileActor* _tmp15_;
	TileActor* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tiles;
	_tmp2__length1 = self->priv->tiles_length1;
	_tmp2__length2 = self->priv->tiles_length2;
	_tmp3_ = game_group_get_cursor_x (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_group_get_cursor_y (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
	_tmp8_ = _tmp7_->tile;
	game_remove_connected_tiles (_tmp1_, _tmp8_);
	_tmp9_ = self->priv->tiles;
	_tmp9__length1 = self->priv->tiles_length1;
	_tmp9__length2 = self->priv->tiles_length2;
	_tmp10_ = game_group_get_cursor_x (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = game_group_get_cursor_y (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp9_[(_tmp11_ * _tmp9__length2) + _tmp13_];
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp15_;
	_tmp16_ = self->priv->highlighted;
	game_group_opacity_for_connected_tiles (self, _tmp16_, OPACITY_FULL);
}

static void
game_group_update_score_cb (GameGroup* self,
                            guint points_awarded)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_zealous;
	if (_tmp0_) {
		ScoreActor* text = NULL;
		Game* _tmp1_;
		Game* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		ScoreActor* _tmp9_;
		ClutterActor* _tmp10_;
		ScoreActor* _tmp11_;
		ScoreActor* _tmp12_;
		ClutterAlignConstraint* _tmp13_;
		ClutterAlignConstraint* _tmp14_;
		ScoreActor* _tmp15_;
		_tmp1_ = game_group_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = game_get_rows (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = score_actor_new (_tmp4_ / 5, (gdouble) _tmp6_, (gdouble) _tmp8_);
		g_object_ref_sink (_tmp9_);
		text = _tmp9_;
		_tmp10_ = self->priv->game_actors;
		_tmp11_ = text;
		clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
		_tmp12_ = text;
		_tmp13_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		clutter_actor_add_constraint ((ClutterActor*) _tmp12_, (ClutterConstraint*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = text;
		score_actor_animate_score (_tmp15_, points_awarded);
		_g_object_unref0 (text);
	}
}

static void
game_group_game_complete_cb (GameGroup* self)
{
	ScoreActor* text = NULL;
	Game* _tmp0_;
	Game* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	ScoreActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterAlignConstraint* _tmp10_;
	ClutterAlignConstraint* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	GtkButton* play_again_button = NULL;
	GtkButton* _tmp16_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkClutterActor* button_actor = NULL;
	GtkClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterAlignConstraint* _tmp21_;
	ClutterAlignConstraint* _tmp22_;
	ClutterAlignConstraint* _tmp23_;
	ClutterAlignConstraint* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = score_actor_new (_tmp3_ / 5, (gdouble) _tmp5_, (gdouble) _tmp7_);
	g_object_ref_sink (_tmp8_);
	text = _tmp8_;
	_tmp9_ = self->priv->game_actors;
	clutter_actor_add_child (_tmp9_, (ClutterActor*) text);
	_tmp10_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	clutter_actor_add_constraint ((ClutterActor*) text, (ClutterConstraint*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = game_group_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_score (_tmp13_);
	_tmp15_ = _tmp14_;
	score_actor_animate_final_score (text, _tmp15_);
	_tmp16_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Play Again"));
	g_object_ref_sink (_tmp16_);
	play_again_button = _tmp16_;
	g_object_set ((GtkWidget*) play_again_button, "width-request", 130, NULL);
	g_object_set ((GtkWidget*) play_again_button, "height-request", 40, NULL);
	gtk_actionable_set_action_name ((GtkActionable*) play_again_button, "win.new-game");
	gtk_widget_show ((GtkWidget*) play_again_button);
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) play_again_button);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	style = _tmp18_;
	gtk_style_context_add_class (style, "suggested-action");
	_tmp19_ = (GtkClutterActor*) gtk_clutter_actor_new_with_contents ((GtkWidget*) play_again_button);
	g_object_ref_sink (_tmp19_);
	button_actor = _tmp19_;
	_tmp20_ = self->priv->game_actors;
	clutter_actor_add_child (_tmp20_, (ClutterActor*) button_actor);
	g_object_set ((ClutterActor*) button_actor, "visible", TRUE, NULL);
	_tmp21_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_X_AXIS, 0.5f);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	clutter_actor_add_constraint ((ClutterActor*) button_actor, (ClutterConstraint*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_Y_AXIS, 0.88f);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	clutter_actor_add_constraint ((ClutterActor*) button_actor, (ClutterConstraint*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	clutter_actor_set_easing_mode ((ClutterActor*) button_actor, CLUTTER_EASE_OUT_ELASTIC);
	clutter_actor_set_easing_duration ((ClutterActor*) button_actor, (guint) 2000);
	clutter_actor_set_z_position ((ClutterActor*) button_actor, (gfloat) -50);
	clutter_actor_set_opacity ((ClutterActor*) button_actor, (guint8) 255);
	_g_object_unref0 (button_actor);
	_g_object_unref0 (style);
	_g_object_unref0 (play_again_button);
	_g_object_unref0 (text);
}

static inline void
game_group_move_undone_cb (GameGroup* self)
{
	Game* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	game_group_set_game (self, _tmp1_);
}

GameGroup*
game_group_construct (GType object_type)
{
	GameGroup * self = NULL;
	self = (GameGroup*) g_object_new (object_type, NULL);
	return self;
}

GameGroup*
game_group_new (void)
{
	return game_group_construct (TYPE_GAME_GROUP);
}

static gint
game_group_get_cursor_x (GameGroup* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cursor_x;
	return result;
}

static void
game_group_set_cursor_x (GameGroup* self,
                         gint value)
{
	Game* _tmp0_;
	Game* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_columns (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->_cursor_x = CLAMP (value, 0, _tmp3_ - 1);
}

static gint
game_group_get_cursor_y (GameGroup* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cursor_y;
	return result;
}

static void
game_group_set_cursor_y (GameGroup* self,
                         gint value)
{
	Game* _tmp0_;
	Game* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->_cursor_y = CLAMP (value, 0, _tmp3_ - 1);
}

static Game*
game_group_get_game (GameGroup* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->game_is_set) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_game_group_move_undone_cb_game_undone (Game* _sender,
                                        gpointer self)
{
	game_group_move_undone_cb ((GameGroup*) self);
}

static void
_game_group_game_complete_cb_game_complete (Game* _sender,
                                            gpointer self)
{
	game_group_game_complete_cb ((GameGroup*) self);
}

static void
_game_group_update_score_cb_game_update_score (Game* _sender,
                                               guint points_awarded,
                                               gpointer self)
{
	game_group_update_score_cb ((GameGroup*) self, points_awarded);
}

void
game_group_set_game (GameGroup* self,
                     Game* value)
{
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	Game* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	guint8 _tmp18_;
	guint8 _tmp19_;
	TileActor** _tmp20_;
	Game* _tmp21_;
	Game* _tmp22_;
	guint8 _tmp23_;
	guint8 _tmp24_;
	Game* _tmp25_;
	Game* _tmp26_;
	guint8 _tmp27_;
	guint8 _tmp28_;
	g_return_if_fail (self != NULL);
	if (self->priv->game_is_set) {
		ClutterActor* _tmp0_;
		_tmp0_ = self->priv->game_actors;
		clutter_actor_destroy (_tmp0_);
	}
	_tmp1_ = clutter_actor_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->game_actors);
	self->priv->game_actors = _tmp1_;
	_tmp2_ = self->priv->game_actors;
	clutter_actor_add_child ((ClutterActor*) self, _tmp2_);
	game_group_remove_tiles (self);
	if (self->priv->game_is_set) {
		Game* _tmp3_;
		Game* _tmp4_;
		_tmp3_ = game_group_get_game (self);
		_tmp4_ = _tmp3_;
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp5_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp5_;
	self->priv->game_is_set = TRUE;
	_tmp6_ = game_group_get_game (self);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "undone", (GCallback) _game_group_move_undone_cb_game_undone, self, 0);
	_tmp8_ = game_group_get_game (self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "complete", (GCallback) _game_group_game_complete_cb_game_complete, self, 0);
	_tmp10_ = game_group_get_game (self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "update-score", (GCallback) _game_group_update_score_cb_game_update_score, self, 0);
	_tmp12_ = game_group_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_columns (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = game_group_get_game (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = game_get_rows (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_new0 (TileActor*, (_tmp15_ * _tmp19_) + 1);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->tiles = _tmp20_;
	self->priv->tiles_length1 = _tmp15_;
	self->priv->tiles_length2 = _tmp19_;
	game_group_set_cursor_x (self, 0);
	game_group_set_cursor_y (self, 0);
	game_group_place_tiles (self);
	_tmp21_ = game_group_get_game (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = game_get_columns (_tmp22_);
	_tmp24_ = _tmp23_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (self->priv->tile_size * _tmp24_));
	_tmp25_ = game_group_get_game (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = game_get_rows (_tmp26_);
	_tmp28_ = _tmp27_;
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (self->priv->tile_size * _tmp28_));
	g_object_notify_by_pspec ((GObject *) self, game_group_properties[GAME_GROUP_GAME_PROPERTY]);
}

static const gchar*
game_group_get_theme_name (GameGroup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_name;
	result = _tmp0_;
	return result;
}

void
game_group_set_theme_name (GameGroup* self,
                           const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_group_get_theme_name (self);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, value) == 0) {
		return;
	}
	_tmp2_ = g_strdup (value);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp2_;
	game_group_remove_tiles (self);
	game_group_place_tiles (self);
	g_object_notify_by_pspec ((GObject *) self, game_group_properties[GAME_GROUP_THEME_NAME_PROPERTY]);
}

static gboolean
game_group_get_is_zealous (GameGroup* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_zealous;
	return result;
}

void
game_group_set_is_zealous (GameGroup* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = game_group_get_is_zealous (self);
	if (old_value != value) {
		self->priv->_is_zealous = value;
		g_object_notify_by_pspec ((GObject *) self, game_group_properties[GAME_GROUP_IS_ZEALOUS_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
game_group_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameGroup * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	Theme* theme = NULL;
	Theme* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	Theme* _tmp6_;
	Theme* _tmp7_;
	Theme* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	Theme* _tmp11_;
	Theme* _tmp12_;
	Theme* _tmp13_;
	GHashTable* _tmp14_;
	gchar* _tmp15_;
	Theme* _tmp16_;
	Theme* _tmp17_;
	parent_class = G_OBJECT_CLASS (game_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_GROUP, GameGroup);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->themes);
	self->priv->themes = _tmp2_;
	_tmp3_ = theme_new ("colors");
	theme = _tmp3_;
	_tmp4_ = self->priv->themes;
	_tmp5_ = g_strdup ("colors");
	_tmp6_ = theme;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = theme_new ("shapesandcolors");
	_g_object_unref0 (theme);
	theme = _tmp8_;
	_tmp9_ = self->priv->themes;
	_tmp10_ = g_strdup ("shapesandcolors");
	_tmp11_ = theme;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	_tmp13_ = theme_new ("boringshapes");
	_g_object_unref0 (theme);
	theme = _tmp13_;
	_tmp14_ = self->priv->themes;
	_tmp15_ = g_strdup ("boringshapes");
	_tmp16_ = theme;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	g_hash_table_insert (_tmp14_, _tmp15_, _tmp17_);
	_g_object_unref0 (theme);
	return obj;
}

static void
game_group_class_init (GameGroupClass * klass,
                       gpointer klass_data)
{
	game_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameGroup_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GROUP_GAME_PROPERTY, game_group_properties[GAME_GROUP_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GROUP_THEME_NAME_PROPERTY, game_group_properties[GAME_GROUP_THEME_NAME_PROPERTY] = g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GROUP_IS_ZEALOUS_PROPERTY, game_group_properties[GAME_GROUP_IS_ZEALOUS_PROPERTY] = g_param_spec_boolean ("is-zealous", "is-zealous", "is-zealous", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
game_group_instance_init (GameGroup * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = game_group_get_instance_private (self);
	self->priv->highlighted = NULL;
	self->priv->cursor_active = FALSE;
	self->priv->game_is_set = FALSE;
	_tmp0_ = g_strdup ("shapesandcolors");
	self->priv->_theme_name = _tmp0_;
	self->priv->tile_size = 50;
}

static void
game_group_finalize (GObject * obj)
{
	GameGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_GROUP, GameGroup);
	_g_object_unref0 (self->priv->highlighted);
	_g_object_unref0 (self->priv->cursor);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->game_actors);
	_g_object_unref0 (self->priv->_game);
	_g_hash_table_unref0 (self->priv->themes);
	_g_free0 (self->priv->_theme_name);
	G_OBJECT_CLASS (game_group_parent_class)->finalize (obj);
}

static GType
game_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameGroup), 0, (GInstanceInitFunc) game_group_instance_init, NULL };
	GType game_group_type_id;
	game_group_type_id = g_type_register_static (clutter_group_get_type (), "GameGroup", &g_define_type_info, 0);
	GameGroup_private_offset = g_type_add_instance_private (game_group_type_id, sizeof (GameGroupPrivate));
	return game_group_type_id;
}

GType
game_group_get_type (void)
{
	static volatile gsize game_group_type_id__once = 0;
	if (g_once_init_enter (&game_group_type_id__once)) {
		GType game_group_type_id;
		game_group_type_id = game_group_get_type_once ();
		g_once_init_leave (&game_group_type_id__once, game_group_type_id);
	}
	return game_group_type_id__once;
}

static void
_vala_game_group_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	GameGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_GROUP, GameGroup);
	switch (property_id) {
		case GAME_GROUP_GAME_PROPERTY:
		g_value_set_object (value, game_group_get_game (self));
		break;
		case GAME_GROUP_THEME_NAME_PROPERTY:
		g_value_set_string (value, game_group_get_theme_name (self));
		break;
		case GAME_GROUP_IS_ZEALOUS_PROPERTY:
		g_value_set_boolean (value, game_group_get_is_zealous (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_group_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	GameGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_GROUP, GameGroup);
	switch (property_id) {
		case GAME_GROUP_GAME_PROPERTY:
		game_group_set_game (self, g_value_get_object (value));
		break;
		case GAME_GROUP_THEME_NAME_PROPERTY:
		game_group_set_theme_name (self, g_value_get_string (value));
		break;
		case GAME_GROUP_IS_ZEALOUS_PROPERTY:
		game_group_set_is_zealous (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

Theme*
theme_construct (GType object_type,
                 const gchar* name)
{
	Theme * self = NULL;
	ClutterImage** _tmp0_;
	gchar** colors = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint colors_length1;
	gint _colors_size_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (Theme*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (ClutterImage*, 4 + 1);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->textures = _tmp0_;
	self->textures_length1 = 4;
	self->_textures_size_ = self->textures_length1;
	_tmp1_ = g_strdup ("blue");
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_strdup ("yellow");
	_tmp4_ = g_strdup ("red");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	colors = _tmp5_;
	colors_length1 = 4;
	_colors_size_ = colors_length1;
	{
		GdkPixbuf* pixbuf = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GdkPixbuf* _tmp27_;
		GdkPixbuf* _tmp28_;
		ClutterImage* _tmp29_;
		ClutterImage* _tmp30_;
		GdkPixbuf* _tmp31_;
		guint8* _tmp32_;
		GdkPixbuf* _tmp33_;
		GdkPixbuf* _tmp34_;
		GdkPixbuf* _tmp35_;
		{
			guint8 i = 0U;
			i = (guint8) 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GdkPixbuf* pixbuf = NULL;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					GdkPixbuf* _tmp14_;
					GdkPixbuf* _tmp15_;
					ClutterImage** _tmp16_;
					gint _tmp16__length1;
					ClutterImage* _tmp17_;
					ClutterImage** _tmp18_;
					gint _tmp18__length1;
					ClutterImage* _tmp19_;
					GdkPixbuf* _tmp20_;
					guint8* _tmp21_;
					GdkPixbuf* _tmp22_;
					GdkPixbuf* _tmp23_;
					GdkPixbuf* _tmp24_;
					if (!_tmp6_) {
						guint8 _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(((gint) i) < 4)) {
						break;
					}
					_tmp8_ = colors;
					_tmp8__length1 = colors_length1;
					_tmp9_ = _tmp8_[i];
					_tmp10_ = g_strconcat (_tmp9_, ".svg", NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_build_filename (DATADIR, "themes", name, _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = gdk_pixbuf_new_from_file (_tmp13_, &_inner_error0_);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					pixbuf = _tmp15_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_tmp16_ = self->textures;
					_tmp16__length1 = self->textures_length1;
					_tmp17_ = (ClutterImage*) clutter_image_new ();
					_g_object_unref0 (_tmp16_[i]);
					_tmp16_[i] = _tmp17_;
					_tmp18_ = self->textures;
					_tmp18__length1 = self->textures_length1;
					_tmp19_ = _tmp18_[i];
					_tmp20_ = pixbuf;
					_tmp21_ = gdk_pixbuf_get_pixels (_tmp20_);
					_tmp22_ = pixbuf;
					_tmp23_ = pixbuf;
					_tmp24_ = pixbuf;
					clutter_image_set_data (_tmp19_, _tmp21_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) gdk_pixbuf_get_width (_tmp22_), (guint) gdk_pixbuf_get_height (_tmp23_), (guint) gdk_pixbuf_get_rowstride (_tmp24_), &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (pixbuf);
						if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_g_object_unref0 (pixbuf);
				}
			}
		}
		_tmp25_ = g_build_filename (DATADIR, "themes", name, "highlight.svg", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = gdk_pixbuf_new_from_file (_tmp26_, &_inner_error0_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		pixbuf = _tmp28_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_tmp29_ = (ClutterImage*) clutter_image_new ();
		_g_object_unref0 (self->cursor);
		self->cursor = _tmp29_;
		_tmp30_ = self->cursor;
		_tmp31_ = pixbuf;
		_tmp32_ = gdk_pixbuf_get_pixels (_tmp31_);
		_tmp33_ = pixbuf;
		_tmp34_ = pixbuf;
		_tmp35_ = pixbuf;
		clutter_image_set_data (_tmp30_, _tmp32_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) gdk_pixbuf_get_width (_tmp33_), (guint) gdk_pixbuf_get_height (_tmp34_), (guint) gdk_pixbuf_get_rowstride (_tmp35_), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (pixbuf);
	}
	goto __finally0;
	__catch0_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("game-view.vala:496: Failed to load textures: %s", _tmp37_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("game-view.vala:500: Failed to load textures: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

Theme*
theme_new (const gchar* name)
{
	return theme_construct (TYPE_THEME, name);
}

static void
theme_class_init (ThemeClass * klass,
                  gpointer klass_data)
{
	theme_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = theme_finalize;
}

static void
theme_instance_init (Theme * self,
                     gpointer klass)
{
}

static void
theme_finalize (GObject * obj)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->cursor);
	G_OBJECT_CLASS (theme_parent_class)->finalize (obj);
}

/**
 *  This class holds the textures for a specific theme. These textures are used for creating light
 *  actors and cursor actor.
 */
static GType
theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, NULL };
	GType theme_type_id;
	theme_type_id = g_type_register_static (G_TYPE_OBJECT, "Theme", &g_define_type_info, 0);
	return theme_type_id;
}

GType
theme_get_type (void)
{
	static volatile gsize theme_type_id__once = 0;
	if (g_once_init_enter (&theme_type_id__once)) {
		GType theme_type_id;
		theme_type_id = theme_get_type_once ();
		g_once_init_leave (&theme_type_id__once, theme_type_id);
	}
	return theme_type_id__once;
}

static GType
opacity_get_type_once (void)
{
	static const GEnumValue values[] = {{OPACITY_NULL, "OPACITY_NULL", "null"}, {OPACITY_HALF, "OPACITY_HALF", "half"}, {OPACITY_FULL, "OPACITY_FULL", "full"}, {0, NULL, NULL}};
	GType opacity_type_id;
	opacity_type_id = g_enum_register_static ("Opacity", values);
	return opacity_type_id;
}

GType
opacity_get_type (void)
{
	static volatile gsize opacity_type_id__once = 0;
	if (g_once_init_enter (&opacity_type_id__once)) {
		GType opacity_type_id;
		opacity_type_id = opacity_get_type_once ();
		g_once_init_leave (&opacity_type_id__once, opacity_type_id);
	}
	return opacity_type_id__once;
}

TileActor*
tile_actor_construct (GType object_type,
                      Tile* tile,
                      ClutterImage* texture,
                      gint size)
{
	TileActor * self = NULL;
	Tile* _tmp0_;
	g_return_val_if_fail (tile != NULL, NULL);
	g_return_val_if_fail (texture != NULL, NULL);
	self = (TileActor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (tile);
	_g_object_unref0 (self->tile);
	self->tile = _tmp0_;
	tile_actor_update_opacity (self, OPACITY_HALF);
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) size, (gfloat) size);
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) texture);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	return self;
}

TileActor*
tile_actor_new (Tile* tile,
                ClutterImage* texture,
                gint size)
{
	return tile_actor_construct (TYPE_TILE_ACTOR, tile, texture, size);
}

void
tile_actor_update_opacity (TileActor* self,
                           Opacity opacity)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 200);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	switch (opacity) {
		case OPACITY_NULL:
		{
			clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
			break;
		}
		case OPACITY_HALF:
		{
			clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 180);
			break;
		}
		case OPACITY_FULL:
		{
			clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
_tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                              gpointer self)
{
	tile_actor_hide_tile_cb ((TileActor*) self);
}

void
tile_actor_animate_out (TileActor* self)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_LINEAR);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	clutter_actor_set_scale ((ClutterActor*) self, 2.0, 2.0);
	tile_actor_update_opacity (self, OPACITY_NULL);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _tile_actor_hide_tile_cb_clutter_actor_transitions_completed, self, 0);
}

static void
tile_actor_hide_tile_cb (TileActor* self)
{
	g_return_if_fail (self != NULL);
	clutter_actor_hide ((ClutterActor*) self);
}

void
tile_actor_animate_to (TileActor* self,
                       gdouble new_x,
                       gdouble new_y,
                       gboolean is_zealous)
{
	ClutterAnimationMode _tmp0_ = 0;
	ClutterAnimationMode anim_mode = 0;
	g_return_if_fail (self != NULL);
	if (is_zealous) {
		_tmp0_ = CLUTTER_EASE_OUT_BOUNCE;
	} else {
		_tmp0_ = CLUTTER_EASE_OUT_QUAD;
	}
	anim_mode = _tmp0_;
	clutter_actor_set_easing_mode ((ClutterActor*) self, anim_mode);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) new_x, (gfloat) new_y);
}

static void
tile_actor_class_init (TileActorClass * klass,
                       gpointer klass_data)
{
	tile_actor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tile_actor_finalize;
}

static void
tile_actor_instance_init (TileActor * self,
                          gpointer klass)
{
}

static void
tile_actor_finalize (GObject * obj)
{
	TileActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_ACTOR, TileActor);
	_g_object_unref0 (self->tile);
	G_OBJECT_CLASS (tile_actor_parent_class)->finalize (obj);
}

/**
 *  This class defines the view of a tile. All clutter related stuff goes here
 */
static GType
tile_actor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TileActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileActor), 0, (GInstanceInitFunc) tile_actor_instance_init, NULL };
	GType tile_actor_type_id;
	tile_actor_type_id = g_type_register_static (clutter_actor_get_type (), "TileActor", &g_define_type_info, 0);
	return tile_actor_type_id;
}

GType
tile_actor_get_type (void)
{
	static volatile gsize tile_actor_type_id__once = 0;
	if (g_once_init_enter (&tile_actor_type_id__once)) {
		GType tile_actor_type_id;
		tile_actor_type_id = tile_actor_get_type_once ();
		g_once_init_leave (&tile_actor_type_id__once, tile_actor_type_id);
	}
	return tile_actor_type_id__once;
}

CursorActor*
cursor_actor_construct (GType object_type,
                        ClutterContent* texture,
                        gint size)
{
	CursorActor * self = NULL;
	g_return_val_if_fail (texture != NULL, NULL);
	self = (CursorActor*) g_object_new (object_type, NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 180);
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) size, (gfloat) size);
	clutter_actor_set_content ((ClutterActor*) self, texture);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	return self;
}

CursorActor*
cursor_actor_new (ClutterContent* texture,
                  gint size)
{
	return cursor_actor_construct (TYPE_CURSOR_ACTOR, texture, size);
}

static void
cursor_actor_class_init (CursorActorClass * klass,
                         gpointer klass_data)
{
	cursor_actor_parent_class = g_type_class_peek_parent (klass);
}

static void
cursor_actor_instance_init (CursorActor * self,
                            gpointer klass)
{
}

static GType
cursor_actor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CursorActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cursor_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CursorActor), 0, (GInstanceInitFunc) cursor_actor_instance_init, NULL };
	GType cursor_actor_type_id;
	cursor_actor_type_id = g_type_register_static (clutter_actor_get_type (), "CursorActor", &g_define_type_info, 0);
	return cursor_actor_type_id;
}

GType
cursor_actor_get_type (void)
{
	static volatile gsize cursor_actor_type_id__once = 0;
	if (g_once_init_enter (&cursor_actor_type_id__once)) {
		GType cursor_actor_type_id;
		cursor_actor_type_id = cursor_actor_get_type_once ();
		g_once_init_leave (&cursor_actor_type_id__once, cursor_actor_type_id);
	}
	return cursor_actor_type_id__once;
}

static inline gpointer
score_actor_get_instance_private (ScoreActor* self)
{
	return G_STRUCT_MEMBER_P (self, ScoreActor_private_offset);
}

ScoreActor*
score_actor_construct (GType object_type,
                       gint game_size,
                       gdouble width,
                       gdouble height)
{
	ScoreActor * self = NULL;
	ClutterText* _tmp0_;
	ClutterText* _tmp1_;
	ClutterColor _tmp2_ = {0};
	ClutterText* _tmp3_;
	self = (ScoreActor*) g_object_new (object_type, NULL);
	_tmp0_ = (ClutterText*) clutter_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp0_;
	_tmp1_ = self->priv->label;
	clutter_color_from_string (&_tmp2_, "rgba(255, 255, 255, 255)");
	clutter_text_set_color (_tmp1_, &_tmp2_);
	_tmp3_ = self->priv->label;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp3_);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	self->priv->scene_width = (gfloat) width;
	self->priv->scene_height = (gfloat) height;
	self->priv->game_size = game_size;
	return self;
}

ScoreActor*
score_actor_new (gint game_size,
                 gdouble width,
                 gdouble height)
{
	return score_actor_construct (TYPE_SCORE_ACTOR, game_size, width, height);
}

static void
__lambda6_ (ScoreActor* self)
{
	clutter_actor_destroy ((ClutterActor*) self);
}

static void
___lambda6__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                 gpointer self)
{
	__lambda6_ ((ScoreActor*) self);
}

void
score_actor_animate_score (ScoreActor* self,
                           guint points)
{
	ClutterText* _tmp0_;
	ClutterText* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	if (points == ((guint) 0)) {
		return;
	}
	_tmp0_ = self->priv->label;
	clutter_text_set_font_name (_tmp0_, "Bitstrem Vera Sans Bold 30");
	_tmp1_ = self->priv->label;
	_tmp2_ = g_strdup_printf ("%u", points);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("+", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	clutter_text_set_text (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
	clutter_actor_set_z_position ((ClutterActor*) self, 0.f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_SINE);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 600);
	clutter_actor_set_z_position ((ClutterActor*) self, 500.f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) ___lambda6__clutter_actor_transitions_completed, self, 0);
}

void
score_actor_animate_final_score (ScoreActor* self,
                                 guint points)
{
	ClutterText* _tmp0_;
	gchar* points_label = NULL;
	gchar* _tmp1_;
	ClutterText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ClutterText* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label;
	clutter_text_set_font_name (_tmp0_, "Bitstrem Vera Sans 30");
	_tmp1_ = g_strdup_printf (ngettext ("%u point", "%u points", (gulong) points), points);
	points_label = _tmp1_;
	_tmp2_ = self->priv->label;
	_tmp3_ = g_strdup_printf ("<b>%s</b>\n%s", _ ("Game Over!"), points_label);
	_tmp4_ = _tmp3_;
	clutter_text_set_markup (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->label;
	clutter_text_set_line_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
	clutter_actor_set_z_position ((ClutterActor*) self, (-300.f) + (self->priv->game_size * 100));
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_ELASTIC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 2000);
	clutter_actor_set_z_position ((ClutterActor*) self, (gfloat) (-200 + (self->priv->game_size * 150)));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
	_g_free0 (points_label);
}

static void
score_actor_class_init (ScoreActorClass * klass,
                        gpointer klass_data)
{
	score_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScoreActor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = score_actor_finalize;
}

static void
score_actor_instance_init (ScoreActor * self,
                           gpointer klass)
{
	self->priv = score_actor_get_instance_private (self);
}

static void
score_actor_finalize (GObject * obj)
{
	ScoreActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_ACTOR, ScoreActor);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (score_actor_parent_class)->finalize (obj);
}

/**
 *  This class defines the view of a score. All clutter related stuff goes here
 */
static GType
score_actor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreActor), 0, (GInstanceInitFunc) score_actor_instance_init, NULL };
	GType score_actor_type_id;
	score_actor_type_id = g_type_register_static (clutter_group_get_type (), "ScoreActor", &g_define_type_info, 0);
	ScoreActor_private_offset = g_type_add_instance_private (score_actor_type_id, sizeof (ScoreActorPrivate));
	return score_actor_type_id;
}

GType
score_actor_get_type (void)
{
	static volatile gsize score_actor_type_id__once = 0;
	if (g_once_init_enter (&score_actor_type_id__once)) {
		GType score_actor_type_id;
		score_actor_type_id = score_actor_get_type_once ();
		g_once_init_leave (&score_actor_type_id__once, score_actor_type_id);
	}
	return score_actor_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

