# Testing duplicity

## Introduction
Duplicity's tests are unit tests contained in the /testing folder of the main repository.

## Running tests on your branch
The recommended approach is to test duplicity using Docker, to ensure that you are running tests in a known-good
environment. This also creates additional containers to test backends. You can run tests on your branch as follows:
a. Install Docker
b. cd [BRANCH FOLDER]/testing/docker/
c. ./setup.sh to build and to start the containers and open a shell inside your branch folder in duplicity_test.
d. cd testing/
e. ./run-tests
f. When you are finished, exit the Docker container and run ./teardown.sh to delete the containers.

Please test your branch using this method and ensure all tests pass before submitting a merge request.

The decorator @unittest.expectedFailure can be used to commit a known-failing test case without breaking the test suite,
for example to exhibit the behaviour in a bug report before it has been fixed.

## Manual testing and running individual tests
As to see in the following sketch, there are several levels of testing duplicity and each can be used directly.

                                    ┌─────────────────────┐
                                    │    docker image     │
                                    ├─────────────────────┴────┐
                                    │                          │
                                    │  ┌──────────────────┐    │
                                    │  │  run-tests/tox   │    │
                                    │  └──────────────────┘    │
                                    │            │             │
                                    │            ▼             │
                                    │  ┌──────────────────┐    │
                                    │  │    unittests     │    │
                                    │  └──────────────────┘    │
                                    │            │             │
                                    │            ▼             │
                                    │  ┌──────────────────┐    │
                                    │  │    duplicity     │    │
                                    │  └──────────────────┘    │
                                    │                          │
                                    └──────────────────────────┘

1. Docker container
Even if you wish to run tests manually, we recommend that you do this inside the provided Docker container to ensure
that you have a clean and reproducible environment with all required dependencies for executing these. Please follow
steps a to d of the above section titled "Running tests on your branch".

2. Using run-tests
The run-tests script mentioned above is a shortcut to running all tests with tox. This is the recommended approach to
run tests on your code. We recommend running this within the provided Docker container as mentioned above, but it is
possible to run this directly if you have installed all required dependencies (see "Dependencies for testing" below).

3. Using tox
Tox is a generic virtualenv management and test command line tool that is used for checking your package installs
correctly with different Python versions and interpreters. It runs the tests in each of the environments that are
configured in the tox.ini file (see root folder of the repository). As mentioned, we recommend this is run inside the
provided Docker container.

A tox run can be started simply by typing

‘tox‘

from the main duplicity folder.

You can run specific tests using:
‘tox -- [test filename][::TestClassName::test_method]‘
For example:
‘tox -- testing/unit/test_selection.py‘
or:
‘tox -- testing/unit/test_selection.py::MatchingTest::test_tuple_include‘

You can test against a single environment, e.g.
‘tox -e py27‘

Or stack these together, e.g.
‘tox -e py3 -- testing/unit/test_selection.py::MatchingTest::test_tuple_include‘

This is helpful, for example, if you are working on fixing a bug, but please do a full run-tests before submitting a
merge request.

4. Testing directly using __setup.py__
Assuming that your machine has all the required dependencies installed, you can start all the unit tests by simply typing

‘setup.py test‘

## Dependencies for testing
If you should prefer to execute the tests locally without using Docker, see the Dockerfile in
testing/docker/duplicity_test/
for requirements to correctly set up your environment.

## Working with test coverage
Python makes it easy to determine how well the tests cover the source code.

You first run the tests __under observation__ of the coverage script:
‘coverage run setup.py test‘
After that, a report can be generated by the use of the command:
‘coverage html --omit="testing/*,/usr/*"‘

The report will be generated and stored in the folder htmlcov.
