/* Settings.c generated by valac 0.56.0, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright 2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#define CONSTANTS_CONF_DIR "/etc/lightdm"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_SETTINGS (greeter_settings_get_type ())
#define GREETER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SETTINGS, GreeterSettings))
#define GREETER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SETTINGS, GreeterSettingsClass))
#define GREETER_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SETTINGS))
#define GREETER_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SETTINGS))
#define GREETER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SETTINGS, GreeterSettingsClass))

typedef struct _GreeterSettings GreeterSettings;
typedef struct _GreeterSettingsClass GreeterSettingsClass;
typedef struct _GreeterSettingsPrivate GreeterSettingsPrivate;
enum  {
	GREETER_SETTINGS_0_PROPERTY,
	GREETER_SETTINGS_LAST_USER_PROPERTY,
	GREETER_SETTINGS_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY,
	GREETER_SETTINGS_SLEEP_INACTIVE_AC_TYPE_PROPERTY,
	GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY,
	GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY,
	GREETER_SETTINGS_ACTIVATE_NUMLOCK_PROPERTY,
	GREETER_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* greeter_settings_properties[GREETER_SETTINGS_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GreeterSettings {
	GObject parent_instance;
	GreeterSettingsPrivate * priv;
};

struct _GreeterSettingsClass {
	GObjectClass parent_class;
};

struct _GreeterSettingsPrivate {
	GKeyFile* state;
	GKeyFile* settings;
	GSettings* power_settings;
	gchar* state_file;
};

static gint GreeterSettings_private_offset;
static gpointer greeter_settings_parent_class = NULL;

VALA_EXTERN GType greeter_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSettings, g_object_unref)
VALA_EXTERN GreeterSettings* greeter_settings_new (void);
VALA_EXTERN GreeterSettings* greeter_settings_construct (GType object_type);
VALA_EXTERN gchar* greeter_settings_get_last_user (GreeterSettings* self);
VALA_EXTERN void greeter_settings_set_last_user (GreeterSettings* self,
                                     const gchar* value);
VALA_EXTERN void greeter_settings_set_sleep_inactive_ac_timeout (GreeterSettings* self,
                                                     gint value);
VALA_EXTERN void greeter_settings_set_sleep_inactive_ac_type (GreeterSettings* self,
                                                  gint value);
VALA_EXTERN void greeter_settings_set_sleep_inactive_battery_timeout (GreeterSettings* self,
                                                          gint value);
VALA_EXTERN void greeter_settings_set_sleep_inactive_battery_type (GreeterSettings* self,
                                                       gint value);
VALA_EXTERN gboolean greeter_settings_get_activate_numlock (GreeterSettings* self);
static GObject * greeter_settings_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void greeter_settings_finalize (GObject * obj);
static GType greeter_settings_get_type_once (void);
static void _vala_greeter_settings_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_greeter_settings_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
greeter_settings_get_instance_private (GreeterSettings* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterSettings_private_offset);
}

GreeterSettings*
greeter_settings_construct (GType object_type)
{
	GreeterSettings * self = NULL;
	self = (GreeterSettings*) g_object_new (object_type, NULL);
	return self;
}

GreeterSettings*
greeter_settings_new (void)
{
	return greeter_settings_construct (GREETER_TYPE_SETTINGS);
}

gchar*
greeter_settings_get_last_user (GreeterSettings* self)
{
	gchar* result;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->state;
		_tmp2_ = g_key_file_get_value (_tmp1_, "greeter", "last-user", &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_debug ("Settings.vala:33: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
greeter_settings_set_last_user (GreeterSettings* self,
                                const gchar* value)
{
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	g_key_file_set_value (_tmp0_, "greeter", "last-user", value);
	{
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->state;
		_tmp2_ = self->priv->state_file;
		g_key_file_save_to_file (_tmp1_, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("Settings.vala:43: Failed to write state: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, greeter_settings_properties[GREETER_SETTINGS_LAST_USER_PROPERTY]);
}

void
greeter_settings_set_sleep_inactive_ac_timeout (GreeterSettings* self,
                                                gint value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->power_settings;
		g_settings_set_int (_tmp1_, "sleep-inactive-ac-timeout", value);
	}
	g_object_notify_by_pspec ((GObject *) self, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY]);
}

void
greeter_settings_set_sleep_inactive_ac_type (GreeterSettings* self,
                                             gint value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->power_settings;
		g_settings_set_enum (_tmp1_, "sleep-inactive-ac-type", value);
	}
	g_object_notify_by_pspec ((GObject *) self, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_AC_TYPE_PROPERTY]);
}

void
greeter_settings_set_sleep_inactive_battery_timeout (GreeterSettings* self,
                                                     gint value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->power_settings;
		g_settings_set_int (_tmp1_, "sleep-inactive-battery-timeout", value);
	}
	g_object_notify_by_pspec ((GObject *) self, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY]);
}

void
greeter_settings_set_sleep_inactive_battery_type (GreeterSettings* self,
                                                  gint value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->power_settings;
		g_settings_set_enum (_tmp1_, "sleep-inactive-battery-type", value);
	}
	g_object_notify_by_pspec ((GObject *) self, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY]);
}

gboolean
greeter_settings_get_activate_numlock (GreeterSettings* self)
{
	gboolean result;
	gboolean _tmp4_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->settings;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, "greeter", "activate-numlock", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("Settings.vala:85: %s", _tmp3_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp4_;
}

static GObject *
greeter_settings_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterSettings * self;
	gchar* state_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* xdg_seat = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* state_file_name = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GKeyFile* _tmp15_;
	GKeyFile* _tmp21_;
	GSettings* _tmp27_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (greeter_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_SETTINGS, GreeterSettings);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "io.elementary.greeter", NULL);
	state_dir = _tmp1_;
	_tmp2_ = state_dir;
	g_mkdir_with_parents (_tmp2_, 0775);
	_tmp3_ = g_getenv ("XDG_SEAT");
	xdg_seat = _tmp3_;
	_tmp6_ = xdg_seat;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = xdg_seat;
		_tmp5_ = g_strcmp0 (_tmp7_, "seat0") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = xdg_seat;
		_tmp9_ = g_strconcat (_tmp8_, "-state", NULL);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("state");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp4_);
	state_file_name = _tmp11_;
	_tmp12_ = state_dir;
	_tmp13_ = state_file_name;
	_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
	_g_free0 (self->priv->state_file);
	self->priv->state_file = _tmp14_;
	_tmp15_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->state);
	self->priv->state = _tmp15_;
	{
		GKeyFile* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = self->priv->state;
		_tmp17_ = self->priv->state_file;
		g_key_file_load_from_file (_tmp16_, _tmp17_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
				goto __catch0_g_file_error_noent;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_file_error_noent:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = self->priv->state_file;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("Settings.vala:104: Failed to load state from %s: %s", _tmp18_, _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (state_file_name);
		_g_free0 (_tmp4_);
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp21_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->settings);
	self->priv->settings = _tmp21_;
	{
		gchar* greeter_conf_file = NULL;
		gchar* _tmp22_;
		GKeyFile* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = g_build_filename (CONSTANTS_CONF_DIR, "io.elementary.greeter.conf", NULL);
		greeter_conf_file = _tmp22_;
		_tmp23_ = self->priv->settings;
		_tmp24_ = greeter_conf_file;
		g_key_file_load_from_file (_tmp23_, _tmp24_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (greeter_conf_file);
			goto __catch1_g_error;
		}
		_g_free0 (greeter_conf_file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_critical ("Settings.vala:112: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (state_file_name);
		_g_free0 (_tmp4_);
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp27_ = g_settings_new ("org.gnome.settings-daemon.plugins.power");
	_g_object_unref0 (self->priv->power_settings);
	self->priv->power_settings = _tmp27_;
	_g_free0 (state_file_name);
	_g_free0 (_tmp4_);
	_g_free0 (state_dir);
	return obj;
}

static void
greeter_settings_class_init (GreeterSettingsClass * klass,
                             gpointer klass_data)
{
	greeter_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_LAST_USER_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_LAST_USER_PROPERTY] = g_param_spec_string ("last-user", "last-user", "last-user", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY] = g_param_spec_int ("sleep-inactive-ac-timeout", "sleep-inactive-ac-timeout", "sleep-inactive-ac-timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_SLEEP_INACTIVE_AC_TYPE_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_AC_TYPE_PROPERTY] = g_param_spec_int ("sleep-inactive-ac-type", "sleep-inactive-ac-type", "sleep-inactive-ac-type", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY] = g_param_spec_int ("sleep-inactive-battery-timeout", "sleep-inactive-battery-timeout", "sleep-inactive-battery-timeout", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY] = g_param_spec_int ("sleep-inactive-battery-type", "sleep-inactive-battery-type", "sleep-inactive-battery-type", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_SETTINGS_ACTIVATE_NUMLOCK_PROPERTY, greeter_settings_properties[GREETER_SETTINGS_ACTIVATE_NUMLOCK_PROPERTY] = g_param_spec_boolean ("activate-numlock", "activate-numlock", "activate-numlock", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
greeter_settings_instance_init (GreeterSettings * self,
                                gpointer klass)
{
	self->priv = greeter_settings_get_instance_private (self);
}

static void
greeter_settings_finalize (GObject * obj)
{
	GreeterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_SETTINGS, GreeterSettings);
	_g_key_file_unref0 (self->priv->state);
	_g_key_file_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->power_settings);
	_g_free0 (self->priv->state_file);
	G_OBJECT_CLASS (greeter_settings_parent_class)->finalize (obj);
}

static GType
greeter_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterSettings), 0, (GInstanceInitFunc) greeter_settings_instance_init, NULL };
	GType greeter_settings_type_id;
	greeter_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterSettings", &g_define_type_info, 0);
	GreeterSettings_private_offset = g_type_add_instance_private (greeter_settings_type_id, sizeof (GreeterSettingsPrivate));
	return greeter_settings_type_id;
}

GType
greeter_settings_get_type (void)
{
	static volatile gsize greeter_settings_type_id__once = 0;
	if (g_once_init_enter (&greeter_settings_type_id__once)) {
		GType greeter_settings_type_id;
		greeter_settings_type_id = greeter_settings_get_type_once ();
		g_once_init_leave (&greeter_settings_type_id__once, greeter_settings_type_id);
	}
	return greeter_settings_type_id__once;
}

static void
_vala_greeter_settings_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GreeterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_SETTINGS, GreeterSettings);
	switch (property_id) {
		case GREETER_SETTINGS_LAST_USER_PROPERTY:
		g_value_take_string (value, greeter_settings_get_last_user (self));
		break;
		case GREETER_SETTINGS_ACTIVATE_NUMLOCK_PROPERTY:
		g_value_set_boolean (value, greeter_settings_get_activate_numlock (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_settings_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GreeterSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_SETTINGS, GreeterSettings);
	switch (property_id) {
		case GREETER_SETTINGS_LAST_USER_PROPERTY:
		greeter_settings_set_last_user (self, g_value_get_string (value));
		break;
		case GREETER_SETTINGS_SLEEP_INACTIVE_AC_TIMEOUT_PROPERTY:
		greeter_settings_set_sleep_inactive_ac_timeout (self, g_value_get_int (value));
		break;
		case GREETER_SETTINGS_SLEEP_INACTIVE_AC_TYPE_PROPERTY:
		greeter_settings_set_sleep_inactive_ac_type (self, g_value_get_int (value));
		break;
		case GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TIMEOUT_PROPERTY:
		greeter_settings_set_sleep_inactive_battery_timeout (self, g_value_get_int (value));
		break;
		case GREETER_SETTINGS_SLEEP_INACTIVE_BATTERY_TYPE_PROPERTY:
		greeter_settings_set_sleep_inactive_battery_type (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

