#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#include <wlr/backend.h>
#include <wlr/backend/headless.h>
#include <wlr/backend/libinput.h>
#include <wlr/render/allocator.h>
#include <wlr/render/wlr_renderer.h>
#include <wlr/types/wlr_cursor.h>
#include <wlr/types/wlr_compositor.h>
#include <wlr/types/wlr_data_control_v1.h>
#include <wlr/types/wlr_data_device.h>
#include <wlr/types/wlr_foreign_toplevel_management_v1.h>
#include <wlr/types/wlr_gamma_control_v1.h>
#include <wlr/types/wlr_idle.h>
#include <wlr/types/wlr_idle_inhibit_v1.h>
#include <wlr/types/wlr_input_inhibitor.h>
#include <wlr/types/wlr_keyboard.h>
#include <wlr/types/wlr_layer_shell_v1.h>
#include <wlr/types/wlr_linux_dmabuf_v1.h>
#include <wlr/types/wlr_matrix.h>
#include <wlr/types/wlr_output.h>
#include <wlr/types/wlr_output_damage.h>
#include <wlr/types/wlr_output_layout.h>
#include <wlr/types/wlr_output_management_v1.h>
#include <wlr/types/wlr_output_power_management_v1.h>
#include <wlr/types/wlr_pointer_constraints_v1.h>
#include <wlr/types/wlr_primary_selection.h>
#include <wlr/types/wlr_primary_selection_v1.h>
#include <wlr/types/wlr_relative_pointer_v1.h>
#include <wlr/types/wlr_scene.h>
#include <wlr/types/wlr_screencopy_v1.h>
#include <wlr/types/wlr_surface.h>
#include <wlr/types/wlr_seat.h>
#include <wlr/types/wlr_server_decoration.h>
#include <wlr/types/wlr_virtual_keyboard_v1.h>
#include <wlr/types/wlr_xcursor_manager.h>
#include <wlr/types/wlr_xdg_decoration_v1.h>
#include <wlr/types/wlr_xdg_output_v1.h>
#include <wlr/types/wlr_xdg_shell.h>
#include <wlr/util/log.h>
#include <wlr/util/region.h>
#include <wlr/version.h>

#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>
#include <xkbcommon/xkbcommon-compose.h>

struct wl_listener_container {
    void *handle;
    struct wl_listener destroy_listener;
};

typedef void (*wrapped_log_func_t)(enum wlr_log_importance importance, const char *log_str);

wrapped_log_func_t py_callback = NULL;

void wrapped_log_callback(enum wlr_log_importance importance, const char *fmt, va_list args)
{
    char formatted_str[4096];
    vsnprintf(formatted_str, 4096, fmt, args);
    py_callback(importance, formatted_str);
}

void wrapped_log_init(enum wlr_log_importance verbosity, wrapped_log_func_t callback)
{
    if (callback == NULL)
    {
        wlr_log_init(verbosity, NULL);
    }
    else
    {
        py_callback = callback;
        wlr_log_init(verbosity, wrapped_log_callback);
    }
}

    #include <wlr/xwayland.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct pixman_region32 *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 1038), // struct pixman_region32 *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_backend *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 1064), // struct wlr_backend *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_box *, struct wlr_box const *, struct wlr_box const *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 1067), // struct wlr_box *
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 1067), // struct wlr_box const *
/*  9 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_box const *)
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_box const *, double, double)
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_cursor *, struct wlr_input_device *, double, double)
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 1073), // struct wlr_cursor *
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 1114), // struct wlr_input_device *
/* 22 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 23 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_input_device *)
/* 26 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_output *)
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 1133), // struct wlr_output *
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_output *, int *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 33 */ _CFFI_OP(_CFFI_OP_POINTER, 59), // int *
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_output *, struct wlr_allocator *, struct wlr_renderer *)
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 1063), // struct wlr_allocator *
/* 38 */ _CFFI_OP(_CFFI_OP_POINTER, 1167), // struct wlr_renderer *
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_output_damage *, _Bool *, struct pixman_region32 *)
/* 41 */ _CFFI_OP(_CFFI_OP_POINTER, 1139), // struct wlr_output_damage *
/* 42 */ _CFFI_OP(_CFFI_OP_POINTER, 364), // _Bool *
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_renderer *, struct wl_display *)
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 47 */ _CFFI_OP(_CFFI_OP_POINTER, 1044), // struct wl_display *
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_renderer *, struct wlr_texture *, float const *, float)
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 51 */ _CFFI_OP(_CFFI_OP_POINTER, 1205), // struct wlr_texture *
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // float const *
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13), // float
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_renderer *, struct wlr_texture *, float const *, int, int, float)
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 60 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 61 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_scene *, struct wlr_output_layout *)
/* 64 */ _CFFI_OP(_CFFI_OP_POINTER, 1168), // struct wlr_scene *
/* 65 */ _CFFI_OP(_CFFI_OP_POINTER, 1143), // struct wlr_output_layout *
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_scene_output *)
/* 68 */ _CFFI_OP(_CFFI_OP_POINTER, 1171), // struct wlr_scene_output *
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_seat *)
/* 71 */ _CFFI_OP(_CFFI_OP_POINTER, 1174), // struct wlr_seat *
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_seat *, struct wlr_surface *)
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 75 */ _CFFI_OP(_CFFI_OP_POINTER, 1195), // struct wlr_surface *
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_seat *, struct wlr_surface *, uint32_t)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_session *, unsigned int)
/* 83 */ _CFFI_OP(_CFFI_OP_POINTER, 1190), // struct wlr_session *
/* 84 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_surface *)
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_surface *, double, double)
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 91 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_surface *, struct wlr_surface_role const *, void *, struct wl_resource *, uint32_t)
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 96 */ _CFFI_OP(_CFFI_OP_POINTER, 1197), // struct wlr_surface_role const *
/* 97 */ _CFFI_OP(_CFFI_OP_POINTER, 1287), // void *
/* 98 */ _CFFI_OP(_CFFI_OP_POINTER, 1061), // struct wl_resource *
/* 99 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_texture *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, void const *)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 103 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 106 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 108 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 110 */ _CFFI_OP(_CFFI_OP_POINTER, 1287), // void const *
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 364), // _Bool()(struct wlr_xwayland_surface const *)
/* 113 */ _CFFI_OP(_CFFI_OP_POINTER, 1255), // struct wlr_xwayland_surface const *
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 116), // enum wl_output_transform()(enum wl_output_transform)
/* 116 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // enum wl_output_transform
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 947), // enum wlr_xwayland_icccm_input_model()(struct wlr_xwayland_surface const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(int, uint32_t, void *)
/* 122 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 123 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(int, void *)
/* 127 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(int32_t, struct timespec *)
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 1041), // struct timespec *
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(struct wlr_xcursor_manager *, float)
/* 135 */ _CFFI_OP(_CFFI_OP_POINTER, 1218), // struct wlr_xcursor_manager *
/* 136 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(struct wlr_xwm *, xcb_generic_event_t *)
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 1261), // struct wlr_xwm *
/* 140 */ _CFFI_OP(_CFFI_OP_POINTER, 1291), // xcb_generic_event_t *
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(void *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 148 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 149 */ _CFFI_OP(_CFFI_OP_POINTER, 1058), // struct wl_message const *
/* 150 */ _CFFI_OP(_CFFI_OP_POINTER, 1279), // union wl_argument *
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 59), // int()(xcb_connection_t *)
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 1288), // xcb_connection_t *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1034), // struct libinput_device *()(struct wlr_input_device *)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1036), // struct pixman_box32 *()(struct pixman_region32 *, int *)
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 160 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 37), // struct wlr_allocator *()(struct wlr_backend *, struct wlr_renderer *)
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // struct wlr_backend *()(struct wl_display *)
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // struct wlr_box *()(struct wlr_output_layout *, struct wlr_output *)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 363), // struct wlr_compositor *()(struct wl_display *, struct wlr_renderer *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION, 20), // struct wlr_cursor *()(void)
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1076), // struct wlr_data_control_manager_v1 *()(struct wl_display *)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1078), // struct wlr_data_device_manager *()(struct wl_display *)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 527), // struct wlr_foreign_toplevel_handle_v1 *()(struct wlr_foreign_toplevel_manager_v1 *)
/* 186 */ _CFFI_OP(_CFFI_OP_POINTER, 1106), // struct wlr_foreign_toplevel_manager_v1 *
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 186), // struct wlr_foreign_toplevel_manager_v1 *()(struct wl_display *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1107), // struct wlr_gamma_control_manager_v1 *()(struct wl_display *)
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 201), // struct wlr_idle *()(struct wl_display *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1110), // struct wlr_idle_inhibit_manager_v1 *()(struct wl_display *)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 555), // struct wlr_idle_timeout *()(struct wlr_idle *, struct wlr_seat *, uint32_t)
/* 201 */ _CFFI_OP(_CFFI_OP_POINTER, 1109), // struct wlr_idle *
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 203 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // struct wlr_input_device *()(struct wlr_backend *, enum wlr_input_device_type)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 207 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // enum wlr_input_device_type
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1117), // struct wlr_input_inhibit_manager *()(struct wl_display *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 378), // struct wlr_keyboard *()(struct wlr_seat *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1127), // struct wlr_layer_shell_v1 *()(struct wl_display *)
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION, 302), // struct wlr_layer_surface_v1 *()(struct wlr_surface *)
/* 219 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1131), // struct wlr_linux_dmabuf_v1 *()(struct wl_display *, struct wlr_renderer *)
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // struct wlr_output *()(struct wlr_backend *, unsigned int, unsigned int)
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 29), // struct wlr_output *()(struct wlr_output_layout *, double, double)
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 232 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 233 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1134), // struct wlr_output_configuration_head_v1 *()(struct wlr_output_configuration_v1 *, struct wlr_output *)
/* 236 */ _CFFI_OP(_CFFI_OP_POINTER, 1136), // struct wlr_output_configuration_v1 *
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 236), // struct wlr_output_configuration_v1 *()(void)
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 41), // struct wlr_output_damage *()(struct wlr_output *)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // struct wlr_output_layout *()(void)
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 655), // struct wlr_output_manager_v1 *()(struct wl_display *)
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 611), // struct wlr_output_mode *()(struct wlr_output *)
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1148), // struct wlr_output_power_manager_v1 *()(struct wl_display *)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 659), // struct wlr_pointer_constraint_v1 *()(struct wlr_pointer_constraints_v1 *, struct wlr_surface *, struct wlr_seat *)
/* 256 */ _CFFI_OP(_CFFI_OP_POINTER, 1157), // struct wlr_pointer_constraints_v1 *
/* 257 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 256), // struct wlr_pointer_constraints_v1 *()(struct wl_display *)
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1163), // struct wlr_primary_selection_v1_device_manager *()(struct wl_display *)
/* 264 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 662), // struct wlr_relative_pointer_manager_v1 *()(struct wl_display *)
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 38), // struct wlr_renderer *()(struct wlr_backend *)
/* 270 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 64), // struct wlr_scene *()(void)
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION, 275), // struct wlr_scene_node *()(struct wlr_scene_node *, struct wlr_xdg_surface *)
/* 275 */ _CFFI_OP(_CFFI_OP_POINTER, 1169), // struct wlr_scene_node *
/* 276 */ _CFFI_OP(_CFFI_OP_POINTER, 1229), // struct wlr_xdg_surface *
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 68), // struct wlr_scene_output *()(struct wlr_scene *, struct wlr_output *)
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 64),
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1172), // struct wlr_screencopy_manager_v1 *()(struct wl_display *)
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 71), // struct wlr_seat *()(struct wl_display *, char const *)
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 287 */ _CFFI_OP(_CFFI_OP_POINTER, 930), // char const *
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 796), // struct wlr_server_decoration_manager *()(struct wl_display *)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 83), // struct wlr_session *()(struct wlr_backend *)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1192), // struct wlr_subsurface *()(struct wlr_surface *)
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_surface *()(struct wl_resource *)
/* 299 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_surface *()(struct wlr_layer_surface_v1 *, double, double, double *, double *)
/* 302 */ _CFFI_OP(_CFFI_OP_POINTER, 1129), // struct wlr_layer_surface_v1 *
/* 303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 305 */ _CFFI_OP(_CFFI_OP_POINTER, 16), // double *
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_surface *()(struct wlr_surface *)
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_surface *()(struct wlr_surface *, double, double, double *, double *)
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 313 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 314 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 316 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION, 75), // struct wlr_surface *()(struct wlr_xdg_surface *, double, double, double *, double *)
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 320 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 321 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 322 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 324 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // struct wlr_texture *()(struct wlr_renderer *, uint32_t, uint32_t, uint32_t, uint32_t, void const *)
/* 326 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 327 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 328 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 329 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 330 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 333 */ _CFFI_OP(_CFFI_OP_FUNCTION, 51), // struct wlr_texture *()(struct wlr_surface *)
/* 334 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 336 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1210), // struct wlr_virtual_keyboard_manager_v1 *()(struct wl_display *)
/* 337 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1213), // struct wlr_xcursor *()(struct wlr_xcursor_manager *, char const *, float)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 135),
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 343 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION, 135), // struct wlr_xcursor_manager *()(char const *, uint32_t)
/* 345 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 346 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1221), // struct wlr_xdg_decoration_manager_v1 *()(struct wl_display *)
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1223), // struct wlr_xdg_output_manager_v1 *()(struct wl_display *, struct wlr_output_layout *)
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 354 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 355 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1227), // struct wlr_xdg_shell *()(struct wl_display *)
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 276), // struct wlr_xdg_surface *()(struct wlr_surface *)
/* 359 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 360 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION, 865), // struct wlr_xwayland *()(struct wl_display *, struct wlr_compositor *, _Bool)
/* 362 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 363 */ _CFFI_OP(_CFFI_OP_POINTER, 1072), // struct wlr_compositor *
/* 364 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1), // _Bool
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 881), // struct wlr_xwayland_server *()(struct wl_display *, struct wlr_xwayland_server_options *)
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 47),
/* 368 */ _CFFI_OP(_CFFI_OP_POINTER, 1254), // struct wlr_xwayland_server_options *
/* 369 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 370 */ _CFFI_OP(_CFFI_OP_FUNCTION, 884), // struct wlr_xwayland_surface *()(struct wlr_surface *)
/* 371 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1270), // uint32_t const *()(struct wlr_renderer *, size_t *)
/* 374 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 375 */ _CFFI_OP(_CFFI_OP_POINTER, 756), // size_t *
/* 376 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_keyboard *)
/* 378 */ _CFFI_OP(_CFFI_OP_POINTER, 1119), // struct wlr_keyboard *
/* 379 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_seat *, struct wlr_surface *, uint32_t, int32_t, double, double)
/* 381 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 382 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 383 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 384 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 385 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 386 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 388 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_seat *, uint32_t, uint32_t, enum wlr_button_state)
/* 389 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 390 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 391 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 392 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // enum wlr_button_state
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_surface *)
/* 395 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 397 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_xdg_surface *, _Bool)
/* 398 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 399 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_xdg_surface *, uint32_t)
/* 402 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 403 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 405 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_xdg_surface *, uint32_t, uint32_t)
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 407 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 408 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 409 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION, 80), // uint32_t()(struct wlr_xdg_toplevel_decoration_v1 *, enum wlr_xdg_toplevel_decoration_v1_mode)
/* 411 */ _CFFI_OP(_CFFI_OP_POINTER, 1237), // struct wlr_xdg_toplevel_decoration_v1 *
/* 412 */ _CFFI_OP(_CFFI_OP_ENUM, 18), // enum wlr_xdg_toplevel_decoration_v1_mode
/* 413 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 414 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(enum wlr_log_importance, char const *)
/* 415 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // enum wlr_log_importance
/* 416 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 417 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 418 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(enum wlr_log_importance, void(*)(enum wlr_log_importance, char const *))
/* 419 */ _CFFI_OP(_CFFI_OP_NOOP, 415),
/* 420 */ _CFFI_OP(_CFFI_OP_POINTER, 414), // void(*)(enum wlr_log_importance, char const *)
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *)
/* 423 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // float *
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 425 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, enum wl_output_transform)
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 427 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, float const *)
/* 430 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 431 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 432 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 433 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, float const *, float const *)
/* 434 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 435 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 437 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 438 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, float)
/* 439 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 441 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 442 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, float, float)
/* 443 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 445 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 446 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 447 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, int, int, enum wl_output_transform)
/* 448 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 449 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 450 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 451 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 452 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 453 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(float *, struct wlr_box const *, enum wl_output_transform, float, float const *)
/* 454 */ _CFFI_OP(_CFFI_OP_NOOP, 423),
/* 455 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 456 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 458 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct pixman_region32 *)
/* 461 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct pixman_region32 *, struct pixman_region32 *, enum wl_output_transform, int, int)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 465 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 466 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 467 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 468 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 469 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 470 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wl_client *, void *, uint32_t, uint32_t)
/* 471 */ _CFFI_OP(_CFFI_OP_POINTER, 1043), // struct wl_client *
/* 472 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 473 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 474 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 475 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 476 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wl_listener *, void *)
/* 477 */ _CFFI_OP(_CFFI_OP_POINTER, 1056), // struct wl_listener *
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 479 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 480 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wl_resource *)
/* 481 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 482 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 483 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_backend *)
/* 484 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 485 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 486 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_box *, struct wlr_box const *, enum wl_output_transform, int, int)
/* 487 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 488 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 489 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 492 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 493 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_box const *, double, double, double *, double *)
/* 494 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 496 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 497 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 498 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 499 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 500 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_cursor *)
/* 501 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 502 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 503 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_cursor *, struct wlr_input_device *)
/* 504 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 505 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 506 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 507 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_cursor *, struct wlr_input_device *, double, double)
/* 508 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 509 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 510 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 511 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 513 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_cursor *, struct wlr_output_layout *)
/* 514 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 515 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 516 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 517 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_cursor *, struct wlr_surface *, int32_t, int32_t)
/* 518 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 519 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 520 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 522 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 523 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_data_source *)
/* 524 */ _CFFI_OP(_CFFI_OP_POINTER, 1080), // struct wlr_data_source *
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 526 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_foreign_toplevel_handle_v1 *)
/* 527 */ _CFFI_OP(_CFFI_OP_POINTER, 1100), // struct wlr_foreign_toplevel_handle_v1 *
/* 528 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 529 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_foreign_toplevel_handle_v1 *, _Bool)
/* 530 */ _CFFI_OP(_CFFI_OP_NOOP, 527),
/* 531 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 532 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 533 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_foreign_toplevel_handle_v1 *, char const *)
/* 534 */ _CFFI_OP(_CFFI_OP_NOOP, 527),
/* 535 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 537 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_foreign_toplevel_handle_v1 *, struct wlr_foreign_toplevel_handle_v1 *)
/* 538 */ _CFFI_OP(_CFFI_OP_NOOP, 527),
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 527),
/* 540 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 541 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_foreign_toplevel_handle_v1 *, struct wlr_output *)
/* 542 */ _CFFI_OP(_CFFI_OP_NOOP, 527),
/* 543 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 544 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 545 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_idle *, struct wlr_seat *)
/* 546 */ _CFFI_OP(_CFFI_OP_NOOP, 201),
/* 547 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 548 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 549 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_idle *, struct wlr_seat *, _Bool)
/* 550 */ _CFFI_OP(_CFFI_OP_NOOP, 201),
/* 551 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 552 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 553 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 554 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_idle_timeout *)
/* 555 */ _CFFI_OP(_CFFI_OP_POINTER, 1113), // struct wlr_idle_timeout *
/* 556 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 557 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_keyboard *, int32_t, int32_t)
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 559 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 560 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 561 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 562 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_keyboard *, struct xkb_keymap *)
/* 563 */ _CFFI_OP(_CFFI_OP_NOOP, 378),
/* 564 */ _CFFI_OP(_CFFI_OP_POINTER, 1265), // struct xkb_keymap *
/* 565 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 566 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_layer_surface_v1 *)
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 302),
/* 568 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 569 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_layer_surface_v1 *, uint32_t, uint32_t)
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 302),
/* 571 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 572 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 573 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 574 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_layer_surface_v1 *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 302),
/* 576 */ _CFFI_OP(_CFFI_OP_POINTER, 802), // void(*)(struct wlr_surface *, int, int, void *)
/* 577 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 579 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *)
/* 580 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 581 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 582 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, _Bool)
/* 583 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 584 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 586 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, enum wl_output_transform)
/* 587 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 588 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 589 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 590 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, float)
/* 591 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 592 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 13),
/* 593 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 594 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, int *, int *)
/* 595 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 596 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 597 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 598 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 599 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, int32_t, int32_t, int32_t)
/* 600 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 601 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 602 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 603 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 604 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, struct pixman_region32 *)
/* 606 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 608 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 609 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output *, struct wlr_output_mode *)
/* 610 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 611 */ _CFFI_OP(_CFFI_OP_POINTER, 1147), // struct wlr_output_mode *
/* 612 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 613 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_configuration_v1 *)
/* 614 */ _CFFI_OP(_CFFI_OP_NOOP, 236),
/* 615 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_damage *)
/* 617 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 618 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 619 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_damage *, struct pixman_region32 *)
/* 620 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 621 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 622 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 623 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_damage *, struct wlr_box *)
/* 624 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 625 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 627 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_layout *)
/* 628 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 629 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 630 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_layout *, struct wlr_output *)
/* 631 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 632 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 633 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 634 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_layout *, struct wlr_output *, double *, double *)
/* 635 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 636 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 637 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 638 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 639 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 640 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_layout *, struct wlr_output *, double, double, double *, double *)
/* 641 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 642 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 643 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 644 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 645 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 646 */ _CFFI_OP(_CFFI_OP_NOOP, 305),
/* 647 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 648 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_layout *, struct wlr_output *, int, int)
/* 649 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 650 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 651 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 652 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 653 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 654 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_output_manager_v1 *, struct wlr_output_configuration_v1 *)
/* 655 */ _CFFI_OP(_CFFI_OP_POINTER, 1146), // struct wlr_output_manager_v1 *
/* 656 */ _CFFI_OP(_CFFI_OP_NOOP, 236),
/* 657 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 658 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_pointer_constraint_v1 *)
/* 659 */ _CFFI_OP(_CFFI_OP_POINTER, 1155), // struct wlr_pointer_constraint_v1 *
/* 660 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 661 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_relative_pointer_manager_v1 *, struct wlr_seat *, uint64_t, double, double, double, double)
/* 662 */ _CFFI_OP(_CFFI_OP_POINTER, 1165), // struct wlr_relative_pointer_manager_v1 *
/* 663 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 664 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 665 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 666 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 667 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 668 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 669 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 670 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_renderer *)
/* 671 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 672 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 673 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_renderer *, float const *)
/* 674 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 675 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 676 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 677 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_renderer *, int, int)
/* 678 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 679 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 680 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 681 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 682 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_renderer *, struct wlr_box *)
/* 683 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 684 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 685 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 686 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_renderer *, struct wlr_box const *, float const *, float const *)
/* 687 */ _CFFI_OP(_CFFI_OP_NOOP, 38),
/* 688 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 689 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 690 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 691 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 692 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_scene_node *)
/* 693 */ _CFFI_OP(_CFFI_OP_NOOP, 275),
/* 694 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 695 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_scene_node *, int, int)
/* 696 */ _CFFI_OP(_CFFI_OP_NOOP, 275),
/* 697 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 698 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 699 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 700 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_scene_node *, struct wlr_scene_node *)
/* 701 */ _CFFI_OP(_CFFI_OP_NOOP, 275),
/* 702 */ _CFFI_OP(_CFFI_OP_NOOP, 275),
/* 703 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 704 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_scene_output *, struct timespec *)
/* 705 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 706 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 707 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 708 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *)
/* 709 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 711 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, char const *)
/* 712 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 713 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 714 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 715 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_data_source *, uint32_t)
/* 716 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 717 */ _CFFI_OP(_CFFI_OP_NOOP, 524),
/* 718 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 719 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 720 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_drag *, uint32_t)
/* 721 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 722 */ _CFFI_OP(_CFFI_OP_POINTER, 1083), // struct wlr_drag *
/* 723 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 724 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 725 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_input_device *)
/* 726 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 728 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 729 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_keyboard_modifiers *)
/* 730 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 731 */ _CFFI_OP(_CFFI_OP_POINTER, 1126), // struct wlr_keyboard_modifiers *
/* 732 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 733 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_primary_selection_source *, uint32_t)
/* 734 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 735 */ _CFFI_OP(_CFFI_OP_POINTER, 1162), // struct wlr_primary_selection_source *
/* 736 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 737 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 738 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_seat_keyboard_grab *)
/* 739 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 740 */ _CFFI_OP(_CFFI_OP_POINTER, 1178), // struct wlr_seat_keyboard_grab *
/* 741 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 742 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_seat_pointer_grab *)
/* 743 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 744 */ _CFFI_OP(_CFFI_OP_POINTER, 1181), // struct wlr_seat_pointer_grab *
/* 745 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 746 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_surface *, double, double)
/* 747 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 749 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 750 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 751 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 752 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, struct wlr_surface *, uint32_t *, size_t, struct wlr_keyboard_modifiers *)
/* 753 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 754 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 755 */ _CFFI_OP(_CFFI_OP_POINTER, 80), // uint32_t *
/* 756 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 757 */ _CFFI_OP(_CFFI_OP_NOOP, 731),
/* 758 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 759 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t)
/* 760 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 761 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 762 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 763 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t, double, double)
/* 764 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 765 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 766 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 767 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 768 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 769 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t, enum wlr_axis_orientation, double, int32_t, enum wlr_axis_source)
/* 770 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 771 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 772 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // enum wlr_axis_orientation
/* 773 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 774 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 775 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // enum wlr_axis_source
/* 776 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 777 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t, int32_t)
/* 778 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 779 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 780 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 781 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 782 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t, int32_t, double, double)
/* 783 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 784 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 785 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 786 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 787 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 788 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 789 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_seat *, uint32_t, uint32_t, uint32_t)
/* 790 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 791 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 792 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 793 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 794 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 795 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_server_decoration_manager *, uint32_t)
/* 796 */ _CFFI_OP(_CFFI_OP_POINTER, 1189), // struct wlr_server_decoration_manager *
/* 797 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 798 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 799 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *)
/* 800 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 801 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 802 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, int, int, void *)
/* 803 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 804 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 805 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 806 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 807 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 808 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, struct pixman_region32 *)
/* 809 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 810 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 811 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 812 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, struct timespec const *)
/* 813 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 814 */ _CFFI_OP(_CFFI_OP_POINTER, 1041), // struct timespec const *
/* 815 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 816 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, struct wlr_box *)
/* 817 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 818 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 819 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 820 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, struct wlr_fbox *)
/* 821 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 822 */ _CFFI_OP(_CFFI_OP_POINTER, 1099), // struct wlr_fbox *
/* 823 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 824 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, struct wlr_output *)
/* 825 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 826 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 827 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 828 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, uint32_t)
/* 829 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 830 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 831 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_surface *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 833 */ _CFFI_OP(_CFFI_OP_NOOP, 75),
/* 834 */ _CFFI_OP(_CFFI_OP_NOOP, 576),
/* 835 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 837 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_texture *)
/* 838 */ _CFFI_OP(_CFFI_OP_NOOP, 51),
/* 839 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 840 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xcursor_manager *)
/* 841 */ _CFFI_OP(_CFFI_OP_NOOP, 135),
/* 842 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 843 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xcursor_manager *, char const *, struct wlr_cursor *)
/* 844 */ _CFFI_OP(_CFFI_OP_NOOP, 135),
/* 845 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 846 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 847 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 848 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xdg_popup *, struct wlr_box const *)
/* 849 */ _CFFI_OP(_CFFI_OP_POINTER, 1225), // struct wlr_xdg_popup *
/* 850 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 851 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 852 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xdg_surface *)
/* 853 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 854 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 855 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xdg_surface *, struct wlr_box *)
/* 856 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 857 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 858 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 859 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xdg_surface *, void(*)(struct wlr_surface *, int, int, void *), void *)
/* 860 */ _CFFI_OP(_CFFI_OP_NOOP, 276),
/* 861 */ _CFFI_OP(_CFFI_OP_NOOP, 576),
/* 862 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 863 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 864 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland *)
/* 865 */ _CFFI_OP(_CFFI_OP_POINTER, 1246), // struct wlr_xwayland *
/* 866 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 867 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland *, struct wlr_seat *)
/* 868 */ _CFFI_OP(_CFFI_OP_NOOP, 865),
/* 869 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 870 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 871 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland *, uint8_t *, uint32_t, uint32_t, uint32_t, int32_t, int32_t)
/* 872 */ _CFFI_OP(_CFFI_OP_NOOP, 865),
/* 873 */ _CFFI_OP(_CFFI_OP_POINTER, 919), // uint8_t *
/* 874 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 875 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 876 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 877 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 878 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21),
/* 879 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 880 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland_server *)
/* 881 */ _CFFI_OP(_CFFI_OP_POINTER, 1253), // struct wlr_xwayland_server *
/* 882 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 883 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland_surface *)
/* 884 */ _CFFI_OP(_CFFI_OP_POINTER, 1255), // struct wlr_xwayland_surface *
/* 885 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 886 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland_surface *, _Bool)
/* 887 */ _CFFI_OP(_CFFI_OP_NOOP, 884),
/* 888 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 1),
/* 889 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 890 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland_surface *, int16_t, int16_t, uint16_t, uint16_t)
/* 891 */ _CFFI_OP(_CFFI_OP_NOOP, 884),
/* 892 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19), // int16_t
/* 893 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 19),
/* 894 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 895 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 896 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 897 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct wlr_xwayland_surface *, struct wlr_xwayland_surface *, enum xcb_stack_mode_t)
/* 898 */ _CFFI_OP(_CFFI_OP_NOOP, 884),
/* 899 */ _CFFI_OP(_CFFI_OP_NOOP, 884),
/* 900 */ _CFFI_OP(_CFFI_OP_ENUM, 21), // enum xcb_stack_mode_t
/* 901 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 902 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(struct xkb_keymap *, uint32_t, void *)
/* 903 */ _CFFI_OP(_CFFI_OP_NOOP, 564),
/* 904 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 906 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 907 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(void *)
/* 908 */ _CFFI_OP(_CFFI_OP_NOOP, 97),
/* 909 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 910 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1287), // void()(xcb_connection_t *)
/* 911 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 912 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 913 */ _CFFI_OP(_CFFI_OP_FUNCTION, 153), // xcb_connection_t *()(char const *, int *)
/* 914 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 915 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 916 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 917 */ _CFFI_OP(_CFFI_OP_FUNCTION, 925), // xcb_intern_atom_cookie_t()(xcb_connection_t *, uint8_t, uint16_t, char const *)
/* 918 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 919 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 920 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20),
/* 921 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 922 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 923 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1292), // xcb_intern_atom_reply_t *()(xcb_connection_t *, xcb_intern_atom_cookie_t, xcb_generic_error_t * *)
/* 924 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 925 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 232), // xcb_intern_atom_cookie_t
/* 926 */ _CFFI_OP(_CFFI_OP_POINTER, 1289), // xcb_generic_error_t * *
/* 927 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 928 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // FILE
/* 929 */ _CFFI_OP(_CFFI_OP_POINTER, 930), // char *
/* 930 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 931 */ _CFFI_OP(_CFFI_OP_ARRAY, 930), // char[16]
/* 932 */ (_cffi_opcode_t)(16),
/* 933 */ _CFFI_OP(_CFFI_OP_ARRAY, 930), // char[56]
/* 934 */ (_cffi_opcode_t)(56),
/* 935 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum wl_data_device_manager_dnd_action
/* 936 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // enum wl_keyboard_key_state
/* 937 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // enum wl_output_subpixel
/* 938 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // enum wlr_drag_grab_type
/* 939 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // enum wlr_edges
/* 940 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // enum wlr_keyboard_led
/* 941 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // enum wlr_keyboard_modifier
/* 942 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // enum wlr_pointer_constraint_v1_state_field
/* 943 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // enum wlr_pointer_constraint_v1_type
/* 944 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // enum wlr_scene_node_type
/* 945 */ _CFFI_OP(_CFFI_OP_ENUM, 16), // enum wlr_server_decoration_manager_mode
/* 946 */ _CFFI_OP(_CFFI_OP_ENUM, 17), // enum wlr_xdg_surface_role
/* 947 */ _CFFI_OP(_CFFI_OP_ENUM, 19), // enum wlr_xwayland_icccm_input_model
/* 948 */ _CFFI_OP(_CFFI_OP_ENUM, 20), // enum wlr_xwayland_surface_decorations
/* 949 */ _CFFI_OP(_CFFI_OP_ENUM, 22), // enum xdg_positioner_anchor
/* 950 */ _CFFI_OP(_CFFI_OP_ENUM, 23), // enum xdg_positioner_constraint_adjustment
/* 951 */ _CFFI_OP(_CFFI_OP_ENUM, 24), // enum xdg_positioner_gravity
/* 952 */ _CFFI_OP(_CFFI_OP_ENUM, 25), // enum xkb_compose_compile_flags
/* 953 */ _CFFI_OP(_CFFI_OP_ENUM, 26), // enum xkb_compose_feed_result
/* 954 */ _CFFI_OP(_CFFI_OP_ENUM, 27), // enum xkb_compose_format
/* 955 */ _CFFI_OP(_CFFI_OP_ENUM, 28), // enum xkb_compose_state_flags
/* 956 */ _CFFI_OP(_CFFI_OP_ENUM, 29), // enum xkb_compose_status
/* 957 */ _CFFI_OP(_CFFI_OP_ENUM, 30), // enum xkb_context_flags
/* 958 */ _CFFI_OP(_CFFI_OP_ENUM, 31), // enum xkb_key_direction
/* 959 */ _CFFI_OP(_CFFI_OP_ENUM, 32), // enum xkb_keymap_compile_flags
/* 960 */ _CFFI_OP(_CFFI_OP_ENUM, 33), // enum xkb_keymap_format
/* 961 */ _CFFI_OP(_CFFI_OP_ENUM, 34), // enum xkb_keysym_flags
/* 962 */ _CFFI_OP(_CFFI_OP_ENUM, 35), // enum xkb_log_level
/* 963 */ _CFFI_OP(_CFFI_OP_ENUM, 36), // enum xkb_state_component
/* 964 */ _CFFI_OP(_CFFI_OP_ENUM, 37), // enum xkb_state_match
/* 965 */ _CFFI_OP(_CFFI_OP_ENUM, 38), // enum zwlr_layer_shell_v1_layer
/* 966 */ _CFFI_OP(_CFFI_OP_ENUM, 39), // enum zwlr_layer_surface_v1_keyboard_interactivity
/* 967 */ _CFFI_OP(_CFFI_OP_ENUM, 40), // enum zwlr_output_power_v1_mode
/* 968 */ _CFFI_OP(_CFFI_OP_ENUM, 41), // enum zwp_pointer_constraints_v1_lifetime
/* 969 */ _CFFI_OP(_CFFI_OP_ARRAY, 53), // float[9]
/* 970 */ (_cffi_opcode_t)(9),
/* 971 */ _CFFI_OP(_CFFI_OP_POINTER, 121), // int(*)(int, uint32_t, void *)
/* 972 */ _CFFI_OP(_CFFI_OP_POINTER, 126), // int(*)(int, void *)
/* 973 */ _CFFI_OP(_CFFI_OP_POINTER, 138), // int(*)(struct wlr_xwm *, xcb_generic_event_t *)
/* 974 */ _CFFI_OP(_CFFI_OP_POINTER, 142), // int(*)(void *)
/* 975 */ _CFFI_OP(_CFFI_OP_POINTER, 145), // int(*)(void const *, void *, uint32_t, struct wl_message const *, union wl_argument *)
/* 976 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 977 */ _CFFI_OP(_CFFI_OP_ARRAY, 59), // int[2]
/* 978 */ (_cffi_opcode_t)(2),
/* 979 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct $10
/* 980 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct $11
/* 981 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct $12
/* 982 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct $13
/* 983 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct $14
/* 984 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct $16
/* 985 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct $17
/* 986 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct $18
/* 987 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct $19
/* 988 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct $1
/* 989 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct $20
/* 990 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct $21
/* 991 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct $22
/* 992 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct $23
/* 993 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct $24
/* 994 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct $25
/* 995 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct $26
/* 996 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct $27
/* 997 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct $28
/* 998 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct $29
/* 999 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct $2
/* 1000 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct $30
/* 1001 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct $31
/* 1002 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct $32
/* 1003 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct $33
/* 1004 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct $34
/* 1005 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct $35
/* 1006 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // struct $36
/* 1007 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // struct $37
/* 1008 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // struct $38
/* 1009 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // struct $39
/* 1010 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct $3
/* 1011 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // struct $40
/* 1012 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // struct $41
/* 1013 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // struct $42
/* 1014 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // struct $43
/* 1015 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // struct $44
/* 1016 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // struct $45
/* 1017 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // struct $46
/* 1018 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // struct $47
/* 1019 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // struct $48
/* 1020 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // struct $49
/* 1021 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // struct $4
/* 1022 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // struct $51
/* 1023 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // struct $52
/* 1024 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // struct $53
/* 1025 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // struct $54
/* 1026 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // struct $55
/* 1027 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // struct $56
/* 1028 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // struct $57
/* 1029 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // struct $5
/* 1030 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // struct $6
/* 1031 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // struct $7
/* 1032 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // struct $8
/* 1033 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // struct $9
/* 1034 */ _CFFI_OP(_CFFI_OP_POINTER, 1035), // struct libinput_device *
/* 1035 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 60), // struct libinput_device
/* 1036 */ _CFFI_OP(_CFFI_OP_POINTER, 1037), // struct pixman_box32 *
/* 1037 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 61), // struct pixman_box32
/* 1038 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 62), // struct pixman_region32
/* 1039 */ _CFFI_OP(_CFFI_OP_ARRAY, 1038), // struct pixman_region32[2]
/* 1040 */ (_cffi_opcode_t)(2),
/* 1041 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 63), // struct timespec
/* 1042 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 65), // struct wl_array
/* 1043 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 66), // struct wl_client
/* 1044 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 67), // struct wl_display
/* 1045 */ _CFFI_OP(_CFFI_OP_POINTER, 1046), // struct wl_event_loop *
/* 1046 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 68), // struct wl_event_loop
/* 1047 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 69), // struct wl_event_queue
/* 1048 */ _CFFI_OP(_CFFI_OP_POINTER, 1051), // struct wl_event_source *
/* 1049 */ _CFFI_OP(_CFFI_OP_ARRAY, 1048), // struct wl_event_source *[2]
/* 1050 */ (_cffi_opcode_t)(2),
/* 1051 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 70), // struct wl_event_source
/* 1052 */ _CFFI_OP(_CFFI_OP_POINTER, 1053), // struct wl_global *
/* 1053 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 71), // struct wl_global
/* 1054 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 72), // struct wl_interface
/* 1055 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 73), // struct wl_list
/* 1056 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 74), // struct wl_listener
/* 1057 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 75), // struct wl_listener_container
/* 1058 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 76), // struct wl_message
/* 1059 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 77), // struct wl_object
/* 1060 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 78), // struct wl_proxy
/* 1061 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 79), // struct wl_resource
/* 1062 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 80), // struct wl_signal
/* 1063 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 81), // struct wlr_allocator
/* 1064 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 82), // struct wlr_backend
/* 1065 */ _CFFI_OP(_CFFI_OP_POINTER, 1066), // struct wlr_backend_impl const *
/* 1066 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 83), // struct wlr_backend_impl
/* 1067 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 84), // struct wlr_box
/* 1068 */ _CFFI_OP(_CFFI_OP_POINTER, 1069), // struct wlr_buffer *
/* 1069 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 85), // struct wlr_buffer
/* 1070 */ _CFFI_OP(_CFFI_OP_POINTER, 1071), // struct wlr_client_buffer *
/* 1071 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 86), // struct wlr_client_buffer
/* 1072 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 87), // struct wlr_compositor
/* 1073 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 88), // struct wlr_cursor
/* 1074 */ _CFFI_OP(_CFFI_OP_POINTER, 1075), // struct wlr_cursor_state *
/* 1075 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 89), // struct wlr_cursor_state
/* 1076 */ _CFFI_OP(_CFFI_OP_POINTER, 1077), // struct wlr_data_control_manager_v1 *
/* 1077 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 90), // struct wlr_data_control_manager_v1
/* 1078 */ _CFFI_OP(_CFFI_OP_POINTER, 1079), // struct wlr_data_device_manager *
/* 1079 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 91), // struct wlr_data_device_manager
/* 1080 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 92), // struct wlr_data_source
/* 1081 */ _CFFI_OP(_CFFI_OP_POINTER, 1082), // struct wlr_data_source_impl const *
/* 1082 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 93), // struct wlr_data_source_impl
/* 1083 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 94), // struct wlr_drag
/* 1084 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 95), // struct wlr_drag_drop_event
/* 1085 */ _CFFI_OP(_CFFI_OP_POINTER, 1086), // struct wlr_drag_icon *
/* 1086 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 96), // struct wlr_drag_icon
/* 1087 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 97), // struct wlr_drag_motion_event
/* 1088 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 98), // struct wlr_event_keyboard_key
/* 1089 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 99), // struct wlr_event_pointer_axis
/* 1090 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 100), // struct wlr_event_pointer_button
/* 1091 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 101), // struct wlr_event_pointer_motion
/* 1092 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 102), // struct wlr_event_pointer_motion_absolute
/* 1093 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 103), // struct wlr_event_pointer_pinch_begin
/* 1094 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 104), // struct wlr_event_pointer_pinch_end
/* 1095 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 105), // struct wlr_event_pointer_pinch_update
/* 1096 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 106), // struct wlr_event_pointer_swipe_begin
/* 1097 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 107), // struct wlr_event_pointer_swipe_end
/* 1098 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 108), // struct wlr_event_pointer_swipe_update
/* 1099 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 109), // struct wlr_fbox
/* 1100 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 110), // struct wlr_foreign_toplevel_handle_v1
/* 1101 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 111), // struct wlr_foreign_toplevel_handle_v1_activated_event
/* 1102 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 112), // struct wlr_foreign_toplevel_handle_v1_fullscreen_event
/* 1103 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 113), // struct wlr_foreign_toplevel_handle_v1_maximized_event
/* 1104 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 114), // struct wlr_foreign_toplevel_handle_v1_minimized_event
/* 1105 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 115), // struct wlr_foreign_toplevel_handle_v1_set_rectangle_event
/* 1106 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 116), // struct wlr_foreign_toplevel_manager_v1
/* 1107 */ _CFFI_OP(_CFFI_OP_POINTER, 1108), // struct wlr_gamma_control_manager_v1 *
/* 1108 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 117), // struct wlr_gamma_control_manager_v1
/* 1109 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 118), // struct wlr_idle
/* 1110 */ _CFFI_OP(_CFFI_OP_POINTER, 1111), // struct wlr_idle_inhibit_manager_v1 *
/* 1111 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 119), // struct wlr_idle_inhibit_manager_v1
/* 1112 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 120), // struct wlr_idle_inhibitor_v1
/* 1113 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 121), // struct wlr_idle_timeout
/* 1114 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 122), // struct wlr_input_device
/* 1115 */ _CFFI_OP(_CFFI_OP_POINTER, 1116), // struct wlr_input_device_impl const *
/* 1116 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 123), // struct wlr_input_device_impl
/* 1117 */ _CFFI_OP(_CFFI_OP_POINTER, 1118), // struct wlr_input_inhibit_manager *
/* 1118 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 124), // struct wlr_input_inhibit_manager
/* 1119 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 125), // struct wlr_keyboard
/* 1120 */ _CFFI_OP(_CFFI_OP_POINTER, 1121), // struct wlr_keyboard_grab_interface const *
/* 1121 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 126), // struct wlr_keyboard_grab_interface
/* 1122 */ _CFFI_OP(_CFFI_OP_POINTER, 1123), // struct wlr_keyboard_group *
/* 1123 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 127), // struct wlr_keyboard_group
/* 1124 */ _CFFI_OP(_CFFI_OP_POINTER, 1125), // struct wlr_keyboard_impl const *
/* 1125 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 128), // struct wlr_keyboard_impl
/* 1126 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 129), // struct wlr_keyboard_modifiers
/* 1127 */ _CFFI_OP(_CFFI_OP_POINTER, 1128), // struct wlr_layer_shell_v1 *
/* 1128 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 130), // struct wlr_layer_shell_v1
/* 1129 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 131), // struct wlr_layer_surface_v1
/* 1130 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 132), // struct wlr_layer_surface_v1_state
/* 1131 */ _CFFI_OP(_CFFI_OP_POINTER, 1132), // struct wlr_linux_dmabuf_v1 *
/* 1132 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 133), // struct wlr_linux_dmabuf_v1
/* 1133 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 134), // struct wlr_output
/* 1134 */ _CFFI_OP(_CFFI_OP_POINTER, 1135), // struct wlr_output_configuration_head_v1 *
/* 1135 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 135), // struct wlr_output_configuration_head_v1
/* 1136 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 136), // struct wlr_output_configuration_v1
/* 1137 */ _CFFI_OP(_CFFI_OP_POINTER, 1138), // struct wlr_output_cursor *
/* 1138 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 137), // struct wlr_output_cursor
/* 1139 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 138), // struct wlr_output_damage
/* 1140 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 139), // struct wlr_output_head_v1_state
/* 1141 */ _CFFI_OP(_CFFI_OP_POINTER, 1142), // struct wlr_output_impl const *
/* 1142 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 140), // struct wlr_output_impl
/* 1143 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 141), // struct wlr_output_layout
/* 1144 */ _CFFI_OP(_CFFI_OP_POINTER, 1145), // struct wlr_output_layout_state *
/* 1145 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 142), // struct wlr_output_layout_state
/* 1146 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 143), // struct wlr_output_manager_v1
/* 1147 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 144), // struct wlr_output_mode
/* 1148 */ _CFFI_OP(_CFFI_OP_POINTER, 1149), // struct wlr_output_power_manager_v1 *
/* 1149 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 145), // struct wlr_output_power_manager_v1
/* 1150 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 146), // struct wlr_output_power_v1
/* 1151 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 147), // struct wlr_output_power_v1_set_mode_event
/* 1152 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 148), // struct wlr_output_state
/* 1153 */ _CFFI_OP(_CFFI_OP_POINTER, 1154), // struct wlr_pointer *
/* 1154 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 149), // struct wlr_pointer
/* 1155 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 150), // struct wlr_pointer_constraint_v1
/* 1156 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 151), // struct wlr_pointer_constraint_v1_state
/* 1157 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 152), // struct wlr_pointer_constraints_v1
/* 1158 */ _CFFI_OP(_CFFI_OP_POINTER, 1159), // struct wlr_pointer_grab_interface const *
/* 1159 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 153), // struct wlr_pointer_grab_interface
/* 1160 */ _CFFI_OP(_CFFI_OP_POINTER, 1161), // struct wlr_pointer_impl const *
/* 1161 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 154), // struct wlr_pointer_impl
/* 1162 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 155), // struct wlr_primary_selection_source
/* 1163 */ _CFFI_OP(_CFFI_OP_POINTER, 1164), // struct wlr_primary_selection_v1_device_manager *
/* 1164 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 156), // struct wlr_primary_selection_v1_device_manager
/* 1165 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 157), // struct wlr_relative_pointer_manager_v1
/* 1166 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 158), // struct wlr_relative_pointer_v1
/* 1167 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 159), // struct wlr_renderer
/* 1168 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 160), // struct wlr_scene
/* 1169 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 161), // struct wlr_scene_node
/* 1170 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 162), // struct wlr_scene_node_state
/* 1171 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 163), // struct wlr_scene_output
/* 1172 */ _CFFI_OP(_CFFI_OP_POINTER, 1173), // struct wlr_screencopy_manager_v1 *
/* 1173 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 164), // struct wlr_screencopy_manager_v1
/* 1174 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 165), // struct wlr_seat
/* 1175 */ _CFFI_OP(_CFFI_OP_POINTER, 1176), // struct wlr_seat_client *
/* 1176 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 166), // struct wlr_seat_client
/* 1177 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 167), // struct wlr_seat_keyboard_focus_change_event
/* 1178 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 168), // struct wlr_seat_keyboard_grab
/* 1179 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 169), // struct wlr_seat_keyboard_state
/* 1180 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 170), // struct wlr_seat_pointer_focus_change_event
/* 1181 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 171), // struct wlr_seat_pointer_grab
/* 1182 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 172), // struct wlr_seat_pointer_request_set_cursor_event
/* 1183 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 173), // struct wlr_seat_pointer_state
/* 1184 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 174), // struct wlr_seat_request_set_primary_selection_event
/* 1185 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 175), // struct wlr_seat_request_set_selection_event
/* 1186 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 176), // struct wlr_seat_request_start_drag_event
/* 1187 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 177), // struct wlr_seat_touch_grab
/* 1188 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 178), // struct wlr_seat_touch_state
/* 1189 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 179), // struct wlr_server_decoration_manager
/* 1190 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 180), // struct wlr_session
/* 1191 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 181), // struct wlr_subcompositor
/* 1192 */ _CFFI_OP(_CFFI_OP_POINTER, 1193), // struct wlr_subsurface *
/* 1193 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 182), // struct wlr_subsurface
/* 1194 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 183), // struct wlr_subsurface_parent_state
/* 1195 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 184), // struct wlr_surface
/* 1196 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 185), // struct wlr_surface_output
/* 1197 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 186), // struct wlr_surface_role
/* 1198 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 187), // struct wlr_surface_state
/* 1199 */ _CFFI_OP(_CFFI_OP_POINTER, 1200), // struct wlr_switch *
/* 1200 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 188), // struct wlr_switch
/* 1201 */ _CFFI_OP(_CFFI_OP_POINTER, 1202), // struct wlr_tablet *
/* 1202 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 189), // struct wlr_tablet
/* 1203 */ _CFFI_OP(_CFFI_OP_POINTER, 1204), // struct wlr_tablet_pad *
/* 1204 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 190), // struct wlr_tablet_pad
/* 1205 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 191), // struct wlr_texture
/* 1206 */ _CFFI_OP(_CFFI_OP_POINTER, 1207), // struct wlr_touch *
/* 1207 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 192), // struct wlr_touch
/* 1208 */ _CFFI_OP(_CFFI_OP_POINTER, 1209), // struct wlr_touch_grab_interface const *
/* 1209 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 193), // struct wlr_touch_grab_interface
/* 1210 */ _CFFI_OP(_CFFI_OP_POINTER, 1211), // struct wlr_virtual_keyboard_manager_v1 *
/* 1211 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 194), // struct wlr_virtual_keyboard_manager_v1
/* 1212 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 195), // struct wlr_virtual_keyboard_v1
/* 1213 */ _CFFI_OP(_CFFI_OP_POINTER, 1214), // struct wlr_xcursor *
/* 1214 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 196), // struct wlr_xcursor
/* 1215 */ _CFFI_OP(_CFFI_OP_POINTER, 1216), // struct wlr_xcursor_image * *
/* 1216 */ _CFFI_OP(_CFFI_OP_POINTER, 1217), // struct wlr_xcursor_image *
/* 1217 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 197), // struct wlr_xcursor_image
/* 1218 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 198), // struct wlr_xcursor_manager
/* 1219 */ _CFFI_OP(_CFFI_OP_POINTER, 1220), // struct wlr_xdg_client *
/* 1220 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 199), // struct wlr_xdg_client
/* 1221 */ _CFFI_OP(_CFFI_OP_POINTER, 1222), // struct wlr_xdg_decoration_manager_v1 *
/* 1222 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 200), // struct wlr_xdg_decoration_manager_v1
/* 1223 */ _CFFI_OP(_CFFI_OP_POINTER, 1224), // struct wlr_xdg_output_manager_v1 *
/* 1224 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 201), // struct wlr_xdg_output_manager_v1
/* 1225 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 202), // struct wlr_xdg_popup
/* 1226 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 203), // struct wlr_xdg_positioner
/* 1227 */ _CFFI_OP(_CFFI_OP_POINTER, 1228), // struct wlr_xdg_shell *
/* 1228 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 204), // struct wlr_xdg_shell
/* 1229 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 205), // struct wlr_xdg_surface
/* 1230 */ _CFFI_OP(_CFFI_OP_POINTER, 1231), // struct wlr_xdg_surface_configure *
/* 1231 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 206), // struct wlr_xdg_surface_configure
/* 1232 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 207), // struct wlr_xdg_surface_state
/* 1233 */ _CFFI_OP(_CFFI_OP_POINTER, 1234), // struct wlr_xdg_toplevel *
/* 1234 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 208), // struct wlr_xdg_toplevel
/* 1235 */ _CFFI_OP(_CFFI_OP_POINTER, 1236), // struct wlr_xdg_toplevel_configure *
/* 1236 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 209), // struct wlr_xdg_toplevel_configure
/* 1237 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 210), // struct wlr_xdg_toplevel_decoration_v1
/* 1238 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 211), // struct wlr_xdg_toplevel_decoration_v1_configure
/* 1239 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 212), // struct wlr_xdg_toplevel_decoration_v1_state
/* 1240 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 213), // struct wlr_xdg_toplevel_move_event
/* 1241 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 214), // struct wlr_xdg_toplevel_requested
/* 1242 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 215), // struct wlr_xdg_toplevel_resize_event
/* 1243 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 216), // struct wlr_xdg_toplevel_set_fullscreen_event
/* 1244 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 217), // struct wlr_xdg_toplevel_show_window_menu_event
/* 1245 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 218), // struct wlr_xdg_toplevel_state
/* 1246 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 219), // struct wlr_xwayland
/* 1247 */ _CFFI_OP(_CFFI_OP_POINTER, 1248), // struct wlr_xwayland_cursor *
/* 1248 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 220), // struct wlr_xwayland_cursor
/* 1249 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 221), // struct wlr_xwayland_minimize_event
/* 1250 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 222), // struct wlr_xwayland_move_event
/* 1251 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 223), // struct wlr_xwayland_remove_startup_info_event
/* 1252 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 224), // struct wlr_xwayland_resize_event
/* 1253 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 225), // struct wlr_xwayland_server
/* 1254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 226), // struct wlr_xwayland_server_options
/* 1255 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 227), // struct wlr_xwayland_surface
/* 1256 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 228), // struct wlr_xwayland_surface_configure_event
/* 1257 */ _CFFI_OP(_CFFI_OP_POINTER, 1258), // struct wlr_xwayland_surface_hints *
/* 1258 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 229), // struct wlr_xwayland_surface_hints
/* 1259 */ _CFFI_OP(_CFFI_OP_POINTER, 1260), // struct wlr_xwayland_surface_size_hints *
/* 1260 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 230), // struct wlr_xwayland_surface_size_hints
/* 1261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 231), // struct wlr_xwm
/* 1262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 234), // struct xkb_compose_state
/* 1263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 235), // struct xkb_compose_table
/* 1264 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 236), // struct xkb_context
/* 1265 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 237), // struct xkb_keymap
/* 1266 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 238), // struct xkb_rule_names
/* 1267 */ _CFFI_OP(_CFFI_OP_POINTER, 1268), // struct xkb_state *
/* 1268 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 239), // struct xkb_state
/* 1269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 1270 */ _CFFI_OP(_CFFI_OP_POINTER, 80), // uint32_t const *
/* 1271 */ _CFFI_OP(_CFFI_OP_ARRAY, 80), // uint32_t[16]
/* 1272 */ (_cffi_opcode_t)(16),
/* 1273 */ _CFFI_OP(_CFFI_OP_ARRAY, 80), // uint32_t[32]
/* 1274 */ (_cffi_opcode_t)(32),
/* 1275 */ _CFFI_OP(_CFFI_OP_ARRAY, 80), // uint32_t[3]
/* 1276 */ (_cffi_opcode_t)(3),
/* 1277 */ _CFFI_OP(_CFFI_OP_ARRAY, 80), // uint32_t[8]
/* 1278 */ (_cffi_opcode_t)(8),
/* 1279 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 64), // union wl_argument
/* 1280 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // va_list
/* 1281 */ _CFFI_OP(_CFFI_OP_POINTER, 470), // void(*)(struct wl_client *, void *, uint32_t, uint32_t)
/* 1282 */ _CFFI_OP(_CFFI_OP_POINTER, 476), // void(*)(struct wl_listener *, void *)
/* 1283 */ _CFFI_OP(_CFFI_OP_POINTER, 480), // void(*)(struct wl_resource *)
/* 1284 */ _CFFI_OP(_CFFI_OP_POINTER, 799), // void(*)(struct wlr_surface *)
/* 1285 */ _CFFI_OP(_CFFI_OP_POINTER, 902), // void(*)(struct xkb_keymap *, uint32_t, void *)
/* 1286 */ _CFFI_OP(_CFFI_OP_POINTER, 907), // void(*)(void *)
/* 1287 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
/* 1288 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // xcb_connection_t
/* 1289 */ _CFFI_OP(_CFFI_OP_POINTER, 1290), // xcb_generic_error_t *
/* 1290 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 58), // xcb_generic_error_t
/* 1291 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 59), // xcb_generic_event_t
/* 1292 */ _CFFI_OP(_CFFI_OP_POINTER, 1293), // xcb_intern_atom_reply_t *
/* 1293 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 233), // xcb_intern_atom_reply_t
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_xcb_generic_event_t(xcb_generic_event_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_typedef_xcb_generic_event_t { char x; xcb_generic_event_t y; };

static int _cffi_const_WLR_AXIS_ORIENTATION_VERTICAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_VERTICAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_VERTICAL) | 0);  /* check that WLR_AXIS_ORIENTATION_VERTICAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL(unsigned long long *o)
{
  int n = (WLR_AXIS_ORIENTATION_HORIZONTAL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_ORIENTATION_HORIZONTAL) | 0);  /* check that WLR_AXIS_ORIENTATION_HORIZONTAL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_FINGER(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_FINGER) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_FINGER) | 0);  /* check that WLR_AXIS_SOURCE_FINGER is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_CONTINUOUS(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_CONTINUOUS) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_CONTINUOUS) | 0);  /* check that WLR_AXIS_SOURCE_CONTINUOUS is an integer */
  return n;
}

static int _cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT(unsigned long long *o)
{
  int n = (WLR_AXIS_SOURCE_WHEEL_TILT) <= 0;
  *o = (unsigned long long)((WLR_AXIS_SOURCE_WHEEL_TILT) | 0);  /* check that WLR_AXIS_SOURCE_WHEEL_TILT is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_RELEASED(unsigned long long *o)
{
  int n = (WLR_BUTTON_RELEASED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_RELEASED) | 0);  /* check that WLR_BUTTON_RELEASED is an integer */
  return n;
}

static int _cffi_const_WLR_BUTTON_PRESSED(unsigned long long *o)
{
  int n = (WLR_BUTTON_PRESSED) <= 0;
  *o = (unsigned long long)((WLR_BUTTON_PRESSED) | 0);  /* check that WLR_BUTTON_PRESSED is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_NONE(unsigned long long *o)
{
  int n = (WLR_EDGE_NONE) <= 0;
  *o = (unsigned long long)((WLR_EDGE_NONE) | 0);  /* check that WLR_EDGE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_TOP(unsigned long long *o)
{
  int n = (WLR_EDGE_TOP) <= 0;
  *o = (unsigned long long)((WLR_EDGE_TOP) | 0);  /* check that WLR_EDGE_TOP is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_BOTTOM(unsigned long long *o)
{
  int n = (WLR_EDGE_BOTTOM) <= 0;
  *o = (unsigned long long)((WLR_EDGE_BOTTOM) | 0);  /* check that WLR_EDGE_BOTTOM is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_LEFT(unsigned long long *o)
{
  int n = (WLR_EDGE_LEFT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_LEFT) | 0);  /* check that WLR_EDGE_LEFT is an integer */
  return n;
}

static int _cffi_const_WLR_EDGE_RIGHT(unsigned long long *o)
{
  int n = (WLR_EDGE_RIGHT) <= 0;
  *o = (unsigned long long)((WLR_EDGE_RIGHT) | 0);  /* check that WLR_EDGE_RIGHT is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_KEYBOARD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_KEYBOARD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_KEYBOARD) | 0);  /* check that WLR_INPUT_DEVICE_KEYBOARD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_POINTER(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_POINTER) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_POINTER) | 0);  /* check that WLR_INPUT_DEVICE_POINTER is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TOUCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TOUCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TOUCH) | 0);  /* check that WLR_INPUT_DEVICE_TOUCH is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_TOOL) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_TOOL) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_TOOL is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_TABLET_PAD(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_TABLET_PAD) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_TABLET_PAD) | 0);  /* check that WLR_INPUT_DEVICE_TABLET_PAD is an integer */
  return n;
}

static int _cffi_const_WLR_INPUT_DEVICE_SWITCH(unsigned long long *o)
{
  int n = (WLR_INPUT_DEVICE_SWITCH) <= 0;
  *o = (unsigned long long)((WLR_INPUT_DEVICE_SWITCH) | 0);  /* check that WLR_INPUT_DEVICE_SWITCH is an integer */
  return n;
}

static int _cffi_const_WLR_LED_NUM_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_NUM_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_NUM_LOCK) | 0);  /* check that WLR_LED_NUM_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_CAPS_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_CAPS_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_CAPS_LOCK) | 0);  /* check that WLR_LED_CAPS_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_LED_SCROLL_LOCK(unsigned long long *o)
{
  int n = (WLR_LED_SCROLL_LOCK) <= 0;
  *o = (unsigned long long)((WLR_LED_SCROLL_LOCK) | 0);  /* check that WLR_LED_SCROLL_LOCK is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_SHIFT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_SHIFT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_SHIFT) | 0);  /* check that WLR_MODIFIER_SHIFT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CAPS(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CAPS) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CAPS) | 0);  /* check that WLR_MODIFIER_CAPS is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_CTRL(unsigned long long *o)
{
  int n = (WLR_MODIFIER_CTRL) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_CTRL) | 0);  /* check that WLR_MODIFIER_CTRL is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_ALT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_ALT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_ALT) | 0);  /* check that WLR_MODIFIER_ALT is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD2(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD2) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD2) | 0);  /* check that WLR_MODIFIER_MOD2 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD3(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD3) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD3) | 0);  /* check that WLR_MODIFIER_MOD3 is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_LOGO(unsigned long long *o)
{
  int n = (WLR_MODIFIER_LOGO) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_LOGO) | 0);  /* check that WLR_MODIFIER_LOGO is an integer */
  return n;
}

static int _cffi_const_WLR_MODIFIER_MOD5(unsigned long long *o)
{
  int n = (WLR_MODIFIER_MOD5) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_MOD5) | 0);  /* check that WLR_MODIFIER_MOD5 is an integer */
  return n;
}

static int _cffi_const_WLR_SILENT(unsigned long long *o)
{
  int n = (WLR_SILENT) <= 0;
  *o = (unsigned long long)((WLR_SILENT) | 0);  /* check that WLR_SILENT is an integer */
  return n;
}

static int _cffi_const_WLR_ERROR(unsigned long long *o)
{
  int n = (WLR_ERROR) <= 0;
  *o = (unsigned long long)((WLR_ERROR) | 0);  /* check that WLR_ERROR is an integer */
  return n;
}

static int _cffi_const_WLR_INFO(unsigned long long *o)
{
  int n = (WLR_INFO) <= 0;
  *o = (unsigned long long)((WLR_INFO) | 0);  /* check that WLR_INFO is an integer */
  return n;
}

static int _cffi_const_WLR_DEBUG(unsigned long long *o)
{
  int n = (WLR_DEBUG) <= 0;
  *o = (unsigned long long)((WLR_DEBUG) | 0);  /* check that WLR_DEBUG is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_REGION) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_REGION) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_REGION is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_LOCKED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_LOCKED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_LOCKED is an integer */
  return n;
}

static int _cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED(unsigned long long *o)
{
  int n = (WLR_POINTER_CONSTRAINT_V1_CONFINED) <= 0;
  *o = (unsigned long long)((WLR_POINTER_CONSTRAINT_V1_CONFINED) | 0);  /* check that WLR_POINTER_CONSTRAINT_V1_CONFINED is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_NONE) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT is an integer */
  return n;
}

static int _cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER(unsigned long long *o)
{
  int n = (WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) <= 0;
  *o = (unsigned long long)((WLR_SERVER_DECORATION_MANAGER_MODE_SERVER) | 0);  /* check that WLR_SERVER_DECORATION_MANAGER_MODE_SERVER is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_NONE) | 0);  /* check that WLR_XDG_SURFACE_ROLE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_TOPLEVEL) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_TOPLEVEL) | 0);  /* check that WLR_XDG_SURFACE_ROLE_TOPLEVEL is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_SURFACE_ROLE_POPUP(unsigned long long *o)
{
  int n = (WLR_XDG_SURFACE_ROLE_POPUP) <= 0;
  *o = (unsigned long long)((WLR_XDG_SURFACE_ROLE_POPUP) | 0);  /* check that WLR_XDG_SURFACE_ROLE_POPUP is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE(unsigned long long *o)
{
  int n = (WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) <= 0;
  *o = (unsigned long long)((WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE) | 0);  /* check that WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_NONE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_NONE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_NONE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_NONE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_PASSIVE) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_PASSIVE) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_PASSIVE is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_LOCAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_LOCAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_LOCAL is an integer */
  return n;
}

static int _cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL(unsigned long long *o)
{
  int n = (WLR_ICCCM_INPUT_MODEL_GLOBAL) <= 0;
  *o = (unsigned long long)((WLR_ICCCM_INPUT_MODEL_GLOBAL) | 0);  /* check that WLR_ICCCM_INPUT_MODEL_GLOBAL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_ALL) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_ALL is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER is an integer */
  return n;
}

static int _cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE(unsigned long long *o)
{
  int n = (WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) <= 0;
  *o = (unsigned long long)((WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE) | 0);  /* check that WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPILE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_IGNORED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_IGNORED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_IGNORED) | 0);  /* check that XKB_COMPOSE_FEED_IGNORED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FEED_ACCEPTED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FEED_ACCEPTED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FEED_ACCEPTED) | 0);  /* check that XKB_COMPOSE_FEED_ACCEPTED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_COMPOSE_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_FORMAT_TEXT_V1) | 0);  /* check that XKB_COMPOSE_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_STATE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_COMPOSE_STATE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_STATE_NO_FLAGS) | 0);  /* check that XKB_COMPOSE_STATE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_NOTHING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_NOTHING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_NOTHING) | 0);  /* check that XKB_COMPOSE_NOTHING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSING(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSING) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSING) | 0);  /* check that XKB_COMPOSE_COMPOSING is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_COMPOSED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_COMPOSED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_COMPOSED) | 0);  /* check that XKB_COMPOSE_COMPOSED is an integer */
  return n;
}

static int _cffi_const_XKB_COMPOSE_CANCELLED(unsigned long long *o)
{
  int n = (XKB_COMPOSE_CANCELLED) <= 0;
  *o = (unsigned long long)((XKB_COMPOSE_CANCELLED) | 0);  /* check that XKB_COMPOSE_CANCELLED is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_FLAGS) | 0);  /* check that XKB_CONTEXT_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_DEFAULT_INCLUDES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_DEFAULT_INCLUDES) | 0);  /* check that XKB_CONTEXT_NO_DEFAULT_INCLUDES is an integer */
  return n;
}

static int _cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES(unsigned long long *o)
{
  int n = (XKB_CONTEXT_NO_ENVIRONMENT_NAMES) <= 0;
  *o = (unsigned long long)((XKB_CONTEXT_NO_ENVIRONMENT_NAMES) | 0);  /* check that XKB_CONTEXT_NO_ENVIRONMENT_NAMES is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_UP(unsigned long long *o)
{
  int n = (XKB_KEY_UP) <= 0;
  *o = (unsigned long long)((XKB_KEY_UP) | 0);  /* check that XKB_KEY_UP is an integer */
  return n;
}

static int _cffi_const_XKB_KEY_DOWN(unsigned long long *o)
{
  int n = (XKB_KEY_DOWN) <= 0;
  *o = (unsigned long long)((XKB_KEY_DOWN) | 0);  /* check that XKB_KEY_DOWN is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYMAP_COMPILE_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_COMPILE_NO_FLAGS) | 0);  /* check that XKB_KEYMAP_COMPILE_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1(unsigned long long *o)
{
  int n = (XKB_KEYMAP_FORMAT_TEXT_V1) <= 0;
  *o = (unsigned long long)((XKB_KEYMAP_FORMAT_TEXT_V1) | 0);  /* check that XKB_KEYMAP_FORMAT_TEXT_V1 is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_NO_FLAGS(unsigned long long *o)
{
  int n = (XKB_KEYSYM_NO_FLAGS) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_NO_FLAGS) | 0);  /* check that XKB_KEYSYM_NO_FLAGS is an integer */
  return n;
}

static int _cffi_const_XKB_KEYSYM_CASE_INSENSITIVE(unsigned long long *o)
{
  int n = (XKB_KEYSYM_CASE_INSENSITIVE) <= 0;
  *o = (unsigned long long)((XKB_KEYSYM_CASE_INSENSITIVE) | 0);  /* check that XKB_KEYSYM_CASE_INSENSITIVE is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_CRITICAL(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_CRITICAL) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_CRITICAL) | 0);  /* check that XKB_LOG_LEVEL_CRITICAL is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_ERROR(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_ERROR) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_ERROR) | 0);  /* check that XKB_LOG_LEVEL_ERROR is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_WARNING(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_WARNING) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_WARNING) | 0);  /* check that XKB_LOG_LEVEL_WARNING is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_INFO(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_INFO) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_INFO) | 0);  /* check that XKB_LOG_LEVEL_INFO is an integer */
  return n;
}

static int _cffi_const_XKB_LOG_LEVEL_DEBUG(unsigned long long *o)
{
  int n = (XKB_LOG_LEVEL_DEBUG) <= 0;
  *o = (unsigned long long)((XKB_LOG_LEVEL_DEBUG) | 0);  /* check that XKB_LOG_LEVEL_DEBUG is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_DEPRESSED) | 0);  /* check that XKB_STATE_MODS_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LATCHED) | 0);  /* check that XKB_STATE_MODS_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_LOCKED) | 0);  /* check that XKB_STATE_MODS_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MODS_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MODS_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MODS_EFFECTIVE) | 0);  /* check that XKB_STATE_MODS_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_DEPRESSED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_DEPRESSED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_DEPRESSED) | 0);  /* check that XKB_STATE_LAYOUT_DEPRESSED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LATCHED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LATCHED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LATCHED) | 0);  /* check that XKB_STATE_LAYOUT_LATCHED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_LOCKED(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_LOCKED) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_LOCKED) | 0);  /* check that XKB_STATE_LAYOUT_LOCKED is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LAYOUT_EFFECTIVE(unsigned long long *o)
{
  int n = (XKB_STATE_LAYOUT_EFFECTIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_LAYOUT_EFFECTIVE) | 0);  /* check that XKB_STATE_LAYOUT_EFFECTIVE is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_LEDS(unsigned long long *o)
{
  int n = (XKB_STATE_LEDS) <= 0;
  *o = (unsigned long long)((XKB_STATE_LEDS) | 0);  /* check that XKB_STATE_LEDS is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ANY(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ANY) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ANY) | 0);  /* check that XKB_STATE_MATCH_ANY is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_ALL(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_ALL) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_ALL) | 0);  /* check that XKB_STATE_MATCH_ALL is an integer */
  return n;
}

static int _cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE(unsigned long long *o)
{
  int n = (XKB_STATE_MATCH_NON_EXCLUSIVE) <= 0;
  *o = (unsigned long long)((XKB_STATE_MATCH_NON_EXCLUSIVE) | 0);  /* check that XKB_STATE_MATCH_NON_EXCLUSIVE is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy__log_func_callback =
  { "wlroots._ffi.log_func_callback", 0, 0, 0 };

static void log_func_callback(enum wlr_log_importance a0, char const * a1)
{
  char a[16];
  char *p = a;
  *(enum wlr_log_importance *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__log_func_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__surface_iterator_callback =
  { "wlroots._ffi.surface_iterator_callback", 0, 0, 0 };

static void surface_iterator_callback(struct wlr_surface * a0, int a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(struct wlr_surface * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__surface_iterator_callback, p);
}

static int _cffi_d_clock_gettime(int32_t x0, struct timespec * x1)
{
  return clock_gettime(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_clock_gettime(PyObject *self, PyObject *args)
{
  int32_t x0;
  struct timespec * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "clock_gettime", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int32_t);
  if (x0 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = clock_gettime(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_clock_gettime _cffi_d_clock_gettime
#endif

static void _cffi_d_pixman_region32_fini(struct pixman_region32 * x0)
{
  pixman_region32_fini(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_fini(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pixman_region32_fini(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pixman_region32_fini _cffi_d_pixman_region32_fini
#endif

static void _cffi_d_pixman_region32_init(struct pixman_region32 * x0)
{
  pixman_region32_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_init(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { pixman_region32_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_pixman_region32_init _cffi_d_pixman_region32_init
#endif

static _Bool _cffi_d_pixman_region32_not_empty(struct pixman_region32 * x0)
{
  return pixman_region32_not_empty(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_not_empty(PyObject *self, PyObject *arg0)
{
  struct pixman_region32 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pixman_region32_not_empty(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pixman_region32_not_empty _cffi_d_pixman_region32_not_empty
#endif

static struct pixman_box32 * _cffi_d_pixman_region32_rectangles(struct pixman_region32 * x0, int * x1)
{
  return pixman_region32_rectangles(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_pixman_region32_rectangles(PyObject *self, PyObject *args)
{
  struct pixman_region32 * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct pixman_box32 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "pixman_region32_rectangles", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = pixman_region32_rectangles(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1036));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_pixman_region32_rectangles _cffi_d_pixman_region32_rectangles
#endif

static struct wlr_allocator * _cffi_d_wlr_allocator_autocreate(struct wlr_backend * x0, struct wlr_renderer * x1)
{
  return wlr_allocator_autocreate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_allocator_autocreate(PyObject *self, PyObject *args)
{
  struct wlr_backend * x0;
  struct wlr_renderer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_allocator * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_allocator_autocreate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_allocator_autocreate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(37));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_allocator_autocreate _cffi_d_wlr_allocator_autocreate
#endif

static struct wlr_backend * _cffi_d_wlr_backend_autocreate(struct wl_display * x0)
{
  return wlr_backend_autocreate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_autocreate(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_backend * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_autocreate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_autocreate _cffi_d_wlr_backend_autocreate
#endif

static void _cffi_d_wlr_backend_destroy(struct wlr_backend * x0)
{
  wlr_backend_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_backend_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_backend_destroy _cffi_d_wlr_backend_destroy
#endif

static struct wlr_session * _cffi_d_wlr_backend_get_session(struct wlr_backend * x0)
{
  return wlr_backend_get_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_get_session(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_session * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_get_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(83));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_get_session _cffi_d_wlr_backend_get_session
#endif

static _Bool _cffi_d_wlr_backend_is_headless(struct wlr_backend * x0)
{
  return wlr_backend_is_headless(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_is_headless(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_is_headless(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_is_headless _cffi_d_wlr_backend_is_headless
#endif

static _Bool _cffi_d_wlr_backend_start(struct wlr_backend * x0)
{
  return wlr_backend_start(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_backend_start(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_backend_start(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_backend_start _cffi_d_wlr_backend_start
#endif

static void _cffi_d_wlr_box_closest_point(struct wlr_box const * x0, double x1, double x2, double * x3, double * x4)
{
  wlr_box_closest_point(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_closest_point(PyObject *self, PyObject *args)
{
  struct wlr_box const * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_box_closest_point", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_box_closest_point(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_box_closest_point _cffi_d_wlr_box_closest_point
#endif

static _Bool _cffi_d_wlr_box_contains_point(struct wlr_box const * x0, double x1, double x2)
{
  return wlr_box_contains_point(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_contains_point(PyObject *self, PyObject *args)
{
  struct wlr_box const * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_box_contains_point", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_contains_point(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_contains_point _cffi_d_wlr_box_contains_point
#endif

static _Bool _cffi_d_wlr_box_empty(struct wlr_box const * x0)
{
  return wlr_box_empty(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_empty(PyObject *self, PyObject *arg0)
{
  struct wlr_box const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_empty(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_empty _cffi_d_wlr_box_empty
#endif

static _Bool _cffi_d_wlr_box_intersection(struct wlr_box * x0, struct wlr_box const * x1, struct wlr_box const * x2)
{
  return wlr_box_intersection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_intersection(PyObject *self, PyObject *args)
{
  struct wlr_box * x0;
  struct wlr_box const * x1;
  struct wlr_box const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_box_intersection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_box_intersection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_box_intersection _cffi_d_wlr_box_intersection
#endif

static void _cffi_d_wlr_box_transform(struct wlr_box * x0, struct wlr_box const * x1, enum wl_output_transform x2, int x3, int x4)
{
  wlr_box_transform(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_box_transform(PyObject *self, PyObject *args)
{
  struct wlr_box * x0;
  struct wlr_box const * x1;
  enum wl_output_transform x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_box_transform", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(116), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_box_transform(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_box_transform _cffi_d_wlr_box_transform
#endif

static struct wlr_compositor * _cffi_d_wlr_compositor_create(struct wl_display * x0, struct wlr_renderer * x1)
{
  return wlr_compositor_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_compositor_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_renderer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_compositor * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_compositor_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_compositor_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(363));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_compositor_create _cffi_d_wlr_compositor_create
#endif

static void _cffi_d_wlr_cursor_attach_input_device(struct wlr_cursor * x0, struct wlr_input_device * x1)
{
  wlr_cursor_attach_input_device(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_attach_input_device(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_attach_input_device", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_attach_input_device(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_attach_input_device _cffi_d_wlr_cursor_attach_input_device
#endif

static void _cffi_d_wlr_cursor_attach_output_layout(struct wlr_cursor * x0, struct wlr_output_layout * x1)
{
  wlr_cursor_attach_output_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_attach_output_layout(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_attach_output_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_attach_output_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_attach_output_layout _cffi_d_wlr_cursor_attach_output_layout
#endif

static struct wlr_cursor * _cffi_d_wlr_cursor_create(void)
{
  return wlr_cursor_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_create(PyObject *self, PyObject *noarg)
{
  struct wlr_cursor * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_cursor_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(20));
  return pyresult;
}
#else
#  define _cffi_f_wlr_cursor_create _cffi_d_wlr_cursor_create
#endif

static void _cffi_d_wlr_cursor_destroy(struct wlr_cursor * x0)
{
  wlr_cursor_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_cursor * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_destroy _cffi_d_wlr_cursor_destroy
#endif

static void _cffi_d_wlr_cursor_move(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_move(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_move(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_move", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_move(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_move _cffi_d_wlr_cursor_move
#endif

static void _cffi_d_wlr_cursor_set_surface(struct wlr_cursor * x0, struct wlr_surface * x1, int32_t x2, int32_t x3)
{
  wlr_cursor_set_surface(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_set_surface(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_surface * x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_set_surface", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_set_surface(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_set_surface _cffi_d_wlr_cursor_set_surface
#endif

static _Bool _cffi_d_wlr_cursor_warp(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  return wlr_cursor_warp(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_cursor_warp(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_cursor_warp _cffi_d_wlr_cursor_warp
#endif

static void _cffi_d_wlr_cursor_warp_absolute(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_warp_absolute(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp_absolute(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp_absolute", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_warp_absolute(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_warp_absolute _cffi_d_wlr_cursor_warp_absolute
#endif

static void _cffi_d_wlr_cursor_warp_closest(struct wlr_cursor * x0, struct wlr_input_device * x1, double x2, double x3)
{
  wlr_cursor_warp_closest(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_cursor_warp_closest(PyObject *self, PyObject *args)
{
  struct wlr_cursor * x0;
  struct wlr_input_device * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_cursor_warp_closest", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_cursor_warp_closest(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_cursor_warp_closest _cffi_d_wlr_cursor_warp_closest
#endif

static struct wlr_data_control_manager_v1 * _cffi_d_wlr_data_control_manager_v1_create(struct wl_display * x0)
{
  return wlr_data_control_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_control_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_data_control_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_data_control_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1076));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_data_control_manager_v1_create _cffi_d_wlr_data_control_manager_v1_create
#endif

static struct wlr_data_device_manager * _cffi_d_wlr_data_device_manager_create(struct wl_display * x0)
{
  return wlr_data_device_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_device_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_data_device_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_data_device_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1078));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_data_device_manager_create _cffi_d_wlr_data_device_manager_create
#endif

static void _cffi_d_wlr_data_source_destroy(struct wlr_data_source * x0)
{
  wlr_data_source_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_data_source_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_data_source * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_data_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_data_source_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_data_source_destroy _cffi_d_wlr_data_source_destroy
#endif

static struct wlr_foreign_toplevel_handle_v1 * _cffi_d_wlr_foreign_toplevel_handle_v1_create(struct wlr_foreign_toplevel_manager_v1 * x0)
{
  return wlr_foreign_toplevel_handle_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_create(PyObject *self, PyObject *arg0)
{
  struct wlr_foreign_toplevel_manager_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_foreign_toplevel_handle_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(186), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(186), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_foreign_toplevel_handle_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(527));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_create _cffi_d_wlr_foreign_toplevel_handle_v1_create
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_destroy(struct wlr_foreign_toplevel_handle_v1 * x0)
{
  wlr_foreign_toplevel_handle_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_destroy _cffi_d_wlr_foreign_toplevel_handle_v1_destroy
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_output_enter(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_output * x1)
{
  wlr_foreign_toplevel_handle_v1_output_enter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_output_enter(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_output_enter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_output_enter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_output_enter _cffi_d_wlr_foreign_toplevel_handle_v1_output_enter
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_output_leave(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_output * x1)
{
  wlr_foreign_toplevel_handle_v1_output_leave(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_output_leave(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_output_leave", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_output_leave(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_output_leave _cffi_d_wlr_foreign_toplevel_handle_v1_output_leave
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_activated(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_activated(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_activated(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_activated", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_activated(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_activated _cffi_d_wlr_foreign_toplevel_handle_v1_set_activated
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id(struct wlr_foreign_toplevel_handle_v1 * x0, char const * x1)
{
  wlr_foreign_toplevel_handle_v1_set_app_id(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_app_id", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_app_id(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id _cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen _cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized _cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized(struct wlr_foreign_toplevel_handle_v1 * x0, _Bool x1)
{
  wlr_foreign_toplevel_handle_v1_set_minimized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_minimized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_minimized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized _cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_parent(struct wlr_foreign_toplevel_handle_v1 * x0, struct wlr_foreign_toplevel_handle_v1 * x1)
{
  wlr_foreign_toplevel_handle_v1_set_parent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_parent(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  struct wlr_foreign_toplevel_handle_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_parent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_parent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_parent _cffi_d_wlr_foreign_toplevel_handle_v1_set_parent
#endif

static void _cffi_d_wlr_foreign_toplevel_handle_v1_set_title(struct wlr_foreign_toplevel_handle_v1 * x0, char const * x1)
{
  wlr_foreign_toplevel_handle_v1_set_title(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_handle_v1_set_title(PyObject *self, PyObject *args)
{
  struct wlr_foreign_toplevel_handle_v1 * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_foreign_toplevel_handle_v1_set_title", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(527), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_foreign_toplevel_handle_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(527), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_foreign_toplevel_handle_v1_set_title(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_handle_v1_set_title _cffi_d_wlr_foreign_toplevel_handle_v1_set_title
#endif

static struct wlr_foreign_toplevel_manager_v1 * _cffi_d_wlr_foreign_toplevel_manager_v1_create(struct wl_display * x0)
{
  return wlr_foreign_toplevel_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_foreign_toplevel_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_foreign_toplevel_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_foreign_toplevel_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(186));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_foreign_toplevel_manager_v1_create _cffi_d_wlr_foreign_toplevel_manager_v1_create
#endif

static struct wlr_gamma_control_manager_v1 * _cffi_d_wlr_gamma_control_manager_v1_create(struct wl_display * x0)
{
  return wlr_gamma_control_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_gamma_control_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_gamma_control_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_gamma_control_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1107));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_gamma_control_manager_v1_create _cffi_d_wlr_gamma_control_manager_v1_create
#endif

static struct wlr_input_device * _cffi_d_wlr_headless_add_input_device(struct wlr_backend * x0, enum wlr_input_device_type x1)
{
  return wlr_headless_add_input_device(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_headless_add_input_device(PyObject *self, PyObject *args)
{
  struct wlr_backend * x0;
  enum wlr_input_device_type x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_input_device * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_headless_add_input_device", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(207), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_headless_add_input_device(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(21));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_headless_add_input_device _cffi_d_wlr_headless_add_input_device
#endif

static struct wlr_output * _cffi_d_wlr_headless_add_output(struct wlr_backend * x0, unsigned int x1, unsigned int x2)
{
  return wlr_headless_add_output(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_headless_add_output(PyObject *self, PyObject *args)
{
  struct wlr_backend * x0;
  unsigned int x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_headless_add_output", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_headless_add_output(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_headless_add_output _cffi_d_wlr_headless_add_output
#endif

static struct wlr_backend * _cffi_d_wlr_headless_backend_create(struct wl_display * x0)
{
  return wlr_headless_backend_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_headless_backend_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_backend * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_headless_backend_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_headless_backend_create _cffi_d_wlr_headless_backend_create
#endif

static struct wlr_idle * _cffi_d_wlr_idle_create(struct wl_display * x0)
{
  return wlr_idle_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_idle * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_idle_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(201));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_idle_create _cffi_d_wlr_idle_create
#endif

static struct wlr_idle_inhibit_manager_v1 * _cffi_d_wlr_idle_inhibit_v1_create(struct wl_display * x0)
{
  return wlr_idle_inhibit_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_inhibit_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_idle_inhibit_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_idle_inhibit_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1110));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_idle_inhibit_v1_create _cffi_d_wlr_idle_inhibit_v1_create
#endif

static void _cffi_d_wlr_idle_notify_activity(struct wlr_idle * x0, struct wlr_seat * x1)
{
  wlr_idle_notify_activity(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_notify_activity(PyObject *self, PyObject *args)
{
  struct wlr_idle * x0;
  struct wlr_seat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_idle_notify_activity", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_idle_notify_activity(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_idle_notify_activity _cffi_d_wlr_idle_notify_activity
#endif

static void _cffi_d_wlr_idle_set_enabled(struct wlr_idle * x0, struct wlr_seat * x1, _Bool x2)
{
  wlr_idle_set_enabled(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_set_enabled(PyObject *self, PyObject *args)
{
  struct wlr_idle * x0;
  struct wlr_seat * x1;
  _Bool x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_idle_set_enabled", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (_Bool)_cffi_to_c__Bool(arg2);
  if (x2 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_idle_set_enabled(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_idle_set_enabled _cffi_d_wlr_idle_set_enabled
#endif

static struct wlr_idle_timeout * _cffi_d_wlr_idle_timeout_create(struct wlr_idle * x0, struct wlr_seat * x1, uint32_t x2)
{
  return wlr_idle_timeout_create(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_timeout_create(PyObject *self, PyObject *args)
{
  struct wlr_idle * x0;
  struct wlr_seat * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_idle_timeout * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_idle_timeout_create", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(201), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(201), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_idle_timeout_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(555));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_idle_timeout_create _cffi_d_wlr_idle_timeout_create
#endif

static void _cffi_d_wlr_idle_timeout_destroy(struct wlr_idle_timeout * x0)
{
  wlr_idle_timeout_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_idle_timeout_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_idle_timeout * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(555), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_idle_timeout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(555), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_idle_timeout_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_idle_timeout_destroy _cffi_d_wlr_idle_timeout_destroy
#endif

static _Bool _cffi_d_wlr_input_device_is_headless(struct wlr_input_device * x0)
{
  return wlr_input_device_is_headless(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_device_is_headless(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_device_is_headless(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_device_is_headless _cffi_d_wlr_input_device_is_headless
#endif

static _Bool _cffi_d_wlr_input_device_is_libinput(struct wlr_input_device * x0)
{
  return wlr_input_device_is_libinput(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_device_is_libinput(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_device_is_libinput(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_device_is_libinput _cffi_d_wlr_input_device_is_libinput
#endif

static struct wlr_input_inhibit_manager * _cffi_d_wlr_input_inhibit_manager_create(struct wl_display * x0)
{
  return wlr_input_inhibit_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_input_inhibit_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_input_inhibit_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_input_inhibit_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1117));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_input_inhibit_manager_create _cffi_d_wlr_input_inhibit_manager_create
#endif

static uint32_t _cffi_d_wlr_keyboard_get_modifiers(struct wlr_keyboard * x0)
{
  return wlr_keyboard_get_modifiers(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_get_modifiers(PyObject *self, PyObject *arg0)
{
  struct wlr_keyboard * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_keyboard_get_modifiers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_keyboard_get_modifiers _cffi_d_wlr_keyboard_get_modifiers
#endif

static void _cffi_d_wlr_keyboard_set_keymap(struct wlr_keyboard * x0, struct xkb_keymap * x1)
{
  wlr_keyboard_set_keymap(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_set_keymap(PyObject *self, PyObject *args)
{
  struct wlr_keyboard * x0;
  struct xkb_keymap * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_keyboard_set_keymap", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(564), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct xkb_keymap *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(564), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_keyboard_set_keymap(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_keyboard_set_keymap _cffi_d_wlr_keyboard_set_keymap
#endif

static void _cffi_d_wlr_keyboard_set_repeat_info(struct wlr_keyboard * x0, int32_t x1, int32_t x2)
{
  wlr_keyboard_set_repeat_info(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_keyboard_set_repeat_info(PyObject *self, PyObject *args)
{
  struct wlr_keyboard * x0;
  int32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_keyboard_set_repeat_info", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(378), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(378), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_keyboard_set_repeat_info(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_keyboard_set_repeat_info _cffi_d_wlr_keyboard_set_repeat_info
#endif

static struct wlr_layer_shell_v1 * _cffi_d_wlr_layer_shell_v1_create(struct wl_display * x0)
{
  return wlr_layer_shell_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_shell_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_layer_shell_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_shell_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1127));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_shell_v1_create _cffi_d_wlr_layer_shell_v1_create
#endif

static void _cffi_d_wlr_layer_surface_v1_configure(struct wlr_layer_surface_v1 * x0, uint32_t x1, uint32_t x2)
{
  wlr_layer_surface_v1_configure(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_configure(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_configure", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(302), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(302), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_configure(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_configure _cffi_d_wlr_layer_surface_v1_configure
#endif

static void _cffi_d_wlr_layer_surface_v1_destroy(struct wlr_layer_surface_v1 * x0)
{
  wlr_layer_surface_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_layer_surface_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(302), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(302), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_destroy _cffi_d_wlr_layer_surface_v1_destroy
#endif

static void _cffi_d_wlr_layer_surface_v1_for_each_surface(struct wlr_layer_surface_v1 * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_layer_surface_v1_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(302), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(302), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(576));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_layer_surface_v1_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_for_each_surface _cffi_d_wlr_layer_surface_v1_for_each_surface
#endif

static struct wlr_layer_surface_v1 * _cffi_d_wlr_layer_surface_v1_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_layer_surface_v1_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_layer_surface_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_surface_v1_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(302));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_from_wlr_surface _cffi_d_wlr_layer_surface_v1_from_wlr_surface
#endif

static struct wlr_surface * _cffi_d_wlr_layer_surface_v1_surface_at(struct wlr_layer_surface_v1 * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_layer_surface_v1_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_layer_surface_v1_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_layer_surface_v1 * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_layer_surface_v1_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(302), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_layer_surface_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(302), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_layer_surface_v1_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_layer_surface_v1_surface_at _cffi_d_wlr_layer_surface_v1_surface_at
#endif

static struct libinput_device * _cffi_d_wlr_libinput_get_device_handle(struct wlr_input_device * x0)
{
  return wlr_libinput_get_device_handle(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_libinput_get_device_handle(PyObject *self, PyObject *arg0)
{
  struct wlr_input_device * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct libinput_device * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_libinput_get_device_handle(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1034));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_libinput_get_device_handle _cffi_d_wlr_libinput_get_device_handle
#endif

static struct wlr_linux_dmabuf_v1 * _cffi_d_wlr_linux_dmabuf_v1_create(struct wl_display * x0, struct wlr_renderer * x1)
{
  return wlr_linux_dmabuf_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_linux_dmabuf_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_renderer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_linux_dmabuf_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_linux_dmabuf_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_linux_dmabuf_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1131));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_linux_dmabuf_v1_create _cffi_d_wlr_linux_dmabuf_v1_create
#endif

static void _cffi_d_wlr_matrix_identity(float * x0)
{
  wlr_matrix_identity(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_identity(PyObject *self, PyObject *arg0)
{
  float * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_identity(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_identity _cffi_d_wlr_matrix_identity
#endif

static void _cffi_d_wlr_matrix_multiply(float * x0, float const * x1, float const * x2)
{
  wlr_matrix_multiply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_multiply(PyObject *self, PyObject *args)
{
  float * x0;
  float const * x1;
  float const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_multiply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_multiply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_multiply _cffi_d_wlr_matrix_multiply
#endif

static void _cffi_d_wlr_matrix_project_box(float * x0, struct wlr_box const * x1, enum wl_output_transform x2, float x3, float const * x4)
{
  wlr_matrix_project_box(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_project_box(PyObject *self, PyObject *args)
{
  float * x0;
  struct wlr_box const * x1;
  enum wl_output_transform x2;
  float x3;
  float const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_project_box", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(116), arg2) < 0)
    return NULL;

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_project_box(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_project_box _cffi_d_wlr_matrix_project_box
#endif

static void _cffi_d_wlr_matrix_projection(float * x0, int x1, int x2, enum wl_output_transform x3)
{
  wlr_matrix_projection(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_projection(PyObject *self, PyObject *args)
{
  float * x0;
  int x1;
  int x2;
  enum wl_output_transform x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_projection", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(116), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_projection(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_projection _cffi_d_wlr_matrix_projection
#endif

static void _cffi_d_wlr_matrix_rotate(float * x0, float x1)
{
  wlr_matrix_rotate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_rotate(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_rotate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_rotate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_rotate _cffi_d_wlr_matrix_rotate
#endif

static void _cffi_d_wlr_matrix_scale(float * x0, float x1, float x2)
{
  wlr_matrix_scale(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_scale(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_scale", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_scale(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_scale _cffi_d_wlr_matrix_scale
#endif

static void _cffi_d_wlr_matrix_transform(float * x0, enum wl_output_transform x1)
{
  wlr_matrix_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_transform(PyObject *self, PyObject *args)
{
  float * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(116), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_transform _cffi_d_wlr_matrix_transform
#endif

static void _cffi_d_wlr_matrix_translate(float * x0, float x1, float x2)
{
  wlr_matrix_translate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_translate(PyObject *self, PyObject *args)
{
  float * x0;
  float x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_translate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_translate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_translate _cffi_d_wlr_matrix_translate
#endif

static void _cffi_d_wlr_matrix_transpose(float * x0, float const * x1)
{
  wlr_matrix_transpose(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_matrix_transpose(PyObject *self, PyObject *args)
{
  float * x0;
  float const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_matrix_transpose", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(423), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (float *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(423), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_matrix_transpose(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_matrix_transpose _cffi_d_wlr_matrix_transpose
#endif

static _Bool _cffi_d_wlr_output_attach_render(struct wlr_output * x0, int * x1)
{
  return wlr_output_attach_render(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_attach_render(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_attach_render", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_attach_render(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_attach_render _cffi_d_wlr_output_attach_render
#endif

static _Bool _cffi_d_wlr_output_commit(struct wlr_output * x0)
{
  return wlr_output_commit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_commit(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_commit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_commit _cffi_d_wlr_output_commit
#endif

static struct wlr_output_configuration_head_v1 * _cffi_d_wlr_output_configuration_head_v1_create(struct wlr_output_configuration_v1 * x0, struct wlr_output * x1)
{
  return wlr_output_configuration_head_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_head_v1_create(PyObject *self, PyObject *args)
{
  struct wlr_output_configuration_v1 * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_configuration_head_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_configuration_head_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(236), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(236), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_configuration_head_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1134));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_configuration_head_v1_create _cffi_d_wlr_output_configuration_head_v1_create
#endif

static struct wlr_output_configuration_v1 * _cffi_d_wlr_output_configuration_v1_create(void)
{
  return wlr_output_configuration_v1_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_create(PyObject *self, PyObject *noarg)
{
  struct wlr_output_configuration_v1 * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_configuration_v1_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(236));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_create _cffi_d_wlr_output_configuration_v1_create
#endif

static void _cffi_d_wlr_output_configuration_v1_destroy(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(236), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(236), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_destroy _cffi_d_wlr_output_configuration_v1_destroy
#endif

static void _cffi_d_wlr_output_configuration_v1_send_failed(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_send_failed(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_send_failed(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(236), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(236), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_send_failed(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_send_failed _cffi_d_wlr_output_configuration_v1_send_failed
#endif

static void _cffi_d_wlr_output_configuration_v1_send_succeeded(struct wlr_output_configuration_v1 * x0)
{
  wlr_output_configuration_v1_send_succeeded(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_configuration_v1_send_succeeded(PyObject *self, PyObject *arg0)
{
  struct wlr_output_configuration_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(236), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(236), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_configuration_v1_send_succeeded(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_configuration_v1_send_succeeded _cffi_d_wlr_output_configuration_v1_send_succeeded
#endif

static void _cffi_d_wlr_output_create_global(struct wlr_output * x0)
{
  wlr_output_create_global(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_create_global(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_create_global(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_create_global _cffi_d_wlr_output_create_global
#endif

static void _cffi_d_wlr_output_damage_add(struct wlr_output_damage * x0, struct pixman_region32 * x1)
{
  wlr_output_damage_add(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_add(PyObject *self, PyObject *args)
{
  struct wlr_output_damage * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_damage_add", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_damage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_damage_add(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_damage_add _cffi_d_wlr_output_damage_add
#endif

static void _cffi_d_wlr_output_damage_add_box(struct wlr_output_damage * x0, struct wlr_box * x1)
{
  wlr_output_damage_add_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_add_box(PyObject *self, PyObject *args)
{
  struct wlr_output_damage * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_damage_add_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_damage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_damage_add_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_damage_add_box _cffi_d_wlr_output_damage_add_box
#endif

static void _cffi_d_wlr_output_damage_add_whole(struct wlr_output_damage * x0)
{
  wlr_output_damage_add_whole(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_add_whole(PyObject *self, PyObject *arg0)
{
  struct wlr_output_damage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_damage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_damage_add_whole(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_damage_add_whole _cffi_d_wlr_output_damage_add_whole
#endif

static _Bool _cffi_d_wlr_output_damage_attach_render(struct wlr_output_damage * x0, _Bool * x1, struct pixman_region32 * x2)
{
  return wlr_output_damage_attach_render(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_attach_render(PyObject *self, PyObject *args)
{
  struct wlr_output_damage * x0;
  _Bool * x1;
  struct pixman_region32 * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_damage_attach_render", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_damage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(42), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (_Bool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(42), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_damage_attach_render(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_damage_attach_render _cffi_d_wlr_output_damage_attach_render
#endif

static struct wlr_output_damage * _cffi_d_wlr_output_damage_create(struct wlr_output * x0)
{
  return wlr_output_damage_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_create(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_damage * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_damage_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(41));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_damage_create _cffi_d_wlr_output_damage_create
#endif

static void _cffi_d_wlr_output_damage_destroy(struct wlr_output_damage * x0)
{
  wlr_output_damage_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_damage_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_output_damage * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_damage *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_damage_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_damage_destroy _cffi_d_wlr_output_damage_destroy
#endif

static void _cffi_d_wlr_output_destroy_global(struct wlr_output * x0)
{
  wlr_output_destroy_global(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_destroy_global(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_destroy_global(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_destroy_global _cffi_d_wlr_output_destroy_global
#endif

static void _cffi_d_wlr_output_effective_resolution(struct wlr_output * x0, int * x1, int * x2)
{
  wlr_output_effective_resolution(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_effective_resolution(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_effective_resolution", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_effective_resolution(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_effective_resolution _cffi_d_wlr_output_effective_resolution
#endif

static void _cffi_d_wlr_output_enable(struct wlr_output * x0, _Bool x1)
{
  wlr_output_enable(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_enable(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_enable", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_enable(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_enable _cffi_d_wlr_output_enable
#endif

static _Bool _cffi_d_wlr_output_init_render(struct wlr_output * x0, struct wlr_allocator * x1, struct wlr_renderer * x2)
{
  return wlr_output_init_render(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_init_render(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_allocator * x1;
  struct wlr_renderer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_init_render", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_allocator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_init_render(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_init_render _cffi_d_wlr_output_init_render
#endif

static _Bool _cffi_d_wlr_output_is_headless(struct wlr_output * x0)
{
  return wlr_output_is_headless(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_is_headless(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_is_headless(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_is_headless _cffi_d_wlr_output_is_headless
#endif

static void _cffi_d_wlr_output_layout_add(struct wlr_output_layout * x0, struct wlr_output * x1, int x2, int x3)
{
  wlr_output_layout_add(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_add(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_add", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_add(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_add _cffi_d_wlr_output_layout_add
#endif

static void _cffi_d_wlr_output_layout_add_auto(struct wlr_output_layout * x0, struct wlr_output * x1)
{
  wlr_output_layout_add_auto(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_add_auto(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_add_auto", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_add_auto(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_add_auto _cffi_d_wlr_output_layout_add_auto
#endif

static void _cffi_d_wlr_output_layout_closest_point(struct wlr_output_layout * x0, struct wlr_output * x1, double x2, double x3, double * x4, double * x5)
{
  wlr_output_layout_closest_point(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_closest_point(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  double x2;
  double x3;
  double * x4;
  double * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_closest_point", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_closest_point(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_closest_point _cffi_d_wlr_output_layout_closest_point
#endif

static struct wlr_output_layout * _cffi_d_wlr_output_layout_create(void)
{
  return wlr_output_layout_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_create(PyObject *self, PyObject *noarg)
{
  struct wlr_output_layout * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(65));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_create _cffi_d_wlr_output_layout_create
#endif

static void _cffi_d_wlr_output_layout_destroy(struct wlr_output_layout * x0)
{
  wlr_output_layout_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_output_layout * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_destroy _cffi_d_wlr_output_layout_destroy
#endif

static struct wlr_box * _cffi_d_wlr_output_layout_get_box(struct wlr_output_layout * x0, struct wlr_output * x1)
{
  return wlr_output_layout_get_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_get_box(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_box * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_get_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_get_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(7));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_get_box _cffi_d_wlr_output_layout_get_box
#endif

static void _cffi_d_wlr_output_layout_move(struct wlr_output_layout * x0, struct wlr_output * x1, int x2, int x3)
{
  wlr_output_layout_move(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_move(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_move", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_move(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_move _cffi_d_wlr_output_layout_move
#endif

static struct wlr_output * _cffi_d_wlr_output_layout_output_at(struct wlr_output_layout * x0, double x1, double x2)
{
  return wlr_output_layout_output_at(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_output_at(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_output_at", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_layout_output_at(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(29));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_layout_output_at _cffi_d_wlr_output_layout_output_at
#endif

static void _cffi_d_wlr_output_layout_output_coords(struct wlr_output_layout * x0, struct wlr_output * x1, double * x2, double * x3)
{
  wlr_output_layout_output_coords(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_output_coords(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  double * x2;
  double * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_output_coords", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_output_coords(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_output_coords _cffi_d_wlr_output_layout_output_coords
#endif

static void _cffi_d_wlr_output_layout_remove(struct wlr_output_layout * x0, struct wlr_output * x1)
{
  wlr_output_layout_remove(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_layout_remove(PyObject *self, PyObject *args)
{
  struct wlr_output_layout * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_layout_remove", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_layout_remove(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_layout_remove _cffi_d_wlr_output_layout_remove
#endif

static struct wlr_output_manager_v1 * _cffi_d_wlr_output_manager_v1_create(struct wl_display * x0)
{
  return wlr_output_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(655));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_manager_v1_create _cffi_d_wlr_output_manager_v1_create
#endif

static void _cffi_d_wlr_output_manager_v1_set_configuration(struct wlr_output_manager_v1 * x0, struct wlr_output_configuration_v1 * x1)
{
  wlr_output_manager_v1_set_configuration(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_manager_v1_set_configuration(PyObject *self, PyObject *args)
{
  struct wlr_output_manager_v1 * x0;
  struct wlr_output_configuration_v1 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_manager_v1_set_configuration", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(655), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(655), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(236), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_configuration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(236), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_manager_v1_set_configuration(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_manager_v1_set_configuration _cffi_d_wlr_output_manager_v1_set_configuration
#endif

static struct wlr_output_power_manager_v1 * _cffi_d_wlr_output_power_manager_v1_create(struct wl_display * x0)
{
  return wlr_output_power_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_power_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_power_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_power_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1148));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_power_manager_v1_create _cffi_d_wlr_output_power_manager_v1_create
#endif

static struct wlr_output_mode * _cffi_d_wlr_output_preferred_mode(struct wlr_output * x0)
{
  return wlr_output_preferred_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_preferred_mode(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_output_mode * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_preferred_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(611));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_preferred_mode _cffi_d_wlr_output_preferred_mode
#endif

static void _cffi_d_wlr_output_render_software_cursors(struct wlr_output * x0, struct pixman_region32 * x1)
{
  wlr_output_render_software_cursors(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_render_software_cursors(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_render_software_cursors", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_render_software_cursors(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_render_software_cursors _cffi_d_wlr_output_render_software_cursors
#endif

static void _cffi_d_wlr_output_rollback(struct wlr_output * x0)
{
  wlr_output_rollback(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_rollback(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_rollback(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_rollback _cffi_d_wlr_output_rollback
#endif

static void _cffi_d_wlr_output_set_custom_mode(struct wlr_output * x0, int32_t x1, int32_t x2, int32_t x3)
{
  wlr_output_set_custom_mode(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_custom_mode(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int32_t x1;
  int32_t x2;
  int32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_custom_mode", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int32_t);
  if (x1 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_custom_mode(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_custom_mode _cffi_d_wlr_output_set_custom_mode
#endif

static void _cffi_d_wlr_output_set_damage(struct wlr_output * x0, struct pixman_region32 * x1)
{
  wlr_output_set_damage(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_damage(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_damage", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_damage(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_damage _cffi_d_wlr_output_set_damage
#endif

static void _cffi_d_wlr_output_set_mode(struct wlr_output * x0, struct wlr_output_mode * x1)
{
  wlr_output_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_mode(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  struct wlr_output_mode * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(611), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_mode *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(611), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_mode _cffi_d_wlr_output_set_mode
#endif

static void _cffi_d_wlr_output_set_scale(struct wlr_output * x0, float x1)
{
  wlr_output_set_scale(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_scale(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_scale", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_scale(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_scale _cffi_d_wlr_output_set_scale
#endif

static void _cffi_d_wlr_output_set_transform(struct wlr_output * x0, enum wl_output_transform x1)
{
  wlr_output_set_transform(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_set_transform(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  enum wl_output_transform x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_output_set_transform", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(116), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_set_transform(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_set_transform _cffi_d_wlr_output_set_transform
#endif

static _Bool _cffi_d_wlr_output_test(struct wlr_output * x0)
{
  return wlr_output_test(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_test(PyObject *self, PyObject *arg0)
{
  struct wlr_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_test(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_test _cffi_d_wlr_output_test
#endif

static enum wl_output_transform _cffi_d_wlr_output_transform_invert(enum wl_output_transform x0)
{
  return wlr_output_transform_invert(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_transform_invert(PyObject *self, PyObject *arg0)
{
  enum wl_output_transform x0;
  enum wl_output_transform result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(116), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_output_transform_invert(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(116));
  return pyresult;
}
#else
#  define _cffi_f_wlr_output_transform_invert _cffi_d_wlr_output_transform_invert
#endif

static void _cffi_d_wlr_output_transformed_resolution(struct wlr_output * x0, int * x1, int * x2)
{
  wlr_output_transformed_resolution(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_output_transformed_resolution(PyObject *self, PyObject *args)
{
  struct wlr_output * x0;
  int * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_output_transformed_resolution", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_output_transformed_resolution(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_output_transformed_resolution _cffi_d_wlr_output_transformed_resolution
#endif

static void _cffi_d_wlr_pointer_constraint_v1_send_activated(struct wlr_pointer_constraint_v1 * x0)
{
  wlr_pointer_constraint_v1_send_activated(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraint_v1_send_activated(PyObject *self, PyObject *arg0)
{
  struct wlr_pointer_constraint_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(659), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraint_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(659), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_constraint_v1_send_activated(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_constraint_v1_send_activated _cffi_d_wlr_pointer_constraint_v1_send_activated
#endif

static void _cffi_d_wlr_pointer_constraint_v1_send_deactivated(struct wlr_pointer_constraint_v1 * x0)
{
  wlr_pointer_constraint_v1_send_deactivated(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraint_v1_send_deactivated(PyObject *self, PyObject *arg0)
{
  struct wlr_pointer_constraint_v1 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(659), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraint_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(659), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_pointer_constraint_v1_send_deactivated(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_pointer_constraint_v1_send_deactivated _cffi_d_wlr_pointer_constraint_v1_send_deactivated
#endif

static struct wlr_pointer_constraint_v1 * _cffi_d_wlr_pointer_constraints_v1_constraint_for_surface(struct wlr_pointer_constraints_v1 * x0, struct wlr_surface * x1, struct wlr_seat * x2)
{
  return wlr_pointer_constraints_v1_constraint_for_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraints_v1_constraint_for_surface(PyObject *self, PyObject *args)
{
  struct wlr_pointer_constraints_v1 * x0;
  struct wlr_surface * x1;
  struct wlr_seat * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer_constraint_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_pointer_constraints_v1_constraint_for_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(256), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_pointer_constraints_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(256), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_constraints_v1_constraint_for_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(659));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_constraints_v1_constraint_for_surface _cffi_d_wlr_pointer_constraints_v1_constraint_for_surface
#endif

static struct wlr_pointer_constraints_v1 * _cffi_d_wlr_pointer_constraints_v1_create(struct wl_display * x0)
{
  return wlr_pointer_constraints_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_pointer_constraints_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_pointer_constraints_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_pointer_constraints_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(256));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_pointer_constraints_v1_create _cffi_d_wlr_pointer_constraints_v1_create
#endif

static struct wlr_primary_selection_v1_device_manager * _cffi_d_wlr_primary_selection_v1_device_manager_create(struct wl_display * x0)
{
  return wlr_primary_selection_v1_device_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_primary_selection_v1_device_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_primary_selection_v1_device_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_primary_selection_v1_device_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1163));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_primary_selection_v1_device_manager_create _cffi_d_wlr_primary_selection_v1_device_manager_create
#endif

static void _cffi_d_wlr_region_transform(struct pixman_region32 * x0, struct pixman_region32 * x1, enum wl_output_transform x2, int x3, int x4)
{
  wlr_region_transform(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_region_transform(PyObject *self, PyObject *args)
{
  struct pixman_region32 * x0;
  struct pixman_region32 * x1;
  enum wl_output_transform x2;
  int x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_region_transform", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(116), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_region_transform(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_region_transform _cffi_d_wlr_region_transform
#endif

static struct wlr_relative_pointer_manager_v1 * _cffi_d_wlr_relative_pointer_manager_v1_create(struct wl_display * x0)
{
  return wlr_relative_pointer_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_relative_pointer_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_relative_pointer_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_relative_pointer_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(662));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_relative_pointer_manager_v1_create _cffi_d_wlr_relative_pointer_manager_v1_create
#endif

static void _cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion(struct wlr_relative_pointer_manager_v1 * x0, struct wlr_seat * x1, uint64_t x2, double x3, double x4, double x5, double x6)
{
  wlr_relative_pointer_manager_v1_send_relative_motion(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion(PyObject *self, PyObject *args)
{
  struct wlr_relative_pointer_manager_v1 * x0;
  struct wlr_seat * x1;
  uint64_t x2;
  double x3;
  double x4;
  double x5;
  double x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "wlr_relative_pointer_manager_v1_send_relative_motion", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(662), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_relative_pointer_manager_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(662), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint64_t);
  if (x2 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  x6 = (double)_cffi_to_c_double(arg6);
  if (x6 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_relative_pointer_manager_v1_send_relative_motion(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion _cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion
#endif

static void _cffi_d_wlr_render_rect(struct wlr_renderer * x0, struct wlr_box const * x1, float const * x2, float const * x3)
{
  wlr_render_rect(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_rect(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_box const * x1;
  float const * x2;
  float const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_render_rect", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_render_rect(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_render_rect _cffi_d_wlr_render_rect
#endif

static _Bool _cffi_d_wlr_render_texture(struct wlr_renderer * x0, struct wlr_texture * x1, float const * x2, int x3, int x4, float x5)
{
  return wlr_render_texture(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_texture(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_texture * x1;
  float const * x2;
  int x3;
  int x4;
  float x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_render_texture", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (float)_cffi_to_c_float(arg5);
  if (x5 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_render_texture(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_render_texture _cffi_d_wlr_render_texture
#endif

static _Bool _cffi_d_wlr_render_texture_with_matrix(struct wlr_renderer * x0, struct wlr_texture * x1, float const * x2, float x3)
{
  return wlr_render_texture_with_matrix(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_render_texture_with_matrix(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_texture * x1;
  float const * x2;
  float x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_render_texture_with_matrix", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (float)_cffi_to_c_float(arg3);
  if (x3 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_render_texture_with_matrix(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_render_texture_with_matrix _cffi_d_wlr_render_texture_with_matrix
#endif

static struct wlr_renderer * _cffi_d_wlr_renderer_autocreate(struct wlr_backend * x0)
{
  return wlr_renderer_autocreate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_autocreate(PyObject *self, PyObject *arg0)
{
  struct wlr_backend * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_renderer * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_backend *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_autocreate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(38));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_autocreate _cffi_d_wlr_renderer_autocreate
#endif

static void _cffi_d_wlr_renderer_begin(struct wlr_renderer * x0, int x1, int x2)
{
  wlr_renderer_begin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_begin(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_begin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_begin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_begin _cffi_d_wlr_renderer_begin
#endif

static void _cffi_d_wlr_renderer_clear(struct wlr_renderer * x0, float const * x1)
{
  wlr_renderer_clear(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_clear(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  float const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_clear", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (float const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_clear(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_clear _cffi_d_wlr_renderer_clear
#endif

static void _cffi_d_wlr_renderer_destroy(struct wlr_renderer * x0)
{
  wlr_renderer_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_renderer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_destroy _cffi_d_wlr_renderer_destroy
#endif

static void _cffi_d_wlr_renderer_end(struct wlr_renderer * x0)
{
  wlr_renderer_end(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_end(PyObject *self, PyObject *arg0)
{
  struct wlr_renderer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_end(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_end _cffi_d_wlr_renderer_end
#endif

static uint32_t const * _cffi_d_wlr_renderer_get_shm_texture_formats(struct wlr_renderer * x0, size_t * x1)
{
  return wlr_renderer_get_shm_texture_formats(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_get_shm_texture_formats(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  size_t * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_get_shm_texture_formats", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(375), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(375), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_get_shm_texture_formats(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1270));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_get_shm_texture_formats _cffi_d_wlr_renderer_get_shm_texture_formats
#endif

static _Bool _cffi_d_wlr_renderer_init_wl_display(struct wlr_renderer * x0, struct wl_display * x1)
{
  return wlr_renderer_init_wl_display(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_init_wl_display(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wl_display * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_init_wl_display", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_renderer_init_wl_display(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_renderer_init_wl_display _cffi_d_wlr_renderer_init_wl_display
#endif

static void _cffi_d_wlr_renderer_scissor(struct wlr_renderer * x0, struct wlr_box * x1)
{
  wlr_renderer_scissor(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_renderer_scissor(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_renderer_scissor", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_renderer_scissor(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_renderer_scissor _cffi_d_wlr_renderer_scissor
#endif

static _Bool _cffi_d_wlr_scene_attach_output_layout(struct wlr_scene * x0, struct wlr_output_layout * x1)
{
  return wlr_scene_attach_output_layout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_attach_output_layout(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_attach_output_layout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(64), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(64), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_attach_output_layout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_attach_output_layout _cffi_d_wlr_scene_attach_output_layout
#endif

static struct wlr_scene * _cffi_d_wlr_scene_create(void)
{
  return wlr_scene_create();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_create(PyObject *self, PyObject *noarg)
{
  struct wlr_scene * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_create(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(64));
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_create _cffi_d_wlr_scene_create
#endif

static struct wlr_scene_output * _cffi_d_wlr_scene_get_scene_output(struct wlr_scene * x0, struct wlr_output * x1)
{
  return wlr_scene_get_scene_output(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_get_scene_output(PyObject *self, PyObject *args)
{
  struct wlr_scene * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_output * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_get_scene_output", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(64), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(64), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_get_scene_output(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(68));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_get_scene_output _cffi_d_wlr_scene_get_scene_output
#endif

static void _cffi_d_wlr_scene_node_lower_to_bottom(struct wlr_scene_node * x0)
{
  wlr_scene_node_lower_to_bottom(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_lower_to_bottom(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_lower_to_bottom(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_lower_to_bottom _cffi_d_wlr_scene_node_lower_to_bottom
#endif

static void _cffi_d_wlr_scene_node_place_above(struct wlr_scene_node * x0, struct wlr_scene_node * x1)
{
  wlr_scene_node_place_above(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_place_above(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_scene_node * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_place_above", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_place_above(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_place_above _cffi_d_wlr_scene_node_place_above
#endif

static void _cffi_d_wlr_scene_node_place_below(struct wlr_scene_node * x0, struct wlr_scene_node * x1)
{
  wlr_scene_node_place_below(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_place_below(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_scene_node * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_place_below", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_place_below(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_place_below _cffi_d_wlr_scene_node_place_below
#endif

static void _cffi_d_wlr_scene_node_raise_to_top(struct wlr_scene_node * x0)
{
  wlr_scene_node_raise_to_top(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_raise_to_top(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_node * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_raise_to_top(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_raise_to_top _cffi_d_wlr_scene_node_raise_to_top
#endif

static void _cffi_d_wlr_scene_node_set_position(struct wlr_scene_node * x0, int x1, int x2)
{
  wlr_scene_node_set_position(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_node_set_position(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_scene_node_set_position", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_node_set_position(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_node_set_position _cffi_d_wlr_scene_node_set_position
#endif

static _Bool _cffi_d_wlr_scene_output_commit(struct wlr_scene_output * x0)
{
  return wlr_scene_output_commit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_commit(PyObject *self, PyObject *arg0)
{
  struct wlr_scene_output * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_output_commit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_output_commit _cffi_d_wlr_scene_output_commit
#endif

static void _cffi_d_wlr_scene_output_send_frame_done(struct wlr_scene_output * x0, struct timespec * x1)
{
  wlr_scene_output_send_frame_done(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_output_send_frame_done(PyObject *self, PyObject *args)
{
  struct wlr_scene_output * x0;
  struct timespec * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_output_send_frame_done", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(68), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(68), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(132), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_scene_output_send_frame_done(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_scene_output_send_frame_done _cffi_d_wlr_scene_output_send_frame_done
#endif

static struct wlr_scene_node * _cffi_d_wlr_scene_xdg_surface_create(struct wlr_scene_node * x0, struct wlr_xdg_surface * x1)
{
  return wlr_scene_xdg_surface_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_scene_xdg_surface_create(PyObject *self, PyObject *args)
{
  struct wlr_scene_node * x0;
  struct wlr_xdg_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_scene_node * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_scene_xdg_surface_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(275), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_scene_node *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(275), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_scene_xdg_surface_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(275));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_scene_xdg_surface_create _cffi_d_wlr_scene_xdg_surface_create
#endif

static struct wlr_screencopy_manager_v1 * _cffi_d_wlr_screencopy_manager_v1_create(struct wl_display * x0)
{
  return wlr_screencopy_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_screencopy_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_screencopy_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_screencopy_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1172));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_screencopy_manager_v1_create _cffi_d_wlr_screencopy_manager_v1_create
#endif

static struct wlr_seat * _cffi_d_wlr_seat_create(struct wl_display * x0, char const * x1)
{
  return wlr_seat_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_seat * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(71));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_create _cffi_d_wlr_seat_create
#endif

static void _cffi_d_wlr_seat_destroy(struct wlr_seat * x0)
{
  wlr_seat_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_destroy _cffi_d_wlr_seat_destroy
#endif

static struct wlr_keyboard * _cffi_d_wlr_seat_get_keyboard(struct wlr_seat * x0)
{
  return wlr_seat_get_keyboard(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_get_keyboard(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_keyboard * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_get_keyboard(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(378));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_get_keyboard _cffi_d_wlr_seat_get_keyboard
#endif

static void _cffi_d_wlr_seat_keyboard_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_keyboard_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_clear_focus _cffi_d_wlr_seat_keyboard_clear_focus
#endif

static void _cffi_d_wlr_seat_keyboard_end_grab(struct wlr_seat * x0)
{
  wlr_seat_keyboard_end_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_end_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_end_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_end_grab _cffi_d_wlr_seat_keyboard_end_grab
#endif

static _Bool _cffi_d_wlr_seat_keyboard_has_grab(struct wlr_seat * x0)
{
  return wlr_seat_keyboard_has_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_has_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_keyboard_has_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_keyboard_has_grab _cffi_d_wlr_seat_keyboard_has_grab
#endif

static void _cffi_d_wlr_seat_keyboard_notify_enter(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t * x2, size_t x3, struct wlr_keyboard_modifiers * x4)
{
  wlr_seat_keyboard_notify_enter(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_enter(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t * x2;
  size_t x3;
  struct wlr_keyboard_modifiers * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_enter", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(755), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(755), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(731), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard_modifiers *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(731), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_enter(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_enter _cffi_d_wlr_seat_keyboard_notify_enter
#endif

static void _cffi_d_wlr_seat_keyboard_notify_key(struct wlr_seat * x0, uint32_t x1, uint32_t x2, uint32_t x3)
{
  wlr_seat_keyboard_notify_key(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_key(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_key", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_key _cffi_d_wlr_seat_keyboard_notify_key
#endif

static void _cffi_d_wlr_seat_keyboard_notify_modifiers(struct wlr_seat * x0, struct wlr_keyboard_modifiers * x1)
{
  wlr_seat_keyboard_notify_modifiers(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_notify_modifiers(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_keyboard_modifiers * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_notify_modifiers", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(731), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_keyboard_modifiers *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(731), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_notify_modifiers(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_notify_modifiers _cffi_d_wlr_seat_keyboard_notify_modifiers
#endif

static void _cffi_d_wlr_seat_keyboard_start_grab(struct wlr_seat * x0, struct wlr_seat_keyboard_grab * x1)
{
  wlr_seat_keyboard_start_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_keyboard_start_grab(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_seat_keyboard_grab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_keyboard_start_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(740), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat_keyboard_grab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(740), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_keyboard_start_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_keyboard_start_grab _cffi_d_wlr_seat_keyboard_start_grab
#endif

static void _cffi_d_wlr_seat_pointer_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_pointer_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_clear_focus _cffi_d_wlr_seat_pointer_clear_focus
#endif

static void _cffi_d_wlr_seat_pointer_end_grab(struct wlr_seat * x0)
{
  wlr_seat_pointer_end_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_end_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_end_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_end_grab _cffi_d_wlr_seat_pointer_end_grab
#endif

static _Bool _cffi_d_wlr_seat_pointer_has_grab(struct wlr_seat * x0)
{
  return wlr_seat_pointer_has_grab(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_has_grab(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_has_grab(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_has_grab _cffi_d_wlr_seat_pointer_has_grab
#endif

static void _cffi_d_wlr_seat_pointer_notify_axis(struct wlr_seat * x0, uint32_t x1, enum wlr_axis_orientation x2, double x3, int32_t x4, enum wlr_axis_source x5)
{
  wlr_seat_pointer_notify_axis(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_axis(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  enum wlr_axis_orientation x2;
  double x3;
  int32_t x4;
  enum wlr_axis_source x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_axis", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(772), arg2) < 0)
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int32_t);
  if (x4 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(775), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_axis(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_axis _cffi_d_wlr_seat_pointer_notify_axis
#endif

static uint32_t _cffi_d_wlr_seat_pointer_notify_button(struct wlr_seat * x0, uint32_t x1, uint32_t x2, enum wlr_button_state x3)
{
  return wlr_seat_pointer_notify_button(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_button(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  uint32_t x2;
  enum wlr_button_state x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_button", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(392), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_notify_button(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_button _cffi_d_wlr_seat_pointer_notify_button
#endif

static void _cffi_d_wlr_seat_pointer_notify_clear_focus(struct wlr_seat * x0)
{
  wlr_seat_pointer_notify_clear_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_clear_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_clear_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_clear_focus _cffi_d_wlr_seat_pointer_notify_clear_focus
#endif

static void _cffi_d_wlr_seat_pointer_notify_enter(struct wlr_seat * x0, struct wlr_surface * x1, double x2, double x3)
{
  wlr_seat_pointer_notify_enter(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_enter(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_enter", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_enter(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_enter _cffi_d_wlr_seat_pointer_notify_enter
#endif

static void _cffi_d_wlr_seat_pointer_notify_frame(struct wlr_seat * x0)
{
  wlr_seat_pointer_notify_frame(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_frame(PyObject *self, PyObject *arg0)
{
  struct wlr_seat * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_frame(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_frame _cffi_d_wlr_seat_pointer_notify_frame
#endif

static void _cffi_d_wlr_seat_pointer_notify_motion(struct wlr_seat * x0, uint32_t x1, double x2, double x3)
{
  wlr_seat_pointer_notify_motion(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_notify_motion(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_notify_motion", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_notify_motion(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_notify_motion _cffi_d_wlr_seat_pointer_notify_motion
#endif

static void _cffi_d_wlr_seat_pointer_start_grab(struct wlr_seat * x0, struct wlr_seat_pointer_grab * x1)
{
  wlr_seat_pointer_start_grab(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_start_grab(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_seat_pointer_grab * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_start_grab", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(744), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat_pointer_grab *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(744), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_pointer_start_grab(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_pointer_start_grab _cffi_d_wlr_seat_pointer_start_grab
#endif

static _Bool _cffi_d_wlr_seat_pointer_surface_has_focus(struct wlr_seat * x0, struct wlr_surface * x1)
{
  return wlr_seat_pointer_surface_has_focus(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_pointer_surface_has_focus(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_pointer_surface_has_focus", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_pointer_surface_has_focus(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_pointer_surface_has_focus _cffi_d_wlr_seat_pointer_surface_has_focus
#endif

static void _cffi_d_wlr_seat_set_capabilities(struct wlr_seat * x0, uint32_t x1)
{
  wlr_seat_set_capabilities(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_capabilities(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_capabilities", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_capabilities(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_capabilities _cffi_d_wlr_seat_set_capabilities
#endif

static void _cffi_d_wlr_seat_set_keyboard(struct wlr_seat * x0, struct wlr_input_device * x1)
{
  wlr_seat_set_keyboard(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_keyboard(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_input_device * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_keyboard", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_input_device *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_keyboard(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_keyboard _cffi_d_wlr_seat_set_keyboard
#endif

static void _cffi_d_wlr_seat_set_name(struct wlr_seat * x0, char const * x1)
{
  wlr_seat_set_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_name(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_name _cffi_d_wlr_seat_set_name
#endif

static void _cffi_d_wlr_seat_set_primary_selection(struct wlr_seat * x0, struct wlr_primary_selection_source * x1, uint32_t x2)
{
  wlr_seat_set_primary_selection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_primary_selection(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_primary_selection_source * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_primary_selection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(735), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_primary_selection_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(735), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_primary_selection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_primary_selection _cffi_d_wlr_seat_set_primary_selection
#endif

static void _cffi_d_wlr_seat_set_selection(struct wlr_seat * x0, struct wlr_data_source * x1, uint32_t x2)
{
  wlr_seat_set_selection(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_set_selection(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_data_source * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_set_selection", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_data_source *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_set_selection(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_set_selection _cffi_d_wlr_seat_set_selection
#endif

static void _cffi_d_wlr_seat_start_pointer_drag(struct wlr_seat * x0, struct wlr_drag * x1, uint32_t x2)
{
  wlr_seat_start_pointer_drag(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_start_pointer_drag(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_drag * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_start_pointer_drag", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(722), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_drag *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(722), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_start_pointer_drag(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_start_pointer_drag _cffi_d_wlr_seat_start_pointer_drag
#endif

static uint32_t _cffi_d_wlr_seat_touch_notify_down(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2, int32_t x3, double x4, double x5)
{
  return wlr_seat_touch_notify_down(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_down(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  int32_t x3;
  double x4;
  double x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_down", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int32_t);
  if (x3 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  x5 = (double)_cffi_to_c_double(arg5);
  if (x5 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_touch_notify_down(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_down _cffi_d_wlr_seat_touch_notify_down
#endif

static void _cffi_d_wlr_seat_touch_notify_motion(struct wlr_seat * x0, uint32_t x1, int32_t x2, double x3, double x4)
{
  wlr_seat_touch_notify_motion(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_motion(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  double x3;
  double x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_motion", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  x4 = (double)_cffi_to_c_double(arg4);
  if (x4 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_motion(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_motion _cffi_d_wlr_seat_touch_notify_motion
#endif

static void _cffi_d_wlr_seat_touch_notify_up(struct wlr_seat * x0, uint32_t x1, int32_t x2)
{
  wlr_seat_touch_notify_up(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_touch_notify_up(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  uint32_t x1;
  int32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_touch_notify_up", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int32_t);
  if (x2 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_seat_touch_notify_up(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_seat_touch_notify_up _cffi_d_wlr_seat_touch_notify_up
#endif

static _Bool _cffi_d_wlr_seat_validate_pointer_grab_serial(struct wlr_seat * x0, struct wlr_surface * x1, uint32_t x2)
{
  return wlr_seat_validate_pointer_grab_serial(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_seat_validate_pointer_grab_serial(PyObject *self, PyObject *args)
{
  struct wlr_seat * x0;
  struct wlr_surface * x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_seat_validate_pointer_grab_serial", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_seat_validate_pointer_grab_serial(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_seat_validate_pointer_grab_serial _cffi_d_wlr_seat_validate_pointer_grab_serial
#endif

static struct wlr_server_decoration_manager * _cffi_d_wlr_server_decoration_manager_create(struct wl_display * x0)
{
  return wlr_server_decoration_manager_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_server_decoration_manager_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_server_decoration_manager * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_server_decoration_manager_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(796));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_server_decoration_manager_create _cffi_d_wlr_server_decoration_manager_create
#endif

static void _cffi_d_wlr_server_decoration_manager_set_default_mode(struct wlr_server_decoration_manager * x0, uint32_t x1)
{
  wlr_server_decoration_manager_set_default_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_server_decoration_manager_set_default_mode(PyObject *self, PyObject *args)
{
  struct wlr_server_decoration_manager * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_server_decoration_manager_set_default_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(796), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_server_decoration_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(796), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_server_decoration_manager_set_default_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_server_decoration_manager_set_default_mode _cffi_d_wlr_server_decoration_manager_set_default_mode
#endif

static _Bool _cffi_d_wlr_session_change_vt(struct wlr_session * x0, unsigned int x1)
{
  return wlr_session_change_vt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_session_change_vt(PyObject *self, PyObject *args)
{
  struct wlr_session * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_session_change_vt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(83), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_session *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(83), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_session_change_vt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_session_change_vt _cffi_d_wlr_session_change_vt
#endif

static struct wlr_subsurface * _cffi_d_wlr_subsurface_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_subsurface_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_subsurface_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_subsurface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_subsurface_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1192));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_subsurface_from_wlr_surface _cffi_d_wlr_subsurface_from_wlr_surface
#endif

static void _cffi_d_wlr_surface_for_each_surface(struct wlr_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_surface_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_surface_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(576));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_for_each_surface _cffi_d_wlr_surface_for_each_surface
#endif

static struct wlr_surface * _cffi_d_wlr_surface_from_resource(struct wl_resource * x0)
{
  return wlr_surface_from_resource(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_from_resource(PyObject *self, PyObject *arg0)
{
  struct wl_resource * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_from_resource(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_from_resource _cffi_d_wlr_surface_from_resource
#endif

static void _cffi_d_wlr_surface_get_buffer_source_box(struct wlr_surface * x0, struct wlr_fbox * x1)
{
  wlr_surface_get_buffer_source_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_buffer_source_box(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_fbox * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_buffer_source_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(822), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_fbox *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(822), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_buffer_source_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_buffer_source_box _cffi_d_wlr_surface_get_buffer_source_box
#endif

static void _cffi_d_wlr_surface_get_effective_damage(struct wlr_surface * x0, struct pixman_region32 * x1)
{
  wlr_surface_get_effective_damage(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_effective_damage(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct pixman_region32 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_effective_damage", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct pixman_region32 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_effective_damage(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_effective_damage _cffi_d_wlr_surface_get_effective_damage
#endif

static void _cffi_d_wlr_surface_get_extends(struct wlr_surface * x0, struct wlr_box * x1)
{
  wlr_surface_get_extends(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_extends(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_get_extends", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_get_extends(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_get_extends _cffi_d_wlr_surface_get_extends
#endif

static struct wlr_surface * _cffi_d_wlr_surface_get_root_surface(struct wlr_surface * x0)
{
  return wlr_surface_get_root_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_root_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_get_root_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_get_root_surface _cffi_d_wlr_surface_get_root_surface
#endif

static struct wlr_texture * _cffi_d_wlr_surface_get_texture(struct wlr_surface * x0)
{
  return wlr_surface_get_texture(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_get_texture(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_texture * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_get_texture(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_get_texture _cffi_d_wlr_surface_get_texture
#endif

static _Bool _cffi_d_wlr_surface_has_buffer(struct wlr_surface * x0)
{
  return wlr_surface_has_buffer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_has_buffer(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_has_buffer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_has_buffer _cffi_d_wlr_surface_has_buffer
#endif

static _Bool _cffi_d_wlr_surface_is_layer_surface(struct wlr_surface * x0)
{
  return wlr_surface_is_layer_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_is_layer_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_is_layer_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_is_layer_surface _cffi_d_wlr_surface_is_layer_surface
#endif

static _Bool _cffi_d_wlr_surface_is_subsurface(struct wlr_surface * x0)
{
  return wlr_surface_is_subsurface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_is_subsurface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_is_subsurface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_is_subsurface _cffi_d_wlr_surface_is_subsurface
#endif

static _Bool _cffi_d_wlr_surface_is_xdg_surface(struct wlr_surface * x0)
{
  return wlr_surface_is_xdg_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_is_xdg_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_is_xdg_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_is_xdg_surface _cffi_d_wlr_surface_is_xdg_surface
#endif

static _Bool _cffi_d_wlr_surface_is_xwayland_surface(struct wlr_surface * x0)
{
  return wlr_surface_is_xwayland_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_is_xwayland_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_is_xwayland_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_is_xwayland_surface _cffi_d_wlr_surface_is_xwayland_surface
#endif

static uint32_t _cffi_d_wlr_surface_lock_pending(struct wlr_surface * x0)
{
  return wlr_surface_lock_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_lock_pending(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_lock_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_lock_pending _cffi_d_wlr_surface_lock_pending
#endif

static _Bool _cffi_d_wlr_surface_point_accepts_input(struct wlr_surface * x0, double x1, double x2)
{
  return wlr_surface_point_accepts_input(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_point_accepts_input(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  double x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_surface_point_accepts_input", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_point_accepts_input(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_point_accepts_input _cffi_d_wlr_surface_point_accepts_input
#endif

static void _cffi_d_wlr_surface_send_enter(struct wlr_surface * x0, struct wlr_output * x1)
{
  wlr_surface_send_enter(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_enter(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_enter", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_enter(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_enter _cffi_d_wlr_surface_send_enter
#endif

static void _cffi_d_wlr_surface_send_frame_done(struct wlr_surface * x0, struct timespec const * x1)
{
  wlr_surface_send_frame_done(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_frame_done(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct timespec const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_frame_done", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(814), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timespec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(814), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_frame_done(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_frame_done _cffi_d_wlr_surface_send_frame_done
#endif

static void _cffi_d_wlr_surface_send_leave(struct wlr_surface * x0, struct wlr_output * x1)
{
  wlr_surface_send_leave(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_send_leave(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_output * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_send_leave", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_send_leave(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_send_leave _cffi_d_wlr_surface_send_leave
#endif

static _Bool _cffi_d_wlr_surface_set_role(struct wlr_surface * x0, struct wlr_surface_role const * x1, void * x2, struct wl_resource * x3, uint32_t x4)
{
  return wlr_surface_set_role(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_set_role(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  struct wlr_surface_role const * x1;
  void * x2;
  struct wl_resource * x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_surface_set_role", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(96), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_surface_role const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(96), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct wl_resource *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_set_role(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_set_role _cffi_d_wlr_surface_set_role
#endif

static struct wlr_surface * _cffi_d_wlr_surface_surface_at(struct wlr_surface * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_surface_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_surface_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_surface_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_surface_surface_at _cffi_d_wlr_surface_surface_at
#endif

static void _cffi_d_wlr_surface_unlock_cached(struct wlr_surface * x0, uint32_t x1)
{
  wlr_surface_unlock_cached(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_surface_unlock_cached(PyObject *self, PyObject *args)
{
  struct wlr_surface * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_surface_unlock_cached", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_surface_unlock_cached(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_surface_unlock_cached _cffi_d_wlr_surface_unlock_cached
#endif

static void _cffi_d_wlr_texture_destroy(struct wlr_texture * x0)
{
  wlr_texture_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_texture * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_texture_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_texture_destroy _cffi_d_wlr_texture_destroy
#endif

static struct wlr_texture * _cffi_d_wlr_texture_from_pixels(struct wlr_renderer * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, void const * x5)
{
  return wlr_texture_from_pixels(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_from_pixels(PyObject *self, PyObject *args)
{
  struct wlr_renderer * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  void const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_texture * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "wlr_texture_from_pixels", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(38), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_renderer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(38), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_texture_from_pixels(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(51));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_texture_from_pixels _cffi_d_wlr_texture_from_pixels
#endif

static _Bool _cffi_d_wlr_texture_write_pixels(struct wlr_texture * x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t x5, uint32_t x6, uint32_t x7, void const * x8)
{
  return wlr_texture_write_pixels(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_texture_write_pixels(PyObject *self, PyObject *args)
{
  struct wlr_texture * x0;
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  void const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "wlr_texture_write_pixels", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(51), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_texture *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(51), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, uint32_t);
  if (x7 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(110), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_texture_write_pixels(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_texture_write_pixels _cffi_d_wlr_texture_write_pixels
#endif

static struct wlr_virtual_keyboard_manager_v1 * _cffi_d_wlr_virtual_keyboard_manager_v1_create(struct wl_display * x0)
{
  return wlr_virtual_keyboard_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_virtual_keyboard_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_virtual_keyboard_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_virtual_keyboard_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1210));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_virtual_keyboard_manager_v1_create _cffi_d_wlr_virtual_keyboard_manager_v1_create
#endif

static struct wlr_xcursor_manager * _cffi_d_wlr_xcursor_manager_create(char const * x0, uint32_t x1)
{
  return wlr_xcursor_manager_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_create(PyObject *self, PyObject *args)
{
  char const * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xcursor_manager * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(135));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_create _cffi_d_wlr_xcursor_manager_create
#endif

static void _cffi_d_wlr_xcursor_manager_destroy(struct wlr_xcursor_manager * x0)
{
  wlr_xcursor_manager_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xcursor_manager * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(135), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xcursor_manager_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xcursor_manager_destroy _cffi_d_wlr_xcursor_manager_destroy
#endif

static struct wlr_xcursor * _cffi_d_wlr_xcursor_manager_get_xcursor(struct wlr_xcursor_manager * x0, char const * x1, float x2)
{
  return wlr_xcursor_manager_get_xcursor(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_get_xcursor(PyObject *self, PyObject *args)
{
  struct wlr_xcursor_manager * x0;
  char const * x1;
  float x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xcursor * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_get_xcursor", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(135), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (float)_cffi_to_c_float(arg2);
  if (x2 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_get_xcursor(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1213));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_get_xcursor _cffi_d_wlr_xcursor_manager_get_xcursor
#endif

static int _cffi_d_wlr_xcursor_manager_load(struct wlr_xcursor_manager * x0, float x1)
{
  return wlr_xcursor_manager_load(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_load(PyObject *self, PyObject *args)
{
  struct wlr_xcursor_manager * x0;
  float x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_load", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(135), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (float)_cffi_to_c_float(arg1);
  if (x1 == (float)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xcursor_manager_load(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xcursor_manager_load _cffi_d_wlr_xcursor_manager_load
#endif

static void _cffi_d_wlr_xcursor_manager_set_cursor_image(struct wlr_xcursor_manager * x0, char const * x1, struct wlr_cursor * x2)
{
  wlr_xcursor_manager_set_cursor_image(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xcursor_manager_set_cursor_image(PyObject *self, PyObject *args)
{
  struct wlr_xcursor_manager * x0;
  char const * x1;
  struct wlr_cursor * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xcursor_manager_set_cursor_image", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(135), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xcursor_manager *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(135), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct wlr_cursor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xcursor_manager_set_cursor_image(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xcursor_manager_set_cursor_image _cffi_d_wlr_xcursor_manager_set_cursor_image
#endif

static struct wlr_xdg_decoration_manager_v1 * _cffi_d_wlr_xdg_decoration_manager_v1_create(struct wl_display * x0)
{
  return wlr_xdg_decoration_manager_v1_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_decoration_manager_v1_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_decoration_manager_v1 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_decoration_manager_v1_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1221));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_decoration_manager_v1_create _cffi_d_wlr_xdg_decoration_manager_v1_create
#endif

static struct wlr_xdg_output_manager_v1 * _cffi_d_wlr_xdg_output_manager_v1_create(struct wl_display * x0, struct wlr_output_layout * x1)
{
  return wlr_xdg_output_manager_v1_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_output_manager_v1_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_output_layout * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_output_manager_v1 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_output_manager_v1_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_output_layout *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_output_manager_v1_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1223));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_output_manager_v1_create _cffi_d_wlr_xdg_output_manager_v1_create
#endif

static void _cffi_d_wlr_xdg_popup_destroy(struct wlr_xdg_surface * x0)
{
  wlr_xdg_popup_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_popup_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_popup_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_popup_destroy _cffi_d_wlr_xdg_popup_destroy
#endif

static void _cffi_d_wlr_xdg_popup_unconstrain_from_box(struct wlr_xdg_popup * x0, struct wlr_box const * x1)
{
  wlr_xdg_popup_unconstrain_from_box(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_popup_unconstrain_from_box(PyObject *self, PyObject *args)
{
  struct wlr_xdg_popup * x0;
  struct wlr_box const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_popup_unconstrain_from_box", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(849), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_popup *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(849), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_popup_unconstrain_from_box(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_popup_unconstrain_from_box _cffi_d_wlr_xdg_popup_unconstrain_from_box
#endif

static struct wlr_xdg_shell * _cffi_d_wlr_xdg_shell_create(struct wl_display * x0)
{
  return wlr_xdg_shell_create(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_shell_create(PyObject *self, PyObject *arg0)
{
  struct wl_display * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_shell * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_shell_create(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_shell_create _cffi_d_wlr_xdg_shell_create
#endif

static void _cffi_d_wlr_xdg_surface_for_each_popup_surface(struct wlr_xdg_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_xdg_surface_for_each_popup_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_for_each_popup_surface(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_for_each_popup_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(576));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_for_each_popup_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_for_each_popup_surface _cffi_d_wlr_xdg_surface_for_each_popup_surface
#endif

static void _cffi_d_wlr_xdg_surface_for_each_surface(struct wlr_xdg_surface * x0, void(* x1)(struct wlr_surface *, int, int, void *), void * x2)
{
  wlr_xdg_surface_for_each_surface(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_for_each_surface(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  void(* x1)(struct wlr_surface *, int, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_for_each_surface", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct wlr_surface *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(576));
  if (x1 == (void(*)(struct wlr_surface *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(97), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(97), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_for_each_surface(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_for_each_surface _cffi_d_wlr_xdg_surface_for_each_surface
#endif

static struct wlr_xdg_surface * _cffi_d_wlr_xdg_surface_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_xdg_surface_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xdg_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_surface_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(276));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_surface_from_wlr_surface _cffi_d_wlr_xdg_surface_from_wlr_surface
#endif

static void _cffi_d_wlr_xdg_surface_get_geometry(struct wlr_xdg_surface * x0, struct wlr_box * x1)
{
  wlr_xdg_surface_get_geometry(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_get_geometry(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  struct wlr_box * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_get_geometry", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_box *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_get_geometry(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_get_geometry _cffi_d_wlr_xdg_surface_get_geometry
#endif

static void _cffi_d_wlr_xdg_surface_ping(struct wlr_xdg_surface * x0)
{
  wlr_xdg_surface_ping(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_ping(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_surface_ping(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_surface_ping _cffi_d_wlr_xdg_surface_ping
#endif

static struct wlr_surface * _cffi_d_wlr_xdg_surface_surface_at(struct wlr_xdg_surface * x0, double x1, double x2, double * x3, double * x4)
{
  return wlr_xdg_surface_surface_at(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_surface_surface_at(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  double x1;
  double x2;
  double * x3;
  double * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_surface * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_surface_surface_at", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (double)_cffi_to_c_double(arg1);
  if (x1 == (double)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(305), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(305), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_surface_surface_at(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(75));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_surface_surface_at _cffi_d_wlr_xdg_surface_surface_at
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode(struct wlr_xdg_toplevel_decoration_v1 * x0, enum wlr_xdg_toplevel_decoration_v1_mode x1)
{
  return wlr_xdg_toplevel_decoration_v1_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode(PyObject *self, PyObject *args)
{
  struct wlr_xdg_toplevel_decoration_v1 * x0;
  enum wlr_xdg_toplevel_decoration_v1_mode x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_decoration_v1_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(411), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_toplevel_decoration_v1 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(411), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(412), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_decoration_v1_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode _cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode
#endif

static void _cffi_d_wlr_xdg_toplevel_send_close(struct wlr_xdg_surface * x0)
{
  wlr_xdg_toplevel_send_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_send_close(PyObject *self, PyObject *arg0)
{
  struct wlr_xdg_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xdg_toplevel_send_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_send_close _cffi_d_wlr_xdg_toplevel_send_close
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_activated(struct wlr_xdg_surface * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_activated(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_activated(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_activated", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_activated(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_activated _cffi_d_wlr_xdg_toplevel_set_activated
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_fullscreen(struct wlr_xdg_surface * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_fullscreen _cffi_d_wlr_xdg_toplevel_set_fullscreen
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_maximized(struct wlr_xdg_surface * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_maximized _cffi_d_wlr_xdg_toplevel_set_maximized
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_resizing(struct wlr_xdg_surface * x0, _Bool x1)
{
  return wlr_xdg_toplevel_set_resizing(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_resizing(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_resizing", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_resizing(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_resizing _cffi_d_wlr_xdg_toplevel_set_resizing
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_size(struct wlr_xdg_surface * x0, uint32_t x1, uint32_t x2)
{
  return wlr_xdg_toplevel_set_size(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_size(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  uint32_t x1;
  uint32_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_size", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_size(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_size _cffi_d_wlr_xdg_toplevel_set_size
#endif

static uint32_t _cffi_d_wlr_xdg_toplevel_set_tiled(struct wlr_xdg_surface * x0, uint32_t x1)
{
  return wlr_xdg_toplevel_set_tiled(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xdg_toplevel_set_tiled(PyObject *self, PyObject *args)
{
  struct wlr_xdg_surface * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xdg_toplevel_set_tiled", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(276), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xdg_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(276), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xdg_toplevel_set_tiled(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xdg_toplevel_set_tiled _cffi_d_wlr_xdg_toplevel_set_tiled
#endif

static struct wlr_xwayland * _cffi_d_wlr_xwayland_create(struct wl_display * x0, struct wlr_compositor * x1, _Bool x2)
{
  return wlr_xwayland_create(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_compositor * x1;
  _Bool x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_create", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(363), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_compositor *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(363), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (_Bool)_cffi_to_c__Bool(arg2);
  if (x2 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_create(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(865));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_create _cffi_d_wlr_xwayland_create
#endif

static void _cffi_d_wlr_xwayland_destroy(struct wlr_xwayland * x0)
{
  wlr_xwayland_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(865), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(865), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_destroy _cffi_d_wlr_xwayland_destroy
#endif

static enum wlr_xwayland_icccm_input_model _cffi_d_wlr_xwayland_icccm_input_model(struct wlr_xwayland_surface const * x0)
{
  return wlr_xwayland_icccm_input_model(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_icccm_input_model(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum wlr_xwayland_icccm_input_model result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_icccm_input_model(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(947));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_icccm_input_model _cffi_d_wlr_xwayland_icccm_input_model
#endif

static _Bool _cffi_d_wlr_xwayland_or_surface_wants_focus(struct wlr_xwayland_surface const * x0)
{
  return wlr_xwayland_or_surface_wants_focus(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_or_surface_wants_focus(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  _Bool result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_or_surface_wants_focus(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c__Bool(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_or_surface_wants_focus _cffi_d_wlr_xwayland_or_surface_wants_focus
#endif

static struct wlr_xwayland_server * _cffi_d_wlr_xwayland_server_create(struct wl_display * x0, struct wlr_xwayland_server_options * x1)
{
  return wlr_xwayland_server_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_server_create(PyObject *self, PyObject *args)
{
  struct wl_display * x0;
  struct wlr_xwayland_server_options * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland_server * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_server_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wl_display *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(368), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_server_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(368), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_server_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(881));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_server_create _cffi_d_wlr_xwayland_server_create
#endif

static void _cffi_d_wlr_xwayland_server_destroy(struct wlr_xwayland_server * x0)
{
  wlr_xwayland_server_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_server_destroy(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_server * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(881), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_server *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(881), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_server_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_server_destroy _cffi_d_wlr_xwayland_server_destroy
#endif

static void _cffi_d_wlr_xwayland_set_cursor(struct wlr_xwayland * x0, uint8_t * x1, uint32_t x2, uint32_t x3, uint32_t x4, int32_t x5, int32_t x6)
{
  wlr_xwayland_set_cursor(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_set_cursor(PyObject *self, PyObject *args)
{
  struct wlr_xwayland * x0;
  uint8_t * x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  int32_t x5;
  int32_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_set_cursor", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(865), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(865), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(873), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(873), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, uint32_t);
  if (x2 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int32_t);
  if (x5 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int32_t);
  if (x6 == (int32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_set_cursor(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_set_cursor _cffi_d_wlr_xwayland_set_cursor
#endif

static void _cffi_d_wlr_xwayland_set_seat(struct wlr_xwayland * x0, struct wlr_seat * x1)
{
  wlr_xwayland_set_seat(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_set_seat(PyObject *self, PyObject *args)
{
  struct wlr_xwayland * x0;
  struct wlr_seat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_set_seat", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(865), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(865), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_seat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_set_seat(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_set_seat _cffi_d_wlr_xwayland_set_seat
#endif

static void _cffi_d_wlr_xwayland_surface_activate(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_activate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_activate(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_activate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_activate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_activate _cffi_d_wlr_xwayland_surface_activate
#endif

static void _cffi_d_wlr_xwayland_surface_close(struct wlr_xwayland_surface * x0)
{
  wlr_xwayland_surface_close(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_close(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_close(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_close _cffi_d_wlr_xwayland_surface_close
#endif

static void _cffi_d_wlr_xwayland_surface_configure(struct wlr_xwayland_surface * x0, int16_t x1, int16_t x2, uint16_t x3, uint16_t x4)
{
  wlr_xwayland_surface_configure(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_configure(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  int16_t x1;
  int16_t x2;
  uint16_t x3;
  uint16_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_configure", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int16_t);
  if (x1 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int16_t);
  if (x2 == (int16_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint16_t);
  if (x3 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint16_t);
  if (x4 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_configure(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_configure _cffi_d_wlr_xwayland_surface_configure
#endif

static struct wlr_xwayland_surface * _cffi_d_wlr_xwayland_surface_from_wlr_surface(struct wlr_surface * x0)
{
  return wlr_xwayland_surface_from_wlr_surface(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_from_wlr_surface(PyObject *self, PyObject *arg0)
{
  struct wlr_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct wlr_xwayland_surface * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(75), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(75), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = wlr_xwayland_surface_from_wlr_surface(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(884));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_wlr_xwayland_surface_from_wlr_surface _cffi_d_wlr_xwayland_surface_from_wlr_surface
#endif

static void _cffi_d_wlr_xwayland_surface_ping(struct wlr_xwayland_surface * x0)
{
  wlr_xwayland_surface_ping(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_ping(PyObject *self, PyObject *arg0)
{
  struct wlr_xwayland_surface * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_ping(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_ping _cffi_d_wlr_xwayland_surface_ping
#endif

static void _cffi_d_wlr_xwayland_surface_restack(struct wlr_xwayland_surface * x0, struct wlr_xwayland_surface * x1, enum xcb_stack_mode_t x2)
{
  wlr_xwayland_surface_restack(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_restack(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  struct wlr_xwayland_surface * x1;
  enum xcb_stack_mode_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_restack", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(900), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_restack(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_restack _cffi_d_wlr_xwayland_surface_restack
#endif

static void _cffi_d_wlr_xwayland_surface_set_fullscreen(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_fullscreen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_fullscreen(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_fullscreen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_fullscreen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_fullscreen _cffi_d_wlr_xwayland_surface_set_fullscreen
#endif

static void _cffi_d_wlr_xwayland_surface_set_maximized(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_maximized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_maximized(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_maximized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_maximized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_maximized _cffi_d_wlr_xwayland_surface_set_maximized
#endif

static void _cffi_d_wlr_xwayland_surface_set_minimized(struct wlr_xwayland_surface * x0, _Bool x1)
{
  wlr_xwayland_surface_set_minimized(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wlr_xwayland_surface_set_minimized(PyObject *self, PyObject *args)
{
  struct wlr_xwayland_surface * x0;
  _Bool x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wlr_xwayland_surface_set_minimized", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(884), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct wlr_xwayland_surface *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(884), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (_Bool)_cffi_to_c__Bool(arg1);
  if (x1 == (_Bool)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wlr_xwayland_surface_set_minimized(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wlr_xwayland_surface_set_minimized _cffi_d_wlr_xwayland_surface_set_minimized
#endif

static void _cffi_d_wrapped_log_init(enum wlr_log_importance x0, void(* x1)(enum wlr_log_importance, char const *))
{
  wrapped_log_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_wrapped_log_init(PyObject *self, PyObject *args)
{
  enum wlr_log_importance x0;
  void(* x1)(enum wlr_log_importance, char const *);
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "wrapped_log_init", 2, 2, &arg0, &arg1))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(415), arg0) < 0)
    return NULL;

  x1 = (void(*)(enum wlr_log_importance, char const *))_cffi_to_c_pointer(arg1, _cffi_type(420));
  if (x1 == (void(*)(enum wlr_log_importance, char const *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { wrapped_log_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_wrapped_log_init _cffi_d_wrapped_log_init
#endif

static xcb_connection_t * _cffi_d_xcb_connect(char const * x0, int * x1)
{
  return xcb_connect(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_connect(PyObject *self, PyObject *args)
{
  char const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_connection_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "xcb_connect", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(33), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(33), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_connect(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(153));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xcb_connect _cffi_d_xcb_connect
#endif

static int _cffi_d_xcb_connection_has_error(xcb_connection_t * x0)
{
  return xcb_connection_has_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_connection_has_error(PyObject *self, PyObject *arg0)
{
  xcb_connection_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_connection_has_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_xcb_connection_has_error _cffi_d_xcb_connection_has_error
#endif

static void _cffi_d_xcb_disconnect(xcb_connection_t * x0)
{
  xcb_disconnect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_disconnect(PyObject *self, PyObject *arg0)
{
  xcb_connection_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { xcb_disconnect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_xcb_disconnect _cffi_d_xcb_disconnect
#endif

static xcb_intern_atom_cookie_t _cffi_d_xcb_intern_atom(xcb_connection_t * x0, uint8_t x1, uint16_t x2, char const * x3)
{
  return xcb_intern_atom(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_intern_atom(PyObject *self, PyObject *args)
{
  xcb_connection_t * x0;
  uint8_t x1;
  uint16_t x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_intern_atom_cookie_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "xcb_intern_atom", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint8_t);
  if (x1 == (uint8_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, uint16_t);
  if (x2 == (uint16_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_intern_atom(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(925));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_xcb_intern_atom(xcb_intern_atom_cookie_t *result, xcb_connection_t * x0, uint8_t x1, uint16_t x2, char const * x3)
{
  { *result = xcb_intern_atom(x0, x1, x2, x3); }
}
#endif

static xcb_intern_atom_reply_t * _cffi_d_xcb_intern_atom_reply(xcb_connection_t * x0, xcb_intern_atom_cookie_t x1, xcb_generic_error_t * * x2)
{
  return xcb_intern_atom_reply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_xcb_intern_atom_reply(PyObject *self, PyObject *args)
{
  xcb_connection_t * x0;
  xcb_intern_atom_cookie_t x1;
  xcb_generic_error_t * * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  xcb_intern_atom_reply_t * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "xcb_intern_atom_reply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (xcb_connection_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(925), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(926), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (xcb_generic_error_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(926), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = xcb_intern_atom_reply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1292));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static xcb_intern_atom_reply_t * _cffi_f_xcb_intern_atom_reply(xcb_connection_t * x0, xcb_intern_atom_cookie_t *x1, xcb_generic_error_t * * x2)
{
  xcb_intern_atom_reply_t * result;
  { result = xcb_intern_atom_reply(x0, *x1, x2); }
  return result;
}
#endif

static int _cffi_const_CLOCK_MONOTONIC(unsigned long long *o)
{
  int n = (CLOCK_MONOTONIC) <= 0;
  *o = (unsigned long long)((CLOCK_MONOTONIC) | 0);  /* check that CLOCK_MONOTONIC is an integer */
  return n;
}

static int _cffi_const_WLR_KEYBOARD_KEYS_CAP(unsigned long long *o)
{
  int n = (WLR_KEYBOARD_KEYS_CAP) <= 0;
  *o = (unsigned long long)((WLR_KEYBOARD_KEYS_CAP) | 0);  /* check that WLR_KEYBOARD_KEYS_CAP is an integer */
  if (!_cffi_check_int(*o, n, 32U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_LED_COUNT(unsigned long long *o)
{
  int n = (WLR_LED_COUNT) <= 0;
  *o = (unsigned long long)((WLR_LED_COUNT) | 0);  /* check that WLR_LED_COUNT is an integer */
  if (!_cffi_check_int(*o, n, 3U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_MODIFIER_COUNT(unsigned long long *o)
{
  int n = (WLR_MODIFIER_COUNT) <= 0;
  *o = (unsigned long long)((WLR_MODIFIER_COUNT) | 0);  /* check that WLR_MODIFIER_COUNT is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_OUTPUT_DAMAGE_PREVIOUS_LEN(unsigned long long *o)
{
  int n = (WLR_OUTPUT_DAMAGE_PREVIOUS_LEN) <= 0;
  *o = (unsigned long long)((WLR_OUTPUT_DAMAGE_PREVIOUS_LEN) | 0);  /* check that WLR_OUTPUT_DAMAGE_PREVIOUS_LEN is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_POINTER_BUTTONS_CAP(unsigned long long *o)
{
  int n = (WLR_POINTER_BUTTONS_CAP) <= 0;
  *o = (unsigned long long)((WLR_POINTER_BUTTONS_CAP) | 0);  /* check that WLR_POINTER_BUTTONS_CAP is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_WLR_VERSION_MAJOR(unsigned long long *o)
{
  int n = (WLR_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MAJOR) | 0);  /* check that WLR_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_WLR_VERSION_MICRO(unsigned long long *o)
{
  int n = (WLR_VERSION_MICRO) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MICRO) | 0);  /* check that WLR_VERSION_MICRO is an integer */
  return n;
}

static int _cffi_const_WLR_VERSION_MINOR(unsigned long long *o)
{
  int n = (WLR_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((WLR_VERSION_MINOR) | 0);  /* check that WLR_VERSION_MINOR is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_box32(struct pixman_box32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x1) | 0);  /* check that 'struct pixman_box32.x1' is an integer */
  (void)((p->y1) | 0);  /* check that 'struct pixman_box32.y1' is an integer */
  (void)((p->x2) | 0);  /* check that 'struct pixman_box32.x2' is an integer */
  (void)((p->y2) | 0);  /* check that 'struct pixman_box32.y2' is an integer */
}
struct _cffi_align_struct_pixman_box32 { char x; struct pixman_box32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_pixman_region32(struct pixman_region32 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_pixman_region32 { char x; struct pixman_region32 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_timespec(struct timespec *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'struct timespec.tv_sec' is an integer */
  (void)((p->tv_nsec) | 0);  /* check that 'struct timespec.tv_nsec' is an integer */
}
struct _cffi_align_struct_timespec { char x; struct timespec y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_array(struct wl_array *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->size) | 0);  /* check that 'struct wl_array.size' is an integer */
  (void)((p->alloc) | 0);  /* check that 'struct wl_array.alloc' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wl_array { char x; struct wl_array y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_interface(struct wl_interface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->version) | 0);  /* check that 'struct wl_interface.version' is an integer */
  (void)((p->method_count) | 0);  /* check that 'struct wl_interface.method_count' is an integer */
  { struct wl_message const * *tmp = &p->methods; (void)tmp; }
  (void)((p->event_count) | 0);  /* check that 'struct wl_interface.event_count' is an integer */
  { struct wl_message const * *tmp = &p->events; (void)tmp; }
}
struct _cffi_align_struct_wl_interface { char x; struct wl_interface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_list(struct wl_list *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list * *tmp = &p->prev; (void)tmp; }
  { struct wl_list * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_wl_list { char x; struct wl_list y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener(struct wl_listener *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { void(* *tmp)(struct wl_listener *, void *) = &p->notify; (void)tmp; }
}
struct _cffi_align_struct_wl_listener { char x; struct wl_listener y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_listener_container(struct wl_listener_container *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->handle; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy_listener; (void)tmp; }
}
struct _cffi_align_struct_wl_listener_container { char x; struct wl_listener_container y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_message(struct wl_message *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->signature; (void)tmp; }
  { struct wl_interface const * * *tmp = &p->types; (void)tmp; }
}
struct _cffi_align_struct_wl_message { char x; struct wl_message y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wl_signal(struct wl_signal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->listener_list; (void)tmp; }
}
struct _cffi_align_struct_wl_signal { char x; struct wl_signal y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_allocator(struct wlr_allocator *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_allocator { char x; struct wlr_allocator y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_backend(struct wlr_backend *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_backend_impl const * *tmp = &p->impl; (void)tmp; }
  /* cannot generate 'struct $1' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_backend { char x; struct wlr_backend y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_box(struct wlr_box *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_box.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_box.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_box.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_box.height' is an integer */
}
struct _cffi_align_struct_wlr_box { char x; struct wlr_box y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_compositor(struct wlr_compositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_subcompositor *tmp = &p->subcompositor; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $3' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_compositor { char x; struct wlr_compositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_cursor(struct wlr_cursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_cursor_state * *tmp = &p->state; (void)tmp; }
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  /* cannot generate 'struct $2' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_cursor { char x; struct wlr_cursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_control_manager_v1(struct wlr_data_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  /* cannot generate 'struct $4' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_data_control_manager_v1 { char x; struct wlr_data_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_data_source(struct wlr_data_source *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wl_array *tmp = &p->mime_types; (void)tmp; }
  (void)((p->actions) | 0);  /* check that 'struct wlr_data_source.actions' is an integer */
  (void)((p->accepted) | 0);  /* check that 'struct wlr_data_source.accepted' is an integer */
  { enum wl_data_device_manager_dnd_action *tmp = &p->current_dnd_action; (void)tmp; }
  (void)((p->compositor_action) | 0);  /* check that 'struct wlr_data_source.compositor_action' is an integer */
  /* cannot generate 'struct $7' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_data_source { char x; struct wlr_data_source y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag(struct wlr_drag *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_drag_grab_type *tmp = &p->grab_type; (void)tmp; }
  { struct wlr_seat_keyboard_grab *tmp = &p->keyboard_grab; (void)tmp; }
  { struct wlr_seat_pointer_grab *tmp = &p->pointer_grab; (void)tmp; }
  { struct wlr_seat_touch_grab *tmp = &p->touch_grab; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focus_client; (void)tmp; }
  { struct wlr_drag_icon * *tmp = &p->icon; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focus; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->started) | 0);  /* check that 'struct wlr_drag.started' is an integer */
  (void)((p->dropped) | 0);  /* check that 'struct wlr_drag.dropped' is an integer */
  (void)((p->cancelling) | 0);  /* check that 'struct wlr_drag.cancelling' is an integer */
  (void)((p->grab_touch_id) | 0);  /* check that 'struct wlr_drag.grab_touch_id' is an integer */
  (void)((p->touch_id) | 0);  /* check that 'struct wlr_drag.touch_id' is an integer */
  /* cannot generate 'struct $6' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->icon_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag { char x; struct wlr_drag y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_drop_event(struct wlr_drag_drop_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_drop_event.time' is an integer */
}
struct _cffi_align_struct_wlr_drag_drop_event { char x; struct wlr_drag_drop_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_icon(struct wlr_drag_icon *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->mapped) | 0);  /* check that 'struct wlr_drag_icon.mapped' is an integer */
  /* cannot generate 'struct $5' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_icon { char x; struct wlr_drag_icon y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_drag_motion_event(struct wlr_drag_motion_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  (void)((p->time) | 0);  /* check that 'struct wlr_drag_motion_event.time' is an integer */
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_drag_motion_event { char x; struct wlr_drag_motion_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_keyboard_key(struct wlr_event_keyboard_key *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_keyboard_key.time_msec' is an integer */
  (void)((p->keycode) | 0);  /* check that 'struct wlr_event_keyboard_key.keycode' is an integer */
  (void)((p->update_state) | 0);  /* check that 'struct wlr_event_keyboard_key.update_state' is an integer */
  { enum wl_keyboard_key_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_keyboard_key { char x; struct wlr_event_keyboard_key y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_axis(struct wlr_event_pointer_axis *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_axis.time_msec' is an integer */
  { enum wlr_axis_source *tmp = &p->source; (void)tmp; }
  { enum wlr_axis_orientation *tmp = &p->orientation; (void)tmp; }
  { double *tmp = &p->delta; (void)tmp; }
  (void)((p->delta_discrete) | 0);  /* check that 'struct wlr_event_pointer_axis.delta_discrete' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_axis { char x; struct wlr_event_pointer_axis y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_button(struct wlr_event_pointer_button *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_button.time_msec' is an integer */
  (void)((p->button) | 0);  /* check that 'struct wlr_event_pointer_button.button' is an integer */
  { enum wlr_button_state *tmp = &p->state; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_button { char x; struct wlr_event_pointer_button y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_motion(struct wlr_event_pointer_motion *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_motion.time_msec' is an integer */
  { double *tmp = &p->delta_x; (void)tmp; }
  { double *tmp = &p->delta_y; (void)tmp; }
  { double *tmp = &p->unaccel_dx; (void)tmp; }
  { double *tmp = &p->unaccel_dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_motion { char x; struct wlr_event_pointer_motion y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_motion_absolute(struct wlr_event_pointer_motion_absolute *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_motion_absolute.time_msec' is an integer */
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_motion_absolute { char x; struct wlr_event_pointer_motion_absolute y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_begin(struct wlr_event_pointer_pinch_begin *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_begin.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_pinch_begin.fingers' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_pinch_begin { char x; struct wlr_event_pointer_pinch_begin y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_end(struct wlr_event_pointer_pinch_end *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_end.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_event_pointer_pinch_end.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_pinch_end { char x; struct wlr_event_pointer_pinch_end y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_pinch_update(struct wlr_event_pointer_pinch_update *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_pinch_update.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_pinch_update.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
  { double *tmp = &p->scale; (void)tmp; }
  { double *tmp = &p->rotation; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_pinch_update { char x; struct wlr_event_pointer_pinch_update y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_begin(struct wlr_event_pointer_swipe_begin *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_begin.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_swipe_begin.fingers' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_swipe_begin { char x; struct wlr_event_pointer_swipe_begin y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_end(struct wlr_event_pointer_swipe_end *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_end.time_msec' is an integer */
  (void)((p->cancelled) | 0);  /* check that 'struct wlr_event_pointer_swipe_end.cancelled' is an integer */
}
struct _cffi_align_struct_wlr_event_pointer_swipe_end { char x; struct wlr_event_pointer_swipe_end y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_event_pointer_swipe_update(struct wlr_event_pointer_swipe_update *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device * *tmp = &p->device; (void)tmp; }
  (void)((p->time_msec) | 0);  /* check that 'struct wlr_event_pointer_swipe_update.time_msec' is an integer */
  (void)((p->fingers) | 0);  /* check that 'struct wlr_event_pointer_swipe_update.fingers' is an integer */
  { double *tmp = &p->dx; (void)tmp; }
  { double *tmp = &p->dy; (void)tmp; }
}
struct _cffi_align_struct_wlr_event_pointer_swipe_update { char x; struct wlr_event_pointer_swipe_update y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_fbox(struct wlr_fbox *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->x; (void)tmp; }
  { double *tmp = &p->y; (void)tmp; }
  { double *tmp = &p->width; (void)tmp; }
  { double *tmp = &p->height; (void)tmp; }
}
struct _cffi_align_struct_wlr_fbox { char x; struct wlr_fbox y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1(struct wlr_foreign_toplevel_handle_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_source; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  (void)((p->state) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1.state' is an integer */
  /* cannot generate 'struct $9' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1 { char x; struct wlr_foreign_toplevel_handle_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_activated_event(struct wlr_foreign_toplevel_handle_v1_activated_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_activated_event { char x; struct wlr_foreign_toplevel_handle_v1_activated_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event(struct wlr_foreign_toplevel_handle_v1_fullscreen_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_fullscreen_event.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event { char x; struct wlr_foreign_toplevel_handle_v1_fullscreen_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_maximized_event(struct wlr_foreign_toplevel_handle_v1_maximized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->maximized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_maximized_event.maximized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_maximized_event { char x; struct wlr_foreign_toplevel_handle_v1_maximized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_minimized_event(struct wlr_foreign_toplevel_handle_v1_minimized_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  (void)((p->minimized) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_minimized_event.minimized' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_minimized_event { char x; struct wlr_foreign_toplevel_handle_v1_minimized_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_foreign_toplevel_handle_v1 * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_foreign_toplevel_handle_v1_set_rectangle_event.height' is an integer */
}
struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event { char x; struct wlr_foreign_toplevel_handle_v1_set_rectangle_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_foreign_toplevel_manager_v1(struct wlr_foreign_toplevel_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_event_loop * *tmp = &p->event_loop; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->toplevels; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $8' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_foreign_toplevel_manager_v1 { char x; struct wlr_foreign_toplevel_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_gamma_control_manager_v1(struct wlr_gamma_control_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->controls; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $10' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_gamma_control_manager_v1 { char x; struct wlr_gamma_control_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle(struct wlr_idle *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->idle_timers; (void)tmp; }
  { struct wl_event_loop * *tmp = &p->event_loop; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_idle.enabled' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $11' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle { char x; struct wlr_idle y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibit_manager_v1(struct wlr_idle_inhibit_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->inhibitors; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $13' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibit_manager_v1 { char x; struct wlr_idle_inhibit_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_inhibitor_v1(struct wlr_idle_inhibitor_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $14' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_inhibitor_v1 { char x; struct wlr_idle_inhibitor_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_idle_timeout(struct wlr_idle_timeout *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_source; (void)tmp; }
  (void)((p->idle_state) | 0);  /* check that 'struct wlr_idle_timeout.idle_state' is an integer */
  (void)((p->enabled) | 0);  /* check that 'struct wlr_idle_timeout.enabled' is an integer */
  (void)((p->timeout) | 0);  /* check that 'struct wlr_idle_timeout.timeout' is an integer */
  /* cannot generate 'struct $12' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->input_listener; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_idle_timeout { char x; struct wlr_idle_timeout y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_device(struct wlr_input_device *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device_impl const * *tmp = &p->impl; (void)tmp; }
  { enum wlr_input_device_type *tmp = &p->type; (void)tmp; }
  (void)((p->vendor) | 0);  /* check that 'struct wlr_input_device.vendor' is an integer */
  (void)((p->product) | 0);  /* check that 'struct wlr_input_device.product' is an integer */
  { char * *tmp = &p->name; (void)tmp; }
  { double *tmp = &p->width_mm; (void)tmp; }
  { double *tmp = &p->height_mm; (void)tmp; }
  { char * *tmp = &p->output_name; (void)tmp; }
  { void * *tmp = &p->_device; (void)tmp; }
  { struct wlr_keyboard * *tmp = &p->keyboard; (void)tmp; }
  { struct wlr_pointer * *tmp = &p->pointer; (void)tmp; }
  { struct wlr_switch * *tmp = &p->switch_device; (void)tmp; }
  { struct wlr_touch * *tmp = &p->touch; (void)tmp; }
  { struct wlr_tablet * *tmp = &p->tablet; (void)tmp; }
  { struct wlr_tablet_pad * *tmp = &p->tablet_pad; (void)tmp; }
  /* cannot generate 'struct $16' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_device { char x; struct wlr_input_device y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_input_inhibit_manager(struct wlr_input_inhibit_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_client * *tmp = &p->active_client; (void)tmp; }
  { struct wl_resource * *tmp = &p->active_inhibitor; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $17' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_input_inhibit_manager { char x; struct wlr_input_inhibit_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard(struct wlr_keyboard *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_keyboard_group * *tmp = &p->group; (void)tmp; }
  { char * *tmp = &p->keymap_string; (void)tmp; }
  (void)((p->keymap_size) | 0);  /* check that 'struct wlr_keyboard.keymap_size' is an integer */
  { struct xkb_keymap * *tmp = &p->keymap; (void)tmp; }
  { struct xkb_state * *tmp = &p->xkb_state; (void)tmp; }
  { uint32_t(*tmp)[3] = &p->led_indexes; (void)tmp; }
  { uint32_t(*tmp)[8] = &p->mod_indexes; (void)tmp; }
  { uint32_t(*tmp)[32] = &p->keycodes; (void)tmp; }
  (void)((p->num_keycodes) | 0);  /* check that 'struct wlr_keyboard.num_keycodes' is an integer */
  { struct wlr_keyboard_modifiers *tmp = &p->modifiers; (void)tmp; }
  /* cannot generate 'struct $18' in field 'repeat_info': unknown type name */
  /* cannot generate 'struct $19' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_keyboard { char x; struct wlr_keyboard y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_keyboard_modifiers(struct wlr_keyboard_modifiers *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->depressed) | 0);  /* check that 'struct wlr_keyboard_modifiers.depressed' is an integer */
  (void)((p->latched) | 0);  /* check that 'struct wlr_keyboard_modifiers.latched' is an integer */
  (void)((p->locked) | 0);  /* check that 'struct wlr_keyboard_modifiers.locked' is an integer */
  (void)((p->group) | 0);  /* check that 'struct wlr_keyboard_modifiers.group' is an integer */
}
struct _cffi_align_struct_wlr_keyboard_modifiers { char x; struct wlr_keyboard_modifiers y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_shell_v1(struct wlr_layer_shell_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $52' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_shell_v1 { char x; struct wlr_layer_shell_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1(struct wlr_layer_surface_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_layer_shell_v1 * *tmp = &p->shell; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  { char * *tmp = &p->namespace; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_layer_surface_v1.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_layer_surface_v1.configured' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_layer_surface_v1.mapped' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_layer_surface_v1_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  /* cannot generate 'struct $54' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1 { char x; struct wlr_layer_surface_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_layer_surface_v1_state(struct wlr_layer_surface_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->anchor) | 0);  /* check that 'struct wlr_layer_surface_v1_state.anchor' is an integer */
  (void)((p->exclusive_zone) | 0);  /* check that 'struct wlr_layer_surface_v1_state.exclusive_zone' is an integer */
  /* cannot generate 'struct $53' in field 'margin': unknown type name */
  { enum zwlr_layer_surface_v1_keyboard_interactivity *tmp = &p->keyboard_interactive; (void)tmp; }
  (void)((p->desired_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_width' is an integer */
  (void)((p->desired_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.desired_height' is an integer */
  (void)((p->actual_width) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_width' is an integer */
  (void)((p->actual_height) | 0);  /* check that 'struct wlr_layer_surface_v1_state.actual_height' is an integer */
  { enum zwlr_layer_shell_v1_layer *tmp = &p->layer; (void)tmp; }
}
struct _cffi_align_struct_wlr_layer_surface_v1_state { char x; struct wlr_layer_surface_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output(struct wlr_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_impl const * *tmp = &p->impl; (void)tmp; }
  { struct wlr_backend * *tmp = &p->backend; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->description; (void)tmp; }
  { char(*tmp)[56] = &p->make; (void)tmp; }
  { char(*tmp)[16] = &p->model; (void)tmp; }
  { char(*tmp)[16] = &p->serial; (void)tmp; }
  (void)((p->phys_width) | 0);  /* check that 'struct wlr_output.phys_width' is an integer */
  (void)((p->phys_height) | 0);  /* check that 'struct wlr_output.phys_height' is an integer */
  { struct wl_list *tmp = &p->modes; (void)tmp; }
  { struct wlr_output_mode * *tmp = &p->current_mode; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_output.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_output.height' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct wlr_output.refresh' is an integer */
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output.enabled' is an integer */
  { float *tmp = &p->scale; (void)tmp; }
  { enum wl_output_subpixel *tmp = &p->subpixel; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->needs_frame) | 0);  /* check that 'struct wlr_output.needs_frame' is an integer */
  (void)((p->frame_pending) | 0);  /* check that 'struct wlr_output.frame_pending' is an integer */
  { float(*tmp)[9] = &p->transform_matrix; (void)tmp; }
  { struct wlr_output_state *tmp = &p->pending; (void)tmp; }
  /* cannot generate 'struct $20' in field 'events': unknown type name */
  { struct wl_event_source * *tmp = &p->idle_frame; (void)tmp; }
  { struct wl_event_source * *tmp = &p->idle_done; (void)tmp; }
  (void)((p->attach_render_locks) | 0);  /* check that 'struct wlr_output.attach_render_locks' is an integer */
  { struct wl_list *tmp = &p->cursors; (void)tmp; }
  { struct wlr_output_cursor * *tmp = &p->hardware_cursor; (void)tmp; }
  (void)((p->software_cursor_locks) | 0);  /* check that 'struct wlr_output.software_cursor_locks' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output { char x; struct wlr_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_head_v1(struct wlr_output_configuration_head_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output_head_v1_state *tmp = &p->state; (void)tmp; }
  { struct wlr_output_configuration_v1 * *tmp = &p->config; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_head_v1 { char x; struct wlr_output_configuration_head_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_configuration_v1(struct wlr_output_configuration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  { struct wlr_output_manager_v1 * *tmp = &p->manager; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_configuration_v1.serial' is an integer */
  (void)((p->finalized) | 0);  /* check that 'struct wlr_output_configuration_v1.finalized' is an integer */
  (void)((p->finished) | 0);  /* check that 'struct wlr_output_configuration_v1.finished' is an integer */
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_configuration_v1 { char x; struct wlr_output_configuration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_damage(struct wlr_output_damage *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->max_rects) | 0);  /* check that 'struct wlr_output_damage.max_rects' is an integer */
  { struct pixman_region32 *tmp = &p->current; (void)tmp; }
  { struct pixman_region32(*tmp)[2] = &p->previous; (void)tmp; }
  (void)((p->previous_idx) | 0);  /* check that 'struct wlr_output_damage.previous_idx' is an integer */
  (void)((p->pending_attach_render) | 0);  /* check that 'struct wlr_output_damage.pending_attach_render' is an integer */
  /* cannot generate 'struct $21' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->output_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->output_mode; (void)tmp; }
  { struct wl_listener *tmp = &p->output_needs_frame; (void)tmp; }
  { struct wl_listener *tmp = &p->output_damage; (void)tmp; }
  { struct wl_listener *tmp = &p->output_frame; (void)tmp; }
  { struct wl_listener *tmp = &p->output_precommit; (void)tmp; }
  { struct wl_listener *tmp = &p->output_commit; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_damage { char x; struct wlr_output_damage y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_head_v1_state(struct wlr_output_head_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_output_head_v1_state.enabled' is an integer */
  { struct wlr_output_mode * *tmp = &p->mode; (void)tmp; }
  /* cannot generate 'struct $24' in field 'custom_mode': unknown type name */
  (void)((p->x) | 0);  /* check that 'struct wlr_output_head_v1_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_output_head_v1_state.y' is an integer */
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  { float *tmp = &p->scale; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_head_v1_state { char x; struct wlr_output_head_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_layout(struct wlr_output_layout *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  { struct wlr_output_layout_state * *tmp = &p->state; (void)tmp; }
  /* cannot generate 'struct $22' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_layout { char x; struct wlr_output_layout y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_manager_v1(struct wlr_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->heads; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_output_manager_v1.serial' is an integer */
  (void)((p->current_configuration_dirty) | 0);  /* check that 'struct wlr_output_manager_v1.current_configuration_dirty' is an integer */
  /* cannot generate 'struct $23' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_manager_v1 { char x; struct wlr_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_manager_v1(struct wlr_output_power_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->output_powers; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $25' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_manager_v1 { char x; struct wlr_output_power_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1(struct wlr_output_power_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wlr_output_power_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->output_destroy_listener; (void)tmp; }
  { struct wl_listener *tmp = &p->output_commit_listener; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1 { char x; struct wlr_output_power_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_power_v1_set_mode_event(struct wlr_output_power_v1_set_mode_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { enum zwlr_output_power_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_output_power_v1_set_mode_event { char x; struct wlr_output_power_v1_set_mode_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_output_state(struct wlr_output_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_output_state { char x; struct wlr_output_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer(struct wlr_pointer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_impl const * *tmp = &p->impl; (void)tmp; }
  /* cannot generate 'struct $26' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer { char x; struct wlr_pointer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1(struct wlr_pointer_constraint_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_constraints_v1 * *tmp = &p->pointer_constraints; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { enum zwp_pointer_constraints_v1_lifetime *tmp = &p->lifetime; (void)tmp; }
  { enum wlr_pointer_constraint_v1_type *tmp = &p->type; (void)tmp; }
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_pointer_constraint_v1_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $28' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraint_v1 { char x; struct wlr_pointer_constraint_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraint_v1_state(struct wlr_pointer_constraint_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_pointer_constraint_v1_state.committed' is an integer */
  { struct pixman_region32 *tmp = &p->region; (void)tmp; }
  /* cannot generate 'struct $27' in field 'cursor_hint': unknown type name */
}
struct _cffi_align_struct_wlr_pointer_constraint_v1_state { char x; struct wlr_pointer_constraint_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_pointer_constraints_v1(struct wlr_pointer_constraints_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->constraints; (void)tmp; }
  /* cannot generate 'struct $29' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_pointer_constraints_v1 { char x; struct wlr_pointer_constraints_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_primary_selection_v1_device_manager(struct wlr_primary_selection_v1_device_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->devices; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $30' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_primary_selection_v1_device_manager { char x; struct wlr_primary_selection_v1_device_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_manager_v1(struct wlr_relative_pointer_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->relative_pointers; (void)tmp; }
  /* cannot generate 'struct $31' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_manager_v1 { char x; struct wlr_relative_pointer_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_relative_pointer_v1(struct wlr_relative_pointer_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_resource * *tmp = &p->pointer_resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $32' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_relative_pointer_v1 { char x; struct wlr_relative_pointer_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene(struct wlr_scene *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_scene_node *tmp = &p->node; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene { char x; struct wlr_scene y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_node(struct wlr_scene_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_scene_node_type *tmp = &p->type; (void)tmp; }
  { struct wlr_scene_node * *tmp = &p->parent; (void)tmp; }
  { struct wlr_scene_node_state *tmp = &p->state; (void)tmp; }
  /* cannot generate 'struct $33' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_scene_node { char x; struct wlr_scene_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_scene_node_state(struct wlr_scene_node_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_list *tmp = &p->children; (void)tmp; }
  (void)((p->enabled) | 0);  /* check that 'struct wlr_scene_node_state.enabled' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_scene_node_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_scene_node_state.y' is an integer */
}
struct _cffi_align_struct_wlr_scene_node_state { char x; struct wlr_scene_node_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_screencopy_manager_v1(struct wlr_screencopy_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->frames; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $34' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_screencopy_manager_v1 { char x; struct wlr_screencopy_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat(struct wlr_seat *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_display * *tmp = &p->display; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  (void)((p->capabilities) | 0);  /* check that 'struct wlr_seat.capabilities' is an integer */
  { struct timespec *tmp = &p->last_event; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->selection_source; (void)tmp; }
  (void)((p->selection_serial) | 0);  /* check that 'struct wlr_seat.selection_serial' is an integer */
  { struct wl_list *tmp = &p->selection_offers; (void)tmp; }
  { struct wlr_primary_selection_source * *tmp = &p->primary_selection_source; (void)tmp; }
  (void)((p->primary_selection_serial) | 0);  /* check that 'struct wlr_seat.primary_selection_serial' is an integer */
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_data_source * *tmp = &p->drag_source; (void)tmp; }
  (void)((p->drag_serial) | 0);  /* check that 'struct wlr_seat.drag_serial' is an integer */
  { struct wl_list *tmp = &p->drag_offers; (void)tmp; }
  { struct wlr_seat_pointer_state *tmp = &p->pointer_state; (void)tmp; }
  { struct wlr_seat_keyboard_state *tmp = &p->keyboard_state; (void)tmp; }
  { struct wlr_seat_touch_state *tmp = &p->touch_state; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->primary_selection_source_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->drag_source_destroy; (void)tmp; }
  /* cannot generate 'struct $37' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat { char x; struct wlr_seat y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_focus_change_event(struct wlr_seat_keyboard_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_focus_change_event { char x; struct wlr_seat_keyboard_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_grab(struct wlr_seat_keyboard_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_keyboard_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_keyboard_grab { char x; struct wlr_seat_keyboard_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_keyboard_state(struct wlr_seat_keyboard_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_keyboard * *tmp = &p->keyboard; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_keymap; (void)tmp; }
  { struct wl_listener *tmp = &p->keyboard_repeat_info; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_keyboard_grab * *tmp = &p->default_grab; (void)tmp; }
  /* cannot generate 'struct $36' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_keyboard_state { char x; struct wlr_seat_keyboard_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_focus_change_event(struct wlr_seat_pointer_focus_change_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_surface * *tmp = &p->old_surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->new_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_focus_change_event { char x; struct wlr_seat_pointer_focus_change_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_grab(struct wlr_seat_pointer_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_pointer_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_pointer_grab { char x; struct wlr_seat_pointer_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_request_set_cursor_event(struct wlr_seat_pointer_request_set_cursor_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat_client * *tmp = &p->seat_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.serial' is an integer */
  (void)((p->hotspot_x) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_x' is an integer */
  (void)((p->hotspot_y) | 0);  /* check that 'struct wlr_seat_pointer_request_set_cursor_event.hotspot_y' is an integer */
}
struct _cffi_align_struct_wlr_seat_pointer_request_set_cursor_event { char x; struct wlr_seat_pointer_request_set_cursor_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_pointer_state(struct wlr_seat_pointer_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->focused_client; (void)tmp; }
  { struct wlr_surface * *tmp = &p->focused_surface; (void)tmp; }
  { double *tmp = &p->sx; (void)tmp; }
  { double *tmp = &p->sy; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->grab; (void)tmp; }
  { struct wlr_seat_pointer_grab * *tmp = &p->default_grab; (void)tmp; }
  { uint32_t(*tmp)[16] = &p->buttons; (void)tmp; }
  (void)((p->button_count) | 0);  /* check that 'struct wlr_seat_pointer_state.button_count' is an integer */
  (void)((p->grab_button) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_button' is an integer */
  (void)((p->grab_serial) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_serial' is an integer */
  (void)((p->grab_time) | 0);  /* check that 'struct wlr_seat_pointer_state.grab_time' is an integer */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  /* cannot generate 'struct $35' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_seat_pointer_state { char x; struct wlr_seat_pointer_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_set_primary_selection_event(struct wlr_seat_request_set_primary_selection_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_primary_selection_source * *tmp = &p->source; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_set_primary_selection_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_set_primary_selection_event { char x; struct wlr_seat_request_set_primary_selection_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_set_selection_event(struct wlr_seat_request_set_selection_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_data_source * *tmp = &p->source; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_set_selection_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_set_selection_event { char x; struct wlr_seat_request_set_selection_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_request_start_drag_event(struct wlr_seat_request_start_drag_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_drag * *tmp = &p->drag; (void)tmp; }
  { struct wlr_surface * *tmp = &p->origin; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_seat_request_start_drag_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_seat_request_start_drag_event { char x; struct wlr_seat_request_start_drag_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_grab(struct wlr_seat_touch_grab *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_touch_grab_interface const * *tmp = &p->interface; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_seat_touch_grab { char x; struct wlr_seat_touch_grab y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_seat_touch_state(struct wlr_seat_touch_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align_struct_wlr_seat_touch_state { char x; struct wlr_seat_touch_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_server_decoration_manager(struct wlr_server_decoration_manager *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->resources; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  (void)((p->default_mode) | 0);  /* check that 'struct wlr_server_decoration_manager.default_mode' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $38' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_server_decoration_manager { char x; struct wlr_server_decoration_manager y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subcompositor(struct wlr_subcompositor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
}
struct _cffi_align_struct_wlr_subcompositor { char x; struct wlr_subcompositor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface(struct wlr_subsurface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->current; (void)tmp; }
  { struct wlr_subsurface_parent_state *tmp = &p->pending; (void)tmp; }
  (void)((p->cached_seq) | 0);  /* check that 'struct wlr_subsurface.cached_seq' is an integer */
  (void)((p->has_cache) | 0);  /* check that 'struct wlr_subsurface.has_cache' is an integer */
  (void)((p->synchronized) | 0);  /* check that 'struct wlr_subsurface.synchronized' is an integer */
  (void)((p->reordered) | 0);  /* check that 'struct wlr_subsurface.reordered' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_subsurface.mapped' is an integer */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_destroy; (void)tmp; }
  /* cannot generate 'struct $40' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_subsurface { char x; struct wlr_subsurface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_subsurface_parent_state(struct wlr_subsurface_parent_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->x) | 0);  /* check that 'struct wlr_subsurface_parent_state.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_subsurface_parent_state.y' is an integer */
}
struct _cffi_align_struct_wlr_subsurface_parent_state { char x; struct wlr_subsurface_parent_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface(struct wlr_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_renderer * *tmp = &p->renderer; (void)tmp; }
  { struct wlr_client_buffer * *tmp = &p->buffer; (void)tmp; }
  (void)((p->sx) | 0);  /* check that 'struct wlr_surface.sx' is an integer */
  (void)((p->sy) | 0);  /* check that 'struct wlr_surface.sy' is an integer */
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque_region; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input_region; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_surface_state *tmp = &p->pending; (void)tmp; }
  { struct wl_list *tmp = &p->cached; (void)tmp; }
  { struct wlr_surface_role const * *tmp = &p->role; (void)tmp; }
  { void * *tmp = &p->role_data; (void)tmp; }
  /* cannot generate 'struct $39' in field 'events': unknown type name */
  { struct wl_list *tmp = &p->current_outputs; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
  { struct wl_listener *tmp = &p->renderer_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface { char x; struct wlr_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_output(struct wlr_surface_output *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_listener *tmp = &p->bind; (void)tmp; }
  { struct wl_listener *tmp = &p->destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_output { char x; struct wlr_surface_output y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_role(struct wlr_surface_role *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->commit; (void)tmp; }
  { void(* *tmp)(struct wlr_surface *) = &p->precommit; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_role { char x; struct wlr_surface_role y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_surface_state(struct wlr_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->committed) | 0);  /* check that 'struct wlr_surface_state.committed' is an integer */
  (void)((p->seq) | 0);  /* check that 'struct wlr_surface_state.seq' is an integer */
  { struct wlr_buffer * *tmp = &p->buffer; (void)tmp; }
  (void)((p->dx) | 0);  /* check that 'struct wlr_surface_state.dx' is an integer */
  (void)((p->dy) | 0);  /* check that 'struct wlr_surface_state.dy' is an integer */
  { struct pixman_region32 *tmp = &p->surface_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->buffer_damage; (void)tmp; }
  { struct pixman_region32 *tmp = &p->opaque; (void)tmp; }
  { struct pixman_region32 *tmp = &p->input; (void)tmp; }
  { enum wl_output_transform *tmp = &p->transform; (void)tmp; }
  (void)((p->scale) | 0);  /* check that 'struct wlr_surface_state.scale' is an integer */
  { struct wl_list *tmp = &p->frame_callback_list; (void)tmp; }
  (void)((p->width) | 0);  /* check that 'struct wlr_surface_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_surface_state.height' is an integer */
  (void)((p->buffer_width) | 0);  /* check that 'struct wlr_surface_state.buffer_width' is an integer */
  (void)((p->buffer_height) | 0);  /* check that 'struct wlr_surface_state.buffer_height' is an integer */
  { struct wl_list *tmp = &p->subsurfaces_below; (void)tmp; }
  { struct wl_list *tmp = &p->subsurfaces_above; (void)tmp; }
}
struct _cffi_align_struct_wlr_surface_state { char x; struct wlr_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_manager_v1(struct wlr_virtual_keyboard_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->virtual_keyboards; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $41' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_keyboard_manager_v1 { char x; struct wlr_virtual_keyboard_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_virtual_keyboard_v1(struct wlr_virtual_keyboard_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_input_device *tmp = &p->input_device; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  (void)((p->has_keymap) | 0);  /* check that 'struct wlr_virtual_keyboard_v1.has_keymap' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
  /* cannot generate 'struct $42' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_virtual_keyboard_v1 { char x; struct wlr_virtual_keyboard_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xcursor(struct wlr_xcursor *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->image_count) | 0);  /* check that 'struct wlr_xcursor.image_count' is an integer */
  { struct wlr_xcursor_image * * *tmp = &p->images; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  (void)((p->total_delay) | 0);  /* check that 'struct wlr_xcursor.total_delay' is an integer */
}
struct _cffi_align_struct_wlr_xcursor { char x; struct wlr_xcursor y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xcursor_image(struct wlr_xcursor_image *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->width) | 0);  /* check that 'struct wlr_xcursor_image.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xcursor_image.height' is an integer */
  (void)((p->hotspot_x) | 0);  /* check that 'struct wlr_xcursor_image.hotspot_x' is an integer */
  (void)((p->hotspot_y) | 0);  /* check that 'struct wlr_xcursor_image.hotspot_y' is an integer */
  (void)((p->delay) | 0);  /* check that 'struct wlr_xcursor_image.delay' is an integer */
  { uint8_t * *tmp = &p->buffer; (void)tmp; }
}
struct _cffi_align_struct_wlr_xcursor_image { char x; struct wlr_xcursor_image y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_client(struct wlr_xdg_client *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_shell * *tmp = &p->shell; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_list *tmp = &p->surfaces; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->ping_serial) | 0);  /* check that 'struct wlr_xdg_client.ping_serial' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_client { char x; struct wlr_xdg_client y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_decoration_manager_v1(struct wlr_xdg_decoration_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->decorations; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $43' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_decoration_manager_v1 { char x; struct wlr_xdg_decoration_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_output_manager_v1(struct wlr_xdg_output_manager_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wlr_output_layout * *tmp = &p->layout; (void)tmp; }
  { struct wl_list *tmp = &p->outputs; (void)tmp; }
  /* cannot generate 'struct $45' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_add; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_change; (void)tmp; }
  { struct wl_listener *tmp = &p->layout_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_output_manager_v1 { char x; struct wlr_xdg_output_manager_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_popup(struct wlr_xdg_popup *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  (void)((p->committed) | 0);  /* check that 'struct wlr_xdg_popup.committed' is an integer */
  { struct wlr_surface * *tmp = &p->parent; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
  { struct wlr_xdg_positioner *tmp = &p->positioner; (void)tmp; }
  { struct wl_list *tmp = &p->grab_link; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_popup { char x; struct wlr_xdg_popup y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_positioner(struct wlr_xdg_positioner *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_box *tmp = &p->anchor_rect; (void)tmp; }
  { enum xdg_positioner_anchor *tmp = &p->anchor; (void)tmp; }
  { enum xdg_positioner_gravity *tmp = &p->gravity; (void)tmp; }
  { enum xdg_positioner_constraint_adjustment *tmp = &p->constraint_adjustment; (void)tmp; }
  /* cannot generate 'struct $47' in field 'size': unknown type name */
  /* cannot generate 'struct $48' in field 'offset': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_positioner { char x; struct wlr_xdg_positioner y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_shell(struct wlr_xdg_shell *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_global * *tmp = &p->global; (void)tmp; }
  { struct wl_list *tmp = &p->clients; (void)tmp; }
  { struct wl_list *tmp = &p->popup_grabs; (void)tmp; }
  (void)((p->ping_timeout) | 0);  /* check that 'struct wlr_xdg_shell.ping_timeout' is an integer */
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  /* cannot generate 'struct $46' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_shell { char x; struct wlr_xdg_shell y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface(struct wlr_xdg_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_client * *tmp = &p->client; (void)tmp; }
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { enum wlr_xdg_surface_role *tmp = &p->role; (void)tmp; }
  { struct wlr_xdg_toplevel * *tmp = &p->toplevel; (void)tmp; }
  { struct wlr_xdg_popup * *tmp = &p->popup; (void)tmp; }
  { struct wl_list *tmp = &p->popups; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_surface.added' is an integer */
  (void)((p->configured) | 0);  /* check that 'struct wlr_xdg_surface.configured' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_xdg_surface.mapped' is an integer */
  { struct wl_event_source * *tmp = &p->configure_idle; (void)tmp; }
  (void)((p->scheduled_serial) | 0);  /* check that 'struct wlr_xdg_surface.scheduled_serial' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_surface_state *tmp = &p->pending; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  /* cannot generate 'struct $51' in field 'events': unknown type name */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface { char x; struct wlr_xdg_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_configure(struct wlr_xdg_surface_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_surface_configure.serial' is an integer */
  { struct wlr_xdg_toplevel_configure * *tmp = &p->toplevel_configure; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_configure { char x; struct wlr_xdg_surface_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_surface_state(struct wlr_xdg_surface_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->configure_serial) | 0);  /* check that 'struct wlr_xdg_surface_state.configure_serial' is an integer */
  { struct wlr_box *tmp = &p->geometry; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_surface_state { char x; struct wlr_xdg_surface_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel(struct wlr_xdg_toplevel *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_surface * *tmp = &p->base; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_toplevel.added' is an integer */
  { struct wlr_xdg_surface * *tmp = &p->parent; (void)tmp; }
  { struct wl_listener *tmp = &p->parent_unmap; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_state *tmp = &p->pending; (void)tmp; }
  { struct wlr_xdg_toplevel_configure *tmp = &p->scheduled; (void)tmp; }
  { struct wlr_xdg_toplevel_requested *tmp = &p->requested; (void)tmp; }
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->app_id; (void)tmp; }
  /* cannot generate 'struct $49' in field 'events': unknown type name */
}
struct _cffi_align_struct_wlr_xdg_toplevel { char x; struct wlr_xdg_toplevel y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_configure(struct wlr_xdg_toplevel_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_configure.height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_configure { char x; struct wlr_xdg_toplevel_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1(struct wlr_xdg_toplevel_decoration_v1 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_resource * *tmp = &p->resource; (void)tmp; }
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_xdg_decoration_manager_v1 * *tmp = &p->manager; (void)tmp; }
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->current; (void)tmp; }
  { struct wlr_xdg_toplevel_decoration_v1_state *tmp = &p->pending; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->scheduled_mode; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->requested_mode; (void)tmp; }
  (void)((p->added) | 0);  /* check that 'struct wlr_xdg_toplevel_decoration_v1.added' is an integer */
  { struct wl_list *tmp = &p->configure_list; (void)tmp; }
  /* cannot generate 'struct $44' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_ack_configure; (void)tmp; }
  { struct wl_listener *tmp = &p->surface_commit; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1 { char x; struct wlr_xdg_toplevel_decoration_v1 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_configure(struct wlr_xdg_toplevel_decoration_v1_configure *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wlr_xdg_surface_configure * *tmp = &p->surface_configure; (void)tmp; }
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_configure { char x; struct wlr_xdg_toplevel_decoration_v1_configure y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_decoration_v1_state(struct wlr_xdg_toplevel_decoration_v1_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { enum wlr_xdg_toplevel_decoration_v1_mode *tmp = &p->mode; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_state { char x; struct wlr_xdg_toplevel_decoration_v1_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_move_event(struct wlr_xdg_toplevel_move_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_move_event.serial' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_move_event { char x; struct wlr_xdg_toplevel_move_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_requested(struct wlr_xdg_toplevel_requested *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.maximized' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.minimized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_requested.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->fullscreen_output; (void)tmp; }
  { struct wl_listener *tmp = &p->fullscreen_output_destroy; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_requested { char x; struct wlr_xdg_toplevel_requested y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_resize_event(struct wlr_xdg_toplevel_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.serial' is an integer */
  (void)((p->edges) | 0);  /* check that 'struct wlr_xdg_toplevel_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_resize_event { char x; struct wlr_xdg_toplevel_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_set_fullscreen_event(struct wlr_xdg_toplevel_set_fullscreen_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_set_fullscreen_event.fullscreen' is an integer */
  { struct wlr_output * *tmp = &p->output; (void)tmp; }
}
struct _cffi_align_struct_wlr_xdg_toplevel_set_fullscreen_event { char x; struct wlr_xdg_toplevel_set_fullscreen_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_show_window_menu_event(struct wlr_xdg_toplevel_show_window_menu_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xdg_surface * *tmp = &p->surface; (void)tmp; }
  { struct wlr_seat_client * *tmp = &p->seat; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.serial' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xdg_toplevel_show_window_menu_event.y' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_show_window_menu_event { char x; struct wlr_xdg_toplevel_show_window_menu_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xdg_toplevel_state(struct wlr_xdg_toplevel_state *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->maximized) | 0);  /* check that 'struct wlr_xdg_toplevel_state.maximized' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xdg_toplevel_state.fullscreen' is an integer */
  (void)((p->resizing) | 0);  /* check that 'struct wlr_xdg_toplevel_state.resizing' is an integer */
  (void)((p->activated) | 0);  /* check that 'struct wlr_xdg_toplevel_state.activated' is an integer */
  (void)((p->tiled) | 0);  /* check that 'struct wlr_xdg_toplevel_state.tiled' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.max_height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'struct wlr_xdg_toplevel_state.min_height' is an integer */
}
struct _cffi_align_struct_wlr_xdg_toplevel_state { char x; struct wlr_xdg_toplevel_state y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland(struct wlr_xwayland *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_server * *tmp = &p->server; (void)tmp; }
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  { struct wlr_xwayland_cursor * *tmp = &p->cursor; (void)tmp; }
  { char const * *tmp = &p->display_name; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  { struct wlr_compositor * *tmp = &p->compositor; (void)tmp; }
  { struct wlr_seat * *tmp = &p->seat; (void)tmp; }
  /* cannot generate 'struct $56' in field 'events': unknown type name */
  { int(* *tmp)(struct wlr_xwm *, xcb_generic_event_t *) = &p->user_event_handler; (void)tmp; }
  { struct wl_listener *tmp = &p->server_ready; (void)tmp; }
  { struct wl_listener *tmp = &p->server_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->seat_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland { char x; struct wlr_xwayland y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_minimize_event(struct wlr_xwayland_minimize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->minimize) | 0);  /* check that 'struct wlr_xwayland_minimize_event.minimize' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_minimize_event { char x; struct wlr_xwayland_minimize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_move_event(struct wlr_xwayland_move_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_move_event { char x; struct wlr_xwayland_move_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_remove_startup_info_event(struct wlr_xwayland_remove_startup_info_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->id; (void)tmp; }
  (void)((p->window) | 0);  /* check that 'struct wlr_xwayland_remove_startup_info_event.window' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_remove_startup_info_event { char x; struct wlr_xwayland_remove_startup_info_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_resize_event(struct wlr_xwayland_resize_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->edges) | 0);  /* check that 'struct wlr_xwayland_resize_event.edges' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_resize_event { char x; struct wlr_xwayland_resize_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server(struct wlr_xwayland_server *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_server.pid' is an integer */
  { struct wl_client * *tmp = &p->client; (void)tmp; }
  { struct wl_event_source * *tmp = &p->pipe_source; (void)tmp; }
  { int(*tmp)[2] = &p->wm_fd; (void)tmp; }
  { int(*tmp)[2] = &p->wl_fd; (void)tmp; }
  (void)((p->server_start) | 0);  /* check that 'struct wlr_xwayland_server.server_start' is an integer */
  (void)((p->display) | 0);  /* check that 'struct wlr_xwayland_server.display' is an integer */
  { char(*tmp)[16] = &p->display_name; (void)tmp; }
  { int(*tmp)[2] = &p->x_fd; (void)tmp; }
  { struct wl_event_source *(*tmp)[2] = &p->x_fd_read_event; (void)tmp; }
  { struct wlr_xwayland_server_options *tmp = &p->options; (void)tmp; }
  { struct wl_display * *tmp = &p->wl_display; (void)tmp; }
  /* cannot generate 'struct $55' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->client_destroy; (void)tmp; }
  { struct wl_listener *tmp = &p->display_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_server { char x; struct wlr_xwayland_server y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_server_options(struct wlr_xwayland_server_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->lazy) | 0);  /* check that 'struct wlr_xwayland_server_options.lazy' is an integer */
  (void)((p->enable_wm) | 0);  /* check that 'struct wlr_xwayland_server_options.enable_wm' is an integer */
  (void)((p->no_touch_pointer_emulation) | 0);  /* check that 'struct wlr_xwayland_server_options.no_touch_pointer_emulation' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_server_options { char x; struct wlr_xwayland_server_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface(struct wlr_xwayland_surface *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->window_id) | 0);  /* check that 'struct wlr_xwayland_surface.window_id' is an integer */
  { struct wlr_xwm * *tmp = &p->xwm; (void)tmp; }
  (void)((p->surface_id) | 0);  /* check that 'struct wlr_xwayland_surface.surface_id' is an integer */
  { struct wl_list *tmp = &p->link; (void)tmp; }
  { struct wl_list *tmp = &p->stack_link; (void)tmp; }
  { struct wl_list *tmp = &p->unpaired_link; (void)tmp; }
  { struct wlr_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface.height' is an integer */
  (void)((p->saved_width) | 0);  /* check that 'struct wlr_xwayland_surface.saved_width' is an integer */
  (void)((p->saved_height) | 0);  /* check that 'struct wlr_xwayland_surface.saved_height' is an integer */
  (void)((p->override_redirect) | 0);  /* check that 'struct wlr_xwayland_surface.override_redirect' is an integer */
  (void)((p->mapped) | 0);  /* check that 'struct wlr_xwayland_surface.mapped' is an integer */
  { char * *tmp = &p->title; (void)tmp; }
  { char * *tmp = &p->class; (void)tmp; }
  { char * *tmp = &p->instance; (void)tmp; }
  { char * *tmp = &p->role; (void)tmp; }
  { char * *tmp = &p->startup_id; (void)tmp; }
  (void)((p->pid) | 0);  /* check that 'struct wlr_xwayland_surface.pid' is an integer */
  (void)((p->has_utf8_title) | 0);  /* check that 'struct wlr_xwayland_surface.has_utf8_title' is an integer */
  { struct wl_list *tmp = &p->children; (void)tmp; }
  { struct wlr_xwayland_surface * *tmp = &p->parent; (void)tmp; }
  { struct wl_list *tmp = &p->parent_link; (void)tmp; }
  { uint32_t * *tmp = &p->window_type; (void)tmp; }
  (void)((p->window_type_len) | 0);  /* check that 'struct wlr_xwayland_surface.window_type_len' is an integer */
  { uint32_t * *tmp = &p->protocols; (void)tmp; }
  (void)((p->protocols_len) | 0);  /* check that 'struct wlr_xwayland_surface.protocols_len' is an integer */
  (void)((p->decorations) | 0);  /* check that 'struct wlr_xwayland_surface.decorations' is an integer */
  { struct wlr_xwayland_surface_hints * *tmp = &p->hints; (void)tmp; }
  (void)((p->hints_urgency) | 0);  /* check that 'struct wlr_xwayland_surface.hints_urgency' is an integer */
  { struct wlr_xwayland_surface_size_hints * *tmp = &p->size_hints; (void)tmp; }
  (void)((p->pinging) | 0);  /* check that 'struct wlr_xwayland_surface.pinging' is an integer */
  { struct wl_event_source * *tmp = &p->ping_timer; (void)tmp; }
  (void)((p->modal) | 0);  /* check that 'struct wlr_xwayland_surface.modal' is an integer */
  (void)((p->fullscreen) | 0);  /* check that 'struct wlr_xwayland_surface.fullscreen' is an integer */
  (void)((p->maximized_vert) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_vert' is an integer */
  (void)((p->maximized_horz) | 0);  /* check that 'struct wlr_xwayland_surface.maximized_horz' is an integer */
  (void)((p->minimized) | 0);  /* check that 'struct wlr_xwayland_surface.minimized' is an integer */
  (void)((p->has_alpha) | 0);  /* check that 'struct wlr_xwayland_surface.has_alpha' is an integer */
  /* cannot generate 'struct $57' in field 'events': unknown type name */
  { struct wl_listener *tmp = &p->surface_destroy; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_wlr_xwayland_surface { char x; struct wlr_xwayland_surface y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_configure_event(struct wlr_xwayland_surface_configure_event *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct wlr_xwayland_surface * *tmp = &p->surface; (void)tmp; }
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.height' is an integer */
  (void)((p->mask) | 0);  /* check that 'struct wlr_xwayland_surface_configure_event.mask' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_configure_event { char x; struct wlr_xwayland_surface_configure_event y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_hints(struct wlr_xwayland_surface_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct wlr_xwayland_surface_hints.flags' is an integer */
  (void)((p->input) | 0);  /* check that 'struct wlr_xwayland_surface_hints.input' is an integer */
  (void)((p->initial_state) | 0);  /* check that 'struct wlr_xwayland_surface_hints.initial_state' is an integer */
  (void)((p->icon_pixmap) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_pixmap' is an integer */
  (void)((p->icon_window) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_window' is an integer */
  (void)((p->icon_x) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_x' is an integer */
  (void)((p->icon_y) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_y' is an integer */
  (void)((p->icon_mask) | 0);  /* check that 'struct wlr_xwayland_surface_hints.icon_mask' is an integer */
  (void)((p->window_group) | 0);  /* check that 'struct wlr_xwayland_surface_hints.window_group' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_hints { char x; struct wlr_xwayland_surface_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_wlr_xwayland_surface_size_hints(struct wlr_xwayland_surface_size_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.flags' is an integer */
  (void)((p->x) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.x' is an integer */
  (void)((p->y) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.y' is an integer */
  (void)((p->width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.width' is an integer */
  (void)((p->height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.height' is an integer */
  (void)((p->min_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_width' is an integer */
  (void)((p->min_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_height' is an integer */
  (void)((p->max_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_width' is an integer */
  (void)((p->max_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_height' is an integer */
  (void)((p->width_inc) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.width_inc' is an integer */
  (void)((p->height_inc) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.height_inc' is an integer */
  (void)((p->base_width) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.base_width' is an integer */
  (void)((p->base_height) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.base_height' is an integer */
  (void)((p->min_aspect_num) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_aspect_num' is an integer */
  (void)((p->min_aspect_den) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.min_aspect_den' is an integer */
  (void)((p->max_aspect_num) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_aspect_num' is an integer */
  (void)((p->max_aspect_den) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.max_aspect_den' is an integer */
  (void)((p->win_gravity) | 0);  /* check that 'struct wlr_xwayland_surface_size_hints.win_gravity' is an integer */
}
struct _cffi_align_struct_wlr_xwayland_surface_size_hints { char x; struct wlr_xwayland_surface_size_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_cookie_t(xcb_intern_atom_cookie_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align__xcb_intern_atom_cookie_t { char x; xcb_intern_atom_cookie_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__xcb_intern_atom_reply_t(xcb_intern_atom_reply_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->response_type) | 0);  /* check that 'xcb_intern_atom_reply_t.response_type' is an integer */
  (void)((p->pad0) | 0);  /* check that 'xcb_intern_atom_reply_t.pad0' is an integer */
  (void)((p->sequence) | 0);  /* check that 'xcb_intern_atom_reply_t.sequence' is an integer */
  (void)((p->length) | 0);  /* check that 'xcb_intern_atom_reply_t.length' is an integer */
  (void)((p->atom) | 0);  /* check that 'xcb_intern_atom_reply_t.atom' is an integer */
}
struct _cffi_align__xcb_intern_atom_reply_t { char x; xcb_intern_atom_reply_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_xkb_rule_names(struct xkb_rule_names *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->rules; (void)tmp; }
  { char const * *tmp = &p->model; (void)tmp; }
  { char const * *tmp = &p->layout; (void)tmp; }
  { char const * *tmp = &p->variant; (void)tmp; }
  { char const * *tmp = &p->options; (void)tmp; }
}
struct _cffi_align_struct_xkb_rule_names { char x; struct xkb_rule_names y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_union_wl_argument(union wl_argument *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->i) | 0);  /* check that 'union wl_argument.i' is an integer */
  (void)((p->u) | 0);  /* check that 'union wl_argument.u' is an integer */
  (void)((p->f) | 0);  /* check that 'union wl_argument.f' is an integer */
  { char const * *tmp = &p->s; (void)tmp; }
  { struct wl_object * *tmp = &p->o; (void)tmp; }
  (void)((p->n) | 0);  /* check that 'union wl_argument.n' is an integer */
  { struct wl_array * *tmp = &p->a; (void)tmp; }
  (void)((p->h) | 0);  /* check that 'union wl_argument.h' is an integer */
}
struct _cffi_align_union_wl_argument { char x; union wl_argument y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "CLOCK_MONOTONIC", (void *)_cffi_const_CLOCK_MONOTONIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_HORIZONTAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_HORIZONTAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_ORIENTATION_VERTICAL", (void *)_cffi_const_WLR_AXIS_ORIENTATION_VERTICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_CONTINUOUS", (void *)_cffi_const_WLR_AXIS_SOURCE_CONTINUOUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_FINGER", (void *)_cffi_const_WLR_AXIS_SOURCE_FINGER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_AXIS_SOURCE_WHEEL_TILT", (void *)_cffi_const_WLR_AXIS_SOURCE_WHEEL_TILT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_PRESSED", (void *)_cffi_const_WLR_BUTTON_PRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_BUTTON_RELEASED", (void *)_cffi_const_WLR_BUTTON_RELEASED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_DEBUG", (void *)_cffi_const_WLR_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_BOTTOM", (void *)_cffi_const_WLR_EDGE_BOTTOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_LEFT", (void *)_cffi_const_WLR_EDGE_LEFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_NONE", (void *)_cffi_const_WLR_EDGE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_RIGHT", (void *)_cffi_const_WLR_EDGE_RIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_EDGE_TOP", (void *)_cffi_const_WLR_EDGE_TOP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ERROR", (void *)_cffi_const_WLR_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_GLOBAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_GLOBAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_LOCAL", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_NONE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_ICCCM_INPUT_MODEL_PASSIVE", (void *)_cffi_const_WLR_ICCCM_INPUT_MODEL_PASSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INFO", (void *)_cffi_const_WLR_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_KEYBOARD", (void *)_cffi_const_WLR_INPUT_DEVICE_KEYBOARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_POINTER", (void *)_cffi_const_WLR_INPUT_DEVICE_POINTER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_SWITCH", (void *)_cffi_const_WLR_INPUT_DEVICE_SWITCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_PAD", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_PAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TABLET_TOOL", (void *)_cffi_const_WLR_INPUT_DEVICE_TABLET_TOOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_INPUT_DEVICE_TOUCH", (void *)_cffi_const_WLR_INPUT_DEVICE_TOUCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_KEYBOARD_KEYS_CAP", (void *)_cffi_const_WLR_KEYBOARD_KEYS_CAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_LED_CAPS_LOCK", (void *)_cffi_const_WLR_LED_CAPS_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_COUNT", (void *)_cffi_const_WLR_LED_COUNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_LED_NUM_LOCK", (void *)_cffi_const_WLR_LED_NUM_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_LED_SCROLL_LOCK", (void *)_cffi_const_WLR_LED_SCROLL_LOCK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_ALT", (void *)_cffi_const_WLR_MODIFIER_ALT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_CAPS", (void *)_cffi_const_WLR_MODIFIER_CAPS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_COUNT", (void *)_cffi_const_WLR_MODIFIER_COUNT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_MODIFIER_CTRL", (void *)_cffi_const_WLR_MODIFIER_CTRL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_LOGO", (void *)_cffi_const_WLR_MODIFIER_LOGO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD2", (void *)_cffi_const_WLR_MODIFIER_MOD2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD3", (void *)_cffi_const_WLR_MODIFIER_MOD3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_MOD5", (void *)_cffi_const_WLR_MODIFIER_MOD5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_MODIFIER_SHIFT", (void *)_cffi_const_WLR_MODIFIER_SHIFT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_OUTPUT_DAMAGE_PREVIOUS_LEN", (void *)_cffi_const_WLR_OUTPUT_DAMAGE_PREVIOUS_LEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_POINTER_BUTTONS_CAP", (void *)_cffi_const_WLR_POINTER_BUTTONS_CAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_CONFINED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_CONFINED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_LOCKED", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_POINTER_CONSTRAINT_V1_STATE_REGION", (void *)_cffi_const_WLR_POINTER_CONSTRAINT_V1_STATE_REGION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_NONE", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SERVER_DECORATION_MANAGER_MODE_SERVER", (void *)_cffi_const_WLR_SERVER_DECORATION_MANAGER_MODE_SERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_SILENT", (void *)_cffi_const_WLR_SILENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_VERSION_MAJOR", (void *)_cffi_const_WLR_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_VERSION_MICRO", (void *)_cffi_const_WLR_VERSION_MICRO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_VERSION_MINOR", (void *)_cffi_const_WLR_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_NONE", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_POPUP", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_POPUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_SURFACE_ROLE_TOPLEVEL", (void *)_cffi_const_WLR_XDG_SURFACE_ROLE_TOPLEVEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE", (void *)_cffi_const_WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_ALL", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE", (void *)_cffi_const_WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_CANCELLED", (void *)_cffi_const_XKB_COMPOSE_CANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSED", (void *)_cffi_const_XKB_COMPOSE_COMPOSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_COMPOSING", (void *)_cffi_const_XKB_COMPOSE_COMPOSING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_ACCEPTED", (void *)_cffi_const_XKB_COMPOSE_FEED_ACCEPTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FEED_IGNORED", (void *)_cffi_const_XKB_COMPOSE_FEED_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_COMPOSE_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_NOTHING", (void *)_cffi_const_XKB_COMPOSE_NOTHING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_COMPOSE_STATE_NO_FLAGS", (void *)_cffi_const_XKB_COMPOSE_STATE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_DEFAULT_INCLUDES", (void *)_cffi_const_XKB_CONTEXT_NO_DEFAULT_INCLUDES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_ENVIRONMENT_NAMES", (void *)_cffi_const_XKB_CONTEXT_NO_ENVIRONMENT_NAMES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_CONTEXT_NO_FLAGS", (void *)_cffi_const_XKB_CONTEXT_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_COMPILE_NO_FLAGS", (void *)_cffi_const_XKB_KEYMAP_COMPILE_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYMAP_FORMAT_TEXT_V1", (void *)_cffi_const_XKB_KEYMAP_FORMAT_TEXT_V1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_CASE_INSENSITIVE", (void *)_cffi_const_XKB_KEYSYM_CASE_INSENSITIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEYSYM_NO_FLAGS", (void *)_cffi_const_XKB_KEYSYM_NO_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_DOWN", (void *)_cffi_const_XKB_KEY_DOWN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_KEY_UP", (void *)_cffi_const_XKB_KEY_UP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_CRITICAL", (void *)_cffi_const_XKB_LOG_LEVEL_CRITICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_DEBUG", (void *)_cffi_const_XKB_LOG_LEVEL_DEBUG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_ERROR", (void *)_cffi_const_XKB_LOG_LEVEL_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_INFO", (void *)_cffi_const_XKB_LOG_LEVEL_INFO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_LOG_LEVEL_WARNING", (void *)_cffi_const_XKB_LOG_LEVEL_WARNING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_DEPRESSED", (void *)_cffi_const_XKB_STATE_LAYOUT_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_EFFECTIVE", (void *)_cffi_const_XKB_STATE_LAYOUT_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LATCHED", (void *)_cffi_const_XKB_STATE_LAYOUT_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LAYOUT_LOCKED", (void *)_cffi_const_XKB_STATE_LAYOUT_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_LEDS", (void *)_cffi_const_XKB_STATE_LEDS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ALL", (void *)_cffi_const_XKB_STATE_MATCH_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_ANY", (void *)_cffi_const_XKB_STATE_MATCH_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MATCH_NON_EXCLUSIVE", (void *)_cffi_const_XKB_STATE_MATCH_NON_EXCLUSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_DEPRESSED", (void *)_cffi_const_XKB_STATE_MODS_DEPRESSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_EFFECTIVE", (void *)_cffi_const_XKB_STATE_MODS_EFFECTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LATCHED", (void *)_cffi_const_XKB_STATE_MODS_LATCHED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XKB_STATE_MODS_LOCKED", (void *)_cffi_const_XKB_STATE_MODS_LOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "clock_gettime", (void *)_cffi_f_clock_gettime, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_clock_gettime },
  { "log_func_callback", (void *)&_cffi_externpy__log_func_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 420), (void *)log_func_callback },
  { "pixman_region32_fini", (void *)_cffi_f_pixman_region32_fini, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 460), (void *)_cffi_d_pixman_region32_fini },
  { "pixman_region32_init", (void *)_cffi_f_pixman_region32_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 460), (void *)_cffi_d_pixman_region32_init },
  { "pixman_region32_not_empty", (void *)_cffi_f_pixman_region32_not_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_pixman_region32_not_empty },
  { "pixman_region32_rectangles", (void *)_cffi_f_pixman_region32_rectangles, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 158), (void *)_cffi_d_pixman_region32_rectangles },
  { "surface_iterator_callback", (void *)&_cffi_externpy__surface_iterator_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 576), (void *)surface_iterator_callback },
  { "wlr_allocator_autocreate", (void *)_cffi_f_wlr_allocator_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 162), (void *)_cffi_d_wlr_allocator_autocreate },
  { "wlr_backend_autocreate", (void *)_cffi_f_wlr_backend_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 166), (void *)_cffi_d_wlr_backend_autocreate },
  { "wlr_backend_destroy", (void *)_cffi_f_wlr_backend_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 483), (void *)_cffi_d_wlr_backend_destroy },
  { "wlr_backend_get_session", (void *)_cffi_f_wlr_backend_get_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 292), (void *)_cffi_d_wlr_backend_get_session },
  { "wlr_backend_is_headless", (void *)_cffi_f_wlr_backend_is_headless, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wlr_backend_is_headless },
  { "wlr_backend_start", (void *)_cffi_f_wlr_backend_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_wlr_backend_start },
  { "wlr_box_closest_point", (void *)_cffi_f_wlr_box_closest_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 493), (void *)_cffi_d_wlr_box_closest_point },
  { "wlr_box_contains_point", (void *)_cffi_f_wlr_box_contains_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 14), (void *)_cffi_d_wlr_box_contains_point },
  { "wlr_box_empty", (void *)_cffi_f_wlr_box_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_wlr_box_empty },
  { "wlr_box_intersection", (void *)_cffi_f_wlr_box_intersection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 6), (void *)_cffi_d_wlr_box_intersection },
  { "wlr_box_transform", (void *)_cffi_f_wlr_box_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 486), (void *)_cffi_d_wlr_box_transform },
  { "wlr_compositor_create", (void *)_cffi_f_wlr_compositor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_wlr_compositor_create },
  { "wlr_cursor_attach_input_device", (void *)_cffi_f_wlr_cursor_attach_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 503), (void *)_cffi_d_wlr_cursor_attach_input_device },
  { "wlr_cursor_attach_output_layout", (void *)_cffi_f_wlr_cursor_attach_output_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 513), (void *)_cffi_d_wlr_cursor_attach_output_layout },
  { "wlr_cursor_create", (void *)_cffi_f_wlr_cursor_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 177), (void *)_cffi_d_wlr_cursor_create },
  { "wlr_cursor_destroy", (void *)_cffi_f_wlr_cursor_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 500), (void *)_cffi_d_wlr_cursor_destroy },
  { "wlr_cursor_move", (void *)_cffi_f_wlr_cursor_move, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 507), (void *)_cffi_d_wlr_cursor_move },
  { "wlr_cursor_set_surface", (void *)_cffi_f_wlr_cursor_set_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 517), (void *)_cffi_d_wlr_cursor_set_surface },
  { "wlr_cursor_warp", (void *)_cffi_f_wlr_cursor_warp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_wlr_cursor_warp },
  { "wlr_cursor_warp_absolute", (void *)_cffi_f_wlr_cursor_warp_absolute, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 507), (void *)_cffi_d_wlr_cursor_warp_absolute },
  { "wlr_cursor_warp_closest", (void *)_cffi_f_wlr_cursor_warp_closest, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 507), (void *)_cffi_d_wlr_cursor_warp_closest },
  { "wlr_data_control_manager_v1_create", (void *)_cffi_f_wlr_data_control_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 179), (void *)_cffi_d_wlr_data_control_manager_v1_create },
  { "wlr_data_device_manager_create", (void *)_cffi_f_wlr_data_device_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 182), (void *)_cffi_d_wlr_data_device_manager_create },
  { "wlr_data_source_destroy", (void *)_cffi_f_wlr_data_source_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 523), (void *)_cffi_d_wlr_data_source_destroy },
  { "wlr_foreign_toplevel_handle_v1_create", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 185), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_create },
  { "wlr_foreign_toplevel_handle_v1_destroy", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 526), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_destroy },
  { "wlr_foreign_toplevel_handle_v1_output_enter", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_output_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 541), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_output_enter },
  { "wlr_foreign_toplevel_handle_v1_output_leave", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_output_leave, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 541), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_output_leave },
  { "wlr_foreign_toplevel_handle_v1_set_activated", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 529), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_activated },
  { "wlr_foreign_toplevel_handle_v1_set_app_id", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_app_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 533), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_app_id },
  { "wlr_foreign_toplevel_handle_v1_set_fullscreen", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 529), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_fullscreen },
  { "wlr_foreign_toplevel_handle_v1_set_maximized", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 529), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_maximized },
  { "wlr_foreign_toplevel_handle_v1_set_minimized", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_minimized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 529), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_minimized },
  { "wlr_foreign_toplevel_handle_v1_set_parent", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_parent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 537), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_parent },
  { "wlr_foreign_toplevel_handle_v1_set_title", (void *)_cffi_f_wlr_foreign_toplevel_handle_v1_set_title, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 533), (void *)_cffi_d_wlr_foreign_toplevel_handle_v1_set_title },
  { "wlr_foreign_toplevel_manager_v1_create", (void *)_cffi_f_wlr_foreign_toplevel_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_wlr_foreign_toplevel_manager_v1_create },
  { "wlr_gamma_control_manager_v1_create", (void *)_cffi_f_wlr_gamma_control_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 191), (void *)_cffi_d_wlr_gamma_control_manager_v1_create },
  { "wlr_headless_add_input_device", (void *)_cffi_f_wlr_headless_add_input_device, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 205), (void *)_cffi_d_wlr_headless_add_input_device },
  { "wlr_headless_add_output", (void *)_cffi_f_wlr_headless_add_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 225), (void *)_cffi_d_wlr_headless_add_output },
  { "wlr_headless_backend_create", (void *)_cffi_f_wlr_headless_backend_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 166), (void *)_cffi_d_wlr_headless_backend_create },
  { "wlr_idle_create", (void *)_cffi_f_wlr_idle_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 194), (void *)_cffi_d_wlr_idle_create },
  { "wlr_idle_inhibit_v1_create", (void *)_cffi_f_wlr_idle_inhibit_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 197), (void *)_cffi_d_wlr_idle_inhibit_v1_create },
  { "wlr_idle_notify_activity", (void *)_cffi_f_wlr_idle_notify_activity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 545), (void *)_cffi_d_wlr_idle_notify_activity },
  { "wlr_idle_set_enabled", (void *)_cffi_f_wlr_idle_set_enabled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 549), (void *)_cffi_d_wlr_idle_set_enabled },
  { "wlr_idle_timeout_create", (void *)_cffi_f_wlr_idle_timeout_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_wlr_idle_timeout_create },
  { "wlr_idle_timeout_destroy", (void *)_cffi_f_wlr_idle_timeout_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 554), (void *)_cffi_d_wlr_idle_timeout_destroy },
  { "wlr_input_device_is_headless", (void *)_cffi_f_wlr_input_device_is_headless, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 25), (void *)_cffi_d_wlr_input_device_is_headless },
  { "wlr_input_device_is_libinput", (void *)_cffi_f_wlr_input_device_is_libinput, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 25), (void *)_cffi_d_wlr_input_device_is_libinput },
  { "wlr_input_inhibit_manager_create", (void *)_cffi_f_wlr_input_inhibit_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_wlr_input_inhibit_manager_create },
  { "wlr_keyboard_get_modifiers", (void *)_cffi_f_wlr_keyboard_get_modifiers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 377), (void *)_cffi_d_wlr_keyboard_get_modifiers },
  { "wlr_keyboard_set_keymap", (void *)_cffi_f_wlr_keyboard_set_keymap, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 562), (void *)_cffi_d_wlr_keyboard_set_keymap },
  { "wlr_keyboard_set_repeat_info", (void *)_cffi_f_wlr_keyboard_set_repeat_info, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_wlr_keyboard_set_repeat_info },
  { "wlr_layer_shell_v1_create", (void *)_cffi_f_wlr_layer_shell_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 215), (void *)_cffi_d_wlr_layer_shell_v1_create },
  { "wlr_layer_surface_v1_configure", (void *)_cffi_f_wlr_layer_surface_v1_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 569), (void *)_cffi_d_wlr_layer_surface_v1_configure },
  { "wlr_layer_surface_v1_destroy", (void *)_cffi_f_wlr_layer_surface_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 566), (void *)_cffi_d_wlr_layer_surface_v1_destroy },
  { "wlr_layer_surface_v1_for_each_surface", (void *)_cffi_f_wlr_layer_surface_v1_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 574), (void *)_cffi_d_wlr_layer_surface_v1_for_each_surface },
  { "wlr_layer_surface_v1_from_wlr_surface", (void *)_cffi_f_wlr_layer_surface_v1_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 218), (void *)_cffi_d_wlr_layer_surface_v1_from_wlr_surface },
  { "wlr_layer_surface_v1_surface_at", (void *)_cffi_f_wlr_layer_surface_v1_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 301), (void *)_cffi_d_wlr_layer_surface_v1_surface_at },
  { "wlr_libinput_get_device_handle", (void *)_cffi_f_wlr_libinput_get_device_handle, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 155), (void *)_cffi_d_wlr_libinput_get_device_handle },
  { "wlr_linux_dmabuf_v1_create", (void *)_cffi_f_wlr_linux_dmabuf_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 221), (void *)_cffi_d_wlr_linux_dmabuf_v1_create },
  { "wlr_matrix_identity", (void *)_cffi_f_wlr_matrix_identity, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 422), (void *)_cffi_d_wlr_matrix_identity },
  { "wlr_matrix_multiply", (void *)_cffi_f_wlr_matrix_multiply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 433), (void *)_cffi_d_wlr_matrix_multiply },
  { "wlr_matrix_project_box", (void *)_cffi_f_wlr_matrix_project_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 453), (void *)_cffi_d_wlr_matrix_project_box },
  { "wlr_matrix_projection", (void *)_cffi_f_wlr_matrix_projection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 447), (void *)_cffi_d_wlr_matrix_projection },
  { "wlr_matrix_rotate", (void *)_cffi_f_wlr_matrix_rotate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 438), (void *)_cffi_d_wlr_matrix_rotate },
  { "wlr_matrix_scale", (void *)_cffi_f_wlr_matrix_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 442), (void *)_cffi_d_wlr_matrix_scale },
  { "wlr_matrix_transform", (void *)_cffi_f_wlr_matrix_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 425), (void *)_cffi_d_wlr_matrix_transform },
  { "wlr_matrix_translate", (void *)_cffi_f_wlr_matrix_translate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 442), (void *)_cffi_d_wlr_matrix_translate },
  { "wlr_matrix_transpose", (void *)_cffi_f_wlr_matrix_transpose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 429), (void *)_cffi_d_wlr_matrix_transpose },
  { "wlr_output_attach_render", (void *)_cffi_f_wlr_output_attach_render, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 31), (void *)_cffi_d_wlr_output_attach_render },
  { "wlr_output_commit", (void *)_cffi_f_wlr_output_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_wlr_output_commit },
  { "wlr_output_configuration_head_v1_create", (void *)_cffi_f_wlr_output_configuration_head_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 235), (void *)_cffi_d_wlr_output_configuration_head_v1_create },
  { "wlr_output_configuration_v1_create", (void *)_cffi_f_wlr_output_configuration_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 239), (void *)_cffi_d_wlr_output_configuration_v1_create },
  { "wlr_output_configuration_v1_destroy", (void *)_cffi_f_wlr_output_configuration_v1_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 613), (void *)_cffi_d_wlr_output_configuration_v1_destroy },
  { "wlr_output_configuration_v1_send_failed", (void *)_cffi_f_wlr_output_configuration_v1_send_failed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 613), (void *)_cffi_d_wlr_output_configuration_v1_send_failed },
  { "wlr_output_configuration_v1_send_succeeded", (void *)_cffi_f_wlr_output_configuration_v1_send_succeeded, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 613), (void *)_cffi_d_wlr_output_configuration_v1_send_succeeded },
  { "wlr_output_create_global", (void *)_cffi_f_wlr_output_create_global, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 579), (void *)_cffi_d_wlr_output_create_global },
  { "wlr_output_damage_add", (void *)_cffi_f_wlr_output_damage_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 619), (void *)_cffi_d_wlr_output_damage_add },
  { "wlr_output_damage_add_box", (void *)_cffi_f_wlr_output_damage_add_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 623), (void *)_cffi_d_wlr_output_damage_add_box },
  { "wlr_output_damage_add_whole", (void *)_cffi_f_wlr_output_damage_add_whole, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 616), (void *)_cffi_d_wlr_output_damage_add_whole },
  { "wlr_output_damage_attach_render", (void *)_cffi_f_wlr_output_damage_attach_render, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_wlr_output_damage_attach_render },
  { "wlr_output_damage_create", (void *)_cffi_f_wlr_output_damage_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_wlr_output_damage_create },
  { "wlr_output_damage_destroy", (void *)_cffi_f_wlr_output_damage_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 616), (void *)_cffi_d_wlr_output_damage_destroy },
  { "wlr_output_destroy_global", (void *)_cffi_f_wlr_output_destroy_global, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 579), (void *)_cffi_d_wlr_output_destroy_global },
  { "wlr_output_effective_resolution", (void *)_cffi_f_wlr_output_effective_resolution, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 594), (void *)_cffi_d_wlr_output_effective_resolution },
  { "wlr_output_enable", (void *)_cffi_f_wlr_output_enable, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 582), (void *)_cffi_d_wlr_output_enable },
  { "wlr_output_init_render", (void *)_cffi_f_wlr_output_init_render, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 35), (void *)_cffi_d_wlr_output_init_render },
  { "wlr_output_is_headless", (void *)_cffi_f_wlr_output_is_headless, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_wlr_output_is_headless },
  { "wlr_output_layout_add", (void *)_cffi_f_wlr_output_layout_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 648), (void *)_cffi_d_wlr_output_layout_add },
  { "wlr_output_layout_add_auto", (void *)_cffi_f_wlr_output_layout_add_auto, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 630), (void *)_cffi_d_wlr_output_layout_add_auto },
  { "wlr_output_layout_closest_point", (void *)_cffi_f_wlr_output_layout_closest_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 640), (void *)_cffi_d_wlr_output_layout_closest_point },
  { "wlr_output_layout_create", (void *)_cffi_f_wlr_output_layout_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 244), (void *)_cffi_d_wlr_output_layout_create },
  { "wlr_output_layout_destroy", (void *)_cffi_f_wlr_output_layout_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 627), (void *)_cffi_d_wlr_output_layout_destroy },
  { "wlr_output_layout_get_box", (void *)_cffi_f_wlr_output_layout_get_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_wlr_output_layout_get_box },
  { "wlr_output_layout_move", (void *)_cffi_f_wlr_output_layout_move, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 648), (void *)_cffi_d_wlr_output_layout_move },
  { "wlr_output_layout_output_at", (void *)_cffi_f_wlr_output_layout_output_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 230), (void *)_cffi_d_wlr_output_layout_output_at },
  { "wlr_output_layout_output_coords", (void *)_cffi_f_wlr_output_layout_output_coords, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 634), (void *)_cffi_d_wlr_output_layout_output_coords },
  { "wlr_output_layout_remove", (void *)_cffi_f_wlr_output_layout_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 630), (void *)_cffi_d_wlr_output_layout_remove },
  { "wlr_output_manager_v1_create", (void *)_cffi_f_wlr_output_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 246), (void *)_cffi_d_wlr_output_manager_v1_create },
  { "wlr_output_manager_v1_set_configuration", (void *)_cffi_f_wlr_output_manager_v1_set_configuration, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 654), (void *)_cffi_d_wlr_output_manager_v1_set_configuration },
  { "wlr_output_power_manager_v1_create", (void *)_cffi_f_wlr_output_power_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 252), (void *)_cffi_d_wlr_output_power_manager_v1_create },
  { "wlr_output_preferred_mode", (void *)_cffi_f_wlr_output_preferred_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 249), (void *)_cffi_d_wlr_output_preferred_mode },
  { "wlr_output_render_software_cursors", (void *)_cffi_f_wlr_output_render_software_cursors, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 605), (void *)_cffi_d_wlr_output_render_software_cursors },
  { "wlr_output_rollback", (void *)_cffi_f_wlr_output_rollback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 579), (void *)_cffi_d_wlr_output_rollback },
  { "wlr_output_set_custom_mode", (void *)_cffi_f_wlr_output_set_custom_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 599), (void *)_cffi_d_wlr_output_set_custom_mode },
  { "wlr_output_set_damage", (void *)_cffi_f_wlr_output_set_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 605), (void *)_cffi_d_wlr_output_set_damage },
  { "wlr_output_set_mode", (void *)_cffi_f_wlr_output_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 609), (void *)_cffi_d_wlr_output_set_mode },
  { "wlr_output_set_scale", (void *)_cffi_f_wlr_output_set_scale, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 590), (void *)_cffi_d_wlr_output_set_scale },
  { "wlr_output_set_transform", (void *)_cffi_f_wlr_output_set_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 586), (void *)_cffi_d_wlr_output_set_transform },
  { "wlr_output_test", (void *)_cffi_f_wlr_output_test, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 28), (void *)_cffi_d_wlr_output_test },
  { "wlr_output_transform_invert", (void *)_cffi_f_wlr_output_transform_invert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_wlr_output_transform_invert },
  { "wlr_output_transformed_resolution", (void *)_cffi_f_wlr_output_transformed_resolution, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 594), (void *)_cffi_d_wlr_output_transformed_resolution },
  { "wlr_pointer_constraint_v1_send_activated", (void *)_cffi_f_wlr_pointer_constraint_v1_send_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 658), (void *)_cffi_d_wlr_pointer_constraint_v1_send_activated },
  { "wlr_pointer_constraint_v1_send_deactivated", (void *)_cffi_f_wlr_pointer_constraint_v1_send_deactivated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 658), (void *)_cffi_d_wlr_pointer_constraint_v1_send_deactivated },
  { "wlr_pointer_constraints_v1_constraint_for_surface", (void *)_cffi_f_wlr_pointer_constraints_v1_constraint_for_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 255), (void *)_cffi_d_wlr_pointer_constraints_v1_constraint_for_surface },
  { "wlr_pointer_constraints_v1_create", (void *)_cffi_f_wlr_pointer_constraints_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 260), (void *)_cffi_d_wlr_pointer_constraints_v1_create },
  { "wlr_primary_selection_v1_device_manager_create", (void *)_cffi_f_wlr_primary_selection_v1_device_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 263), (void *)_cffi_d_wlr_primary_selection_v1_device_manager_create },
  { "wlr_region_transform", (void *)_cffi_f_wlr_region_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 463), (void *)_cffi_d_wlr_region_transform },
  { "wlr_relative_pointer_manager_v1_create", (void *)_cffi_f_wlr_relative_pointer_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 266), (void *)_cffi_d_wlr_relative_pointer_manager_v1_create },
  { "wlr_relative_pointer_manager_v1_send_relative_motion", (void *)_cffi_f_wlr_relative_pointer_manager_v1_send_relative_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 661), (void *)_cffi_d_wlr_relative_pointer_manager_v1_send_relative_motion },
  { "wlr_render_rect", (void *)_cffi_f_wlr_render_rect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 686), (void *)_cffi_d_wlr_render_rect },
  { "wlr_render_texture", (void *)_cffi_f_wlr_render_texture, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 55), (void *)_cffi_d_wlr_render_texture },
  { "wlr_render_texture_with_matrix", (void *)_cffi_f_wlr_render_texture_with_matrix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_wlr_render_texture_with_matrix },
  { "wlr_renderer_autocreate", (void *)_cffi_f_wlr_renderer_autocreate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 269), (void *)_cffi_d_wlr_renderer_autocreate },
  { "wlr_renderer_begin", (void *)_cffi_f_wlr_renderer_begin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 677), (void *)_cffi_d_wlr_renderer_begin },
  { "wlr_renderer_clear", (void *)_cffi_f_wlr_renderer_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 673), (void *)_cffi_d_wlr_renderer_clear },
  { "wlr_renderer_destroy", (void *)_cffi_f_wlr_renderer_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 670), (void *)_cffi_d_wlr_renderer_destroy },
  { "wlr_renderer_end", (void *)_cffi_f_wlr_renderer_end, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 670), (void *)_cffi_d_wlr_renderer_end },
  { "wlr_renderer_get_shm_texture_formats", (void *)_cffi_f_wlr_renderer_get_shm_texture_formats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 373), (void *)_cffi_d_wlr_renderer_get_shm_texture_formats },
  { "wlr_renderer_init_wl_display", (void *)_cffi_f_wlr_renderer_init_wl_display, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 45), (void *)_cffi_d_wlr_renderer_init_wl_display },
  { "wlr_renderer_scissor", (void *)_cffi_f_wlr_renderer_scissor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 682), (void *)_cffi_d_wlr_renderer_scissor },
  { "wlr_scene_attach_output_layout", (void *)_cffi_f_wlr_scene_attach_output_layout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 63), (void *)_cffi_d_wlr_scene_attach_output_layout },
  { "wlr_scene_create", (void *)_cffi_f_wlr_scene_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 272), (void *)_cffi_d_wlr_scene_create },
  { "wlr_scene_get_scene_output", (void *)_cffi_f_wlr_scene_get_scene_output, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 278), (void *)_cffi_d_wlr_scene_get_scene_output },
  { "wlr_scene_node_lower_to_bottom", (void *)_cffi_f_wlr_scene_node_lower_to_bottom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 692), (void *)_cffi_d_wlr_scene_node_lower_to_bottom },
  { "wlr_scene_node_place_above", (void *)_cffi_f_wlr_scene_node_place_above, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 700), (void *)_cffi_d_wlr_scene_node_place_above },
  { "wlr_scene_node_place_below", (void *)_cffi_f_wlr_scene_node_place_below, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 700), (void *)_cffi_d_wlr_scene_node_place_below },
  { "wlr_scene_node_raise_to_top", (void *)_cffi_f_wlr_scene_node_raise_to_top, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 692), (void *)_cffi_d_wlr_scene_node_raise_to_top },
  { "wlr_scene_node_set_position", (void *)_cffi_f_wlr_scene_node_set_position, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 695), (void *)_cffi_d_wlr_scene_node_set_position },
  { "wlr_scene_output_commit", (void *)_cffi_f_wlr_scene_output_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 67), (void *)_cffi_d_wlr_scene_output_commit },
  { "wlr_scene_output_send_frame_done", (void *)_cffi_f_wlr_scene_output_send_frame_done, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 704), (void *)_cffi_d_wlr_scene_output_send_frame_done },
  { "wlr_scene_xdg_surface_create", (void *)_cffi_f_wlr_scene_xdg_surface_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 274), (void *)_cffi_d_wlr_scene_xdg_surface_create },
  { "wlr_screencopy_manager_v1_create", (void *)_cffi_f_wlr_screencopy_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 282), (void *)_cffi_d_wlr_screencopy_manager_v1_create },
  { "wlr_seat_create", (void *)_cffi_f_wlr_seat_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 285), (void *)_cffi_d_wlr_seat_create },
  { "wlr_seat_destroy", (void *)_cffi_f_wlr_seat_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_destroy },
  { "wlr_seat_get_keyboard", (void *)_cffi_f_wlr_seat_get_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 212), (void *)_cffi_d_wlr_seat_get_keyboard },
  { "wlr_seat_keyboard_clear_focus", (void *)_cffi_f_wlr_seat_keyboard_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_keyboard_clear_focus },
  { "wlr_seat_keyboard_end_grab", (void *)_cffi_f_wlr_seat_keyboard_end_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_keyboard_end_grab },
  { "wlr_seat_keyboard_has_grab", (void *)_cffi_f_wlr_seat_keyboard_has_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 70), (void *)_cffi_d_wlr_seat_keyboard_has_grab },
  { "wlr_seat_keyboard_notify_enter", (void *)_cffi_f_wlr_seat_keyboard_notify_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 752), (void *)_cffi_d_wlr_seat_keyboard_notify_enter },
  { "wlr_seat_keyboard_notify_key", (void *)_cffi_f_wlr_seat_keyboard_notify_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 789), (void *)_cffi_d_wlr_seat_keyboard_notify_key },
  { "wlr_seat_keyboard_notify_modifiers", (void *)_cffi_f_wlr_seat_keyboard_notify_modifiers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 729), (void *)_cffi_d_wlr_seat_keyboard_notify_modifiers },
  { "wlr_seat_keyboard_start_grab", (void *)_cffi_f_wlr_seat_keyboard_start_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 738), (void *)_cffi_d_wlr_seat_keyboard_start_grab },
  { "wlr_seat_pointer_clear_focus", (void *)_cffi_f_wlr_seat_pointer_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_pointer_clear_focus },
  { "wlr_seat_pointer_end_grab", (void *)_cffi_f_wlr_seat_pointer_end_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_pointer_end_grab },
  { "wlr_seat_pointer_has_grab", (void *)_cffi_f_wlr_seat_pointer_has_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 70), (void *)_cffi_d_wlr_seat_pointer_has_grab },
  { "wlr_seat_pointer_notify_axis", (void *)_cffi_f_wlr_seat_pointer_notify_axis, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 769), (void *)_cffi_d_wlr_seat_pointer_notify_axis },
  { "wlr_seat_pointer_notify_button", (void *)_cffi_f_wlr_seat_pointer_notify_button, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 388), (void *)_cffi_d_wlr_seat_pointer_notify_button },
  { "wlr_seat_pointer_notify_clear_focus", (void *)_cffi_f_wlr_seat_pointer_notify_clear_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_pointer_notify_clear_focus },
  { "wlr_seat_pointer_notify_enter", (void *)_cffi_f_wlr_seat_pointer_notify_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 746), (void *)_cffi_d_wlr_seat_pointer_notify_enter },
  { "wlr_seat_pointer_notify_frame", (void *)_cffi_f_wlr_seat_pointer_notify_frame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 708), (void *)_cffi_d_wlr_seat_pointer_notify_frame },
  { "wlr_seat_pointer_notify_motion", (void *)_cffi_f_wlr_seat_pointer_notify_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 763), (void *)_cffi_d_wlr_seat_pointer_notify_motion },
  { "wlr_seat_pointer_start_grab", (void *)_cffi_f_wlr_seat_pointer_start_grab, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 742), (void *)_cffi_d_wlr_seat_pointer_start_grab },
  { "wlr_seat_pointer_surface_has_focus", (void *)_cffi_f_wlr_seat_pointer_surface_has_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 73), (void *)_cffi_d_wlr_seat_pointer_surface_has_focus },
  { "wlr_seat_set_capabilities", (void *)_cffi_f_wlr_seat_set_capabilities, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 759), (void *)_cffi_d_wlr_seat_set_capabilities },
  { "wlr_seat_set_keyboard", (void *)_cffi_f_wlr_seat_set_keyboard, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 725), (void *)_cffi_d_wlr_seat_set_keyboard },
  { "wlr_seat_set_name", (void *)_cffi_f_wlr_seat_set_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 711), (void *)_cffi_d_wlr_seat_set_name },
  { "wlr_seat_set_primary_selection", (void *)_cffi_f_wlr_seat_set_primary_selection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 733), (void *)_cffi_d_wlr_seat_set_primary_selection },
  { "wlr_seat_set_selection", (void *)_cffi_f_wlr_seat_set_selection, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 715), (void *)_cffi_d_wlr_seat_set_selection },
  { "wlr_seat_start_pointer_drag", (void *)_cffi_f_wlr_seat_start_pointer_drag, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 720), (void *)_cffi_d_wlr_seat_start_pointer_drag },
  { "wlr_seat_touch_notify_down", (void *)_cffi_f_wlr_seat_touch_notify_down, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 380), (void *)_cffi_d_wlr_seat_touch_notify_down },
  { "wlr_seat_touch_notify_motion", (void *)_cffi_f_wlr_seat_touch_notify_motion, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 782), (void *)_cffi_d_wlr_seat_touch_notify_motion },
  { "wlr_seat_touch_notify_up", (void *)_cffi_f_wlr_seat_touch_notify_up, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 777), (void *)_cffi_d_wlr_seat_touch_notify_up },
  { "wlr_seat_validate_pointer_grab_serial", (void *)_cffi_f_wlr_seat_validate_pointer_grab_serial, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_wlr_seat_validate_pointer_grab_serial },
  { "wlr_server_decoration_manager_create", (void *)_cffi_f_wlr_server_decoration_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 289), (void *)_cffi_d_wlr_server_decoration_manager_create },
  { "wlr_server_decoration_manager_set_default_mode", (void *)_cffi_f_wlr_server_decoration_manager_set_default_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 795), (void *)_cffi_d_wlr_server_decoration_manager_set_default_mode },
  { "wlr_session_change_vt", (void *)_cffi_f_wlr_session_change_vt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 82), (void *)_cffi_d_wlr_session_change_vt },
  { "wlr_subsurface_from_wlr_surface", (void *)_cffi_f_wlr_subsurface_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 295), (void *)_cffi_d_wlr_subsurface_from_wlr_surface },
  { "wlr_surface_for_each_surface", (void *)_cffi_f_wlr_surface_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 832), (void *)_cffi_d_wlr_surface_for_each_surface },
  { "wlr_surface_from_resource", (void *)_cffi_f_wlr_surface_from_resource, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 298), (void *)_cffi_d_wlr_surface_from_resource },
  { "wlr_surface_get_buffer_source_box", (void *)_cffi_f_wlr_surface_get_buffer_source_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 820), (void *)_cffi_d_wlr_surface_get_buffer_source_box },
  { "wlr_surface_get_effective_damage", (void *)_cffi_f_wlr_surface_get_effective_damage, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 808), (void *)_cffi_d_wlr_surface_get_effective_damage },
  { "wlr_surface_get_extends", (void *)_cffi_f_wlr_surface_get_extends, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 816), (void *)_cffi_d_wlr_surface_get_extends },
  { "wlr_surface_get_root_surface", (void *)_cffi_f_wlr_surface_get_root_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 308), (void *)_cffi_d_wlr_surface_get_root_surface },
  { "wlr_surface_get_texture", (void *)_cffi_f_wlr_surface_get_texture, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 333), (void *)_cffi_d_wlr_surface_get_texture },
  { "wlr_surface_has_buffer", (void *)_cffi_f_wlr_surface_has_buffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_wlr_surface_has_buffer },
  { "wlr_surface_is_layer_surface", (void *)_cffi_f_wlr_surface_is_layer_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_wlr_surface_is_layer_surface },
  { "wlr_surface_is_subsurface", (void *)_cffi_f_wlr_surface_is_subsurface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_wlr_surface_is_subsurface },
  { "wlr_surface_is_xdg_surface", (void *)_cffi_f_wlr_surface_is_xdg_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_wlr_surface_is_xdg_surface },
  { "wlr_surface_is_xwayland_surface", (void *)_cffi_f_wlr_surface_is_xwayland_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 86), (void *)_cffi_d_wlr_surface_is_xwayland_surface },
  { "wlr_surface_lock_pending", (void *)_cffi_f_wlr_surface_lock_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 394), (void *)_cffi_d_wlr_surface_lock_pending },
  { "wlr_surface_point_accepts_input", (void *)_cffi_f_wlr_surface_point_accepts_input, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 89), (void *)_cffi_d_wlr_surface_point_accepts_input },
  { "wlr_surface_send_enter", (void *)_cffi_f_wlr_surface_send_enter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 824), (void *)_cffi_d_wlr_surface_send_enter },
  { "wlr_surface_send_frame_done", (void *)_cffi_f_wlr_surface_send_frame_done, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 812), (void *)_cffi_d_wlr_surface_send_frame_done },
  { "wlr_surface_send_leave", (void *)_cffi_f_wlr_surface_send_leave, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 824), (void *)_cffi_d_wlr_surface_send_leave },
  { "wlr_surface_set_role", (void *)_cffi_f_wlr_surface_set_role, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 94), (void *)_cffi_d_wlr_surface_set_role },
  { "wlr_surface_surface_at", (void *)_cffi_f_wlr_surface_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 311), (void *)_cffi_d_wlr_surface_surface_at },
  { "wlr_surface_unlock_cached", (void *)_cffi_f_wlr_surface_unlock_cached, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 828), (void *)_cffi_d_wlr_surface_unlock_cached },
  { "wlr_texture_destroy", (void *)_cffi_f_wlr_texture_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 837), (void *)_cffi_d_wlr_texture_destroy },
  { "wlr_texture_from_pixels", (void *)_cffi_f_wlr_texture_from_pixels, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 325), (void *)_cffi_d_wlr_texture_from_pixels },
  { "wlr_texture_write_pixels", (void *)_cffi_f_wlr_texture_write_pixels, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 101), (void *)_cffi_d_wlr_texture_write_pixels },
  { "wlr_virtual_keyboard_manager_v1_create", (void *)_cffi_f_wlr_virtual_keyboard_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 336), (void *)_cffi_d_wlr_virtual_keyboard_manager_v1_create },
  { "wlr_xcursor_manager_create", (void *)_cffi_f_wlr_xcursor_manager_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 344), (void *)_cffi_d_wlr_xcursor_manager_create },
  { "wlr_xcursor_manager_destroy", (void *)_cffi_f_wlr_xcursor_manager_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 840), (void *)_cffi_d_wlr_xcursor_manager_destroy },
  { "wlr_xcursor_manager_get_xcursor", (void *)_cffi_f_wlr_xcursor_manager_get_xcursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_wlr_xcursor_manager_get_xcursor },
  { "wlr_xcursor_manager_load", (void *)_cffi_f_wlr_xcursor_manager_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 134), (void *)_cffi_d_wlr_xcursor_manager_load },
  { "wlr_xcursor_manager_set_cursor_image", (void *)_cffi_f_wlr_xcursor_manager_set_cursor_image, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 843), (void *)_cffi_d_wlr_xcursor_manager_set_cursor_image },
  { "wlr_xdg_decoration_manager_v1_create", (void *)_cffi_f_wlr_xdg_decoration_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 348), (void *)_cffi_d_wlr_xdg_decoration_manager_v1_create },
  { "wlr_xdg_output_manager_v1_create", (void *)_cffi_f_wlr_xdg_output_manager_v1_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 351), (void *)_cffi_d_wlr_xdg_output_manager_v1_create },
  { "wlr_xdg_popup_destroy", (void *)_cffi_f_wlr_xdg_popup_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 852), (void *)_cffi_d_wlr_xdg_popup_destroy },
  { "wlr_xdg_popup_unconstrain_from_box", (void *)_cffi_f_wlr_xdg_popup_unconstrain_from_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 848), (void *)_cffi_d_wlr_xdg_popup_unconstrain_from_box },
  { "wlr_xdg_shell_create", (void *)_cffi_f_wlr_xdg_shell_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 355), (void *)_cffi_d_wlr_xdg_shell_create },
  { "wlr_xdg_surface_for_each_popup_surface", (void *)_cffi_f_wlr_xdg_surface_for_each_popup_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 859), (void *)_cffi_d_wlr_xdg_surface_for_each_popup_surface },
  { "wlr_xdg_surface_for_each_surface", (void *)_cffi_f_wlr_xdg_surface_for_each_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 859), (void *)_cffi_d_wlr_xdg_surface_for_each_surface },
  { "wlr_xdg_surface_from_wlr_surface", (void *)_cffi_f_wlr_xdg_surface_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 358), (void *)_cffi_d_wlr_xdg_surface_from_wlr_surface },
  { "wlr_xdg_surface_get_geometry", (void *)_cffi_f_wlr_xdg_surface_get_geometry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 855), (void *)_cffi_d_wlr_xdg_surface_get_geometry },
  { "wlr_xdg_surface_ping", (void *)_cffi_f_wlr_xdg_surface_ping, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 852), (void *)_cffi_d_wlr_xdg_surface_ping },
  { "wlr_xdg_surface_surface_at", (void *)_cffi_f_wlr_xdg_surface_surface_at, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 318), (void *)_cffi_d_wlr_xdg_surface_surface_at },
  { "wlr_xdg_toplevel_decoration_v1_set_mode", (void *)_cffi_f_wlr_xdg_toplevel_decoration_v1_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 410), (void *)_cffi_d_wlr_xdg_toplevel_decoration_v1_set_mode },
  { "wlr_xdg_toplevel_send_close", (void *)_cffi_f_wlr_xdg_toplevel_send_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 852), (void *)_cffi_d_wlr_xdg_toplevel_send_close },
  { "wlr_xdg_toplevel_set_activated", (void *)_cffi_f_wlr_xdg_toplevel_set_activated, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_wlr_xdg_toplevel_set_activated },
  { "wlr_xdg_toplevel_set_fullscreen", (void *)_cffi_f_wlr_xdg_toplevel_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_wlr_xdg_toplevel_set_fullscreen },
  { "wlr_xdg_toplevel_set_maximized", (void *)_cffi_f_wlr_xdg_toplevel_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_wlr_xdg_toplevel_set_maximized },
  { "wlr_xdg_toplevel_set_resizing", (void *)_cffi_f_wlr_xdg_toplevel_set_resizing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_wlr_xdg_toplevel_set_resizing },
  { "wlr_xdg_toplevel_set_size", (void *)_cffi_f_wlr_xdg_toplevel_set_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 405), (void *)_cffi_d_wlr_xdg_toplevel_set_size },
  { "wlr_xdg_toplevel_set_tiled", (void *)_cffi_f_wlr_xdg_toplevel_set_tiled, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 401), (void *)_cffi_d_wlr_xdg_toplevel_set_tiled },
  { "wlr_xwayland_create", (void *)_cffi_f_wlr_xwayland_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 361), (void *)_cffi_d_wlr_xwayland_create },
  { "wlr_xwayland_destroy", (void *)_cffi_f_wlr_xwayland_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 864), (void *)_cffi_d_wlr_xwayland_destroy },
  { "wlr_xwayland_icccm_input_model", (void *)_cffi_f_wlr_xwayland_icccm_input_model, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_wlr_xwayland_icccm_input_model },
  { "wlr_xwayland_or_surface_wants_focus", (void *)_cffi_f_wlr_xwayland_or_surface_wants_focus, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 112), (void *)_cffi_d_wlr_xwayland_or_surface_wants_focus },
  { "wlr_xwayland_server_create", (void *)_cffi_f_wlr_xwayland_server_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 366), (void *)_cffi_d_wlr_xwayland_server_create },
  { "wlr_xwayland_server_destroy", (void *)_cffi_f_wlr_xwayland_server_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 880), (void *)_cffi_d_wlr_xwayland_server_destroy },
  { "wlr_xwayland_set_cursor", (void *)_cffi_f_wlr_xwayland_set_cursor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 871), (void *)_cffi_d_wlr_xwayland_set_cursor },
  { "wlr_xwayland_set_seat", (void *)_cffi_f_wlr_xwayland_set_seat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 867), (void *)_cffi_d_wlr_xwayland_set_seat },
  { "wlr_xwayland_surface_activate", (void *)_cffi_f_wlr_xwayland_surface_activate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 886), (void *)_cffi_d_wlr_xwayland_surface_activate },
  { "wlr_xwayland_surface_close", (void *)_cffi_f_wlr_xwayland_surface_close, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 883), (void *)_cffi_d_wlr_xwayland_surface_close },
  { "wlr_xwayland_surface_configure", (void *)_cffi_f_wlr_xwayland_surface_configure, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 890), (void *)_cffi_d_wlr_xwayland_surface_configure },
  { "wlr_xwayland_surface_from_wlr_surface", (void *)_cffi_f_wlr_xwayland_surface_from_wlr_surface, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 370), (void *)_cffi_d_wlr_xwayland_surface_from_wlr_surface },
  { "wlr_xwayland_surface_ping", (void *)_cffi_f_wlr_xwayland_surface_ping, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 883), (void *)_cffi_d_wlr_xwayland_surface_ping },
  { "wlr_xwayland_surface_restack", (void *)_cffi_f_wlr_xwayland_surface_restack, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 897), (void *)_cffi_d_wlr_xwayland_surface_restack },
  { "wlr_xwayland_surface_set_fullscreen", (void *)_cffi_f_wlr_xwayland_surface_set_fullscreen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 886), (void *)_cffi_d_wlr_xwayland_surface_set_fullscreen },
  { "wlr_xwayland_surface_set_maximized", (void *)_cffi_f_wlr_xwayland_surface_set_maximized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 886), (void *)_cffi_d_wlr_xwayland_surface_set_maximized },
  { "wlr_xwayland_surface_set_minimized", (void *)_cffi_f_wlr_xwayland_surface_set_minimized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 886), (void *)_cffi_d_wlr_xwayland_surface_set_minimized },
  { "wrapped_log_init", (void *)_cffi_f_wrapped_log_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 418), (void *)_cffi_d_wrapped_log_init },
  { "xcb_connect", (void *)_cffi_f_xcb_connect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 913), (void *)_cffi_d_xcb_connect },
  { "xcb_connection_has_error", (void *)_cffi_f_xcb_connection_has_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_xcb_connection_has_error },
  { "xcb_disconnect", (void *)_cffi_f_xcb_disconnect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 910), (void *)_cffi_d_xcb_disconnect },
  { "xcb_intern_atom", (void *)_cffi_f_xcb_intern_atom, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 917), (void *)_cffi_d_xcb_intern_atom },
  { "xcb_intern_atom_reply", (void *)_cffi_f_xcb_intern_atom_reply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 923), (void *)_cffi_d_xcb_intern_atom_reply },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "x1", offsetof(struct pixman_box32, x1),
          sizeof(((struct pixman_box32 *)0)->x1),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y1", offsetof(struct pixman_box32, y1),
          sizeof(((struct pixman_box32 *)0)->y1),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "x2", offsetof(struct pixman_box32, x2),
          sizeof(((struct pixman_box32 *)0)->x2),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y2", offsetof(struct pixman_box32, y2),
          sizeof(((struct pixman_box32 *)0)->y2),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "tv_sec", offsetof(struct timespec, tv_sec),
              sizeof(((struct timespec *)0)->tv_sec),
              _CFFI_OP(_CFFI_OP_NOOP, 976) },
  { "tv_nsec", offsetof(struct timespec, tv_nsec),
               sizeof(((struct timespec *)0)->tv_nsec),
               _CFFI_OP(_CFFI_OP_NOOP, 976) },
  { "impl", offsetof(struct wlr_backend, impl),
            sizeof(((struct wlr_backend *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1065) },
  { "events", offsetof(struct wlr_backend, events),
              sizeof(((struct wlr_backend *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 988) },
  { "x", offsetof(struct wlr_box, x),
         sizeof(((struct wlr_box *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "y", offsetof(struct wlr_box, y),
         sizeof(((struct wlr_box *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "width", offsetof(struct wlr_box, width),
             sizeof(((struct wlr_box *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "height", offsetof(struct wlr_box, height),
              sizeof(((struct wlr_box *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "global", offsetof(struct wlr_compositor, global),
              sizeof(((struct wlr_compositor *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "renderer", offsetof(struct wlr_compositor, renderer),
                sizeof(((struct wlr_compositor *)0)->renderer),
                _CFFI_OP(_CFFI_OP_NOOP, 38) },
  { "subcompositor", offsetof(struct wlr_compositor, subcompositor),
                     sizeof(((struct wlr_compositor *)0)->subcompositor),
                     _CFFI_OP(_CFFI_OP_NOOP, 1191) },
  { "display_destroy", offsetof(struct wlr_compositor, display_destroy),
                       sizeof(((struct wlr_compositor *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_compositor, events),
              sizeof(((struct wlr_compositor *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1010) },
  { "state", offsetof(struct wlr_cursor, state),
             sizeof(((struct wlr_cursor *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1074) },
  { "x", offsetof(struct wlr_cursor, x),
         sizeof(((struct wlr_cursor *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_cursor, y),
         sizeof(((struct wlr_cursor *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "events", offsetof(struct wlr_cursor, events),
              sizeof(((struct wlr_cursor *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 999) },
  { "data", offsetof(struct wlr_cursor, data),
            sizeof(((struct wlr_cursor *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_data_control_manager_v1, global),
              sizeof(((struct wlr_data_control_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "devices", offsetof(struct wlr_data_control_manager_v1, devices),
               sizeof(((struct wlr_data_control_manager_v1 *)0)->devices),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_data_control_manager_v1, events),
              sizeof(((struct wlr_data_control_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1021) },
  { "display_destroy", offsetof(struct wlr_data_control_manager_v1, display_destroy),
                       sizeof(((struct wlr_data_control_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "impl", offsetof(struct wlr_data_source, impl),
            sizeof(((struct wlr_data_source *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1081) },
  { "mime_types", offsetof(struct wlr_data_source, mime_types),
                  sizeof(((struct wlr_data_source *)0)->mime_types),
                  _CFFI_OP(_CFFI_OP_NOOP, 1042) },
  { "actions", offsetof(struct wlr_data_source, actions),
               sizeof(((struct wlr_data_source *)0)->actions),
               _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "accepted", offsetof(struct wlr_data_source, accepted),
                sizeof(((struct wlr_data_source *)0)->accepted),
                _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "current_dnd_action", offsetof(struct wlr_data_source, current_dnd_action),
                          sizeof(((struct wlr_data_source *)0)->current_dnd_action),
                          _CFFI_OP(_CFFI_OP_NOOP, 935) },
  { "compositor_action", offsetof(struct wlr_data_source, compositor_action),
                         sizeof(((struct wlr_data_source *)0)->compositor_action),
                         _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "events", offsetof(struct wlr_data_source, events),
              sizeof(((struct wlr_data_source *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1031) },
  { "grab_type", offsetof(struct wlr_drag, grab_type),
                 sizeof(((struct wlr_drag *)0)->grab_type),
                 _CFFI_OP(_CFFI_OP_NOOP, 938) },
  { "keyboard_grab", offsetof(struct wlr_drag, keyboard_grab),
                     sizeof(((struct wlr_drag *)0)->keyboard_grab),
                     _CFFI_OP(_CFFI_OP_NOOP, 1178) },
  { "pointer_grab", offsetof(struct wlr_drag, pointer_grab),
                    sizeof(((struct wlr_drag *)0)->pointer_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 1181) },
  { "touch_grab", offsetof(struct wlr_drag, touch_grab),
                  sizeof(((struct wlr_drag *)0)->touch_grab),
                  _CFFI_OP(_CFFI_OP_NOOP, 1187) },
  { "seat", offsetof(struct wlr_drag, seat),
            sizeof(((struct wlr_drag *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "seat_client", offsetof(struct wlr_drag, seat_client),
                   sizeof(((struct wlr_drag *)0)->seat_client),
                   _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "focus_client", offsetof(struct wlr_drag, focus_client),
                    sizeof(((struct wlr_drag *)0)->focus_client),
                    _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "icon", offsetof(struct wlr_drag, icon),
            sizeof(((struct wlr_drag *)0)->icon),
            _CFFI_OP(_CFFI_OP_NOOP, 1085) },
  { "focus", offsetof(struct wlr_drag, focus),
             sizeof(((struct wlr_drag *)0)->focus),
             _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "source", offsetof(struct wlr_drag, source),
              sizeof(((struct wlr_drag *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 524) },
  { "started", offsetof(struct wlr_drag, started),
               sizeof(((struct wlr_drag *)0)->started),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "dropped", offsetof(struct wlr_drag, dropped),
               sizeof(((struct wlr_drag *)0)->dropped),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "cancelling", offsetof(struct wlr_drag, cancelling),
                  sizeof(((struct wlr_drag *)0)->cancelling),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "grab_touch_id", offsetof(struct wlr_drag, grab_touch_id),
                     sizeof(((struct wlr_drag *)0)->grab_touch_id),
                     _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "touch_id", offsetof(struct wlr_drag, touch_id),
                sizeof(((struct wlr_drag *)0)->touch_id),
                _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "events", offsetof(struct wlr_drag, events),
              sizeof(((struct wlr_drag *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1030) },
  { "source_destroy", offsetof(struct wlr_drag, source_destroy),
                      sizeof(((struct wlr_drag *)0)->source_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "seat_client_destroy", offsetof(struct wlr_drag, seat_client_destroy),
                           sizeof(((struct wlr_drag *)0)->seat_client_destroy),
                           _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "icon_destroy", offsetof(struct wlr_drag, icon_destroy),
                    sizeof(((struct wlr_drag *)0)->icon_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_drag, data),
            sizeof(((struct wlr_drag *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "drag", offsetof(struct wlr_drag_drop_event, drag),
            sizeof(((struct wlr_drag_drop_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 722) },
  { "time", offsetof(struct wlr_drag_drop_event, time),
            sizeof(((struct wlr_drag_drop_event *)0)->time),
            _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "drag", offsetof(struct wlr_drag_icon, drag),
            sizeof(((struct wlr_drag_icon *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 722) },
  { "surface", offsetof(struct wlr_drag_icon, surface),
               sizeof(((struct wlr_drag_icon *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "mapped", offsetof(struct wlr_drag_icon, mapped),
              sizeof(((struct wlr_drag_icon *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "events", offsetof(struct wlr_drag_icon, events),
              sizeof(((struct wlr_drag_icon *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1029) },
  { "surface_destroy", offsetof(struct wlr_drag_icon, surface_destroy),
                       sizeof(((struct wlr_drag_icon *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_drag_icon, data),
            sizeof(((struct wlr_drag_icon *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "drag", offsetof(struct wlr_drag_motion_event, drag),
            sizeof(((struct wlr_drag_motion_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 722) },
  { "time", offsetof(struct wlr_drag_motion_event, time),
            sizeof(((struct wlr_drag_motion_event *)0)->time),
            _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "sx", offsetof(struct wlr_drag_motion_event, sx),
          sizeof(((struct wlr_drag_motion_event *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_drag_motion_event, sy),
          sizeof(((struct wlr_drag_motion_event *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "time_msec", offsetof(struct wlr_event_keyboard_key, time_msec),
                 sizeof(((struct wlr_event_keyboard_key *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "keycode", offsetof(struct wlr_event_keyboard_key, keycode),
               sizeof(((struct wlr_event_keyboard_key *)0)->keycode),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "update_state", offsetof(struct wlr_event_keyboard_key, update_state),
                    sizeof(((struct wlr_event_keyboard_key *)0)->update_state),
                    _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "state", offsetof(struct wlr_event_keyboard_key, state),
             sizeof(((struct wlr_event_keyboard_key *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 936) },
  { "device", offsetof(struct wlr_event_pointer_axis, device),
              sizeof(((struct wlr_event_pointer_axis *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_axis, time_msec),
                 sizeof(((struct wlr_event_pointer_axis *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "source", offsetof(struct wlr_event_pointer_axis, source),
              sizeof(((struct wlr_event_pointer_axis *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 775) },
  { "orientation", offsetof(struct wlr_event_pointer_axis, orientation),
                   sizeof(((struct wlr_event_pointer_axis *)0)->orientation),
                   _CFFI_OP(_CFFI_OP_NOOP, 772) },
  { "delta", offsetof(struct wlr_event_pointer_axis, delta),
             sizeof(((struct wlr_event_pointer_axis *)0)->delta),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "delta_discrete", offsetof(struct wlr_event_pointer_axis, delta_discrete),
                      sizeof(((struct wlr_event_pointer_axis *)0)->delta_discrete),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "device", offsetof(struct wlr_event_pointer_button, device),
              sizeof(((struct wlr_event_pointer_button *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_button, time_msec),
                 sizeof(((struct wlr_event_pointer_button *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "button", offsetof(struct wlr_event_pointer_button, button),
              sizeof(((struct wlr_event_pointer_button *)0)->button),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "state", offsetof(struct wlr_event_pointer_button, state),
             sizeof(((struct wlr_event_pointer_button *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 392) },
  { "device", offsetof(struct wlr_event_pointer_motion, device),
              sizeof(((struct wlr_event_pointer_motion *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_motion, time_msec),
                 sizeof(((struct wlr_event_pointer_motion *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "delta_x", offsetof(struct wlr_event_pointer_motion, delta_x),
               sizeof(((struct wlr_event_pointer_motion *)0)->delta_x),
               _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "delta_y", offsetof(struct wlr_event_pointer_motion, delta_y),
               sizeof(((struct wlr_event_pointer_motion *)0)->delta_y),
               _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "unaccel_dx", offsetof(struct wlr_event_pointer_motion, unaccel_dx),
                  sizeof(((struct wlr_event_pointer_motion *)0)->unaccel_dx),
                  _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "unaccel_dy", offsetof(struct wlr_event_pointer_motion, unaccel_dy),
                  sizeof(((struct wlr_event_pointer_motion *)0)->unaccel_dy),
                  _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "device", offsetof(struct wlr_event_pointer_motion_absolute, device),
              sizeof(((struct wlr_event_pointer_motion_absolute *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_motion_absolute, time_msec),
                 sizeof(((struct wlr_event_pointer_motion_absolute *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "x", offsetof(struct wlr_event_pointer_motion_absolute, x),
         sizeof(((struct wlr_event_pointer_motion_absolute *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_event_pointer_motion_absolute, y),
         sizeof(((struct wlr_event_pointer_motion_absolute *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "device", offsetof(struct wlr_event_pointer_pinch_begin, device),
              sizeof(((struct wlr_event_pointer_pinch_begin *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_pinch_begin, time_msec),
                 sizeof(((struct wlr_event_pointer_pinch_begin *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "fingers", offsetof(struct wlr_event_pointer_pinch_begin, fingers),
               sizeof(((struct wlr_event_pointer_pinch_begin *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "device", offsetof(struct wlr_event_pointer_pinch_end, device),
              sizeof(((struct wlr_event_pointer_pinch_end *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_pinch_end, time_msec),
                 sizeof(((struct wlr_event_pointer_pinch_end *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "cancelled", offsetof(struct wlr_event_pointer_pinch_end, cancelled),
                 sizeof(((struct wlr_event_pointer_pinch_end *)0)->cancelled),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "device", offsetof(struct wlr_event_pointer_pinch_update, device),
              sizeof(((struct wlr_event_pointer_pinch_update *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_pinch_update, time_msec),
                 sizeof(((struct wlr_event_pointer_pinch_update *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "fingers", offsetof(struct wlr_event_pointer_pinch_update, fingers),
               sizeof(((struct wlr_event_pointer_pinch_update *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "dx", offsetof(struct wlr_event_pointer_pinch_update, dx),
          sizeof(((struct wlr_event_pointer_pinch_update *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "dy", offsetof(struct wlr_event_pointer_pinch_update, dy),
          sizeof(((struct wlr_event_pointer_pinch_update *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "scale", offsetof(struct wlr_event_pointer_pinch_update, scale),
             sizeof(((struct wlr_event_pointer_pinch_update *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "rotation", offsetof(struct wlr_event_pointer_pinch_update, rotation),
                sizeof(((struct wlr_event_pointer_pinch_update *)0)->rotation),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "device", offsetof(struct wlr_event_pointer_swipe_begin, device),
              sizeof(((struct wlr_event_pointer_swipe_begin *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_swipe_begin, time_msec),
                 sizeof(((struct wlr_event_pointer_swipe_begin *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "fingers", offsetof(struct wlr_event_pointer_swipe_begin, fingers),
               sizeof(((struct wlr_event_pointer_swipe_begin *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "device", offsetof(struct wlr_event_pointer_swipe_end, device),
              sizeof(((struct wlr_event_pointer_swipe_end *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_swipe_end, time_msec),
                 sizeof(((struct wlr_event_pointer_swipe_end *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "cancelled", offsetof(struct wlr_event_pointer_swipe_end, cancelled),
                 sizeof(((struct wlr_event_pointer_swipe_end *)0)->cancelled),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "device", offsetof(struct wlr_event_pointer_swipe_update, device),
              sizeof(((struct wlr_event_pointer_swipe_update *)0)->device),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "time_msec", offsetof(struct wlr_event_pointer_swipe_update, time_msec),
                 sizeof(((struct wlr_event_pointer_swipe_update *)0)->time_msec),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "fingers", offsetof(struct wlr_event_pointer_swipe_update, fingers),
               sizeof(((struct wlr_event_pointer_swipe_update *)0)->fingers),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "dx", offsetof(struct wlr_event_pointer_swipe_update, dx),
          sizeof(((struct wlr_event_pointer_swipe_update *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "dy", offsetof(struct wlr_event_pointer_swipe_update, dy),
          sizeof(((struct wlr_event_pointer_swipe_update *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "x", offsetof(struct wlr_fbox, x),
         sizeof(((struct wlr_fbox *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", offsetof(struct wlr_fbox, y),
         sizeof(((struct wlr_fbox *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "width", offsetof(struct wlr_fbox, width),
             sizeof(((struct wlr_fbox *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "height", offsetof(struct wlr_fbox, height),
              sizeof(((struct wlr_fbox *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "manager", offsetof(struct wlr_foreign_toplevel_handle_v1, manager),
               sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 186) },
  { "resources", offsetof(struct wlr_foreign_toplevel_handle_v1, resources),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "link", offsetof(struct wlr_foreign_toplevel_handle_v1, link),
            sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "idle_source", offsetof(struct wlr_foreign_toplevel_handle_v1, idle_source),
                   sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->idle_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "title", offsetof(struct wlr_foreign_toplevel_handle_v1, title),
             sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->title),
             _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "app_id", offsetof(struct wlr_foreign_toplevel_handle_v1, app_id),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->app_id),
              _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "parent", offsetof(struct wlr_foreign_toplevel_handle_v1, parent),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "outputs", offsetof(struct wlr_foreign_toplevel_handle_v1, outputs),
               sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "state", offsetof(struct wlr_foreign_toplevel_handle_v1, state),
             sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "events", offsetof(struct wlr_foreign_toplevel_handle_v1, events),
              sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1033) },
  { "data", offsetof(struct wlr_foreign_toplevel_handle_v1, data),
            sizeof(((struct wlr_foreign_toplevel_handle_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_activated_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_activated_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "seat", offsetof(struct wlr_foreign_toplevel_handle_v1_activated_event, seat),
            sizeof(((struct wlr_foreign_toplevel_handle_v1_activated_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "fullscreen", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, fullscreen),
                  sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "output", offsetof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event, output),
              sizeof(((struct wlr_foreign_toplevel_handle_v1_fullscreen_event *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_maximized_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_maximized_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "maximized", offsetof(struct wlr_foreign_toplevel_handle_v1_maximized_event, maximized),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1_maximized_event *)0)->maximized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_minimized_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_minimized_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "minimized", offsetof(struct wlr_foreign_toplevel_handle_v1_minimized_event, minimized),
                 sizeof(((struct wlr_foreign_toplevel_handle_v1_minimized_event *)0)->minimized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "toplevel", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, toplevel),
                sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 527) },
  { "surface", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, surface),
               sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "x", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, x),
         sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, y),
         sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "width", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, width),
             sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height", offsetof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event, height),
              sizeof(((struct wlr_foreign_toplevel_handle_v1_set_rectangle_event *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "event_loop", offsetof(struct wlr_foreign_toplevel_manager_v1, event_loop),
                  sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->event_loop),
                  _CFFI_OP(_CFFI_OP_NOOP, 1045) },
  { "global", offsetof(struct wlr_foreign_toplevel_manager_v1, global),
              sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "resources", offsetof(struct wlr_foreign_toplevel_manager_v1, resources),
                 sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "toplevels", offsetof(struct wlr_foreign_toplevel_manager_v1, toplevels),
                 sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->toplevels),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_foreign_toplevel_manager_v1, display_destroy),
                       sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_foreign_toplevel_manager_v1, events),
              sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1032) },
  { "data", offsetof(struct wlr_foreign_toplevel_manager_v1, data),
            sizeof(((struct wlr_foreign_toplevel_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_gamma_control_manager_v1, global),
              sizeof(((struct wlr_gamma_control_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "controls", offsetof(struct wlr_gamma_control_manager_v1, controls),
                sizeof(((struct wlr_gamma_control_manager_v1 *)0)->controls),
                _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_gamma_control_manager_v1, display_destroy),
                       sizeof(((struct wlr_gamma_control_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_gamma_control_manager_v1, events),
              sizeof(((struct wlr_gamma_control_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 979) },
  { "data", offsetof(struct wlr_gamma_control_manager_v1, data),
            sizeof(((struct wlr_gamma_control_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_idle, global),
              sizeof(((struct wlr_idle *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "idle_timers", offsetof(struct wlr_idle, idle_timers),
                   sizeof(((struct wlr_idle *)0)->idle_timers),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "event_loop", offsetof(struct wlr_idle, event_loop),
                  sizeof(((struct wlr_idle *)0)->event_loop),
                  _CFFI_OP(_CFFI_OP_NOOP, 1045) },
  { "enabled", offsetof(struct wlr_idle, enabled),
               sizeof(((struct wlr_idle *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "display_destroy", offsetof(struct wlr_idle, display_destroy),
                       sizeof(((struct wlr_idle *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_idle, events),
              sizeof(((struct wlr_idle *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 980) },
  { "data", offsetof(struct wlr_idle, data),
            sizeof(((struct wlr_idle *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "inhibitors", offsetof(struct wlr_idle_inhibit_manager_v1, inhibitors),
                  sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->inhibitors),
                  _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "global", offsetof(struct wlr_idle_inhibit_manager_v1, global),
              sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "display_destroy", offsetof(struct wlr_idle_inhibit_manager_v1, display_destroy),
                       sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_idle_inhibit_manager_v1, events),
              sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 982) },
  { "data", offsetof(struct wlr_idle_inhibit_manager_v1, data),
            sizeof(((struct wlr_idle_inhibit_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "surface", offsetof(struct wlr_idle_inhibitor_v1, surface),
               sizeof(((struct wlr_idle_inhibitor_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "resource", offsetof(struct wlr_idle_inhibitor_v1, resource),
                sizeof(((struct wlr_idle_inhibitor_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "surface_destroy", offsetof(struct wlr_idle_inhibitor_v1, surface_destroy),
                       sizeof(((struct wlr_idle_inhibitor_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "link", offsetof(struct wlr_idle_inhibitor_v1, link),
            sizeof(((struct wlr_idle_inhibitor_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_idle_inhibitor_v1, events),
              sizeof(((struct wlr_idle_inhibitor_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 983) },
  { "data", offsetof(struct wlr_idle_inhibitor_v1, data),
            sizeof(((struct wlr_idle_inhibitor_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "resource", offsetof(struct wlr_idle_timeout, resource),
                sizeof(((struct wlr_idle_timeout *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "link", offsetof(struct wlr_idle_timeout, link),
            sizeof(((struct wlr_idle_timeout *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "seat", offsetof(struct wlr_idle_timeout, seat),
            sizeof(((struct wlr_idle_timeout *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "idle_source", offsetof(struct wlr_idle_timeout, idle_source),
                   sizeof(((struct wlr_idle_timeout *)0)->idle_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "idle_state", offsetof(struct wlr_idle_timeout, idle_state),
                  sizeof(((struct wlr_idle_timeout *)0)->idle_state),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "enabled", offsetof(struct wlr_idle_timeout, enabled),
               sizeof(((struct wlr_idle_timeout *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "timeout", offsetof(struct wlr_idle_timeout, timeout),
               sizeof(((struct wlr_idle_timeout *)0)->timeout),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "events", offsetof(struct wlr_idle_timeout, events),
              sizeof(((struct wlr_idle_timeout *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 981) },
  { "input_listener", offsetof(struct wlr_idle_timeout, input_listener),
                      sizeof(((struct wlr_idle_timeout *)0)->input_listener),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "seat_destroy", offsetof(struct wlr_idle_timeout, seat_destroy),
                    sizeof(((struct wlr_idle_timeout *)0)->seat_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_idle_timeout, data),
            sizeof(((struct wlr_idle_timeout *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "impl", offsetof(struct wlr_input_device, impl),
            sizeof(((struct wlr_input_device *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1115) },
  { "type", offsetof(struct wlr_input_device, type),
            sizeof(((struct wlr_input_device *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 207) },
  { "vendor", offsetof(struct wlr_input_device, vendor),
              sizeof(((struct wlr_input_device *)0)->vendor),
              _CFFI_OP(_CFFI_OP_NOOP, 84) },
  { "product", offsetof(struct wlr_input_device, product),
               sizeof(((struct wlr_input_device *)0)->product),
               _CFFI_OP(_CFFI_OP_NOOP, 84) },
  { "name", offsetof(struct wlr_input_device, name),
            sizeof(((struct wlr_input_device *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "width_mm", offsetof(struct wlr_input_device, width_mm),
                sizeof(((struct wlr_input_device *)0)->width_mm),
                _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "height_mm", offsetof(struct wlr_input_device, height_mm),
                 sizeof(((struct wlr_input_device *)0)->height_mm),
                 _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "output_name", offsetof(struct wlr_input_device, output_name),
                   sizeof(((struct wlr_input_device *)0)->output_name),
                   _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "_device", offsetof(struct wlr_input_device, _device),
               sizeof(((struct wlr_input_device *)0)->_device),
               _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "keyboard", offsetof(struct wlr_input_device, keyboard),
                sizeof(((struct wlr_input_device *)0)->keyboard),
                _CFFI_OP(_CFFI_OP_NOOP, 378) },
  { "pointer", offsetof(struct wlr_input_device, pointer),
               sizeof(((struct wlr_input_device *)0)->pointer),
               _CFFI_OP(_CFFI_OP_NOOP, 1153) },
  { "switch_device", offsetof(struct wlr_input_device, switch_device),
                     sizeof(((struct wlr_input_device *)0)->switch_device),
                     _CFFI_OP(_CFFI_OP_NOOP, 1199) },
  { "touch", offsetof(struct wlr_input_device, touch),
             sizeof(((struct wlr_input_device *)0)->touch),
             _CFFI_OP(_CFFI_OP_NOOP, 1206) },
  { "tablet", offsetof(struct wlr_input_device, tablet),
              sizeof(((struct wlr_input_device *)0)->tablet),
              _CFFI_OP(_CFFI_OP_NOOP, 1201) },
  { "tablet_pad", offsetof(struct wlr_input_device, tablet_pad),
                  sizeof(((struct wlr_input_device *)0)->tablet_pad),
                  _CFFI_OP(_CFFI_OP_NOOP, 1203) },
  { "events", offsetof(struct wlr_input_device, events),
              sizeof(((struct wlr_input_device *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 984) },
  { "data", offsetof(struct wlr_input_device, data),
            sizeof(((struct wlr_input_device *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_input_inhibit_manager, global),
              sizeof(((struct wlr_input_inhibit_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "active_client", offsetof(struct wlr_input_inhibit_manager, active_client),
                     sizeof(((struct wlr_input_inhibit_manager *)0)->active_client),
                     _CFFI_OP(_CFFI_OP_NOOP, 471) },
  { "active_inhibitor", offsetof(struct wlr_input_inhibit_manager, active_inhibitor),
                        sizeof(((struct wlr_input_inhibit_manager *)0)->active_inhibitor),
                        _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "display_destroy", offsetof(struct wlr_input_inhibit_manager, display_destroy),
                       sizeof(((struct wlr_input_inhibit_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_input_inhibit_manager, events),
              sizeof(((struct wlr_input_inhibit_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 985) },
  { "data", offsetof(struct wlr_input_inhibit_manager, data),
            sizeof(((struct wlr_input_inhibit_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "impl", offsetof(struct wlr_keyboard, impl),
            sizeof(((struct wlr_keyboard *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1124) },
  { "group", offsetof(struct wlr_keyboard, group),
             sizeof(((struct wlr_keyboard *)0)->group),
             _CFFI_OP(_CFFI_OP_NOOP, 1122) },
  { "keymap_string", offsetof(struct wlr_keyboard, keymap_string),
                     sizeof(((struct wlr_keyboard *)0)->keymap_string),
                     _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "keymap_size", offsetof(struct wlr_keyboard, keymap_size),
                   sizeof(((struct wlr_keyboard *)0)->keymap_size),
                   _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "keymap", offsetof(struct wlr_keyboard, keymap),
              sizeof(((struct wlr_keyboard *)0)->keymap),
              _CFFI_OP(_CFFI_OP_NOOP, 564) },
  { "xkb_state", offsetof(struct wlr_keyboard, xkb_state),
                 sizeof(((struct wlr_keyboard *)0)->xkb_state),
                 _CFFI_OP(_CFFI_OP_NOOP, 1267) },
  { "led_indexes", offsetof(struct wlr_keyboard, led_indexes),
                   sizeof(((struct wlr_keyboard *)0)->led_indexes),
                   _CFFI_OP(_CFFI_OP_NOOP, 1275) },
  { "mod_indexes", offsetof(struct wlr_keyboard, mod_indexes),
                   sizeof(((struct wlr_keyboard *)0)->mod_indexes),
                   _CFFI_OP(_CFFI_OP_NOOP, 1277) },
  { "keycodes", offsetof(struct wlr_keyboard, keycodes),
                sizeof(((struct wlr_keyboard *)0)->keycodes),
                _CFFI_OP(_CFFI_OP_NOOP, 1273) },
  { "num_keycodes", offsetof(struct wlr_keyboard, num_keycodes),
                    sizeof(((struct wlr_keyboard *)0)->num_keycodes),
                    _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "modifiers", offsetof(struct wlr_keyboard, modifiers),
                 sizeof(((struct wlr_keyboard *)0)->modifiers),
                 _CFFI_OP(_CFFI_OP_NOOP, 1126) },
  { "repeat_info", offsetof(struct wlr_keyboard, repeat_info),
                   sizeof(((struct wlr_keyboard *)0)->repeat_info),
                   _CFFI_OP(_CFFI_OP_NOOP, 986) },
  { "events", offsetof(struct wlr_keyboard, events),
              sizeof(((struct wlr_keyboard *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 987) },
  { "data", offsetof(struct wlr_keyboard, data),
            sizeof(((struct wlr_keyboard *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "depressed", offsetof(struct wlr_keyboard_modifiers, depressed),
                 sizeof(((struct wlr_keyboard_modifiers *)0)->depressed),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "latched", offsetof(struct wlr_keyboard_modifiers, latched),
               sizeof(((struct wlr_keyboard_modifiers *)0)->latched),
               _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "locked", offsetof(struct wlr_keyboard_modifiers, locked),
              sizeof(((struct wlr_keyboard_modifiers *)0)->locked),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "group", offsetof(struct wlr_keyboard_modifiers, group),
             sizeof(((struct wlr_keyboard_modifiers *)0)->group),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "global", offsetof(struct wlr_layer_shell_v1, global),
              sizeof(((struct wlr_layer_shell_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "display_destroy", offsetof(struct wlr_layer_shell_v1, display_destroy),
                       sizeof(((struct wlr_layer_shell_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_layer_shell_v1, events),
              sizeof(((struct wlr_layer_shell_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1023) },
  { "data", offsetof(struct wlr_layer_shell_v1, data),
            sizeof(((struct wlr_layer_shell_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "surface", offsetof(struct wlr_layer_surface_v1, surface),
               sizeof(((struct wlr_layer_surface_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "output", offsetof(struct wlr_layer_surface_v1, output),
              sizeof(((struct wlr_layer_surface_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "resource", offsetof(struct wlr_layer_surface_v1, resource),
                sizeof(((struct wlr_layer_surface_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "shell", offsetof(struct wlr_layer_surface_v1, shell),
             sizeof(((struct wlr_layer_surface_v1 *)0)->shell),
             _CFFI_OP(_CFFI_OP_NOOP, 1127) },
  { "popups", offsetof(struct wlr_layer_surface_v1, popups),
              sizeof(((struct wlr_layer_surface_v1 *)0)->popups),
              _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "namespace", offsetof(struct wlr_layer_surface_v1, namespace),
                 sizeof(((struct wlr_layer_surface_v1 *)0)->namespace),
                 _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "added", offsetof(struct wlr_layer_surface_v1, added),
             sizeof(((struct wlr_layer_surface_v1 *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "configured", offsetof(struct wlr_layer_surface_v1, configured),
                  sizeof(((struct wlr_layer_surface_v1 *)0)->configured),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "mapped", offsetof(struct wlr_layer_surface_v1, mapped),
              sizeof(((struct wlr_layer_surface_v1 *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "configure_list", offsetof(struct wlr_layer_surface_v1, configure_list),
                      sizeof(((struct wlr_layer_surface_v1 *)0)->configure_list),
                      _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "current", offsetof(struct wlr_layer_surface_v1, current),
               sizeof(((struct wlr_layer_surface_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1130) },
  { "pending", offsetof(struct wlr_layer_surface_v1, pending),
               sizeof(((struct wlr_layer_surface_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1130) },
  { "surface_destroy", offsetof(struct wlr_layer_surface_v1, surface_destroy),
                       sizeof(((struct wlr_layer_surface_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_layer_surface_v1, events),
              sizeof(((struct wlr_layer_surface_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1025) },
  { "data", offsetof(struct wlr_layer_surface_v1, data),
            sizeof(((struct wlr_layer_surface_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "anchor", offsetof(struct wlr_layer_surface_v1_state, anchor),
              sizeof(((struct wlr_layer_surface_v1_state *)0)->anchor),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "exclusive_zone", offsetof(struct wlr_layer_surface_v1_state, exclusive_zone),
                      sizeof(((struct wlr_layer_surface_v1_state *)0)->exclusive_zone),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "margin", offsetof(struct wlr_layer_surface_v1_state, margin),
              sizeof(((struct wlr_layer_surface_v1_state *)0)->margin),
              _CFFI_OP(_CFFI_OP_NOOP, 1024) },
  { "keyboard_interactive", offsetof(struct wlr_layer_surface_v1_state, keyboard_interactive),
                            sizeof(((struct wlr_layer_surface_v1_state *)0)->keyboard_interactive),
                            _CFFI_OP(_CFFI_OP_NOOP, 966) },
  { "desired_width", offsetof(struct wlr_layer_surface_v1_state, desired_width),
                     sizeof(((struct wlr_layer_surface_v1_state *)0)->desired_width),
                     _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "desired_height", offsetof(struct wlr_layer_surface_v1_state, desired_height),
                      sizeof(((struct wlr_layer_surface_v1_state *)0)->desired_height),
                      _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "actual_width", offsetof(struct wlr_layer_surface_v1_state, actual_width),
                    sizeof(((struct wlr_layer_surface_v1_state *)0)->actual_width),
                    _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "actual_height", offsetof(struct wlr_layer_surface_v1_state, actual_height),
                     sizeof(((struct wlr_layer_surface_v1_state *)0)->actual_height),
                     _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "layer", offsetof(struct wlr_layer_surface_v1_state, layer),
             sizeof(((struct wlr_layer_surface_v1_state *)0)->layer),
             _CFFI_OP(_CFFI_OP_NOOP, 965) },
  { "impl", offsetof(struct wlr_output, impl),
            sizeof(((struct wlr_output *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1141) },
  { "backend", offsetof(struct wlr_output, backend),
               sizeof(((struct wlr_output *)0)->backend),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "display", offsetof(struct wlr_output, display),
               sizeof(((struct wlr_output *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 47) },
  { "global", offsetof(struct wlr_output, global),
              sizeof(((struct wlr_output *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "resources", offsetof(struct wlr_output, resources),
                 sizeof(((struct wlr_output *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "name", offsetof(struct wlr_output, name),
            sizeof(((struct wlr_output *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "description", offsetof(struct wlr_output, description),
                   sizeof(((struct wlr_output *)0)->description),
                   _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "make", offsetof(struct wlr_output, make),
            sizeof(((struct wlr_output *)0)->make),
            _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "model", offsetof(struct wlr_output, model),
             sizeof(((struct wlr_output *)0)->model),
             _CFFI_OP(_CFFI_OP_NOOP, 931) },
  { "serial", offsetof(struct wlr_output, serial),
              sizeof(((struct wlr_output *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 931) },
  { "phys_width", offsetof(struct wlr_output, phys_width),
                  sizeof(((struct wlr_output *)0)->phys_width),
                  _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "phys_height", offsetof(struct wlr_output, phys_height),
                   sizeof(((struct wlr_output *)0)->phys_height),
                   _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "modes", offsetof(struct wlr_output, modes),
             sizeof(((struct wlr_output *)0)->modes),
             _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "current_mode", offsetof(struct wlr_output, current_mode),
                    sizeof(((struct wlr_output *)0)->current_mode),
                    _CFFI_OP(_CFFI_OP_NOOP, 611) },
  { "width", offsetof(struct wlr_output, width),
             sizeof(((struct wlr_output *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height", offsetof(struct wlr_output, height),
              sizeof(((struct wlr_output *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "refresh", offsetof(struct wlr_output, refresh),
               sizeof(((struct wlr_output *)0)->refresh),
               _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "enabled", offsetof(struct wlr_output, enabled),
               sizeof(((struct wlr_output *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "scale", offsetof(struct wlr_output, scale),
             sizeof(((struct wlr_output *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "subpixel", offsetof(struct wlr_output, subpixel),
                sizeof(((struct wlr_output *)0)->subpixel),
                _CFFI_OP(_CFFI_OP_NOOP, 937) },
  { "transform", offsetof(struct wlr_output, transform),
                 sizeof(((struct wlr_output *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "needs_frame", offsetof(struct wlr_output, needs_frame),
                   sizeof(((struct wlr_output *)0)->needs_frame),
                   _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "frame_pending", offsetof(struct wlr_output, frame_pending),
                     sizeof(((struct wlr_output *)0)->frame_pending),
                     _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "transform_matrix", offsetof(struct wlr_output, transform_matrix),
                        sizeof(((struct wlr_output *)0)->transform_matrix),
                        _CFFI_OP(_CFFI_OP_NOOP, 969) },
  { "pending", offsetof(struct wlr_output, pending),
               sizeof(((struct wlr_output *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1152) },
  { "events", offsetof(struct wlr_output, events),
              sizeof(((struct wlr_output *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 989) },
  { "idle_frame", offsetof(struct wlr_output, idle_frame),
                  sizeof(((struct wlr_output *)0)->idle_frame),
                  _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "idle_done", offsetof(struct wlr_output, idle_done),
                 sizeof(((struct wlr_output *)0)->idle_done),
                 _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "attach_render_locks", offsetof(struct wlr_output, attach_render_locks),
                           sizeof(((struct wlr_output *)0)->attach_render_locks),
                           _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "cursors", offsetof(struct wlr_output, cursors),
               sizeof(((struct wlr_output *)0)->cursors),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "hardware_cursor", offsetof(struct wlr_output, hardware_cursor),
                       sizeof(((struct wlr_output *)0)->hardware_cursor),
                       _CFFI_OP(_CFFI_OP_NOOP, 1137) },
  { "software_cursor_locks", offsetof(struct wlr_output, software_cursor_locks),
                             sizeof(((struct wlr_output *)0)->software_cursor_locks),
                             _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "display_destroy", offsetof(struct wlr_output, display_destroy),
                       sizeof(((struct wlr_output *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_output, data),
            sizeof(((struct wlr_output *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "state", offsetof(struct wlr_output_configuration_head_v1, state),
             sizeof(((struct wlr_output_configuration_head_v1 *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1140) },
  { "config", offsetof(struct wlr_output_configuration_head_v1, config),
              sizeof(((struct wlr_output_configuration_head_v1 *)0)->config),
              _CFFI_OP(_CFFI_OP_NOOP, 236) },
  { "link", offsetof(struct wlr_output_configuration_head_v1, link),
            sizeof(((struct wlr_output_configuration_head_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "resource", offsetof(struct wlr_output_configuration_head_v1, resource),
                sizeof(((struct wlr_output_configuration_head_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "output_destroy", offsetof(struct wlr_output_configuration_head_v1, output_destroy),
                      sizeof(((struct wlr_output_configuration_head_v1 *)0)->output_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "heads", offsetof(struct wlr_output_configuration_v1, heads),
             sizeof(((struct wlr_output_configuration_v1 *)0)->heads),
             _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "manager", offsetof(struct wlr_output_configuration_v1, manager),
               sizeof(((struct wlr_output_configuration_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 655) },
  { "serial", offsetof(struct wlr_output_configuration_v1, serial),
              sizeof(((struct wlr_output_configuration_v1 *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "finalized", offsetof(struct wlr_output_configuration_v1, finalized),
                 sizeof(((struct wlr_output_configuration_v1 *)0)->finalized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "finished", offsetof(struct wlr_output_configuration_v1, finished),
                sizeof(((struct wlr_output_configuration_v1 *)0)->finished),
                _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "resource", offsetof(struct wlr_output_configuration_v1, resource),
                sizeof(((struct wlr_output_configuration_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "output", offsetof(struct wlr_output_damage, output),
              sizeof(((struct wlr_output_damage *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "max_rects", offsetof(struct wlr_output_damage, max_rects),
                 sizeof(((struct wlr_output_damage *)0)->max_rects),
                 _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "current", offsetof(struct wlr_output_damage, current),
               sizeof(((struct wlr_output_damage *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "previous", offsetof(struct wlr_output_damage, previous),
                sizeof(((struct wlr_output_damage *)0)->previous),
                _CFFI_OP(_CFFI_OP_NOOP, 1039) },
  { "previous_idx", offsetof(struct wlr_output_damage, previous_idx),
                    sizeof(((struct wlr_output_damage *)0)->previous_idx),
                    _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "pending_attach_render", offsetof(struct wlr_output_damage, pending_attach_render),
                             sizeof(((struct wlr_output_damage *)0)->pending_attach_render),
                             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "events", offsetof(struct wlr_output_damage, events),
              sizeof(((struct wlr_output_damage *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 990) },
  { "output_destroy", offsetof(struct wlr_output_damage, output_destroy),
                      sizeof(((struct wlr_output_damage *)0)->output_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_mode", offsetof(struct wlr_output_damage, output_mode),
                   sizeof(((struct wlr_output_damage *)0)->output_mode),
                   _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_needs_frame", offsetof(struct wlr_output_damage, output_needs_frame),
                          sizeof(((struct wlr_output_damage *)0)->output_needs_frame),
                          _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_damage", offsetof(struct wlr_output_damage, output_damage),
                     sizeof(((struct wlr_output_damage *)0)->output_damage),
                     _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_frame", offsetof(struct wlr_output_damage, output_frame),
                    sizeof(((struct wlr_output_damage *)0)->output_frame),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_precommit", offsetof(struct wlr_output_damage, output_precommit),
                        sizeof(((struct wlr_output_damage *)0)->output_precommit),
                        _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_commit", offsetof(struct wlr_output_damage, output_commit),
                     sizeof(((struct wlr_output_damage *)0)->output_commit),
                     _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output", offsetof(struct wlr_output_head_v1_state, output),
              sizeof(((struct wlr_output_head_v1_state *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "enabled", offsetof(struct wlr_output_head_v1_state, enabled),
               sizeof(((struct wlr_output_head_v1_state *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "mode", offsetof(struct wlr_output_head_v1_state, mode),
            sizeof(((struct wlr_output_head_v1_state *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 611) },
  { "custom_mode", offsetof(struct wlr_output_head_v1_state, custom_mode),
                   sizeof(((struct wlr_output_head_v1_state *)0)->custom_mode),
                   _CFFI_OP(_CFFI_OP_NOOP, 993) },
  { "x", offsetof(struct wlr_output_head_v1_state, x),
         sizeof(((struct wlr_output_head_v1_state *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y", offsetof(struct wlr_output_head_v1_state, y),
         sizeof(((struct wlr_output_head_v1_state *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "transform", offsetof(struct wlr_output_head_v1_state, transform),
                 sizeof(((struct wlr_output_head_v1_state *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "scale", offsetof(struct wlr_output_head_v1_state, scale),
             sizeof(((struct wlr_output_head_v1_state *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 53) },
  { "outputs", offsetof(struct wlr_output_layout, outputs),
               sizeof(((struct wlr_output_layout *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "state", offsetof(struct wlr_output_layout, state),
             sizeof(((struct wlr_output_layout *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1144) },
  { "events", offsetof(struct wlr_output_layout, events),
              sizeof(((struct wlr_output_layout *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 991) },
  { "data", offsetof(struct wlr_output_layout, data),
            sizeof(((struct wlr_output_layout *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "display", offsetof(struct wlr_output_manager_v1, display),
               sizeof(((struct wlr_output_manager_v1 *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 47) },
  { "global", offsetof(struct wlr_output_manager_v1, global),
              sizeof(((struct wlr_output_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "resources", offsetof(struct wlr_output_manager_v1, resources),
                 sizeof(((struct wlr_output_manager_v1 *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "heads", offsetof(struct wlr_output_manager_v1, heads),
             sizeof(((struct wlr_output_manager_v1 *)0)->heads),
             _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "serial", offsetof(struct wlr_output_manager_v1, serial),
              sizeof(((struct wlr_output_manager_v1 *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "current_configuration_dirty", offsetof(struct wlr_output_manager_v1, current_configuration_dirty),
                                   sizeof(((struct wlr_output_manager_v1 *)0)->current_configuration_dirty),
                                   _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "events", offsetof(struct wlr_output_manager_v1, events),
              sizeof(((struct wlr_output_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 992) },
  { "display_destroy", offsetof(struct wlr_output_manager_v1, display_destroy),
                       sizeof(((struct wlr_output_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_output_manager_v1, data),
            sizeof(((struct wlr_output_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_output_power_manager_v1, global),
              sizeof(((struct wlr_output_power_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "output_powers", offsetof(struct wlr_output_power_manager_v1, output_powers),
                     sizeof(((struct wlr_output_power_manager_v1 *)0)->output_powers),
                     _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_output_power_manager_v1, display_destroy),
                       sizeof(((struct wlr_output_power_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_output_power_manager_v1, events),
              sizeof(((struct wlr_output_power_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 994) },
  { "data", offsetof(struct wlr_output_power_manager_v1, data),
            sizeof(((struct wlr_output_power_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "resource", offsetof(struct wlr_output_power_v1, resource),
                sizeof(((struct wlr_output_power_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "output", offsetof(struct wlr_output_power_v1, output),
              sizeof(((struct wlr_output_power_v1 *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "manager", offsetof(struct wlr_output_power_v1, manager),
               sizeof(((struct wlr_output_power_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 1148) },
  { "link", offsetof(struct wlr_output_power_v1, link),
            sizeof(((struct wlr_output_power_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "output_destroy_listener", offsetof(struct wlr_output_power_v1, output_destroy_listener),
                               sizeof(((struct wlr_output_power_v1 *)0)->output_destroy_listener),
                               _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "output_commit_listener", offsetof(struct wlr_output_power_v1, output_commit_listener),
                              sizeof(((struct wlr_output_power_v1 *)0)->output_commit_listener),
                              _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_output_power_v1, data),
            sizeof(((struct wlr_output_power_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "output", offsetof(struct wlr_output_power_v1_set_mode_event, output),
              sizeof(((struct wlr_output_power_v1_set_mode_event *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "mode", offsetof(struct wlr_output_power_v1_set_mode_event, mode),
            sizeof(((struct wlr_output_power_v1_set_mode_event *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 967) },
  { "impl", offsetof(struct wlr_pointer, impl),
            sizeof(((struct wlr_pointer *)0)->impl),
            _CFFI_OP(_CFFI_OP_NOOP, 1160) },
  { "events", offsetof(struct wlr_pointer, events),
              sizeof(((struct wlr_pointer *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 995) },
  { "data", offsetof(struct wlr_pointer, data),
            sizeof(((struct wlr_pointer *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "pointer_constraints", offsetof(struct wlr_pointer_constraint_v1, pointer_constraints),
                           sizeof(((struct wlr_pointer_constraint_v1 *)0)->pointer_constraints),
                           _CFFI_OP(_CFFI_OP_NOOP, 256) },
  { "resource", offsetof(struct wlr_pointer_constraint_v1, resource),
                sizeof(((struct wlr_pointer_constraint_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "surface", offsetof(struct wlr_pointer_constraint_v1, surface),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "seat", offsetof(struct wlr_pointer_constraint_v1, seat),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "lifetime", offsetof(struct wlr_pointer_constraint_v1, lifetime),
                sizeof(((struct wlr_pointer_constraint_v1 *)0)->lifetime),
                _CFFI_OP(_CFFI_OP_NOOP, 968) },
  { "type", offsetof(struct wlr_pointer_constraint_v1, type),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 943) },
  { "region", offsetof(struct wlr_pointer_constraint_v1, region),
              sizeof(((struct wlr_pointer_constraint_v1 *)0)->region),
              _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "current", offsetof(struct wlr_pointer_constraint_v1, current),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1156) },
  { "pending", offsetof(struct wlr_pointer_constraint_v1, pending),
               sizeof(((struct wlr_pointer_constraint_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1156) },
  { "surface_commit", offsetof(struct wlr_pointer_constraint_v1, surface_commit),
                      sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface_commit),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_destroy", offsetof(struct wlr_pointer_constraint_v1, surface_destroy),
                       sizeof(((struct wlr_pointer_constraint_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "seat_destroy", offsetof(struct wlr_pointer_constraint_v1, seat_destroy),
                    sizeof(((struct wlr_pointer_constraint_v1 *)0)->seat_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "link", offsetof(struct wlr_pointer_constraint_v1, link),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_pointer_constraint_v1, events),
              sizeof(((struct wlr_pointer_constraint_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 997) },
  { "data", offsetof(struct wlr_pointer_constraint_v1, data),
            sizeof(((struct wlr_pointer_constraint_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "committed", offsetof(struct wlr_pointer_constraint_v1_state, committed),
                 sizeof(((struct wlr_pointer_constraint_v1_state *)0)->committed),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "region", offsetof(struct wlr_pointer_constraint_v1_state, region),
              sizeof(((struct wlr_pointer_constraint_v1_state *)0)->region),
              _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "cursor_hint", offsetof(struct wlr_pointer_constraint_v1_state, cursor_hint),
                   sizeof(((struct wlr_pointer_constraint_v1_state *)0)->cursor_hint),
                   _CFFI_OP(_CFFI_OP_NOOP, 996) },
  { "global", offsetof(struct wlr_pointer_constraints_v1, global),
              sizeof(((struct wlr_pointer_constraints_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "constraints", offsetof(struct wlr_pointer_constraints_v1, constraints),
                   sizeof(((struct wlr_pointer_constraints_v1 *)0)->constraints),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_pointer_constraints_v1, events),
              sizeof(((struct wlr_pointer_constraints_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 998) },
  { "display_destroy", offsetof(struct wlr_pointer_constraints_v1, display_destroy),
                       sizeof(((struct wlr_pointer_constraints_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_pointer_constraints_v1, data),
            sizeof(((struct wlr_pointer_constraints_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_primary_selection_v1_device_manager, global),
              sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "devices", offsetof(struct wlr_primary_selection_v1_device_manager, devices),
               sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->devices),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_primary_selection_v1_device_manager, display_destroy),
                       sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_primary_selection_v1_device_manager, events),
              sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1000) },
  { "data", offsetof(struct wlr_primary_selection_v1_device_manager, data),
            sizeof(((struct wlr_primary_selection_v1_device_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_relative_pointer_manager_v1, global),
              sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "relative_pointers", offsetof(struct wlr_relative_pointer_manager_v1, relative_pointers),
                         sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->relative_pointers),
                         _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_relative_pointer_manager_v1, events),
              sizeof(((struct wlr_relative_pointer_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1001) },
  { "resource", offsetof(struct wlr_relative_pointer_v1, resource),
                sizeof(((struct wlr_relative_pointer_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "pointer_resource", offsetof(struct wlr_relative_pointer_v1, pointer_resource),
                        sizeof(((struct wlr_relative_pointer_v1 *)0)->pointer_resource),
                        _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "seat", offsetof(struct wlr_relative_pointer_v1, seat),
            sizeof(((struct wlr_relative_pointer_v1 *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "link", offsetof(struct wlr_relative_pointer_v1, link),
            sizeof(((struct wlr_relative_pointer_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_relative_pointer_v1, events),
              sizeof(((struct wlr_relative_pointer_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1002) },
  { "node", offsetof(struct wlr_scene, node),
            sizeof(((struct wlr_scene *)0)->node),
            _CFFI_OP(_CFFI_OP_NOOP, 1169) },
  { "outputs", offsetof(struct wlr_scene, outputs),
               sizeof(((struct wlr_scene *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "type", offsetof(struct wlr_scene_node, type),
            sizeof(((struct wlr_scene_node *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 944) },
  { "parent", offsetof(struct wlr_scene_node, parent),
              sizeof(((struct wlr_scene_node *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 275) },
  { "state", offsetof(struct wlr_scene_node, state),
             sizeof(((struct wlr_scene_node *)0)->state),
             _CFFI_OP(_CFFI_OP_NOOP, 1170) },
  { "events", offsetof(struct wlr_scene_node, events),
              sizeof(((struct wlr_scene_node *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1003) },
  { "data", offsetof(struct wlr_scene_node, data),
            sizeof(((struct wlr_scene_node *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "link", offsetof(struct wlr_scene_node_state, link),
            sizeof(((struct wlr_scene_node_state *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "children", offsetof(struct wlr_scene_node_state, children),
                sizeof(((struct wlr_scene_node_state *)0)->children),
                _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "enabled", offsetof(struct wlr_scene_node_state, enabled),
               sizeof(((struct wlr_scene_node_state *)0)->enabled),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "x", offsetof(struct wlr_scene_node_state, x),
         sizeof(((struct wlr_scene_node_state *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "y", offsetof(struct wlr_scene_node_state, y),
         sizeof(((struct wlr_scene_node_state *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "global", offsetof(struct wlr_screencopy_manager_v1, global),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "frames", offsetof(struct wlr_screencopy_manager_v1, frames),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->frames),
              _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_screencopy_manager_v1, display_destroy),
                       sizeof(((struct wlr_screencopy_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_screencopy_manager_v1, events),
              sizeof(((struct wlr_screencopy_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1004) },
  { "data", offsetof(struct wlr_screencopy_manager_v1, data),
            sizeof(((struct wlr_screencopy_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_seat, global),
              sizeof(((struct wlr_seat *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "display", offsetof(struct wlr_seat, display),
               sizeof(((struct wlr_seat *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 47) },
  { "clients", offsetof(struct wlr_seat, clients),
               sizeof(((struct wlr_seat *)0)->clients),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "name", offsetof(struct wlr_seat, name),
            sizeof(((struct wlr_seat *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "capabilities", offsetof(struct wlr_seat, capabilities),
                    sizeof(((struct wlr_seat *)0)->capabilities),
                    _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "last_event", offsetof(struct wlr_seat, last_event),
                  sizeof(((struct wlr_seat *)0)->last_event),
                  _CFFI_OP(_CFFI_OP_NOOP, 1041) },
  { "selection_source", offsetof(struct wlr_seat, selection_source),
                        sizeof(((struct wlr_seat *)0)->selection_source),
                        _CFFI_OP(_CFFI_OP_NOOP, 524) },
  { "selection_serial", offsetof(struct wlr_seat, selection_serial),
                        sizeof(((struct wlr_seat *)0)->selection_serial),
                        _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "selection_offers", offsetof(struct wlr_seat, selection_offers),
                        sizeof(((struct wlr_seat *)0)->selection_offers),
                        _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "primary_selection_source", offsetof(struct wlr_seat, primary_selection_source),
                                sizeof(((struct wlr_seat *)0)->primary_selection_source),
                                _CFFI_OP(_CFFI_OP_NOOP, 735) },
  { "primary_selection_serial", offsetof(struct wlr_seat, primary_selection_serial),
                                sizeof(((struct wlr_seat *)0)->primary_selection_serial),
                                _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "drag", offsetof(struct wlr_seat, drag),
            sizeof(((struct wlr_seat *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 722) },
  { "drag_source", offsetof(struct wlr_seat, drag_source),
                   sizeof(((struct wlr_seat *)0)->drag_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 524) },
  { "drag_serial", offsetof(struct wlr_seat, drag_serial),
                   sizeof(((struct wlr_seat *)0)->drag_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "drag_offers", offsetof(struct wlr_seat, drag_offers),
                   sizeof(((struct wlr_seat *)0)->drag_offers),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "pointer_state", offsetof(struct wlr_seat, pointer_state),
                     sizeof(((struct wlr_seat *)0)->pointer_state),
                     _CFFI_OP(_CFFI_OP_NOOP, 1183) },
  { "keyboard_state", offsetof(struct wlr_seat, keyboard_state),
                      sizeof(((struct wlr_seat *)0)->keyboard_state),
                      _CFFI_OP(_CFFI_OP_NOOP, 1179) },
  { "touch_state", offsetof(struct wlr_seat, touch_state),
                   sizeof(((struct wlr_seat *)0)->touch_state),
                   _CFFI_OP(_CFFI_OP_NOOP, 1188) },
  { "display_destroy", offsetof(struct wlr_seat, display_destroy),
                       sizeof(((struct wlr_seat *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "selection_source_destroy", offsetof(struct wlr_seat, selection_source_destroy),
                                sizeof(((struct wlr_seat *)0)->selection_source_destroy),
                                _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "primary_selection_source_destroy", offsetof(struct wlr_seat, primary_selection_source_destroy),
                                        sizeof(((struct wlr_seat *)0)->primary_selection_source_destroy),
                                        _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "drag_source_destroy", offsetof(struct wlr_seat, drag_source_destroy),
                           sizeof(((struct wlr_seat *)0)->drag_source_destroy),
                           _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_seat, events),
              sizeof(((struct wlr_seat *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1007) },
  { "data", offsetof(struct wlr_seat, data),
            sizeof(((struct wlr_seat *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "seat", offsetof(struct wlr_seat_keyboard_focus_change_event, seat),
            sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "old_surface", offsetof(struct wlr_seat_keyboard_focus_change_event, old_surface),
                   sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->old_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "new_surface", offsetof(struct wlr_seat_keyboard_focus_change_event, new_surface),
                   sizeof(((struct wlr_seat_keyboard_focus_change_event *)0)->new_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "interface", offsetof(struct wlr_seat_keyboard_grab, interface),
                 sizeof(((struct wlr_seat_keyboard_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1120) },
  { "seat", offsetof(struct wlr_seat_keyboard_grab, seat),
            sizeof(((struct wlr_seat_keyboard_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "data", offsetof(struct wlr_seat_keyboard_grab, data),
            sizeof(((struct wlr_seat_keyboard_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "seat", offsetof(struct wlr_seat_keyboard_state, seat),
            sizeof(((struct wlr_seat_keyboard_state *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "keyboard", offsetof(struct wlr_seat_keyboard_state, keyboard),
                sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard),
                _CFFI_OP(_CFFI_OP_NOOP, 378) },
  { "focused_client", offsetof(struct wlr_seat_keyboard_state, focused_client),
                      sizeof(((struct wlr_seat_keyboard_state *)0)->focused_client),
                      _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "focused_surface", offsetof(struct wlr_seat_keyboard_state, focused_surface),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->focused_surface),
                       _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "keyboard_destroy", offsetof(struct wlr_seat_keyboard_state, keyboard_destroy),
                        sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_destroy),
                        _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "keyboard_keymap", offsetof(struct wlr_seat_keyboard_state, keyboard_keymap),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_keymap),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "keyboard_repeat_info", offsetof(struct wlr_seat_keyboard_state, keyboard_repeat_info),
                            sizeof(((struct wlr_seat_keyboard_state *)0)->keyboard_repeat_info),
                            _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_destroy", offsetof(struct wlr_seat_keyboard_state, surface_destroy),
                       sizeof(((struct wlr_seat_keyboard_state *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "grab", offsetof(struct wlr_seat_keyboard_state, grab),
            sizeof(((struct wlr_seat_keyboard_state *)0)->grab),
            _CFFI_OP(_CFFI_OP_NOOP, 740) },
  { "default_grab", offsetof(struct wlr_seat_keyboard_state, default_grab),
                    sizeof(((struct wlr_seat_keyboard_state *)0)->default_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 740) },
  { "events", offsetof(struct wlr_seat_keyboard_state, events),
              sizeof(((struct wlr_seat_keyboard_state *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1006) },
  { "seat", offsetof(struct wlr_seat_pointer_focus_change_event, seat),
            sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "old_surface", offsetof(struct wlr_seat_pointer_focus_change_event, old_surface),
                   sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->old_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "new_surface", offsetof(struct wlr_seat_pointer_focus_change_event, new_surface),
                   sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->new_surface),
                   _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "sx", offsetof(struct wlr_seat_pointer_focus_change_event, sx),
          sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_seat_pointer_focus_change_event, sy),
          sizeof(((struct wlr_seat_pointer_focus_change_event *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "interface", offsetof(struct wlr_seat_pointer_grab, interface),
                 sizeof(((struct wlr_seat_pointer_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1158) },
  { "seat", offsetof(struct wlr_seat_pointer_grab, seat),
            sizeof(((struct wlr_seat_pointer_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "data", offsetof(struct wlr_seat_pointer_grab, data),
            sizeof(((struct wlr_seat_pointer_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "seat_client", offsetof(struct wlr_seat_pointer_request_set_cursor_event, seat_client),
                   sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->seat_client),
                   _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "surface", offsetof(struct wlr_seat_pointer_request_set_cursor_event, surface),
               sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "serial", offsetof(struct wlr_seat_pointer_request_set_cursor_event, serial),
              sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "hotspot_x", offsetof(struct wlr_seat_pointer_request_set_cursor_event, hotspot_x),
                 sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->hotspot_x),
                 _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "hotspot_y", offsetof(struct wlr_seat_pointer_request_set_cursor_event, hotspot_y),
                 sizeof(((struct wlr_seat_pointer_request_set_cursor_event *)0)->hotspot_y),
                 _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "seat", offsetof(struct wlr_seat_pointer_state, seat),
            sizeof(((struct wlr_seat_pointer_state *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "focused_client", offsetof(struct wlr_seat_pointer_state, focused_client),
                      sizeof(((struct wlr_seat_pointer_state *)0)->focused_client),
                      _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "focused_surface", offsetof(struct wlr_seat_pointer_state, focused_surface),
                       sizeof(((struct wlr_seat_pointer_state *)0)->focused_surface),
                       _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "sx", offsetof(struct wlr_seat_pointer_state, sx),
          sizeof(((struct wlr_seat_pointer_state *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "sy", offsetof(struct wlr_seat_pointer_state, sy),
          sizeof(((struct wlr_seat_pointer_state *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "grab", offsetof(struct wlr_seat_pointer_state, grab),
            sizeof(((struct wlr_seat_pointer_state *)0)->grab),
            _CFFI_OP(_CFFI_OP_NOOP, 744) },
  { "default_grab", offsetof(struct wlr_seat_pointer_state, default_grab),
                    sizeof(((struct wlr_seat_pointer_state *)0)->default_grab),
                    _CFFI_OP(_CFFI_OP_NOOP, 744) },
  { "buttons", offsetof(struct wlr_seat_pointer_state, buttons),
               sizeof(((struct wlr_seat_pointer_state *)0)->buttons),
               _CFFI_OP(_CFFI_OP_NOOP, 1271) },
  { "button_count", offsetof(struct wlr_seat_pointer_state, button_count),
                    sizeof(((struct wlr_seat_pointer_state *)0)->button_count),
                    _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "grab_button", offsetof(struct wlr_seat_pointer_state, grab_button),
                   sizeof(((struct wlr_seat_pointer_state *)0)->grab_button),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "grab_serial", offsetof(struct wlr_seat_pointer_state, grab_serial),
                   sizeof(((struct wlr_seat_pointer_state *)0)->grab_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "grab_time", offsetof(struct wlr_seat_pointer_state, grab_time),
                 sizeof(((struct wlr_seat_pointer_state *)0)->grab_time),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "surface_destroy", offsetof(struct wlr_seat_pointer_state, surface_destroy),
                       sizeof(((struct wlr_seat_pointer_state *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_seat_pointer_state, events),
              sizeof(((struct wlr_seat_pointer_state *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1005) },
  { "source", offsetof(struct wlr_seat_request_set_primary_selection_event, source),
              sizeof(((struct wlr_seat_request_set_primary_selection_event *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 735) },
  { "serial", offsetof(struct wlr_seat_request_set_primary_selection_event, serial),
              sizeof(((struct wlr_seat_request_set_primary_selection_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "source", offsetof(struct wlr_seat_request_set_selection_event, source),
              sizeof(((struct wlr_seat_request_set_selection_event *)0)->source),
              _CFFI_OP(_CFFI_OP_NOOP, 524) },
  { "serial", offsetof(struct wlr_seat_request_set_selection_event, serial),
              sizeof(((struct wlr_seat_request_set_selection_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "drag", offsetof(struct wlr_seat_request_start_drag_event, drag),
            sizeof(((struct wlr_seat_request_start_drag_event *)0)->drag),
            _CFFI_OP(_CFFI_OP_NOOP, 722) },
  { "origin", offsetof(struct wlr_seat_request_start_drag_event, origin),
              sizeof(((struct wlr_seat_request_start_drag_event *)0)->origin),
              _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "serial", offsetof(struct wlr_seat_request_start_drag_event, serial),
              sizeof(((struct wlr_seat_request_start_drag_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "interface", offsetof(struct wlr_seat_touch_grab, interface),
                 sizeof(((struct wlr_seat_touch_grab *)0)->interface),
                 _CFFI_OP(_CFFI_OP_NOOP, 1208) },
  { "seat", offsetof(struct wlr_seat_touch_grab, seat),
            sizeof(((struct wlr_seat_touch_grab *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "data", offsetof(struct wlr_seat_touch_grab, data),
            sizeof(((struct wlr_seat_touch_grab *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_server_decoration_manager, global),
              sizeof(((struct wlr_server_decoration_manager *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "resources", offsetof(struct wlr_server_decoration_manager, resources),
                 sizeof(((struct wlr_server_decoration_manager *)0)->resources),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "decorations", offsetof(struct wlr_server_decoration_manager, decorations),
                   sizeof(((struct wlr_server_decoration_manager *)0)->decorations),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "default_mode", offsetof(struct wlr_server_decoration_manager, default_mode),
                    sizeof(((struct wlr_server_decoration_manager *)0)->default_mode),
                    _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "display_destroy", offsetof(struct wlr_server_decoration_manager, display_destroy),
                       sizeof(((struct wlr_server_decoration_manager *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_server_decoration_manager, events),
              sizeof(((struct wlr_server_decoration_manager *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1008) },
  { "data", offsetof(struct wlr_server_decoration_manager, data),
            sizeof(((struct wlr_server_decoration_manager *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_subcompositor, global),
              sizeof(((struct wlr_subcompositor *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "resource", offsetof(struct wlr_subsurface, resource),
                sizeof(((struct wlr_subsurface *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "surface", offsetof(struct wlr_subsurface, surface),
               sizeof(((struct wlr_subsurface *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "parent", offsetof(struct wlr_subsurface, parent),
              sizeof(((struct wlr_subsurface *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "current", offsetof(struct wlr_subsurface, current),
               sizeof(((struct wlr_subsurface *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1194) },
  { "pending", offsetof(struct wlr_subsurface, pending),
               sizeof(((struct wlr_subsurface *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1194) },
  { "cached_seq", offsetof(struct wlr_subsurface, cached_seq),
                  sizeof(((struct wlr_subsurface *)0)->cached_seq),
                  _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "has_cache", offsetof(struct wlr_subsurface, has_cache),
                 sizeof(((struct wlr_subsurface *)0)->has_cache),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "synchronized", offsetof(struct wlr_subsurface, synchronized),
                    sizeof(((struct wlr_subsurface *)0)->synchronized),
                    _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "reordered", offsetof(struct wlr_subsurface, reordered),
                 sizeof(((struct wlr_subsurface *)0)->reordered),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "mapped", offsetof(struct wlr_subsurface, mapped),
              sizeof(((struct wlr_subsurface *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "surface_destroy", offsetof(struct wlr_subsurface, surface_destroy),
                       sizeof(((struct wlr_subsurface *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "parent_destroy", offsetof(struct wlr_subsurface, parent_destroy),
                      sizeof(((struct wlr_subsurface *)0)->parent_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_subsurface, events),
              sizeof(((struct wlr_subsurface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1011) },
  { "data", offsetof(struct wlr_subsurface, data),
            sizeof(((struct wlr_subsurface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "x", offsetof(struct wlr_subsurface_parent_state, x),
         sizeof(((struct wlr_subsurface_parent_state *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y", offsetof(struct wlr_subsurface_parent_state, y),
         sizeof(((struct wlr_subsurface_parent_state *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "resource", offsetof(struct wlr_surface, resource),
                sizeof(((struct wlr_surface *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "renderer", offsetof(struct wlr_surface, renderer),
                sizeof(((struct wlr_surface *)0)->renderer),
                _CFFI_OP(_CFFI_OP_NOOP, 38) },
  { "buffer", offsetof(struct wlr_surface, buffer),
              sizeof(((struct wlr_surface *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 1070) },
  { "sx", offsetof(struct wlr_surface, sx),
          sizeof(((struct wlr_surface *)0)->sx),
          _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "sy", offsetof(struct wlr_surface, sy),
          sizeof(((struct wlr_surface *)0)->sy),
          _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "buffer_damage", offsetof(struct wlr_surface, buffer_damage),
                     sizeof(((struct wlr_surface *)0)->buffer_damage),
                     _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "opaque_region", offsetof(struct wlr_surface, opaque_region),
                     sizeof(((struct wlr_surface *)0)->opaque_region),
                     _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "input_region", offsetof(struct wlr_surface, input_region),
                    sizeof(((struct wlr_surface *)0)->input_region),
                    _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "current", offsetof(struct wlr_surface, current),
               sizeof(((struct wlr_surface *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1198) },
  { "pending", offsetof(struct wlr_surface, pending),
               sizeof(((struct wlr_surface *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1198) },
  { "cached", offsetof(struct wlr_surface, cached),
              sizeof(((struct wlr_surface *)0)->cached),
              _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "role", offsetof(struct wlr_surface, role),
            sizeof(((struct wlr_surface *)0)->role),
            _CFFI_OP(_CFFI_OP_NOOP, 96) },
  { "role_data", offsetof(struct wlr_surface, role_data),
                 sizeof(((struct wlr_surface *)0)->role_data),
                 _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "events", offsetof(struct wlr_surface, events),
              sizeof(((struct wlr_surface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1009) },
  { "current_outputs", offsetof(struct wlr_surface, current_outputs),
                       sizeof(((struct wlr_surface *)0)->current_outputs),
                       _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "data", offsetof(struct wlr_surface, data),
            sizeof(((struct wlr_surface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "renderer_destroy", offsetof(struct wlr_surface, renderer_destroy),
                        sizeof(((struct wlr_surface *)0)->renderer_destroy),
                        _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface", offsetof(struct wlr_surface_output, surface),
               sizeof(((struct wlr_surface_output *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "output", offsetof(struct wlr_surface_output, output),
              sizeof(((struct wlr_surface_output *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "link", offsetof(struct wlr_surface_output, link),
            sizeof(((struct wlr_surface_output *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "bind", offsetof(struct wlr_surface_output, bind),
            sizeof(((struct wlr_surface_output *)0)->bind),
            _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "destroy", offsetof(struct wlr_surface_output, destroy),
               sizeof(((struct wlr_surface_output *)0)->destroy),
               _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "name", offsetof(struct wlr_surface_role, name),
            sizeof(((struct wlr_surface_role *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 287) },
  { "commit", offsetof(struct wlr_surface_role, commit),
              sizeof(((struct wlr_surface_role *)0)->commit),
              _CFFI_OP(_CFFI_OP_NOOP, 1284) },
  { "precommit", offsetof(struct wlr_surface_role, precommit),
                 sizeof(((struct wlr_surface_role *)0)->precommit),
                 _CFFI_OP(_CFFI_OP_NOOP, 1284) },
  { "committed", offsetof(struct wlr_surface_state, committed),
                 sizeof(((struct wlr_surface_state *)0)->committed),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "seq", offsetof(struct wlr_surface_state, seq),
           sizeof(((struct wlr_surface_state *)0)->seq),
           _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "buffer", offsetof(struct wlr_surface_state, buffer),
              sizeof(((struct wlr_surface_state *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 1068) },
  { "dx", offsetof(struct wlr_surface_state, dx),
          sizeof(((struct wlr_surface_state *)0)->dx),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "dy", offsetof(struct wlr_surface_state, dy),
          sizeof(((struct wlr_surface_state *)0)->dy),
          _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "surface_damage", offsetof(struct wlr_surface_state, surface_damage),
                      sizeof(((struct wlr_surface_state *)0)->surface_damage),
                      _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "buffer_damage", offsetof(struct wlr_surface_state, buffer_damage),
                     sizeof(((struct wlr_surface_state *)0)->buffer_damage),
                     _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "opaque", offsetof(struct wlr_surface_state, opaque),
              sizeof(((struct wlr_surface_state *)0)->opaque),
              _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "input", offsetof(struct wlr_surface_state, input),
             sizeof(((struct wlr_surface_state *)0)->input),
             _CFFI_OP(_CFFI_OP_NOOP, 1038) },
  { "transform", offsetof(struct wlr_surface_state, transform),
                 sizeof(((struct wlr_surface_state *)0)->transform),
                 _CFFI_OP(_CFFI_OP_NOOP, 116) },
  { "scale", offsetof(struct wlr_surface_state, scale),
             sizeof(((struct wlr_surface_state *)0)->scale),
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "frame_callback_list", offsetof(struct wlr_surface_state, frame_callback_list),
                           sizeof(((struct wlr_surface_state *)0)->frame_callback_list),
                           _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "width", offsetof(struct wlr_surface_state, width),
             sizeof(((struct wlr_surface_state *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "height", offsetof(struct wlr_surface_state, height),
              sizeof(((struct wlr_surface_state *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "buffer_width", offsetof(struct wlr_surface_state, buffer_width),
                    sizeof(((struct wlr_surface_state *)0)->buffer_width),
                    _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "buffer_height", offsetof(struct wlr_surface_state, buffer_height),
                     sizeof(((struct wlr_surface_state *)0)->buffer_height),
                     _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "subsurfaces_below", offsetof(struct wlr_surface_state, subsurfaces_below),
                         sizeof(((struct wlr_surface_state *)0)->subsurfaces_below),
                         _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "subsurfaces_above", offsetof(struct wlr_surface_state, subsurfaces_above),
                         sizeof(((struct wlr_surface_state *)0)->subsurfaces_above),
                         _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "global", offsetof(struct wlr_virtual_keyboard_manager_v1, global),
              sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "virtual_keyboards", offsetof(struct wlr_virtual_keyboard_manager_v1, virtual_keyboards),
                         sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->virtual_keyboards),
                         _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_virtual_keyboard_manager_v1, display_destroy),
                       sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_virtual_keyboard_manager_v1, events),
              sizeof(((struct wlr_virtual_keyboard_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1012) },
  { "input_device", offsetof(struct wlr_virtual_keyboard_v1, input_device),
                    sizeof(((struct wlr_virtual_keyboard_v1 *)0)->input_device),
                    _CFFI_OP(_CFFI_OP_NOOP, 1114) },
  { "resource", offsetof(struct wlr_virtual_keyboard_v1, resource),
                sizeof(((struct wlr_virtual_keyboard_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "seat", offsetof(struct wlr_virtual_keyboard_v1, seat),
            sizeof(((struct wlr_virtual_keyboard_v1 *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "has_keymap", offsetof(struct wlr_virtual_keyboard_v1, has_keymap),
                  sizeof(((struct wlr_virtual_keyboard_v1 *)0)->has_keymap),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "link", offsetof(struct wlr_virtual_keyboard_v1, link),
            sizeof(((struct wlr_virtual_keyboard_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_virtual_keyboard_v1, events),
              sizeof(((struct wlr_virtual_keyboard_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1013) },
  { "image_count", offsetof(struct wlr_xcursor, image_count),
                   sizeof(((struct wlr_xcursor *)0)->image_count),
                   _CFFI_OP(_CFFI_OP_NOOP, 84) },
  { "images", offsetof(struct wlr_xcursor, images),
              sizeof(((struct wlr_xcursor *)0)->images),
              _CFFI_OP(_CFFI_OP_NOOP, 1215) },
  { "name", offsetof(struct wlr_xcursor, name),
            sizeof(((struct wlr_xcursor *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "total_delay", offsetof(struct wlr_xcursor, total_delay),
                   sizeof(((struct wlr_xcursor *)0)->total_delay),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "width", offsetof(struct wlr_xcursor_image, width),
             sizeof(((struct wlr_xcursor_image *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "height", offsetof(struct wlr_xcursor_image, height),
              sizeof(((struct wlr_xcursor_image *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "hotspot_x", offsetof(struct wlr_xcursor_image, hotspot_x),
                 sizeof(((struct wlr_xcursor_image *)0)->hotspot_x),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "hotspot_y", offsetof(struct wlr_xcursor_image, hotspot_y),
                 sizeof(((struct wlr_xcursor_image *)0)->hotspot_y),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "delay", offsetof(struct wlr_xcursor_image, delay),
             sizeof(((struct wlr_xcursor_image *)0)->delay),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "buffer", offsetof(struct wlr_xcursor_image, buffer),
              sizeof(((struct wlr_xcursor_image *)0)->buffer),
              _CFFI_OP(_CFFI_OP_NOOP, 873) },
  { "shell", offsetof(struct wlr_xdg_client, shell),
             sizeof(((struct wlr_xdg_client *)0)->shell),
             _CFFI_OP(_CFFI_OP_NOOP, 1227) },
  { "resource", offsetof(struct wlr_xdg_client, resource),
                sizeof(((struct wlr_xdg_client *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "client", offsetof(struct wlr_xdg_client, client),
              sizeof(((struct wlr_xdg_client *)0)->client),
              _CFFI_OP(_CFFI_OP_NOOP, 471) },
  { "surfaces", offsetof(struct wlr_xdg_client, surfaces),
                sizeof(((struct wlr_xdg_client *)0)->surfaces),
                _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "link", offsetof(struct wlr_xdg_client, link),
            sizeof(((struct wlr_xdg_client *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "ping_serial", offsetof(struct wlr_xdg_client, ping_serial),
                   sizeof(((struct wlr_xdg_client *)0)->ping_serial),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "ping_timer", offsetof(struct wlr_xdg_client, ping_timer),
                  sizeof(((struct wlr_xdg_client *)0)->ping_timer),
                  _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "global", offsetof(struct wlr_xdg_decoration_manager_v1, global),
              sizeof(((struct wlr_xdg_decoration_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "decorations", offsetof(struct wlr_xdg_decoration_manager_v1, decorations),
                   sizeof(((struct wlr_xdg_decoration_manager_v1 *)0)->decorations),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "display_destroy", offsetof(struct wlr_xdg_decoration_manager_v1, display_destroy),
                       sizeof(((struct wlr_xdg_decoration_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_xdg_decoration_manager_v1, events),
              sizeof(((struct wlr_xdg_decoration_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1014) },
  { "data", offsetof(struct wlr_xdg_decoration_manager_v1, data),
            sizeof(((struct wlr_xdg_decoration_manager_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "global", offsetof(struct wlr_xdg_output_manager_v1, global),
              sizeof(((struct wlr_xdg_output_manager_v1 *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "layout", offsetof(struct wlr_xdg_output_manager_v1, layout),
              sizeof(((struct wlr_xdg_output_manager_v1 *)0)->layout),
              _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "outputs", offsetof(struct wlr_xdg_output_manager_v1, outputs),
               sizeof(((struct wlr_xdg_output_manager_v1 *)0)->outputs),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_xdg_output_manager_v1, events),
              sizeof(((struct wlr_xdg_output_manager_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1016) },
  { "display_destroy", offsetof(struct wlr_xdg_output_manager_v1, display_destroy),
                       sizeof(((struct wlr_xdg_output_manager_v1 *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "layout_add", offsetof(struct wlr_xdg_output_manager_v1, layout_add),
                  sizeof(((struct wlr_xdg_output_manager_v1 *)0)->layout_add),
                  _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "layout_change", offsetof(struct wlr_xdg_output_manager_v1, layout_change),
                     sizeof(((struct wlr_xdg_output_manager_v1 *)0)->layout_change),
                     _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "layout_destroy", offsetof(struct wlr_xdg_output_manager_v1, layout_destroy),
                      sizeof(((struct wlr_xdg_output_manager_v1 *)0)->layout_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "base", offsetof(struct wlr_xdg_popup, base),
            sizeof(((struct wlr_xdg_popup *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "link", offsetof(struct wlr_xdg_popup, link),
            sizeof(((struct wlr_xdg_popup *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "resource", offsetof(struct wlr_xdg_popup, resource),
                sizeof(((struct wlr_xdg_popup *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "committed", offsetof(struct wlr_xdg_popup, committed),
                 sizeof(((struct wlr_xdg_popup *)0)->committed),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "parent", offsetof(struct wlr_xdg_popup, parent),
              sizeof(((struct wlr_xdg_popup *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "seat", offsetof(struct wlr_xdg_popup, seat),
            sizeof(((struct wlr_xdg_popup *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "geometry", offsetof(struct wlr_xdg_popup, geometry),
                sizeof(((struct wlr_xdg_popup *)0)->geometry),
                _CFFI_OP(_CFFI_OP_NOOP, 1067) },
  { "positioner", offsetof(struct wlr_xdg_popup, positioner),
                  sizeof(((struct wlr_xdg_popup *)0)->positioner),
                  _CFFI_OP(_CFFI_OP_NOOP, 1226) },
  { "grab_link", offsetof(struct wlr_xdg_popup, grab_link),
                 sizeof(((struct wlr_xdg_popup *)0)->grab_link),
                 _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "anchor_rect", offsetof(struct wlr_xdg_positioner, anchor_rect),
                   sizeof(((struct wlr_xdg_positioner *)0)->anchor_rect),
                   _CFFI_OP(_CFFI_OP_NOOP, 1067) },
  { "anchor", offsetof(struct wlr_xdg_positioner, anchor),
              sizeof(((struct wlr_xdg_positioner *)0)->anchor),
              _CFFI_OP(_CFFI_OP_NOOP, 949) },
  { "gravity", offsetof(struct wlr_xdg_positioner, gravity),
               sizeof(((struct wlr_xdg_positioner *)0)->gravity),
               _CFFI_OP(_CFFI_OP_NOOP, 951) },
  { "constraint_adjustment", offsetof(struct wlr_xdg_positioner, constraint_adjustment),
                             sizeof(((struct wlr_xdg_positioner *)0)->constraint_adjustment),
                             _CFFI_OP(_CFFI_OP_NOOP, 950) },
  { "size", offsetof(struct wlr_xdg_positioner, size),
            sizeof(((struct wlr_xdg_positioner *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 1018) },
  { "offset", offsetof(struct wlr_xdg_positioner, offset),
              sizeof(((struct wlr_xdg_positioner *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 1019) },
  { "global", offsetof(struct wlr_xdg_shell, global),
              sizeof(((struct wlr_xdg_shell *)0)->global),
              _CFFI_OP(_CFFI_OP_NOOP, 1052) },
  { "clients", offsetof(struct wlr_xdg_shell, clients),
               sizeof(((struct wlr_xdg_shell *)0)->clients),
               _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "popup_grabs", offsetof(struct wlr_xdg_shell, popup_grabs),
                   sizeof(((struct wlr_xdg_shell *)0)->popup_grabs),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "ping_timeout", offsetof(struct wlr_xdg_shell, ping_timeout),
                    sizeof(((struct wlr_xdg_shell *)0)->ping_timeout),
                    _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "display_destroy", offsetof(struct wlr_xdg_shell, display_destroy),
                       sizeof(((struct wlr_xdg_shell *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_xdg_shell, events),
              sizeof(((struct wlr_xdg_shell *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1017) },
  { "data", offsetof(struct wlr_xdg_shell, data),
            sizeof(((struct wlr_xdg_shell *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "client", offsetof(struct wlr_xdg_surface, client),
              sizeof(((struct wlr_xdg_surface *)0)->client),
              _CFFI_OP(_CFFI_OP_NOOP, 1219) },
  { "resource", offsetof(struct wlr_xdg_surface, resource),
                sizeof(((struct wlr_xdg_surface *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "surface", offsetof(struct wlr_xdg_surface, surface),
               sizeof(((struct wlr_xdg_surface *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "link", offsetof(struct wlr_xdg_surface, link),
            sizeof(((struct wlr_xdg_surface *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "role", offsetof(struct wlr_xdg_surface, role),
            sizeof(((struct wlr_xdg_surface *)0)->role),
            _CFFI_OP(_CFFI_OP_NOOP, 946) },
  { "toplevel", offsetof(struct wlr_xdg_surface, toplevel),
                sizeof(((struct wlr_xdg_surface *)0)->toplevel),
                _CFFI_OP(_CFFI_OP_NOOP, 1233) },
  { "popup", offsetof(struct wlr_xdg_surface, popup),
             sizeof(((struct wlr_xdg_surface *)0)->popup),
             _CFFI_OP(_CFFI_OP_NOOP, 849) },
  { "popups", offsetof(struct wlr_xdg_surface, popups),
              sizeof(((struct wlr_xdg_surface *)0)->popups),
              _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "added", offsetof(struct wlr_xdg_surface, added),
             sizeof(((struct wlr_xdg_surface *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "configured", offsetof(struct wlr_xdg_surface, configured),
                  sizeof(((struct wlr_xdg_surface *)0)->configured),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "mapped", offsetof(struct wlr_xdg_surface, mapped),
              sizeof(((struct wlr_xdg_surface *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "configure_idle", offsetof(struct wlr_xdg_surface, configure_idle),
                      sizeof(((struct wlr_xdg_surface *)0)->configure_idle),
                      _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "scheduled_serial", offsetof(struct wlr_xdg_surface, scheduled_serial),
                        sizeof(((struct wlr_xdg_surface *)0)->scheduled_serial),
                        _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "configure_list", offsetof(struct wlr_xdg_surface, configure_list),
                      sizeof(((struct wlr_xdg_surface *)0)->configure_list),
                      _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "current", offsetof(struct wlr_xdg_surface, current),
               sizeof(((struct wlr_xdg_surface *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1232) },
  { "pending", offsetof(struct wlr_xdg_surface, pending),
               sizeof(((struct wlr_xdg_surface *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1232) },
  { "surface_destroy", offsetof(struct wlr_xdg_surface, surface_destroy),
                       sizeof(((struct wlr_xdg_surface *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_commit", offsetof(struct wlr_xdg_surface, surface_commit),
                      sizeof(((struct wlr_xdg_surface *)0)->surface_commit),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "events", offsetof(struct wlr_xdg_surface, events),
              sizeof(((struct wlr_xdg_surface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1022) },
  { "data", offsetof(struct wlr_xdg_surface, data),
            sizeof(((struct wlr_xdg_surface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "surface", offsetof(struct wlr_xdg_surface_configure, surface),
               sizeof(((struct wlr_xdg_surface_configure *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "link", offsetof(struct wlr_xdg_surface_configure, link),
            sizeof(((struct wlr_xdg_surface_configure *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "serial", offsetof(struct wlr_xdg_surface_configure, serial),
              sizeof(((struct wlr_xdg_surface_configure *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "toplevel_configure", offsetof(struct wlr_xdg_surface_configure, toplevel_configure),
                          sizeof(((struct wlr_xdg_surface_configure *)0)->toplevel_configure),
                          _CFFI_OP(_CFFI_OP_NOOP, 1235) },
  { "configure_serial", offsetof(struct wlr_xdg_surface_state, configure_serial),
                        sizeof(((struct wlr_xdg_surface_state *)0)->configure_serial),
                        _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "geometry", offsetof(struct wlr_xdg_surface_state, geometry),
                sizeof(((struct wlr_xdg_surface_state *)0)->geometry),
                _CFFI_OP(_CFFI_OP_NOOP, 1067) },
  { "resource", offsetof(struct wlr_xdg_toplevel, resource),
                sizeof(((struct wlr_xdg_toplevel *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "base", offsetof(struct wlr_xdg_toplevel, base),
            sizeof(((struct wlr_xdg_toplevel *)0)->base),
            _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "added", offsetof(struct wlr_xdg_toplevel, added),
             sizeof(((struct wlr_xdg_toplevel *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "parent", offsetof(struct wlr_xdg_toplevel, parent),
              sizeof(((struct wlr_xdg_toplevel *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "parent_unmap", offsetof(struct wlr_xdg_toplevel, parent_unmap),
                    sizeof(((struct wlr_xdg_toplevel *)0)->parent_unmap),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "current", offsetof(struct wlr_xdg_toplevel, current),
               sizeof(((struct wlr_xdg_toplevel *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1245) },
  { "pending", offsetof(struct wlr_xdg_toplevel, pending),
               sizeof(((struct wlr_xdg_toplevel *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1245) },
  { "scheduled", offsetof(struct wlr_xdg_toplevel, scheduled),
                 sizeof(((struct wlr_xdg_toplevel *)0)->scheduled),
                 _CFFI_OP(_CFFI_OP_NOOP, 1236) },
  { "requested", offsetof(struct wlr_xdg_toplevel, requested),
                 sizeof(((struct wlr_xdg_toplevel *)0)->requested),
                 _CFFI_OP(_CFFI_OP_NOOP, 1241) },
  { "title", offsetof(struct wlr_xdg_toplevel, title),
             sizeof(((struct wlr_xdg_toplevel *)0)->title),
             _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "app_id", offsetof(struct wlr_xdg_toplevel, app_id),
              sizeof(((struct wlr_xdg_toplevel *)0)->app_id),
              _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "events", offsetof(struct wlr_xdg_toplevel, events),
              sizeof(((struct wlr_xdg_toplevel *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1020) },
  { "maximized", offsetof(struct wlr_xdg_toplevel_configure, maximized),
                 sizeof(((struct wlr_xdg_toplevel_configure *)0)->maximized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "fullscreen", offsetof(struct wlr_xdg_toplevel_configure, fullscreen),
                  sizeof(((struct wlr_xdg_toplevel_configure *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "resizing", offsetof(struct wlr_xdg_toplevel_configure, resizing),
                sizeof(((struct wlr_xdg_toplevel_configure *)0)->resizing),
                _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "activated", offsetof(struct wlr_xdg_toplevel_configure, activated),
                 sizeof(((struct wlr_xdg_toplevel_configure *)0)->activated),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "tiled", offsetof(struct wlr_xdg_toplevel_configure, tiled),
             sizeof(((struct wlr_xdg_toplevel_configure *)0)->tiled),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "width", offsetof(struct wlr_xdg_toplevel_configure, width),
             sizeof(((struct wlr_xdg_toplevel_configure *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "height", offsetof(struct wlr_xdg_toplevel_configure, height),
              sizeof(((struct wlr_xdg_toplevel_configure *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "resource", offsetof(struct wlr_xdg_toplevel_decoration_v1, resource),
                sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->resource),
                _CFFI_OP(_CFFI_OP_NOOP, 98) },
  { "surface", offsetof(struct wlr_xdg_toplevel_decoration_v1, surface),
               sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "manager", offsetof(struct wlr_xdg_toplevel_decoration_v1, manager),
               sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->manager),
               _CFFI_OP(_CFFI_OP_NOOP, 1221) },
  { "link", offsetof(struct wlr_xdg_toplevel_decoration_v1, link),
            sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "current", offsetof(struct wlr_xdg_toplevel_decoration_v1, current),
               sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->current),
               _CFFI_OP(_CFFI_OP_NOOP, 1239) },
  { "pending", offsetof(struct wlr_xdg_toplevel_decoration_v1, pending),
               sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->pending),
               _CFFI_OP(_CFFI_OP_NOOP, 1239) },
  { "scheduled_mode", offsetof(struct wlr_xdg_toplevel_decoration_v1, scheduled_mode),
                      sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->scheduled_mode),
                      _CFFI_OP(_CFFI_OP_NOOP, 412) },
  { "requested_mode", offsetof(struct wlr_xdg_toplevel_decoration_v1, requested_mode),
                      sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->requested_mode),
                      _CFFI_OP(_CFFI_OP_NOOP, 412) },
  { "added", offsetof(struct wlr_xdg_toplevel_decoration_v1, added),
             sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->added),
             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "configure_list", offsetof(struct wlr_xdg_toplevel_decoration_v1, configure_list),
                      sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->configure_list),
                      _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "events", offsetof(struct wlr_xdg_toplevel_decoration_v1, events),
              sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1015) },
  { "surface_destroy", offsetof(struct wlr_xdg_toplevel_decoration_v1, surface_destroy),
                       sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_configure", offsetof(struct wlr_xdg_toplevel_decoration_v1, surface_configure),
                         sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->surface_configure),
                         _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_ack_configure", offsetof(struct wlr_xdg_toplevel_decoration_v1, surface_ack_configure),
                             sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->surface_ack_configure),
                             _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface_commit", offsetof(struct wlr_xdg_toplevel_decoration_v1, surface_commit),
                      sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->surface_commit),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_xdg_toplevel_decoration_v1, data),
            sizeof(((struct wlr_xdg_toplevel_decoration_v1 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "link", offsetof(struct wlr_xdg_toplevel_decoration_v1_configure, link),
            sizeof(((struct wlr_xdg_toplevel_decoration_v1_configure *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "surface_configure", offsetof(struct wlr_xdg_toplevel_decoration_v1_configure, surface_configure),
                         sizeof(((struct wlr_xdg_toplevel_decoration_v1_configure *)0)->surface_configure),
                         _CFFI_OP(_CFFI_OP_NOOP, 1230) },
  { "mode", offsetof(struct wlr_xdg_toplevel_decoration_v1_configure, mode),
            sizeof(((struct wlr_xdg_toplevel_decoration_v1_configure *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 412) },
  { "mode", offsetof(struct wlr_xdg_toplevel_decoration_v1_state, mode),
            sizeof(((struct wlr_xdg_toplevel_decoration_v1_state *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 412) },
  { "surface", offsetof(struct wlr_xdg_toplevel_move_event, surface),
               sizeof(((struct wlr_xdg_toplevel_move_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "seat", offsetof(struct wlr_xdg_toplevel_move_event, seat),
            sizeof(((struct wlr_xdg_toplevel_move_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "serial", offsetof(struct wlr_xdg_toplevel_move_event, serial),
              sizeof(((struct wlr_xdg_toplevel_move_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "maximized", offsetof(struct wlr_xdg_toplevel_requested, maximized),
                 sizeof(((struct wlr_xdg_toplevel_requested *)0)->maximized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "minimized", offsetof(struct wlr_xdg_toplevel_requested, minimized),
                 sizeof(((struct wlr_xdg_toplevel_requested *)0)->minimized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "fullscreen", offsetof(struct wlr_xdg_toplevel_requested, fullscreen),
                  sizeof(((struct wlr_xdg_toplevel_requested *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "fullscreen_output", offsetof(struct wlr_xdg_toplevel_requested, fullscreen_output),
                         sizeof(((struct wlr_xdg_toplevel_requested *)0)->fullscreen_output),
                         _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "fullscreen_output_destroy", offsetof(struct wlr_xdg_toplevel_requested, fullscreen_output_destroy),
                                 sizeof(((struct wlr_xdg_toplevel_requested *)0)->fullscreen_output_destroy),
                                 _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "surface", offsetof(struct wlr_xdg_toplevel_resize_event, surface),
               sizeof(((struct wlr_xdg_toplevel_resize_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "seat", offsetof(struct wlr_xdg_toplevel_resize_event, seat),
            sizeof(((struct wlr_xdg_toplevel_resize_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "serial", offsetof(struct wlr_xdg_toplevel_resize_event, serial),
              sizeof(((struct wlr_xdg_toplevel_resize_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "edges", offsetof(struct wlr_xdg_toplevel_resize_event, edges),
             sizeof(((struct wlr_xdg_toplevel_resize_event *)0)->edges),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "surface", offsetof(struct wlr_xdg_toplevel_set_fullscreen_event, surface),
               sizeof(((struct wlr_xdg_toplevel_set_fullscreen_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "fullscreen", offsetof(struct wlr_xdg_toplevel_set_fullscreen_event, fullscreen),
                  sizeof(((struct wlr_xdg_toplevel_set_fullscreen_event *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "output", offsetof(struct wlr_xdg_toplevel_set_fullscreen_event, output),
              sizeof(((struct wlr_xdg_toplevel_set_fullscreen_event *)0)->output),
              _CFFI_OP(_CFFI_OP_NOOP, 29) },
  { "surface", offsetof(struct wlr_xdg_toplevel_show_window_menu_event, surface),
               sizeof(((struct wlr_xdg_toplevel_show_window_menu_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 276) },
  { "seat", offsetof(struct wlr_xdg_toplevel_show_window_menu_event, seat),
            sizeof(((struct wlr_xdg_toplevel_show_window_menu_event *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 1175) },
  { "serial", offsetof(struct wlr_xdg_toplevel_show_window_menu_event, serial),
              sizeof(((struct wlr_xdg_toplevel_show_window_menu_event *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "x", offsetof(struct wlr_xdg_toplevel_show_window_menu_event, x),
         sizeof(((struct wlr_xdg_toplevel_show_window_menu_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "y", offsetof(struct wlr_xdg_toplevel_show_window_menu_event, y),
         sizeof(((struct wlr_xdg_toplevel_show_window_menu_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "maximized", offsetof(struct wlr_xdg_toplevel_state, maximized),
                 sizeof(((struct wlr_xdg_toplevel_state *)0)->maximized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "fullscreen", offsetof(struct wlr_xdg_toplevel_state, fullscreen),
                  sizeof(((struct wlr_xdg_toplevel_state *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "resizing", offsetof(struct wlr_xdg_toplevel_state, resizing),
                sizeof(((struct wlr_xdg_toplevel_state *)0)->resizing),
                _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "activated", offsetof(struct wlr_xdg_toplevel_state, activated),
                 sizeof(((struct wlr_xdg_toplevel_state *)0)->activated),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "tiled", offsetof(struct wlr_xdg_toplevel_state, tiled),
             sizeof(((struct wlr_xdg_toplevel_state *)0)->tiled),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "width", offsetof(struct wlr_xdg_toplevel_state, width),
             sizeof(((struct wlr_xdg_toplevel_state *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "height", offsetof(struct wlr_xdg_toplevel_state, height),
              sizeof(((struct wlr_xdg_toplevel_state *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "max_width", offsetof(struct wlr_xdg_toplevel_state, max_width),
                 sizeof(((struct wlr_xdg_toplevel_state *)0)->max_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "max_height", offsetof(struct wlr_xdg_toplevel_state, max_height),
                  sizeof(((struct wlr_xdg_toplevel_state *)0)->max_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "min_width", offsetof(struct wlr_xdg_toplevel_state, min_width),
                 sizeof(((struct wlr_xdg_toplevel_state *)0)->min_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "min_height", offsetof(struct wlr_xdg_toplevel_state, min_height),
                  sizeof(((struct wlr_xdg_toplevel_state *)0)->min_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "server", offsetof(struct wlr_xwayland, server),
              sizeof(((struct wlr_xwayland *)0)->server),
              _CFFI_OP(_CFFI_OP_NOOP, 881) },
  { "xwm", offsetof(struct wlr_xwayland, xwm),
           sizeof(((struct wlr_xwayland *)0)->xwm),
           _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "cursor", offsetof(struct wlr_xwayland, cursor),
              sizeof(((struct wlr_xwayland *)0)->cursor),
              _CFFI_OP(_CFFI_OP_NOOP, 1247) },
  { "display_name", offsetof(struct wlr_xwayland, display_name),
                    sizeof(((struct wlr_xwayland *)0)->display_name),
                    _CFFI_OP(_CFFI_OP_NOOP, 287) },
  { "wl_display", offsetof(struct wlr_xwayland, wl_display),
                  sizeof(((struct wlr_xwayland *)0)->wl_display),
                  _CFFI_OP(_CFFI_OP_NOOP, 47) },
  { "compositor", offsetof(struct wlr_xwayland, compositor),
                  sizeof(((struct wlr_xwayland *)0)->compositor),
                  _CFFI_OP(_CFFI_OP_NOOP, 363) },
  { "seat", offsetof(struct wlr_xwayland, seat),
            sizeof(((struct wlr_xwayland *)0)->seat),
            _CFFI_OP(_CFFI_OP_NOOP, 71) },
  { "events", offsetof(struct wlr_xwayland, events),
              sizeof(((struct wlr_xwayland *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1027) },
  { "user_event_handler", offsetof(struct wlr_xwayland, user_event_handler),
                          sizeof(((struct wlr_xwayland *)0)->user_event_handler),
                          _CFFI_OP(_CFFI_OP_NOOP, 973) },
  { "server_ready", offsetof(struct wlr_xwayland, server_ready),
                    sizeof(((struct wlr_xwayland *)0)->server_ready),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "server_destroy", offsetof(struct wlr_xwayland, server_destroy),
                      sizeof(((struct wlr_xwayland *)0)->server_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "seat_destroy", offsetof(struct wlr_xwayland, seat_destroy),
                    sizeof(((struct wlr_xwayland *)0)->seat_destroy),
                    _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_xwayland, data),
            sizeof(((struct wlr_xwayland *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "surface", offsetof(struct wlr_xwayland_minimize_event, surface),
               sizeof(((struct wlr_xwayland_minimize_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 884) },
  { "minimize", offsetof(struct wlr_xwayland_minimize_event, minimize),
                sizeof(((struct wlr_xwayland_minimize_event *)0)->minimize),
                _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "surface", offsetof(struct wlr_xwayland_move_event, surface),
               sizeof(((struct wlr_xwayland_move_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 884) },
  { "id", offsetof(struct wlr_xwayland_remove_startup_info_event, id),
          sizeof(((struct wlr_xwayland_remove_startup_info_event *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 287) },
  { "window", offsetof(struct wlr_xwayland_remove_startup_info_event, window),
              sizeof(((struct wlr_xwayland_remove_startup_info_event *)0)->window),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "surface", offsetof(struct wlr_xwayland_resize_event, surface),
               sizeof(((struct wlr_xwayland_resize_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 884) },
  { "edges", offsetof(struct wlr_xwayland_resize_event, edges),
             sizeof(((struct wlr_xwayland_resize_event *)0)->edges),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "pid", offsetof(struct wlr_xwayland_server, pid),
           sizeof(((struct wlr_xwayland_server *)0)->pid),
           _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "client", offsetof(struct wlr_xwayland_server, client),
              sizeof(((struct wlr_xwayland_server *)0)->client),
              _CFFI_OP(_CFFI_OP_NOOP, 471) },
  { "pipe_source", offsetof(struct wlr_xwayland_server, pipe_source),
                   sizeof(((struct wlr_xwayland_server *)0)->pipe_source),
                   _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "wm_fd", offsetof(struct wlr_xwayland_server, wm_fd),
             sizeof(((struct wlr_xwayland_server *)0)->wm_fd),
             _CFFI_OP(_CFFI_OP_NOOP, 977) },
  { "wl_fd", offsetof(struct wlr_xwayland_server, wl_fd),
             sizeof(((struct wlr_xwayland_server *)0)->wl_fd),
             _CFFI_OP(_CFFI_OP_NOOP, 977) },
  { "server_start", offsetof(struct wlr_xwayland_server, server_start),
                    sizeof(((struct wlr_xwayland_server *)0)->server_start),
                    _CFFI_OP(_CFFI_OP_NOOP, 1269) },
  { "display", offsetof(struct wlr_xwayland_server, display),
               sizeof(((struct wlr_xwayland_server *)0)->display),
               _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "display_name", offsetof(struct wlr_xwayland_server, display_name),
                    sizeof(((struct wlr_xwayland_server *)0)->display_name),
                    _CFFI_OP(_CFFI_OP_NOOP, 931) },
  { "x_fd", offsetof(struct wlr_xwayland_server, x_fd),
            sizeof(((struct wlr_xwayland_server *)0)->x_fd),
            _CFFI_OP(_CFFI_OP_NOOP, 977) },
  { "x_fd_read_event", offsetof(struct wlr_xwayland_server, x_fd_read_event),
                       sizeof(((struct wlr_xwayland_server *)0)->x_fd_read_event),
                       _CFFI_OP(_CFFI_OP_NOOP, 1049) },
  { "options", offsetof(struct wlr_xwayland_server, options),
               sizeof(((struct wlr_xwayland_server *)0)->options),
               _CFFI_OP(_CFFI_OP_NOOP, 1254) },
  { "wl_display", offsetof(struct wlr_xwayland_server, wl_display),
                  sizeof(((struct wlr_xwayland_server *)0)->wl_display),
                  _CFFI_OP(_CFFI_OP_NOOP, 47) },
  { "events", offsetof(struct wlr_xwayland_server, events),
              sizeof(((struct wlr_xwayland_server *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1026) },
  { "client_destroy", offsetof(struct wlr_xwayland_server, client_destroy),
                      sizeof(((struct wlr_xwayland_server *)0)->client_destroy),
                      _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "display_destroy", offsetof(struct wlr_xwayland_server, display_destroy),
                       sizeof(((struct wlr_xwayland_server *)0)->display_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_xwayland_server, data),
            sizeof(((struct wlr_xwayland_server *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "lazy", offsetof(struct wlr_xwayland_server_options, lazy),
            sizeof(((struct wlr_xwayland_server_options *)0)->lazy),
            _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "enable_wm", offsetof(struct wlr_xwayland_server_options, enable_wm),
                 sizeof(((struct wlr_xwayland_server_options *)0)->enable_wm),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "no_touch_pointer_emulation", offsetof(struct wlr_xwayland_server_options, no_touch_pointer_emulation),
                                  sizeof(((struct wlr_xwayland_server_options *)0)->no_touch_pointer_emulation),
                                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "window_id", offsetof(struct wlr_xwayland_surface, window_id),
                 sizeof(((struct wlr_xwayland_surface *)0)->window_id),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "xwm", offsetof(struct wlr_xwayland_surface, xwm),
           sizeof(((struct wlr_xwayland_surface *)0)->xwm),
           _CFFI_OP(_CFFI_OP_NOOP, 139) },
  { "surface_id", offsetof(struct wlr_xwayland_surface, surface_id),
                  sizeof(((struct wlr_xwayland_surface *)0)->surface_id),
                  _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "link", offsetof(struct wlr_xwayland_surface, link),
            sizeof(((struct wlr_xwayland_surface *)0)->link),
            _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "stack_link", offsetof(struct wlr_xwayland_surface, stack_link),
                  sizeof(((struct wlr_xwayland_surface *)0)->stack_link),
                  _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "unpaired_link", offsetof(struct wlr_xwayland_surface, unpaired_link),
                     sizeof(((struct wlr_xwayland_surface *)0)->unpaired_link),
                     _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "surface", offsetof(struct wlr_xwayland_surface, surface),
               sizeof(((struct wlr_xwayland_surface *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 75) },
  { "x", offsetof(struct wlr_xwayland_surface, x),
         sizeof(((struct wlr_xwayland_surface *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 892) },
  { "y", offsetof(struct wlr_xwayland_surface, y),
         sizeof(((struct wlr_xwayland_surface *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 892) },
  { "width", offsetof(struct wlr_xwayland_surface, width),
             sizeof(((struct wlr_xwayland_surface *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "height", offsetof(struct wlr_xwayland_surface, height),
              sizeof(((struct wlr_xwayland_surface *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "saved_width", offsetof(struct wlr_xwayland_surface, saved_width),
                   sizeof(((struct wlr_xwayland_surface *)0)->saved_width),
                   _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "saved_height", offsetof(struct wlr_xwayland_surface, saved_height),
                    sizeof(((struct wlr_xwayland_surface *)0)->saved_height),
                    _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "override_redirect", offsetof(struct wlr_xwayland_surface, override_redirect),
                         sizeof(((struct wlr_xwayland_surface *)0)->override_redirect),
                         _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "mapped", offsetof(struct wlr_xwayland_surface, mapped),
              sizeof(((struct wlr_xwayland_surface *)0)->mapped),
              _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "title", offsetof(struct wlr_xwayland_surface, title),
             sizeof(((struct wlr_xwayland_surface *)0)->title),
             _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "class", offsetof(struct wlr_xwayland_surface, class),
             sizeof(((struct wlr_xwayland_surface *)0)->class),
             _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "instance", offsetof(struct wlr_xwayland_surface, instance),
                sizeof(((struct wlr_xwayland_surface *)0)->instance),
                _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "role", offsetof(struct wlr_xwayland_surface, role),
            sizeof(((struct wlr_xwayland_surface *)0)->role),
            _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "startup_id", offsetof(struct wlr_xwayland_surface, startup_id),
                  sizeof(((struct wlr_xwayland_surface *)0)->startup_id),
                  _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "pid", offsetof(struct wlr_xwayland_surface, pid),
           sizeof(((struct wlr_xwayland_surface *)0)->pid),
           _CFFI_OP(_CFFI_OP_NOOP, 59) },
  { "has_utf8_title", offsetof(struct wlr_xwayland_surface, has_utf8_title),
                      sizeof(((struct wlr_xwayland_surface *)0)->has_utf8_title),
                      _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "children", offsetof(struct wlr_xwayland_surface, children),
                sizeof(((struct wlr_xwayland_surface *)0)->children),
                _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "parent", offsetof(struct wlr_xwayland_surface, parent),
              sizeof(((struct wlr_xwayland_surface *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 884) },
  { "parent_link", offsetof(struct wlr_xwayland_surface, parent_link),
                   sizeof(((struct wlr_xwayland_surface *)0)->parent_link),
                   _CFFI_OP(_CFFI_OP_NOOP, 1055) },
  { "window_type", offsetof(struct wlr_xwayland_surface, window_type),
                   sizeof(((struct wlr_xwayland_surface *)0)->window_type),
                   _CFFI_OP(_CFFI_OP_NOOP, 755) },
  { "window_type_len", offsetof(struct wlr_xwayland_surface, window_type_len),
                       sizeof(((struct wlr_xwayland_surface *)0)->window_type_len),
                       _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "protocols", offsetof(struct wlr_xwayland_surface, protocols),
                 sizeof(((struct wlr_xwayland_surface *)0)->protocols),
                 _CFFI_OP(_CFFI_OP_NOOP, 755) },
  { "protocols_len", offsetof(struct wlr_xwayland_surface, protocols_len),
                     sizeof(((struct wlr_xwayland_surface *)0)->protocols_len),
                     _CFFI_OP(_CFFI_OP_NOOP, 756) },
  { "decorations", offsetof(struct wlr_xwayland_surface, decorations),
                   sizeof(((struct wlr_xwayland_surface *)0)->decorations),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "hints", offsetof(struct wlr_xwayland_surface, hints),
             sizeof(((struct wlr_xwayland_surface *)0)->hints),
             _CFFI_OP(_CFFI_OP_NOOP, 1257) },
  { "hints_urgency", offsetof(struct wlr_xwayland_surface, hints_urgency),
                     sizeof(((struct wlr_xwayland_surface *)0)->hints_urgency),
                     _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "size_hints", offsetof(struct wlr_xwayland_surface, size_hints),
                  sizeof(((struct wlr_xwayland_surface *)0)->size_hints),
                  _CFFI_OP(_CFFI_OP_NOOP, 1259) },
  { "pinging", offsetof(struct wlr_xwayland_surface, pinging),
               sizeof(((struct wlr_xwayland_surface *)0)->pinging),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "ping_timer", offsetof(struct wlr_xwayland_surface, ping_timer),
                  sizeof(((struct wlr_xwayland_surface *)0)->ping_timer),
                  _CFFI_OP(_CFFI_OP_NOOP, 1048) },
  { "modal", offsetof(struct wlr_xwayland_surface, modal),
             sizeof(((struct wlr_xwayland_surface *)0)->modal),
             _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "fullscreen", offsetof(struct wlr_xwayland_surface, fullscreen),
                  sizeof(((struct wlr_xwayland_surface *)0)->fullscreen),
                  _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "maximized_vert", offsetof(struct wlr_xwayland_surface, maximized_vert),
                      sizeof(((struct wlr_xwayland_surface *)0)->maximized_vert),
                      _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "maximized_horz", offsetof(struct wlr_xwayland_surface, maximized_horz),
                      sizeof(((struct wlr_xwayland_surface *)0)->maximized_horz),
                      _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "minimized", offsetof(struct wlr_xwayland_surface, minimized),
                 sizeof(((struct wlr_xwayland_surface *)0)->minimized),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "has_alpha", offsetof(struct wlr_xwayland_surface, has_alpha),
                 sizeof(((struct wlr_xwayland_surface *)0)->has_alpha),
                 _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "events", offsetof(struct wlr_xwayland_surface, events),
              sizeof(((struct wlr_xwayland_surface *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 1028) },
  { "surface_destroy", offsetof(struct wlr_xwayland_surface, surface_destroy),
                       sizeof(((struct wlr_xwayland_surface *)0)->surface_destroy),
                       _CFFI_OP(_CFFI_OP_NOOP, 1056) },
  { "data", offsetof(struct wlr_xwayland_surface, data),
            sizeof(((struct wlr_xwayland_surface *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 97) },
  { "surface", offsetof(struct wlr_xwayland_surface_configure_event, surface),
               sizeof(((struct wlr_xwayland_surface_configure_event *)0)->surface),
               _CFFI_OP(_CFFI_OP_NOOP, 884) },
  { "x", offsetof(struct wlr_xwayland_surface_configure_event, x),
         sizeof(((struct wlr_xwayland_surface_configure_event *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 892) },
  { "y", offsetof(struct wlr_xwayland_surface_configure_event, y),
         sizeof(((struct wlr_xwayland_surface_configure_event *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 892) },
  { "width", offsetof(struct wlr_xwayland_surface_configure_event, width),
             sizeof(((struct wlr_xwayland_surface_configure_event *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "height", offsetof(struct wlr_xwayland_surface_configure_event, height),
              sizeof(((struct wlr_xwayland_surface_configure_event *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "mask", offsetof(struct wlr_xwayland_surface_configure_event, mask),
            sizeof(((struct wlr_xwayland_surface_configure_event *)0)->mask),
            _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "flags", offsetof(struct wlr_xwayland_surface_hints, flags),
             sizeof(((struct wlr_xwayland_surface_hints *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "input", offsetof(struct wlr_xwayland_surface_hints, input),
             sizeof(((struct wlr_xwayland_surface_hints *)0)->input),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "initial_state", offsetof(struct wlr_xwayland_surface_hints, initial_state),
                     sizeof(((struct wlr_xwayland_surface_hints *)0)->initial_state),
                     _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "icon_pixmap", offsetof(struct wlr_xwayland_surface_hints, icon_pixmap),
                   sizeof(((struct wlr_xwayland_surface_hints *)0)->icon_pixmap),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "icon_window", offsetof(struct wlr_xwayland_surface_hints, icon_window),
                   sizeof(((struct wlr_xwayland_surface_hints *)0)->icon_window),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "icon_x", offsetof(struct wlr_xwayland_surface_hints, icon_x),
              sizeof(((struct wlr_xwayland_surface_hints *)0)->icon_x),
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "icon_y", offsetof(struct wlr_xwayland_surface_hints, icon_y),
              sizeof(((struct wlr_xwayland_surface_hints *)0)->icon_y),
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "icon_mask", offsetof(struct wlr_xwayland_surface_hints, icon_mask),
                 sizeof(((struct wlr_xwayland_surface_hints *)0)->icon_mask),
                 _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "window_group", offsetof(struct wlr_xwayland_surface_hints, window_group),
                    sizeof(((struct wlr_xwayland_surface_hints *)0)->window_group),
                    _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "flags", offsetof(struct wlr_xwayland_surface_size_hints, flags),
             sizeof(((struct wlr_xwayland_surface_size_hints *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "x", offsetof(struct wlr_xwayland_surface_size_hints, x),
         sizeof(((struct wlr_xwayland_surface_size_hints *)0)->x),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y", offsetof(struct wlr_xwayland_surface_size_hints, y),
         sizeof(((struct wlr_xwayland_surface_size_hints *)0)->y),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "width", offsetof(struct wlr_xwayland_surface_size_hints, width),
             sizeof(((struct wlr_xwayland_surface_size_hints *)0)->width),
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height", offsetof(struct wlr_xwayland_surface_size_hints, height),
              sizeof(((struct wlr_xwayland_surface_size_hints *)0)->height),
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "min_width", offsetof(struct wlr_xwayland_surface_size_hints, min_width),
                 sizeof(((struct wlr_xwayland_surface_size_hints *)0)->min_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "min_height", offsetof(struct wlr_xwayland_surface_size_hints, min_height),
                  sizeof(((struct wlr_xwayland_surface_size_hints *)0)->min_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "max_width", offsetof(struct wlr_xwayland_surface_size_hints, max_width),
                 sizeof(((struct wlr_xwayland_surface_size_hints *)0)->max_width),
                 _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "max_height", offsetof(struct wlr_xwayland_surface_size_hints, max_height),
                  sizeof(((struct wlr_xwayland_surface_size_hints *)0)->max_height),
                  _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "width_inc", offsetof(struct wlr_xwayland_surface_size_hints, width_inc),
                 sizeof(((struct wlr_xwayland_surface_size_hints *)0)->width_inc),
                 _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height_inc", offsetof(struct wlr_xwayland_surface_size_hints, height_inc),
                  sizeof(((struct wlr_xwayland_surface_size_hints *)0)->height_inc),
                  _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "base_width", offsetof(struct wlr_xwayland_surface_size_hints, base_width),
                  sizeof(((struct wlr_xwayland_surface_size_hints *)0)->base_width),
                  _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "base_height", offsetof(struct wlr_xwayland_surface_size_hints, base_height),
                   sizeof(((struct wlr_xwayland_surface_size_hints *)0)->base_height),
                   _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "min_aspect_num", offsetof(struct wlr_xwayland_surface_size_hints, min_aspect_num),
                      sizeof(((struct wlr_xwayland_surface_size_hints *)0)->min_aspect_num),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "min_aspect_den", offsetof(struct wlr_xwayland_surface_size_hints, min_aspect_den),
                      sizeof(((struct wlr_xwayland_surface_size_hints *)0)->min_aspect_den),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "max_aspect_num", offsetof(struct wlr_xwayland_surface_size_hints, max_aspect_num),
                      sizeof(((struct wlr_xwayland_surface_size_hints *)0)->max_aspect_num),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "max_aspect_den", offsetof(struct wlr_xwayland_surface_size_hints, max_aspect_den),
                      sizeof(((struct wlr_xwayland_surface_size_hints *)0)->max_aspect_den),
                      _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "win_gravity", offsetof(struct wlr_xwayland_surface_size_hints, win_gravity),
                   sizeof(((struct wlr_xwayland_surface_size_hints *)0)->win_gravity),
                   _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "response_type", offsetof(xcb_intern_atom_reply_t, response_type),
                     sizeof(((xcb_intern_atom_reply_t *)0)->response_type),
                     _CFFI_OP(_CFFI_OP_NOOP, 919) },
  { "pad0", offsetof(xcb_intern_atom_reply_t, pad0),
            sizeof(((xcb_intern_atom_reply_t *)0)->pad0),
            _CFFI_OP(_CFFI_OP_NOOP, 919) },
  { "sequence", offsetof(xcb_intern_atom_reply_t, sequence),
                sizeof(((xcb_intern_atom_reply_t *)0)->sequence),
                _CFFI_OP(_CFFI_OP_NOOP, 894) },
  { "length", offsetof(xcb_intern_atom_reply_t, length),
              sizeof(((xcb_intern_atom_reply_t *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "atom", offsetof(xcb_intern_atom_reply_t, atom),
            sizeof(((xcb_intern_atom_reply_t *)0)->atom),
            _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_input", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_output", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "activity_notify", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "idle", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "resume", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_inhibitor", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "activate", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "deactivate", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "rate", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "delay", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "key", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "modifiers", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "keymap", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "repeat_info", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "motion", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "motion_absolute", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "button", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "axis", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "frame", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_begin", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_update", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_end", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_begin", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_update", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_end", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "hold_begin", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "hold_end", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_up", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_down", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_motion", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_cancel", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_frame", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "tablet_tool_axis", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "tablet_tool_proximity", (size_t)-1,
                             (size_t)-1,
                             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "tablet_tool_tip", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "tablet_tool_button", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "frame", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "damage", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "needs_frame", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "precommit", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "commit", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "present", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "bind", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "enable", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "mode", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "description", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "frame", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "add", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "change", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "apply", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "test", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "width", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "refresh", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "set_mode", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "motion", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "motion_absolute", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "button", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "axis", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "frame", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_begin", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_update", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "swipe_end", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_begin", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_update", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pinch_end", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "x", (size_t)-1,
         (size_t)-1,
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "y", (size_t)-1,
         (size_t)-1,
         _CFFI_OP(_CFFI_OP_NOOP, 16) },
  { "set_region", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_constraint", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_surface", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_relative_pointer", (size_t)-1,
                            (size_t)-1,
                            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "focus_change", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "focus_change", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pointer_grab_begin", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "pointer_grab_end", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "keyboard_grab_begin", (size_t)-1,
                           (size_t)-1,
                           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "keyboard_grab_end", (size_t)-1,
                         (size_t)-1,
                         _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_grab_begin", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "touch_grab_end", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_set_cursor", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_set_selection", (size_t)-1,
                             (size_t)-1,
                             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_selection", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_set_primary_selection", (size_t)-1,
                                     (size_t)-1,
                                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_primary_selection", (size_t)-1,
                             (size_t)-1,
                             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_start_drag", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "start_drag", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_decoration", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "commit", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_subsurface", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_device", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "map", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "unmap", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_virtual_keyboard", (size_t)-1,
                            (size_t)-1,
                            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_toplevel_decoration", (size_t)-1,
                               (size_t)-1,
                               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_mode", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_surface", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "width", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "height", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "x", (size_t)-1,
         (size_t)-1,
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "y", (size_t)-1,
         (size_t)-1,
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "request_maximize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_fullscreen", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_minimize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_move", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_resize", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_show_window_menu", (size_t)-1,
                                (size_t)-1,
                                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_parent", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_title", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_app_id", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "map", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "unmap", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "ping_timeout", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_popup", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "map", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "unmap", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "configure", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "ack_configure", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_surface", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "top", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "right", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "bottom", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "left", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 80) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "map", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "unmap", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_popup", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "ready", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "ready", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "new_surface", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "remove_startup_info", (size_t)-1,
                           (size_t)-1,
                           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_configure", (size_t)-1,
                         (size_t)-1,
                         _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_move", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_resize", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_minimize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_maximize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_fullscreen", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_activate", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "map", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "unmap", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_title", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_class", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_role", (size_t)-1,
                (size_t)-1,
                _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_parent", (size_t)-1,
                  (size_t)-1,
                  _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_pid", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_startup_id", (size_t)-1,
                      (size_t)-1,
                      _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_window_type", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_hints", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_decorations", (size_t)-1,
                       (size_t)-1,
                       _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_override_redirect", (size_t)-1,
                             (size_t)-1,
                             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_geometry", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "ping_timeout", (size_t)-1,
                    (size_t)-1,
                    _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "focus", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "motion", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "drop", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_maximize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_minimize", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_activate", (size_t)-1,
                        (size_t)-1,
                        _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_fullscreen", (size_t)-1,
                          (size_t)-1,
                          _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "request_close", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "set_rectangle", (size_t)-1,
                     (size_t)-1,
                     _CFFI_OP(_CFFI_OP_NOOP, 1062) },
  { "destroy", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 1062) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 988, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 827, 3 /* unnamed */ },
  { "$10", 979, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 830, 1 /* unnamed */ },
  { "$11", 980, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 831, 2 /* unnamed */ },
  { "$12", 981, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 833, 3 /* unnamed */ },
  { "$13", 982, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 836, 2 /* unnamed */ },
  { "$14", 983, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 838, 1 /* unnamed */ },
  { "$16", 984, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 839, 1 /* unnamed */ },
  { "$17", 985, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 840, 3 /* unnamed */ },
  { "$18", 986, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 843, 2 /* unnamed */ },
  { "$19", 987, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 845, 5 /* unnamed */ },
  { "$2", 999, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 850, 22 /* unnamed */ },
  { "$20", 989, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 872, 11 /* unnamed */ },
  { "$21", 990, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 883, 2 /* unnamed */ },
  { "$22", 991, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 885, 3 /* unnamed */ },
  { "$23", 992, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 888, 3 /* unnamed */ },
  { "$24", 993, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 891, 3 /* unnamed */ },
  { "$25", 994, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 894, 2 /* unnamed */ },
  { "$26", 995, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 896, 11 /* unnamed */ },
  { "$27", 996, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 907, 2 /* unnamed */ },
  { "$28", 997, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 909, 2 /* unnamed */ },
  { "$29", 998, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 911, 1 /* unnamed */ },
  { "$3", 1010, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 912, 2 /* unnamed */ },
  { "$30", 1000, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 914, 1 /* unnamed */ },
  { "$31", 1001, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 915, 2 /* unnamed */ },
  { "$32", 1002, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 917, 1 /* unnamed */ },
  { "$33", 1003, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 918, 1 /* unnamed */ },
  { "$34", 1004, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 919, 1 /* unnamed */ },
  { "$35", 1005, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 920, 1 /* unnamed */ },
  { "$36", 1006, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 921, 1 /* unnamed */ },
  { "$37", 1007, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 922, 14 /* unnamed */ },
  { "$38", 1008, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 936, 2 /* unnamed */ },
  { "$39", 1009, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 938, 3 /* unnamed */ },
  { "$4", 1021, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 941, 2 /* unnamed */ },
  { "$40", 1011, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 943, 3 /* unnamed */ },
  { "$41", 1012, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 946, 2 /* unnamed */ },
  { "$42", 1013, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 948, 1 /* unnamed */ },
  { "$43", 1014, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 949, 2 /* unnamed */ },
  { "$44", 1015, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 951, 2 /* unnamed */ },
  { "$45", 1016, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 953, 1 /* unnamed */ },
  { "$46", 1017, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 954, 2 /* unnamed */ },
  { "$47", 1018, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 956, 2 /* unnamed */ },
  { "$48", 1019, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 958, 2 /* unnamed */ },
  { "$49", 1020, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 960, 9 /* unnamed */ },
  { "$5", 1029, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 969, 3 /* unnamed */ },
  { "$51", 1022, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 972, 7 /* unnamed */ },
  { "$52", 1023, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 979, 2 /* unnamed */ },
  { "$53", 1024, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 981, 4 /* unnamed */ },
  { "$54", 1025, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 985, 4 /* unnamed */ },
  { "$55", 1026, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 989, 2 /* unnamed */ },
  { "$56", 1027, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 991, 3 /* unnamed */ },
  { "$57", 1028, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 994, 22 /* unnamed */ },
  { "$6", 1030, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 1016, 4 /* unnamed */ },
  { "$7", 1031, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 1020, 1 /* unnamed */ },
  { "$8", 1032, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 1021, 1 /* unnamed */ },
  { "$9", 1033, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 1022, 7 /* unnamed */ },
  { "$FILE", 928, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$va_list", 1280, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "$xcb_connection_t", 1288, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$xcb_generic_error_t", 1290, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$xcb_generic_event_t", 1291, 0,
    sizeof(xcb_generic_event_t), offsetof(struct _cffi_align_typedef_xcb_generic_event_t, y), 0, 0 },
  { "libinput_device", 1035, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "pixman_box32", 1037, 0,
    sizeof(struct pixman_box32), offsetof(struct _cffi_align_struct_pixman_box32, y), 0, 4 },
  { "pixman_region32", 1038, 0,
    sizeof(struct pixman_region32), offsetof(struct _cffi_align_struct_pixman_region32, y), 4, 0 },
  { "timespec", 1041, 0,
    sizeof(struct timespec), offsetof(struct _cffi_align_struct_timespec, y), 4, 2 },
  { "wl_argument", 1279, _CFFI_F_UNION|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_array", 1042, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_client", 1043, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_display", 1044, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_loop", 1046, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_queue", 1047, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_event_source", 1051, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_global", 1053, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_interface", 1054, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_list", 1055, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_listener", 1056, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_listener_container", 1057, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_message", 1058, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_object", 1059, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_proxy", 1060, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_resource", 1061, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wl_signal", 1062, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "wlr_allocator", 1063, 0,
    sizeof(struct wlr_allocator), offsetof(struct _cffi_align_struct_wlr_allocator, y), 6, 0 },
  { "wlr_backend", 1064, 0,
    sizeof(struct wlr_backend), offsetof(struct _cffi_align_struct_wlr_backend, y), 6, 2 },
  { "wlr_backend_impl", 1066, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_box", 1067, 0,
    sizeof(struct wlr_box), offsetof(struct _cffi_align_struct_wlr_box, y), 8, 4 },
  { "wlr_buffer", 1069, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_client_buffer", 1071, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_compositor", 1072, 0,
    sizeof(struct wlr_compositor), offsetof(struct _cffi_align_struct_wlr_compositor, y), 12, 5 },
  { "wlr_cursor", 1073, 0,
    sizeof(struct wlr_cursor), offsetof(struct _cffi_align_struct_wlr_cursor, y), 17, 5 },
  { "wlr_cursor_state", 1075, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_data_control_manager_v1", 1077, 0,
    sizeof(struct wlr_data_control_manager_v1), offsetof(struct _cffi_align_struct_wlr_data_control_manager_v1, y), 22, 4 },
  { "wlr_data_device_manager", 1079, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_data_source", 1080, 0,
    sizeof(struct wlr_data_source), offsetof(struct _cffi_align_struct_wlr_data_source, y), 26, 7 },
  { "wlr_data_source_impl", 1082, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_drag", 1083, 0,
    sizeof(struct wlr_drag), offsetof(struct _cffi_align_struct_wlr_drag, y), 33, 20 },
  { "wlr_drag_drop_event", 1084, 0,
    sizeof(struct wlr_drag_drop_event), offsetof(struct _cffi_align_struct_wlr_drag_drop_event, y), 53, 2 },
  { "wlr_drag_icon", 1086, 0,
    sizeof(struct wlr_drag_icon), offsetof(struct _cffi_align_struct_wlr_drag_icon, y), 55, 6 },
  { "wlr_drag_motion_event", 1087, 0,
    sizeof(struct wlr_drag_motion_event), offsetof(struct _cffi_align_struct_wlr_drag_motion_event, y), 61, 4 },
  { "wlr_event_keyboard_key", 1088, 0,
    sizeof(struct wlr_event_keyboard_key), offsetof(struct _cffi_align_struct_wlr_event_keyboard_key, y), 65, 4 },
  { "wlr_event_pointer_axis", 1089, 0,
    sizeof(struct wlr_event_pointer_axis), offsetof(struct _cffi_align_struct_wlr_event_pointer_axis, y), 69, 6 },
  { "wlr_event_pointer_button", 1090, 0,
    sizeof(struct wlr_event_pointer_button), offsetof(struct _cffi_align_struct_wlr_event_pointer_button, y), 75, 4 },
  { "wlr_event_pointer_motion", 1091, 0,
    sizeof(struct wlr_event_pointer_motion), offsetof(struct _cffi_align_struct_wlr_event_pointer_motion, y), 79, 6 },
  { "wlr_event_pointer_motion_absolute", 1092, 0,
    sizeof(struct wlr_event_pointer_motion_absolute), offsetof(struct _cffi_align_struct_wlr_event_pointer_motion_absolute, y), 85, 4 },
  { "wlr_event_pointer_pinch_begin", 1093, 0,
    sizeof(struct wlr_event_pointer_pinch_begin), offsetof(struct _cffi_align_struct_wlr_event_pointer_pinch_begin, y), 89, 3 },
  { "wlr_event_pointer_pinch_end", 1094, 0,
    sizeof(struct wlr_event_pointer_pinch_end), offsetof(struct _cffi_align_struct_wlr_event_pointer_pinch_end, y), 92, 3 },
  { "wlr_event_pointer_pinch_update", 1095, 0,
    sizeof(struct wlr_event_pointer_pinch_update), offsetof(struct _cffi_align_struct_wlr_event_pointer_pinch_update, y), 95, 7 },
  { "wlr_event_pointer_swipe_begin", 1096, 0,
    sizeof(struct wlr_event_pointer_swipe_begin), offsetof(struct _cffi_align_struct_wlr_event_pointer_swipe_begin, y), 102, 3 },
  { "wlr_event_pointer_swipe_end", 1097, 0,
    sizeof(struct wlr_event_pointer_swipe_end), offsetof(struct _cffi_align_struct_wlr_event_pointer_swipe_end, y), 105, 3 },
  { "wlr_event_pointer_swipe_update", 1098, 0,
    sizeof(struct wlr_event_pointer_swipe_update), offsetof(struct _cffi_align_struct_wlr_event_pointer_swipe_update, y), 108, 5 },
  { "wlr_fbox", 1099, 0,
    sizeof(struct wlr_fbox), offsetof(struct _cffi_align_struct_wlr_fbox, y), 113, 4 },
  { "wlr_foreign_toplevel_handle_v1", 1100, 0,
    sizeof(struct wlr_foreign_toplevel_handle_v1), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1, y), 117, 11 },
  { "wlr_foreign_toplevel_handle_v1_activated_event", 1101, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_foreign_toplevel_handle_v1_activated_event), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_activated_event, y), 128, 2 },
  { "wlr_foreign_toplevel_handle_v1_fullscreen_event", 1102, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_foreign_toplevel_handle_v1_fullscreen_event), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_fullscreen_event, y), 130, 3 },
  { "wlr_foreign_toplevel_handle_v1_maximized_event", 1103, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_foreign_toplevel_handle_v1_maximized_event), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_maximized_event, y), 133, 2 },
  { "wlr_foreign_toplevel_handle_v1_minimized_event", 1104, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_foreign_toplevel_handle_v1_minimized_event), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_minimized_event, y), 135, 2 },
  { "wlr_foreign_toplevel_handle_v1_set_rectangle_event", 1105, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_foreign_toplevel_handle_v1_set_rectangle_event), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_handle_v1_set_rectangle_event, y), 137, 6 },
  { "wlr_foreign_toplevel_manager_v1", 1106, 0,
    sizeof(struct wlr_foreign_toplevel_manager_v1), offsetof(struct _cffi_align_struct_wlr_foreign_toplevel_manager_v1, y), 143, 7 },
  { "wlr_gamma_control_manager_v1", 1108, 0,
    sizeof(struct wlr_gamma_control_manager_v1), offsetof(struct _cffi_align_struct_wlr_gamma_control_manager_v1, y), 150, 5 },
  { "wlr_idle", 1109, 0,
    sizeof(struct wlr_idle), offsetof(struct _cffi_align_struct_wlr_idle, y), 155, 7 },
  { "wlr_idle_inhibit_manager_v1", 1111, 0,
    sizeof(struct wlr_idle_inhibit_manager_v1), offsetof(struct _cffi_align_struct_wlr_idle_inhibit_manager_v1, y), 162, 5 },
  { "wlr_idle_inhibitor_v1", 1112, 0,
    sizeof(struct wlr_idle_inhibitor_v1), offsetof(struct _cffi_align_struct_wlr_idle_inhibitor_v1, y), 167, 6 },
  { "wlr_idle_timeout", 1113, 0,
    sizeof(struct wlr_idle_timeout), offsetof(struct _cffi_align_struct_wlr_idle_timeout, y), 173, 11 },
  { "wlr_input_device", 1114, 0,
    sizeof(struct wlr_input_device), offsetof(struct _cffi_align_struct_wlr_input_device, y), 184, 17 },
  { "wlr_input_device_impl", 1116, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_input_inhibit_manager", 1118, 0,
    sizeof(struct wlr_input_inhibit_manager), offsetof(struct _cffi_align_struct_wlr_input_inhibit_manager, y), 201, 6 },
  { "wlr_keyboard", 1119, 0,
    sizeof(struct wlr_keyboard), offsetof(struct _cffi_align_struct_wlr_keyboard, y), 207, 14 },
  { "wlr_keyboard_grab_interface", 1121, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_keyboard_group", 1123, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_keyboard_impl", 1125, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_keyboard_modifiers", 1126, 0,
    sizeof(struct wlr_keyboard_modifiers), offsetof(struct _cffi_align_struct_wlr_keyboard_modifiers, y), 221, 4 },
  { "wlr_layer_shell_v1", 1128, 0,
    sizeof(struct wlr_layer_shell_v1), offsetof(struct _cffi_align_struct_wlr_layer_shell_v1, y), 225, 4 },
  { "wlr_layer_surface_v1", 1129, 0,
    sizeof(struct wlr_layer_surface_v1), offsetof(struct _cffi_align_struct_wlr_layer_surface_v1, y), 229, 15 },
  { "wlr_layer_surface_v1_state", 1130, 0,
    sizeof(struct wlr_layer_surface_v1_state), offsetof(struct _cffi_align_struct_wlr_layer_surface_v1_state, y), 244, 9 },
  { "wlr_linux_dmabuf_v1", 1132, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output", 1133, 0,
    sizeof(struct wlr_output), offsetof(struct _cffi_align_struct_wlr_output, y), 253, 34 },
  { "wlr_output_configuration_head_v1", 1135, 0,
    sizeof(struct wlr_output_configuration_head_v1), offsetof(struct _cffi_align_struct_wlr_output_configuration_head_v1, y), 287, 5 },
  { "wlr_output_configuration_v1", 1136, 0,
    sizeof(struct wlr_output_configuration_v1), offsetof(struct _cffi_align_struct_wlr_output_configuration_v1, y), 292, 6 },
  { "wlr_output_cursor", 1138, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output_damage", 1139, 0,
    sizeof(struct wlr_output_damage), offsetof(struct _cffi_align_struct_wlr_output_damage, y), 298, 14 },
  { "wlr_output_head_v1_state", 1140, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_output_head_v1_state), offsetof(struct _cffi_align_struct_wlr_output_head_v1_state, y), 312, 8 },
  { "wlr_output_impl", 1142, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output_layout", 1143, 0,
    sizeof(struct wlr_output_layout), offsetof(struct _cffi_align_struct_wlr_output_layout, y), 320, 4 },
  { "wlr_output_layout_state", 1145, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output_manager_v1", 1146, 0,
    sizeof(struct wlr_output_manager_v1), offsetof(struct _cffi_align_struct_wlr_output_manager_v1, y), 324, 9 },
  { "wlr_output_mode", 1147, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_output_power_manager_v1", 1149, 0,
    sizeof(struct wlr_output_power_manager_v1), offsetof(struct _cffi_align_struct_wlr_output_power_manager_v1, y), 333, 5 },
  { "wlr_output_power_v1", 1150, 0,
    sizeof(struct wlr_output_power_v1), offsetof(struct _cffi_align_struct_wlr_output_power_v1, y), 338, 7 },
  { "wlr_output_power_v1_set_mode_event", 1151, 0,
    sizeof(struct wlr_output_power_v1_set_mode_event), offsetof(struct _cffi_align_struct_wlr_output_power_v1_set_mode_event, y), 345, 2 },
  { "wlr_output_state", 1152, 0,
    sizeof(struct wlr_output_state), offsetof(struct _cffi_align_struct_wlr_output_state, y), 347, 0 },
  { "wlr_pointer", 1154, 0,
    sizeof(struct wlr_pointer), offsetof(struct _cffi_align_struct_wlr_pointer, y), 347, 3 },
  { "wlr_pointer_constraint_v1", 1155, 0,
    sizeof(struct wlr_pointer_constraint_v1), offsetof(struct _cffi_align_struct_wlr_pointer_constraint_v1, y), 350, 15 },
  { "wlr_pointer_constraint_v1_state", 1156, 0,
    sizeof(struct wlr_pointer_constraint_v1_state), offsetof(struct _cffi_align_struct_wlr_pointer_constraint_v1_state, y), 365, 3 },
  { "wlr_pointer_constraints_v1", 1157, 0,
    sizeof(struct wlr_pointer_constraints_v1), offsetof(struct _cffi_align_struct_wlr_pointer_constraints_v1, y), 368, 5 },
  { "wlr_pointer_grab_interface", 1159, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_pointer_impl", 1161, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_primary_selection_source", 1162, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_primary_selection_v1_device_manager", 1164, 0,
    sizeof(struct wlr_primary_selection_v1_device_manager), offsetof(struct _cffi_align_struct_wlr_primary_selection_v1_device_manager, y), 373, 5 },
  { "wlr_relative_pointer_manager_v1", 1165, 0,
    sizeof(struct wlr_relative_pointer_manager_v1), offsetof(struct _cffi_align_struct_wlr_relative_pointer_manager_v1, y), 378, 3 },
  { "wlr_relative_pointer_v1", 1166, 0,
    sizeof(struct wlr_relative_pointer_v1), offsetof(struct _cffi_align_struct_wlr_relative_pointer_v1, y), 381, 5 },
  { "wlr_renderer", 1167, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_scene", 1168, 0,
    sizeof(struct wlr_scene), offsetof(struct _cffi_align_struct_wlr_scene, y), 386, 2 },
  { "wlr_scene_node", 1169, 0,
    sizeof(struct wlr_scene_node), offsetof(struct _cffi_align_struct_wlr_scene_node, y), 388, 5 },
  { "wlr_scene_node_state", 1170, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_scene_node_state), offsetof(struct _cffi_align_struct_wlr_scene_node_state, y), 393, 5 },
  { "wlr_scene_output", 1171, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_screencopy_manager_v1", 1173, 0,
    sizeof(struct wlr_screencopy_manager_v1), offsetof(struct _cffi_align_struct_wlr_screencopy_manager_v1, y), 398, 5 },
  { "wlr_seat", 1174, 0,
    sizeof(struct wlr_seat), offsetof(struct _cffi_align_struct_wlr_seat, y), 403, 24 },
  { "wlr_seat_client", 1176, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_seat_keyboard_focus_change_event", 1177, 0,
    sizeof(struct wlr_seat_keyboard_focus_change_event), offsetof(struct _cffi_align_struct_wlr_seat_keyboard_focus_change_event, y), 427, 3 },
  { "wlr_seat_keyboard_grab", 1178, 0,
    sizeof(struct wlr_seat_keyboard_grab), offsetof(struct _cffi_align_struct_wlr_seat_keyboard_grab, y), 430, 3 },
  { "wlr_seat_keyboard_state", 1179, 0,
    sizeof(struct wlr_seat_keyboard_state), offsetof(struct _cffi_align_struct_wlr_seat_keyboard_state, y), 433, 11 },
  { "wlr_seat_pointer_focus_change_event", 1180, 0,
    sizeof(struct wlr_seat_pointer_focus_change_event), offsetof(struct _cffi_align_struct_wlr_seat_pointer_focus_change_event, y), 444, 5 },
  { "wlr_seat_pointer_grab", 1181, 0,
    sizeof(struct wlr_seat_pointer_grab), offsetof(struct _cffi_align_struct_wlr_seat_pointer_grab, y), 449, 3 },
  { "wlr_seat_pointer_request_set_cursor_event", 1182, 0,
    sizeof(struct wlr_seat_pointer_request_set_cursor_event), offsetof(struct _cffi_align_struct_wlr_seat_pointer_request_set_cursor_event, y), 452, 5 },
  { "wlr_seat_pointer_state", 1183, 0,
    sizeof(struct wlr_seat_pointer_state), offsetof(struct _cffi_align_struct_wlr_seat_pointer_state, y), 457, 14 },
  { "wlr_seat_request_set_primary_selection_event", 1184, 0,
    sizeof(struct wlr_seat_request_set_primary_selection_event), offsetof(struct _cffi_align_struct_wlr_seat_request_set_primary_selection_event, y), 471, 2 },
  { "wlr_seat_request_set_selection_event", 1185, 0,
    sizeof(struct wlr_seat_request_set_selection_event), offsetof(struct _cffi_align_struct_wlr_seat_request_set_selection_event, y), 473, 2 },
  { "wlr_seat_request_start_drag_event", 1186, 0,
    sizeof(struct wlr_seat_request_start_drag_event), offsetof(struct _cffi_align_struct_wlr_seat_request_start_drag_event, y), 475, 3 },
  { "wlr_seat_touch_grab", 1187, 0,
    sizeof(struct wlr_seat_touch_grab), offsetof(struct _cffi_align_struct_wlr_seat_touch_grab, y), 478, 3 },
  { "wlr_seat_touch_state", 1188, 0,
    sizeof(struct wlr_seat_touch_state), offsetof(struct _cffi_align_struct_wlr_seat_touch_state, y), 481, 0 },
  { "wlr_server_decoration_manager", 1189, 0,
    sizeof(struct wlr_server_decoration_manager), offsetof(struct _cffi_align_struct_wlr_server_decoration_manager, y), 481, 7 },
  { "wlr_session", 1190, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_subcompositor", 1191, 0,
    sizeof(struct wlr_subcompositor), offsetof(struct _cffi_align_struct_wlr_subcompositor, y), 488, 1 },
  { "wlr_subsurface", 1193, 0,
    sizeof(struct wlr_subsurface), offsetof(struct _cffi_align_struct_wlr_subsurface, y), 489, 14 },
  { "wlr_subsurface_parent_state", 1194, 0,
    sizeof(struct wlr_subsurface_parent_state), offsetof(struct _cffi_align_struct_wlr_subsurface_parent_state, y), 503, 2 },
  { "wlr_surface", 1195, 0,
    sizeof(struct wlr_surface), offsetof(struct _cffi_align_struct_wlr_surface, y), 505, 17 },
  { "wlr_surface_output", 1196, 0,
    sizeof(struct wlr_surface_output), offsetof(struct _cffi_align_struct_wlr_surface_output, y), 522, 5 },
  { "wlr_surface_role", 1197, 0,
    sizeof(struct wlr_surface_role), offsetof(struct _cffi_align_struct_wlr_surface_role, y), 527, 3 },
  { "wlr_surface_state", 1198, 0,
    sizeof(struct wlr_surface_state), offsetof(struct _cffi_align_struct_wlr_surface_state, y), 530, 18 },
  { "wlr_switch", 1200, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_tablet", 1202, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_tablet_pad", 1204, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_texture", 1205, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_touch", 1207, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_touch_grab_interface", 1209, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_virtual_keyboard_manager_v1", 1211, 0,
    sizeof(struct wlr_virtual_keyboard_manager_v1), offsetof(struct _cffi_align_struct_wlr_virtual_keyboard_manager_v1, y), 548, 4 },
  { "wlr_virtual_keyboard_v1", 1212, 0,
    sizeof(struct wlr_virtual_keyboard_v1), offsetof(struct _cffi_align_struct_wlr_virtual_keyboard_v1, y), 552, 6 },
  { "wlr_xcursor", 1214, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_xcursor), offsetof(struct _cffi_align_struct_wlr_xcursor, y), 558, 4 },
  { "wlr_xcursor_image", 1217, _CFFI_F_CHECK_FIELDS,
    sizeof(struct wlr_xcursor_image), offsetof(struct _cffi_align_struct_wlr_xcursor_image, y), 562, 6 },
  { "wlr_xcursor_manager", 1218, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_xdg_client", 1220, 0,
    sizeof(struct wlr_xdg_client), offsetof(struct _cffi_align_struct_wlr_xdg_client, y), 568, 7 },
  { "wlr_xdg_decoration_manager_v1", 1222, 0,
    sizeof(struct wlr_xdg_decoration_manager_v1), offsetof(struct _cffi_align_struct_wlr_xdg_decoration_manager_v1, y), 575, 5 },
  { "wlr_xdg_output_manager_v1", 1224, 0,
    sizeof(struct wlr_xdg_output_manager_v1), offsetof(struct _cffi_align_struct_wlr_xdg_output_manager_v1, y), 580, 8 },
  { "wlr_xdg_popup", 1225, 0,
    sizeof(struct wlr_xdg_popup), offsetof(struct _cffi_align_struct_wlr_xdg_popup, y), 588, 9 },
  { "wlr_xdg_positioner", 1226, 0,
    sizeof(struct wlr_xdg_positioner), offsetof(struct _cffi_align_struct_wlr_xdg_positioner, y), 597, 6 },
  { "wlr_xdg_shell", 1228, 0,
    sizeof(struct wlr_xdg_shell), offsetof(struct _cffi_align_struct_wlr_xdg_shell, y), 603, 7 },
  { "wlr_xdg_surface", 1229, 0,
    sizeof(struct wlr_xdg_surface), offsetof(struct _cffi_align_struct_wlr_xdg_surface, y), 610, 20 },
  { "wlr_xdg_surface_configure", 1231, 0,
    sizeof(struct wlr_xdg_surface_configure), offsetof(struct _cffi_align_struct_wlr_xdg_surface_configure, y), 630, 4 },
  { "wlr_xdg_surface_state", 1232, 0,
    sizeof(struct wlr_xdg_surface_state), offsetof(struct _cffi_align_struct_wlr_xdg_surface_state, y), 634, 2 },
  { "wlr_xdg_toplevel", 1234, 0,
    sizeof(struct wlr_xdg_toplevel), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel, y), 636, 12 },
  { "wlr_xdg_toplevel_configure", 1236, 0,
    sizeof(struct wlr_xdg_toplevel_configure), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_configure, y), 648, 7 },
  { "wlr_xdg_toplevel_decoration_v1", 1237, 0,
    sizeof(struct wlr_xdg_toplevel_decoration_v1), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1, y), 655, 16 },
  { "wlr_xdg_toplevel_decoration_v1_configure", 1238, 0,
    sizeof(struct wlr_xdg_toplevel_decoration_v1_configure), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_configure, y), 671, 3 },
  { "wlr_xdg_toplevel_decoration_v1_state", 1239, 0,
    sizeof(struct wlr_xdg_toplevel_decoration_v1_state), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_decoration_v1_state, y), 674, 1 },
  { "wlr_xdg_toplevel_move_event", 1240, 0,
    sizeof(struct wlr_xdg_toplevel_move_event), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_move_event, y), 675, 3 },
  { "wlr_xdg_toplevel_requested", 1241, 0,
    sizeof(struct wlr_xdg_toplevel_requested), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_requested, y), 678, 5 },
  { "wlr_xdg_toplevel_resize_event", 1242, 0,
    sizeof(struct wlr_xdg_toplevel_resize_event), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_resize_event, y), 683, 4 },
  { "wlr_xdg_toplevel_set_fullscreen_event", 1243, 0,
    sizeof(struct wlr_xdg_toplevel_set_fullscreen_event), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_set_fullscreen_event, y), 687, 3 },
  { "wlr_xdg_toplevel_show_window_menu_event", 1244, 0,
    sizeof(struct wlr_xdg_toplevel_show_window_menu_event), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_show_window_menu_event, y), 690, 5 },
  { "wlr_xdg_toplevel_state", 1245, 0,
    sizeof(struct wlr_xdg_toplevel_state), offsetof(struct _cffi_align_struct_wlr_xdg_toplevel_state, y), 695, 11 },
  { "wlr_xwayland", 1246, 0,
    sizeof(struct wlr_xwayland), offsetof(struct _cffi_align_struct_wlr_xwayland, y), 706, 13 },
  { "wlr_xwayland_cursor", 1248, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "wlr_xwayland_minimize_event", 1249, 0,
    sizeof(struct wlr_xwayland_minimize_event), offsetof(struct _cffi_align_struct_wlr_xwayland_minimize_event, y), 719, 2 },
  { "wlr_xwayland_move_event", 1250, 0,
    sizeof(struct wlr_xwayland_move_event), offsetof(struct _cffi_align_struct_wlr_xwayland_move_event, y), 721, 1 },
  { "wlr_xwayland_remove_startup_info_event", 1251, 0,
    sizeof(struct wlr_xwayland_remove_startup_info_event), offsetof(struct _cffi_align_struct_wlr_xwayland_remove_startup_info_event, y), 722, 2 },
  { "wlr_xwayland_resize_event", 1252, 0,
    sizeof(struct wlr_xwayland_resize_event), offsetof(struct _cffi_align_struct_wlr_xwayland_resize_event, y), 724, 2 },
  { "wlr_xwayland_server", 1253, 0,
    sizeof(struct wlr_xwayland_server), offsetof(struct _cffi_align_struct_wlr_xwayland_server, y), 726, 16 },
  { "wlr_xwayland_server_options", 1254, 0,
    sizeof(struct wlr_xwayland_server_options), offsetof(struct _cffi_align_struct_wlr_xwayland_server_options, y), 742, 3 },
  { "wlr_xwayland_surface", 1255, 0,
    sizeof(struct wlr_xwayland_surface), offsetof(struct _cffi_align_struct_wlr_xwayland_surface, y), 745, 44 },
  { "wlr_xwayland_surface_configure_event", 1256, 0,
    sizeof(struct wlr_xwayland_surface_configure_event), offsetof(struct _cffi_align_struct_wlr_xwayland_surface_configure_event, y), 789, 6 },
  { "wlr_xwayland_surface_hints", 1258, 0,
    sizeof(struct wlr_xwayland_surface_hints), offsetof(struct _cffi_align_struct_wlr_xwayland_surface_hints, y), 795, 9 },
  { "wlr_xwayland_surface_size_hints", 1260, 0,
    sizeof(struct wlr_xwayland_surface_size_hints), offsetof(struct _cffi_align_struct_wlr_xwayland_surface_size_hints, y), 804, 18 },
  { "wlr_xwm", 1261, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "xcb_intern_atom_cookie_t", 925, 0,
    sizeof(xcb_intern_atom_cookie_t), offsetof(struct _cffi_align__xcb_intern_atom_cookie_t, y), 822, 0 },
  { "xcb_intern_atom_reply_t", 1293, 0,
    sizeof(xcb_intern_atom_reply_t), offsetof(struct _cffi_align__xcb_intern_atom_reply_t, y), 822, 5 },
  { "xkb_compose_state", 1262, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_compose_table", 1263, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_context", 1264, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_keymap", 1265, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_rule_names", 1266, _CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
  { "xkb_state", 1268, _CFFI_F_OPAQUE|_CFFI_F_EXTERNAL,
    (size_t)-1, -1, -1, 0 /* external */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "wl_data_device_manager_dnd_action", 935, _cffi_prim_int(sizeof(enum wl_data_device_manager_dnd_action), ((enum wl_data_device_manager_dnd_action)-1) <= 0),
    "" },
  { "wl_keyboard_key_state", 936, _cffi_prim_int(sizeof(enum wl_keyboard_key_state), ((enum wl_keyboard_key_state)-1) <= 0),
    "" },
  { "wl_output_subpixel", 937, _cffi_prim_int(sizeof(enum wl_output_subpixel), ((enum wl_output_subpixel)-1) <= 0),
    "" },
  { "wl_output_transform", 116, _cffi_prim_int(sizeof(enum wl_output_transform), ((enum wl_output_transform)-1) <= 0),
    "" },
  { "wlr_axis_orientation", 772, _cffi_prim_int(sizeof(enum wlr_axis_orientation), ((enum wlr_axis_orientation)-1) <= 0),
    "WLR_AXIS_ORIENTATION_VERTICAL,WLR_AXIS_ORIENTATION_HORIZONTAL" },
  { "wlr_axis_source", 775, _cffi_prim_int(sizeof(enum wlr_axis_source), ((enum wlr_axis_source)-1) <= 0),
    "WLR_AXIS_SOURCE_WHEEL,WLR_AXIS_SOURCE_FINGER,WLR_AXIS_SOURCE_CONTINUOUS,WLR_AXIS_SOURCE_WHEEL_TILT" },
  { "wlr_button_state", 392, _cffi_prim_int(sizeof(enum wlr_button_state), ((enum wlr_button_state)-1) <= 0),
    "WLR_BUTTON_RELEASED,WLR_BUTTON_PRESSED" },
  { "wlr_drag_grab_type", 938, _cffi_prim_int(sizeof(enum wlr_drag_grab_type), ((enum wlr_drag_grab_type)-1) <= 0),
    "" },
  { "wlr_edges", 939, _cffi_prim_int(sizeof(enum wlr_edges), ((enum wlr_edges)-1) <= 0),
    "WLR_EDGE_NONE,WLR_EDGE_TOP,WLR_EDGE_BOTTOM,WLR_EDGE_LEFT,WLR_EDGE_RIGHT" },
  { "wlr_input_device_type", 207, _cffi_prim_int(sizeof(enum wlr_input_device_type), ((enum wlr_input_device_type)-1) <= 0),
    "WLR_INPUT_DEVICE_KEYBOARD,WLR_INPUT_DEVICE_POINTER,WLR_INPUT_DEVICE_TOUCH,WLR_INPUT_DEVICE_TABLET_TOOL,WLR_INPUT_DEVICE_TABLET_PAD,WLR_INPUT_DEVICE_SWITCH" },
  { "wlr_keyboard_led", 940, _cffi_prim_int(sizeof(enum wlr_keyboard_led), ((enum wlr_keyboard_led)-1) <= 0),
    "WLR_LED_NUM_LOCK,WLR_LED_CAPS_LOCK,WLR_LED_SCROLL_LOCK" },
  { "wlr_keyboard_modifier", 941, _cffi_prim_int(sizeof(enum wlr_keyboard_modifier), ((enum wlr_keyboard_modifier)-1) <= 0),
    "WLR_MODIFIER_SHIFT,WLR_MODIFIER_CAPS,WLR_MODIFIER_CTRL,WLR_MODIFIER_ALT,WLR_MODIFIER_MOD2,WLR_MODIFIER_MOD3,WLR_MODIFIER_LOGO,WLR_MODIFIER_MOD5" },
  { "wlr_log_importance", 415, _cffi_prim_int(sizeof(enum wlr_log_importance), ((enum wlr_log_importance)-1) <= 0),
    "WLR_SILENT,WLR_ERROR,WLR_INFO,WLR_DEBUG" },
  { "wlr_pointer_constraint_v1_state_field", 942, _cffi_prim_int(sizeof(enum wlr_pointer_constraint_v1_state_field), ((enum wlr_pointer_constraint_v1_state_field)-1) <= 0),
    "WLR_POINTER_CONSTRAINT_V1_STATE_REGION,WLR_POINTER_CONSTRAINT_V1_STATE_CURSOR_HINT" },
  { "wlr_pointer_constraint_v1_type", 943, _cffi_prim_int(sizeof(enum wlr_pointer_constraint_v1_type), ((enum wlr_pointer_constraint_v1_type)-1) <= 0),
    "WLR_POINTER_CONSTRAINT_V1_LOCKED,WLR_POINTER_CONSTRAINT_V1_CONFINED" },
  { "wlr_scene_node_type", 944, _cffi_prim_int(sizeof(enum wlr_scene_node_type), ((enum wlr_scene_node_type)-1) <= 0),
    "" },
  { "wlr_server_decoration_manager_mode", 945, _cffi_prim_int(sizeof(enum wlr_server_decoration_manager_mode), ((enum wlr_server_decoration_manager_mode)-1) <= 0),
    "WLR_SERVER_DECORATION_MANAGER_MODE_NONE,WLR_SERVER_DECORATION_MANAGER_MODE_CLIENT,WLR_SERVER_DECORATION_MANAGER_MODE_SERVER" },
  { "wlr_xdg_surface_role", 946, _cffi_prim_int(sizeof(enum wlr_xdg_surface_role), ((enum wlr_xdg_surface_role)-1) <= 0),
    "WLR_XDG_SURFACE_ROLE_NONE,WLR_XDG_SURFACE_ROLE_TOPLEVEL,WLR_XDG_SURFACE_ROLE_POPUP" },
  { "wlr_xdg_toplevel_decoration_v1_mode", 412, _cffi_prim_int(sizeof(enum wlr_xdg_toplevel_decoration_v1_mode), ((enum wlr_xdg_toplevel_decoration_v1_mode)-1) <= 0),
    "WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_NONE,WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_CLIENT_SIDE,WLR_XDG_TOPLEVEL_DECORATION_V1_MODE_SERVER_SIDE" },
  { "wlr_xwayland_icccm_input_model", 947, _cffi_prim_int(sizeof(enum wlr_xwayland_icccm_input_model), ((enum wlr_xwayland_icccm_input_model)-1) <= 0),
    "WLR_ICCCM_INPUT_MODEL_NONE,WLR_ICCCM_INPUT_MODEL_PASSIVE,WLR_ICCCM_INPUT_MODEL_LOCAL,WLR_ICCCM_INPUT_MODEL_GLOBAL" },
  { "wlr_xwayland_surface_decorations", 948, _cffi_prim_int(sizeof(enum wlr_xwayland_surface_decorations), ((enum wlr_xwayland_surface_decorations)-1) <= 0),
    "WLR_XWAYLAND_SURFACE_DECORATIONS_ALL,WLR_XWAYLAND_SURFACE_DECORATIONS_NO_BORDER,WLR_XWAYLAND_SURFACE_DECORATIONS_NO_TITLE" },
  { "xcb_stack_mode_t", 900, _cffi_prim_int(sizeof(enum xcb_stack_mode_t), ((enum xcb_stack_mode_t)-1) <= 0),
    "" },
  { "xdg_positioner_anchor", 949, _cffi_prim_int(sizeof(enum xdg_positioner_anchor), ((enum xdg_positioner_anchor)-1) <= 0),
    "" },
  { "xdg_positioner_constraint_adjustment", 950, _cffi_prim_int(sizeof(enum xdg_positioner_constraint_adjustment), ((enum xdg_positioner_constraint_adjustment)-1) <= 0),
    "" },
  { "xdg_positioner_gravity", 951, _cffi_prim_int(sizeof(enum xdg_positioner_gravity), ((enum xdg_positioner_gravity)-1) <= 0),
    "" },
  { "xkb_compose_compile_flags", 952, _cffi_prim_int(sizeof(enum xkb_compose_compile_flags), ((enum xkb_compose_compile_flags)-1) <= 0),
    "XKB_COMPOSE_COMPILE_NO_FLAGS" },
  { "xkb_compose_feed_result", 953, _cffi_prim_int(sizeof(enum xkb_compose_feed_result), ((enum xkb_compose_feed_result)-1) <= 0),
    "XKB_COMPOSE_FEED_IGNORED,XKB_COMPOSE_FEED_ACCEPTED" },
  { "xkb_compose_format", 954, _cffi_prim_int(sizeof(enum xkb_compose_format), ((enum xkb_compose_format)-1) <= 0),
    "XKB_COMPOSE_FORMAT_TEXT_V1" },
  { "xkb_compose_state_flags", 955, _cffi_prim_int(sizeof(enum xkb_compose_state_flags), ((enum xkb_compose_state_flags)-1) <= 0),
    "XKB_COMPOSE_STATE_NO_FLAGS" },
  { "xkb_compose_status", 956, _cffi_prim_int(sizeof(enum xkb_compose_status), ((enum xkb_compose_status)-1) <= 0),
    "XKB_COMPOSE_NOTHING,XKB_COMPOSE_COMPOSING,XKB_COMPOSE_COMPOSED,XKB_COMPOSE_CANCELLED" },
  { "xkb_context_flags", 957, _cffi_prim_int(sizeof(enum xkb_context_flags), ((enum xkb_context_flags)-1) <= 0),
    "XKB_CONTEXT_NO_FLAGS,XKB_CONTEXT_NO_DEFAULT_INCLUDES,XKB_CONTEXT_NO_ENVIRONMENT_NAMES" },
  { "xkb_key_direction", 958, _cffi_prim_int(sizeof(enum xkb_key_direction), ((enum xkb_key_direction)-1) <= 0),
    "XKB_KEY_UP,XKB_KEY_DOWN" },
  { "xkb_keymap_compile_flags", 959, _cffi_prim_int(sizeof(enum xkb_keymap_compile_flags), ((enum xkb_keymap_compile_flags)-1) <= 0),
    "XKB_KEYMAP_COMPILE_NO_FLAGS" },
  { "xkb_keymap_format", 960, _cffi_prim_int(sizeof(enum xkb_keymap_format), ((enum xkb_keymap_format)-1) <= 0),
    "XKB_KEYMAP_FORMAT_TEXT_V1" },
  { "xkb_keysym_flags", 961, _cffi_prim_int(sizeof(enum xkb_keysym_flags), ((enum xkb_keysym_flags)-1) <= 0),
    "XKB_KEYSYM_NO_FLAGS,XKB_KEYSYM_CASE_INSENSITIVE" },
  { "xkb_log_level", 962, _cffi_prim_int(sizeof(enum xkb_log_level), ((enum xkb_log_level)-1) <= 0),
    "XKB_LOG_LEVEL_CRITICAL,XKB_LOG_LEVEL_ERROR,XKB_LOG_LEVEL_WARNING,XKB_LOG_LEVEL_INFO,XKB_LOG_LEVEL_DEBUG" },
  { "xkb_state_component", 963, _cffi_prim_int(sizeof(enum xkb_state_component), ((enum xkb_state_component)-1) <= 0),
    "XKB_STATE_MODS_DEPRESSED,XKB_STATE_MODS_LATCHED,XKB_STATE_MODS_LOCKED,XKB_STATE_MODS_EFFECTIVE,XKB_STATE_LAYOUT_DEPRESSED,XKB_STATE_LAYOUT_LATCHED,XKB_STATE_LAYOUT_LOCKED,XKB_STATE_LAYOUT_EFFECTIVE,XKB_STATE_LEDS" },
  { "xkb_state_match", 964, _cffi_prim_int(sizeof(enum xkb_state_match), ((enum xkb_state_match)-1) <= 0),
    "XKB_STATE_MATCH_ANY,XKB_STATE_MATCH_ALL,XKB_STATE_MATCH_NON_EXCLUSIVE" },
  { "zwlr_layer_shell_v1_layer", 965, _cffi_prim_int(sizeof(enum zwlr_layer_shell_v1_layer), ((enum zwlr_layer_shell_v1_layer)-1) <= 0),
    "" },
  { "zwlr_layer_surface_v1_keyboard_interactivity", 966, _cffi_prim_int(sizeof(enum zwlr_layer_surface_v1_keyboard_interactivity), ((enum zwlr_layer_surface_v1_keyboard_interactivity)-1) <= 0),
    "" },
  { "zwlr_output_power_v1_mode", 967, _cffi_prim_int(sizeof(enum zwlr_output_power_v1_mode), ((enum zwlr_output_power_v1_mode)-1) <= 0),
    "" },
  { "zwp_pointer_constraints_v1_lifetime", 968, _cffi_prim_int(sizeof(enum zwp_pointer_constraints_v1_lifetime), ((enum zwp_pointer_constraints_v1_lifetime)-1) <= 0),
    "" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "FILE", 928 },
  { "clockid_t", 131 },
  { "gid_t", 84 },
  { "pid_t", 59 },
  { "time_t", 1269 },
  { "uid_t", 84 },
  { "va_list", 1280 },
  { "wl_dispatcher_func_t", 975 },
  { "wl_event_loop_fd_func_t", 971 },
  { "wl_event_loop_idle_func_t", 1286 },
  { "wl_event_loop_signal_func_t", 972 },
  { "wl_event_loop_timer_func_t", 974 },
  { "wl_fixed_t", 131 },
  { "wl_global_bind_func_t", 1281 },
  { "wl_notify_func_t", 1282 },
  { "wl_resource_destroy_func_t", 1283 },
  { "wlr_surface_iterator_func_t", 576 },
  { "wrapped_log_func_t", 420 },
  { "xcb_atom_t", 80 },
  { "xcb_connection_t", 1288 },
  { "xcb_generic_error_t", 1290 },
  { "xcb_generic_event_t", 1291 },
  { "xcb_intern_atom_cookie_t", 925 },
  { "xcb_intern_atom_reply_t", 1293 },
  { "xcb_pixmap_t", 80 },
  { "xcb_window_t", 80 },
  { "xkb_keycode_t", 80 },
  { "xkb_keymap_key_iter_t", 1285 },
  { "xkb_keysym_t", 80 },
  { "xkb_layout_index_t", 80 },
  { "xkb_layout_mask_t", 80 },
  { "xkb_led_index_t", 80 },
  { "xkb_led_mask_t", 80 },
  { "xkb_level_index_t", 80 },
  { "xkb_mod_index_t", 80 },
  { "xkb_mod_mask_t", 80 },
};

static const char * const _cffi_includes[] = {
  "pywayland._ffi",
  "xkbcommon._ffi",
  NULL
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  354,  /* num_globals */
  240,  /* num_struct_unions */
  42,  /* num_enums */
  36,  /* num_typenames */
  _cffi_includes,
  1294,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__ffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__ffi(void) { return NULL; }
#  else
     init_ffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__ffi(void)
{
  return _cffi_init("wlroots._ffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_ffi(void)
{
  _cffi_init("wlroots._ffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
