/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogresults;

import java.util.EnumSet;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;

public abstract class BasicDialogValue {
    public static final EnumSet<Primitive> Yes = EnumSet.of(Primitive.YES);
    public static final EnumSet<Primitive> YesNo = EnumSet.of(Primitive.YES, Primitive.NO);
    public static final EnumSet<Primitive> YesCancel = EnumSet.of(Primitive.YES, Primitive.CANCEL);
    public static final EnumSet<Primitive> YesCancelSkip = EnumSet.of(Primitive.YES, Primitive.CANCEL, Primitive.SKIP);
    public static final EnumSet<Primitive> YesNoCancel = EnumSet.of(Primitive.YES, Primitive.NO, Primitive.CANCEL);
    public static final EnumSet<Primitive> YesNoSandbox = EnumSet.of(Primitive.YES, Primitive.NO, Primitive.SANDBOX);

    public static String writeNUll() {
        return "";
    }

    static abstract class PrimitivesSubset
    implements DialogResult {
        protected final Primitive value;

        abstract EnumSet<Primitive> getAllowedValues();

        protected PrimitivesSubset(Primitive value) {
            this.value = value;
            this.checkValue(value);
        }

        final void checkValue(Primitive p) {
            if (!this.getAllowedValues().contains((Object)p)) {
                throw new RuntimeException("Unsupported primitive " + (Object)((Object)p) + ". Allowed are " + this.getAllowedValues().toString());
            }
        }

        @Override
        public String writeValue() {
            if (this.value == null) {
                return BasicDialogValue.writeNUll();
            }
            return this.value.name();
        }

        @Override
        public boolean toBoolean() {
            return this.value != null && this.value != Primitive.NO && this.value != Primitive.CANCEL;
        }

        public Primitive getValue() {
            return this.value;
        }

        public boolean compareValue(Primitive with) {
            if (this.getValue() == null && with == null) {
                return true;
            }
            this.checkValue(with);
            return this.getValue() == with;
        }

        public boolean compareValue(PrimitivesSubset with) {
            if (with == null) {
                return false;
            }
            return this.compareValue(with.getValue());
        }

        @Override
        public int getButtonIndex() {
            return Primitive.NO.getLegacyButton();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PrimitivesSubset) {
                return this.compareValue((PrimitivesSubset)obj);
            }
            return false;
        }

        public int hashCode() {
            return this.getValue().hashCode();
        }
    }

    public static enum Primitive {
        YES(0),
        NO(1),
        CANCEL(2),
        SANDBOX(2),
        SKIP(0);

        private final int legacyButton;

        private Primitive(int legacyButton) {
            this.legacyButton = legacyButton;
        }

        public int getLegacyButton() {
            return this.legacyButton;
        }
    }
}

