/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import sun.security.ssl.Krb5Proxy;

public final class Krb5Helper {
    private static final String IMPL_CLASS = "sun.security.ssl.krb5.Krb5ProxyImpl";
    private static final Krb5Proxy proxy = AccessController.doPrivileged(new PrivilegedAction<Krb5Proxy>(){

        @Override
        public Krb5Proxy run() {
            try {
                Class<?> c = Class.forName(Krb5Helper.IMPL_CLASS, true, null);
                return (Krb5Proxy)c.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    });

    private Krb5Helper() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Kerberos should have been available");
        }
    }

    public static Subject getClientSubject(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getClientSubject(acc);
    }

    public static Subject getServerSubject(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getServerSubject(acc);
    }

    public static SecretKey[] getServerKeys(AccessControlContext acc) throws LoginException {
        Krb5Helper.ensureAvailable();
        return proxy.getServerKeys(acc);
    }

    public static String getServerPrincipalName(SecretKey kerberosKey) {
        Krb5Helper.ensureAvailable();
        return proxy.getServerPrincipalName(kerberosKey);
    }

    public static String getPrincipalHostName(Principal principal) {
        Krb5Helper.ensureAvailable();
        return proxy.getPrincipalHostName(principal);
    }

    public static Permission getServicePermission(String principalName, String action) {
        Krb5Helper.ensureAvailable();
        return proxy.getServicePermission(principalName, action);
    }
}

