# - Config file for the KDEGames package
# It defines the following variables (deprecated, used targets instead)
#  KDEGAMES_INCLUDE_DIRS
#  KDEGAMES_INCLUDE_DIR
#  KDEGAMES_LIBRARY


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KDEGamesConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KF5KDEGames" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

find_dependency(Qt5Widgets 5.15.0)
find_dependency(Qt5Xml 5.15.0)
find_dependency(Qt5Network 5.15.0)
find_dependency(Qt5QuickWidgets 5.15.0)
find_dependency(Qt5Qml 5.15.0)
find_dependency(KF5Config 5.89.0)
find_dependency(KF5I18n 5.89.0)
find_dependency(KF5WidgetsAddons 5.89.0)
find_dependency(KF5ConfigWidgets 5.89.0)
find_dependency(KF5Completion 5.89.0)

include("${CMAKE_CURRENT_LIST_DIR}/KF5KDEGamesTargets.cmake")

# set backward-compat variables
get_target_property(KDEGAMES_INCLUDE_DIR KF5KDEGames INTERFACE_INCLUDE_DIRECTORIES)
set(KDEGAMES_INCLUDE_DIRS ${KDEGAMES_INCLUDE_DIR})
set(KDEGAMES_LIBRARY KF5KDEGames)
