/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.FreeColButton;

public final class UnitButton
extends FreeColButton {
    private static final Logger logger = Logger.getLogger(UnitButton.class.getName());
    private final String actionId;
    private final ActionManager am;

    public UnitButton(ActionManager am, String actionId) {
        super(FreeColButton.ButtonStyle.TRANSPARENT, am.getFreeColAction(actionId));
        this.actionId = actionId;
        this.am = am;
    }

    public void refreshAction() {
        this.setAction(null);
        this.setAction(this.am.getFreeColAction(this.actionId));
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        if (a != null) {
            this.setRolloverEnabled(true);
            ImageIcon bi = (ImageIcon)a.getValue("BUTTON_IMAGE");
            this.setIcon(bi);
            this.setRolloverIcon((ImageIcon)a.getValue("BUTTON_ROLLOVER_IMAGE"));
            this.setPressedIcon((ImageIcon)a.getValue("BUTTON_PRESSED_IMAGE"));
            this.setDisabledIcon((ImageIcon)a.getValue("BUTTON_DISABLED_IMAGE"));
            this.setToolTipText((String)a.getValue("Name"));
            this.setText(null);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            if (bi != null) {
                this.setSize(bi.getIconWidth(), bi.getIconHeight());
            } else {
                logger.warning("Action " + a + " has no BUTTON_IMAGE");
            }
        }
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new UnitButtonActionPropertyChangeListener(this);
    }

    private static class UnitButtonActionPropertyChangeListener
    implements PropertyChangeListener {
        private final AbstractButton button;

        UnitButtonActionPropertyChangeListener(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("Name".equals(e.getPropertyName()) || "ShortDescription".equals(e.getPropertyName())) {
                String text = (String)e.getNewValue();
                this.button.setToolTipText(text);
            } else if ("enabled".equals(propertyName)) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if ("SmallIcon".equals(e.getPropertyName())) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.repaint();
            } else if ("BUTTON_IMAGE".equals(e.getPropertyName())) {
                ImageIcon bi = (ImageIcon)e.getNewValue();
                this.button.setIcon(bi);
                if (bi != null) {
                    this.button.setSize(bi.getIconWidth(), bi.getIconHeight());
                }
                this.button.repaint();
            } else if ("BUTTON_ROLLOVER_IMAGE".equals(e.getPropertyName())) {
                this.button.setRolloverIcon((ImageIcon)e.getNewValue());
                this.button.repaint();
            } else if ("BUTTON_PRESSED_IMAGE".equals(e.getPropertyName())) {
                this.button.setPressedIcon((ImageIcon)e.getNewValue());
                this.button.repaint();
            } else if ("BUTTON_DISABLED_IMAGE".equals(e.getPropertyName())) {
                this.button.setDisabledIcon((ImageIcon)e.getNewValue());
                this.button.repaint();
            } else if ("MnemonicKey".equals(e.getPropertyName())) {
                Integer mn = (Integer)e.getNewValue();
                this.button.setMnemonic(mn);
                this.button.repaint();
            } else if ("ActionCommandKey".equals(e.getPropertyName())) {
                this.button.setActionCommand((String)e.getNewValue());
            }
        }
    }
}

