/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.resources.ResourceMapping;

public class FreeColTcFile
extends FreeColModFile {
    private static final Logger logger = Logger.getLogger(FreeColTcFile.class.getName());
    private static final Map<String, FreeColTcFile> allTCs = new HashMap<String, FreeColTcFile>();

    public FreeColTcFile(File file) throws IOException {
        super(file);
    }

    @Override
    public ResourceMapping getResourceMapping() {
        ResourceMapping result = new ResourceMapping();
        if (this.getParent() != null) {
            FreeColTcFile parentTcData = FreeColTcFile.getFreeColTcFile(this.getParent());
            result.addAll(parentTcData.getResourceMapping());
        }
        result.addAll(super.getResourceMapping());
        return result;
    }

    public static List<FreeColTcFile> getRulesList() {
        ArrayList<FreeColTcFile> ret = new ArrayList<FreeColTcFile>();
        for (File f : FreeColDirectories.getTcFileList()) {
            try {
                ret.add(new FreeColTcFile(f));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to load TC from: " + f, ioe);
            }
        }
        return ret;
    }

    public static void loadTCs() {
        if (allTCs.isEmpty()) {
            for (FreeColTcFile fctf : FreeColTcFile.getRulesList()) {
                allTCs.put(fctf.getId(), fctf);
            }
        }
    }

    public static FreeColTcFile getFreeColTcFile(String id) {
        return allTCs.get(id);
    }
}

