/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.TimeIndex;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.statistics.StatisticsModelImpl;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.api.StatisticsModel;
import org.gephi.statistics.spi.DynamicStatistics;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class StatisticsControllerImpl
implements StatisticsController {
    private final StatisticsBuilder[] statisticsBuilders = Lookup.getDefault().lookupAll(StatisticsBuilder.class).toArray(new StatisticsBuilder[0]);
    private StatisticsModelImpl model;

    public StatisticsControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                if (workspace.getLookup().lookup(StatisticsModelImpl.class) == null) {
                    workspace.add((Object)new StatisticsModelImpl());
                }
            }

            public void select(Workspace workspace) {
                StatisticsControllerImpl.this.model = (StatisticsModelImpl)workspace.getLookup().lookup(StatisticsModelImpl.class);
                if (StatisticsControllerImpl.this.model == null) {
                    StatisticsControllerImpl.this.model = new StatisticsModelImpl();
                    workspace.add((Object)StatisticsControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                StatisticsControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (StatisticsModelImpl)pc.getCurrentWorkspace().getLookup().lookup(StatisticsModelImpl.class);
            if (this.model == null) {
                this.model = new StatisticsModelImpl();
                pc.getCurrentWorkspace().add((Object)this.model);
            }
        }
    }

    @Override
    public void execute(final Statistics statistics, LongTaskListener listener) {
        StatisticsBuilder builder = this.getBuilder(statistics.getClass());
        LongTaskExecutor executor = new LongTaskExecutor(true, "Statistics " + builder.getName(), 10);
        if (listener != null) {
            executor.setLongTaskListener(listener);
        }
        if (statistics instanceof DynamicStatistics) {
            final DynamicLongTask dynamicLongTask = new DynamicLongTask((DynamicStatistics)statistics);
            executor.execute((LongTask)dynamicLongTask, new Runnable(){

                @Override
                public void run() {
                    StatisticsControllerImpl.this.executeDynamic((DynamicStatistics)statistics, dynamicLongTask);
                }
            }, builder.getName(), null);
        } else {
            LongTask task = statistics instanceof LongTask ? (LongTask)statistics : null;
            executor.execute(task, new Runnable(){

                @Override
                public void run() {
                    StatisticsControllerImpl.this.execute(statistics);
                }
            }, builder.getName(), null);
        }
    }

    @Override
    public void execute(Statistics statistics) {
        if (statistics instanceof DynamicStatistics) {
            this.executeDynamic((DynamicStatistics)statistics, null);
        } else {
            GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
            GraphModel graphModel = graphController.getGraphModel();
            statistics.execute(graphModel);
            this.model.addReport(statistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDynamic(DynamicStatistics statistics, DynamicLongTask dynamicLongTask) {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel();
        double window = statistics.getWindow();
        double tick = statistics.getTick();
        GraphView currentView = graphModel.getVisibleView();
        Interval bounds = statistics.getBounds();
        if (bounds == null) {
            bounds = currentView.isMainView() ? graphModel.getTimeBounds() : currentView.getTimeInterval();
            statistics.setBounds(bounds);
        }
        if (dynamicLongTask != null) {
            int c = (int)((bounds.getHigh() - window - bounds.getLow()) / tick);
            dynamicLongTask.start(c);
        }
        statistics.execute(graphModel);
        for (double low = bounds.getLow(); low <= bounds.getHigh() - window; low += tick) {
            double high = low + window;
            Graph graph = graphModel.getGraphVisible();
            graph.writeLock();
            try {
                TimeIndex edgeIndex;
                GraphView view = graphModel.createView();
                Subgraph g = graphModel.getGraph(view);
                TimeIndex nodeIndex = graphModel.getNodeTimeIndex(currentView);
                if (Double.isInfinite(nodeIndex.getMinTimestamp()) && Double.isInfinite(nodeIndex.getMaxTimestamp())) {
                    for (Node node : graph.getNodes()) {
                        g.addNode(node);
                    }
                } else {
                    for (Node node : nodeIndex.get(new Interval(low, high))) {
                        g.addNode(node);
                    }
                }
                if (Double.isInfinite((edgeIndex = graphModel.getEdgeTimeIndex(currentView)).getMinTimestamp()) && Double.isInfinite(edgeIndex.getMaxTimestamp())) {
                    for (Edge edge : graph.getEdges()) {
                        if (!g.contains(edge.getSource()) || !g.contains(edge.getTarget())) continue;
                        g.addEdge(edge);
                    }
                } else {
                    for (Edge edge : edgeIndex.get(new Interval(low, high))) {
                        if (!g.contains(edge.getSource()) || !g.contains(edge.getTarget())) continue;
                        g.addEdge(edge);
                    }
                }
                statistics.loop(g.getView(), new Interval(low, high));
            }
            finally {
                graph.writeUnlock();
                graph.readUnlockAll();
            }
            if (dynamicLongTask != null && dynamicLongTask.isCancelled()) {
                return;
            }
            if (dynamicLongTask == null) continue;
            dynamicLongTask.progress();
        }
        statistics.end();
        this.model.addReport(statistics);
    }

    @Override
    public StatisticsBuilder getBuilder(Class<? extends Statistics> statisticsClass) {
        for (StatisticsBuilder b : this.statisticsBuilders) {
            if (!b.getStatisticsClass().equals(statisticsClass)) continue;
            return b;
        }
        return null;
    }

    @Override
    public StatisticsModelImpl getModel() {
        return this.model;
    }

    @Override
    public StatisticsModel getModel(Workspace workspace) {
        StatisticsModel statModel = (StatisticsModel)workspace.getLookup().lookup(StatisticsModelImpl.class);
        if (statModel == null) {
            statModel = new StatisticsModelImpl();
            workspace.add((Object)statModel);
        }
        return statModel;
    }

    private static class DynamicLongTask
    implements LongTask {
        private final LongTask longTask;
        private ProgressTicket progressTicket;
        private boolean cancel = false;

        public DynamicLongTask(DynamicStatistics statistics) {
            this.longTask = statistics instanceof LongTask ? (LongTask)statistics : null;
        }

        public boolean cancel() {
            this.cancel = true;
            if (this.longTask != null) {
                this.longTask.cancel();
            }
            return true;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
        }

        public void start(int iterations) {
            Progress.start((ProgressTicket)this.progressTicket, (int)iterations);
        }

        public void progress() {
            Progress.progress((ProgressTicket)this.progressTicket);
        }

        public boolean isCancelled() {
            return this.cancel;
        }
    }
}

