/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.filters.FilterUIModel;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FilterPanelPanel
extends JPanel
implements ChangeListener {
    private final String settingsString = NbBundle.getMessage(FilterPanelPanel.class, (String)"FilterPanelPanel.settings");
    private Query selectedQuery;
    private FilterUIModel uiModel;

    public FilterPanelPanel() {
        super(new BorderLayout());
        if (UIUtils.isAquaLookAndFeel()) {
            this.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshModel();
    }

    private void refreshModel() {
        if (this.uiModel != null) {
            if (this.uiModel.getSelectedQuery() != this.selectedQuery) {
                this.selectedQuery = this.uiModel.getSelectedQuery();
                this.setQuery(this.selectedQuery);
            }
        } else {
            this.setQuery(null);
        }
    }

    public void setup(FilterUIModel model) {
        this.uiModel = model;
        if (model != null) {
            model.addChangeListener(this);
        }
        this.refreshModel();
    }

    public void unsetup() {
        if (this.uiModel != null) {
            this.uiModel.removeChangeListener(this);
            this.uiModel = null;
            this.refreshModel();
        }
    }

    private void setQuery(final Query query) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterPanelPanel.this.removeAll();
                FilterPanelPanel.this.setBorder(null);
                if (query != null) {
                    FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
                    FilterBuilder builder = filterController.getModel().getLibrary().getBuilder(query.getFilter());
                    try {
                        JPanel panel = builder.getPanel(query.getFilter());
                        if (panel != null) {
                            FilterPanelPanel.this.add((Component)panel, "Center");
                            panel.setOpaque(false);
                            FilterPanelPanel.this.setBorder(BorderFactory.createTitledBorder(query.getFilter().getName() + " " + FilterPanelPanel.this.settingsString));
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger("").log(Level.SEVERE, "Error while setting query", e);
                    }
                }
                FilterPanelPanel.this.revalidate();
                FilterPanelPanel.this.repaint();
            }
        });
    }
}

