/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.awt.Color;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.ElementIdType;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;
import org.openide.util.NbBundle;

public class ImporterGEXF
implements FileImporter,
LongTask {
    private static final String GEXF = "gexf";
    private static final String GEXF_VERSION = "version";
    private static final String GRAPH = "graph";
    private static final String GRAPH_DEFAULT_EDGETYPE = "defaultedgetype";
    private static final String GRAPH_TIMEFORMAT = "timeformat";
    private static final String GRAPH_TIMEREPRESENTATION = "timerepresentation";
    private static final String GRAPH_TIMEFORMAT2 = "timetype";
    private static final String GRAPH_TIMEZONE = "timezone";
    private static final String GRAPH_IDTYPE = "idtype";
    private static final String START = "start";
    private static final String END = "end";
    private static final String START_OPEN = "startopen";
    private static final String END_OPEN = "endopen";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMPS = "timestamps";
    private static final String INTERVALS = "intervals";
    private static final String NODE = "node";
    private static final String NODE_ID = "id";
    private static final String NODE_LABEL = "label";
    private static final String NODE_PID = "pid";
    private static final String NODE_POSITION = "position";
    private static final String NODE_COLOR = "color";
    private static final String NODE_SIZE = "size";
    private static final String NODE_SPELL = "slice";
    private static final String NODE_SPELL2 = "spell";
    private static final String EDGE = "edge";
    private static final String EDGE_ID = "id";
    private static final String EDGE_SOURCE = "source";
    private static final String EDGE_TARGET = "target";
    private static final String EDGE_LABEL = "label";
    private static final String EDGE_TYPE = "type";
    private static final String EDGE_WEIGHT = "weight";
    private static final String EDGE_COLOR = "color";
    private static final String EGDE_KIND = "kind";
    private static final String EDGE_SPELL = "slice";
    private static final String EDGE_SPELL2 = "spell";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTES_CLASS = "class";
    private static final String ATTRIBUTES_TYPE = "type";
    private static final String ATTRIBUTES_TYPE2 = "mode";
    private static final String ATTVALUE = "attvalue";
    private static final String ATTVALUE_FOR = "for";
    private static final String ATTVALUE_FOR2 = "id";
    private static final String ATTVALUE_VALUE = "value";
    private Reader reader;
    private ContainerLoader container;
    private boolean cancel;
    private Report report;
    private ProgressTicket progress;
    private XMLStreamReader xmlReader;

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        Progress.start((ProgressTicket)this.progress);
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            inputFactory.setXMLReporter(new XMLReporter(){

                @Override
                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                }
            });
            this.xmlReader = inputFactory.createXMLStreamReader(this.reader);
            while (this.xmlReader.hasNext()) {
                String name;
                Integer eventType = this.xmlReader.next();
                if (eventType.equals(1)) {
                    name = this.xmlReader.getLocalName();
                    if (GEXF.equalsIgnoreCase(name)) {
                        this.readGexf(this.xmlReader);
                        continue;
                    }
                    if (GRAPH.equalsIgnoreCase(name)) {
                        this.readGraph(this.xmlReader);
                        continue;
                    }
                    if (NODE.equalsIgnoreCase(name)) {
                        this.readNode(this.xmlReader);
                        continue;
                    }
                    if (EDGE.equalsIgnoreCase(name)) {
                        this.readEdge(this.xmlReader);
                        continue;
                    }
                    if (!ATTRIBUTES.equalsIgnoreCase(name)) continue;
                    this.readAttributes(this.xmlReader);
                    continue;
                }
                if (eventType.equals(2) && !NODE.equalsIgnoreCase(name = this.xmlReader.getLocalName())) continue;
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (this.xmlReader != null) {
                    this.xmlReader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        Progress.finish((ProgressTicket)this.progress);
        return !this.cancel;
    }

    private void readGexf(XMLStreamReader reader) throws Exception {
        String version = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (!GEXF_VERSION.equalsIgnoreCase(attName)) continue;
            version = reader.getAttributeValue(i);
        }
        if (!version.isEmpty() && version.equals("1.0")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version10"), Issue.Level.INFO));
        } else if (!version.isEmpty() && version.equals("1.1")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version11"), Issue.Level.INFO));
        } else if (!version.isEmpty() && version.equals("1.2")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version12"), Issue.Level.INFO));
        } else if (!version.isEmpty() && version.equals("1.3")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version13"), Issue.Level.INFO));
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_version_undef"), Issue.Level.WARNING));
        }
    }

    private void readGraph(XMLStreamReader reader) throws Exception {
        String mode = "";
        String defaultEdgeType = "";
        String timeFormat = "";
        String timeRepresentation = "";
        String timeZone = "";
        String timestamp = "";
        String start = "";
        String end = "";
        String idType = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (GRAPH_DEFAULT_EDGETYPE.equalsIgnoreCase(attName)) {
                defaultEdgeType = reader.getAttributeValue(i);
                continue;
            }
            if (ATTRIBUTES_TYPE2.equalsIgnoreCase(attName)) {
                mode = reader.getAttributeValue(i);
                continue;
            }
            if (GRAPH_TIMEFORMAT.equalsIgnoreCase(attName) || GRAPH_TIMEFORMAT2.equalsIgnoreCase(attName)) {
                timeFormat = reader.getAttributeValue(i);
                continue;
            }
            if (GRAPH_TIMEREPRESENTATION.equalsIgnoreCase(attName)) {
                timeRepresentation = reader.getAttributeValue(i);
                continue;
            }
            if (GRAPH_TIMEZONE.equalsIgnoreCase(attName)) {
                timeZone = reader.getAttributeValue(i);
                continue;
            }
            if (TIMESTAMP.equalsIgnoreCase(attName)) {
                timestamp = reader.getAttributeValue(i);
                continue;
            }
            if (START.equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                continue;
            }
            if (END.equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                continue;
            }
            if (!GRAPH_IDTYPE.equals(attName)) continue;
            idType = reader.getAttributeValue(i);
        }
        if (!defaultEdgeType.isEmpty()) {
            if (defaultEdgeType.equalsIgnoreCase("undirected")) {
                this.container.setEdgeDefault(EdgeDirectionDefault.UNDIRECTED);
            } else if (defaultEdgeType.equalsIgnoreCase("directed")) {
                this.container.setEdgeDefault(EdgeDirectionDefault.DIRECTED);
            } else if (defaultEdgeType.equalsIgnoreCase("mutual")) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgedouble"), Issue.Level.WARNING));
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_defaultedgetype", (Object)defaultEdgeType), Issue.Level.SEVERE));
            }
        }
        if (!timeFormat.isEmpty()) {
            if ("double".equalsIgnoreCase(timeFormat) || "float".equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(TimeFormat.DOUBLE);
            } else if ("date".equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(TimeFormat.DATE);
            } else if ("datetime".equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(TimeFormat.DATETIME);
            } else if (TIMESTAMP.equalsIgnoreCase(timeFormat)) {
                this.container.setTimeFormat(TimeFormat.DATETIME);
            }
        } else if (mode.equalsIgnoreCase("dynamic")) {
            this.container.setTimeFormat(TimeFormat.DOUBLE);
        }
        if (!timeRepresentation.isEmpty()) {
            if (TIMESTAMP.equalsIgnoreCase(timeRepresentation)) {
                this.container.setTimeRepresentation(TimeRepresentation.TIMESTAMP);
            } else if ("interval".equalsIgnoreCase(timeRepresentation)) {
                this.container.setTimeRepresentation(TimeRepresentation.INTERVAL);
            }
        }
        if (!timeZone.isEmpty()) {
            try {
                this.container.setTimeZone(DateTimeZone.forID((String)timeZone));
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_timezone_parseerror"), Issue.Level.SEVERE));
            }
        }
        if (!mode.isEmpty() && mode.equalsIgnoreCase("slice")) {
            if (timestamp.isEmpty() && start.isEmpty() && end.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_slice_bound_missing"), Issue.Level.SEVERE));
            }
            if (!timestamp.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                this.container.setTimestamp(timestamp);
            }
            if (!(start.isEmpty() && end.isEmpty() || !this.checkTimerepresentationIsInterval())) {
                this.container.setInterval(start, end);
            }
        }
        if (!idType.isEmpty()) {
            if (idType.equalsIgnoreCase("integer")) {
                this.container.setElementIdType(ElementIdType.INTEGER);
            } else if (idType.equalsIgnoreCase("long")) {
                this.container.setElementIdType(ElementIdType.LONG);
            } else if (idType.equalsIgnoreCase("string")) {
                this.container.setElementIdType(ElementIdType.STRING);
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_idtype_error", (Object)idType), Issue.Level.SEVERE));
            }
        }
    }

    private void readNode(XMLStreamReader reader) throws Exception {
        String id = "";
        String label = "";
        String startDate = "";
        String endDate = "";
        String pid = "";
        String timestamp = "";
        String timestamps = "";
        String intervals = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("label".equalsIgnoreCase(attName)) {
                label = reader.getAttributeValue(i);
                continue;
            }
            if (START.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (END.equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                continue;
            }
            if (END_OPEN.equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                endOpen = true;
                continue;
            }
            if (NODE_PID.equalsIgnoreCase(attName)) {
                pid = reader.getAttributeValue(i);
                continue;
            }
            if (TIMESTAMP.equalsIgnoreCase(attName)) {
                timestamp = reader.getAttributeValue(i);
                continue;
            }
            if (TIMESTAMPS.equalsIgnoreCase(attName)) {
                timestamps = reader.getAttributeValue(i);
                continue;
            }
            if (!INTERVALS.equalsIgnoreCase(attName)) continue;
            intervals = reader.getAttributeValue(i);
        }
        if (id.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeid"), Issue.Level.SEVERE));
            return;
        }
        NodeDraft node = null;
        node = this.container.nodeExists(id) ? this.container.getNode(id) : this.container.factory().newNodeDraft(id);
        node.setLabel(label);
        if (!pid.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_pid", (Object)id), Issue.Level.SEVERE));
        }
        if (!this.container.nodeExists(id)) {
            this.container.addNode(node);
        }
        boolean end = false;
        boolean spells = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = this.xmlReader.getLocalName();
                    if (ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readElementAttValue(reader, (ElementDraft)node);
                        break;
                    }
                    if (NODE_POSITION.equalsIgnoreCase(name)) {
                        this.readNodePosition(reader, node);
                        break;
                    }
                    if ("color".equalsIgnoreCase(name)) {
                        this.readElementColor(reader, (ElementDraft)node);
                        break;
                    }
                    if (NODE_SIZE.equalsIgnoreCase(name)) {
                        this.readNodeSize(reader, node);
                        break;
                    }
                    if ("slice".equalsIgnoreCase(name) || "spell".equalsIgnoreCase(name)) {
                        this.readElementSpell(reader, (ElementDraft)node);
                        spells = true;
                        break;
                    }
                    if (!NODE.equalsIgnoreCase(name)) break;
                    this.readNode(reader);
                    break;
                }
                case 2: {
                    if (!NODE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!spells) {
            if (!(startDate.isEmpty() && endDate.isEmpty() || !this.checkTimerepresentationIsInterval())) {
                if (startOpen || endOpen) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_open_interval", (Object)id), Issue.Level.WARNING));
                }
                try {
                    node.addInterval(startDate, endDate);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timeinterval_parseerror", (Object)id), Issue.Level.SEVERE));
                }
            } else if (!intervals.isEmpty() && this.checkTimerepresentationIsInterval()) {
                try {
                    node.addIntervals(intervals);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timeintervals_parseerror", (Object)id), Issue.Level.SEVERE));
                }
            } else if (!timestamp.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                try {
                    node.addTimestamp(timestamp);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timestamp_parseerror", (Object)id), Issue.Level.SEVERE));
                }
            } else if (!timestamps.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                try {
                    node.addTimestamps(timestamps);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_node_timestamps_parseerror", (Object)id), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readElementAttValue(XMLStreamReader reader, ElementDraft element) {
        block28: {
            String fore = "";
            String value = "";
            String startDate = "";
            String endDate = "";
            String timestamp = "";
            boolean startOpen = false;
            boolean endOpen = false;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attName = reader.getAttributeName(i).getLocalPart();
                if (ATTVALUE_FOR.equalsIgnoreCase(attName) || "id".equalsIgnoreCase(attName)) {
                    fore = reader.getAttributeValue(i);
                    continue;
                }
                if (ATTVALUE_VALUE.equalsIgnoreCase(attName)) {
                    value = reader.getAttributeValue(i);
                    continue;
                }
                if (START.equalsIgnoreCase(attName)) {
                    startDate = reader.getAttributeValue(i);
                    continue;
                }
                if (START_OPEN.equalsIgnoreCase(attName)) {
                    startDate = reader.getAttributeValue(i);
                    startOpen = true;
                    continue;
                }
                if (END.equalsIgnoreCase(attName)) {
                    endDate = reader.getAttributeValue(i);
                    continue;
                }
                if (END_OPEN.equalsIgnoreCase(attName)) {
                    endDate = reader.getAttributeValue(i);
                    endOpen = true;
                    continue;
                }
                if (!TIMESTAMP.equalsIgnoreCase(attName)) continue;
                timestamp = reader.getAttributeValue(i);
            }
            if (fore.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datakey", (Object)element), Issue.Level.SEVERE));
                return;
            }
            if (!value.isEmpty()) {
                ColumnDraft column;
                ColumnDraft columnDraft = column = element instanceof NodeDraft ? this.container.getNodeColumn(fore) : this.container.getEdgeColumn(fore);
                if (column != null) {
                    if (column.isDynamic()) {
                        if (!(startDate.isEmpty() && endDate.isEmpty() || !this.checkTimerepresentationIsInterval())) {
                            if (startOpen || endOpen) {
                                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "_open_interval"), (Object)element), Issue.Level.WARNING));
                            }
                            try {
                                element.parseAndSetValue(column.getId(), value, startDate, endDate);
                            }
                            catch (Exception e) {
                                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "attribute_timeinterval_parseerror"), (Object)element), Issue.Level.SEVERE));
                            }
                        } else if (!timestamp.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                            try {
                                element.parseAndSetValue(column.getId(), value, timestamp);
                            }
                            catch (Exception e) {
                                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "attribute_timestamp_parseerror"), (Object)element), Issue.Level.SEVERE));
                            }
                        } else {
                            try {
                                element.parseAndSetValue(column.getId(), value);
                            }
                            catch (Exception e1) {
                                if (this.checkTimerepresentationIsInterval()) {
                                    try {
                                        element.parseAndSetValue(column.getId(), value, "-inf", "inf");
                                    }
                                    catch (Exception e2) {
                                        this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "attribute_timeinterval_parseerror"), (Object)element), Issue.Level.SEVERE));
                                    }
                                    break block28;
                                }
                                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "attribute_timeset_parseerror"), (Object)element), Issue.Level.SEVERE));
                            }
                        }
                    } else {
                        try {
                            element.parseAndSetValue(column.getId(), value);
                        }
                        catch (Exception e) {
                            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_datavalue", (Object)fore, (Object)element, (Object)column.getTitle()), Issue.Level.SEVERE));
                        }
                    }
                }
            }
        }
    }

    private void readElementColor(XMLStreamReader reader, ElementDraft element) throws Exception {
        String rStr = "";
        String gStr = "";
        String bStr = "";
        String aStr = "";
        String hexStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("r".equalsIgnoreCase(attName)) {
                rStr = reader.getAttributeValue(i);
                continue;
            }
            if ("g".equalsIgnoreCase(attName)) {
                gStr = reader.getAttributeValue(i);
                continue;
            }
            if ("b".equalsIgnoreCase(attName)) {
                bStr = reader.getAttributeValue(i);
                continue;
            }
            if ("a".equalsIgnoreCase(attName)) {
                aStr = reader.getAttributeValue(i);
                continue;
            }
            if (!"hex".equalsIgnoreCase(attName)) continue;
            hexStr = reader.getAttributeValue(i);
        }
        if (!hexStr.isEmpty()) {
            element.setColor(hexStr);
            if (!aStr.isEmpty()) {
                float a;
                float f = a = aStr.isEmpty() ? 1.0f : Float.parseFloat(aStr);
                if (a < 0.0f || a > 1.0f) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "opacityvalue"), (Object)aStr, (Object)element), Issue.Level.WARNING));
                    a = 1.0f;
                }
                Color cl = element.getColor();
                element.setColor(new Color((float)cl.getRed(), (float)cl.getGreen(), (float)cl.getBlue(), a));
            }
        } else {
            float a;
            int r = rStr.isEmpty() ? 0 : Integer.parseInt(rStr);
            int g = gStr.isEmpty() ? 0 : Integer.parseInt(gStr);
            int b = bStr.isEmpty() ? 0 : Integer.parseInt(bStr);
            float f = a = aStr.isEmpty() ? 1.0f : Float.parseFloat(aStr);
            if (r < 0 || r > 255) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "colorvalue"), (Object)rStr, (Object)element, (Object)"r"), Issue.Level.WARNING));
                r = 0;
            }
            if (g < 0 || g > 255) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "colorvalue"), (Object)gStr, (Object)element, (Object)"g"), Issue.Level.WARNING));
                g = 0;
            }
            if (b < 0 || b > 255) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "colorvalue"), (Object)bStr, (Object)element, (Object)"b"), Issue.Level.WARNING));
                b = 0;
            }
            if (a < 0.0f || a > 1.0f) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "opacityvalue"), (Object)aStr, (Object)element), Issue.Level.WARNING));
                a = 1.0f;
            }
            if (!aStr.isEmpty()) {
                element.setColor(new Color(r, g, b, (int)(a * 255.0f)));
            } else {
                element.setColor(new Color(r, g, b));
            }
        }
    }

    private void readNodePosition(XMLStreamReader reader, NodeDraft node) throws Exception {
        String xStr = "";
        String yStr = "";
        String zStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("x".equalsIgnoreCase(attName)) {
                xStr = reader.getAttributeValue(i);
                continue;
            }
            if ("y".equalsIgnoreCase(attName)) {
                yStr = reader.getAttributeValue(i);
                continue;
            }
            if (!"z".equalsIgnoreCase(attName)) continue;
            zStr = reader.getAttributeValue(i);
        }
        if (!xStr.isEmpty()) {
            try {
                float x = Float.parseFloat(xStr);
                node.setX(x);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"X"), Issue.Level.WARNING));
            }
        }
        if (!yStr.isEmpty()) {
            try {
                float y = Float.parseFloat(yStr);
                node.setY(y);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"Y"), Issue.Level.WARNING));
            }
        }
        if (!zStr.isEmpty()) {
            try {
                float z = Float.parseFloat(zStr);
                node.setZ(z);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodeposition", (Object)node, (Object)"Z"), Issue.Level.WARNING));
            }
        }
    }

    private void readNodeSize(XMLStreamReader reader, NodeDraft node) throws Exception {
        String sizeStr;
        String attName = reader.getAttributeName(0).getLocalPart();
        if (ATTVALUE_VALUE.equalsIgnoreCase(attName) && !(sizeStr = reader.getAttributeValue(0)).isEmpty()) {
            try {
                float size = Float.parseFloat(sizeStr);
                node.setSize(size);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_nodesize", (Object)node), Issue.Level.WARNING));
            }
        }
    }

    private void readElementSpell(XMLStreamReader reader, ElementDraft element) throws Exception {
        String start = "";
        String end = "";
        String timestamp = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (START.equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                continue;
            }
            if (END.equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                start = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (END_OPEN.equalsIgnoreCase(attName)) {
                end = reader.getAttributeValue(i);
                endOpen = true;
                continue;
            }
            if (!TIMESTAMP.equalsIgnoreCase(attName)) continue;
            timestamp = reader.getAttributeValue(i);
        }
        if (!(start.isEmpty() && end.isEmpty() || !this.checkTimerepresentationIsInterval())) {
            if (startOpen || endOpen) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "_open_interval"), (Object)element), Issue.Level.WARNING));
            }
            try {
                element.addInterval(start, end);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "_timeinterval_parseerror"), (Object)element), Issue.Level.SEVERE));
            }
        } else if (!timestamp.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
            try {
                element.addTimestamp(timestamp);
            }
            catch (IllegalArgumentException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)("importerGEXF_error_" + (element instanceof NodeDraft ? NODE : EDGE) + "_timestamp_parseerror"), (Object)element), Issue.Level.SEVERE));
            }
        }
    }

    private void readEdge(XMLStreamReader reader) throws Exception {
        String id = "";
        String label = "";
        String source = "";
        String target = "";
        String weight = "";
        String kind = "";
        String edgeType = "";
        String startDate = "";
        String endDate = "";
        String timestamp = "";
        String timestamps = "";
        String intervals = "";
        boolean startOpen = false;
        boolean endOpen = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (EDGE_SOURCE.equalsIgnoreCase(attName)) {
                source = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_TARGET.equalsIgnoreCase(attName)) {
                target = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_WEIGHT.equalsIgnoreCase(attName)) {
                weight = reader.getAttributeValue(i);
                continue;
            }
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("type".equalsIgnoreCase(attName)) {
                edgeType = reader.getAttributeValue(i);
                continue;
            }
            if ("label".equalsIgnoreCase(attName)) {
                label = reader.getAttributeValue(i);
                continue;
            }
            if (EGDE_KIND.equalsIgnoreCase(attName)) {
                kind = reader.getAttributeValue(i);
                continue;
            }
            if (START.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                continue;
            }
            if (END.equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                continue;
            }
            if (START_OPEN.equalsIgnoreCase(attName)) {
                startDate = reader.getAttributeValue(i);
                startOpen = true;
                continue;
            }
            if (END_OPEN.equalsIgnoreCase(attName)) {
                endDate = reader.getAttributeValue(i);
                endOpen = true;
                continue;
            }
            if (TIMESTAMP.equalsIgnoreCase(attName)) {
                timestamp = reader.getAttributeValue(i);
                continue;
            }
            if (TIMESTAMPS.equalsIgnoreCase(attName)) {
                timestamps = reader.getAttributeValue(i);
                continue;
            }
            if (!INTERVALS.equalsIgnoreCase(attName)) continue;
            intervals = reader.getAttributeValue(i);
        }
        EdgeDraft edge = !id.isEmpty() ? this.container.factory().newEdgeDraft(id) : this.container.factory().newEdgeDraft();
        try {
            NodeDraft nodeSource = this.container.getNode(source);
            NodeDraft nodeTarget = this.container.getNode(target);
            edge.setSource(nodeSource);
            edge.setTarget(nodeTarget);
        }
        catch (Exception e) {
            if (source.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgesource"), Issue.Level.SEVERE));
            } else if (target.isEmpty()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgetarget"), Issue.Level.SEVERE));
            } else {
                this.report.logIssue(new Issue(e.getMessage(), Issue.Level.SEVERE));
            }
            return;
        }
        if (!edgeType.isEmpty()) {
            if (edgeType.equalsIgnoreCase("undirected")) {
                edge.setDirection(EdgeDirection.UNDIRECTED);
            } else if (edgeType.equalsIgnoreCase("directed")) {
                edge.setDirection(EdgeDirection.DIRECTED);
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgetype", (Object)edgeType, (Object)edge), Issue.Level.SEVERE));
            }
        }
        if (!weight.isEmpty()) {
            try {
                float weightNumber = Float.parseFloat(weight);
                edge.setWeight((double)weightNumber);
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edgeweight", (Object)edge), Issue.Level.WARNING));
            }
        }
        if (!label.isEmpty()) {
            edge.setLabel(label);
        }
        if (!kind.isEmpty()) {
            edge.setType((Object)kind);
        }
        this.container.addEdge(edge);
        boolean end = false;
        boolean spells = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readElementAttValue(reader, (ElementDraft)edge);
                        break;
                    }
                    if ("color".equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readElementColor(reader, (ElementDraft)edge);
                        break;
                    }
                    if (!"slice".equalsIgnoreCase(this.xmlReader.getLocalName()) && !"spell".equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    this.readElementSpell(reader, (ElementDraft)edge);
                    spells = true;
                    break;
                }
                case 2: {
                    if (!EDGE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!spells) {
            if (!(startDate.isEmpty() && endDate.isEmpty() || !this.checkTimerepresentationIsInterval())) {
                if (startOpen || endOpen) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_open_interval", (Object)edge), Issue.Level.WARNING));
                }
                try {
                    edge.addInterval(startDate, endDate);
                }
                catch (IllegalArgumentException e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timeinterval_parseerror", (Object)edge), Issue.Level.SEVERE));
                }
            } else if (!intervals.isEmpty() && this.checkTimerepresentationIsInterval()) {
                try {
                    edge.addIntervals(intervals);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timeintervals_parseerror", (Object)edge), Issue.Level.SEVERE));
                }
            } else if (!timestamp.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                try {
                    edge.addTimestamp(timestamp);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timestamp_parseerror", (Object)edge), Issue.Level.SEVERE));
                }
            } else if (!timestamps.isEmpty() && this.checkTimerepresentationIsTimestamp()) {
                try {
                    edge.addTimestamps(timestamps);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_edge_timestamps_parseerror", (Object)edge), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readAttributes(XMLStreamReader reader) throws Exception {
        String classAtt = "";
        String typeAtt = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (ATTRIBUTES_CLASS.equalsIgnoreCase(attName)) {
                classAtt = reader.getAttributeValue(i);
                continue;
            }
            if (!"type".equalsIgnoreCase(attName) && !ATTRIBUTES_TYPE2.equalsIgnoreCase(attName)) continue;
            typeAtt = reader.getAttributeValue(i);
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (!ATTRIBUTE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    this.readAttribute(reader, classAtt, typeAtt);
                    break;
                }
                case 2: {
                    if (!ATTRIBUTES.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    private void readAttribute(XMLStreamReader reader, String classAtt, String typeAtt) throws Exception {
        String id = "";
        String type = "";
        String title = "";
        String defaultStr = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if ("type".equalsIgnoreCase(attName)) {
                type = reader.getAttributeValue(i);
                continue;
            }
            if (!ATTRIBUTE_TITLE.equalsIgnoreCase(attName)) continue;
            title = reader.getAttributeValue(i);
        }
        if (title.isEmpty()) {
            title = id;
        }
        if (!id.isEmpty() && !type.isEmpty()) {
            if (classAtt.isEmpty() || !classAtt.equalsIgnoreCase(NODE) && !classAtt.equalsIgnoreCase(EDGE)) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributeclass", (Object)title), Issue.Level.SEVERE));
            }
            boolean end = false;
            boolean defaultFlag = false;
            while (reader.hasNext() && !end) {
                int xmltype = reader.next();
                switch (xmltype) {
                    case 1: {
                        if (!ATTRIBUTE_DEFAULT.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        defaultFlag = true;
                        break;
                    }
                    case 4: {
                        if (!defaultFlag || this.xmlReader.isWhiteSpace()) break;
                        defaultStr = this.xmlReader.getText();
                        break;
                    }
                    case 2: {
                        if (!ATTRIBUTE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        end = true;
                    }
                }
            }
            boolean dynamic = typeAtt.equalsIgnoreCase("dynamic");
            Class attributeType = String.class;
            if (type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("bool")) {
                attributeType = Boolean.class;
            } else if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("int")) {
                attributeType = Integer.class;
            } else if (type.equalsIgnoreCase("long")) {
                attributeType = Long.class;
            } else if (type.equalsIgnoreCase("float")) {
                attributeType = Float.class;
            } else if (type.equalsIgnoreCase("double")) {
                attributeType = Double.class;
            } else if (type.equalsIgnoreCase("string")) {
                attributeType = String.class;
            } else if (type.equalsIgnoreCase("bigdecimal")) {
                attributeType = BigDecimal.class;
            } else if (type.equalsIgnoreCase("biginteger")) {
                attributeType = BigInteger.class;
            } else if (type.equalsIgnoreCase("byte")) {
                attributeType = Byte.class;
            } else if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("character")) {
                attributeType = Character.class;
            } else if (type.equalsIgnoreCase("short")) {
                attributeType = Short.class;
            } else if (type.equalsIgnoreCase("listboolean")) {
                attributeType = boolean[].class;
            } else if (type.equalsIgnoreCase("listint") || type.equalsIgnoreCase("listinteger")) {
                attributeType = int[].class;
            } else if (type.equalsIgnoreCase("listlong")) {
                attributeType = long[].class;
            } else if (type.equalsIgnoreCase("listfloat")) {
                attributeType = float[].class;
            } else if (type.equalsIgnoreCase("listdouble")) {
                attributeType = double[].class;
            } else if (type.equalsIgnoreCase("liststring")) {
                attributeType = String[].class;
            } else if (type.equalsIgnoreCase("listbigdecimal")) {
                attributeType = BigDecimal[].class;
            } else if (type.equalsIgnoreCase("listbiginteger")) {
                attributeType = BigInteger[].class;
            } else if (type.equalsIgnoreCase("listbyte")) {
                attributeType = byte[].class;
            } else if (type.equalsIgnoreCase("listchar") || type.equalsIgnoreCase("listcharacter")) {
                attributeType = char[].class;
            } else if (type.equalsIgnoreCase("listshort")) {
                attributeType = short[].class;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributetype2", (Object)type), Issue.Level.SEVERE));
                return;
            }
            ColumnDraft column = null;
            if (NODE.equalsIgnoreCase(classAtt) || classAtt.isEmpty()) {
                if (this.container.getNodeColumn(id) != null) {
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributecolumn_exist", (Object)id));
                    return;
                }
                column = this.container.addNodeColumn(id, attributeType, dynamic);
                column.setTitle(title);
                this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_nodeattribute", (Object)title, (Object)attributeType.getCanonicalName()));
            } else if (EDGE.equalsIgnoreCase(classAtt) || classAtt.isEmpty()) {
                if (this.container.getEdgeColumn(id) != null) {
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributecolumn_exist", (Object)id));
                    return;
                }
                column = this.container.addEdgeColumn(id, attributeType, dynamic);
                column.setTitle(title);
                this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_edgeattribute", (Object)title, (Object)attributeType.getCanonicalName()));
            }
            if (column != null && !defaultStr.isEmpty()) {
                try {
                    column.setDefaultValueString(defaultStr);
                    this.report.log(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_log_default", (Object)defaultStr, (Object)title));
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributedefault", (Object)title, (Object)attributeType.getCanonicalName()), Issue.Level.SEVERE));
                }
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_attributeempty", (Object)title), Issue.Level.SEVERE));
        }
    }

    private boolean checkTimerepresentationIsInterval() {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.INTERVAL)) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_timerepresentation_intervalerror"), Issue.Level.SEVERE));
            return false;
        }
        return true;
    }

    private boolean checkTimerepresentationIsTimestamp() {
        if (!this.container.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGEXF.class, (String)"importerGEXF_error_timerepresentation_timestamperror"), Issue.Level.SEVERE));
            return false;
        }
        return true;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

