/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.AbstractBeanDefinitionReference;
import io.micronaut.context.AbstractBeanResolutionContext;
import io.micronaut.context.AnnotationProcessorListener;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfiguration;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultCustomScopeRegistry;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.InitializableBeanContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Infrastructure;
import io.micronaut.context.annotation.Parallel;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.event.BeanDestroyedEvent;
import io.micronaut.context.event.BeanDestroyedEventListener;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanPreDestroyEvent;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.exceptions.NonUniqueBeanException;
import io.micronaut.context.processor.AnnotationProcessor;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.context.scope.CustomScopeRegistry;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StreamUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualified;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanContext
implements InitializableBeanContext {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultBeanContext.class);
    protected static final Logger LOG_LIFECYCLE = LoggerFactory.getLogger((String)(DefaultBeanContext.class.getPackage().getName() + ".lifecycle"));
    private static final Qualifier PROXY_TARGET_QUALIFIER = new Qualifier<Object>(){

        @Override
        public <BT extends BeanType<Object>> Stream<BT> reduce(Class<Object> beanType, Stream<BT> candidates) {
            return candidates.filter(bt -> {
                if (bt instanceof BeanDefinitionDelegate) {
                    return !(((BeanDefinitionDelegate)bt).getDelegate() instanceof ProxyBeanDefinition);
                }
                return !(bt instanceof ProxyBeanDefinition);
            });
        }
    };
    private static final String SCOPED_PROXY_ANN = "io.micronaut.runtime.context.scope.ScopedProxy";
    private static final String INTRODUCTION_TYPE = "io.micronaut.aop.Introduction";
    private static final String ADAPTER_TYPE = "io.micronaut.aop.Adapter";
    private static final String NAMED_MEMBER = "named";
    private static final String PARALLEL_TYPE = Parallel.class.getName();
    private static final String INDEXES_TYPE = Indexes.class.getName();
    private static final String REPLACES_ANN = Replaces.class.getName();
    private static final Comparator<BeanRegistration<?>> BEAN_REGISTRATION_COMPARATOR = (o1, o2) -> {
        int order1 = OrderUtil.getOrder(o1.getBeanDefinition(), o1.getBean());
        int order2 = OrderUtil.getOrder(o2.getBeanDefinition(), o2.getBean());
        return Integer.compare(order1, order2);
    };
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicBoolean initializing = new AtomicBoolean(false);
    protected final AtomicBoolean terminating = new AtomicBoolean(false);
    final Map<BeanKey, BeanRegistration> singletonObjects = new ConcurrentHashMap<BeanKey, BeanRegistration>(100);
    final Map<BeanIdentifier, Object> singlesInCreation = new ConcurrentHashMap<BeanIdentifier, Object>(5);
    final Map<BeanKey, Provider<Object>> scopedProxies = new ConcurrentHashMap<BeanKey, Provider<Object>>(20);
    Set<Map.Entry<Class, List<BeanInitializedEventListener>>> beanInitializedEventListeners;
    private final BeanContextConfiguration beanContextConfiguration;
    private final Collection<BeanDefinitionReference> beanDefinitionsClasses = new ConcurrentLinkedQueue<BeanDefinitionReference>();
    private final Map<String, BeanConfiguration> beanConfigurations = new HashMap<String, BeanConfiguration>(10);
    private final Map<BeanKey, Boolean> containsBeanCache = new ConcurrentHashMap<BeanKey, Boolean>(30);
    private final Map<CharSequence, Object> attributes = Collections.synchronizedMap(new HashMap(5));
    private final Map<BeanKey, Collection> initializedObjectsByType = new ConcurrentHashMap<BeanKey, Collection>(50);
    private final Map<BeanKey, Optional<BeanDefinition>> beanConcreteCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Argument, Collection<BeanDefinition>> beanCandidateCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(30L).build();
    private final Map<Class, Collection<BeanDefinitionReference>> beanIndex = new ConcurrentHashMap<Class, Collection<BeanDefinitionReference>>(12);
    private final ClassLoader classLoader;
    private final Set<Class> thisInterfaces = CollectionUtils.setOf((Object[])new Class[]{BeanDefinitionRegistry.class, BeanContext.class, AnnotationMetadataResolver.class, BeanLocator.class, ExecutionHandleLocator.class, ApplicationContext.class, PropertyResolver.class, ValueResolver.class, PropertyPlaceholderResolver.class});
    private final Set<Class> indexedTypes = CollectionUtils.setOf((Object[])new Class[]{ResourceLoader.class, TypeConverter.class, TypeConverterRegistrar.class, ApplicationEventListener.class, BeanCreatedEventListener.class, BeanInitializedEventListener.class});
    private final CustomScopeRegistry customScopeRegistry;
    private final String[] eagerInitStereotypes;
    private final boolean eagerInitStereotypesPresent;
    private final boolean eagerInitSingletons;
    private Set<Map.Entry<Class, List<BeanCreatedEventListener>>> beanCreationEventListeners;
    private BeanDefinitionValidator beanValidator;
    private List<BeanDefinitionReference> beanDefinitionReferences;
    private List<BeanConfiguration> beanConfigurationsList;

    public DefaultBeanContext() {
        this(BeanContext.class.getClassLoader());
    }

    public DefaultBeanContext(final @NonNull ClassLoader classLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"classLoader", (Object)classLoader);
                return classLoader;
            }
        });
    }

    public DefaultBeanContext(final @NonNull ClassPathResourceLoader resourceLoader) {
        this(new BeanContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader.getClassLoader();
            }
        });
    }

    public DefaultBeanContext(@NonNull BeanContextConfiguration contextConfiguration) {
        ArgumentUtils.requireNonNull((String)"contextConfiguration", (Object)contextConfiguration);
        System.setProperty("micronaut.classloader.logging", "true");
        this.classLoader = contextConfiguration.getClassLoader();
        this.customScopeRegistry = Objects.requireNonNull(this.createCustomScopeRegistry(), "Scope registry cannot be null");
        Set<Class<? extends Annotation>> eagerInitAnnotated = contextConfiguration.getEagerInitAnnotated();
        ArrayList<String> eagerInitStereotypes = new ArrayList<String>(eagerInitAnnotated.size());
        for (Class<? extends Annotation> ann : eagerInitAnnotated) {
            eagerInitStereotypes.add(ann.getName());
        }
        this.eagerInitStereotypes = eagerInitStereotypes.toArray(new String[0]);
        this.eagerInitStereotypesPresent = !eagerInitStereotypes.isEmpty();
        this.eagerInitSingletons = this.eagerInitStereotypesPresent && (eagerInitStereotypes.contains("javax.inject.Singleton") || eagerInitStereotypes.contains(Singleton.class.getName()));
        this.beanContextConfiguration = contextConfiguration;
    }

    @NonNull
    protected CustomScopeRegistry createCustomScopeRegistry() {
        return new DefaultCustomScopeRegistry(this);
    }

    @Internal
    @NonNull
    CustomScopeRegistry getCustomScopeRegistry() {
        return this.customScopeRegistry;
    }

    @Override
    public boolean isRunning() {
        return this.running.get() && !this.initializing.get();
    }

    @Override
    public synchronized BeanContext start() {
        if (!this.isRunning()) {
            if (this.initializing.compareAndSet(false, true)) {
                String activeConfigurations;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting BeanContext");
                }
                this.finalizeConfiguration();
                if (LOG.isDebugEnabled() && StringUtils.isNotEmpty((CharSequence)(activeConfigurations = this.beanConfigurations.values().stream().filter(config -> config.isEnabled(this)).map(BeanConfiguration::getName).collect(Collectors.joining(","))))) {
                    LOG.debug("Loaded active configurations: {}", (Object)activeConfigurations);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("BeanContext Started.");
                }
                this.publishEvent(new StartupEvent(this));
            }
            this.running.set(true);
            this.initializing.set(false);
        }
        return this;
    }

    @Override
    public synchronized BeanContext stop() {
        if (this.terminating.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping BeanContext");
            }
            this.publishEvent(new ShutdownEvent(this));
            this.attributes.clear();
            List<BeanRegistration> objects = this.topologicalSort(this.singletonObjects.values());
            HashSet<Integer> processed = new HashSet<Integer>();
            for (BeanRegistration beanRegistration : objects) {
                BeanDefinition def = beanRegistration.beanDefinition;
                Object bean = beanRegistration.bean;
                int sysId = System.identityHashCode(bean);
                if (processed.contains(sysId)) continue;
                if (LOG_LIFECYCLE.isDebugEnabled()) {
                    LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, (Object)beanRegistration.identifier);
                }
                processed.add(sysId);
                try {
                    this.disposeBean(beanRegistration, def.asArgument(), bean, def);
                }
                catch (BeanDestructionException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            this.terminating.set(false);
            this.running.set(false);
        }
        return this;
    }

    @NonNull
    public AnnotationMetadata resolveMetadata(Class<?> type) {
        if (type == null) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        Optional<BeanDefinition<BeanDefinition>> candidate = this.findConcreteCandidate(null, Argument.of(type), null, false);
        return candidate.map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public <T> Optional<T> refreshBean(BeanIdentifier identifier) {
        BeanRegistration beanRegistration;
        if (identifier != null && (beanRegistration = this.singletonObjects.get(identifier)) != null) {
            BeanDefinition definition = beanRegistration.getBeanDefinition();
            return Optional.of(definition.inject(this, beanRegistration.getBean()));
        }
        return Optional.empty();
    }

    @Override
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(Qualifier<?> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<?>> result = this.singletonObjects.values().stream().filter(registration -> {
            BeanDefinition beanDefinition = registration.beanDefinition;
            return qualifier.reduce(beanDefinition.getBeanType(), Stream.of(beanDefinition)).findFirst().isPresent();
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        List<BeanRegistration<T>> result = this.singletonObjects.values().stream().filter(registration -> {
            BeanDefinition beanDefinition = registration.beanDefinition;
            return beanType.isAssignableFrom(beanDefinition.getBeanType());
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Class<T> beanType, Qualifier<T> qualifier) {
        if (beanType == null) {
            return Collections.emptyList();
        }
        return this.getBeanRegistrations(null, Argument.of(beanType), null);
    }

    @Override
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistrations(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> BeanRegistration<T> getBeanRegistration(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistration(null, Objects.requireNonNull(beanType, "Bean type cannot be null"), qualifier);
    }

    @Override
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        if (bean == null) {
            return Optional.empty();
        }
        for (BeanRegistration beanRegistration : this.singletonObjects.values()) {
            if (bean != beanRegistration.getBean()) continue;
            return Optional.of(beanRegistration);
        }
        return this.customScopeRegistry.findBeanRegistration(bean);
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, String method, Class ... arguments) {
        return this.findExecutionHandle(beanType, null, method, arguments);
    }

    public MethodExecutionHandle<?, Object> createExecutionHandle(final BeanDefinition<? extends Object> beanDefinition, final ExecutableMethod<Object, ?> method) {
        return new MethodExecutionHandle<Object, Object>(){
            private Object target;

            @NonNull
            public AnnotationMetadata getAnnotationMetadata() {
                return method.getAnnotationMetadata();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getTarget() {
                Object target = this.target;
                if (target == null) {
                    4 var2_2 = this;
                    synchronized (var2_2) {
                        target = this.target;
                        if (target == null) {
                            try (BeanResolutionContext context = DefaultBeanContext.this.newResolutionContext(beanDefinition, null);){
                                BeanDefinition rawDefinition = beanDefinition;
                                target = DefaultBeanContext.this.getBeanForDefinition(context, Argument.of(rawDefinition.getBeanType()), rawDefinition.getDeclaredQualifier(), true, rawDefinition);
                            }
                            this.target = target;
                        }
                    }
                }
                return target;
            }

            @Override
            public Class getDeclaringType() {
                return beanDefinition.getBeanType();
            }

            @Override
            public String getMethodName() {
                return method.getMethodName();
            }

            @Override
            public Argument[] getArguments() {
                return method.getArguments();
            }

            @Override
            public Method getTargetMethod() {
                return method.getTargetMethod();
            }

            public ReturnType getReturnType() {
                return method.getReturnType();
            }

            @Override
            public Object invoke(Object ... arguments) {
                return method.invoke(this.getTarget(), arguments);
            }

            @Override
            @NonNull
            public ExecutableMethod<?, Object> getExecutableMethod() {
                return method;
            }
        };
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(Class<T> beanType, Qualifier<?> qualifier, String method, Class ... arguments) {
        Optional<BeanDefinition<T>> foundBean = this.findBeanDefinition(beanType, qualifier);
        if (foundBean.isPresent()) {
            BeanDefinition<T> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().filter(m -> {
                Class[] argTypes = m.getArgumentTypes();
                if (argTypes.length == arguments.length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (arguments[i].isAssignableFrom(argTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }).map(executableMethod -> new BeanExecutionHandle(this, beanType, qualifier, executableMethod));
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findExecutableMethod(Class<T> beanType, String method, Class[] arguments) {
        Collection<BeanDefinition<T>> definitions;
        if (beanType != null && !(definitions = this.getBeanDefinitions(beanType)).isEmpty()) {
            BeanDefinition<T> beanDefinition = definitions.iterator().next();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod;
            }
            return beanDefinition.findPossibleMethods(method).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public <T, R> Optional<MethodExecutionHandle<T, R>> findExecutionHandle(T bean, String method, Class[] arguments) {
        Optional<BeanDefinition<?>> foundBean;
        if (bean != null && (foundBean = this.findBeanDefinition(bean.getClass())).isPresent()) {
            BeanDefinition<?> beanDefinition = foundBean.get();
            Optional foundMethod = beanDefinition.findMethod(method, arguments);
            if (foundMethod.isPresent()) {
                return foundMethod.map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
            }
            return beanDefinition.findPossibleMethods(method).findFirst().map(executableMethod -> new ObjectExecutionHandle(bean, executableMethod));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BeanContext registerSingleton(final @NonNull Class<T> type, @NonNull T singleton, Qualifier<T> qualifier, boolean inject) {
        ArgumentUtils.requireNonNull((String)"type", type);
        ArgumentUtils.requireNonNull((String)"singleton", singleton);
        BeanKey<T> beanKey = new BeanKey<T>(type, qualifier, new Class[0]);
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            BeanDefinition<T> beanDefinition;
            this.initializedObjectsByType.clear();
            this.beanCandidateCache.remove(Argument.of(type));
            BeanDefinition<T> beanDefinition2 = beanDefinition = inject ? (BeanDefinition)this.findConcreteCandidate(null, ((BeanKey)beanKey).beanType, qualifier, false).orElse(null) : null;
            if (beanDefinition != null && beanDefinition.getBeanType().isInstance(singleton)) {
                try (BeanResolutionContext context = this.newResolutionContext(beanDefinition, null);){
                    this.doInject(context, singleton, beanDefinition);
                    List<BeanRegistration<?>> dependentBeans = context.getAndResetDependentBeans();
                    if (dependentBeans.isEmpty()) {
                        this.singletonObjects.put(beanKey, new BeanDisposingRegistration<T>(beanKey, beanDefinition, singleton));
                    } else {
                        this.singletonObjects.put(beanKey, new BeanDisposingRegistration<T>(beanKey, beanDefinition, singleton, dependentBeans));
                    }
                    BeanKey concreteKey = new BeanKey(singleton.getClass(), qualifier, new Class[0]);
                    this.singletonObjects.put(concreteKey, new BeanRegistration<T>(concreteKey, beanDefinition, singleton));
                }
            } else {
                NoInjectionBeanDefinition<T> dynamicRegistration = new NoInjectionBeanDefinition<T>(singleton.getClass(), qualifier);
                if (qualifier instanceof Named) {
                    BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(dynamicRegistration);
                    delegate.put(BeanDefinition.NAMED_ATTRIBUTE, ((Named)qualifier).getName());
                    beanDefinition = delegate;
                } else {
                    beanDefinition = dynamicRegistration;
                }
                this.beanDefinitionsClasses.add(dynamicRegistration);
                this.singletonObjects.put(beanKey, new BeanRegistration<T>(beanKey, dynamicRegistration, singleton));
                BeanKey concreteKey = new BeanKey(singleton.getClass(), qualifier, new Class[0]);
                this.singletonObjects.put(concreteKey, new BeanRegistration<T>(concreteKey, dynamicRegistration, singleton));
                for (Class indexedType : this.indexedTypes) {
                    if (indexedType != type && !indexedType.isAssignableFrom(type)) continue;
                    Collection<BeanDefinitionReference> indexed = this.resolveTypeIndex(indexedType);
                    final BeanDefinition<T> finalBeanDefinition = beanDefinition;
                    indexed.add(new AbstractBeanDefinitionReference(type.getName(), type.getName()){

                        @Override
                        protected Class<? extends BeanDefinition<?>> getBeanDefinitionType() {
                            return finalBeanDefinition.getClass();
                        }

                        public BeanDefinition load() {
                            return finalBeanDefinition;
                        }

                        @Override
                        public Class getBeanType() {
                            return type;
                        }
                    });
                    break;
                }
            }
        }
        return this;
    }

    @NonNull
    private BeanResolutionContext newResolutionContext(BeanDefinition<?> beanDefinition, @Nullable BeanResolutionContext currentContext) {
        if (currentContext == null) {
            return new SingletonBeanResolutionContext(beanDefinition);
        }
        return currentContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public BeanDefinitionValidator getBeanValidator() {
        if (this.beanValidator == null) {
            this.beanValidator = this.findBean(BeanDefinitionValidator.class).orElse(BeanDefinitionValidator.DEFAULT);
        }
        return this.beanValidator;
    }

    @Override
    public Optional<BeanConfiguration> findBeanConfiguration(String configurationName) {
        BeanConfiguration configuration = this.beanConfigurations.get(configurationName);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        return Optional.empty();
    }

    @Override
    public <T> BeanDefinition<T> getBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findConcreteCandidate(null, beanType, qualifier, true).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        if (Objects.requireNonNull(beanType, "Bean type cannot be null").equalsType(Argument.OBJECT_ARGUMENT)) {
            return Optional.empty();
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        BeanRegistration reg = this.singletonObjects.get(beanKey);
        if (reg != null) {
            return Optional.of(reg.getBeanDefinition());
        }
        Collection<BeanDefinition<Object>> beanCandidates = new ArrayList<BeanDefinition<T>>(this.findBeanCandidatesInternal(null, ((BeanKey)beanKey).beanType));
        if (qualifier != null) {
            beanCandidates = qualifier.reduce(beanType.getType(), beanCandidates.stream()).collect(Collectors.toList());
        }
        this.filterProxiedTypes(beanCandidates, true, true, null);
        if (beanCandidates.isEmpty()) {
            return Optional.empty();
        }
        if (beanCandidates.size() == 1) {
            return Optional.of(beanCandidates.iterator().next());
        }
        return this.findConcreteCandidate(null, ((BeanKey)beanKey).beanType, qualifier, false);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType) {
        return this.getBeanDefinitions(Argument.of(beanType));
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(null, Objects.requireNonNull(beanType, "Bean type cannot be null"));
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanDefinitions(Argument.of(Objects.requireNonNull(beanType, "Bean type cannot be null")), qualifier);
    }

    @Override
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        Collection candidates = this.findBeanCandidatesInternal(null, beanType);
        if (qualifier != null) {
            candidates = qualifier.reduce(beanType.getType(), new ArrayList<BeanDefinition<T>>(candidates).stream()).collect(Collectors.toList());
        }
        return Collections.unmodifiableCollection(candidates);
    }

    @Override
    public <T> boolean containsBean(@NonNull Class<T> beanType, Qualifier<T> qualifier) {
        return this.containsBean(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> boolean containsBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (this.containsBeanCache.containsKey(beanKey)) {
            return this.containsBeanCache.get(beanKey);
        }
        boolean result = this.singletonObjects.containsKey(beanKey) || this.isCandidatePresent(((BeanKey)beanKey).beanType, qualifier);
        this.containsBeanCache.put(beanKey, result);
        return result;
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        try {
            return this.getBeanInternal(null, Argument.of(beanType), qualifier, true, true);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            throw new NoSuchBeanException(beanType, qualifier);
        }
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull Class<T> beanType) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        try {
            return this.getBeanInternal(null, Argument.of(beanType), null, true, true);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            throw new NoSuchBeanException(beanType, null);
        }
    }

    @Override
    public <T> Optional<T> findBean(Class<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Optional<T> findBean(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.findBean(null, beanType, qualifier);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType) {
        return this.getBeansOfType(null, Argument.of(beanType));
    }

    @Override
    public <T> Collection<T> getBeansOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.getBeanRegistrations(null, Argument.of(beanType), qualifier).stream().map(BeanRegistration::getBean).collect(Collectors.toList());
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType) {
        return this.getBeansOfType(null, beanType);
    }

    @Override
    public <T> Collection<T> getBeansOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.getBeansOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    @Override
    public <T> Stream<T> streamOfType(Argument<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(null, beanType, qualifier);
    }

    protected <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Class<T> beanType, Qualifier<T> qualifier) {
        return this.streamOfType(resolutionContext, Argument.of(beanType), qualifier);
    }

    @Internal
    public <T> Stream<T> streamOfType(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier) {
        Objects.requireNonNull(beanType, "Bean type cannot be null");
        return this.getBeanRegistrations(resolutionContext, beanType, qualifier).stream().map(BeanRegistration::getBean);
    }

    @Override
    @NonNull
    public <T> T inject(@NonNull T instance) {
        Objects.requireNonNull(instance, "Instance cannot be null");
        Collection<BeanDefinition> candidates = this.findBeanCandidatesForInstance(instance);
        if (candidates.size() == 1) {
            BeanDefinition beanDefinition = candidates.stream().findFirst().get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                BeanKey beanKey = new BeanKey(beanDefinition.getBeanType(), null, new Class[0]);
                resolutionContext.addInFlightBean(beanKey, instance);
                this.doInject(resolutionContext, instance, beanDefinition);
            }
        } else if (!candidates.isEmpty()) {
            Iterator iterator = candidates.iterator();
            throw new NonUniqueBeanException(instance.getClass(), iterator);
        }
        return instance;
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.createBean(null, beanType, qualifier);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @Nullable Map<String, Object> argumentValues) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Argument beanArg = Argument.of(beanType);
        Optional<BeanDefinition<T>> candidate = this.findConcreteCandidate(null, beanArg, qualifier, true);
        if (candidate.isPresent()) {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(candidate.get(), null);){
                T createdBean = this.doCreateBean(resolutionContext, candidate.get(), qualifier, beanArg, false, argumentValues);
                if (createdBean == null) {
                    throw new NoSuchBeanException(beanType);
                }
                T t = createdBean;
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @Override
    @NonNull
    public <T> T createBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Argument beanArg = Argument.of(beanType);
        Optional<BeanDefinition<T>> candidate = this.findConcreteCandidate(null, beanArg, qualifier, true);
        if (candidate.isPresent()) {
            BeanDefinition<T> definition = candidate.get();
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(definition, null);){
                T t = this.doCreateBean(resolutionContext, definition, Argument.of(beanType), qualifier, args);
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @NonNull
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier, Object ... args) {
        T createdBean;
        Map<String, Object> argumentValues;
        if (definition instanceof ParametrizedBeanFactory) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating bean for parameters: {}", (Object)ArrayUtils.toString((Object[])args));
            }
            Argument<?>[] requiredArguments = ((ParametrizedBeanFactory)((Object)definition)).getRequiredArguments();
            argumentValues = new LinkedHashMap(requiredArguments.length);
            BeanResolutionContext.Path currentPath = resolutionContext.getPath();
            for (int i = 0; i < requiredArguments.length; ++i) {
                Argument<?> requiredArgument = requiredArguments[i];
                try (BeanResolutionContext.Path ignored = currentPath.pushConstructorResolve(definition, requiredArgument);){
                    Class argumentType = requiredArgument.getType();
                    if (args.length > i) {
                        Object val = args[i];
                        if (val != null) {
                            if (argumentType.isInstance(val) && !CollectionUtils.isIterableOrMap((Class)argumentType)) {
                                argumentValues.put(requiredArgument.getName(), val);
                                continue;
                            }
                            argumentValues.put(requiredArgument.getName(), ConversionService.SHARED.convert(val, requiredArgument).orElseThrow(() -> new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + argumentType)));
                            continue;
                        }
                        if (requiredArgument.isDeclaredNullable()) continue;
                        throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. Argument cannot be null");
                    }
                    Optional<T> existingBean = this.findBean(resolutionContext, argumentType, null);
                    if (existingBean.isPresent()) {
                        argumentValues.put(requiredArgument.getName(), existingBean.get());
                        continue;
                    }
                    if (requiredArgument.isDeclaredNullable()) continue;
                    throw new BeanInstantiationException(resolutionContext, "Invalid bean @Argument [" + requiredArgument + "]. No bean found for type: " + argumentType);
                }
            }
        } else {
            argumentValues = Collections.emptyMap();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed bean argument values: {}", argumentValues);
        }
        if ((createdBean = this.doCreateBean(resolutionContext, definition, qualifier, beanType, false, argumentValues)) == null) {
            throw new NoSuchBeanException(beanType);
        }
        return createdBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T destroyBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        T bean = null;
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            if (this.singletonObjects.containsKey(beanKey)) {
                BeanRegistration beanRegistration = this.singletonObjects.get(beanKey);
                bean = beanRegistration.bean;
                if (bean != null) {
                    if (LOG_LIFECYCLE.isDebugEnabled()) {
                        LOG_LIFECYCLE.debug("Destroying bean [{}] with identifier [{}]", bean, beanKey);
                    }
                    this.purgeBeanRegistrations(bean);
                    this.disposeBean(beanRegistration, beanType, bean, beanRegistration.beanDefinition);
                }
            } else {
                BeanRegistration<T> registration;
                BeanDefinition candidate = this.findConcreteCandidate(null, ((BeanKey)beanKey).beanType, qualifier, false).orElse(null);
                if (candidate != null && (registration = this.findExistingCompatibleSingleton(beanType, null, qualifier, candidate)) != null) {
                    bean = registration.getBean();
                    this.disposeBean(registration, beanType, bean, candidate);
                    this.purgeBeanRegistrations(bean);
                }
            }
        }
        return bean;
    }

    private <T> void purgeBeanRegistrations(T bean) {
        this.singletonObjects.entrySet().removeIf(entry -> ((BeanRegistration)entry.getValue()).bean == bean);
    }

    @Override
    @NonNull
    public <T> T destroyBean(T bean) {
        Objects.requireNonNull(bean, "Bean cannot be null");
        Argument arg = Argument.of(bean.getClass());
        BeanDefinition concreteCandidate = this.findConcreteCandidate(null, arg, null, false).orElse(null);
        if (concreteCandidate != null) {
            this.disposeBean(new BeanDisposingRegistration(new BeanKey(concreteCandidate, concreteCandidate.getDeclaredQualifier()), concreteCandidate, bean), arg, bean, concreteCandidate);
        }
        return bean;
    }

    @Override
    @Nullable
    public <T> T destroyBean(@NonNull Class<T> beanType) {
        return this.destroyBean(Argument.of(beanType), null);
    }

    private <T> void disposeBean(BeanRegistration<T> registration, Argument<T> beanType, T finalBean, BeanDefinition<T> definition) {
        List<BeanPreDestroyEventListener> preDestroyEventListeners = this.resolveListeners(BeanPreDestroyEventListener.class, beanType);
        T beanToDestroy = finalBean;
        if (CollectionUtils.isNotEmpty(preDestroyEventListeners)) {
            for (BeanPreDestroyEventListener listener : preDestroyEventListeners) {
                try {
                    BeanPreDestroyEvent<T> event = new BeanPreDestroyEvent<T>(this, definition, beanToDestroy);
                    beanToDestroy = Objects.requireNonNull(listener.onPreDestroy(event), "PreDestroy event listener illegally returned null: " + listener.getClass());
                }
                catch (Exception e) {
                    throw new BeanDestructionException(definition, (Throwable)e);
                }
            }
        }
        try {
            registration.close();
        }
        catch (Exception e) {
            throw new BeanDestructionException(definition, (Throwable)e);
        }
        List<BeanDestroyedEventListener> postDestroyListeners = this.resolveListeners(BeanDestroyedEventListener.class, beanType);
        if (CollectionUtils.isNotEmpty(postDestroyListeners)) {
            for (BeanDestroyedEventListener listener : postDestroyListeners) {
                try {
                    BeanDestroyedEvent<T> event = new BeanDestroyedEvent<T>(this, definition, beanToDestroy);
                    listener.onDestroyed(event);
                }
                catch (Exception e) {
                    throw new BeanDestructionException(definition, (Throwable)e);
                }
            }
        }
    }

    @NonNull
    private <T extends EventListener> List<T> resolveListeners(Class<T> type, Argument<?> genericType) {
        return this.streamOfType(Argument.of(type, (Argument[])new Argument[]{genericType})).sorted(OrderUtil.COMPARATOR).collect(Collectors.toList());
    }

    @Nullable
    protected <T> BeanRegistration<T> getActiveBeanRegistration(BeanDefinition<T> beanDefinition, Qualifier qualifier) {
        if (beanDefinition == null) {
            return null;
        }
        return this.singletonObjects.get(new BeanKey<T>(beanDefinition, qualifier));
    }

    @NonNull
    protected <T> T createBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Argument beanArgument = Argument.of(beanType);
        Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(resolutionContext, beanArgument, qualifier, true);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> candidate = concreteCandidate.get();
            try (BeanResolutionContext context = this.newResolutionContext(candidate, resolutionContext);){
                T createBean = this.doCreateBean(context, candidate, qualifier, beanArgument, false, null);
                if (createBean == null) {
                    throw new NoSuchBeanException(beanType);
                }
                T t = createBean;
                return t;
            }
        }
        throw new NoSuchBeanException(beanType);
    }

    @NonNull
    protected <T> T inject(@NonNull BeanResolutionContext resolutionContext, @Nullable BeanDefinition requestingBeanDefinition, @NonNull T instance) {
        Class<?> beanType = instance.getClass();
        Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(resolutionContext, Argument.of(beanType), null, false);
        if (concreteCandidate.isPresent()) {
            BeanDefinition<T> definition = concreteCandidate.get();
            if (requestingBeanDefinition != null && requestingBeanDefinition.equals(definition)) {
                return instance;
            }
            this.doInject(resolutionContext, instance, definition);
        }
        return instance;
    }

    @NonNull
    protected <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType) {
        return this.getBeanRegistrations(resolutionContext, beanType, null).stream().map(BeanRegistration::getBean).collect(Collectors.toList());
    }

    @Internal
    @NonNull
    public <T> Collection<T> getBeansOfType(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBeanRegistrations(resolutionContext, beanType, qualifier).stream().map(BeanRegistration::getBean).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getProxyTargetBean(Argument.of(beanType), qualifier);
    }

    @Override
    @NonNull
    public <T> T getProxyTargetBean(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        try (BeanResolutionContext resolutionContext = this.newResolutionContext(definition, null);){
            T t = this.getBeanForDefinition(resolutionContext, beanType, proxyQualifier, true, definition);
            return t;
        }
    }

    @NonNull
    public <T> T getProxyTargetBean(BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        return this.getBeanForDefinition(resolutionContext, beanType, proxyQualifier, true, definition);
    }

    @Override
    @NonNull
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(@NonNull Class<T> beanType, @NonNull String method, @NonNull Class[] arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, null);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(Class<T> beanType, Qualifier<T> qualifier, String method, Class ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    public <T, R> Optional<ExecutableMethod<T, R>> findProxyTargetMethod(Argument<T> beanType, Qualifier<T> qualifier, String method, Class ... arguments) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        BeanDefinition<T> definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
        return definition.findMethod(method, arguments);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(Argument.of(beanType), qualifier);
    }

    @Override
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Qualifier proxyQualifier = qualifier != null ? Qualifiers.byQualifiers(qualifier, PROXY_TARGET_QUALIFIER) : PROXY_TARGET_QUALIFIER;
        BeanKey<T> key = new BeanKey<T>(beanType, proxyQualifier);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(key);
        if (beanDefinition == null) {
            BeanRegistration beanRegistration = this.singletonObjects.get(key);
            if (beanRegistration != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{beanRegistration.bean, beanType, qualifier});
                }
                beanDefinition = Optional.of(beanRegistration.beanDefinition);
            } else {
                beanDefinition = this.findConcreteCandidateNoCache(null, beanType, proxyQualifier, true, false);
            }
            this.beanConcreteCandidateCache.put(key, beanDefinition);
        }
        return beanDefinition;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@Nullable Qualifier<Object> qualifier) {
        if (qualifier == null) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for qualifier: {}", qualifier);
        }
        if (this.beanDefinitionsClasses.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<BeanDefinitionReference> reduced = qualifier.reduce(Object.class, this.beanDefinitionsClasses.stream());
        Stream<BeanDefinition> candidateStream = qualifier.reduce(Object.class, reduced.map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)));
        Collection candidates = candidateStream.collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)candidates)) {
            this.filterProxiedTypes(candidates, true, true, null);
            this.filterReplacedBeans(null, candidates);
        }
        return candidates;
    }

    @Override
    @NonNull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding all bean definitions");
        }
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List<BeanDefinition<?>> collection = this.beanDefinitionsClasses.stream().map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toList());
            return collection;
        }
        return (Collection)((Object)Collections.emptyMap());
    }

    @Override
    @NonNull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences() {
        if (!this.beanDefinitionsClasses.isEmpty()) {
            List refs = this.beanDefinitionsClasses.stream().filter(ref -> ref.isEnabled(this)).collect(Collectors.toList());
            return Collections.unmodifiableList(refs);
        }
        return Collections.emptyList();
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanInternal(resolutionContext, Argument.of(beanType), null, true, true);
    }

    @Override
    @NonNull
    public <T> T getBean(@NonNull BeanDefinition<T> definition) {
        BeanRegistration beanRegistration;
        ArgumentUtils.requireNonNull((String)"definition", definition);
        Qualifier<T> declaredQualifier = definition.getDeclaredQualifier();
        BeanKey<T> key = new BeanKey<T>(definition, declaredQualifier);
        if (definition.isSingleton() && (beanRegistration = this.singletonObjects.get(key)) != null) {
            return beanRegistration.bean;
        }
        try (BeanResolutionContext context = this.newResolutionContext(definition, null);){
            T t = this.getBeanForDefinition(context, ((BeanKey)key).beanType, declaredQualifier, true, definition);
            return t;
        }
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.getBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    public <T> T getBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        T bean = this.getBeanInternal(resolutionContext, beanType, qualifier, true, true);
        if (bean == null) {
            throw new NoSuchBeanException(beanType, qualifier);
        }
        return bean;
    }

    @Override
    public <T> T getBean(Argument<T> beanType, Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        T bean = this.getBeanInternal(null, beanType, qualifier, true, true);
        if (bean == null) {
            throw new NoSuchBeanException(beanType, qualifier);
        }
        return bean;
    }

    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBean(resolutionContext, Argument.of(beanType), qualifier);
    }

    @NonNull
    public <T> Optional<T> findBean(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        if (this.thisInterfaces.contains(beanType.getType())) {
            return Optional.of(this);
        }
        try {
            T bean = this.getBeanInternal(resolutionContext, beanType, qualifier, true, false);
            if (bean == null) {
                return Optional.empty();
            }
            return Optional.of(bean);
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getSimpleName(), (Object)e.getMessage());
            }
            return Optional.empty();
        }
    }

    @Override
    public BeanContextConfiguration getContextConfiguration() {
        return this.beanContextConfiguration;
    }

    @Override
    public void publishEvent(@NonNull Object event) {
        if (event != null) {
            ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEvent(event);
        }
    }

    @Override
    @NonNull
    public Future<Void> publishEventAsync(@NonNull Object event) {
        Objects.requireNonNull(event, "Event cannot be null");
        return ((ApplicationEventPublisher)this.getBean(Argument.of(ApplicationEventPublisher.class, (Class[])new Class[]{event.getClass()}))).publishEventAsync(event);
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanDefinitions(beanType, qualifier).stream().filter(BeanDefinition::isProxy).findFirst();
    }

    @Override
    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        return this.getBeanDefinitions(beanType, qualifier).stream().filter(BeanDefinition::isProxy).findFirst();
    }

    protected void invalidateCaches() {
        this.beanCandidateCache.clear();
        this.initializedObjectsByType.clear();
    }

    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.beanDefinitionReferences == null) {
            SoftServiceLoader definitions = SoftServiceLoader.load(BeanDefinitionReference.class, (ClassLoader)this.classLoader);
            this.beanDefinitionReferences = new ArrayList<BeanDefinitionReference>(300);
            definitions.collectAll(this.beanDefinitionReferences, BeanDefinitionReference::isPresent);
        }
        return this.beanDefinitionReferences;
    }

    @Deprecated
    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(@Nullable Predicate<BeanDefinitionReference> predicate) {
        if (predicate != null) {
            List<BeanDefinitionReference> allRefs = this.resolveBeanDefinitionReferences();
            ArrayList<BeanDefinitionReference> newRefs = new ArrayList<BeanDefinitionReference>(allRefs.size());
            for (BeanDefinitionReference reference : allRefs) {
                if (!predicate.test(reference)) continue;
                newRefs.add(reference);
            }
            return newRefs;
        }
        return this.resolveBeanDefinitionReferences();
    }

    @NonNull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.beanConfigurationsList == null) {
            SoftServiceLoader definitions = SoftServiceLoader.load(BeanConfiguration.class, (ClassLoader)this.classLoader);
            this.beanConfigurationsList = new ArrayList<BeanConfiguration>(300);
            definitions.collectAll(this.beanConfigurationsList, null);
        }
        return this.beanConfigurationsList;
    }

    protected void initializeEventListeners() {
        Collection<BeanDefinition<BeanCreatedEventListener>> beanCreatedDefinitions = this.getBeanDefinitions(BeanCreatedEventListener.class);
        HashMap<Class, List> beanCreatedListeners = new HashMap<Class, List>(beanCreatedDefinitions.size());
        beanCreatedListeners.put(AnnotationProcessor.class, Arrays.asList(new AnnotationProcessorListener()));
        for (BeanDefinition<BeanCreatedEventListener> beanCreatedDefinition : beanCreatedDefinitions) {
            BeanResolutionContext context = this.newResolutionContext(beanCreatedDefinition, null);
            Throwable throwable = null;
            try {
                Qualifier<BeanCreatedEventListener> qualifier = beanCreatedDefinition.getDeclaredQualifier();
                BeanCreatedEventListener listener = beanCreatedDefinition.isSingleton() ? this.createAndRegisterSingleton(context, beanCreatedDefinition, beanCreatedDefinition.getBeanType(), qualifier) : this.doCreateBean(context, beanCreatedDefinition, Argument.of(BeanCreatedEventListener.class), qualifier, new Object[0]);
                List<Argument<BeanCreatedEventListener>> typeArguments = beanCreatedDefinition.getTypeArguments(BeanCreatedEventListener.class);
                Argument argument = (Argument)CollectionUtils.last(typeArguments);
                if (argument == null) {
                    argument = Argument.OBJECT_ARGUMENT;
                }
                beanCreatedListeners.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(listener);
            }
            catch (Throwable listener) {
                throwable = listener;
                throw listener;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable listener) {
                        throwable.addSuppressed(listener);
                    }
                    continue;
                }
                context.close();
            }
        }
        for (List listenerList : beanCreatedListeners.values()) {
            OrderUtil.sort((List)listenerList);
        }
        HashMap<Class, List> beanInitializedListeners = new HashMap<Class, List>(beanCreatedDefinitions.size());
        Collection<BeanDefinition<BeanInitializedEventListener>> beanInitializedDefinitions = this.getBeanDefinitions(BeanInitializedEventListener.class);
        for (BeanDefinition<BeanInitializedEventListener> definition : beanInitializedDefinitions) {
            BeanResolutionContext context = this.newResolutionContext(definition, null);
            Throwable throwable = null;
            try {
                Qualifier<BeanInitializedEventListener> qualifier = definition.getDeclaredQualifier();
                BeanInitializedEventListener listener = definition.isSingleton() ? this.createAndRegisterSingleton(context, definition, definition.getBeanType(), qualifier) : this.doCreateBean(context, definition, Argument.of(BeanInitializedEventListener.class), qualifier, new Object[0]);
                List<Argument<BeanInitializedEventListener>> typeArguments = definition.getTypeArguments(BeanInitializedEventListener.class);
                Argument argument = (Argument)CollectionUtils.last(typeArguments);
                if (argument == null) {
                    argument = Argument.OBJECT_ARGUMENT;
                }
                beanInitializedListeners.computeIfAbsent(argument.getType(), aClass -> new ArrayList(10)).add(listener);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                context.close();
            }
        }
        for (List listenerList : beanInitializedListeners.values()) {
            OrderUtil.sort((List)listenerList);
        }
        this.beanCreationEventListeners = beanCreatedListeners.entrySet();
        this.beanInitializedEventListeners = beanInitializedListeners.entrySet();
    }

    protected void initializeContext(@NonNull List<BeanDefinitionReference> contextScopeBeans, @NonNull List<BeanDefinitionReference> processedBeans, @NonNull List<BeanDefinitionReference> parallelBeans) {
        if (CollectionUtils.isNotEmpty(contextScopeBeans)) {
            ArrayList contextBeans = new ArrayList(contextScopeBeans.size());
            for (BeanDefinitionReference beanDefinitionReference : contextScopeBeans) {
                try {
                    this.loadContextScopeBean(beanDefinitionReference, contextBeans::add);
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
            this.filterProxiedTypes(contextBeans, true, false, null);
            this.filterReplacedBeans(null, contextBeans);
            for (BeanDefinition beanDefinition2 : contextBeans) {
                try {
                    this.loadContextScopeBean(beanDefinition2);
                }
                catch (DisabledBeanException e) {
                    if (!AbstractBeanContextConditional.LOG.isDebugEnabled()) continue;
                    AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanDefinition2.getBeanType().getSimpleName(), (Object)e.getMessage());
                }
                catch (Throwable e) {
                    throw new BeanInstantiationException("Bean definition [" + beanDefinition2.getName() + "] could not be loaded: " + e.getMessage(), e);
                }
            }
        }
        if (!processedBeans.isEmpty()) {
            Stream methodStream = processedBeans.stream().filter(ref -> ref.isEnabled(this)).map(reference -> {
                try {
                    return reference.load(this);
                }
                catch (Exception e) {
                    throw new BeanInstantiationException("Bean definition [" + reference.getName() + "] could not be loaded: " + e.getMessage(), (Throwable)e);
                }
            }).filter(bean -> bean.isEnabled(this)).flatMap(beanDefinition -> beanDefinition.getExecutableMethods().parallelStream().filter(method -> method.hasStereotype(Executable.class)).map(executableMethod -> BeanDefinitionMethodReference.of(beanDefinition, executableMethod)));
            HashMap<Class, List> byAnnotation = new HashMap<Class, List>(processedBeans.size());
            methodStream.forEach(reference -> {
                List annotations = reference.getAnnotationTypesByStereotype(Executable.class);
                annotations.forEach(annotation -> byAnnotation.compute((Class)annotation, (ann, list) -> {
                    if (list == null) {
                        list = new ArrayList<BeanDefinitionMethodReference>(10);
                    }
                    list.add(reference);
                    return list;
                }));
            });
            byAnnotation.forEach((annotationType, methods) -> this.streamOfType(ExecutableMethodProcessor.class, Qualifiers.byTypeArguments(annotationType)).forEach(processor -> {
                if (processor instanceof LifeCycle) {
                    ((LifeCycle)((Object)processor)).start();
                }
                for (BeanDefinitionMethodReference method : methods) {
                    BeanDefinition beanDefinition = method.getBeanDefinition();
                    if (beanDefinition.hasStereotype((Class)annotationType)) continue;
                    if (method.hasDeclaredStereotype(Parallel.class)) {
                        ForkJoinPool.commonPool().execute(() -> {
                            block3: {
                                try {
                                    processor.process((BeanDefinition<?>)beanDefinition, method);
                                }
                                catch (Throwable e) {
                                    Boolean shutdownOnError;
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error("Error processing bean method " + beanDefinition + "." + method + " with processor (" + processor + "): " + e.getMessage(), e);
                                    }
                                    if (!(shutdownOnError = method.booleanValue(Parallel.class, "shutdownOnError").orElse(true)).booleanValue()) break block3;
                                    this.stop();
                                }
                            }
                        });
                        continue;
                    }
                    processor.process((BeanDefinition<?>)beanDefinition, method);
                }
                if (processor instanceof LifeCycle) {
                    ((LifeCycle)((Object)processor)).stop();
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(parallelBeans)) {
            this.processParallelBeans(parallelBeans);
        }
        Runnable runnable = () -> this.beanDefinitionsClasses.removeIf(beanDefinitionReference -> !beanDefinitionReference.isEnabled(this));
        ForkJoinPool.commonPool().execute(runnable);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@NonNull Class<T> beanType, @Nullable BeanDefinition<?> filter) {
        return this.findBeanCandidates(null, Argument.of(beanType), filter, true);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable BeanDefinition<?> filter, boolean filterProxied) {
        Predicate<BeanDefinition<BeanDefinition<BeanDefinition<BeanDefinition<T>>>>> predicate = filter == null ? null : definition -> !definition.equals(filter);
        return this.findBeanCandidates(resolutionContext, beanType, filterProxied, predicate);
    }

    @NonNull
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, boolean filterProxied, Predicate<BeanDefinition<T>> predicate) {
        Collection<BeanDefinitionReference> beanDefinitionsClasses;
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        Class beanClass = beanType.getType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for type: {}", beanType);
        }
        if (this.indexedTypes.contains(beanClass)) {
            beanDefinitionsClasses = this.beanIndex.get(beanClass);
            if (beanDefinitionsClasses == null) {
                beanDefinitionsClasses = Collections.emptyList();
            }
        } else {
            beanDefinitionsClasses = this.beanDefinitionsClasses;
        }
        if (!beanDefinitionsClasses.isEmpty()) {
            HashSet<BeanDefinition<T>> candidates = new HashSet<BeanDefinition<T>>();
            for (BeanDefinitionReference reference : beanDefinitionsClasses) {
                BeanDefinition loadedBean;
                if (!reference.isCandidateBean(beanType) || !reference.isEnabled(this, resolutionContext)) continue;
                try {
                    loadedBean = reference.load(this);
                }
                catch (Throwable e) {
                    throw new BeanContextException("Error loading bean [" + reference.getName() + "]: " + e.getMessage(), e);
                }
                if (!loadedBean.isCandidateBean(beanType) || predicate != null && !predicate.test(loadedBean) || !loadedBean.isEnabled(this, resolutionContext)) continue;
                candidates.add(loadedBean);
            }
            if (!candidates.isEmpty()) {
                if (filterProxied) {
                    this.filterProxiedTypes(candidates, true, false, null);
                }
                this.filterReplacedBeans(resolutionContext, candidates);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved bean candidates {} for type: {}", candidates, beanType);
            }
            return candidates;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No bean candidates found for type: {}", beanType);
        }
        return Collections.emptySet();
    }

    protected <T> Collection<BeanDefinition<T>> transformIterables(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates, boolean filterProxied) {
        return candidates;
    }

    @NonNull
    protected <T> Collection<BeanDefinition> findBeanCandidatesForInstance(@NonNull T instance) {
        ArgumentUtils.requireNonNull((String)"instance", instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding candidate beans for instance: {}", instance);
        }
        Collection<BeanDefinitionReference> beanDefinitionsClasses = this.beanDefinitionsClasses;
        Class<?> beanClass = instance.getClass();
        Argument beanType = Argument.of(beanClass);
        Collection<BeanDefinition> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            if (!beanDefinitionsClasses.isEmpty()) {
                List candidates = beanDefinitionsClasses.stream().filter(reference -> {
                    if (reference.isEnabled(this)) {
                        Class candidateType = reference.getBeanType();
                        return candidateType != null && candidateType.isInstance(instance);
                    }
                    return false;
                }).map(ref -> ref.load(this)).filter(candidate -> candidate.isEnabled(this)).collect(Collectors.toList());
                if (candidates.size() > 1) {
                    candidates = candidates.stream().filter(candidate -> !(candidate instanceof NoInjectionBeanDefinition) && candidate.getBeanType() == beanClass).collect(Collectors.toList());
                    beanDefinitions = candidates;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolved bean candidates {} for instance: {}", candidates, instance);
                }
                beanDefinitions = candidates;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No bean candidates found for instance: {}", instance);
                }
                beanDefinitions = Collections.emptySet();
            }
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    protected synchronized void registerConfiguration(@NonNull BeanConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.beanConfigurations.put(configuration.getName(), configuration);
    }

    @Nullable
    @Deprecated
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, boolean isSingleton, @Nullable Map<String, Object> argumentValues) {
        return this.doCreateBean(resolutionContext, beanDefinition, qualifier, Argument.of(beanDefinition.getBeanType()), isSingleton, argumentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Nullable
    protected <T> T doCreateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> beanDefinition, @Nullable Qualifier<T> qualifier, @Nullable Argument<T> qualifierBeanType, boolean isSingleton, @Nullable Map<String, Object> argumentValues) {
        if (argumentValues == null) {
            argumentValues = Collections.emptyMap();
        }
        declaredQualifier = beanDefinition.getDeclaredQualifier();
        beanType = beanDefinition.getBeanType();
        if (isSingleton) {
            beanRegistration = this.singletonObjects.get(new BeanKey<T>(beanDefinition, declaredQualifier));
            beanClass = qualifierBeanType.getType();
            if (beanRegistration != null ? qualifier == null || qualifier.reduce(beanClass, Stream.of(beanRegistration.beanDefinition)).findFirst().isPresent() != false : qualifier != null && (beanRegistration = this.singletonObjects.get(new BeanKey<T>(beanDefinition, null))) != null && qualifier.reduce(beanClass, Stream.of(beanRegistration.beanDefinition)).findFirst().isPresent() != false) {
                return beanRegistration.bean;
            }
        }
        if (beanDefinition instanceof BeanFactory) {
            beanFactory = (BeanFactory)beanDefinition;
            try {
                if (beanFactory instanceof ParametrizedBeanFactory) {
                    parametrizedBeanFactory = (ParametrizedBeanFactory)beanFactory;
                    requiredArguments = parametrizedBeanFactory.getRequiredArguments();
                    convertedValues = new LinkedHashMap<String, Object>(argumentValues);
                    for (Argument<?> requiredArgument : requiredArguments) {
                        argumentName = requiredArgument.getName();
                        val = argumentValues.get(argumentName);
                        if (val == null && !requiredArgument.isDeclaredNullable()) {
                            throw new BeanInstantiationException(resolutionContext, "Missing bean argument [" + requiredArgument + "] for type: " + beanType.getName() + ". Required arguments: " + ArrayUtils.toString((Object[])requiredArguments));
                        }
                        convertedValue = null;
                        if (val != null) {
                            convertedValue = requiredArgument.getType().isInstance(val) != false ? val : ConversionService.SHARED.convert(val, requiredArgument).orElseThrow((Supplier<BeanInstantiationException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCreateBean$38(io.micronaut.context.BeanResolutionContext io.micronaut.core.type.Argument java.lang.Object ), ()Lio/micronaut/context/exceptions/BeanInstantiationException;)((BeanResolutionContext)resolutionContext, requiredArgument, (Object)val));
                        }
                        convertedValues.put(argumentName, convertedValue);
                    }
                    bean = parametrizedBeanFactory.build(resolutionContext, this, beanDefinition, convertedValues);
                }
                v0 = propagateQualifier = beanDefinition.isProxy() != false && declaredQualifier instanceof Named != false;
                if (propagateQualifier) {
                    resolutionContext.setAttribute(BeanDefinition.NAMED_ATTRIBUTE, ((Named)declaredQualifier).getName());
                }
                resolutionContext.setCurrentQualifier(declaredQualifier != null ? declaredQualifier : qualifier);
                try {
                    bean = beanFactory.build(resolutionContext, this, beanDefinition);
                }
                finally {
                    resolutionContext.setCurrentQualifier(null);
                    if (propagateQualifier) {
                        resolutionContext.removeAttribute(BeanDefinition.NAMED_ATTRIBUTE);
                    }
                }
                if (bean == null) {
                    throw new BeanInstantiationException(resolutionContext, "Bean Factory [" + beanFactory + "] returned null");
                }
                if (!(bean instanceof Qualified)) ** GOTO lbl73
                ((Qualified)bean).$withBeanQualifier(declaredQualifier);
            }
            catch (Throwable e) {
                if (e instanceof DependencyInjectionException) {
                    throw e;
                }
                if (e instanceof DisabledBeanException) {
                    throw e;
                }
                if (e instanceof BeanInstantiationException) {
                    throw e;
                }
                if (!resolutionContext.getPath().isEmpty()) {
                    throw new BeanInstantiationException(resolutionContext, e);
                }
                throw new BeanInstantiationException(beanDefinition, e);
            }
        } else {
            constructor = beanDefinition.getConstructor();
            requiredConstructorArguments = constructor.getArguments();
            if (requiredConstructorArguments.length == 0) {
                bean = constructor.invoke(new Object[0]);
            } else {
                constructorArgs = new Object[requiredConstructorArguments.length];
                for (i = 0; i < requiredConstructorArguments.length; ++i) {
                    argument = requiredConstructorArguments[i].getType();
                    constructorArgs[i] = this.getBean(resolutionContext, argument);
                }
                bean = constructor.invoke(constructorArgs);
            }
            this.inject(resolutionContext, null, bean);
        }
lbl73:
        // 4 sources

        if (bean != null) {
            v1 = finalQualifier = qualifier != null ? qualifier : declaredQualifier;
            if (!(bean instanceof BeanCreatedEventListener) && CollectionUtils.isNotEmpty(this.beanCreationEventListeners)) {
                for (Map.Entry<Class, List<BeanCreatedEventListener>> entry : this.beanCreationEventListeners) {
                    if (!entry.getKey().isAssignableFrom(beanType)) continue;
                    beanKey = new BeanKey<T>(beanDefinition, finalQualifier);
                    for (BeanCreatedEventListener listener : entry.getValue()) {
                        bean = listener.onCreated(new BeanCreatedEvent<T>(this, beanDefinition, beanKey, bean));
                        if (bean != null) continue;
                        throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onCreated event");
                    }
                }
            }
            if (beanDefinition instanceof ValidatedBeanDefinition) {
                bean = ((ValidatedBeanDefinition)beanDefinition).validate(resolutionContext, bean);
            }
            if (DefaultBeanContext.LOG_LIFECYCLE.isDebugEnabled()) {
                DefaultBeanContext.LOG_LIFECYCLE.debug("Created bean [{}] from definition [{}] with qualifier [{}]", new Object[]{bean, beanDefinition, finalQualifier});
            }
        }
        return bean;
    }

    @NonNull
    protected <T> BeanDefinition<T> findConcreteCandidate(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier, @NonNull Collection<BeanDefinition<T>> candidates) {
        if (qualifier instanceof AnyQualifier) {
            return candidates.iterator().next();
        }
        throw new NonUniqueBeanException(beanType, candidates.iterator());
    }

    protected void processParallelBeans(List<BeanDefinitionReference> parallelBeans) {
        List finalParallelBeans;
        if (!parallelBeans.isEmpty() && !(finalParallelBeans = parallelBeans.stream().filter(bdr -> bdr.isEnabled(this)).collect(Collectors.toList())).isEmpty()) {
            new Thread(() -> {
                ArrayList<BeanDefinition<BeanDefinition>> parallelDefinitions = new ArrayList<BeanDefinition<BeanDefinition>>();
                finalParallelBeans.forEach(beanDefinitionReference -> {
                    block5: {
                        try {
                            Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                            synchronized (map) {
                                this.loadContextScopeBean((BeanDefinitionReference)beanDefinitionReference, parallelDefinitions::add);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [" + beanDefinitionReference.getName() + "] could not be loaded: " + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinitionReference.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block5;
                            this.stop();
                        }
                    }
                });
                this.filterProxiedTypes(parallelDefinitions, true, false, null);
                this.filterReplacedBeans(null, parallelDefinitions);
                parallelDefinitions.forEach(beanDefinition -> ForkJoinPool.commonPool().execute(() -> {
                    block5: {
                        try {
                            Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                            synchronized (map) {
                                this.loadContextScopeBean((BeanDefinition)beanDefinition);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Parallel Bean definition [" + beanDefinition.getName() + "] could not be loaded: " + e.getMessage(), e);
                            Boolean shutdownOnError = beanDefinition.getAnnotationMetadata().booleanValue(Parallel.class, "shutdownOnError").orElse(true);
                            if (!shutdownOnError.booleanValue()) break block5;
                            this.stop();
                        }
                    }
                }));
                parallelDefinitions.clear();
            }).start();
        }
    }

    private <T> void filterReplacedBeans(BeanResolutionContext resolutionContext, Collection<? extends BeanType<T>> candidates) {
        if (candidates.size() > 1) {
            ArrayList replacementTypes = new ArrayList(2);
            for (BeanType<T> candidate : candidates) {
                if (!candidate.getAnnotationMetadata().hasStereotype(REPLACES_ANN)) continue;
                replacementTypes.add(candidate);
            }
            if (!replacementTypes.isEmpty()) {
                candidates.removeIf(definition -> {
                    if (!definition.isEnabled(this, resolutionContext)) {
                        return true;
                    }
                    AnnotationMetadata annotationMetadata = definition.getAnnotationMetadata();
                    if (annotationMetadata.hasDeclaredStereotype(Infrastructure.class)) {
                        return false;
                    }
                    Optional<Object> declaringType = Optional.empty();
                    if (definition instanceof BeanDefinition) {
                        declaringType = ((BeanDefinition)definition).getDeclaringType();
                    }
                    Function<Class, Boolean> comparisonFunction = null;
                    for (BeanType replacingCandidate : replacementTypes) {
                        String qualifier;
                        if (definition == replacingCandidate || replacingCandidate instanceof ProxyBeanDefinition && ((ProxyBeanDefinition)replacingCandidate).getTargetDefinitionType() == definition.getClass()) continue;
                        AnnotationValue replacesAnn = replacingCandidate.getAnnotation(Replaces.class);
                        Class beanType = replacesAnn.classValue().orElse(this.getCanonicalBeanType(replacingCandidate));
                        if (replacesAnn.contains(NAMED_MEMBER) && (qualifier = (String)replacesAnn.stringValue(NAMED_MEMBER).orElse(null)) != null) {
                            Optional<BeanType> qualified = Qualifiers.byName(qualifier).qualify(beanType, Stream.of(definition));
                            if (!qualified.isPresent()) continue;
                            return true;
                        }
                        Optional factory = replacesAnn.classValue("factory");
                        if (LOG.isDebugEnabled()) {
                            if (factory.isPresent()) {
                                LOG.debug("Bean [{}] replaces existing bean of type [{}] in factory type [{}]", new Object[]{replacingCandidate.getBeanType(), beanType, factory.get()});
                            } else {
                                LOG.debug("Bean [{}] replaces existing bean of type [{}]", replacingCandidate.getBeanType(), beanType);
                            }
                        }
                        if (comparisonFunction == null) {
                            comparisonFunction = this.typeMatches((BeanType)definition, annotationMetadata);
                        }
                        if (!(factory.isPresent() && declaringType.isPresent() ? factory.get() == declaringType.get() && comparisonFunction.apply(beanType) != false : comparisonFunction.apply(beanType) != false)) continue;
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    private <T> Class<T> getCanonicalBeanType(BeanType<T> beanType) {
        if (beanType instanceof AdvisedBeanType) {
            return ((AdvisedBeanType)beanType).getInterceptedType();
        }
        if (beanType instanceof ProxyBeanDefinition) {
            return ((ProxyBeanDefinition)beanType).getTargetType();
        }
        AnnotationMetadata annotationMetadata = beanType.getAnnotationMetadata();
        Class<T> bt = beanType.getBeanType();
        if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
            Class<T> superclass = bt.getSuperclass();
            if (superclass == Object.class || superclass == null) {
                return bt;
            }
            return superclass;
        }
        if (annotationMetadata.hasStereotype("io.micronaut.aop.Around")) {
            Class<T> superclass = bt.getSuperclass();
            if (superclass != null) {
                return superclass;
            }
            return bt;
        }
        return bt;
    }

    private <T> Function<Class, Boolean> typeMatches(BeanType<T> definition, AnnotationMetadata annotationMetadata) {
        Class bt;
        if (definition instanceof ProxyBeanDefinition) {
            bt = ((ProxyBeanDefinition)definition).getTargetType();
        } else if (definition instanceof AdvisedBeanType) {
            bt = ((AdvisedBeanType)definition).getInterceptedType();
        } else {
            bt = definition.getBeanType();
            if (annotationMetadata.hasStereotype(INTRODUCTION_TYPE)) {
                Class superclass = bt.getSuperclass();
                if (superclass == Object.class) {
                    return clazz -> clazz.isAssignableFrom(bt);
                }
                return clazz -> clazz == superclass;
            }
            if (annotationMetadata.hasStereotype("io.micronaut.aop.Around")) {
                Class superclass = bt.getSuperclass();
                return clazz -> clazz == superclass || clazz == bt;
            }
        }
        if (annotationMetadata.hasAnnotation(DefaultImplementation.class)) {
            Optional defaultImpl = annotationMetadata.classValue(DefaultImplementation.class);
            if (!defaultImpl.isPresent()) {
                defaultImpl = annotationMetadata.classValue(DefaultImplementation.class, "name");
            }
            if (defaultImpl.filter(impl -> impl == bt).isPresent()) {
                return clazz -> clazz.isAssignableFrom(bt);
            }
            return clazz -> clazz == bt;
        }
        return clazz -> clazz != Object.class && clazz.isAssignableFrom(bt);
    }

    private <T> void doInject(BeanResolutionContext resolutionContext, T instance, BeanDefinition definition) {
        definition.inject(resolutionContext, this, instance);
        if (definition instanceof InitializingBeanDefinition) {
            ((InitializingBeanDefinition)definition).initialize(resolutionContext, this, instance);
        }
    }

    private void loadContextScopeBean(BeanDefinitionReference contextScopeBean, Consumer<BeanDefinition> beanDefinitionConsumer) {
        if (contextScopeBean.isEnabled(this)) {
            BeanDefinition beanDefinition = contextScopeBean.load(this);
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                if (beanDefinition.isEnabled(this, resolutionContext)) {
                    beanDefinitionConsumer.accept(beanDefinition);
                }
            }
        }
    }

    private void loadContextScopeBean(BeanDefinition beanDefinition) {
        if (beanDefinition.isIterable() || beanDefinition.hasStereotype(ConfigurationReader.class.getName())) {
            Collection beanCandidates = this.transformIterables(null, Collections.singleton(beanDefinition), true);
            for (BeanDefinition beanCandidate : beanCandidates) {
                BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);
                Throwable throwable = null;
                try {
                    this.createAndRegisterSingleton(resolutionContext, beanCandidate, beanCandidate.getBeanType(), beanCandidate.hasAnnotation(Context.class) ? null : beanDefinition.getDeclaredQualifier());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resolutionContext == null) continue;
                    if (throwable != null) {
                        try {
                            resolutionContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resolutionContext.close();
                }
            }
        } else {
            try (BeanResolutionContext resolutionContext = this.newResolutionContext(beanDefinition, null);){
                this.createAndRegisterSingletonInternal(resolutionContext, beanDefinition, beanDefinition.asArgument(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBeanInternal(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, boolean throwNoSuchBean) {
        T inFlightBean;
        Class beanClass = beanType.getType();
        if (this.thisInterfaces.contains(beanClass)) {
            return (T)this;
        }
        if (InjectionPoint.class.isAssignableFrom(beanClass)) {
            BeanResolutionContext.Path path;
            BeanResolutionContext.Path path2 = path = resolutionContext != null ? resolutionContext.getPath() : null;
            if (CollectionUtils.isNotEmpty((Collection)path)) {
                Iterator i = path.iterator();
                BeanResolutionContext.Segment injectionPointSegment = (BeanResolutionContext.Segment)i.next();
                if (i.hasNext()) {
                    InjectionPoint ip;
                    BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)i.next();
                    BeanDefinition declaringBean = segment.getDeclaringType();
                    if (declaringBean.hasStereotype(INTRODUCTION_TYPE)) {
                        if (!i.hasNext()) {
                            if (!injectionPointSegment.getArgument().isNullable()) {
                                throw new BeanContextException("Failed to obtain injection point. No valid injection path present in path: " + path);
                            }
                            return null;
                        }
                        segment = (BeanResolutionContext.Segment)i.next();
                    }
                    if (beanClass.isInstance(ip = segment.getInjectionPoint())) {
                        return (T)ip;
                    }
                    if (!injectionPointSegment.getArgument().isNullable()) {
                        throw new DependencyInjectionException(resolutionContext, "Failed to obtain injection point. No valid injection path present in path: " + path);
                    }
                    return null;
                }
                if (!injectionPointSegment.getArgument().isNullable()) {
                    throw new DependencyInjectionException(resolutionContext, "Failed to obtain injection point. No valid injection path present in path: " + path);
                }
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, "Failed to obtain injection point. No valid injection path present in path: " + path);
        }
        BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing bean for key: {}", beanKey);
        }
        T t = inFlightBean = resolutionContext != null ? (T)resolutionContext.getInFlightBean(beanKey) : null;
        if (inFlightBean != null) {
            return inFlightBean;
        }
        BeanRegistration beanRegistration = this.singletonObjects.get(beanKey);
        if (beanRegistration != null) {
            Object bean = beanRegistration.bean;
            if (bean == null && throwNoSuchBean) {
                throw new NoSuchBeanException(beanType, qualifier);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{beanRegistration.bean, beanType, qualifier});
            }
            return bean;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No existing bean found for bean key: {}", beanKey);
        }
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            Optional<BeanDefinition<T>> concreteCandidate = this.findConcreteCandidate(resolutionContext, beanType, qualifier, throwNonUnique);
            T bean = null;
            if (concreteCandidate.isPresent()) {
                BeanRegistration<T> registration;
                BeanDefinition<T> definition = concreteCandidate.get();
                if (definition.isContainerType() && beanClass != definition.getBeanType()) {
                    throw new NonUniqueBeanException(beanClass, Collections.singletonList(definition).iterator());
                }
                if (definition.isSingleton() && (registration = this.findExistingCompatibleSingleton(definition.asArgument(), beanType, qualifier, definition)) != null) {
                    bean = registration.getBean();
                }
                if (bean != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved existing bean [{}] for type [{}] and qualifier [{}]", new Object[]{bean, beanType, qualifier});
                    }
                    return bean;
                }
                bean = this.getBeanForDefinition(resolutionContext, beanType, qualifier, throwNoSuchBean, definition);
                if (bean == null && throwNoSuchBean) {
                    throw new NoSuchBeanException(beanType, qualifier);
                }
                return bean;
            }
            BeanRegistration<T> registration = this.findExistingCompatibleSingleton(beanType, null, qualifier, null);
            if (registration != null) {
                bean = registration.getBean();
            }
            if (bean == null && throwNoSuchBean) {
                throw new NoSuchBeanException(beanType, qualifier);
            }
            return bean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getBeanForDefinition(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, boolean throwNoSuchBean, BeanDefinition<T> definition) {
        Throwable throwable = null;
        try (BeanResolutionContext context = this.newResolutionContext(definition, resolutionContext);){
            T t;
            block23: {
                boolean isNewPath;
                BeanResolutionContext.Path path;
                block21: {
                    T t2;
                    block22: {
                        path = context.getPath();
                        isNewPath = path.isEmpty();
                        if (isNewPath) {
                            path.pushBeanCreate(definition, beanType);
                        }
                        try {
                            if (!definition.isSingleton() || definition.hasStereotype(SCOPED_PROXY_ANN)) break block21;
                            t2 = this.createAndRegisterSingleton(context, definition, beanType.getType(), qualifier);
                            if (!isNewPath) break block22;
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (isNewPath) {
                                    path.pop();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                        }
                        path.pop();
                    }
                    return t2;
                }
                t = this.getScopedBeanForDefinition(context, beanType, qualifier, throwNoSuchBean, definition);
                if (!isNewPath) break block23;
                path.pop();
            }
            return t;
        }
    }

    private <T> T getScopedBeanForDefinition(final @NonNull BeanResolutionContext resolutionContext, final Argument<T> beanType, final Qualifier<T> qualifier, boolean throwNoSuchBean, BeanDefinition<T> definition) {
        String scopeName;
        boolean isProxy = definition.isProxy();
        boolean isScopedProxyDefinition = definition.hasStereotype(SCOPED_PROXY_ANN);
        if (isProxy && isScopedProxyDefinition && qualifier != PROXY_TARGET_QUALIFIER && definition.getDeclaredQualifier() == null) {
            T createBean;
            Qualifier<T> q = qualifier;
            if (q == null) {
                q = definition.getDeclaredQualifier();
            }
            if ((createBean = this.doCreateBean(resolutionContext, definition, q, beanType, false, null)) instanceof Qualified) {
                ((Qualified)createBean).$withBeanQualifier(q);
            }
            if (createBean == null && throwNoSuchBean) {
                throw new NoSuchBeanException(definition.asArgument(), qualifier);
            }
            return createBean;
        }
        BeanResolutionContext.Segment currentSegment = resolutionContext.getPath().currentSegment().orElse(null);
        CustomScope registeredScope = null;
        if (currentSegment != null) {
            Argument argument = currentSegment.getArgument();
            registeredScope = this.customScopeRegistry.findDeclaredScope(argument).orElse(null);
        }
        if (!(registeredScope != null || isScopedProxyDefinition && isProxy)) {
            registeredScope = this.customScopeRegistry.findDeclaredScope(definition).orElse(null);
        }
        if (registeredScope != null) {
            if (isProxy) {
                definition = this.getProxyTargetBeanDefinition(beanType, qualifier);
            }
            final BeanDefinition<T> finalDefinition = definition;
            final BeanKey<T> beanKey = new BeanKey<T>(beanType, qualifier);
            return registeredScope.getOrCreate(new BeanCreationContext<T>(){

                @Override
                @NonNull
                public BeanDefinition<T> definition() {
                    return finalDefinition;
                }

                @Override
                @NonNull
                public BeanIdentifier id() {
                    return beanKey;
                }

                @Override
                @NonNull
                public CreatedBean<T> create() throws BeanCreationException {
                    Object bean = DefaultBeanContext.this.doCreateBean(resolutionContext, finalDefinition, beanType, qualifier, new Object[0]);
                    List<BeanRegistration<?>> dependentBeans = resolutionContext.getAndResetDependentBeans();
                    if (dependentBeans.isEmpty()) {
                        return new BeanDisposingRegistration(beanKey, finalDefinition, bean);
                    }
                    return new BeanDisposingRegistration(beanKey, finalDefinition, bean, dependentBeans);
                }
            });
        }
        T createdBean = this.doCreateBean(resolutionContext, definition, qualifier, beanType, false, null);
        if (createdBean == null && throwNoSuchBean) {
            throw new NoSuchBeanException(definition.getBeanType(), qualifier);
        }
        if (definition instanceof DisposableBeanDefinition && ((scopeName = (String)definition.getScopeName().orElse(null)) == null || scopeName.equals(Prototype.class.getName()))) {
            resolutionContext.addDependentBean(new BeanKey<T>(beanType, qualifier), definition, createdBean);
        }
        return createdBean;
    }

    private <T> Argument<? extends T> resolveProxiedType(Argument<T> beanType, BeanDefinition<T> definition) {
        BeanDefinition delegate;
        if (definition instanceof AdvisedBeanType) {
            Class t = ((AdvisedBeanType)((Object)definition)).getInterceptedType();
            return Argument.of(t, (Argument[])beanType.getTypeParameters());
        }
        if (definition instanceof ProxyBeanDefinition) {
            Class t = ((ProxyBeanDefinition)definition).getTargetType();
            return Argument.of(t, (Argument[])beanType.getTypeParameters());
        }
        if (definition instanceof BeanDefinitionDelegate && (delegate = ((BeanDefinitionDelegate)definition).getDelegate()) instanceof ProxyBeanDefinition) {
            Class t = ((ProxyBeanDefinition)delegate).getTargetType();
            return Argument.of(t, (Argument[])beanType.getTypeParameters());
        }
        return beanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BeanRegistration<T> findExistingCompatibleSingleton(@NonNull Argument<T> beanType, @Nullable Argument<?> requestedType, @Nullable Qualifier<T> qualifier, @Nullable BeanDefinition<T> definition) {
        BeanRegistration bean = null;
        Object resolvedBeanType = requestedType != null ? requestedType : beanType;
        Class beanClass = resolvedBeanType.getType();
        for (Map.Entry<BeanKey, BeanRegistration> entry : this.singletonObjects.entrySet()) {
            Optional candidate;
            BeanKey key = entry.getKey();
            if (qualifier == null || qualifier.equals(key.qualifier)) {
                Set exposedTypes;
                BeanRegistration reg = entry.getValue();
                if (!beanClass.isInstance(reg.bean) || !(exposedTypes = reg.getBeanDefinition().getExposedTypes()).isEmpty() && !exposedTypes.contains(beanClass) || qualifier == null && definition != null && !reg.beanDefinition.equals(definition) || !reg.beanDefinition.isCandidateBean((Argument<?>)resolvedBeanType)) continue;
                Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                synchronized (map) {
                    bean = reg;
                    this.registerSingletonBean(reg.beanDefinition, (Argument<T>)resolvedBeanType, reg.bean, qualifier, true, Collections.emptyList());
                    break;
                }
            }
            if (key.qualifier != null) continue;
            BeanRegistration registration = entry.getValue();
            Object existing = registration.bean;
            if (!beanType.getType().isInstance(registration.bean) || !(candidate = qualifier.qualify(beanClass, Stream.of(registration.beanDefinition))).isPresent()) continue;
            Map<BeanKey, BeanRegistration> map = this.singletonObjects;
            synchronized (map) {
                BeanDefinition beanDefinition = candidate.get();
                Set exposedTypes = beanDefinition.getExposedTypes();
                if (!exposedTypes.isEmpty() && !exposedTypes.contains(beanClass)) {
                    continue;
                }
                if (!beanDefinition.isCandidateBean((Argument<?>)resolvedBeanType)) {
                    continue;
                }
                bean = registration;
                this.registerSingletonBean(beanDefinition, (Argument<T>)resolvedBeanType, bean.getBean(), qualifier, true, Collections.emptyList());
                break;
            }
        }
        return bean;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidate(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique) {
        BeanKey<T> bk = new BeanKey<T>(beanType, qualifier);
        Optional<BeanDefinition<T>> beanDefinition = this.beanConcreteCandidateCache.get(bk);
        if (beanDefinition == null) {
            beanDefinition = this.findConcreteCandidateNoCache(resolutionContext, beanType, qualifier, throwNonUnique, true);
            this.beanConcreteCandidateCache.put(bk, beanDefinition);
        }
        return beanDefinition;
    }

    private <T> Optional<BeanDefinition<T>> findConcreteCandidateNoCache(BeanResolutionContext resolutionContext, Argument<T> beanType, final Qualifier<T> qualifier, boolean throwNonUnique, boolean filterProxied) {
        Predicate predicate = new Predicate<BeanDefinition<T>>(){

            @Override
            public boolean test(BeanDefinition<T> candidate) {
                if (candidate.isAbstract()) {
                    return false;
                }
                if (qualifier != null && candidate instanceof NoInjectionBeanDefinition) {
                    NoInjectionBeanDefinition noInjectionBeanDefinition = (NoInjectionBeanDefinition)candidate;
                    return qualifier.contains(noInjectionBeanDefinition.qualifier);
                }
                return true;
            }
        };
        ArrayList<BeanDefinition<T>> candidates = new ArrayList<BeanDefinition<T>>(this.findBeanCandidates(resolutionContext, beanType, filterProxied, predicate));
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        this.filterProxiedTypes(candidates, filterProxied, false, predicate);
        int size = candidates.size();
        BeanDefinition<T> definition = null;
        if (size > 0) {
            if (qualifier != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Qualifying bean [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                Stream<BeanDefinition> candidateStream = candidates.stream().filter(c -> {
                    if (!c.isAbstract()) {
                        if (c instanceof NoInjectionBeanDefinition) {
                            NoInjectionBeanDefinition noInjectionBeanDefinition = (NoInjectionBeanDefinition)c;
                            return qualifier.contains(noInjectionBeanDefinition.qualifier);
                        }
                        return true;
                    }
                    return false;
                });
                Stream<BeanDefinition> qualified = qualifier.reduce(beanType.getType(), candidateStream);
                List<BeanDefinition<T>> beanDefinitionList = qualified.collect(Collectors.toList());
                if (beanDefinitionList.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No qualifying beans of type [{}] found for qualifier: {} ", (Object)beanType.getName(), qualifier);
                    }
                    return Optional.empty();
                }
                definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, beanDefinitionList);
            } else if (candidates.size() == 1) {
                definition = (BeanDefinition<T>)candidates.iterator().next();
            } else {
                if (candidates.isEmpty()) {
                    throw new NoSuchBeanException(beanType, null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for @Primary for type [{}] from candidates: {} ", (Object)beanType.getName(), candidates);
                }
                definition = this.lastChanceResolve(beanType, qualifier, throwNonUnique, candidates);
            }
        }
        if (LOG.isDebugEnabled() && definition != null) {
            if (qualifier != null) {
                LOG.debug("Found concrete candidate [{}] for type: {} {} ", new Object[]{definition, qualifier, beanType.getName()});
            } else {
                LOG.debug("Found concrete candidate [{}] for type: {} ", (Object)definition, (Object)beanType.getName());
            }
        }
        return Optional.ofNullable(definition);
    }

    private <T> void filterProxiedTypes(Collection<BeanDefinition<T>> candidates, boolean filterProxied, boolean filterDelegates, Predicate<BeanDefinition<T>> predicate) {
        ArrayList delegates;
        int count = candidates.size();
        HashSet proxiedTypes = new HashSet(count);
        Iterator<BeanDefinition<T>> i = candidates.iterator();
        ArrayList arrayList = delegates = filterDelegates ? new ArrayList(count) : Collections.emptyList();
        while (i.hasNext()) {
            BeanDefinition<T> candidate2 = i.next();
            if (candidate2 instanceof ProxyBeanDefinition) {
                if (filterProxied) {
                    proxiedTypes.add(((ProxyBeanDefinition)candidate2).getTargetDefinitionType());
                    continue;
                }
                proxiedTypes.add(candidate2.getClass());
                continue;
            }
            if (!(candidate2 instanceof BeanDefinitionDelegate)) continue;
            BeanDefinition delegate = ((BeanDefinitionDelegate)candidate2).getDelegate();
            if (filterDelegates) {
                i.remove();
                if (delegates.contains(delegate) || predicate != null && !predicate.test(delegate)) continue;
                delegates.add(delegate);
                continue;
            }
            if (!filterProxied || !(delegate instanceof ProxyBeanDefinition)) continue;
            proxiedTypes.add(((ProxyBeanDefinition)delegate).getTargetDefinitionType());
        }
        if (filterDelegates) {
            candidates.addAll(delegates);
        }
        if (!proxiedTypes.isEmpty()) {
            candidates.removeIf(candidate -> {
                if (candidate instanceof BeanDefinitionDelegate) {
                    return proxiedTypes.contains(((BeanDefinitionDelegate)candidate).getDelegate().getClass());
                }
                return proxiedTypes.contains(candidate.getClass());
            });
        }
    }

    private <T> BeanDefinition<T> lastChanceResolve(Argument<T> beanType, Qualifier<T> qualifier, boolean throwNonUnique, Collection<BeanDefinition<T>> candidates) {
        List primary;
        Class beanClass = beanType.getType();
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).collect(Collectors.toList())).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        BeanDefinition<T> definition = null;
        if ((candidates = (Collection)candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype(Secondary.class)).collect(Collectors.toList())).size() == 1) {
            return (BeanDefinition)candidates.iterator().next();
        }
        if (candidates.stream().anyMatch(candidate -> candidate.hasAnnotation(Order.class))) {
            Iterator i = candidates.stream().sorted((bean1, bean2) -> {
                int order1 = OrderUtil.getOrder((AnnotationMetadata)bean1.getAnnotationMetadata());
                int order2 = OrderUtil.getOrder((AnnotationMetadata)bean2.getAnnotationMetadata());
                return Integer.compare(order1, order2);
            }).iterator();
            if (i.hasNext()) {
                BeanDefinition bean = (BeanDefinition)i.next();
                if (i.hasNext()) {
                    BeanDefinition next = (BeanDefinition)i.next();
                    if (OrderUtil.getOrder((AnnotationMetadata)bean.getAnnotationMetadata()) == OrderUtil.getOrder((AnnotationMetadata)next.getAnnotationMetadata())) {
                        throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
                    }
                }
                LOG.debug("Picked bean {} with the highest precedence for type {} and qualifier {}", new Object[]{bean, beanType, qualifier});
                return bean;
            }
            throw new NonUniqueBeanException(beanType.getType(), candidates.iterator());
        }
        Collection<BeanDefinition<T>> exactMatches = this.filterExactMatch(beanClass, candidates);
        if (exactMatches.size() == 1) {
            definition = exactMatches.iterator().next();
        } else if (throwNonUnique) {
            definition = this.findConcreteCandidate(beanClass, qualifier, candidates);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createAndRegisterSingleton(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Class<T> beanType, Qualifier<T> qualifier) {
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            return this.createAndRegisterSingletonInternal(resolutionContext, definition, Argument.of(beanType), qualifier);
        }
    }

    private <T> T createAndRegisterSingletonInternal(BeanResolutionContext resolutionContext, BeanDefinition<T> definition, Argument<T> beanType, Qualifier<T> qualifier) {
        if (definition instanceof NoInjectionBeanDefinition) {
            NoInjectionBeanDefinition manuallyRegistered = (NoInjectionBeanDefinition)definition;
            BeanRegistration reg = this.singletonObjects.get(new BeanKey(manuallyRegistered.getBeanType(), manuallyRegistered.getQualifier(), new Class[0]));
            if (reg == null) {
                throw new IllegalStateException("Manually registered singleton no longer present in bean context");
            }
            this.registerSingletonBean(definition, beanType, reg.bean, qualifier, true, Collections.emptyList());
            return reg.bean;
        }
        T createdBean = this.doCreateBean(resolutionContext, definition, qualifier, beanType, true, null);
        this.registerSingletonBean(definition, beanType, createdBean, qualifier, true, resolutionContext.getAndResetDependentBeans());
        return createdBean;
    }

    private void readAllBeanConfigurations() {
        Iterable<BeanConfiguration> beanConfigurations = this.resolveBeanConfigurations();
        for (BeanConfiguration beanConfiguration : beanConfigurations) {
            this.registerConfiguration(beanConfiguration);
        }
    }

    private <T> Collection<BeanDefinition<T>> filterExactMatch(Class<T> beanType, Collection<BeanDefinition<T>> candidates) {
        Stream<BeanDefinition> filteredResults = candidates.stream().filter(candidate -> candidate.getBeanType() == beanType);
        return filteredResults.collect(Collectors.toList());
    }

    private <T> void registerSingletonBean(BeanDefinition<T> beanDefinition, Argument<T> beanType, T createdBean, Qualifier<T> qualifier, boolean singleCandidate, List<BeanRegistration<?>> dependents) {
        Set exposedTypes;
        boolean hasNoExposedTypes;
        if (qualifier == null) {
            qualifier = beanDefinition.getDeclaredQualifier();
        }
        if (hasNoExposedTypes = CollectionUtils.isEmpty((Collection)(exposedTypes = beanDefinition.getExposedTypes()))) {
            boolean isNotProxyTarget;
            BeanKey<T> key = new BeanKey<T>(beanDefinition, qualifier);
            if (LOG.isDebugEnabled()) {
                if (qualifier != null) {
                    LOG.debug("Registering singleton bean {} for type [{} {}] using bean key {}", new Object[]{createdBean, qualifier, beanType.getName(), key});
                } else {
                    LOG.debug("Registering singleton bean {} for type [{}] using bean key {}", new Object[]{createdBean, beanType.getName(), key});
                }
            }
            BeanDisposingRegistration<T> registration = dependents.isEmpty() ? new BeanDisposingRegistration<T>(key, beanDefinition, createdBean) : new BeanDisposingRegistration<T>(key, beanDefinition, createdBean, dependents);
            if (singleCandidate || ((BeanKey)key).beanType.getTypeParameters().length > 0) {
                this.singletonObjects.put(key, registration);
            }
            Class<?> beanClass = beanType.getType();
            boolean bl = isNotProxyTarget = qualifier != PROXY_TARGET_QUALIFIER;
            if (isNotProxyTarget) {
                Class<?> createdType = createdBean != null ? createdBean.getClass() : beanClass;
                boolean createdTypeDiffers = !createdType.equals(beanClass);
                BeanKey createdBeanKey = new BeanKey(createdType, qualifier, new Class[0]);
                Qualifier<T> declaredQualifier = beanDefinition.getDeclaredQualifier();
                if (declaredQualifier != null) {
                    BeanKey qualifierKey = new BeanKey(createdType, declaredQualifier, new Class[0]);
                    if (!qualifierKey.equals(createdBeanKey)) {
                        this.singletonObjects.put(qualifierKey, registration);
                    }
                } else if (!beanDefinition.isIterable()) {
                    BeanKey primaryBeanKey = new BeanKey(createdType, null, new Class[0]);
                    this.singletonObjects.put(primaryBeanKey, registration);
                    if (qualifier != null) {
                        BeanKey<T> qualifiedKey = new BeanKey<T>(beanType, qualifier);
                        this.singletonObjects.put(qualifiedKey, registration);
                    }
                } else if (beanDefinition.isPrimary()) {
                    BeanKey<T> primaryBeanKey = new BeanKey<T>(beanType, null);
                    this.singletonObjects.put(primaryBeanKey, registration);
                    if (createdTypeDiffers) {
                        this.singletonObjects.put(new BeanKey(createdType, null, new Class[0]), registration);
                    }
                }
                this.singletonObjects.put(createdBeanKey, registration);
            }
        } else {
            for (Class exposedType : exposedTypes) {
                BeanKey<T> key = new BeanKey<T>(exposedType, qualifier, new Class[0]);
                if (LOG.isDebugEnabled()) {
                    if (qualifier != null) {
                        LOG.debug("Registering singleton bean {} for type [{} {}] using bean key {}", new Object[]{createdBean, qualifier, exposedType.getName(), key});
                    } else {
                        LOG.debug("Registering singleton bean {} for type [{}] using bean key {}", new Object[]{createdBean, exposedType.getName(), key});
                    }
                }
                BeanDisposingRegistration<T> registration = new BeanDisposingRegistration<T>(key, beanDefinition, createdBean, dependents);
                this.singletonObjects.put(key, registration);
                if (qualifier == null || !beanDefinition.isPrimary()) continue;
                BeanKey primaryKey = new BeanKey(exposedType, null, new Class[0]);
                this.singletonObjects.put(primaryKey, registration);
            }
        }
    }

    private void readAllBeanDefinitionClasses() {
        ArrayList<BeanDefinitionReference> contextScopeBeans = new ArrayList<BeanDefinitionReference>(20);
        ArrayList<BeanDefinitionReference> processedBeans = new ArrayList<BeanDefinitionReference>(10);
        ArrayList<BeanDefinitionReference> parallelBeans = new ArrayList<BeanDefinitionReference>(10);
        List<BeanDefinitionReference> beanDefinitionReferences = this.resolveBeanDefinitionReferences();
        this.beanDefinitionsClasses.addAll(beanDefinitionReferences);
        HashSet<BeanConfiguration> configurationsDisabled = new HashSet<BeanConfiguration>();
        for (BeanConfiguration bc : this.beanConfigurations.values()) {
            if (bc.isEnabled(this)) continue;
            configurationsDisabled.add(bc);
        }
        block1: for (BeanDefinitionReference beanDefinitionReference : beanDefinitionReferences) {
            Class aClass;
            for (BeanConfiguration disableConfiguration : configurationsDisabled) {
                if (!disableConfiguration.isWithin(beanDefinitionReference)) continue;
                this.beanDefinitionsClasses.remove(beanDefinitionReference);
                continue block1;
            }
            AnnotationMetadata annotationMetadata = beanDefinitionReference.getAnnotationMetadata();
            Class[] indexes = annotationMetadata.classValues(INDEXES_TYPE);
            if (indexes.length > 0) {
                for (int i = 0; i < indexes.length; ++i) {
                    Class indexedType = indexes[i];
                    this.resolveTypeIndex(indexedType).add(beanDefinitionReference);
                }
            } else if (annotationMetadata.hasStereotype(ADAPTER_TYPE) && this.indexedTypes.contains(aClass = (Class)annotationMetadata.classValue(ADAPTER_TYPE, "value").orElse(null))) {
                this.resolveTypeIndex(aClass).add(beanDefinitionReference);
            }
            if (this.isEagerInit(beanDefinitionReference)) {
                contextScopeBeans.add(beanDefinitionReference);
            } else if (annotationMetadata.hasDeclaredStereotype(PARALLEL_TYPE)) {
                parallelBeans.add(beanDefinitionReference);
            }
            if (!beanDefinitionReference.requiresMethodProcessing()) continue;
            processedBeans.add(beanDefinitionReference);
        }
        beanDefinitionReferences = null;
        this.beanConfigurationsList = null;
        this.initializeEventListeners();
        this.initializeContext(contextScopeBeans, processedBeans, parallelBeans);
    }

    private boolean isEagerInit(BeanDefinitionReference beanDefinitionReference) {
        return beanDefinitionReference.isContextScope() || this.eagerInitSingletons && beanDefinitionReference.isSingleton() || this.eagerInitStereotypesPresent && beanDefinitionReference.getAnnotationMetadata().hasDeclaredStereotype(this.eagerInitStereotypes);
    }

    @NonNull
    private Collection<BeanDefinitionReference> resolveTypeIndex(Class<?> indexedType) {
        return this.beanIndex.computeIfAbsent(indexedType, aClass -> {
            this.indexedTypes.add(indexedType);
            return new ArrayList(20);
        });
    }

    private <T> Collection<BeanDefinition<T>> findBeanCandidatesInternal(BeanResolutionContext resolutionContext, Argument<T> beanType) {
        Collection<BeanDefinition<T>> beanDefinitions = this.beanCandidateCache.get(beanType);
        if (beanDefinitions == null) {
            beanDefinitions = this.findBeanCandidates(resolutionContext, beanType, true, null);
            this.beanCandidateCache.put(beanType, beanDefinitions);
        }
        return beanDefinitions;
    }

    protected <T> BeanRegistration<T> getBeanRegistration(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        BeanDefinition<T> beanDefinition = this.getBeanDefinition(beanType, qualifier);
        T bean = this.getBeanInternal(resolutionContext, beanType, qualifier, true, true);
        return new BeanRegistration<T>(new BeanKey<T>(beanDefinition, qualifier), beanDefinition, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@Nullable BeanResolutionContext resolutionContext, @NonNull Argument<T> beanType, @Nullable Qualifier<T> qualifier) {
        Collection existing;
        boolean hasQualifier;
        boolean bl = hasQualifier = qualifier != null;
        if (LOG.isDebugEnabled()) {
            if (hasQualifier) {
                LOG.debug("Resolving beans for type: {} {} ", qualifier, (Object)beanType.getTypeName());
            } else {
                LOG.debug("Resolving beans for type: {}", (Object)beanType.getTypeName());
            }
        }
        Class beanClass = beanType.getType();
        BeanKey<T> key = new BeanKey<T>(beanType, qualifier);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Looking up existing beans for key: {}", key);
        }
        if ((existing = this.initializedObjectsByType.get(key)) != null) {
            this.logResolvedExisting(beanType, qualifier, hasQualifier, existing);
            return existing;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No beans found for key: {}", key);
        }
        Map<BeanKey, BeanRegistration> map = this.singletonObjects;
        synchronized (map) {
            Set beanRegistrations;
            boolean hasCandidates;
            existing = this.initializedObjectsByType.get(key);
            if (existing != null) {
                this.logResolvedExisting(beanType, qualifier, hasQualifier, existing);
                return existing;
            }
            boolean allCandidatesAreSingleton = true;
            boolean hasOrderAnnotation = false;
            Collection<BeanDefinition<T>> candidates = this.findBeanCandidatesInternal(resolutionContext, beanType);
            this.filterProxiedTypes(candidates, true, false, null);
            boolean bl2 = hasCandidates = !candidates.isEmpty();
            if (hasQualifier && hasCandidates) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Qualifying bean [{}] from candidates {} for qualifier: {} ", new Object[]{beanType.getName(), candidates, qualifier});
                }
                Stream<BeanDefinition<T>> candidateStream = candidates.stream();
                List reduced = qualifier.reduce(beanClass, candidateStream = this.applyBeanResolutionFilters(resolutionContext, candidateStream)).collect(Collectors.toList());
                if (!reduced.isEmpty()) {
                    HashSet<BeanRegistration<T>> beansOfTypeList = new HashSet<BeanRegistration<T>>(reduced.size());
                    for (BeanDefinition definition : reduced) {
                        if (!definition.isSingleton()) {
                            allCandidatesAreSingleton = false;
                        }
                        if (definition.hasAnnotation(Order.class)) {
                            hasOrderAnnotation = true;
                        }
                        this.addCandidateToList(resolutionContext, beanType, definition, beansOfTypeList, qualifier, reduced.size() == 1);
                    }
                    beanRegistrations = beansOfTypeList;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found no matching beans of type [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                    }
                    beanRegistrations = Collections.emptySet();
                }
            } else if (hasCandidates) {
                int candidateCount = candidates.size();
                Stream candidateStream = candidates.stream();
                candidateStream = this.applyBeanResolutionFilters(resolutionContext, candidateStream);
                List candidateList = candidateStream.collect(Collectors.toList());
                HashSet<BeanRegistration<T>> beansOfTypeList = new HashSet<BeanRegistration<T>>(candidateCount);
                for (BeanDefinition candidate : candidateList) {
                    if (!candidate.isSingleton()) {
                        allCandidatesAreSingleton = false;
                    }
                    if (candidate.hasAnnotation(Order.class)) {
                        hasOrderAnnotation = true;
                    }
                    this.addCandidateToList(resolutionContext, beanType, candidate, beansOfTypeList, qualifier, candidateCount == 1);
                }
                beanRegistrations = beansOfTypeList;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found no possible candidate beans of type [{}] for qualifier: {} ", (Object)beanType.getName(), qualifier);
                }
                beanRegistrations = Collections.emptySet();
            }
            Collection<BeanRegistration<Object>> beans = Collections.emptyList();
            if (beanRegistrations != Collections.EMPTY_SET) {
                Stream<Object> stream = beanRegistrations.stream();
                if (Ordered.class.isAssignableFrom(beanClass)) {
                    beans = (Collection)stream.sorted(OrderUtil.COMPARATOR).collect(StreamUtils.toImmutableCollection());
                } else {
                    if (hasOrderAnnotation) {
                        stream = stream.sorted(BEAN_REGISTRATION_COMPARATOR);
                    }
                    beans = (Collection)stream.collect(StreamUtils.toImmutableCollection());
                }
            }
            if (allCandidatesAreSingleton) {
                this.initializedObjectsByType.put(key, beans);
            }
            if (LOG.isDebugEnabled() && !beans.isEmpty()) {
                if (hasQualifier) {
                    LOG.debug("Found {} beans for type [{} {}]: {} ", new Object[]{beanRegistrations.size(), qualifier, beanType.getName(), beanRegistrations});
                } else {
                    LOG.debug("Found {} beans for type [{}]: {} ", new Object[]{beanRegistrations.size(), beanType.getName(), beanRegistrations});
                }
            }
            return beans;
        }
    }

    private <T> void logResolvedExisting(Argument<T> beanType, Qualifier<T> qualifier, boolean hasQualifier, Collection<BeanRegistration<T>> existing) {
        if (LOG.isTraceEnabled()) {
            if (hasQualifier) {
                LOG.trace("Found {} existing beans for type [{} {}]: {} ", new Object[]{existing.size(), qualifier, beanType.getName(), existing});
            } else {
                LOG.trace("Found {} existing beans for type [{}]: {} ", new Object[]{existing.size(), beanType.getName(), existing});
            }
        }
    }

    private <T> Stream<BeanDefinition<T>> applyBeanResolutionFilters(@Nullable BeanResolutionContext resolutionContext, Stream<BeanDefinition<T>> candidateStream) {
        BeanResolutionContext.Segment segment;
        candidateStream = candidateStream.filter(c -> !c.isAbstract());
        BeanResolutionContext.Segment segment2 = segment = resolutionContext != null ? (BeanResolutionContext.Segment)resolutionContext.getPath().peek() : null;
        if (segment instanceof AbstractBeanResolutionContext.ConstructorSegment || segment instanceof AbstractBeanResolutionContext.MethodSegment) {
            BeanDefinition declaringBean = segment.getDeclaringType();
            candidateStream = candidateStream.filter(c -> {
                if (c.equals(declaringBean)) {
                    return false;
                }
                if (declaringBean instanceof ProxyBeanDefinition) {
                    return !((ProxyBeanDefinition)declaringBean).getTargetDefinitionType().equals(c.getClass());
                }
                return true;
            });
        }
        return candidateStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void addCandidateToList(@Nullable BeanResolutionContext resolutionContext, Argument<T> beanType, BeanDefinition<T> candidate, Collection<BeanRegistration<T>> beansOfTypeList, Qualifier<T> qualifier, boolean singleCandidate) {
        boolean isContainerType;
        T bean;
        block38: {
            bean = null;
            isContainerType = candidate.isContainerType();
            try {
                Object context;
                if (candidate.isSingleton()) {
                    Map<BeanKey, BeanRegistration> map = this.singletonObjects;
                    synchronized (map) {
                        context = this.newResolutionContext(candidate, resolutionContext);
                        Object object = null;
                        try {
                            if (candidate instanceof NoInjectionBeanDefinition) {
                                NoInjectionBeanDefinition noibd = (NoInjectionBeanDefinition)candidate;
                                BeanKey key = new BeanKey(noibd.singletonClass, noibd.qualifier, new Class[0]);
                                BeanRegistration beanRegistration = this.singletonObjects.get(key);
                                if (beanRegistration == null) throw new IllegalStateException("Singleton not present for key: " + key);
                                bean = beanRegistration.bean;
                            } else {
                                bean = this.doCreateBean((BeanResolutionContext)context, candidate, qualifier, beanType, true, null);
                                if (candidate.getBeanType() != beanType.getType() && isContainerType) {
                                    this.registerSingletonBean(candidate, candidate.asArgument(), bean, qualifier, singleCandidate, context.getAndResetDependentBeans());
                                } else {
                                    this.registerSingletonBean(candidate, beanType, bean, qualifier, singleCandidate, context.getAndResetDependentBeans());
                                }
                            }
                        }
                        catch (Throwable noibd) {
                            object = noibd;
                            throw noibd;
                        }
                        finally {
                            if (context != null) {
                                if (object != null) {
                                    try {
                                        context.close();
                                    }
                                    catch (Throwable noibd) {
                                        ((Throwable)object).addSuppressed(noibd);
                                    }
                                } else {
                                    context.close();
                                }
                            }
                        }
                        break block38;
                    }
                }
                BeanResolutionContext context2 = this.newResolutionContext(candidate, resolutionContext);
                context = null;
                try {
                    bean = this.getScopedBeanForDefinition(context2, candidate.asArgument(), qualifier, true, candidate);
                }
                catch (Throwable throwable) {
                    context = throwable;
                    throw throwable;
                }
                finally {
                    if (context2 != null) {
                        if (context != null) {
                            try {
                                context2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)context).addSuppressed(throwable);
                            }
                        } else {
                            context2.close();
                        }
                    }
                }
            }
            catch (DisabledBeanException e) {
                if (!AbstractBeanContextConditional.LOG.isDebugEnabled()) break block38;
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)beanType.getTypeName(), (Object)e.getMessage());
            }
        }
        if (bean == null) return;
        if (isContainerType && bean instanceof Iterable) {
            Iterable iterable = (Iterable)bean;
            int i = 0;
            for (Object o : iterable) {
                if (o == null || !beanType.isInstance(o)) continue;
                beansOfTypeList.add(new BeanRegistration<T>(new BeanKey<T>(beanType, Qualifiers.byQualifiers(Qualifiers.byName(String.valueOf(i++)), qualifier)), candidate, o));
            }
            return;
        } else {
            beansOfTypeList.add(new BeanRegistration<Object>(null, (BeanDefinition<Object>)candidate, bean));
        }
    }

    private <T> boolean isCandidatePresent(Argument<T> beanType, Qualifier<T> qualifier) {
        Collection<BeanDefinition<T>> candidates = this.findBeanCandidates(null, beanType, true, null);
        if (!candidates.isEmpty()) {
            this.filterReplacedBeans(null, candidates);
            Stream<BeanDefinition<T>> stream = candidates.stream();
            if (qualifier != null && !(qualifier instanceof AnyQualifier)) {
                stream = qualifier.reduce(beanType.getType(), stream);
            }
            return stream.count() > 0L;
        }
        return false;
    }

    private static <T> List<T> nullSafe(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private List<BeanRegistration> topologicalSort(Collection<BeanRegistration> beans) {
        Map<Boolean, List<BeanRegistration>> initial = beans.stream().sorted(Comparator.comparing(s -> s.getBeanDefinition().getRequiredComponents().size())).collect(Collectors.groupingBy(b -> b.getBeanDefinition().getRequiredComponents().isEmpty()));
        ArrayList<BeanRegistration> sorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(true)));
        ArrayList<BeanRegistration> unsorted = new ArrayList<BeanRegistration>(DefaultBeanContext.nullSafe(initial.get(false)));
        HashSet satisfied = new HashSet();
        HashSet unsatisfied = new HashSet();
        while (!unsorted.isEmpty()) {
            boolean acyclic = false;
            unsatisfied.clear();
            Iterator i = unsorted.iterator();
            while (i.hasNext()) {
                BeanRegistration bean = (BeanRegistration)i.next();
                boolean found = false;
                Collection<Class<?>> components = bean.getBeanDefinition().getRequiredComponents();
                for (Class<?> clazz : components) {
                    block6: {
                        block5: {
                            if (satisfied.contains(clazz)) continue;
                            if (unsatisfied.contains(clazz)) break block5;
                            if (!unsorted.stream().map(BeanRegistration::getBeanDefinition).map(BeanDefinition::getBeanType).anyMatch(clazz::isAssignableFrom)) break block6;
                        }
                        found = true;
                        unsatisfied.add(clazz);
                        break;
                    }
                    satisfied.add(clazz);
                }
                if (found) continue;
                acyclic = true;
                i.remove();
                sorted.add(0, bean);
            }
            if (acyclic) continue;
            sorted.add(0, (BeanRegistration)unsorted.remove(0));
        }
        return sorted;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return MutableConvertibleValues.of(this.attributes);
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        if (name != null) {
            return Optional.ofNullable(this.attributes.get(name));
        }
        return Optional.empty();
    }

    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        if (name != null) {
            Object o = this.attributes.get(name);
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            if (o != null) {
                return ConversionService.SHARED.convert(o, type);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public BeanContext setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (name != null) {
            if (value != null) {
                this.attributes.put(name, value);
            } else {
                this.attributes.remove(name);
            }
        }
        return this;
    }

    @NonNull
    public <T> Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        Object o = this.attributes.remove(name);
        if (type.isInstance(o)) {
            return Optional.of(o);
        }
        return Optional.empty();
    }

    @Override
    public void finalizeConfiguration() {
        this.readAllBeanConfigurations();
        this.readAllBeanDefinitionClasses();
    }

    private static /* synthetic */ BeanInstantiationException lambda$doCreateBean$38(BeanResolutionContext resolutionContext, Argument requiredArgument, Object val) {
        return new BeanInstantiationException(resolutionContext, "Invalid bean argument [" + requiredArgument + "]. Cannot convert object [" + val + "] to required type: " + requiredArgument.getType());
    }

    private class SingletonBeanResolutionContext
    extends AbstractBeanResolutionContext {
        public SingletonBeanResolutionContext(BeanDefinition<?> beanDefinition) {
            super(DefaultBeanContext.this, beanDefinition);
        }

        @Override
        public BeanResolutionContext copy() {
            SingletonBeanResolutionContext copy = new SingletonBeanResolutionContext(this.rootDefinition);
            copy.copyStateFrom(this);
            return copy;
        }

        @Override
        public <T> void addInFlightBean(BeanIdentifier beanIdentifier, T instance) {
            DefaultBeanContext.this.singlesInCreation.put(beanIdentifier, instance);
        }

        @Override
        public void removeInFlightBean(BeanIdentifier beanIdentifier) {
            DefaultBeanContext.this.singlesInCreation.remove(beanIdentifier);
        }

        @Override
        @Nullable
        public <T> T getInFlightBean(BeanIdentifier beanIdentifier) {
            return (T)DefaultBeanContext.this.singlesInCreation.get(beanIdentifier);
        }
    }

    private final class BeanDisposingRegistration<BT>
    extends BeanRegistration<BT> {
        private final List<BeanRegistration<?>> dependents;
        private final boolean hasDependents;

        BeanDisposingRegistration(BeanKey<BT> key, BeanDefinition<BT> beanDefinition, BT createdBean, List<BeanRegistration<?>> dependents) {
            super(key, beanDefinition, createdBean);
            this.dependents = dependents;
            this.hasDependents = true;
        }

        BeanDisposingRegistration(BeanKey<BT> key, BeanDefinition<BT> beanDefinition, BT createdBean) {
            super(key, beanDefinition, createdBean);
            this.hasDependents = false;
            this.dependents = null;
        }

        @Override
        public void close() {
            BeanDefinition definition = this.definition();
            Object beanToDestroy = this.getBean();
            if (definition instanceof DisposableBeanDefinition) {
                ((DisposableBeanDefinition)definition).dispose(DefaultBeanContext.this, beanToDestroy);
            }
            if (beanToDestroy instanceof LifeCycle) {
                try {
                    ((LifeCycle)beanToDestroy).stop();
                }
                catch (Exception e) {
                    throw new BeanDestructionException(definition, (Throwable)e);
                }
            }
            if (this.hasDependents) {
                ListIterator<BeanRegistration<?>> i = this.dependents.listIterator(this.dependents.size());
                while (i.hasPrevious()) {
                    BeanRegistration<?> dependent = i.previous();
                    Object bean = dependent.getBean();
                    BeanDefinition<?> beanDefinition = dependent.getBeanDefinition();
                    if (!(beanDefinition instanceof DisposableBeanDefinition)) continue;
                    try {
                        ((DisposableBeanDefinition)beanDefinition).dispose(DefaultBeanContext.this, bean);
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error("Error disposing dependent bean of type " + beanDefinition.getBeanType().getName() + ": " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private static final class NoInjectionBeanDefinition<T>
    implements BeanDefinition<T>,
    BeanDefinitionReference<T> {
        private final Class<?> singletonClass;
        private final Map<Class<?>, List<Argument<?>>> typeArguments = new HashMap();
        private final Qualifier<T> qualifier;

        NoInjectionBeanDefinition(Class singletonClass, Qualifier<T> qualifier) {
            this.singletonClass = singletonClass;
            this.qualifier = qualifier;
        }

        @Nullable
        public Qualifier<T> getQualifier() {
            return this.qualifier;
        }

        @Override
        public Optional<Class<? extends Annotation>> getScope() {
            return Optional.of(javax.inject.Singleton.class);
        }

        @Override
        public Optional<String> getScopeName() {
            return Optional.of("javax.inject.Singleton");
        }

        @Override
        @NonNull
        public List<Argument<?>> getTypeArguments(Class<?> type) {
            List<Object> result = this.typeArguments.get(type);
            if (result == null) {
                Class[] classes = type.isInterface() ? GenericTypeUtils.resolveInterfaceTypeArguments(this.singletonClass, type) : GenericTypeUtils.resolveSuperTypeGenericArguments(this.singletonClass, type);
                result = Arrays.stream(classes).map(Argument::of).collect(Collectors.toList());
                this.typeArguments.put(type, result);
            }
            return result;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public boolean isProvided() {
            return false;
        }

        @Override
        public boolean isIterable() {
            return false;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }

        @Override
        public Class getBeanType() {
            return this.singletonClass;
        }

        @Override
        public Optional<Class<?>> getDeclaringType() {
            return Optional.empty();
        }

        @Override
        public ConstructorInjectionPoint getConstructor() {
            throw new UnsupportedOperationException("Bean of type [" + this.getBeanType() + "] is a manually registered singleton that was registered with the context via BeanContext.registerBean(..) and cannot be created directly");
        }

        @Override
        public Collection<Class<?>> getRequiredComponents() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint<T, ?>> getInjectedMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<FieldInjectionPoint<T, ?>> getInjectedFields() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint<T, ?>> getPostConstructMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MethodInjectionPoint<T, ?>> getPreDestroyMethods() {
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public String getName() {
            return this.singletonClass.getName();
        }

        @Override
        public boolean isEnabled(BeanContext beanContext) {
            return true;
        }

        @Override
        public boolean isEnabled(@NonNull BeanContext context, @Nullable BeanResolutionContext resolutionContext) {
            return true;
        }

        @Override
        public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class<?>[] argumentTypes) {
            return Optional.empty();
        }

        @Override
        public T inject(BeanContext context, T bean) {
            return bean;
        }

        @Override
        public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            return bean;
        }

        @Override
        public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
            return Collections.emptyList();
        }

        @Override
        public Stream<ExecutableMethod<T, ?>> findPossibleMethods(String name) {
            return Stream.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoInjectionBeanDefinition that = (NoInjectionBeanDefinition)o;
            return this.singletonClass.equals(that.singletonClass);
        }

        public int hashCode() {
            return this.singletonClass.hashCode();
        }

        @Override
        public String getBeanDefinitionName() {
            return this.singletonClass.getName();
        }

        @Override
        public BeanDefinition<T> load() {
            return this;
        }

        @Override
        public BeanDefinition<T> load(BeanContext context) {
            return this;
        }

        @Override
        public boolean isContextScope() {
            return false;
        }

        @Override
        public boolean isPresent() {
            return true;
        }
    }

    static final class BeanKey<T>
    implements BeanIdentifier {
        private final Argument<T> beanType;
        private final Qualifier<T> qualifier;
        private final int hashCode;

        BeanKey(BeanDefinition<T> definition, Qualifier<T> qualifier) {
            this(definition.asArgument(), qualifier);
        }

        BeanKey(Argument<T> argument, Qualifier<T> qualifier) {
            this.beanType = argument;
            this.qualifier = qualifier;
            this.hashCode = argument.typeHashCode();
        }

        BeanKey(Class<T> beanType, Qualifier<T> qualifier, Class ... typeArguments) {
            this(Argument.of(beanType, (Class[])typeArguments), qualifier);
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return (this.qualifier != null ? this.qualifier + " " : "") + this.beanType.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return this.beanType.equalsType(beanKey.beanType) && Objects.equals(this.qualifier, beanKey.qualifier);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getName() {
            if (this.qualifier instanceof Named) {
                return ((Named)this.qualifier).getName();
            }
            return Primary.SIMPLE_NAME;
        }
    }

    private static final class BeanExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final BeanContext beanContext;
        private final Class<T> beanType;
        private final Qualifier<T> qualifier;
        private final boolean isSingleton;
        private T target;

        BeanExecutionHandle(BeanContext beanContext, Class<T> beanType, Qualifier<T> qualifier, ExecutableMethod<T, R> method) {
            super(method);
            this.beanContext = beanContext;
            this.beanType = beanType;
            this.qualifier = qualifier;
            this.isSingleton = beanContext.findBeanDefinition(beanType, qualifier).map(BeanDefinition::isSingleton).orElse(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getTarget() {
            T target = this.target;
            if (target == null) {
                BeanExecutionHandle beanExecutionHandle = this;
                synchronized (beanExecutionHandle) {
                    target = this.target;
                    if (target == null) {
                        this.target = target = this.beanContext.getBean(this.beanType, this.qualifier);
                    }
                }
            }
            return target;
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.beanType;
        }

        @Override
        public R invoke(Object ... arguments) {
            if (this.isSingleton) {
                T target = this.getTarget();
                return (R)this.method.invoke(target, arguments);
            }
            return (R)this.method.invoke(this.beanContext.getBean(this.beanType, this.qualifier), arguments);
        }
    }

    private static final class ObjectExecutionHandle<T, R>
    extends AbstractExecutionHandle<T, R> {
        private final T target;

        ObjectExecutionHandle(T target, ExecutableMethod<T, R> method) {
            super(method);
            this.target = target;
        }

        @Override
        public T getTarget() {
            return this.target;
        }

        @Override
        public R invoke(Object ... arguments) {
            return (R)this.method.invoke(this.target, arguments);
        }

        @Override
        public Method getTargetMethod() {
            return this.method.getTargetMethod();
        }

        @Override
        public Class getDeclaringType() {
            return this.target.getClass();
        }
    }

    private static abstract class AbstractExecutionHandle<T, R>
    implements MethodExecutionHandle<T, R> {
        protected final ExecutableMethod<T, R> method;

        AbstractExecutionHandle(ExecutableMethod<T, R> method) {
            this.method = method;
        }

        @Override
        @NonNull
        public ExecutableMethod<?, R> getExecutableMethod() {
            return this.method;
        }

        @Override
        public Argument[] getArguments() {
            return this.method.getArguments();
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public String getMethodName() {
            return this.method.getMethodName();
        }

        @Override
        public ReturnType<R> getReturnType() {
            return this.method.getReturnType();
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.method.getAnnotationMetadata();
        }
    }
}

