/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.javafx.filterpanel.FilmLenghtSliderNode;
import mediathek.javafx.filterpanel.SenderBoxNode;
import mediathek.javafx.filterpanel.ThemaComboBox;
import mediathek.javafx.filterpanel.ZeitraumSpinner;
import mediathek.tool.FilterDTO;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonViewSettingsPane
extends VBox
implements Initializable {
    private static final Logger logger = LogManager.getLogger(CommonViewSettingsPane.class);
    @FXML
    public Button btnDeleteFilterSettings;
    @FXML
    public CheckBox cbShowOnlyHd;
    @FXML
    public CheckBox cbShowSubtitlesOnly;
    @FXML
    public CheckBox cbShowNewOnly;
    @FXML
    public CheckBox cbShowBookMarkedOnly;
    @FXML
    public CheckBox cbShowOnlyLivestreams;
    @FXML
    public CheckBox cbShowUnseenOnly;
    @FXML
    public CheckBox cbDontShowAbos;
    @FXML
    public CheckBox cbDontShowGebaerdensprache;
    @FXML
    public CheckBox cbDontShowTrailers;
    @FXML
    public CheckBox cbDontShowAudioVersions;
    @FXML
    public SenderBoxNode senderBoxNode;
    @FXML
    public ThemaComboBox themaComboBox;
    @FXML
    public FilmLenghtSliderNode filmLengthSliderNode;
    @FXML
    public ZeitraumSpinner zeitraumSpinner;
    @FXML
    public Button btnDeleteCurrentFilter;
    @FXML
    private Label themaLabel;
    @FXML
    private ComboBox<FilterDTO> filterSelect;
    @FXML
    private Button btnAddNewFilter;
    private boolean deleteCurrentFilterButtonDisabled;

    public CommonViewSettingsPane() {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/mediathek/res/programm/fxml/filter_settings_pane.fxml");
            FXMLLoader fxmlLoader = new FXMLLoader(url);
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException e) {
            logger.error("Failed to load FXML!", (Throwable)e);
        }
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent evt) {
        Platform.runLater(() -> {
            boolean disable = evt.active;
            this.btnDeleteFilterSettings.setDisable(disable);
            this.cbShowOnlyHd.setDisable(disable);
            this.cbShowSubtitlesOnly.setDisable(disable);
            this.cbShowNewOnly.setDisable(disable);
            this.cbShowBookMarkedOnly.setDisable(disable);
            this.cbShowOnlyLivestreams.setDisable(disable);
            this.cbShowUnseenOnly.setDisable(disable);
            this.cbDontShowAbos.setDisable(disable);
            this.cbDontShowGebaerdensprache.setDisable(disable);
            this.cbDontShowTrailers.setDisable(disable);
            this.cbDontShowAudioVersions.setDisable(disable);
            this.senderBoxNode.setDisable(disable);
            this.themaComboBox.setDisable(disable);
            this.filmLengthSliderNode.setDisable(disable);
            this.zeitraumSpinner.setDisable(disable);
            this.filterSelect.setDisable(disable);
            this.btnDeleteCurrentFilter.setDisable(disable || this.deleteCurrentFilterButtonDisabled);
            this.btnAddNewFilter.setDisable(disable);
        });
    }

    public void disableDeleteCurrentFilterButton(boolean disable) {
        this.deleteCurrentFilterButtonDisabled = disable;
        this.btnDeleteCurrentFilter.setDisable(disable);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.themaLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        if (SystemUtils.IS_OS_LINUX) {
            this.themaLabel.setPrefWidth(50.0);
        } else {
            this.themaLabel.setPrefWidth(45.0);
        }
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    public void setFilterSelectionChangeListener(ChangeListener<FilterDTO> changeListener) {
        this.filterSelect.getSelectionModel().selectedItemProperty().addListener(changeListener);
    }

    public FilterDTO getSelectedFilter() {
        return (FilterDTO)this.filterSelect.getValue();
    }

    public void setAvailableFilters(ObservableList<FilterDTO> filters) {
        this.filterSelect.setItems(filters);
    }

    public void selectFilter(FilterDTO filter) {
        SingleSelectionModel selectionModel = this.filterSelect.getSelectionModel();
        if (!filter.equals(selectionModel.getSelectedItem())) {
            selectionModel.select((Object)filter);
        }
    }

    public void setAddNewFilterButtonEventHandler(EventHandler<ActionEvent> eventHandler) {
        this.btnAddNewFilter.setOnAction(eventHandler);
    }

    public void setFilterSelectionStringConverter(StringConverter<FilterDTO> filterStringConverter) {
        this.filterSelect.setConverter(filterStringConverter);
    }
}

