/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MacNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiMac
extends MediathekGui {
    protected static final Logger logger = LogManager.getLogger(MediathekGuiMac.class);
    private final OsxPowerManager powerManager = new OsxPowerManager();

    public MediathekGuiMac() {
        this.setupDockIcon();
    }

    @Override
    protected boolean officialLauncherInUse() {
        boolean macOSBinaryInuse = true;
        String osxOfficialApp = System.getProperty("OSX_OFFICIAL_APP");
        if (osxOfficialApp == null || osxOfficialApp.isEmpty() || osxOfficialApp.equalsIgnoreCase("false")) {
            macOSBinaryInuse = false;
        }
        return macOSBinaryInuse;
    }

    @Override
    protected void installAdditionalHelpEntries() {
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    protected INotificationCenter getNotificationCenter() {
        return new MacNotificationCenter();
    }

    @Override
    protected void shutdownComputer() {
        try {
            Runtime.getRuntime().exec("nohup bin/mv_shutdown_helper");
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(DownloadStartEvent msg) {
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private void setDownloadsBadge(int numDownloads) {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_BADGE_NUMBER)) {
            if (numDownloads > 0) {
                taskbar.setIconBadge(Integer.toString(numDownloads));
            } else {
                taskbar.setIconBadge("");
            }
        }
    }

    private void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        desktop.setQuitHandler((e, response) -> {
            if (!this.beenden(false, false)) {
                response.cancelQuit();
            } else {
                response.performQuit();
            }
        });
        desktop.setAboutHandler(e -> new ShowAboutAction().actionPerformed(null));
        desktop.setPreferencesHandler(e -> this.getSettingsDialog().setVisible(true));
    }

    private void setupDockIcon() {
        try {
            Taskbar taskbar;
            if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
                URL url = this.getClass().getResource("/mediathek/res/MediathekView.png");
                BufferedImage appImage = ImageIO.read(url);
                Taskbar.getTaskbar().setIconImage(appImage);
            }
        }
        catch (IOException ex) {
            logger.error("OS X Application image could not be loaded", (Throwable)ex);
        }
    }
}

