/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.elk.ElkPath;
import net.sourceforge.plantuml.elk.proxy.core.RecursiveGraphLayoutEngine;
import net.sourceforge.plantuml.elk.proxy.core.math.ElkPadding;
import net.sourceforge.plantuml.elk.proxy.core.options.CoreOptions;
import net.sourceforge.plantuml.elk.proxy.core.options.Direction;
import net.sourceforge.plantuml.elk.proxy.core.options.EdgeLabelPlacement;
import net.sourceforge.plantuml.elk.proxy.core.options.HierarchyHandling;
import net.sourceforge.plantuml.elk.proxy.core.options.NodeLabelPlacement;
import net.sourceforge.plantuml.elk.proxy.core.util.NullElkProgressMonitor;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkLabel;
import net.sourceforge.plantuml.elk.proxy.graph.ElkNode;
import net.sourceforge.plantuml.elk.proxy.graph.util.ElkGraphUtil;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class CucaDiagramFileMakerElk
implements CucaDiagramFileMaker {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;
    private final DotStringFactory dotStringFactory;
    private final Map<ILeaf, ElkNode> nodes = new LinkedHashMap<ILeaf, ElkNode>();
    private final Map<IGroup, ElkNode> clusters = new LinkedHashMap<IGroup, ElkNode>();
    private final Map<Link, ElkEdge> edges = new LinkedHashMap<Link, ElkEdge>();

    public CucaDiagramFileMakerElk(CucaDiagram diagram, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.dotStringFactory = new DotStringFactory(stringBounder, diagram);
    }

    private TextBlock getLabel(Link link) {
        if (Display.isNull(link.getLabel())) {
            return null;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = FontConfiguration.create(skinParam, FontParam.ARROW, null);
        TextBlock label = link.getLabel().create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return null;
        }
        return label;
    }

    private TextBlock getQualifier(Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQualifier1() : link.getQualifier2();
        if (tmp == null) {
            return null;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = FontConfiguration.create(skinParam, FontParam.ARROW, null);
        TextBlock label = Display.getWithNewlines(tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return null;
        }
        return label;
    }

    private Point2D getPosition(ElkNode elkNode) {
        ElkNode parent = elkNode.getParent();
        double x = elkNode.getX();
        double y = elkNode.getY();
        if (parent == null || parent.getLabels().size() == 0) {
            return new Point2D.Double(x, y);
        }
        Point2D parentPosition = this.getPosition(parent);
        return new Point2D.Double(parentPosition.getX() + x, parentPosition.getY() + y);
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.diagram.getLeafsvalues()) {
            if (this.diagram.getEntityFactory().getRootGroup() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private ElkNode getElkNode(IEntity entity) {
        ElkNode node = this.nodes.get(entity);
        if (node == null) {
            node = this.clusters.get(entity);
        }
        return node;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            ElkNode root = ElkGraphUtil.createGraph();
            root.setProperty(CoreOptions.DIRECTION, Direction.DOWN);
            root.setProperty(CoreOptions.HIERARCHY_HANDLING, HierarchyHandling.INCLUDE_CHILDREN);
            this.printAllSubgroups(root, this.diagram.getRootGroup());
            this.printEntities(root, this.getUnpackagedEntities());
            this.manageAllEdges();
            new RecursiveGraphLayoutEngine().layout(root, new NullElkProgressMonitor());
            MinMax minMax = TextBlockUtils.getMinMax(new Drawing(null), this.stringBounder, false);
            Drawing drawable = new Drawing(minMax);
            return this.diagram.createImageBuilder(fileFormatOption).drawable(drawable).write(os);
        }
        catch (Throwable e) {
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerElk.getFailureText3(e));
            return ImageDataSimple.error();
        }
    }

    private void printAllSubgroups(ElkNode cluster, IGroup group) {
        for (IGroup g : this.diagram.getChildrenGroups(group)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                ISkinParam skinParam = this.diagram.getSkinParam();
                EntityFactory entityFactory = this.diagram.getEntityFactory();
                ILeaf folder = entityFactory.createLeafForEmptyGroup(g, skinParam);
                System.err.println("STILL IN PROGRESS");
                continue;
            }
            ElkNode elkCluster = ElkGraphUtil.createNode(cluster);
            elkCluster.setProperty(CoreOptions.DIRECTION, Direction.DOWN);
            elkCluster.setProperty(CoreOptions.PADDING, new ElkPadding(40.0, 15.0, 15.0, 15.0));
            ElkLabel label = ElkGraphUtil.createLabel(elkCluster);
            label.setText("C");
            this.clusters.put(g, elkCluster);
            this.printSingleGroup(g);
        }
    }

    private void printSingleGroup(IGroup g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        this.printEntities(this.clusters.get(g), g.getLeafsDirect());
        this.printAllSubgroups(this.clusters.get(g), g);
    }

    private void printEntities(ElkNode parent, Collection<ILeaf> entities) {
        for (ILeaf ent : entities) {
            if (ent.isRemoved()) continue;
            this.manageSingleNode(parent, ent);
        }
    }

    private void manageAllEdges() {
        for (Link link : this.diagram.getLinks()) {
            this.manageSingleEdge(link);
        }
    }

    private void manageSingleNode(ElkNode root, ILeaf leaf) {
        IEntityImage image = this.printEntityInternal(leaf);
        Dimension2D dimension = image.calculateDimension(this.stringBounder);
        ElkNode node = ElkGraphUtil.createNode(root);
        node.setDimensions(dimension.getWidth(), dimension.getHeight());
        ElkLabel label = ElkGraphUtil.createLabel(node);
        label.setText("X");
        double VERY_STRANGE_OFFSET = 10.0;
        label.setDimensions(dimension.getWidth(), dimension.getHeight() - 10.0);
        label.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.V_CENTER));
        this.nodes.put(leaf, node);
    }

    private void manageSingleEdge(Link link) {
        Dimension2D dim;
        ElkLabel edgeLabel;
        ElkNode node1 = this.getElkNode(link.getEntity1());
        ElkNode node2 = this.getElkNode(link.getEntity2());
        ElkEdge edge = ElkGraphUtil.createSimpleEdge(node1, node2);
        TextBlock labelLink = this.getLabel(link);
        if (labelLink != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = labelLink.calculateDimension(this.stringBounder);
            edgeLabel.setText("X");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        if (link.getQualifier1() != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = this.getQualifier(link, 1).calculateDimension(this.stringBounder);
            edgeLabel.setText("1");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edgeLabel.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.TAIL);
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        if (link.getQualifier2() != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = this.getQualifier(link, 2).calculateDimension(this.stringBounder);
            edgeLabel.setText("2");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edgeLabel.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.HEAD);
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        this.edges.put(link, edge);
    }

    private static List<String> getFailureText3(Throwable exception) {
        exception.printStackTrace();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("Sorry, ELK intregration is really alpha feature...");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>http://plantuml.com/qa</b> to solve this issue.");
        strings.add(" ");
        return strings;
    }

    private Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    private IEntityImage printEntityInternal(ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getUmlDiagramType(), this.diagram.getLinks());
        }
        return ent.getSvekImage();
    }

    class Drawing
    extends AbstractTextBlock
    implements TextBlockBackcolored {
        private final MinMax minMax;

        public Drawing(MinMax minMax) {
            this.minMax = minMax;
        }

        @Override
        public void drawU(UGraphic ug) {
            this.drawAllClusters(ug);
            this.drawAllNodes(ug);
            this.drawAllEdges(ug);
        }

        private void drawAllClusters(UGraphic ug) {
            for (Map.Entry ent : CucaDiagramFileMakerElk.this.clusters.entrySet()) {
                this.drawSingleCluster(ug, (IGroup)ent.getKey(), (ElkNode)ent.getValue());
            }
        }

        private void drawAllNodes(UGraphic ug) {
            for (Map.Entry ent : CucaDiagramFileMakerElk.this.nodes.entrySet()) {
                this.drawSingleNode(ug, (ILeaf)ent.getKey(), (ElkNode)ent.getValue());
            }
        }

        private void drawAllEdges(UGraphic ug) {
            for (Map.Entry ent : CucaDiagramFileMakerElk.this.edges.entrySet()) {
                Link link = (Link)ent.getKey();
                if (link.isInvis()) continue;
                this.drawSingleEdge(ug, link, (ElkEdge)ent.getValue());
            }
        }

        private void drawSingleCluster(UGraphic ug, IGroup group, ElkNode elkNode) {
            Point2D corner = CucaDiagramFileMakerElk.this.getPosition(elkNode);
            URectangle rect = new URectangle(elkNode.getWidth(), elkNode.getHeight());
            PackageStyle packageStyle = group.getPackageStyle();
            ISkinParam skinParam = CucaDiagramFileMakerElk.this.diagram.getSkinParam();
            if (packageStyle == null) {
                packageStyle = skinParam.packageStyle();
            }
            UmlDiagramType umlDiagramType = CucaDiagramFileMakerElk.this.diagram.getUmlDiagramType();
            Style style = Cluster.getDefaultStyleDefinition(umlDiagramType.getStyleName(), group.getUSymbol()).getMergedStyle(skinParam.getCurrentStyleBuilder());
            double shadowing = style.value(PName.Shadowing).asDouble();
            UStroke stroke = Cluster.getStrokeInternal(group, skinParam, style);
            HColor backColor = this.getBackColor(umlDiagramType);
            backColor = Cluster.getBackColor(backColor, skinParam, group.getStereotype(), umlDiagramType.getStyleName(), group.getUSymbol());
            double roundCorner = group.getUSymbol() == null ? 0.0 : group.getUSymbol().getSkinParameter().getRoundCorner(skinParam, group.getStereotype());
            TextBlock ztitle = this.getTitleBlock(group);
            TextBlock zstereo = TextBlockUtils.empty(0.0, 0.0);
            ClusterDecoration decoration = new ClusterDecoration(packageStyle, group.getUSymbol(), ztitle, zstereo, 0.0, 0.0, elkNode.getWidth(), elkNode.getHeight(), stroke);
            HColorSimple borderColor = HColorUtils.BLACK;
            decoration.drawU(ug.apply(new UTranslate(corner)), backColor, borderColor, shadowing, roundCorner, skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null), skinParam.getStereotypeAlignment(), 0.0);
        }

        private TextBlock getTitleBlock(IGroup g) {
            Display label = g.getDisplay();
            if (label == null) {
                return TextBlockUtils.empty(0.0, 0.0);
            }
            ISkinParam skinParam = CucaDiagramFileMakerElk.this.diagram.getSkinParam();
            FontConfiguration fontConfiguration = g.getFontConfigurationForTitle(skinParam);
            return label.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
        }

        private HColor getBackColor(UmlDiagramType umlDiagramType) {
            return null;
        }

        private void drawSingleNode(UGraphic ug, ILeaf leaf, ElkNode elkNode) {
            IEntityImage image = CucaDiagramFileMakerElk.this.printEntityInternal(leaf);
            Point2D corner = CucaDiagramFileMakerElk.this.getPosition(elkNode);
            image.drawU(ug.apply(new UTranslate(corner)));
        }

        private void drawSingleEdge(UGraphic ug, Link link, ElkEdge edge) {
            Point2D translate = CucaDiagramFileMakerElk.this.getPosition(edge.getContainingNode());
            ElkPath elkPath = new ElkPath(CucaDiagramFileMakerElk.this.diagram, SName.classDiagram, link, edge, CucaDiagramFileMakerElk.this.getLabel(link), CucaDiagramFileMakerElk.this.getQualifier(link, 1), CucaDiagramFileMakerElk.this.getQualifier(link, 2));
            elkPath.drawU(ug.apply(new UTranslate(translate)));
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            if (this.minMax == null) {
                throw new UnsupportedOperationException();
            }
            return this.minMax.getDimension();
        }

        @Override
        public HColor getBackcolor() {
            return null;
        }
    }
}

