/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.security.SFile;

public class Stdlib {
    private static final Map<String, Stdlib> all = new ConcurrentHashMap<String, Stdlib>();
    private static final String SEPARATOR = "\uf8ff";
    private static final Pattern sizePattern = Pattern.compile("\\[(\\d+)x(\\d+)/16\\]");
    private final Map<String, SoftReference<String>> cache = new ConcurrentHashMap<String, SoftReference<String>>();
    private final String name;
    private final Map<String, String> info = new HashMap<String, String>();

    public static InputStream getResourceAsStream(String fullname) {
        int last = (fullname = fullname.toLowerCase().replace(".puml", "")).indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            Stdlib folder = Stdlib.retrieve(fullname.substring(0, last));
            if (folder == null || folder.info.size() == 0) {
                return null;
            }
            String data = folder.loadRessource(fullname.substring(last + 1));
            if (data == null) {
                return null;
            }
            return new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Stdlib retrieve(String name) throws IOException {
        Stdlib result = all.get(name);
        if (result == null) {
            DataInputStream dataStream = Stdlib.getDataStream(name);
            if (dataStream == null) {
                return null;
            }
            String info = dataStream.readUTF();
            dataStream.close();
            result = new Stdlib(name, info);
            all.put(name, result);
        }
        return result;
    }

    private String loadRessource(String file) throws IOException {
        String cachedResult;
        SoftReference<String> cached = this.cache.get(file.toLowerCase());
        if (cached != null && (cachedResult = cached.get()) != null) {
            return cachedResult;
        }
        Log.info("No cache for " + file);
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return null;
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        if (spriteStream == null) {
            dataStream.close();
            return null;
        }
        try {
            StringBuilder found = null;
            block5: while (true) {
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    Log.info("Not found " + filename);
                    String string = null;
                    return string;
                }
                if (filename.equalsIgnoreCase(file)) {
                    found = new StringBuilder();
                }
                while (true) {
                    String s;
                    if ((s = dataStream.readUTF()).equals(SEPARATOR)) {
                        if (found == null) continue block5;
                        String result = found.toString();
                        this.cache.put(file.toLowerCase(), new SoftReference<String>(result));
                        String string = result;
                        return string;
                    }
                    if (found != null) {
                        found.append(s);
                        found.append("\n");
                    }
                    if (!this.isSpriteLine(s)) continue;
                    Matcher m = sizePattern.matcher(s);
                    boolean ok = m.find();
                    if (!ok) {
                        throw new IOException(s);
                    }
                    int width = Integer.parseInt(m.group(1));
                    int height = Integer.parseInt(m.group(2));
                    if (found == null) {
                        this.skipSprite(width, height, spriteStream);
                        continue;
                    }
                    String sprite = this.readSprite(width, height, spriteStream);
                    found.append(sprite);
                    found.append("}\n");
                }
                break;
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
        }
    }

    private Stdlib(String name, String info) throws IOException {
        this.name = name;
        this.fillMap(info);
    }

    private void skipSprite(int width, int height, InputStream inputStream) throws IOException {
        int nbLines = (height + 1) / 2;
        inputStream.skip(nbLines * width);
    }

    private String readSprite(int width, int height, InputStream inputStream) throws IOException {
        int nbLines = (height + 1) / 2;
        StringBuilder result = new StringBuilder();
        int line = 0;
        for (int j = 0; j < nbLines; ++j) {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                int b = inputStream.read();
                int b1 = (b & 0xF0) >> 4;
                int b2 = b & 0xF;
                sb1.append(this.toHexString(b1));
                sb2.append(this.toHexString(b2));
            }
            result.append(sb1.toString());
            result.append("\n");
            if (++line >= height) continue;
            result.append(sb2.toString());
            result.append("\n");
            ++line;
        }
        return result.toString();
    }

    private String toHexString(int b) {
        return Integer.toHexString(b).toUpperCase();
    }

    private boolean isSpriteLine(String s) {
        return s.trim().startsWith("sprite") && s.trim().endsWith("{");
    }

    private void fillMap(String infoString) {
        for (String s : infoString.split("\n")) {
            if (!s.contains("=")) continue;
            String[] data = s.split("=");
            this.info.put(data[0], data[1]);
        }
    }

    private static DataInputStream getDataStream(String name) throws IOException {
        InputStream raw = Stdlib.getInternalInputStream(name, "-abx.repx");
        if (raw == null) {
            return null;
        }
        return new DataInputStream(new BrotliInputStream(raw));
    }

    private DataInputStream getDataStream() throws IOException {
        return Stdlib.getDataStream(this.name);
    }

    private InputStream getSpriteStream() throws IOException {
        InputStream raw = Stdlib.getInternalInputStream(this.name, "-dex.repx");
        if (raw == null) {
            return null;
        }
        return new BrotliInputStream(raw);
    }

    private static InputStream getInternalInputStream(String fullname, String extension) {
        String res = "/stdlib/" + fullname + extension;
        return Stdlib.class.getResourceAsStream(res);
    }

    public static void extractStdLib() throws IOException {
        for (String name : Stdlib.getAll()) {
            Stdlib folder = Stdlib.retrieve(name);
            folder.extractMeFull();
        }
    }

    private static Collection<String> getAll() throws IOException {
        String name;
        TreeSet<String> result = new TreeSet<String>();
        InputStream home = Stdlib.getInternalInputStream("home", ".repx");
        BufferedReader br = new BufferedReader(new InputStreamReader(home));
        while ((name = br.readLine()) != null) {
            result.add(name);
        }
        return Collections.unmodifiableCollection(result);
    }

    private void extractMeFull() throws IOException {
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return;
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        try {
            while (true) {
                String s;
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    return;
                }
                SFile f = new SFile("stdlib/" + this.name + "/" + filename + ".puml");
                f.getParentFile().mkdirs();
                PrintWriter fos = f.createPrintWriter();
                while (!(s = dataStream.readUTF()).equals(SEPARATOR)) {
                    fos.println(s);
                    if (!this.isSpriteLine(s)) continue;
                    Matcher m = sizePattern.matcher(s);
                    boolean ok = m.find();
                    if (!ok) {
                        throw new IOException(s);
                    }
                    int width = Integer.parseInt(m.group(1));
                    int height = Integer.parseInt(m.group(2));
                    String sprite = this.readSprite(width, height, spriteStream);
                    fos.println(sprite);
                    fos.println("}");
                }
                fos.close();
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
        }
    }

    public List<String> extractAllSprites() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        DataInputStream dataStream = this.getDataStream();
        if (dataStream == null) {
            return Collections.unmodifiableList(result);
        }
        dataStream.readUTF();
        InputStream spriteStream = this.getSpriteStream();
        try {
            block4: while (true) {
                String filename;
                if ((filename = dataStream.readUTF()).equals(SEPARATOR)) {
                    List<String> list = Collections.unmodifiableList(result);
                    return list;
                }
                while (true) {
                    String s;
                    if ((s = dataStream.readUTF()).equals(SEPARATOR)) continue block4;
                    if (!this.isSpriteLine(s)) continue;
                    Matcher m = sizePattern.matcher(s);
                    boolean ok = m.find();
                    if (!ok) {
                        throw new IOException(s);
                    }
                    int width = Integer.parseInt(m.group(1));
                    int height = Integer.parseInt(m.group(2));
                    String sprite = this.readSprite(width, height, spriteStream);
                    if (s.contains("_LARGE")) continue;
                    result.add(s + "\n" + sprite + "}");
                }
                break;
            }
        }
        finally {
            dataStream.close();
            spriteStream.close();
        }
    }

    public static void addInfoVersion(List<String> strings, boolean details) {
        try {
            for (String name : Stdlib.getAll()) {
                Stdlib folder = Stdlib.retrieve(name);
                if (details) {
                    strings.add("<b>" + name);
                    strings.add("Version " + folder.getVersion());
                    strings.add("Delivered by " + folder.getSource());
                    strings.add(" ");
                    continue;
                }
                strings.add("* " + name + " (Version " + folder.getVersion() + ")");
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
            return;
        }
    }

    private String getVersion() {
        return this.info.get("VERSION");
    }

    private String getSource() {
        return this.info.get("SOURCE");
    }

    public static void printStdLib() {
        ArrayList<String> print = new ArrayList<String>();
        Stdlib.addInfoVersion(print, true);
        for (String s : print) {
            System.out.println(s.replace("<b>", ""));
        }
    }
}

