# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BRepTools module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_breptools.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepTools
else:
    import _BRepTools

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepTools.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BRepTools.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepTools.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BRepTools.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BRepTools.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BRepTools.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BRepTools.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BRepTools.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BRepTools.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BRepTools.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepTools.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BRepTools.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BRepTools.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepTools.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BRepTools.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BRepTools.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BRepTools.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepTools:
_BRepTools.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BRepTools.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.BVH
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.Geom2d
import OCC.Core.TopTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_BRepTools_History_Create() -> "opencascade::handle< BRepTools_History >":
    return _BRepTools.Handle_BRepTools_History_Create()

def Handle_BRepTools_History_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_History >":
    return _BRepTools.Handle_BRepTools_History_DownCast(t)

def Handle_BRepTools_History_IsNull(t: "opencascade::handle< BRepTools_History > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_History_IsNull(t)

def Handle_BRepTools_Modification_Create() -> "opencascade::handle< BRepTools_Modification >":
    return _BRepTools.Handle_BRepTools_Modification_Create()

def Handle_BRepTools_Modification_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_Modification >":
    return _BRepTools.Handle_BRepTools_Modification_DownCast(t)

def Handle_BRepTools_Modification_IsNull(t: "opencascade::handle< BRepTools_Modification > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_Modification_IsNull(t)

def Handle_BRepTools_ReShape_Create() -> "opencascade::handle< BRepTools_ReShape >":
    return _BRepTools.Handle_BRepTools_ReShape_Create()

def Handle_BRepTools_ReShape_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_ReShape >":
    return _BRepTools.Handle_BRepTools_ReShape_DownCast(t)

def Handle_BRepTools_ReShape_IsNull(t: "opencascade::handle< BRepTools_ReShape > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_ReShape_IsNull(t)

def Handle_BRepTools_GTrsfModification_Create() -> "opencascade::handle< BRepTools_GTrsfModification >":
    return _BRepTools.Handle_BRepTools_GTrsfModification_Create()

def Handle_BRepTools_GTrsfModification_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_GTrsfModification >":
    return _BRepTools.Handle_BRepTools_GTrsfModification_DownCast(t)

def Handle_BRepTools_GTrsfModification_IsNull(t: "opencascade::handle< BRepTools_GTrsfModification > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_GTrsfModification_IsNull(t)

def Handle_BRepTools_NurbsConvertModification_Create() -> "opencascade::handle< BRepTools_NurbsConvertModification >":
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_Create()

def Handle_BRepTools_NurbsConvertModification_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_NurbsConvertModification >":
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_DownCast(t)

def Handle_BRepTools_NurbsConvertModification_IsNull(t: "opencascade::handle< BRepTools_NurbsConvertModification > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_NurbsConvertModification_IsNull(t)

def Handle_BRepTools_TrsfModification_Create() -> "opencascade::handle< BRepTools_TrsfModification >":
    return _BRepTools.Handle_BRepTools_TrsfModification_Create()

def Handle_BRepTools_TrsfModification_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< BRepTools_TrsfModification >":
    return _BRepTools.Handle_BRepTools_TrsfModification_DownCast(t)

def Handle_BRepTools_TrsfModification_IsNull(t: "opencascade::handle< BRepTools_TrsfModification > const &") -> "bool":
    return _BRepTools.Handle_BRepTools_TrsfModification_IsNull(t)
class BRepTools_MapOfVertexPnt2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_DataMap< TopoDS_Shape,NCollection_Sequence< gp_Pnt2d >,TopTools_ShapeMapHasher >::iterator":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_begin(self)

    def end(self) -> "NCollection_DataMap< TopoDS_Shape,NCollection_Sequence< gp_Pnt2d >,TopTools_ShapeMapHasher >::iterator":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_end(self)

    def cbegin(self) -> "NCollection_DataMap< TopoDS_Shape,NCollection_Sequence< gp_Pnt2d >,TopTools_ShapeMapHasher >::const_iterator":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_cbegin(self)

    def cend(self) -> "NCollection_DataMap< TopoDS_Shape,NCollection_Sequence< gp_Pnt2d >,TopTools_ShapeMapHasher >::const_iterator":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_cend(self)

    def __init__(self, *args):
        _BRepTools.BRepTools_MapOfVertexPnt2d_swiginit(self, _BRepTools.new_BRepTools_MapOfVertexPnt2d(*args))

    def Exchange(self, theOther: "BRepTools_MapOfVertexPnt2d") -> "void":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Exchange(self, theOther)

    def Assign(self, theOther: "BRepTools_MapOfVertexPnt2d") -> "NCollection_DataMap< TopoDS_Shape,TColgp_SequenceOfPnt2d,TopTools_ShapeMapHasher > &":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Assign(self, theOther)

    def Set(self, theOther: "BRepTools_MapOfVertexPnt2d") -> "NCollection_DataMap< TopoDS_Shape,TColgp_SequenceOfPnt2d,TopTools_ShapeMapHasher > &":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ReSize(self, N)

    def Bind(self, theKey: "TopoDS_Shape", theItem: "TColgp_SequenceOfPnt2d") -> "Standard_Boolean":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Bind(self, theKey, theItem)

    def Bound(self, theKey: "TopoDS_Shape", theItem: "TColgp_SequenceOfPnt2d") -> "NCollection_Sequence< gp_Pnt2d > *":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Bound(self, theKey, theItem)

    def IsBound(self, theKey: "TopoDS_Shape") -> "Standard_Boolean":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_IsBound(self, theKey)

    def UnBind(self, theKey: "TopoDS_Shape") -> "Standard_Boolean":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_UnBind(self, theKey)

    def Seek(self, theKey: "TopoDS_Shape") -> "NCollection_Sequence< gp_Pnt2d > const *":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Seek(self, theKey)

    def Find(self, *args) -> "Standard_Boolean":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Find(self, *args)

    def ChangeSeek(self, theKey: "TopoDS_Shape") -> "NCollection_Sequence< gp_Pnt2d > *":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey: "TopoDS_Shape") -> "NCollection_Sequence< gp_Pnt2d > &":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_ChangeFind(self, theKey)

    def __call__(self, *args) -> "NCollection_Sequence< gp_Pnt2d > &":
        return _BRepTools.BRepTools_MapOfVertexPnt2d___call__(self, *args)

    def Clear(self, *args) -> "void":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Clear(self, *args)
    __swig_destroy__ = _BRepTools.delete_BRepTools_MapOfVertexPnt2d

    def Size(self) -> "Standard_Integer":
        return _BRepTools.BRepTools_MapOfVertexPnt2d_Size(self)

# Register BRepTools_MapOfVertexPnt2d in _BRepTools:
_BRepTools.BRepTools_MapOfVertexPnt2d_swigregister(BRepTools_MapOfVertexPnt2d)

class breptools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AddUVBounds(*args) -> "void":
        r"""
        Adds to the box <b> the bounding values in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        B: Bnd_Box2d

        Returns
        -------
        None
        Adds to the box <b> the bounding values of the wire in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire
        B: Bnd_Box2d

        Returns
        -------
        None
        Adds to the box <b> the bounding values of the edge in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge
        B: Bnd_Box2d

        Returns
        -------
        None

        """
        return _BRepTools.breptools_AddUVBounds(*args)

    @staticmethod
    def Clean(*args) -> "void":
        r"""
        Removes all cashed polygonal representation of the shape, i.e. the triangulations of the faces of <s> and polygons on triangulations and polygons 3d of the edges. in case polygonal representation is the only available representation for the shape (shape does not have geometry) it is not removed.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.breptools_Clean(*args)

    @staticmethod
    def CleanGeometry(*args) -> "void":
        r"""
        Removes geometry (curves and surfaces) from all edges and faces of the shape.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.breptools_CleanGeometry(*args)

    @staticmethod
    def Compare(*args) -> "Standard_Boolean":
        r"""
        Returns true if the distance between the two vertices is lower than their tolerance.

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        bool
        Returns true if the distance between the two edges is lower than their tolerance.

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge

        Returns
        -------
        bool

        """
        return _BRepTools.breptools_Compare(*args)

    @staticmethod
    def DetectClosedness(*args) -> "Standard_Boolean &, Standard_Boolean &":
        r"""
        Detect closedness of face in u and v directions.

        Parameters
        ----------
        theFace: TopoDS_Face

        Returns
        -------
        theUclosed: bool
        theVclosed: bool

        """
        return _BRepTools.breptools_DetectClosedness(*args)

    @staticmethod
    def EvalAndUpdateTol(*args) -> "Standard_Real":
        r"""
        Evals real tolerance of edge <thee>. <thec3d>, <thec2d>, <thes>, <thef>, <thel> are correspondently 3d curve of edge, 2d curve on surface <thes> and rang of edge if calculated tolerance is more then current edge tolerance, edge is updated. method returns actual tolerance of edge.

        Parameters
        ----------
        theE: TopoDS_Edge
        theC3d: Geom_Curve
        theC2d: Geom2d_Curve
        theS: Geom_Surface
        theF: float
        theL: float

        Returns
        -------
        float

        """
        return _BRepTools.breptools_EvalAndUpdateTol(*args)

    @staticmethod
    def IsReallyClosed(*args) -> "Standard_Boolean":
        r"""
        Verifies that the edge <e> is found two times on the face <f> before calling brep_tool::isclosed.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face

        Returns
        -------
        bool

        """
        return _BRepTools.breptools_IsReallyClosed(*args)

    @staticmethod
    def Map3DEdges(*args) -> "void":
        r"""
        Stores in the map <m> all the 3d topology edges of <s>.

        Parameters
        ----------
        S: TopoDS_Shape
        M: TopTools_IndexedMapOfShape

        Returns
        -------
        None

        """
        return _BRepTools.breptools_Map3DEdges(*args)

    @staticmethod
    def OriEdgeInFace(*args) -> "TopAbs_Orientation":
        r"""
        Returns the cumul of the orientation of <edge> and thc containing wire in <face>.

        Parameters
        ----------
        theEdge: TopoDS_Edge
        theFace: TopoDS_Face

        Returns
        -------
        TopAbs_Orientation

        """
        return _BRepTools.breptools_OriEdgeInFace(*args)

    @staticmethod
    def OuterWire(*args) -> "TopoDS_Wire":
        r"""
        Returns the outer most wire of <f>. returns a null wire if <f> has no wires.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        TopoDS_Wire

        """
        return _BRepTools.breptools_OuterWire(*args)

    @staticmethod
    def Read(*args) -> "Standard_Boolean":
        r"""
        Reads a shape from <file>, returns it in <sh>. <b> is used to build the shape.

        Parameters
        ----------
        Sh: TopoDS_Shape
        File: char *
        B: BRep_Builder
        theProgress: Message_ProgressRange,optional
        	default value is Message_ProgressRange()

        Returns
        -------
        bool

        """
        return _BRepTools.breptools_Read(*args)

    @staticmethod
    def RemoveInternals(*args) -> "void":
        r"""
        Removes internal sub-shapes from the shape. the check on internal status is based on orientation of sub-shapes, classification is not performed. before removal of internal sub-shapes the algorithm checks if such removal is not going to break topological connectivity between sub-shapes. the flag <theforce> if set to true disables the connectivity check and clears the given shape from all sub-shapes with internal orientation.

        Parameters
        ----------
        theS: TopoDS_Shape
        theForce: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _BRepTools.breptools_RemoveInternals(*args)

    @staticmethod
    def RemoveUnusedPCurves(*args) -> "void":
        r"""
        Removes all the pcurves of the edges of <s> that refer to surfaces not belonging to any face of <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.breptools_RemoveUnusedPCurves(*args)

    @staticmethod
    def Triangulation(*args) -> "Standard_Boolean":
        r"""
        Verifies that each face from the shape has got a triangulation with a deflection smaller or equal to specified one and the edges a discretization on this triangulation. @param theshape [in] shape to verify @param thelindefl [in] maximum allowed linear deflection @param thetocheckfreeedges [in] if true, then free edges are required to have 3d polygon returns false if input shape contains faces without triangulation, or that triangulation has worse (greater) deflection than specified one, or edges in shape lack polygons on triangulation or free edges in shape lack 3d polygons.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theLinDefl: float
        theToCheckFreeEdges: bool,optional
        	default value is Standard_False

        Returns
        -------
        bool

        """
        return _BRepTools.breptools_Triangulation(*args)

    @staticmethod
    def UVBounds(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &, Standard_Real &":
        r"""
        Returns in umin, umax, vmin, vmax the bounding values in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Returns in umin, umax, vmin, vmax the bounding values of the wire in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        W: TopoDS_Wire

        Returns
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float
        Returns in umin, umax, vmin, vmax the bounding values of the edge in the parametric space of f.

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge

        Returns
        -------
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        """
        return _BRepTools.breptools_UVBounds(*args)

    @staticmethod
    def Update(*args) -> "void":
        r"""
        Update a vertex (nothing is done).

        Parameters
        ----------
        V: TopoDS_Vertex

        Returns
        -------
        None
        Update an edge, compute 2d bounding boxes.

        Parameters
        ----------
        E: TopoDS_Edge

        Returns
        -------
        None
        Update a wire (nothing is done).

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None
        Update a face, update uv points.

        Parameters
        ----------
        F: TopoDS_Face

        Returns
        -------
        None
        Update a shell (nothing is done).

        Parameters
        ----------
        S: TopoDS_Shell

        Returns
        -------
        None
        Update a solid (nothing is done).

        Parameters
        ----------
        S: TopoDS_Solid

        Returns
        -------
        None
        Update a composite solid (nothing is done).

        Parameters
        ----------
        C: TopoDS_CompSolid

        Returns
        -------
        None
        Update a compound (nothing is done).

        Parameters
        ----------
        C: TopoDS_Compound

        Returns
        -------
        None
        Update a shape, call the corect update.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.breptools_Update(*args)

    @staticmethod
    def UpdateFaceUVPoints(*args) -> "void":
        r"""
        For each edge of the face <f> reset the uv points to the bounding points of the parametric curve of the edge on the face.

        Parameters
        ----------
        theF: TopoDS_Face

        Returns
        -------
        None

        """
        return _BRepTools.breptools_UpdateFaceUVPoints(*args)

    @staticmethod
    def Write(*args) -> "Standard_Boolean":
        r"""
        Writes <sh> in <file>.

        Parameters
        ----------
        Sh: TopoDS_Shape
        File: char *
        theProgress: Message_ProgressRange,optional
        	default value is Message_ProgressRange()

        Returns
        -------
        bool

        """
        return _BRepTools.breptools_Write(*args)

    @staticmethod
    def WriteToString(shape: "TopoDS_Shape", full_precision: "bool"=True) -> "std::string":
        r"""Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding.Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding."""
        return _BRepTools.breptools_WriteToString(shape, full_precision)

    @staticmethod
    def ReadFromString(src: "std::string const &") -> "TopoDS_Shape":
        r"""Deserializes TopoDS_Shape from string"""
        return _BRepTools.breptools_ReadFromString(src)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepTools.breptools_swiginit(self, _BRepTools.new_breptools())
    __swig_destroy__ = _BRepTools.delete_breptools

# Register breptools in _BRepTools:
_BRepTools.breptools_swigregister(breptools)

def breptools_AddUVBounds(*args) -> "void":
    r"""
    Adds to the box <b> the bounding values in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face
    B: Bnd_Box2d

    Returns
    -------
    None
    Adds to the box <b> the bounding values of the wire in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face
    W: TopoDS_Wire
    B: Bnd_Box2d

    Returns
    -------
    None
    Adds to the box <b> the bounding values of the edge in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face
    E: TopoDS_Edge
    B: Bnd_Box2d

    Returns
    -------
    None

    """
    return _BRepTools.breptools_AddUVBounds(*args)

def breptools_Clean(*args) -> "void":
    r"""
    Removes all cashed polygonal representation of the shape, i.e. the triangulations of the faces of <s> and polygons on triangulations and polygons 3d of the edges. in case polygonal representation is the only available representation for the shape (shape does not have geometry) it is not removed.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepTools.breptools_Clean(*args)

def breptools_CleanGeometry(*args) -> "void":
    r"""
    Removes geometry (curves and surfaces) from all edges and faces of the shape.

    Parameters
    ----------
    theShape: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepTools.breptools_CleanGeometry(*args)

def breptools_Compare(*args) -> "Standard_Boolean":
    r"""
    Returns true if the distance between the two vertices is lower than their tolerance.

    Parameters
    ----------
    V1: TopoDS_Vertex
    V2: TopoDS_Vertex

    Returns
    -------
    bool
    Returns true if the distance between the two edges is lower than their tolerance.

    Parameters
    ----------
    E1: TopoDS_Edge
    E2: TopoDS_Edge

    Returns
    -------
    bool

    """
    return _BRepTools.breptools_Compare(*args)

def breptools_DetectClosedness(*args) -> "Standard_Boolean &, Standard_Boolean &":
    r"""
    Detect closedness of face in u and v directions.

    Parameters
    ----------
    theFace: TopoDS_Face

    Returns
    -------
    theUclosed: bool
    theVclosed: bool

    """
    return _BRepTools.breptools_DetectClosedness(*args)

def breptools_EvalAndUpdateTol(*args) -> "Standard_Real":
    r"""
    Evals real tolerance of edge <thee>. <thec3d>, <thec2d>, <thes>, <thef>, <thel> are correspondently 3d curve of edge, 2d curve on surface <thes> and rang of edge if calculated tolerance is more then current edge tolerance, edge is updated. method returns actual tolerance of edge.

    Parameters
    ----------
    theE: TopoDS_Edge
    theC3d: Geom_Curve
    theC2d: Geom2d_Curve
    theS: Geom_Surface
    theF: float
    theL: float

    Returns
    -------
    float

    """
    return _BRepTools.breptools_EvalAndUpdateTol(*args)

def breptools_IsReallyClosed(*args) -> "Standard_Boolean":
    r"""
    Verifies that the edge <e> is found two times on the face <f> before calling brep_tool::isclosed.

    Parameters
    ----------
    E: TopoDS_Edge
    F: TopoDS_Face

    Returns
    -------
    bool

    """
    return _BRepTools.breptools_IsReallyClosed(*args)

def breptools_Map3DEdges(*args) -> "void":
    r"""
    Stores in the map <m> all the 3d topology edges of <s>.

    Parameters
    ----------
    S: TopoDS_Shape
    M: TopTools_IndexedMapOfShape

    Returns
    -------
    None

    """
    return _BRepTools.breptools_Map3DEdges(*args)

def breptools_OriEdgeInFace(*args) -> "TopAbs_Orientation":
    r"""
    Returns the cumul of the orientation of <edge> and thc containing wire in <face>.

    Parameters
    ----------
    theEdge: TopoDS_Edge
    theFace: TopoDS_Face

    Returns
    -------
    TopAbs_Orientation

    """
    return _BRepTools.breptools_OriEdgeInFace(*args)

def breptools_OuterWire(*args) -> "TopoDS_Wire":
    r"""
    Returns the outer most wire of <f>. returns a null wire if <f> has no wires.

    Parameters
    ----------
    F: TopoDS_Face

    Returns
    -------
    TopoDS_Wire

    """
    return _BRepTools.breptools_OuterWire(*args)

def breptools_Read(*args) -> "Standard_Boolean":
    r"""
    Reads a shape from <file>, returns it in <sh>. <b> is used to build the shape.

    Parameters
    ----------
    Sh: TopoDS_Shape
    File: char *
    B: BRep_Builder
    theProgress: Message_ProgressRange,optional
    	default value is Message_ProgressRange()

    Returns
    -------
    bool

    """
    return _BRepTools.breptools_Read(*args)

def breptools_RemoveInternals(*args) -> "void":
    r"""
    Removes internal sub-shapes from the shape. the check on internal status is based on orientation of sub-shapes, classification is not performed. before removal of internal sub-shapes the algorithm checks if such removal is not going to break topological connectivity between sub-shapes. the flag <theforce> if set to true disables the connectivity check and clears the given shape from all sub-shapes with internal orientation.

    Parameters
    ----------
    theS: TopoDS_Shape
    theForce: bool,optional
    	default value is Standard_False

    Returns
    -------
    None

    """
    return _BRepTools.breptools_RemoveInternals(*args)

def breptools_RemoveUnusedPCurves(*args) -> "void":
    r"""
    Removes all the pcurves of the edges of <s> that refer to surfaces not belonging to any face of <s>.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepTools.breptools_RemoveUnusedPCurves(*args)

def breptools_Triangulation(*args) -> "Standard_Boolean":
    r"""
    Verifies that each face from the shape has got a triangulation with a deflection smaller or equal to specified one and the edges a discretization on this triangulation. @param theshape [in] shape to verify @param thelindefl [in] maximum allowed linear deflection @param thetocheckfreeedges [in] if true, then free edges are required to have 3d polygon returns false if input shape contains faces without triangulation, or that triangulation has worse (greater) deflection than specified one, or edges in shape lack polygons on triangulation or free edges in shape lack 3d polygons.

    Parameters
    ----------
    theShape: TopoDS_Shape
    theLinDefl: float
    theToCheckFreeEdges: bool,optional
    	default value is Standard_False

    Returns
    -------
    bool

    """
    return _BRepTools.breptools_Triangulation(*args)

def breptools_UVBounds(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &, Standard_Real &":
    r"""
    Returns in umin, umax, vmin, vmax the bounding values in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face

    Returns
    -------
    UMin: float
    UMax: float
    VMin: float
    VMax: float
    Returns in umin, umax, vmin, vmax the bounding values of the wire in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face
    W: TopoDS_Wire

    Returns
    -------
    UMin: float
    UMax: float
    VMin: float
    VMax: float
    Returns in umin, umax, vmin, vmax the bounding values of the edge in the parametric space of f.

    Parameters
    ----------
    F: TopoDS_Face
    E: TopoDS_Edge

    Returns
    -------
    UMin: float
    UMax: float
    VMin: float
    VMax: float

    """
    return _BRepTools.breptools_UVBounds(*args)

def breptools_Update(*args) -> "void":
    r"""
    Update a vertex (nothing is done).

    Parameters
    ----------
    V: TopoDS_Vertex

    Returns
    -------
    None
    Update an edge, compute 2d bounding boxes.

    Parameters
    ----------
    E: TopoDS_Edge

    Returns
    -------
    None
    Update a wire (nothing is done).

    Parameters
    ----------
    W: TopoDS_Wire

    Returns
    -------
    None
    Update a face, update uv points.

    Parameters
    ----------
    F: TopoDS_Face

    Returns
    -------
    None
    Update a shell (nothing is done).

    Parameters
    ----------
    S: TopoDS_Shell

    Returns
    -------
    None
    Update a solid (nothing is done).

    Parameters
    ----------
    S: TopoDS_Solid

    Returns
    -------
    None
    Update a composite solid (nothing is done).

    Parameters
    ----------
    C: TopoDS_CompSolid

    Returns
    -------
    None
    Update a compound (nothing is done).

    Parameters
    ----------
    C: TopoDS_Compound

    Returns
    -------
    None
    Update a shape, call the corect update.

    Parameters
    ----------
    S: TopoDS_Shape

    Returns
    -------
    None

    """
    return _BRepTools.breptools_Update(*args)

def breptools_UpdateFaceUVPoints(*args) -> "void":
    r"""
    For each edge of the face <f> reset the uv points to the bounding points of the parametric curve of the edge on the face.

    Parameters
    ----------
    theF: TopoDS_Face

    Returns
    -------
    None

    """
    return _BRepTools.breptools_UpdateFaceUVPoints(*args)

def breptools_Write(*args) -> "Standard_Boolean":
    r"""
    Writes <sh> in <file>.

    Parameters
    ----------
    Sh: TopoDS_Shape
    File: char *
    theProgress: Message_ProgressRange,optional
    	default value is Message_ProgressRange()

    Returns
    -------
    bool

    """
    return _BRepTools.breptools_Write(*args)

def breptools_WriteToString(shape: "TopoDS_Shape", full_precision: "bool"=True) -> "std::string":
    r"""Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding.Serializes TopoDS_Shape to string. If full_precision is False, the default precision of std::stringstream is used which regularly causes rounding."""
    return _BRepTools.breptools_WriteToString(shape, full_precision)

def breptools_ReadFromString(src: "std::string const &") -> "TopoDS_Shape":
    r"""Deserializes TopoDS_Shape from string"""
    return _BRepTools.breptools_ReadFromString(src)

class BRepTools_History(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    TRelationType_Removed = _BRepTools.BRepTools_History_TRelationType_Removed
    TRelationType_Generated = _BRepTools.BRepTools_History_TRelationType_Generated
    TRelationType_Modified = _BRepTools.BRepTools_History_TRelationType_Modified


    class TRelationType(IntEnum):
    	TRelationType_Removed = 0
    	TRelationType_Generated = 1
    	TRelationType_Modified = 2
    TRelationType_Removed = TRelationType.TRelationType_Removed
    TRelationType_Generated = TRelationType.TRelationType_Generated
    TRelationType_Modified = TRelationType.TRelationType_Modified


    def AddGenerated(self, *args) -> "void":
        r"""
        Set the second shape as generated one from the first shape.

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theGenerated: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_AddGenerated(self, *args)

    def AddModified(self, *args) -> "void":
        r"""
        Set the second shape as modified one from the first shape.

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theModified: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_AddModified(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the history.

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_Clear(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(BRepTools_History self) -> std::string"""
        return _BRepTools.BRepTools_History_DumpToString(self)

    def Generated(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        No available documentation.

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepTools.BRepTools_History_Generated(self, *args)

    def HasGenerated(self, *args) -> "Standard_Boolean":
        r"""
        Returns 'true' if there any shapes with generated elements present.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_History_HasGenerated(self, *args)

    def HasModified(self, *args) -> "Standard_Boolean":
        r"""
        Returns 'true' if there any modified shapes present.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_History_HasModified(self, *args)

    def HasRemoved(self, *args) -> "Standard_Boolean":
        r"""
        Returns 'true' if there any removed shapes present.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_History_HasRemoved(self, *args)

    def IsRemoved(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_History_IsRemoved(self, *args)

    @staticmethod
    def IsSupportedType(*args) -> "Standard_Boolean":
        r"""
        Returns 'true' if the type of the shape is supported by the history.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_History_IsSupportedType(*args)

    def Modified(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        No available documentation.

        Parameters
        ----------
        theInitial: TopoDS_Shape

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepTools.BRepTools_History_Modified(self, *args)

    def Remove(self, *args) -> "void":
        r"""
        Set the shape as removed one.

        Parameters
        ----------
        theRemoved: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_Remove(self, *args)

    def ReplaceGenerated(self, *args) -> "void":
        r"""
        Set the second shape as the only generated one from the first one.

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theGenerated: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_ReplaceGenerated(self, *args)

    def ReplaceModified(self, *args) -> "void":
        r"""
        Set the second shape as the only modified one from the first one.

        Parameters
        ----------
        theInitial: TopoDS_Shape
        theModified: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_History_ReplaceModified(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_History_DownCast(t)


    __repr__ = _dumps_object

    @methodnotwrapped
    def BRepTools_History(self):
    	pass

    @methodnotwrapped
    def Merge(self):
    	pass


    def __init__(self):
        r"""__init__(BRepTools_History self) -> BRepTools_History"""
        _BRepTools.BRepTools_History_swiginit(self, _BRepTools.new_BRepTools_History())
    __swig_destroy__ = _BRepTools.delete_BRepTools_History

# Register BRepTools_History in _BRepTools:
_BRepTools.BRepTools_History_swigregister(BRepTools_History)

def BRepTools_History_IsSupportedType(*args) -> "Standard_Boolean":
    r"""
    Returns 'true' if the type of the shape is supported by the history.

    Parameters
    ----------
    theShape: TopoDS_Shape

    Returns
    -------
    bool

    """
    return _BRepTools.BRepTools_History_IsSupportedType(*args)

class BRepTools_Modification(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Continuity(self, *args) -> "GeomAbs_Shape":
        r"""
        Returns the continuity of <newe> between <newf1> and <newf2>. <newe> is the new edge created from <e>. <newf1> (resp. <newf2>) is the new face created from <f1> (resp. <f2>).

        Parameters
        ----------
        E: TopoDS_Edge
        F1: TopoDS_Face
        F2: TopoDS_Face
        NewE: TopoDS_Edge
        NewF1: TopoDS_Face
        NewF2: TopoDS_Face

        Returns
        -------
        GeomAbs_Shape

        """
        return _BRepTools.BRepTools_Modification_Continuity(self, *args)

    def NewCurve(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the edge, e, has been modified. if the edge has been modified: - c is the new geometry associated with the edge, - l is its new location, and - tol is the new tolerance. if the edge has not been modified, this function returns false, and the values of c, l and tol are not significant.

        Parameters
        ----------
        E: TopoDS_Edge
        C: Geom_Curve
        L: TopLoc_Location

        Returns
        -------
        Tol: float

        """
        return _BRepTools.BRepTools_Modification_NewCurve(self, *args)

    def NewCurve2d(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the edge, e, has a new curve on surface on the face, f. if a new curve exists: - c is the new geometry of the edge, - l is the new location, and - tol is the new tolerance. newe is the new edge created from e, and newf is the new face created from f. if there is no new curve on the face, this function returns false, and the values of c, l and tol are not significant.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face
        NewE: TopoDS_Edge
        NewF: TopoDS_Face
        C: Geom2d_Curve

        Returns
        -------
        Tol: float

        """
        return _BRepTools.BRepTools_Modification_NewCurve2d(self, *args)

    def NewParameter(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the vertex v has a new parameter on the edge e. if a new parameter exists: - p is the parameter, and - tol is the new tolerance. if there is no new parameter this function returns false, and the values of p and tol are not significant.

        Parameters
        ----------
        V: TopoDS_Vertex
        E: TopoDS_Edge

        Returns
        -------
        P: float
        Tol: float

        """
        return _BRepTools.BRepTools_Modification_NewParameter(self, *args)

    def NewPoint(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the vertex v has been modified. if v has been modified: - p is the new geometry of the vertex, and - tol is the new tolerance. if the vertex has not been modified this function returns false, and the values of p and tol are not significant.

        Parameters
        ----------
        V: TopoDS_Vertex
        P: gp_Pnt

        Returns
        -------
        Tol: float

        """
        return _BRepTools.BRepTools_Modification_NewPoint(self, *args)

    def NewPolygon(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the edge has been modified according to changed polygon. if the edge has been modified: - p is a new polygon.

        Parameters
        ----------
        E: TopoDS_Edge
        P: Poly_Polygon3D

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Modification_NewPolygon(self, *args)

    def NewPolygonOnTriangulation(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the edge has been modified according to changed polygon on triangulation. if the edge has been modified: - p is a new polygon on triangulation.

        Parameters
        ----------
        E: TopoDS_Edge
        F: TopoDS_Face
        P: Poly_PolygonOnTriangulation

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Modification_NewPolygonOnTriangulation(self, *args)

    def NewSurface(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the face, f, has been modified. if the face has been modified: - s is the new geometry of the face, - l is its new location, and - tol is the new tolerance. the flag, revwires, is set to true when the modification reverses the normal of the surface, (i.e. the wires have to be reversed). the flag, revface, is set to true if the orientation of the modified face changes in the shells which contain it. if the face has not been modified this function returns false, and the values of s, l, tol, revwires and revface are not significant.

        Parameters
        ----------
        F: TopoDS_Face
        S: Geom_Surface
        L: TopLoc_Location

        Returns
        -------
        Tol: float
        RevWires: bool
        RevFace: bool

        """
        return _BRepTools.BRepTools_Modification_NewSurface(self, *args)

    def NewTriangulation(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the face has been modified according to changed triangulation. if the face has been modified: - t is a new triangulation on the face.

        Parameters
        ----------
        F: TopoDS_Face
        T: Poly_Triangulation

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Modification_NewTriangulation(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_Modification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Modification

# Register BRepTools_Modification in _BRepTools:
_BRepTools.BRepTools_Modification_swigregister(BRepTools_Modification)

class BRepTools_Modifier(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty modifier.

        Parameters
        ----------
        theMutableInput: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Creates a modifier on the shape <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None
        Creates a modifier on the shape <s>, and performs the modifications described by <m>.

        Parameters
        ----------
        S: TopoDS_Shape
        M: BRepTools_Modification

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_Modifier_swiginit(self, _BRepTools.new_BRepTools_Modifier(*args))

    def Init(self, *args) -> "void":
        r"""
        Initializes the modifier with the shape <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Modifier_Init(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns standard_true if the modification has been computed successfully.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Modifier_IsDone(self, *args)

    def IsMutableInput(self, *args) -> "Standard_Boolean":
        r"""
        Returns the current mutable input state.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Modifier_IsMutableInput(self, *args)

    def ModifiedShape(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns the modified shape corresponding to <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepTools.BRepTools_Modifier_ModifiedShape(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs the modifications described by <m>.

        Parameters
        ----------
        M: BRepTools_Modification
        theProgress: Message_ProgressRange,optional
        	default value is Message_ProgressRange()

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Modifier_Perform(self, *args)

    def SetMutableInput(self, *args) -> "void":
        r"""
        Sets the mutable input state if true then the input (original) shape can be modified during modification process.

        Parameters
        ----------
        theMutableInput: bool

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Modifier_SetMutableInput(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Modifier

# Register BRepTools_Modifier in _BRepTools:
_BRepTools.BRepTools_Modifier_swigregister(BRepTools_Modifier)

class BRepTools_Quilt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_Quilt_swiginit(self, _BRepTools.new_BRepTools_Quilt(*args))

    def Add(self, *args) -> "void":
        r"""
        Add the faces of <s> to the quilt, the faces containing bounded edges are copied.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Quilt_Add(self, *args)

    def Bind(self, *args) -> "void":
        r"""
        Binds <enew> to be the new edge instead of <eold>. //! the faces of the added shape containing <eold> will be copied to substitute <eold> by <enew>. //! the vertices of <eold> will be bound to the vertices of <enew> with the same orientation. //! if <eold> and <enew> have different orientations the curves are considered to be opposite and the pcurves of <eold> will be copied and reversed in the new faces. //! <eold> must belong to the next added shape, <enew> must belong to a shape added before.

        Parameters
        ----------
        Eold: TopoDS_Edge
        Enew: TopoDS_Edge

        Returns
        -------
        None
        Binds <vnew> to be a new vertex instead of <vold>. //! the faces of the added shape containing <vold> will be copied to substitute <vold> by <vnew>.

        Parameters
        ----------
        Vold: TopoDS_Vertex
        Vnew: TopoDS_Vertex

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Quilt_Bind(self, *args)

    def Copy(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns the shape substitued to <s> in the quilt.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepTools.BRepTools_Quilt_Copy(self, *args)

    def IsCopied(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <s> has been copied (<s> is a vertex, an edge or a face).

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Quilt_IsCopied(self, *args)

    def Shells(self, *args) -> "TopoDS_Shape":
        r"""
        Returns a compound of shells made from the current set of faces. the shells will be flagged as closed or not closed.

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepTools.BRepTools_Quilt_Shells(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Quilt

# Register BRepTools_Quilt in _BRepTools:
_BRepTools.BRepTools_Quilt_swigregister(BRepTools_Quilt)

class BRepTools_ReShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty reshape.

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_ReShape_swiginit(self, _BRepTools.new_BRepTools_ReShape(*args))

    def Apply(self, *args) -> "TopoDS_Shape":
        r"""
        Applies the substitutions requests to a shape. //! <until> gives the level of type until which requests are taken into account. for subshapes of the type <until> no rebuild and futher exploring are done. //! note: each subshape can be replaced by shape of the same type or by shape containing only shapes of that type (for example, topods_edge can be replaced by topods_edge, topods_wire or topods_compound containing topods_edges). if incompatible shape type is encountered, it is ignored and flag fail1 is set in status.

        Parameters
        ----------
        shape: TopoDS_Shape
        until: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepTools.BRepTools_ReShape_Apply(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears all substitutions requests.

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_ReShape_Clear(self, *args)

    def CopyVertex(self, *args) -> "TopoDS_Vertex":
        r"""
        Returns modified copy of vertex if original one is not recorded or returns modified original vertex otherwise.

        Parameters
        ----------
        theV: TopoDS_Vertex
        theTol: float,optional
        	default value is -1.0

        Returns
        -------
        TopoDS_Vertex
        Returns modified copy of vertex if original one is not recorded or returns modified original vertex otherwise.

        Parameters
        ----------
        theV: TopoDS_Vertex
        theNewPos: gp_Pnt
        aTol: float

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepTools.BRepTools_ReShape_CopyVertex(self, *args)

    def History(self, *args) -> "opencascade::handle< BRepTools_History >":
        r"""
        Returns the history of the substituted shapes.

        Returns
        -------
        opencascade::handle<BRepTools_History>

        """
        return _BRepTools.BRepTools_ReShape_History(self, *args)

    def IsNewShape(self, *args) -> "Standard_Boolean":
        r"""
        Checks if shape has been recorded by reshaper as a value.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_ReShape_IsNewShape(self, *args)

    def IsRecorded(self, *args) -> "Standard_Boolean":
        r"""
        Tells if a shape is recorded for replace/remove.

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_ReShape_IsRecorded(self, *args)

    def ModeConsiderLocation(self, *args) -> "Standard_Boolean &":
        r"""
        Returns (modifiable) the flag which defines whether location of shape take into account during replacing shapes.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_ReShape_ModeConsiderLocation(self, *args)

    def Remove(self, *args) -> "void":
        r"""
        Sets a request to remove a shape whatever the orientation.

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_ReShape_Remove(self, *args)

    def Replace(self, *args) -> "void":
        r"""
        Sets a request to replace a shape by a new one.

        Parameters
        ----------
        shape: TopoDS_Shape
        newshape: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_ReShape_Replace(self, *args)

    def Status(self, *args) -> "Standard_Integer":
        r"""
        Returns a complete substitution status for a shape 0 : not recorded, <newsh> = original <shape> < 0: to be removed, <newsh> is null > 0: to be replaced, <newsh> is a new item if <last> is false, returns status and new shape recorded in the map directly for the shape, if true and status > 0 then recursively searches for the last status and new shape.

        Parameters
        ----------
        shape: TopoDS_Shape
        newsh: TopoDS_Shape
        last: bool,optional
        	default value is Standard_False

        Returns
        -------
        int

        """
        return _BRepTools.BRepTools_ReShape_Status(self, *args)

    def Value(self, *args) -> "TopoDS_Shape":
        r"""
        Returns the new value for an individual shape if not recorded, returns the original shape itself if to be removed, returns a null shape else, returns the replacing item.

        Parameters
        ----------
        shape: TopoDS_Shape

        Returns
        -------
        TopoDS_Shape

        """
        return _BRepTools.BRepTools_ReShape_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_ReShape_DownCast(t)


    __repr__ = _dumps_object

    @methodnotwrapped
    def Merge(self):
    	pass

    __swig_destroy__ = _BRepTools.delete_BRepTools_ReShape

# Register BRepTools_ReShape in _BRepTools:
_BRepTools.BRepTools_ReShape_swigregister(BRepTools_ReShape)

class BRepTools_ShapeSet(OCC.Core.TopTools.TopTools_ShapeSet):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Builds an empty shapeset. parameter <iswithtriangles> is added for xml persistence.

        Parameters
        ----------
        isWithTriangles: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Builds an empty shapeset. parameter <iswithtriangles> is added for xml persistence.

        Parameters
        ----------
        B: BRep_Builder
        isWithTriangles: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_ShapeSet_swiginit(self, _BRepTools.new_BRepTools_ShapeSet(*args))

    def DumpGeometryToString(self) -> "std::string":
        r"""DumpGeometryToString(BRepTools_ShapeSet self) -> std::string"""
        return _BRepTools.BRepTools_ShapeSet_DumpGeometryToString(self)

    def DumpPolygon3DToString(self) -> "std::string":
        r"""DumpPolygon3DToString(BRepTools_ShapeSet self) -> std::string"""
        return _BRepTools.BRepTools_ShapeSet_DumpPolygon3DToString(self)

    def DumpPolygonOnTriangulationToString(self) -> "std::string":
        r"""DumpPolygonOnTriangulationToString(BRepTools_ShapeSet self) -> std::string"""
        return _BRepTools.BRepTools_ShapeSet_DumpPolygonOnTriangulationToString(self)

    def DumpTriangulationToString(self) -> "std::string":
        r"""DumpTriangulationToString(BRepTools_ShapeSet self) -> std::string"""
        return _BRepTools.BRepTools_ShapeSet_DumpTriangulationToString(self)

    def ReadGeometryFromString(self, src: "std::string") -> "void":
        r"""ReadGeometryFromString(BRepTools_ShapeSet self, std::string src)"""
        return _BRepTools.BRepTools_ShapeSet_ReadGeometryFromString(self, src)

    def ReadPolygon3DFromString(self, src: "std::string") -> "void":
        r"""ReadPolygon3DFromString(BRepTools_ShapeSet self, std::string src)"""
        return _BRepTools.BRepTools_ShapeSet_ReadPolygon3DFromString(self, src)

    def ReadPolygonOnTriangulationFromString(self, src: "std::string") -> "void":
        r"""ReadPolygonOnTriangulationFromString(BRepTools_ShapeSet self, std::string src)"""
        return _BRepTools.BRepTools_ShapeSet_ReadPolygonOnTriangulationFromString(self, src)

    def ReadTriangulationFromString(self, src: "std::string") -> "void":
        r"""ReadTriangulationFromString(BRepTools_ShapeSet self, std::string src)"""
        return _BRepTools.BRepTools_ShapeSet_ReadTriangulationFromString(self, src)

    def WriteGeometryToString(self) -> "std::string":
        r"""WriteGeometryToString(BRepTools_ShapeSet self) -> std::string"""
        return _BRepTools.BRepTools_ShapeSet_WriteGeometryToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_ShapeSet

# Register BRepTools_ShapeSet in _BRepTools:
_BRepTools.BRepTools_ShapeSet_swigregister(BRepTools_ShapeSet)

class BRepTools_Substitution(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_Substitution_swiginit(self, _BRepTools.new_BRepTools_Substitution(*args))

    def Build(self, *args) -> "void":
        r"""
        Build newshape from <s> if its subshapes has modified. //! the methods <iscopied> and <copy> allows you to keep the resul of <build>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Substitution_Build(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Reset all the fields.

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Substitution_Clear(self, *args)

    def Copy(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        Returns the set of shapes substitued to <s> .

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepTools.BRepTools_Substitution_Copy(self, *args)

    def IsCopied(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <s> has been replaced .

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_Substitution_IsCopied(self, *args)

    def Substitute(self, *args) -> "void":
        r"""
        <oldshape> will be replaced by <newshapes>. //! <newshapes> can be empty , in this case <oldshape> will disparate from its ancestors. //! if an item of <newshapes> is oriented forward. it will be oriented as <oldshape> in its ancestors. else it will be reversed.

        Parameters
        ----------
        OldShape: TopoDS_Shape
        NewShapes: TopTools_ListOfShape

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_Substitution_Substitute(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_Substitution

# Register BRepTools_Substitution in _BRepTools:
_BRepTools.BRepTools_Substitution_swigregister(BRepTools_Substitution)

class BRepTools_WireExplorer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty explorer (which can be initialized using init).

        Returns
        -------
        None
        Iinitializes an exploration of the wire <w>.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_WireExplorer_swiginit(self, _BRepTools.new_BRepTools_WireExplorer(*args))

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the explorer.

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_WireExplorer_Clear(self, *args)

    def Current(self, *args) -> "TopoDS_Edge const":
        r"""
        Returns the current edge.

        Returns
        -------
        TopoDS_Edge

        """
        return _BRepTools.BRepTools_WireExplorer_Current(self, *args)

    def CurrentVertex(self, *args) -> "TopoDS_Vertex const":
        r"""
        Returns the vertex connecting the current edge to the previous one.

        Returns
        -------
        TopoDS_Vertex

        """
        return _BRepTools.BRepTools_WireExplorer_CurrentVertex(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes an exploration of the wire <w>.

        Parameters
        ----------
        W: TopoDS_Wire

        Returns
        -------
        None
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face

        Returns
        -------
        None
        Initializes an exploration of the wire <w>. f is used to select the edge connected to the previous in the parametric representation of <f>. <umin>, <umax>, <vmin>, <vmax> - the uv bounds of the face <f>.

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face
        UMin: float
        UMax: float
        VMin: float
        VMax: float

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_WireExplorer_Init(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there is a current edge.

        Returns
        -------
        bool

        """
        return _BRepTools.BRepTools_WireExplorer_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Proceeds to the next edge.

        Returns
        -------
        None

        """
        return _BRepTools.BRepTools_WireExplorer_Next(self, *args)

    def Orientation(self, *args) -> "TopAbs_Orientation":
        r"""
        Returns an orientation for the current edge.

        Returns
        -------
        TopAbs_Orientation

        """
        return _BRepTools.BRepTools_WireExplorer_Orientation(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_WireExplorer

# Register BRepTools_WireExplorer in _BRepTools:
_BRepTools.BRepTools_WireExplorer_swigregister(BRepTools_WireExplorer)

class BRepTools_GTrsfModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_GTrsf

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_GTrsfModification_swiginit(self, _BRepTools.new_BRepTools_GTrsfModification(*args))

    def GTrsf(self, *args) -> "gp_GTrsf":
        r"""
        Gives an access on the gtrsf.

        Returns
        -------
        gp_GTrsf

        """
        return _BRepTools.BRepTools_GTrsfModification_GTrsf(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_GTrsfModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_GTrsfModification

# Register BRepTools_GTrsfModification in _BRepTools:
_BRepTools.BRepTools_GTrsfModification_swigregister(BRepTools_GTrsfModification)

class BRepTools_NurbsConvertModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_NurbsConvertModification_swiginit(self, _BRepTools.new_BRepTools_NurbsConvertModification(*args))

    def GetUpdatedEdges(self, *args) -> "TopTools_ListOfShape const &":
        r"""
        No available documentation.

        Returns
        -------
        TopTools_ListOfShape

        """
        return _BRepTools.BRepTools_NurbsConvertModification_GetUpdatedEdges(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_NurbsConvertModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_NurbsConvertModification

# Register BRepTools_NurbsConvertModification in _BRepTools:
_BRepTools.BRepTools_NurbsConvertModification_swigregister(BRepTools_NurbsConvertModification)

class BRepTools_TrsfModification(BRepTools_Modification):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        _BRepTools.BRepTools_TrsfModification_swiginit(self, _BRepTools.new_BRepTools_TrsfModification(*args))

    def Trsf(self, *args) -> "gp_Trsf":
        r"""
        Provides access to the gp_trsf associated with this modification. the transformation can be changed.

        Returns
        -------
        gp_Trsf

        """
        return _BRepTools.BRepTools_TrsfModification_Trsf(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepTools_TrsfModification_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepTools.delete_BRepTools_TrsfModification

# Register BRepTools_TrsfModification in _BRepTools:
_BRepTools.BRepTools_TrsfModification_swigregister(BRepTools_TrsfModification)





