/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueArray;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionArrayAggregate
extends Expression {
    SortAndSlice sort;
    SortAndSlice distinctSort;
    String separator = ",";
    ArrayType arrayDataType;
    Type exprType;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionArrayAggregate(int n, boolean bl, Expression expression, SortAndSlice sortAndSlice, String string) {
        super(n);
        this.isDistinctAggregate = bl;
        this.sort = sortAndSlice;
        if (string != null) {
            this.separator = string;
        }
        if (n == 88) {
            this.nodes = new Expression[]{expression};
            return;
        }
        if (sortAndSlice == null) {
            this.nodes = new Expression[]{expression};
        } else {
            HsqlArrayList hsqlArrayList = sortAndSlice.getExpressionList();
            this.nodes = new Expression[hsqlArrayList.size() + 1];
            hsqlArrayList.toArray(this.nodes);
            this.nodes[hsqlArrayList.size()] = expression;
            sortAndSlice.prepareExtraColumn(1);
        }
        if (this.isDistinctAggregate) {
            this.distinctSort = new SortAndSlice();
            this.distinctSort.prepareSingleColumn(this.nodes.length - 1);
        }
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionArrayAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 85: {
                stringBuilder.append(' ').append("ARRAY_AGG").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 86: {
                stringBuilder.append(' ').append("GROUP_CONCAT").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 88: {
                stringBuilder.append(' ').append("MEDIAN").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 85: {
                stringBuilder.append("ARRAY_AGG").append(' ');
                break;
            }
            case 86: {
                stringBuilder.append("GROUP_CONCAT").append(' ');
                break;
            }
            case 88: {
                stringBuilder.append("MEDIAN").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg=[");
            stringBuilder.append(this.nodes[0].describe(session, n + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        HsqlList hsqlList2 = this.condition.resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, null, false);
        if (hsqlList2 != null) {
            ExpressionColumn.checkColumnsResolved(hsqlList2);
        }
        if (hsqlList == null) {
            hsqlList = new ArrayListIdentity();
        }
        hsqlList.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroupArray;
            this.rangeGroup = rangeGroup;
        }
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        this.nodeDataTypes = new Type[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
            if (this.nodes[i].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            if (this.nodes[i].dataType == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[i] = this.nodes[i].dataType;
        }
        this.exprType = this.nodes[this.nodes.length - 1].dataType;
        if (this.exprType.isLobType()) {
            throw Error.error(5534);
        }
        if (this.exprType.isArrayType()) {
            throw Error.error(5534);
        }
        RowType rowType = new RowType(this.nodeDataTypes);
        switch (this.opType) {
            case 85: {
                this.arrayDataType = new ArrayType(rowType, 1024);
                this.dataType = new ArrayType(this.exprType, 1024);
                break;
            }
            case 86: {
                this.arrayDataType = new ArrayType(rowType, 1024);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 88: {
                this.arrayDataType = new ArrayType(this.nodeDataTypes[0], 1024);
                this.dataType = ExpressionAggregate.getType(session, 88, this.exprType);
                if (this.exprType.isNumberType()) break;
                throw Error.error(5563);
            }
        }
        this.condition.resolveTypes(session, null);
    }

    @Override
    boolean equals(Expression expression) {
        if (expression instanceof ExpressionArrayAggregate) {
            ExpressionArrayAggregate expressionArrayAggregate = (ExpressionArrayAggregate)expression;
            return super.equals(expression) && this.opType == expression.opType && this.exprSubType == expression.exprSubType && this.isDistinctAggregate == expressionArrayAggregate.isDistinctAggregate && this.separator.equals(expressionArrayAggregate.separator) && this.condition.equals(expressionArrayAggregate.condition);
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        if (!this.condition.testCondition(session)) {
            return setFunction;
        }
        Object[] objectArray = null;
        switch (this.opType) {
            case 85: {
                Object[] objectArray2 = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray2[i] = this.nodes[i].getValue(session);
                }
                objectArray = objectArray2;
                break;
            }
            case 86: {
                Object[] objectArray3 = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    objectArray3[i] = this.nodes[i].getValue(session);
                }
                if (objectArray3[objectArray3.length - 1] == null) {
                    return setFunction;
                }
                objectArray = objectArray3;
                break;
            }
            case 88: {
                objectArray = this.nodes[0].getValue(session);
                if (objectArray != null) break;
                return setFunction;
            }
        }
        if (setFunction == null) {
            setFunction = new SetFunctionValueArray();
        }
        setFunction.add(objectArray);
        return setFunction;
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        if (setFunction == null) {
            return null;
        }
        Object[] objectArray = (Object[])setFunction.getValue();
        if (this.isDistinctAggregate) {
            this.arrayDataType.sort(session, objectArray, this.distinctSort);
            int n = this.arrayDataType.deDuplicate(session, objectArray, this.distinctSort);
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, n);
        }
        if (this.sort != null) {
            this.arrayDataType.sort(session, objectArray, this.sort);
        }
        switch (this.opType) {
            case 85: {
                Object[] objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray3 = (Object[])objectArray[i];
                    objectArray2[i] = objectArray3[objectArray3.length - 1];
                }
                return objectArray2;
            }
            case 86: {
                StringBuilder stringBuilder = new StringBuilder(16 * objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(this.separator);
                    }
                    Object[] objectArray4 = (Object[])objectArray[i];
                    Object object = objectArray4[objectArray4.length - 1];
                    String string = (String)Type.SQL_VARCHAR.convertToType(session, object, this.exprType);
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case 88: {
                boolean bl;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                this.arrayDataType.sort(session, objectArray, sortAndSlice);
                boolean bl2 = bl = objectArray.length % 2 == 0;
                if (bl) {
                    Object object = objectArray[objectArray.length / 2 - 1];
                    Object object2 = objectArray[objectArray.length / 2];
                    Object object3 = this.dataType.add(session, object, object2, this.dataType);
                    return this.dataType.divide(session, object3, 2);
                }
                return this.dataType.convertToType(session, objectArray[objectArray.length / 2], this.exprType);
            }
        }
        return null;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && !this.condition.isTrue();
    }

    @Override
    public void setCondition(ExpressionLogical expressionLogical) {
        this.condition = expressionLogical;
    }

    @Override
    public Expression duplicate() {
        ExpressionArrayAggregate expressionArrayAggregate = (ExpressionArrayAggregate)super.duplicate();
        if (this.condition != null) {
            expressionArrayAggregate.condition = this.condition.duplicate();
        }
        return expressionArrayAggregate;
    }
}

