/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractTableReference;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.TableConstraintType;

final class MutableForeignKey
extends AbstractTableReference
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private final StringBuilder definition = new StringBuilder();
    private ForeignKeyDeferrability deferrability;
    private ForeignKeyUpdateRule deleteRule;
    private ForeignKeyUpdateRule updateRule = ForeignKeyUpdateRule.unknown;

    MutableForeignKey(String name) {
        super(name);
        this.deleteRule = ForeignKeyUpdateRule.unknown;
        this.deferrability = ForeignKeyDeferrability.unknown;
    }

    @Override
    public ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public TableConstraintType getType() {
        return TableConstraintType.foreign_key;
    }

    @Override
    public ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isDeferrable() {
        return this.isInitiallyDeferred();
    }

    @Override
    public boolean isInitiallyDeferred() {
        if (this.deferrability == null) {
            throw new NotLoadedException(this);
        }
        return this.deferrability == ForeignKeyDeferrability.initiallyDeferred;
    }

    void addColumnReference(int keySequence, Column pkColumn, Column fkColumn) {
        ImmutableColumnReference fkColumnReference = new ImmutableColumnReference(keySequence, fkColumn, pkColumn);
        this.addColumnReference(fkColumnReference);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }
}

