/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.sql.Datum;

class PlsqlIbtBinder
extends Binder {
    Binder thePlsqlIbtCopyingBinder = OraclePreparedStatementReadOnly.theStaticPlsqlIbtCopyingBinder;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    PlsqlIbtBinder() {
        PlsqlIbtBinder.init(this);
    }

    static void init(Binder x2) {
        x2.type = (short)998;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        PlsqlIbtBindInfo bindInfo = stmt.parameterPlsqlIbt[rank][bindPosition];
        if (clearPriorBindValues) {
            stmt.parameterPlsqlIbt[rank][bindPosition] = null;
        }
        int offset = bindInfo.ibtValueIndex;
        switch (bindInfo.element_internal_type) {
            case 9: {
                for (int i2 = 0; i2 < bindInfo.curLen; ++i2) {
                    int len = 0;
                    String s2 = (String)bindInfo.arrayData[i2];
                    if (s2 != null) {
                        len = s2.length();
                        if (len > bindInfo.elemMaxLen - 1) {
                            len = bindInfo.elemMaxLen - 1;
                        }
                        s2.getChars(0, len, stmt.ibtBindChars, offset + 1);
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = 0;
                        stmt.ibtBindChars[offset] = (char)(len <<= 1);
                        stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i2] = (short)(len == 0 ? 3 : (short)(len + 2));
                    } else {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i2] = -1;
                        Arrays.fill(stmt.ibtBindChars, offset, offset + bindInfo.elemMaxLen, '\u0000');
                    }
                    offset += bindInfo.elemMaxLen;
                }
                break;
            }
            case 6: 
            case 12: 
            case 180: {
                for (int i3 = 0; i3 < bindInfo.curLen; ++i3) {
                    byte[] bytes = null;
                    if (bindInfo.arrayData[i3] != null) {
                        bytes = ((Datum)bindInfo.arrayData[i3]).getBytes();
                    }
                    if (bytes == null) {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = -1;
                        stmt.ibtBindBytes[offset] = -1;
                    } else {
                        stmt.ibtBindIndicators[bindInfo.ibtIndicatorIndex + i3] = 0;
                        stmt.ibtBindIndicators[bindInfo.ibtLengthIndex + i3] = (short)(bytes.length + 1);
                        stmt.ibtBindBytes[offset] = (byte)bytes.length;
                        System.arraycopy(bytes, 0, stmt.ibtBindBytes, offset + 1, bytes.length);
                    }
                    offset += bindInfo.elemMaxLen;
                    if (!stmt.connection.checksumMode.needToCalculateBindChecksum()) continue;
                    localCheckSum = bytes == null ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, bytes, 0, bytes.length);
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        return localCheckSum;
    }

    @Override
    Binder copyingBinder() {
        return this.thePlsqlIbtCopyingBinder;
    }

    static {
        try {
            $$$methodRef$$$3 = PlsqlIbtBinder.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PlsqlIbtBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PlsqlIbtBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PlsqlIbtBinder.class.getDeclaredMethod("init", Binder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

