SELECT /*+ PARALLEL(AUTO) */
  NULL AS FUNCTION_CAT,
  FUNCTIONS.OWNER AS FUNCTION_SCHEM,
  FUNCTIONS.OBJECT_NAME AS FUNCTION_NAME,
  FUNCTIONS.OBJECT_NAME AS SPECIFIC_NAME,
  CASE WHEN ARGUMENTS.OBJECT_ID IS NULL
    THEN 0
    ELSE 1
  END AS FUNCTION_TYPE,  
  NULL AS REMARKS
FROM
  ${catalogscope}_PROCEDURES FUNCTIONS
  LEFT OUTER JOIN ${catalogscope}_ARGUMENTS ARGUMENTS
    ON FUNCTIONS.OBJECT_ID = ARGUMENTS.OBJECT_ID
      AND ARGUMENTS.ARGUMENT_NAME IS NULL
      AND ARGUMENTS.POSITION = 0 
WHERE
  FUNCTIONS.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(FUNCTIONS.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(FUNCTIONS.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(FUNCTIONS.OWNER, '${schemas}')
  AND FUNCTIONS.OBJECT_TYPE = 'FUNCTION'
ORDER BY
  FUNCTION_SCHEM,
  FUNCTION_NAME
