SELECT /*+ PARALLEL(AUTO) */
  NULL AS PROCEDURE_CAT,
  PROCEDURES.OWNER AS PROCEDURE_SCHEM,
  PROCEDURES.OBJECT_NAME AS PROCEDURE_NAME,
  PROCEDURES.OBJECT_NAME AS SPECIFIC_NAME,
  CASE WHEN ARGUMENTS.OBJECT_ID IS NULL
    THEN 1
    ELSE 2
  END AS PROCEDURE_TYPE,  
  NULL AS REMARKS
FROM
  ${catalogscope}_PROCEDURES PROCEDURES
  LEFT OUTER JOIN ${catalogscope}_ARGUMENTS ARGUMENTS
    ON PROCEDURES.OBJECT_ID = ARGUMENTS.OBJECT_ID
      AND ARGUMENTS.ARGUMENT_NAME IS NULL
      AND ARGUMENTS.POSITION = 0 
WHERE
  PROCEDURES.OWNER NOT IN 
    ('ANONYMOUS', 'APEX_PUBLIC_USER', 'APPQOSSYS', 'BI', 'CTXSYS', 'DBSNMP', 'DIP', 
    'EXFSYS', 'FLOWS_30000', 'FLOWS_FILES', 'GSMADMIN_INTERNAL', 'IX', 'LBACSYS', 
    'MDDATA', 'MDSYS', 'MGMT_VIEW', 'OE', 'OLAPSYS', 'ORACLE_OCM', 
    'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'OWBSYS', 'PM', 'SCOTT', 'SH', 
    'SI_INFORMTN_SCHEMA', 'SPATIAL_CSW_ADMIN_USR', 'SPATIAL_WFS_ADMIN_USR', 
    'SYS', 'SYSMAN', 'SYSTEM', 'TSMSYS', 'WKPROXY', 'WKSYS', 'WK_TEST', 
    'WMSYS', 'XDB', 'XS$NULL', 'RDSADMIN')  
  AND NOT REGEXP_LIKE(PROCEDURES.OWNER, '^APEX_[0-9]{6}$')
  AND NOT REGEXP_LIKE(PROCEDURES.OWNER, '^FLOWS_[0-9]{5,6}$')
  AND REGEXP_LIKE(PROCEDURES.OWNER, '${schemas}')
  AND PROCEDURES.OBJECT_TYPE = 'PROCEDURE'
ORDER BY
  PROCEDURE_SCHEM,
  PROCEDURE_NAME
