/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.io.IOException;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.tomcat.util.log.CaptureLog;

public class SystemLogHandler
extends PrintStream {
    private final PrintStream out;
    private static final ThreadLocal<Stack<CaptureLog>> logs = new ThreadLocal();
    private static final Stack<CaptureLog> reuse = new Stack();

    public SystemLogHandler(PrintStream printStream) {
        super(printStream);
        this.out = printStream;
    }

    public static void startCapture() {
        Stack<CaptureLog> stack;
        CaptureLog captureLog = null;
        if (!reuse.isEmpty()) {
            try {
                captureLog = reuse.pop();
            }
            catch (EmptyStackException emptyStackException) {
                captureLog = new CaptureLog();
            }
        } else {
            captureLog = new CaptureLog();
        }
        if ((stack = logs.get()) == null) {
            stack = new Stack();
            logs.set(stack);
        }
        stack.push(captureLog);
    }

    public static String stopCapture() {
        Stack<CaptureLog> stack = logs.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CaptureLog captureLog = stack.pop();
        if (captureLog == null) {
            return null;
        }
        String string = captureLog.getCapture();
        captureLog.reset();
        reuse.push(captureLog);
        return string;
    }

    protected PrintStream findStream() {
        PrintStream printStream;
        CaptureLog captureLog;
        Stack<CaptureLog> stack = logs.get();
        if (stack != null && !stack.isEmpty() && (captureLog = stack.peek()) != null && (printStream = captureLog.getStream()) != null) {
            return printStream;
        }
        return this.out;
    }

    @Override
    public void flush() {
        this.findStream().flush();
    }

    @Override
    public void close() {
        this.findStream().close();
    }

    @Override
    public boolean checkError() {
        return this.findStream().checkError();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int n) {
        this.findStream().write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.findStream().write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.findStream().write(byArray, n, n2);
    }

    @Override
    public void print(boolean bl) {
        this.findStream().print(bl);
    }

    @Override
    public void print(char c) {
        this.findStream().print(c);
    }

    @Override
    public void print(int n) {
        this.findStream().print(n);
    }

    @Override
    public void print(long l) {
        this.findStream().print(l);
    }

    @Override
    public void print(float f) {
        this.findStream().print(f);
    }

    @Override
    public void print(double d) {
        this.findStream().print(d);
    }

    @Override
    public void print(char[] cArray) {
        this.findStream().print(cArray);
    }

    @Override
    public void print(String string) {
        this.findStream().print(string);
    }

    @Override
    public void print(Object object) {
        this.findStream().print(object);
    }

    @Override
    public void println() {
        this.findStream().println();
    }

    @Override
    public void println(boolean bl) {
        this.findStream().println(bl);
    }

    @Override
    public void println(char c) {
        this.findStream().println(c);
    }

    @Override
    public void println(int n) {
        this.findStream().println(n);
    }

    @Override
    public void println(long l) {
        this.findStream().println(l);
    }

    @Override
    public void println(float f) {
        this.findStream().println(f);
    }

    @Override
    public void println(double d) {
        this.findStream().println(d);
    }

    @Override
    public void println(char[] cArray) {
        this.findStream().println(cArray);
    }

    @Override
    public void println(String string) {
        this.findStream().println(string);
    }

    @Override
    public void println(Object object) {
        this.findStream().println(object);
    }
}

